/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.pageset.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.dataplatform.DataSetConfigFactory;
import com.kingdee.shr.dataplatform.DataSetConfigInfo;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.IDataSetConfig;
import com.kingdee.shr.dataplatform.IPageConfig;
import com.kingdee.shr.dataplatform.PageConfigException;
import com.kingdee.shr.dataplatform.PageConfigFacadeFactory;
import com.kingdee.shr.dataplatform.PageConfigFactory;
import com.kingdee.shr.dataplatform.PageConfigInfo;
import com.kingdee.shr.dataplatform.variable.VariableServiceFactory;
import com.kingdee.shr.dataset.model.BizObjectItem;
import com.kingdee.shr.dataset.model.DesignDataSetCommon;
import com.kingdee.shr.dataset.model.DesignDataSetSql;
import com.kingdee.shr.dataset.model.ParamsItem;
import com.kingdee.shr.dataset.model.SelectorItem;
import com.kingdee.shr.dataset.util.DataSetUtils;
import com.kingdee.shr.pageset.model.Page;
import com.kingdee.shr.pageset.model.SelectorItemUMode;
import com.kingdee.shr.pageset.model.SelectorObjItem;
import com.kingdee.shr.pageset.service.IPageService;
import com.kingdee.shr.pageset.util.PageSetUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class PageConfigService
implements IPageService {
    private static final String PAGE_BOSTYPE = "B2C7B2B0";

    @Override
    public IObjectPK doSave(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        String pageJson = JSONUtils.convertObjectToJson((Context)ctx, (Object)param.get("page"));
        Boolean isProductionMode = (Boolean)param.get("isProductionMode");
        Page page = (Page)JSONUtils.convertJsonToObject((Context)ctx, (String)pageJson, Page.class);
        page.setProductionMode(isProductionMode);
        IPageConfig iPageConfig = PageConfigFactory.getLocalInstance(ctx);
        CoreBaseInfo pageConfigInfo = page.toPageInfo(ctx);
        pageConfigInfo.put("isProductionMode", (Object)isProductionMode);
        return iPageConfig.save(pageConfigInfo);
    }

    @Override
    public Page init(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        String pageId = (String)param.get("pageId");
        String solutionId = (String)param.get("solutionId");
        String uipk = (String)param.get("uipk");
        boolean isUserState = false;
        if (null != param.get("isUserState") && (isUserState = ((Boolean)param.get("isUserState")).booleanValue()) && "shr.workplatform.homepage".equals(uipk)) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"isUserState  and  uipk is not match!"});
        }
        Boolean isProductionMode = (Boolean)param.get("isProductionMode");
        if (StringUtils.isEmpty((CharSequence)pageId)) {
            return this.createNewPage(isProductionMode);
        }
        return this.initPage(ctx, pageId, solutionId, uipk, isProductionMode, isUserState);
    }

    @Override
    public List<Map<String, String>> getVariableData(Context ctx, Map<String, Object> params) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> typeValue = new HashSet<Integer>();
        typeValue.add(10);
        typeValue.add(50);
        typeValue.add(40);
        typeValue.add(60);
        filter.getFilterItems().add(new FilterItemInfo("type", typeValue, CompareType.INCLUDE));
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("domain.name"));
        sorter.add(new SorterItemInfo("type"));
        SorterItemInfo sorterItem = new SorterItemInfo("number");
        sorterItem.setSortType(SortType.DESCEND);
        sorter.add(sorterItem);
        viewInfo.setFilter(filter);
        viewInfo.setSorter(sorter);
        return VariableServiceFactory.getVariableListData(ctx, viewInfo);
    }

    @Override
    public Map<String, Object> getDataSetInfo(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        IDataSetConfig iDataSetConfig;
        HashMap<String, Object> data = new HashMap<String, Object>();
        String dataSetID = (String)param.get("dataSetId");
        if (!PageSetUtils.isVaild(dataSetID, (ICoreBase)(iDataSetConfig = DataSetConfigFactory.getLocalInstance(ctx)))) {
            throw new PageConfigException(PageConfigException.PARAMS_EXCEPTION, new Object[]{"dataSetId is valid !"});
        }
        DataSetConfigInfo info = iDataSetConfig.getDataSetConfigInfo((IObjectPK)new ObjectUuidPK(dataSetID));
        Boolean isProductionMode = (Boolean)param.get("isProductionMode");
        info.put("isProductionMode", isProductionMode);
        DesignDataSetCommon designDataSetCommon = DataSetUtils.getDataSetModel(ctx, info);
        List<Map<String, String>> i18n = designDataSetCommon.getI18n();
        BizObjectItem bizObjItem = designDataSetCommon.getBizObject();
        boolean isCustomSQL = false;
        if (designDataSetCommon instanceof DesignDataSetSql && null != bizObjItem && bizObjItem.isSql() && null != bizObjItem.getCustomSQL() && bizObjItem.getCustomSQL().isUseSourceSQLQuery()) {
            isCustomSQL = true;
        }
        Map<String, Map<String, String>> i18ns = this.getI18n(i18n);
        SelectorObjItem selectorObjItem = new SelectorObjItem();
        selectorObjItem.setDimension(this.getSelectorItemUModes(ctx, isCustomSQL, info.getSetType().getValue(), i18ns, designDataSetCommon.getSelector().getDimension()));
        selectorObjItem.setMeasure(this.getSelectorItemUModes(ctx, isCustomSQL, info.getSetType().getValue(), i18ns, designDataSetCommon.getSelector().getMeasure()));
        this.setParmMul(designDataSetCommon.getParams(), i18ns);
        data.put("seletors", selectorObjItem);
        data.put("params", designDataSetCommon.getParams());
        return data;
    }

    @Override
    public String resetConfig(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        String pageId = (String)param.get("pageId");
        if (!StringUtils.isEmpty((CharSequence)pageId)) {
            return PageConfigFacadeFactory.getLocalInstance(ctx).resetConfig(pageId);
        }
        return null;
    }

    private void setParmMul(List<ParamsItem> params, Map<String, Map<String, String>> i18ns) {
        for (ParamsItem param : params) {
            param.setAliasObject(i18ns.get(param.getAlias()));
        }
    }

    private List<SelectorItemUMode> getSelectorItemUModes(Context ctx, boolean isCustomSQL, int setType, Map<String, Map<String, String>> i18n, List<SelectorItem> selectorItems) {
        Map<String, String> tables = this.getTableIds(ctx, selectorItems);
        ArrayList<SelectorItemUMode> selectorItemUModes = new ArrayList<SelectorItemUMode>();
        for (Map.Entry<String, String> value : tables.entrySet()) {
            SelectorItemUMode selectU = new SelectorItemUMode();
            ArrayList<Map<String, Object>> children = new ArrayList<Map<String, Object>>();
            selectU.setSelectTable(false);
            selectU.setValue(value.getKey());
            selectU.setAlias(value.getValue());
            for (SelectorItem selector : selectorItems) {
                if (!StringUtils.isEmpty((CharSequence)value.getKey()) && !value.getKey().equals(selector.getTableId()) || selector.isHide()) continue;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("alias", i18n.get(selector.getAlias()));
                if (isCustomSQL || 40 == setType) {
                    map.put("value", StringUtils.isEmpty((CharSequence)selector.getName()) ? selector.getPhysicsName() : selector.getName());
                } else {
                    map.put("value", MessageFormat.format("{0}.{1}", selector.getTableId(), StringUtils.isEmpty((CharSequence)selector.getName()) ? selector.getPhysicsName() : selector.getName()));
                }
                map.put("dataType", StringUtils.isEmpty((CharSequence)selector.getDataType()) ? "" : selector.getDataType());
                map.put("source", StringUtils.isEmpty((CharSequence)selector.getSource()) ? "" : selector.getSource());
                map.put("isMeasureField", selector.isMeasureField());
                children.add(map);
                selectU.setChildren(children);
            }
            selectorItemUModes.add(selectU);
        }
        return selectorItemUModes;
    }

    private Map<String, Map<String, String>> getI18n(List<Map<String, String>> i18n) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (int i = 0; i < i18n.size(); ++i) {
            Map<String, String> mapI18n = i18n.get(i);
            map.put(mapI18n.get("key"), mapI18n);
        }
        return map;
    }

    private Map<String, String> getTableIds(Context ctx, List<SelectorItem> selectorItems) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (SelectorItem selector : selectorItems) {
            if (selector.isHide()) continue;
            map.put(selector.getTableId(), selector.getTableName().get(ctx.getLocale().toString()));
        }
        return map;
    }

    private Page initPage(Context ctx, String pageId, String solutionId, String uipk, Boolean isProductionMode, boolean isUserState) throws BOSException, EASBizException {
        Page page = new Page();
        page.setProductionMode(isProductionMode);
        page.setUserState(isUserState);
        return page.toPage(ctx, pageId, solutionId, uipk);
    }

    private Page createNewPage(Boolean isProductionMode) {
        Page page = new Page();
        page.setProductionMode(isProductionMode);
        page.setPreSet(true);
        page.setId(BOSUuid.create((String)PAGE_BOSTYPE).toString());
        page.setPageName(PageSetUtils.initMutiLanField((IObjectValue)new PageConfigInfo()));
        page.setSchema("");
        page.setUipk("");
        page.setUserState(false);
        page.setPermission(true);
        if (Boolean.TRUE.equals(isProductionMode)) {
            page.setPreSet(false);
        }
        return page;
    }

    @Override
    public Object execute(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        return null;
    }
}

