/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.econtractservice.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.HRBillBaseEntryCollection;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.IHRBillBaseEntry;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.contract.ContractBillMiddleCollection;
import com.kingdee.eas.hr.contract.ContractBillMiddleFactory;
import com.kingdee.eas.hr.contract.ContractBillMiddleInfo;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.ElectronicContractRelationCollection;
import com.kingdee.eas.hr.contract.ElectronicContractRelationFactory;
import com.kingdee.eas.hr.contract.ElectronicContractRelationInfo;
import com.kingdee.eas.hr.contract.IElectronicContractRelation;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateInfo;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.LabContractFirstPartyFactory;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.cloudservice.CloudServiceConfigInfo;
import com.kingdee.shr.econtractservice.ISSCEContractRecord;
import com.kingdee.shr.econtractservice.SSCEContractRecordCollection;
import com.kingdee.shr.econtractservice.SSCEContractRecordFactory;
import com.kingdee.shr.econtractservice.SSCEContractRecordInfo;
import com.kingdee.shr.econtractservice.app.AbstractEContractServiceFacadeControllerBean;
import com.kingdee.shr.econtractservice.app.EContractServiceException;
import com.kingdee.shr.econtractservice.service.EContractService;
import com.kingdee.shr.econtractservice.util.CloudServiceConfigUtils;
import com.kingdee.shr.elecontract.IKDContractConfig;
import com.kingdee.shr.elecontract.KDContractConfigCollection;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.SSCPersonAuthRecordCollection;
import com.kingdee.shr.elecontract.SSCPersonAuthRecordFactory;
import com.kingdee.shr.elecontract.SSCPersonAuthRecordInfo;
import com.kingdee.shr.elecontract.SSCPersonAuthResult;
import com.kingdee.shr.elecontract.util.Base64Utils;
import com.kingdee.shr.elecontract.util.CheckHRCloudLicenseUtils;
import com.kingdee.shr.elecontract.util.CloudServiceUtil;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.elecontract.util.HttpMethodUtils;
import com.kingdee.shr.elecontract.vo.PersonThreeEleInfo;
import com.kingdee.shr.preentry.PreEntryPersonInfo;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.IntEnum;
import java.io.IOException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EContractServiceFacadeControllerBean
extends AbstractEContractServiceFacadeControllerBean {
    private static final long serialVersionUID = -6692678074517236785L;
    public static final Logger logger = LoggerFactory.getLogger(EContractServiceFacadeControllerBean.class);

    @Override
    protected Object _createEContractForDup(Context ctx, IObjectValue billInfo, IObjectValue entryInfo) throws BOSException, EASBizException {
        logger.info("enter _createEContract1");
        HRBillBaseInfo bill = (HRBillBaseInfo)billInfo;
        HRBillBaseEntryInfo entry = (HRBillBaseEntryInfo)entryInfo;
        BOSUuid billBOSUuid = bill.getId();
        BOSUuid entryBOSUuid = entry.getId();
        if (!EContractService.isContractBusinessBill(billBOSUuid.toString())) {
            return null;
        }
        SSCEContractRecordInfo recordInfo = EContractService.getSSCEContractRecord(ctx, billBOSUuid.toString(), entryBOSUuid.toString());
        LabContractFirstPartyInfo firstParty = EContractService.getLabContractFirstParty(ctx, bill, entry);
        ContractTempletInfo templetInfo = EContractService.getContractTempletInfo(ctx, bill, entry);
        ISSCEContractRecord issceContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
        if (recordInfo == null) {
            IObjectCollection entryColl;
            logger.info("record do not exists");
            recordInfo = new SSCEContractRecordInfo();
            String oldNumber = entry.getString("contractNo");
            String eContractNo = "";
            eContractNo = !oldNumber.startsWith("E") ? ElectronicContractUtils.generateContractNumber((Context)ctx, (String)oldNumber) : oldNumber;
            String kdappIdEContractNo = ElectronicContractUtils.addContractNumber((Context)ctx, (LabContractFirstPartyInfo)firstParty, (String)eContractNo);
            recordInfo.setBillId(billBOSUuid);
            recordInfo.setEntryId(entryBOSUuid);
            recordInfo.setBillNumber(bill.getNumber());
            recordInfo.setContractNO(eContractNo);
            recordInfo.setEContractNO(kdappIdEContractNo);
            templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
            recordInfo.setSignType(templetInfo.getSignType());
            Object person = entry.get("person");
            Object preEntryPerson = entry.get("preEntryPerson");
            if (null == person && null == preEntryPerson) {
                logger.info("get new person/preEntryPerson");
                entryColl = (IObjectCollection)bill.get("entrys");
                for (int i = 0; i < entryColl.size(); ++i) {
                    HRBillBaseEntryInfo entryInfoForPerson = (HRBillBaseEntryInfo)entryColl.getObject(i);
                    person = entryInfoForPerson.get("person");
                    if (person != null && person instanceof PersonInfo) {
                        recordInfo.setPerson((PersonInfo)person);
                    }
                    if (person != null && person instanceof PreEntryPersonInfo) {
                        recordInfo.setPreEntryPerson((PreEntryPersonInfo)person);
                    }
                    if ((preEntryPerson = entryInfoForPerson.get("preEntryPerson")) == null || !(preEntryPerson instanceof PreEntryPersonInfo)) continue;
                    recordInfo.setPreEntryPerson((PreEntryPersonInfo)preEntryPerson);
                }
            } else {
                logger.info("get old person/preEntryPerson");
                if (person != null && person instanceof PersonInfo) {
                    recordInfo.setPerson((PersonInfo)person);
                }
                if (person != null && person instanceof PreEntryPersonInfo) {
                    recordInfo.setPreEntryPerson((PreEntryPersonInfo)person);
                }
                if (preEntryPerson != null && preEntryPerson instanceof PreEntryPersonInfo) {
                    recordInfo.setPreEntryPerson((PreEntryPersonInfo)preEntryPerson);
                }
            }
            recordInfo.setKdContractConfig(ElectronicContractUtils.getKDContractConfigByLabContractFirstParty((Context)ctx, (String)firstParty.getId().toString()));
            entryColl = issceContractRecord.save((CoreBaseInfo)recordInfo);
        }
        logger.info("recordInfo_ is {}", (Object)recordInfo.toString());
        if (recordInfo.isIsPersonSign() || recordInfo.isIsCompanySign()) {
            throw new EContractServiceException(EContractServiceException.HAS_SIGNRD);
        }
        ContractBillMiddleInfo middle = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billBOSUuid.toString()));
        filter.getFilterItems().add(new FilterItemInfo("entryId", (Object)entryBOSUuid.toString()));
        view.setFilter(filter);
        ContractBillMiddleCollection collection = ContractBillMiddleFactory.getLocalInstance((Context)ctx).getContractBillMiddleCollection(view);
        middle = collection.size() > 0 ? collection.get(0) : new ContractBillMiddleInfo();
        middle = (ContractBillMiddleInfo)ElectronicContractUtils.copyAndSaveBizBillDataToMiddle((Context)ctx, (HRBillBaseInfo)bill, (HRBillBaseEntryInfo)entry, (CoreBaseInfo)middle);
        String kdappIdEContractNo = recordInfo.getEContractNO();
        SHRElectronicTemplateInfo electronicTemplateInfo = ElectronicContractUtils.getElectronicInfo((Context)ctx, (ContractTempletInfo)templetInfo);
        if (!electronicTemplateInfo.isIsRegister()) {
            throw new EContractServiceException(EContractServiceException.E_TEMPLATE_NOT_REGISTER);
        }
        String csTemplateId = electronicTemplateInfo.getCsTemplateId();
        boolean isCsTemplate = !StringUtils.isEmpty((String)csTemplateId);
        String templateId = electronicTemplateInfo.getTemplateId();
        ArrayList<String> templateIds = new ArrayList<String>();
        templateIds.add(templateId);
        PersonInfo person = recordInfo.getPerson();
        ArrayList osfContractDataList = new ArrayList();
        Map osfContractData = new HashMap();
        osfContractData = !StringUtils.isEmpty((String)electronicTemplateInfo.getStructureNumber()) && !StringUtils.isEmpty((String)electronicTemplateInfo.getContent()) ? ElectronicContractUtils.assembleContractInfoFromEntry((Context)ctx, (String)billBOSUuid.toString(), (SHRElectronicTemplateInfo)electronicTemplateInfo) : ElectronicContractUtils.assembleContractInfoData((Context)ctx, (HRBillBaseInfo)bill, (HRBillBaseEntryInfo)entry, (SHRElectronicTemplateInfo)electronicTemplateInfo, (PersonInfo)person);
        osfContractDataList.add(osfContractData);
        Map dataMap = ElectronicContractUtils.packageOsfParams(templateIds, (String)kdappIdEContractNo, osfContractDataList);
        dataMap.put("labContractFirstPartyInfoId", firstParty.getId().toString());
        dataMap.put("billId", billBOSUuid.toString());
        dataMap.put("entryId", entryBOSUuid.toString());
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        JSONObject result = null;
        if (isCsTemplate) {
            try {
                recordInfo = this.fillTemplate(ctx, csTemplateId, kdappIdEContractNo, osfContractData, recordInfo, issceContractRecord);
                return recordInfo;
            }
            catch (ClientProtocolException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage());
            }
        }
        result = (JSONObject)osfServiceFacade.processService("electronicLaborContractCreateService", dataMap);
        if (result.get((Object)"errcode") != null && ("10002".equals(result.getString("errcode")) || "10001".equals(result.getString("errcode")) || "10003".equals(result.getString("errcode")) || "10004".equals(result.getString("errcode")))) {
            throw new BOSException(result.getString("description"));
        }
        Object codeObj = result.get((Object)"code");
        int returnCode = result.getIntValue("code");
        if (codeObj == null || returnCode != 0) {
            throw new EContractServiceException(EContractServiceException.CREATE_ECOTRACT_ERROR, new Object[]{returnCode, result.get((Object)"msg").toString()});
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.clear();
        if (!isCsTemplate) {
            recordInfo.setIsCreate(true);
            selector.add(new SelectorItemInfo("isCreate"));
        }
        recordInfo.setEcreateTime(new Timestamp(System.currentTimeMillis()));
        recordInfo.setCreateMethod(0);
        selector.add(new SelectorItemInfo("ecreateTime"));
        selector.add(new SelectorItemInfo("createMethod"));
        issceContractRecord.updatePartial(recordInfo, selector);
        return recordInfo;
    }

    @Override
    protected Object _createEContract(Context ctx, String billId, String entryId, String econtractNo) throws BOSException, EASBizException {
        SHRElectronicTemplateInfo electronicTemplateInfo;
        if (!EContractService.isContractBusinessBill(billId)) {
            return null;
        }
        SSCEContractRecordInfo recordInfo = EContractService.getSSCEContractRecord(ctx, billId, entryId);
        if (StringUtils.isEmpty((String)econtractNo)) {
            econtractNo = recordInfo.getEContractNO();
        }
        if (StringUtils.isEmpty((String)entryId)) {
            entryId = recordInfo.getEntryId().toString();
        }
        String kdappIdEContractNo = econtractNo;
        BOSUuid bosBillId = BOSUuid.read((String)billId);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("entrys.*"));
        HRBillBaseInfo billBaseInfo = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosBillId.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
        IObjectCollection entryColls = (IObjectCollection)billBaseInfo.get("entrys");
        HRBillBaseEntryInfo billBaseEntryInfo = null;
        if (entryColls == null || entryColls.size() <= 0) {
            throw new EContractServiceException(EContractServiceException.CREATE_ECOTRACT_ERROR, new Object[]{500, ""});
        }
        billBaseEntryInfo = (HRBillBaseEntryInfo)entryColls.getObject(0);
        Object templet = billBaseEntryInfo.get("contractTemplet");
        LabContractFirstPartyInfo firstPartyInfo = EContractService.getLabContractFirstParty(ctx, billBaseInfo, billBaseEntryInfo);
        ContractTempletInfo templetInfo = null;
        if (templet != null && templet instanceof ContractTempletInfo) {
            templetInfo = (ContractTempletInfo)templet;
        }
        if (!(electronicTemplateInfo = ElectronicContractUtils.getElectronicInfo((Context)ctx, templetInfo)).isIsRegister()) {
            throw new EContractServiceException(EContractServiceException.E_TEMPLATE_NOT_REGISTER);
        }
        String templateId = electronicTemplateInfo.getTemplateId();
        ArrayList<String> templateIds = new ArrayList<String>();
        templateIds.add(templateId);
        PersonInfo person = recordInfo.getPerson();
        ArrayList osfContractDataList = new ArrayList();
        Map osfContractData = new HashMap();
        osfContractData = !StringUtils.isEmpty((String)electronicTemplateInfo.getStructureNumber()) && !StringUtils.isEmpty((String)electronicTemplateInfo.getContent()) ? ElectronicContractUtils.assembleContractInfoFromEntry((Context)ctx, (String)billId, (SHRElectronicTemplateInfo)electronicTemplateInfo) : ElectronicContractUtils.assembleContractInfoData((Context)ctx, (HRBillBaseInfo)billBaseInfo, (HRBillBaseEntryInfo)billBaseEntryInfo, (SHRElectronicTemplateInfo)electronicTemplateInfo, (PersonInfo)person);
        osfContractDataList.add(osfContractData);
        Map dataMap = ElectronicContractUtils.packageOsfParams(templateIds, (String)kdappIdEContractNo, osfContractDataList);
        dataMap.put("labContractFirstPartyInfoId", firstPartyInfo.getId().toString());
        dataMap.put("billId", billId);
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        JSONObject result = (JSONObject)osfServiceFacade.processService("electronicLaborContractCreateService", dataMap);
        if (result.get((Object)"errcode") != null && ("10002".equals(result.getString("errcode")) || "10001".equals(result.getString("errcode")) || "10003".equals(result.getString("errcode")) || "10004".equals(result.getString("errcode")))) {
            throw new BOSException(result.getString("description"));
        }
        Object codeObj = result.get((Object)"code");
        int returnCode = result.getIntValue("code");
        if (codeObj == null || returnCode != 0) {
            throw new EContractServiceException(EContractServiceException.CREATE_ECOTRACT_ERROR, new Object[]{returnCode, result.get((Object)"msg").toString()});
        }
        recordInfo.setIsCreate(true);
        recordInfo.setEcreateTime(new Timestamp(System.currentTimeMillis()));
        selector.clear();
        selector.add(new SelectorItemInfo("isCreate"));
        selector.add(new SelectorItemInfo("ecreateTime"));
        SSCEContractRecordFactory.getLocalInstance(ctx).updatePartial(recordInfo, selector);
        return recordInfo;
    }

    @Override
    protected Object _createEContract(Context ctx, IObjectValue record) throws BOSException, EASBizException {
        SHRElectronicTemplateInfo electronicTemplateInfo;
        String econtractNo;
        SSCEContractRecordInfo recordInfo = (SSCEContractRecordInfo)record;
        String billId = recordInfo.getBillId().toString();
        if (!EContractService.isContractBusinessBill(billId)) {
            return null;
        }
        String entryId = recordInfo.getEntryId().toString();
        String kdappIdEContractNo = econtractNo = recordInfo.getEContractNO();
        BOSUuid bosBillId = BOSUuid.read((String)billId);
        String entryBosType = BOSUuid.read((String)entryId).getType().toString();
        SelectorItemCollection selector = new SelectorItemCollection();
        HRBillBaseInfo billBaseInfo = null;
        IObjectCollection entryColls = null;
        if ("9394E209".equals(entryBosType) || "F5C647BC".equals(entryBosType) || "EF339F6D".equals(entryBosType) || "6A163240".equals(entryBosType)) {
            logger.info("enter_otherEntrys_");
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("otherEntrys.*"));
            billBaseInfo = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosBillId.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
            entryColls = (IObjectCollection)billBaseInfo.get("otherEntrys");
        } else {
            logger.info("enter_entrys_");
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("entrys.*"));
            billBaseInfo = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosBillId.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
            entryColls = (IObjectCollection)billBaseInfo.get("entrys");
        }
        HRBillBaseEntryInfo billBaseEntryInfo = null;
        logger.info("entryColls_size is " + entryColls.size());
        if (entryColls.size() == 1) {
            billBaseEntryInfo = (HRBillBaseEntryInfo)entryColls.getObject(0);
        } else if (entryColls.size() > 1) {
            for (int i = 0; i < entryColls.size(); ++i) {
                HRBillBaseEntryInfo billBaseEntryInfoOne = (HRBillBaseEntryInfo)entryColls.getObject(i);
                String billBaseEntryInfoId = billBaseEntryInfoOne.getId().toString();
                logger.info("billBaseEntryInfoOne_id is " + billBaseEntryInfoId);
                logger.info("entryId_id is " + entryId);
                if (!entryId.equals(billBaseEntryInfoId)) continue;
                logger.info("OK");
                billBaseEntryInfo = billBaseEntryInfoOne;
                break;
            }
        } else {
            throw new EContractServiceException(EContractServiceException.CREATE_ECOTRACT_ERROR, new Object[]{500, ""});
        }
        if (billBaseEntryInfo == null) {
            return null;
        }
        Object templet = billBaseEntryInfo.get("contractTemplet");
        LabContractFirstPartyInfo firstPartyInfo = EContractService.getLabContractFirstParty(ctx, billBaseInfo, billBaseEntryInfo);
        ContractTempletInfo templetInfo = null;
        if (templet != null && templet instanceof ContractTempletInfo) {
            templetInfo = (ContractTempletInfo)templet;
        }
        if (!(electronicTemplateInfo = ElectronicContractUtils.getElectronicInfo((Context)ctx, templetInfo)).isIsRegister()) {
            throw new EContractServiceException(EContractServiceException.E_TEMPLATE_NOT_REGISTER);
        }
        String csTemplateId = electronicTemplateInfo.getCsTemplateId();
        boolean isCsTemplate = !StringUtils.isEmpty((String)csTemplateId);
        String templateId = electronicTemplateInfo.getTemplateId();
        ArrayList<String> templateIds = new ArrayList<String>();
        templateIds.add(templateId);
        ArrayList<HashMap<String, String>> osfContractDataList = new ArrayList<HashMap<String, String>>();
        PersonInfo person = recordInfo.getPerson();
        Map osfContractData = new HashMap();
        osfContractData = !StringUtils.isEmpty((String)electronicTemplateInfo.getStructureNumber()) && !StringUtils.isEmpty((String)electronicTemplateInfo.getContent()) ? ElectronicContractUtils.assembleContractInfoFromEntry((Context)ctx, (String)billId, (SHRElectronicTemplateInfo)electronicTemplateInfo) : ElectronicContractUtils.assembleContractInfoData((Context)ctx, (HRBillBaseInfo)billBaseInfo, (HRBillBaseEntryInfo)billBaseEntryInfo, (SHRElectronicTemplateInfo)electronicTemplateInfo, (PersonInfo)person);
        osfContractDataList.add((HashMap<String, String>)osfContractData);
        Map dataMap = ElectronicContractUtils.packageOsfParams(templateIds, (String)kdappIdEContractNo, osfContractDataList);
        logger.info("templateIds_ value is " + templateIds);
        logger.info("kdappIdEContractNo_ value is " + kdappIdEContractNo);
        logger.info("map key is contractNo value is " + dataMap.get("contractNo"));
        logger.info("map key is templates value is " + dataMap.get("templates"));
        dataMap.put("labContractFirstPartyInfoId", firstPartyInfo.getId().toString());
        dataMap.put("billId", billId);
        dataMap.put("entryId", entryId);
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        ISSCEContractRecord issceContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
        JSONObject result = null;
        if (isCsTemplate) {
            try {
                recordInfo = this.fillTemplate(ctx, csTemplateId, kdappIdEContractNo, osfContractData, recordInfo, issceContractRecord);
                return recordInfo;
            }
            catch (ClientProtocolException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage());
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage());
            }
        }
        result = (JSONObject)osfServiceFacade.processService("electronicLaborContractCreateService", dataMap);
        if (result.get((Object)"errcode") != null && ("10002".equals(result.getString("errcode")) || "10001".equals(result.getString("errcode")) || "10003".equals(result.getString("errcode")) || "10004".equals(result.getString("errcode")))) {
            throw new BOSException(result.getString("description"));
        }
        Object codeObj = result.get((Object)"code");
        int returnCode = result.getIntValue("code");
        if (codeObj == null || returnCode != 0) {
            throw new EContractServiceException(EContractServiceException.CREATE_ECOTRACT_ERROR, new Object[]{returnCode, result.get((Object)"msg").toString()});
        }
        SelectorItemCollection selector2 = new SelectorItemCollection();
        if (!isCsTemplate) {
            recordInfo.setIsCreate(true);
            selector2.add(new SelectorItemInfo("isCreate"));
        }
        recordInfo.setEcreateTime(new Timestamp(System.currentTimeMillis()));
        recordInfo.setCreateMethod(0);
        selector2.add(new SelectorItemInfo("ecreateTime"));
        selector2.add(new SelectorItemInfo("createMethod"));
        issceContractRecord.updatePartial(recordInfo, selector);
        return recordInfo;
    }

    @Override
    protected Object _repairEContractRecordData(Context ctx, String billId, String entryId, Map param) throws BOSException, EASBizException {
        BOSUuid bosBillId = BOSUuid.read((String)billId);
        HRBillBaseEntryInfo billEntryInfo = null;
        HRBillBaseInfo billInfo = null;
        if (!StringUtils.isEmpty((String)entryId)) {
            billEntryInfo = this.getBillEntryInfo(ctx, billId, entryId);
            billInfo = (HRBillBaseInfo)billEntryInfo.get("bill");
        } else {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            selector.add(new SelectorItemInfo("entrys.*"));
            billInfo = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosBillId.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(billId), selector);
            IObjectCollection entryColls = (IObjectCollection)billInfo.get("entrys");
            if (entryColls.size() > 0) {
                billEntryInfo = (HRBillBaseEntryInfo)entryColls.getObject(0);
            }
        }
        return this._repairEContractRecordData(ctx, (IObjectValue)billInfo, (IObjectValue)billEntryInfo, param);
    }

    @Override
    protected Object _repairEContractRecordData(Context ctx, IObjectValue billInfo, IObjectValue entryInfo, Map param) throws BOSException, EASBizException {
        Object preEntryPerson;
        SSCEContractRecordInfo recordInfo = null;
        HRBillBaseInfo bill = (HRBillBaseInfo)billInfo;
        HRBillBaseEntryInfo entry = (HRBillBaseEntryInfo)entryInfo;
        BOSUuid billId = bill.getId();
        IElectronicContractRelation contractRelation = ElectronicContractRelationFactory.getLocalInstance((Context)ctx);
        ElectronicContractRelationCollection coll = contractRelation.getElectronicContractRelationCollection("where billID = '" + billId.toString() + "'");
        ElectronicContractRelationInfo relationInfo = null;
        boolean isNeedAdd = false;
        if (coll.size() > 0) {
            relationInfo = coll.get(0);
        } else {
            isNeedAdd = true;
            relationInfo = new ElectronicContractRelationInfo();
        }
        recordInfo = new SSCEContractRecordInfo();
        String contractNO = (String)param.get("contractNO");
        String kdAppId = (String)param.get("kdAppId");
        KDContractConfigInfo configInfo = null;
        if (StringUtils.isEmpty((String)kdAppId)) {
            LabContractFirstPartyInfo firstParty = EContractService.getLabContractFirstParty(ctx, bill, entry);
            configInfo = ElectronicContractUtils.getKDContractConfigByLabContractFirstParty((Context)ctx, (String)firstParty.getId().toString());
        } else {
            configInfo = ElectronicContractUtils.getKDContractConfigInfoByKdAppId((Context)ctx, (String)kdAppId, null);
        }
        recordInfo.setBillId(billId);
        recordInfo.setEntryId(entry.getId());
        ContractTempletInfo templetInfo = EContractService.getContractTempletInfo(ctx, bill, entry);
        templetInfo = ContractTempletFactory.getLocalInstance((Context)ctx).getContractTempletInfo((IObjectPK)new ObjectUuidPK(templetInfo.getId().toString()));
        recordInfo.setSignType(templetInfo.getSignType());
        String electronicContractNo = "";
        String newContractNo = "";
        if (StringUtils.isEmpty((String)contractNO)) {
            String rempContactNo = relationInfo.getContractId();
            if (!StringUtils.isEmpty((String)rempContactNo)) {
                electronicContractNo = rempContactNo;
                newContractNo = ElectronicContractUtils.getRealContractNo((String)electronicContractNo);
            } else {
                newContractNo = entry.getString("contractNo");
                electronicContractNo = newContractNo + "-" + configInfo.getClientKDAppId();
            }
        } else {
            electronicContractNo = contractNO;
            newContractNo = ElectronicContractUtils.getRealContractNo((String)contractNO);
        }
        recordInfo.setContractNO(newContractNo);
        recordInfo.setEContractNO(electronicContractNo);
        recordInfo.setIsCreate(true);
        recordInfo.setEcreateTime(bill.getLastUpdateTime());
        Object person = entry.get("person");
        if (person != null) {
            if (person instanceof PersonInfo) {
                recordInfo.put("person", person);
            }
            if (person instanceof PreEntryPersonInfo) {
                recordInfo.put("preEntryPerson", person);
            }
        }
        if ((preEntryPerson = entry.get("preEntryPerson")) != null && preEntryPerson instanceof PreEntryPersonInfo) {
            recordInfo.put("preEntryPerson", preEntryPerson);
        }
        if (!param.containsKey("isPersonTask") || param.get("isPersonTask").equals(true)) {
            // empty if block
        }
        if (param.containsKey("isCompanyTask") && param.get("isCompanyTask").equals(true)) {
            Object signStateObj = entry.get("signState");
            int signState = 0;
            signState = signStateObj instanceof IntEnum || signStateObj instanceof Enum ? ((IntEnum)signStateObj).getValue() : Integer.parseInt(signStateObj.toString());
            if (signState >= 1) {
                recordInfo.setIsPersonSign(true);
                recordInfo.setPersonSignTime(EContractService.getCurTimestamp());
            }
        }
        if (param.containsKey("isPersonSigned") && param.get("isPersonSigned").equals(true)) {
            recordInfo.setIsPersonSign(true);
            recordInfo.setPersonSignTime(EContractService.getCurTimestamp());
        }
        if (param.containsKey("isCompanySigned") && param.get("isCompanySigned").equals(true)) {
            if (!recordInfo.isIsPersonSign()) {
                recordInfo.setIsPersonSign(true);
            }
            if (recordInfo.getPersonSignTime() == null) {
                recordInfo.setPersonSignTime(EContractService.getCurTimestamp());
            }
            recordInfo.setIsCompanySign(true);
            recordInfo.setCompanySignTime(EContractService.getCurTimestamp());
        }
        recordInfo.setBillNumber(bill.getNumber());
        recordInfo.setKdContractConfig(configInfo);
        IObjectPK save = SSCEContractRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)recordInfo);
        recordInfo.setId(BOSUuid.read((String)save.toString()));
        if (isNeedAdd) {
            relationInfo.setBillID(billId);
            relationInfo.setEntryId(entry.getId());
            relationInfo.setContractId(electronicContractNo);
            if (configInfo != null && configInfo.getId() != null) {
                relationInfo.setSimpleName(configInfo.getId().toString());
            }
            relationInfo.setPageCount(2);
            relationInfo.setContractState(Short.parseShort("0"));
            ElectronicContractRelationFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)relationInfo);
        }
        return recordInfo;
    }

    protected HRBillBaseEntryInfo getBillEntryInfo(Context ctx, String billId, String entryId) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)entryId));
        filterInfo.getFilterItems().add(new FilterItemInfo("bill.id", (Object)billId));
        view.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("bill.*"));
        view.setSelector(selector);
        IHRBillBaseEntry iHRBillBaseEntry = (IHRBillBaseEntry)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSUuid.read((String)entryId).getType());
        HRBillBaseEntryCollection colls = iHRBillBaseEntry.getHRBillBaseEntryCollection(view);
        if (colls.size() > 0) {
            return colls.get(0);
        }
        return null;
    }

    @Override
    protected Object _getEContractSignStatus(Context ctx, Map param) throws BOSException, EASBizException {
        JSONObject res;
        String userId = (String)param.get("userId");
        String eContractNo = (String)param.get("eContractNo");
        String entryId = (String)param.get("entryId");
        String recordId = (String)param.get("recordId");
        String taskType = (String)param.get("taskType");
        String billId = (String)param.get("billId");
        boolean isQueryCompanySign = param.get("isQueryCompanySign") == null ? false : Boolean.valueOf(param.get("isQueryCompanySign").toString());
        ISSCEContractRecord issceContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
        BOSUuid entryBosId = BOSUuid.read((String)entryId);
        IHRBillBaseEntry entryIn = (IHRBillBaseEntry)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)entryBosId.getType());
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("signState"));
        selector.add(new SelectorItemInfo("contractTemplet.number"));
        selector.add(new SelectorItemInfo("bill.*"));
        HRBillBaseEntryInfo billBaseEntryInfo = entryIn.getHRBillBaseEntryInfo((IObjectPK)new ObjectUuidPK(entryId), selector);
        SSCEContractRecordInfo currentRecord = issceContractRecord.getSSCEContractRecordInfo((IObjectPK)new ObjectUuidPK(recordId));
        EContractSignState currentSignState = null;
        Object signStateObj = billBaseEntryInfo.get("signState");
        if (signStateObj instanceof EContractSignState) {
            currentSignState = (EContractSignState)signStateObj;
        } else if (signStateObj instanceof Integer) {
            currentSignState = EContractSignState.getEnum((int)((Integer)signStateObj));
        } else {
            Integer intObj = Integer.parseInt(String.valueOf(signStateObj));
            currentSignState = EContractSignState.getEnum((int)intObj);
        }
        if (!StringUtils.isEmpty((String)userId) && !isQueryCompanySign && EContractSignState.signing.equals((Object)currentSignState) && currentRecord.isIsPersonSign()) {
            res = new JSONObject();
            JSONObject data = new JSONObject();
            res.put("code", (Object)0);
            res.put("msg", (Object)"SUCCESS");
            data.put("signStatus", (Object)1);
            res.put("data", (Object)data);
            return res;
        }
        logger.error("_getEContractSignStatus isQueryCompanySign is:" + isQueryCompanySign);
        if (isQueryCompanySign) {
            if (!StringUtils.isEmpty((String)taskType) && "COMPANY_B".equalsIgnoreCase(taskType) && EContractSignState.partyASigned.equals((Object)currentSignState) && currentRecord.isIsCompanyBSign()) {
                res = new JSONObject();
                JSONObject data = new JSONObject();
                res.put("code", (Object)0);
                res.put("msg", (Object)"SUCCESS");
                data.put("signStatus", (Object)1);
                res.put("data", (Object)data);
                return res;
            }
            if (EContractSignState.complete.equals((Object)currentSignState) && currentRecord.isIsCompanySign() && currentRecord.isIsSigned()) {
                res = new JSONObject();
                JSONObject data = new JSONObject();
                res.put("code", (Object)0);
                res.put("msg", (Object)"SUCCESS");
                data.put("signStatus", (Object)1);
                res.put("data", (Object)data);
                return res;
            }
        }
        HRBillBaseInfo billBaseInfo = (HRBillBaseInfo)billBaseEntryInfo.getObjectValue("bill");
        if (!StringUtils.isEmpty((String)taskType) && "COMPANY_B".equalsIgnoreCase(taskType)) {
            LabContractFirstPartyInfo partyBInfo = EContractService.getLabContractPartyB(ctx, billBaseInfo, billBaseEntryInfo);
            if (partyBInfo == null) {
                throw new EContractServiceException(EContractServiceException.COMPANY_SIGN_ERROR, new Object[]{500});
            }
            if (StringUtils.isEmpty((String)partyBInfo.getName())) {
                partyBInfo = LabContractFirstPartyFactory.getLocalInstance((Context)ctx).getLabContractFirstPartyInfo((IObjectPK)new ObjectUuidPK(partyBInfo.getId().toString()));
            }
            KDContractConfigInfo contractBConfigInfo = KDContractConfigFactory.getLocalInstance((Context)ctx).getKDContractConfigInfo("where labContractFirstParty.id='" + partyBInfo.getId().toString() + "'");
            userId = contractBConfigInfo.getClientEnterpriseId();
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("contractNo", eContractNo);
        if (!StringUtils.isEmpty((String)userId)) {
            dataMap.put("userId", userId);
        }
        logger.error("_getEContractSignStatus electronicLaborGetSignStatusService param contractNo:" + eContractNo);
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        Object result = osfServiceFacade.processService("electronicLaborGetSignStatusService", dataMap);
        JSONObject resObj = null;
        resObj = result instanceof JSONObject ? (JSONObject)result : JSONObject.parseObject((String)result.toString());
        int code = resObj.getIntValue("code");
        if (code == 0) {
            JSONObject data = resObj.getJSONObject("data");
            int signStatus = data.getIntValue("signStatus");
            logger.error("_getEContractSignStatus electronicLaborGetSignStatusService result signStatus:" + signStatus);
            if (signStatus == 1) {
                EContractSignState state = null;
                if (!StringUtils.isEmpty((String)userId)) {
                    state = EContractSignState.signing;
                    billBaseEntryInfo.put("signState", (Object)state);
                    entryIn.updatePartial((CoreBaseInfo)billBaseEntryInfo, selector);
                    currentRecord.setIsPersonSign(true);
                    currentRecord.setPersonSignTime(EContractService.getCurTimestamp());
                    selector.clear();
                    selector.add(new SelectorItemInfo("isPersonSign"));
                    selector.add(new SelectorItemInfo("personSignTime"));
                    SSCEContractRecordFactory.getLocalInstance(ctx).updatePartial(currentRecord, selector);
                } else if (isQueryCompanySign) {
                    selector.clear();
                    selector.add(new SelectorItemInfo("signState"));
                    state = !StringUtils.isEmpty((String)taskType) && "COMPANY_B".equalsIgnoreCase(taskType) ? EContractSignState.partyASigned : EContractSignState.complete;
                    billBaseEntryInfo.put("signState", (Object)state);
                    entryIn.updatePartial((CoreBaseInfo)billBaseEntryInfo, selector);
                    selector.clear();
                    if (!StringUtils.isEmpty((String)taskType) && "COMPANY_B".equalsIgnoreCase(taskType)) {
                        currentRecord.setIsCompanyBSign(true);
                        currentRecord.setCompanyBSignTime(EContractService.getCurTimestamp());
                        selector.add(new SelectorItemInfo("isCompanyBSign"));
                        selector.add(new SelectorItemInfo("companyBSignTime"));
                    } else {
                        currentRecord.setIsCompanySign(true);
                        currentRecord.setCompanySignTime(EContractService.getCurTimestamp());
                        currentRecord.setIsSigned(true);
                        currentRecord.setSignedTime(EContractService.getCurTimestamp());
                        selector.add(new SelectorItemInfo("isCompanySign"));
                        selector.add(new SelectorItemInfo("companySignTime"));
                        selector.add(new SelectorItemInfo("isSigned"));
                        selector.add(new SelectorItemInfo("signedTime"));
                    }
                    SSCEContractRecordFactory.getLocalInstance(ctx).updatePartial(currentRecord, selector);
                }
                this.doUpdateStateInBill(ctx, billBaseInfo);
            }
        }
        return result;
    }

    protected void doUpdateStateInBill(Context ctx, HRBillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        if (!EContractService.isPackage(billBaseInfo.getId().toString())) {
            return;
        }
        ISSCEContractRecord iSSCEContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
        SSCEContractRecordCollection sSCEContractRecordColl = iSSCEContractRecord.getSSCEContractRecordCollection("where billId = '" + billBaseInfo.getId() + "'");
        boolean isComplete = true;
        boolean isSigningOrComplete = true;
        int sSCEContractRecordCollSize = sSCEContractRecordColl.size();
        for (int i = 0; i < sSCEContractRecordCollSize; ++i) {
            boolean isCompleteInOne = false;
            boolean isSigningOrCompleteInOne = false;
            SSCEContractRecordInfo sSCEContractRecordInfo = sSCEContractRecordColl.get(i);
            if (sSCEContractRecordInfo.isIsSigned()) {
                isCompleteInOne = true;
            }
            if (sSCEContractRecordInfo.isIsPersonSign()) {
                isSigningOrCompleteInOne = true;
            }
            isComplete = isComplete && isCompleteInOne;
            isSigningOrComplete = isSigningOrComplete && isSigningOrCompleteInOne;
        }
        SelectorItemCollection totalSelector = new SelectorItemCollection();
        totalSelector.add(new SelectorItemInfo("totalState"));
        String billBosType = billBaseInfo.getId().getType().toString();
        logger.info("billBosType---->:" + billBosType);
        ICoreBase bizInterface = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)billBaseInfo.getId().getType());
        if (isComplete) {
            billBaseInfo.put("totalState", (Object)EContractSignState.complete);
            bizInterface.updatePartial((CoreBaseInfo)billBaseInfo, totalSelector);
        } else if (!isComplete && isSigningOrComplete) {
            billBaseInfo.put("totalState", (Object)EContractSignState.signing);
            bizInterface.updatePartial((CoreBaseInfo)billBaseInfo, totalSelector);
        }
        this.updateSSCRule(ctx, billBaseInfo, null);
    }

    private void updateSSCRule(Context ctx, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo billEntryInfo) {
        JSONObject paramJson = new JSONObject();
        paramJson.put("certificationStatus", (Object)String.valueOf(((EContractSignState)billBaseInfo.get("totalState")).getValue()));
        JSONObject dyValues = new JSONObject();
        dyValues.put(billBaseInfo.getId().toString(), (Object)paramJson);
        HashMap<String, Object> taskParam = new HashMap<String, Object>();
        taskParam.put("mapValue", dyValues);
        taskParam.put("isUpdateHis", true);
        try {
            SSCTaskAppUtil.operateTaskAll((Context)ctx, (String)"UPDATEDYNAMICVALUE", taskParam);
        }
        catch (Exception e) {
            logger.error("com.kingdee.shr.econtractservice.app.SSCEContractTaskFacadeControllerBean.updateSSCRule:" + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    protected Object _checkPersonHashAuth(Context ctx, String personId, String kdContractConfigId, String billId) throws BOSException, EASBizException {
        IKDContractConfig instance;
        KDContractConfigCollection coll;
        KDContractConfigInfo configInfo = null;
        if (!StringUtils.isEmpty((String)kdContractConfigId) && (coll = (instance = KDContractConfigFactory.getLocalInstance((Context)ctx)).getKDContractConfigCollection(MessageFormat.format(" where id = ''{0}''", kdContractConfigId))) != null && coll.size() > 0) {
            configInfo = coll.get(0);
        }
        if (configInfo == null) {
            String kdConfigInfoId;
            IElectronicContractRelation electronicContractRelation = ElectronicContractRelationFactory.getLocalInstance((Context)ctx);
            coll = electronicContractRelation.getElectronicContractRelationCollection("where billID = '" + billId + "'");
            ElectronicContractRelationInfo relation = null;
            if (coll.size() > 0) {
                relation = coll.get(0);
            }
            if (relation != null && !StringUtils.isEmpty((String)(kdConfigInfoId = relation.getSimpleName()))) {
                IKDContractConfig instance2 = KDContractConfigFactory.getLocalInstance((Context)ctx);
                KDContractConfigCollection kdColls = instance2.getKDContractConfigCollection(MessageFormat.format(" where id = ''{0}''", kdConfigInfoId));
                if (coll != null && coll.size() > 0) {
                    configInfo = kdColls.get(0);
                }
            }
        }
        if (configInfo == null) {
            LabContractFirstPartyInfo Info = EContractService.getLabContractFirstPartyByBillID(ctx, billId);
            configInfo = ElectronicContractUtils.getKDContractConfigByLabContractFirstParty((Context)ctx, (String)Info.getId().toString());
        }
        PersonThreeEleInfo threeInfo = EContractService.getPersonThreeInfo(ctx, personId);
        SSCPersonAuthRecordInfo authRecordInfo = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("idCardNo", (Object)threeInfo.getIdCardNO()));
        filter.getFilterItems().add(new FilterItemInfo("mobile", (Object)threeInfo.getMobile()));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)threeInfo.getName()));
        filter.getFilterItems().add(new FilterItemInfo("kdContractConfig", (Object)configInfo.getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SSCPersonAuthRecordCollection collection = SSCPersonAuthRecordFactory.getLocalInstance((Context)ctx).getSSCPersonAuthRecordCollection(view);
        boolean isNeedGetResultFormCloud = false;
        if (collection.size() > 0) {
            authRecordInfo = collection.get(0);
            if (!SSCPersonAuthResult.SUCCESS.equals((Object)authRecordInfo.getResult()) || StringUtils.isEmpty((String)authRecordInfo.getUserId())) {
                isNeedGetResultFormCloud = true;
            }
        } else {
            isNeedGetResultFormCloud = true;
        }
        if (isNeedGetResultFormCloud) {
            if (authRecordInfo == null) {
                authRecordInfo = new SSCPersonAuthRecordInfo();
                authRecordInfo.setKdContractConfig(configInfo);
                authRecordInfo.setIdCardNo(threeInfo.getIdCardNO());
                authRecordInfo.setMobile(threeInfo.getMobile());
                authRecordInfo.setName(threeInfo.getName());
                authRecordInfo.setPersonId(threeInfo.getId());
            }
            authRecordInfo = this.processAuthInfoFormCloud(ctx, configInfo, threeInfo, authRecordInfo);
        }
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("userId", authRecordInfo.getUserId());
        res.put("result", (String)authRecordInfo.getResult());
        res.put("idCardNo", authRecordInfo.getIdCardNo());
        return res;
    }

    public SSCPersonAuthRecordInfo processAuthInfoFormCloud(Context ctx, KDContractConfigInfo configInfo, PersonThreeEleInfo threeInfo, SSCPersonAuthRecordInfo authRecordInfo) throws BOSException, EASBizException {
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("id", threeInfo.getIdCardNO());
        dataMap.put("name", threeInfo.getName());
        dataMap.put("kdAppId", configInfo.getClientKDAppId());
        dataMap.put("secret", configInfo.getClientSecret());
        dataMap.put("version", configInfo.getCloudSysVersion().getValue());
        dataMap.put("serverURL", configInfo.getCloudServerUrl());
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        JSONObject osfResult = (JSONObject)osfServiceFacade.processService("electronicLaborGetAuthResultService", dataMap);
        if (osfResult.getIntValue("code") == 0) {
            int resultCode = osfResult.getJSONObject("data").getIntValue("resultCode");
            String userId = osfResult.getJSONObject("data").getString("userId");
            SSCPersonAuthResult authResult = null;
            authResult = resultCode == 0 ? SSCPersonAuthResult.FAIL : (resultCode == 1 ? SSCPersonAuthResult.SUCCESS : (resultCode == 2 ? SSCPersonAuthResult.AUTHING : SSCPersonAuthResult.OTHER));
            authRecordInfo.setUserId(userId);
            authRecordInfo.setResult(authResult);
        }
        SSCPersonAuthRecordFactory.getLocalInstance((Context)ctx).save((CoreBaseInfo)authRecordInfo);
        return authRecordInfo;
    }

    private SSCEContractRecordInfo fillTemplate(Context ctx, String cpTemplateId, String contractNo, Map<String, String> templateData, SSCEContractRecordInfo recordInfo, ISSCEContractRecord issceContractRecord) throws ClientProtocolException, IOException, BOSException, EASBizException {
        CheckHRCloudLicenseUtils.checkLicenseCount((Context)ctx, (String)"8", (String)contractNo);
        String serverURL = CloudServiceUtil.getServiceUrl((Context)ctx, (String)"BASE") + "/kdcontract/contract/fillTemplate";
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(serverURL);
        httpPost = (HttpPost)HttpMethodUtils.addHeader((Context)ctx, (AbstractHttpMessage)httpPost);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("templateId", cpTemplateId);
        ArrayList<String> fileIdList = new ArrayList<String>();
        fileIdList.add(contractNo);
        params.put("fileId", fileIdList);
        params.put("fileName", contractNo);
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        dataList.add(templateData);
        params.put("data", dataList);
        CloudServiceConfigInfo cloudServiceConfig = CloudServiceConfigUtils.getCloudServiceConfig(ctx);
        if (null != cloudServiceConfig) {
            params.put("serviceId", cloudServiceConfig.getServiceID());
        }
        String content = JSONUtils.convertObjectToJson((Context)ctx, params);
        logger.error("=========== request to: " + serverURL + ", content: " + content);
        httpPost.setEntity((HttpEntity)new StringEntity(content, ContentType.APPLICATION_JSON));
        HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpPost);
        if (200 != httpResponse.getStatusLine().getStatusCode()) {
            throw new BOSException("request fail and the statuscode = " + httpResponse.getStatusLine().getStatusCode());
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        String response = EntityUtils.toString((HttpEntity)httpEntity);
        String encodeStr = Base64Utils.encode((String)response);
        logger.error("=========== response from: " + serverURL + ", response: " + encodeStr);
        JSONObject result = JSONObject.parseObject((String)response);
        if (result.get((Object)"code") != null && "1".equals(result.getString("code"))) {
            throw new BOSException(result.getString("msg"));
        }
        recordInfo.setIsCreate(false);
        recordInfo.setCreateMethod(1);
        recordInfo.setIsFillSuccess(true);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isCreate"));
        selector.add(new SelectorItemInfo("createMethod"));
        selector.add(new SelectorItemInfo("isFillSuccess"));
        issceContractRecord.updatePartial(recordInfo, selector);
        return recordInfo;
    }
}

