/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.econtractservice.app;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.contract.IOtherContractSignBizBill;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillFactory;
import com.kingdee.eas.hr.contract.OtherContractSignBizBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.econtractservice.ISSCEContractRecord;
import com.kingdee.shr.econtractservice.SSCEContractRecordCollection;
import com.kingdee.shr.econtractservice.SSCEContractRecordFactory;
import com.kingdee.shr.econtractservice.SSCEContractRecordInfo;
import com.kingdee.shr.econtractservice.app.AbstractEContractSyncSignRecordFacadeControllerBean;
import com.kingdee.shr.elecontract.EElBizType;
import com.kingdee.shr.elecontract.IKDContractConfig;
import com.kingdee.shr.elecontract.IKDContractConfigRecord;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.KDContractConfigRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigRecordInfo;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import com.kingdee.util.LocaleUtils;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EContractSyncSignRecordFacadeControllerBean
extends AbstractEContractSyncSignRecordFacadeControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(EContractSyncSignRecordFacadeControllerBean.class);
    private static final String certificationBussAttrID = "ERysvjIDRw27zcSuYvCCc7xcg58=,ybHaTNwJQLiKB2cUmBLYmrxcg58=,QDcSvFXfT1+2sFGXPc0Ov7xcg58=,G5QnX8TaSO2JZms+L9rfy7xcg58=";
    private static final String contractBussAttrID = "YCRhEi3iT3W8pPo7JITzw7xcg58=,FM7eJ3c6TxG3i2xUKhSla7xcg58=,6IXTBav3Rcanok3WJyvqjbxcg58=,9LpcSzs7QyOsI6/t4Hlj3bxcg58=,OPJkiZl7QTGMbdsafsvGhbxcg58=,IuJzzWdLTuCB3zCAt4QnuLxcg58=";
    private static final String contractThreeBussAttrID = "rcR4cz6lQvCoXog30A8Qhrxcg58=";

    @Override
    protected Object _syncKdContractConfigRecord(Context ctx) throws BOSException {
        logger.info("start _syncKdContractConfigRecord");
        this.syncCompanySignRecord(ctx);
        this.syncCompanyBSignRecord(ctx);
        this.syncCertificationRecord(ctx);
        return null;
    }

    public void syncCompanySignRecord(Context ctx) throws BOSException {
        logger.info("start _syncCompanySignRecord");
        IKDContractConfigRecord ikdContractConfigRecord = KDContractConfigRecordFactory.getLocalInstance((Context)ctx);
        ISSCEContractRecord issceContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
        FilterInfo contractFilterInfo = new FilterInfo();
        contractFilterInfo.getFilterItems().add(new FilterItemInfo("isCompanySign", (Object)true, CompareType.EQUALS));
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("kdContractConfig.id"));
        selectorItemCollection.add(new SelectorItemInfo("kdContractConfig.clientEnterpriseId"));
        selectorItemCollection.add(new SelectorItemInfo("kdContractConfig.enterpriseName"));
        selectorItemCollection.add(new SelectorItemInfo("kdContractConfig.clientKDAppId"));
        selectorItemCollection.add(new SelectorItemInfo("kdContractConfig.clientSecret"));
        selectorItemCollection.add(new SelectorItemInfo("person.id"));
        selectorItemCollection.add(new SelectorItemInfo("person.name"));
        selectorItemCollection.add(new SelectorItemInfo("person.number"));
        selectorItemCollection.add(new SelectorItemInfo("preEntryPerson.id"));
        selectorItemCollection.add(new SelectorItemInfo("preEntryPerson.name"));
        selectorItemCollection.add(new SelectorItemInfo("preEntryPerson.number"));
        selectorItemCollection.add(new SelectorItemInfo("creator.id"));
        selectorItemCollection.add(new SelectorItemInfo("creator.name"));
        selectorItemCollection.add(new SelectorItemInfo("creator.number"));
        selectorItemCollection.add(new SelectorItemInfo("lastUpdateUser.id"));
        selectorItemCollection.add(new SelectorItemInfo("lastUpdateUser.number"));
        selectorItemCollection.add(new SelectorItemInfo("lastUpdateUser.name"));
        selectorItemCollection.add(new SelectorItemInfo("CU.id"));
        selectorItemCollection.add(new SelectorItemInfo("signType"));
        EntityViewInfo contractEntityViewInfo = new EntityViewInfo();
        contractEntityViewInfo.setFilter(contractFilterInfo);
        contractEntityViewInfo.setSelector(selectorItemCollection);
        SSCEContractRecordCollection sscEContractRecordCollection = issceContractRecord.getSSCEContractRecordCollection(contractEntityViewInfo);
        logger.info("contract A history data size is {}", (Object)sscEContractRecordCollection.size());
        for (int i = 0; i < sscEContractRecordCollection.size(); ++i) {
            SSCEContractRecordInfo ssceContractRecordInfo = sscEContractRecordCollection.get(i);
            int signType = ssceContractRecordInfo.getSignType().getValue();
            String clientEnterpriseId = ssceContractRecordInfo.getKdContractConfig().getClientEnterpriseId();
            logger.info("signType is {}, clientEnterpriseId is {}", (Object)signType, (Object)clientEnterpriseId);
            try {
                if (this.checkHasSync(ikdContractConfigRecord, ssceContractRecordInfo.getBillId().toString(), signType, clientEnterpriseId)) {
                    logger.info("\u5408\u540c\u7528\u7ae0\u8bb0\u5f55\u5386\u53f2\u6570\u636e\uff1a{} \u5df2\u540c\u6b65", (Object)ssceContractRecordInfo.getId().toString());
                    continue;
                }
                KDContractConfigRecordInfo kdContractConfigRecordInfo = this.getKDContractConfigRecordFromSSCEContractRecord(ctx, ssceContractRecordInfo, 0);
                kdContractConfigRecordInfo.setConfig(ssceContractRecordInfo.getKdContractConfig());
                IObjectPK id = ikdContractConfigRecord.addnew(kdContractConfigRecordInfo);
                this.updateLastUpdateTime(ikdContractConfigRecord, ssceContractRecordInfo.getCompanySignTime(), id);
                logger.info("\u5408\u540c\u7528\u7ae0\u8bb0\u5f55\u5386\u53f2\u6570\u636e\uff1a{} \u6dfb\u52a0\u6210\u529f", (Object)ssceContractRecordInfo.getId());
                continue;
            }
            catch (Exception e) {
                logger.error("\u5408\u540c\u7528\u7ae0\u8bb0\u5f55\u5386\u53f2\u6570\u636e\uff1a{} \u6dfb\u52a0\u5931\u8d25", (Object)ssceContractRecordInfo.getId());
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void syncCompanyBSignRecord(Context ctx) throws BOSException {
        logger.info("start _syncCompanyBSignRecord");
        IKDContractConfigRecord ikdContractConfigRecord = KDContractConfigRecordFactory.getLocalInstance((Context)ctx);
        ISSCEContractRecord issceContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
        IOtherContractSignBizBill iOtherContractSignBizBill = OtherContractSignBizBillFactory.getLocalInstance((Context)ctx);
        IKDContractConfig ikdContractConfig = KDContractConfigFactory.getLocalInstance((Context)ctx);
        FilterInfo contractFilterInfo = new FilterInfo();
        contractFilterInfo.getFilterItems().add(new FilterItemInfo("isCompanyBSign", (Object)true, CompareType.EQUALS));
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("*"));
        selectorItemCollection.add(new SelectorItemInfo("kdContractConfig.id"));
        selectorItemCollection.add(new SelectorItemInfo("kdContractConfig.clientEnterpriseId"));
        selectorItemCollection.add(new SelectorItemInfo("kdContractConfig.enterpriseName"));
        selectorItemCollection.add(new SelectorItemInfo("kdContractConfig.clientKDAppId"));
        selectorItemCollection.add(new SelectorItemInfo("kdContractConfig.clientSecret"));
        selectorItemCollection.add(new SelectorItemInfo("person.id"));
        selectorItemCollection.add(new SelectorItemInfo("person.name"));
        selectorItemCollection.add(new SelectorItemInfo("person.number"));
        selectorItemCollection.add(new SelectorItemInfo("preEntryPerson.id"));
        selectorItemCollection.add(new SelectorItemInfo("preEntryPerson.name"));
        selectorItemCollection.add(new SelectorItemInfo("preEntryPerson.number"));
        selectorItemCollection.add(new SelectorItemInfo("creator.id"));
        selectorItemCollection.add(new SelectorItemInfo("creator.name"));
        selectorItemCollection.add(new SelectorItemInfo("creator.number"));
        selectorItemCollection.add(new SelectorItemInfo("lastUpdateUser.id"));
        selectorItemCollection.add(new SelectorItemInfo("lastUpdateUser.number"));
        selectorItemCollection.add(new SelectorItemInfo("lastUpdateUser.name"));
        selectorItemCollection.add(new SelectorItemInfo("CU.id"));
        selectorItemCollection.add(new SelectorItemInfo("signType"));
        EntityViewInfo contractEntityViewInfo = new EntityViewInfo();
        contractEntityViewInfo.setFilter(contractFilterInfo);
        contractEntityViewInfo.setSelector(selectorItemCollection);
        SSCEContractRecordCollection sscEContractRecordCollection = issceContractRecord.getSSCEContractRecordCollection(contractEntityViewInfo);
        logger.info("contract B history data size is {}", (Object)sscEContractRecordCollection.size());
        for (int i = 0; i < sscEContractRecordCollection.size(); ++i) {
            SSCEContractRecordInfo ssceContractRecordInfo = sscEContractRecordCollection.get(i);
            try {
                OtherContractSignBizBillInfo otherContractSignBizBillInfo = iOtherContractSignBizBill.getOtherContractSignBizBillInfo("where id = '" + ssceContractRecordInfo.getBillId().toString() + "'");
                KDContractConfigInfo kdContractConfigInfo = ikdContractConfig.getKDContractConfigInfo("where LABCONTRACTFIRSTPARTY = '" + otherContractSignBizBillInfo.getLabContractCParty().getId().toString() + "'");
                String clientEnterpriseId = kdContractConfigInfo.getClientEnterpriseId();
                int signType = ssceContractRecordInfo.getSignType().getValue();
                logger.info("signType is {}, clientEnterpriseId is {}", (Object)signType, (Object)clientEnterpriseId);
                if (this.checkHasSync(ikdContractConfigRecord, ssceContractRecordInfo.getBillId().toString(), signType, clientEnterpriseId)) {
                    logger.info("\u4e19\u65b9\u5408\u540c\u7528\u7ae0\u8bb0\u5f55\u5386\u53f2\u6570\u636e\uff1a{} \u5df2\u540c\u6b65", (Object)ssceContractRecordInfo.getId().toString());
                    continue;
                }
                KDContractConfigRecordInfo kdContractConfigRecordInfo = this.getKDContractConfigRecordFromSSCEContractRecord(ctx, ssceContractRecordInfo, 1);
                kdContractConfigRecordInfo.setLastUpdateTime(ssceContractRecordInfo.getCompanyBSignTime());
                kdContractConfigRecordInfo.setConfig(kdContractConfigInfo);
                kdContractConfigRecordInfo.setEnterpId(kdContractConfigInfo.getClientEnterpriseId());
                kdContractConfigRecordInfo.setEnterpName(kdContractConfigInfo.getEnterpriseName());
                IObjectPK id = ikdContractConfigRecord.addnew(kdContractConfigRecordInfo);
                this.updateLastUpdateTime(ikdContractConfigRecord, ssceContractRecordInfo.getCompanyBSignTime(), id);
                logger.info("\u4e19\u65b9\u5408\u540c\u7528\u7ae0\u8bb0\u5f55\u5386\u53f2\u6570\u636e\uff1a{} \u6dfb\u52a0\u6210\u529f", (Object)ssceContractRecordInfo.getId());
                continue;
            }
            catch (Exception e) {
                logger.error("\u4e19\u65b9\u5408\u540c\u7528\u7ae0\u8bb0\u5f55\u5386\u53f2\u6570\u636e\uff1a{} \u6dfb\u52a0\u5931\u8d25", (Object)ssceContractRecordInfo.getId());
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void updateLastUpdateTime(IKDContractConfigRecord ikdContractConfigRecord, Timestamp timestamp, IObjectPK id) throws EASBizException, BOSException {
        SelectorItemCollection selectorItemForLastUpdateTimeCollection = new SelectorItemCollection();
        selectorItemForLastUpdateTimeCollection.add(new SelectorItemInfo("lastUpdateTime"));
        KDContractConfigRecordInfo kdContractConfigRecordInfoNew = ikdContractConfigRecord.getKDContractConfigRecordInfo("where id = '" + id.toString() + "'");
        kdContractConfigRecordInfoNew.setLastUpdateTime(timestamp);
        ikdContractConfigRecord.updatePartial(kdContractConfigRecordInfoNew, selectorItemForLastUpdateTimeCollection);
    }

    public void syncCertificationRecord(Context ctx) throws BOSException {
        logger.info("start _syncCertificationRecord");
        IKDContractConfigRecord ikdContractConfigRecord = KDContractConfigRecordFactory.getLocalInstance((Context)ctx);
        ISSCEContractRecord issceContractRecord = SSCEContractRecordFactory.getLocalInstance(ctx);
        String sql = "SELECT \nHRCertificationBill.FID as FBOID ,\nKDContractConfig.fid as FCONFIGID ,\nHRCertificationBill.FPERSONID , \nHRCertificationBill.FID as FBOID ,\nKDContractConfig.fid as FCONFIGID ,\nHRCertificationBill.FPERSONID , \nHRCertificationBill.FSIGNNO as FILENO,\nPerson.FNAME_L1 as FPERSONNAME_L1 ,\nPerson.FNAME_L2 as FPERSONNAME_L2 ,\nPerson.FNAME_L3 as FPERSONNAME_L3 ,\nKDContractConfig.FCLIENTENTERPRISEID as FENTERPID ,\nKDContractConfig.FENTERPRISENAME as FENTERPNAME ,\npmUser.FNAME_L1 as FCREATORNAME_L1,\npmUser.FNAME_L2 as FCREATORNAME_L2,\npmUser.FNAME_L3 as FCREATORNAME_L3\nFROM T_HR_HRCertificationBill as HRCertificationBill\ninner join T_CDS_KDContractConfig as KDContractConfig\non KDContractConfig.FLABCONTRACTFIRSTPARTY = HRCertificationBill.FCONTFIRSTPARTYID \ninner join T_BD_Person Person \non Person.FID = HRCertificationBill.FPERSONID \ninner join T_PM_User pmUser\non pmUser.FID = HRCertificationBill.FCREATORID \nwhere HRCertificationBill.FISSIGN = 1\nand HRCertificationBill.FDRAWUPMODE = 2";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        logger.info("certificate history data size is {}", (Object)iRowSet.size());
        block4: while (true) {
            try {
                while (iRowSet.next()) {
                    String fid = null;
                    try {
                        fid = iRowSet.getString("FBOID");
                        if (this.checkHasSync(ikdContractConfigRecord, fid, 0, null)) {
                            logger.info("\u8bc1\u660e\u7528\u7ae0\u8bb0\u5f55\u5386\u53f2\u6570\u636e\uff1a{} \u5df2\u540c\u6b65", (Object)fid);
                            continue;
                        }
                        KDContractConfigRecordInfo kdContractConfigRecordInfo = this.getKDContractConfigRecordFromHRCertificationBill(ctx, iRowSet);
                        Timestamp lastUpdateTime = kdContractConfigRecordInfo.getLastUpdateTime();
                        IObjectPK id = ikdContractConfigRecord.addnew(kdContractConfigRecordInfo);
                        this.updateLastUpdateTime(ikdContractConfigRecord, lastUpdateTime, id);
                        logger.info("\u8bc1\u660e\u7528\u7ae0\u8bb0\u5f55\u5386\u53f2\u6570\u636e\uff1a{} \u6dfb\u52a0\u6210\u529f", (Object)fid);
                        continue block4;
                    }
                    catch (Exception e) {
                        logger.error("\u8bc1\u660e\u7528\u7ae0\u8bb0\u5f55\u5386\u53f2\u6570\u636e\uff1a{} \u6dfb\u52a0\u5931\u8d25", (Object)fid);
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                break;
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
                break;
            }
        }
    }

    public KDContractConfigRecordInfo getKDContractConfigRecordFromSSCEContractRecord(Context ctx, SSCEContractRecordInfo ssceContractRecordInfo, int type) throws EASBizException, BOSException {
        KDContractConfigRecordInfo kdContractConfigRecordInfo = new KDContractConfigRecordInfo();
        String bizBosType = BOSUuid.read((String)ssceContractRecordInfo.getBillId().toString()).getType().toString();
        logger.info("bizBosType is {}", (Object)bizBosType);
        kdContractConfigRecordInfo.setResult(true);
        kdContractConfigRecordInfo.setBizBosType(bizBosType);
        kdContractConfigRecordInfo.setUseBiz("CB88E0A5".equals(bizBosType) ? EElBizType.Other_Contract : EElBizType.Lab_Contract);
        kdContractConfigRecordInfo.setBoId(ssceContractRecordInfo.getBillId());
        kdContractConfigRecordInfo.setPerson(ssceContractRecordInfo.getPerson());
        kdContractConfigRecordInfo.setPreEntryPerson(ssceContractRecordInfo.getPreEntryPerson());
        kdContractConfigRecordInfo.setFileNo(ssceContractRecordInfo.getEContractNO());
        kdContractConfigRecordInfo.setState(BaseItemStateEnum.ENABLE);
        if (null != ssceContractRecordInfo.getPerson()) {
            kdContractConfigRecordInfo.setPersonName(ssceContractRecordInfo.getPerson().getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            kdContractConfigRecordInfo.setPersonName(ssceContractRecordInfo.getPerson().getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            kdContractConfigRecordInfo.setPersonName(ssceContractRecordInfo.getPerson().getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        } else if (null != ssceContractRecordInfo.getPreEntryPerson()) {
            kdContractConfigRecordInfo.setPersonName(ssceContractRecordInfo.getPreEntryPerson().getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            kdContractConfigRecordInfo.setPersonName(ssceContractRecordInfo.getPreEntryPerson().getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            kdContractConfigRecordInfo.setPersonName(ssceContractRecordInfo.getPreEntryPerson().getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        }
        Map<String, Object> map = this.getCreatorInfoByBillId(ctx, ssceContractRecordInfo.getBillId().toString(), type);
        if (map.size() > 0) {
            kdContractConfigRecordInfo.setCreator((UserInfo)map.get("userInfo"));
            PersonInfo person = (PersonInfo)map.get("person");
            kdContractConfigRecordInfo.setCreatorName(person.getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            kdContractConfigRecordInfo.setCreatorName(person.getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            kdContractConfigRecordInfo.setCreatorName(person.getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        }
        kdContractConfigRecordInfo.setEnterpId(ssceContractRecordInfo.getKdContractConfig().getClientEnterpriseId());
        kdContractConfigRecordInfo.setEnterpName(ssceContractRecordInfo.getKdContractConfig().getEnterpriseName());
        kdContractConfigRecordInfo.setCreateTime(HRUtilExtend.getCurTimestamp());
        kdContractConfigRecordInfo.setLastUpdateUser(ssceContractRecordInfo.getLastUpdateUser());
        kdContractConfigRecordInfo.setCU(ssceContractRecordInfo.getCU());
        return kdContractConfigRecordInfo;
    }

    public KDContractConfigRecordInfo getKDContractConfigRecordFromHRCertificationBill(Context ctx, IRowSet iRowSet) throws SQLException, EASBizException, BOSException {
        KDContractConfigRecordInfo kdContractConfigRecordInfo = new KDContractConfigRecordInfo();
        String fboid = iRowSet.getString("FBOID");
        kdContractConfigRecordInfo.setResult(true);
        kdContractConfigRecordInfo.setBizBosType("C84F6BC0");
        kdContractConfigRecordInfo.setUseBiz(EElBizType.Certification);
        kdContractConfigRecordInfo.setBoId(BOSUuid.read((String)fboid));
        KDContractConfigInfo kdContractConfigInfo = new KDContractConfigInfo();
        kdContractConfigInfo.setId(BOSUuid.read((String)iRowSet.getString("FCONFIGID")));
        kdContractConfigRecordInfo.setConfig(kdContractConfigInfo);
        PersonInfo personInfo = new PersonInfo();
        personInfo.setId(BOSUuid.read((String)iRowSet.getString("FPERSONID")));
        kdContractConfigRecordInfo.setPerson(personInfo);
        kdContractConfigRecordInfo.setFileNo(iRowSet.getString("FILENO"));
        kdContractConfigRecordInfo.setState(BaseItemStateEnum.ENABLE);
        kdContractConfigRecordInfo.setPersonName(iRowSet.getString("FPERSONNAME_L1"), LocaleUtils.locale_l1);
        kdContractConfigRecordInfo.setPersonName(iRowSet.getString("FPERSONNAME_L2"), LocaleUtils.locale_l2);
        kdContractConfigRecordInfo.setPersonName(iRowSet.getString("FPERSONNAME_L3"), LocaleUtils.locale_l3);
        Map<String, Object> map = this.getCreatorInfoByBillId(ctx, fboid, 0);
        if (map.size() > 0) {
            kdContractConfigRecordInfo.setCreator((UserInfo)map.get("userInfo"));
            PersonInfo person = (PersonInfo)map.get("person");
            kdContractConfigRecordInfo.setCreatorName(person.getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            kdContractConfigRecordInfo.setCreatorName(person.getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            kdContractConfigRecordInfo.setCreatorName(person.getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            String completeTime = (String)map.get("completeTime");
            kdContractConfigRecordInfo.setCreateTime(HRUtilExtend.getCurTimestamp());
            if (null == completeTime) {
                int index;
                String fileno = iRowSet.getString("FILENO");
                logger.info("fileno is {}", (Object)fileno);
                if (null != fileno && (index = StringUtils.lastOrdinalIndexOf((CharSequence)fileno, (CharSequence)"-", (int)4)) != -1) {
                    fileno = fileno.substring(index + 1);
                    logger.info("fileno_sub is {}", (Object)fileno);
                    String date = fileno.substring(0, fileno.lastIndexOf("-"));
                    String hms = fileno.substring(fileno.lastIndexOf("-") + 1);
                    StringBuffer sb = new StringBuffer(date + " ");
                    for (int i = 0; i < 3; ++i) {
                        sb.append(hms, 2 * i, 2 * i + 2);
                        if (i == 2) continue;
                        sb.append(":");
                    }
                    logger.info("new completeTime is {}", (Object)sb.toString());
                    kdContractConfigRecordInfo.setLastUpdateTime(Timestamp.valueOf(sb.toString()));
                }
            } else {
                kdContractConfigRecordInfo.setLastUpdateTime(Timestamp.valueOf(completeTime));
            }
        }
        kdContractConfigRecordInfo.setEnterpId(iRowSet.getString("FENTERPID"));
        kdContractConfigRecordInfo.setEnterpName(iRowSet.getString("FENTERPNAME"));
        return kdContractConfigRecordInfo;
    }

    public boolean checkHasSync(IKDContractConfigRecord ikdContractConfigRecord, String id, int signType, String clientEnterpriseId) throws EASBizException, BOSException {
        String sql = null;
        sql = signType == 2 ? "where boid = '" + id + "' and enterpId = '" + clientEnterpriseId + "'" : "where boid = '" + id + "'";
        logger.info("sql is {}", (Object)sql);
        return ikdContractConfigRecord.exists(sql);
    }

    public Map<String, Object> getCreatorInfoByBillId(Context ctx, String billId, int type) throws EASBizException, BOSException {
        HashMap<String, String> serviceParam = new HashMap<String, String>();
        serviceParam.put("billId", billId);
        serviceParam.put("type", "3");
        serviceParam.put("selector", "bussAttrID,personnelID.easUserId,completeTme");
        JsonObject result = SSCTaskAppUtil.operateTaskAll((Context)ctx, (String)"GETJOBINFOBYBILLID", serviceParam);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (result.get("dataType") != null && "JsonArray".equals(result.get("dataType").getAsString())) {
            JsonArray data = result.get("data").getAsJsonArray();
            for (int i = 0; i < data.size(); ++i) {
                UserCollection userCollection;
                EntityViewInfo entityViewInfo;
                FilterInfo filterInfo;
                SelectorItemCollection selectorItemCollection;
                String easUserId;
                JsonObject personalObj;
                String completeTme;
                JsonObject dataObj = data.get(i).getAsJsonObject();
                JsonObject bussAttr = dataObj.getAsJsonObject("bussAttrID");
                String bussAttrId = bussAttr.get("id").isJsonNull() ? "" : bussAttr.get("id").getAsString();
                logger.info("bussAttrId is {}", (Object)bussAttrId);
                if (type == 0 && contractBussAttrID.contains(bussAttrId) || certificationBussAttrID.contains(bussAttrId)) {
                    completeTme = dataObj.get("completeTme").isJsonNull() ? null : dataObj.get("completeTme").getAsString();
                    map.put("completeTime", completeTme);
                    logger.error("\u5355\u636e\uff1a{}\uff0c\u5b8c\u6210\u65f6\u95f4\uff1a{}", (Object)billId, (Object)completeTme);
                    personalObj = dataObj.getAsJsonObject("personnelID");
                    easUserId = personalObj.get("easUserId").isJsonNull() ? "" : personalObj.get("easUserId").getAsString();
                    selectorItemCollection = new SelectorItemCollection();
                    selectorItemCollection.add(new SelectorItemInfo("person.*"));
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)easUserId, CompareType.EQUALS));
                    entityViewInfo = new EntityViewInfo();
                    entityViewInfo.setSelector(selectorItemCollection);
                    entityViewInfo.setFilter(filterInfo);
                    userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection(entityViewInfo);
                    if (userCollection.size() <= 0) continue;
                    map.put("userInfo", userCollection.get(0));
                    map.put("person", userCollection.get(0).getPerson());
                    continue;
                }
                if (type == 1 && contractThreeBussAttrID.contains(bussAttrId)) {
                    logger.info("\u4e09\u7b7e");
                    completeTme = dataObj.get("completeTme").isJsonNull() ? null : dataObj.get("completeTme").getAsString();
                    map.put("completeTime", completeTme);
                    logger.error("\u5355\u636e\uff1a{}\uff0c\u5b8c\u6210\u65f6\u95f4\uff1a{}", (Object)billId, (Object)completeTme);
                    personalObj = dataObj.getAsJsonObject("personnelID");
                    easUserId = personalObj.get("easUserId").isJsonNull() ? "" : personalObj.get("easUserId").getAsString();
                    selectorItemCollection = new SelectorItemCollection();
                    selectorItemCollection.add(new SelectorItemInfo("person.*"));
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)easUserId, CompareType.EQUALS));
                    entityViewInfo = new EntityViewInfo();
                    entityViewInfo.setSelector(selectorItemCollection);
                    entityViewInfo.setFilter(filterInfo);
                    userCollection = UserFactory.getLocalInstance((Context)ctx).getUserCollection(entityViewInfo);
                    if (userCollection.size() <= 0) continue;
                    map.put("userInfo", userCollection.get(0));
                    map.put("person", userCollection.get(0).getPerson());
                    continue;
                }
                logger.error("\u4efb\u52a1\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u5355\u636e\uff1a{}\uff0c\u4efb\u52a1\u7c7b\u578b\u4e3a\uff1a{}", (Object)billId, (Object)bussAttrId);
            }
        }
        return map;
    }
}

