/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordCollection;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordFactory;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordCollection;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordFactory;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.util.ContractUtils;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtilsEx;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicOtherContractUtilsEx;
import com.kingdee.eas.hr.emp.ContractClassifyEnum;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeOtherContractCollection;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.hr.emp.IEmployeeOtherContract;
import com.kingdee.eas.hr.emp.LabContractFirstPartyInfo;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.elecontract.EContractSyncFileRecordCollection;
import com.kingdee.shr.elecontract.EContractSyncFileRecordFactory;
import com.kingdee.shr.elecontract.EContractSyncFileRecordInfo;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.app.AbstractEContractSyncFileServiceFacadeControllerBean;
import com.kingdee.shr.elecontract.util.EContractUtils;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EContractSyncFileServiceFacadeControllerBean
extends AbstractEContractSyncFileServiceFacadeControllerBean {
    private static final long serialVersionUID = -2249767290863851578L;
    private static final Logger logger = LoggerFactory.getLogger(EContractSyncFileServiceFacadeControllerBean.class);
    private Map<String, KDContractConfigInfo> kdConctractConfigInfoMap = new Hashtable<String, KDContractConfigInfo>();

    @Override
    protected Object _syncFile(Context ctx, String param) throws BOSException, EASBizException {
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("contractNo"));
            selector.add(new SelectorItemInfo("billId"));
            selector.add(new SelectorItemInfo("entryId"));
            selector.add(new SelectorItemInfo("boId"));
            selector.add(new SelectorItemInfo("isSync"));
            view.setSelector(selector);
            view.setFilter(filter);
            EContractSyncFileRecordCollection syncFileRecordCollection = EContractSyncFileRecordFactory.getLocalInstance(ctx).getEContractSyncFileRecordCollection(view);
            Map<Boolean, Map<String, EContractSyncFileRecordInfo>> sortSyncRecord = this.sortSyncRecord(syncFileRecordCollection);
            Map<String, EContractSyncFileRecordInfo> isSyncMap = sortSyncRecord.get(true);
            Map<String, EContractSyncFileRecordInfo> isNotSyncMap = sortSyncRecord.get(false);
            this.employeeContract(ctx, isSyncMap, isNotSyncMap);
            this.otherContract(ctx, isSyncMap, isNotSyncMap);
            this.empEleContractSignRecord(ctx, isSyncMap, isNotSyncMap);
            this.empOtherEleContractSignRecord(ctx, isSyncMap, isNotSyncMap);
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void employeeContract(Context ctx, Map<String, EContractSyncFileRecordInfo> isSyncMap, Map<String, EContractSyncFileRecordInfo> isNotSyncMap) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isElectronicSign", (Object)true));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("contractNo"));
        selector.add(new SelectorItemInfo("employee.id"));
        selector.add(new SelectorItemInfo("employee.name"));
        selector.add(new SelectorItemInfo("contractTemplet.id"));
        selector.add(new SelectorItemInfo("contractTemplet.isElectronicSign"));
        selector.add(new SelectorItemInfo("labContractFirstParty.id"));
        selector.add(new SelectorItemInfo("labContractFirstParty.name"));
        selector.add(new SelectorItemInfo("preEntryPerson.id"));
        selector.add(new SelectorItemInfo("preEntryPerson.name"));
        selector.add(new SelectorItemInfo("signStatus"));
        selector.add(new SelectorItemInfo("contractClassify"));
        selector.add(new SelectorItemInfo("isElectronicSign"));
        view.setSelector(selector);
        view.setFilter(filter);
        logger.error("EContractSyncFileServiceFacadeControllerBean employeeContract view : " + view.toString());
        EmployeeContractCollection employeeContractCollection = EmployeeContractFactory.getLocalInstance((Context)ctx).getEmployeeContractCollection(view);
        String eContractNo = "";
        for (int dex = 0; dex < employeeContractCollection.size(); ++dex) {
            try {
                eContractNo = "";
                EmployeeContractInfo employeeContractInfo = employeeContractCollection.get(dex);
                String boId = employeeContractInfo.getId().toString();
                boolean isElectronicSign = employeeContractInfo.isIsElectronicSign();
                if (!isElectronicSign) continue;
                String contractNo = employeeContractInfo.getContractNo();
                ContractClassifyEnum contractClassify = employeeContractInfo.getContractClassify();
                if (ContractClassifyEnum.ElectronicEmp.equals((Object)contractClassify)) {
                    if (EContractSignState.complete.equals((Object)employeeContractInfo.getSignStatus())) {
                        eContractNo = EmpElectronicContractUtilsEx.getEContractNOByContractId((Context)ctx, (String)boId);
                    }
                } else {
                    if (!ContractClassifyEnum.ElectronicSsc.equals((Object)contractClassify)) continue;
                    CoreBaseInfo recordByContract = EContractUtils.getSSCEContractRecordByContractNo(ctx, contractNo, null);
                    if (recordByContract != null && recordByContract.getBoolean("isSigned")) {
                        eContractNo = recordByContract.getString("eContractNO");
                    }
                }
                this.syncFile(ctx, boId, eContractNo, employeeContractInfo.getLabContractFirstParty(), isSyncMap, isNotSyncMap);
                continue;
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void otherContract(Context ctx, Map<String, EContractSyncFileRecordInfo> isSyncMap, Map<String, EContractSyncFileRecordInfo> isNotSyncMap) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("contractNo"));
        selector.add(new SelectorItemInfo("employee.id"));
        selector.add(new SelectorItemInfo("employee.name"));
        selector.add(new SelectorItemInfo("contractTemplet.id"));
        selector.add(new SelectorItemInfo("contractTemplet.isElectronicSign"));
        selector.add(new SelectorItemInfo("labContractFirstParty.id"));
        selector.add(new SelectorItemInfo("labContractFirstParty.name"));
        selector.add(new SelectorItemInfo("preEntryPerson.id"));
        selector.add(new SelectorItemInfo("preEntryPerson.name"));
        selector.add(new SelectorItemInfo("signStatus"));
        selector.add(new SelectorItemInfo("contractClassify"));
        filter.getFilterItems().add(new FilterItemInfo("contractTemplet.isElectronicSign", (Object)true));
        view.setSelector(selector);
        view.setFilter(filter);
        logger.error("EContractSyncFileServiceFacadeControllerBean otherContract view : " + view.toString());
        EmployeeOtherContractCollection otherContractCollection = EmployeeOtherContractFactory.getLocalInstance((Context)ctx).getEmployeeOtherContractCollection(view);
        int size = otherContractCollection.size();
        for (int dex = 0; dex < size; ++dex) {
            try {
                EmployeeOtherContractInfo otherContractInfo = otherContractCollection.get(dex);
                boolean isElectronicSign = otherContractInfo.getContractTemplet().isIsElectronicSign();
                if (!isElectronicSign) continue;
                String eContractNo = "";
                String boId = otherContractInfo.getId().toString();
                String contractNo = otherContractInfo.getContractNo();
                ContractClassifyEnum contractClassify = otherContractInfo.getContractClassify();
                logger.error("EContractSyncFileServiceFacadeControllerBean contractClassify : " + contractClassify);
                if (ContractClassifyEnum.ElectronicEmp.equals((Object)contractClassify)) {
                    logger.error("EContractSyncFileServiceFacadeControllerBean signStatus : " + otherContractInfo.getSignStatus() + "    boId:" + boId + "  contractNo" + contractNo);
                    if (EContractSignState.complete.equals((Object)otherContractInfo.getSignStatus())) {
                        eContractNo = EmpElectronicOtherContractUtilsEx.getEContractNOByContractId((Context)ctx, (String)boId);
                    }
                    logger.error("EContractSyncFileServiceFacadeControllerBean Emp_eContractNo : " + eContractNo);
                } else {
                    if (!ContractClassifyEnum.ElectronicSsc.equals((Object)contractClassify)) continue;
                    CoreBaseInfo recordByContract = EContractUtils.getSSCEContractRecordByContractNo(ctx, contractNo, null);
                    if (recordByContract != null && recordByContract.getBoolean("isSigned")) {
                        eContractNo = recordByContract.getString("eContractNO");
                    }
                }
                this.syncFile(ctx, boId, eContractNo, otherContractInfo.getLabContractFirstParty(), isSyncMap, isNotSyncMap);
                continue;
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void empEleContractSignRecord(Context ctx, Map<String, EContractSyncFileRecordInfo> isSyncMap, Map<String, EContractSyncFileRecordInfo> isNotSyncMap) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("contract.id"));
        selector.add(new SelectorItemInfo("contractNO"));
        selector.add(new SelectorItemInfo("eContractNO"));
        selector.add(new SelectorItemInfo("person.id"));
        selector.add(new SelectorItemInfo("person.name"));
        selector.add(new SelectorItemInfo("preEntryPerson.id"));
        selector.add(new SelectorItemInfo("preEntryPerson.name"));
        selector.add(new SelectorItemInfo("signStatus"));
        view.setSelector(selector);
        view.setFilter(filter);
        logger.error("EContractSyncFileServiceFacadeControllerBean empEleContractSignRecord view : " + view.toString());
        EmpEleContractSignRecordCollection SignRecordCollection = EmpEleContractSignRecordFactory.getLocalInstance((Context)ctx).getEmpEleContractSignRecordCollection(view);
        for (int dex = 0; dex < SignRecordCollection.size(); ++dex) {
            try {
                EmpEleContractSignRecordInfo empEleContractSignRecordInfo = SignRecordCollection.get(dex);
                if (!EContractSignState.complete.equals((Object)empEleContractSignRecordInfo.getSignStatus())) continue;
                String boId = empEleContractSignRecordInfo.getId().toString();
                String eContractNO = empEleContractSignRecordInfo.getEContractNO();
                EmployeeContractInfo employeeContractInfo = ContractUtils.getEmployeeContractInfo((Context)ctx, (String)empEleContractSignRecordInfo.getContract().getId().toString());
                this.syncFile(ctx, boId, eContractNO, employeeContractInfo.getLabContractFirstParty(), isSyncMap, isNotSyncMap);
                continue;
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void empOtherEleContractSignRecord(Context ctx, Map<String, EContractSyncFileRecordInfo> isSyncMap, Map<String, EContractSyncFileRecordInfo> isNotSyncMap) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("contract.id"));
        selector.add(new SelectorItemInfo("contractNO"));
        selector.add(new SelectorItemInfo("eContractNO"));
        selector.add(new SelectorItemInfo("person.id"));
        selector.add(new SelectorItemInfo("person.name"));
        selector.add(new SelectorItemInfo("preEntryPerson.id"));
        selector.add(new SelectorItemInfo("preEntryPerson.name"));
        selector.add(new SelectorItemInfo("signStatus"));
        view.setSelector(selector);
        view.setFilter(filter);
        logger.error("EContractSyncFileServiceFacadeControllerBean empOtherEleContractSignRecord view : " + view.toString());
        EmpOtherEleContractSignRecordCollection SignRecordCollection = EmpOtherEleContractSignRecordFactory.getLocalInstance((Context)ctx).getEmpOtherEleContractSignRecordCollection(view);
        for (int dex = 0; dex < SignRecordCollection.size(); ++dex) {
            try {
                EmpOtherEleContractSignRecordInfo empOtherEleContractSignRecordInfo = SignRecordCollection.get(dex);
                if (!EContractSignState.complete.equals((Object)empOtherEleContractSignRecordInfo.getSignStatus())) continue;
                String boId = empOtherEleContractSignRecordInfo.getId().toString();
                String eContractNO = empOtherEleContractSignRecordInfo.getEContractNO();
                EmployeeOtherContractInfo employeeOtherContractInfo = EmpElectronicOtherContractUtilsEx.getEmployeeOtherContractInfo((IEmployeeOtherContract)EmployeeOtherContractFactory.getLocalInstance((Context)ctx), (String)empOtherEleContractSignRecordInfo.getContract().getId().toString());
                this.syncFile(ctx, boId, eContractNO, employeeOtherContractInfo.getLabContractFirstParty(), isSyncMap, isNotSyncMap);
                continue;
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                continue;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncFile(Context ctx, String boId, String eContractNo, LabContractFirstPartyInfo labContractFirstParty, Map<String, EContractSyncFileRecordInfo> isSyncMap, Map<String, EContractSyncFileRecordInfo> isNotSyncMap) throws BOSException, EASBizException {
        KDContractConfigInfo kdConcfigInfo;
        if (StringUtils.isEmpty((String)eContractNo)) {
            return;
        }
        if (isSyncMap.containsKey(boId)) {
            return;
        }
        if (labContractFirstParty == null) {
            return;
        }
        EContractSyncFileRecordInfo syncFileRecordInfo = isNotSyncMap.get(boId);
        if (syncFileRecordInfo == null) {
            syncFileRecordInfo = new EContractSyncFileRecordInfo();
        }
        if ((kdConcfigInfo = this.getKDContractConfigInfo(ctx, labContractFirstParty.getId().toString())) == null) {
            logger.error("EContractSyncFileServiceFacadeControllerBean syncFile kdConcfigInfo == null : " + labContractFirstParty.getId().toString());
            return;
        }
        syncFileRecordInfo.setBoId(BOSUuid.read((String)boId));
        syncFileRecordInfo.setKdConfinId(kdConcfigInfo.getId());
        syncFileRecordInfo.setContractNo(eContractNo);
        byte[] byteData = null;
        String filename = null;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("isDefault", "-11");
        dataMap.put("contractNo", eContractNo);
        dataMap.put("kdContractConfigId", kdConcfigInfo.getId().toString());
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        JSONObject result = (JSONObject)osfServiceFacade.processService("electronicLaborRefreshLocalService", dataMap);
        int resultCode = result.getIntValue("code");
        if (resultCode == 0) {
            JSONArray resultData = result.getJSONArray("data");
            if (resultData != null && resultData.size() > 0) {
                InputStream inputStream = null;
                try {
                    JSONObject sealInfo = resultData.getJSONObject(0).getJSONObject("sealInfo");
                    String downloadUrl = sealInfo.getString("downloadUrl");
                    URL httpUrl = new URL(downloadUrl);
                    HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
                    conn.setConnectTimeout(120000);
                    inputStream = conn.getInputStream();
                    byteData = EContractSyncFileServiceFacadeControllerBean.readInputStream(inputStream);
                    filename = eContractNo + ".pdf";
                    SHRAttachmentExtInfo saveAttachment = ElectronicContractUtils.saveAttachment(ctx, boId, filename, byteData, null);
                    logger.error("EContractSyncFileServiceFacadeControllerBean syncFile saveAttachment : " + saveAttachment.getAttachment().getId().toString());
                    syncFileRecordInfo.setAttachmentId(saveAttachment.getAttachment().getId());
                    syncFileRecordInfo.setIsSync(true);
                    EContractSyncFileRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)syncFileRecordInfo);
                }
                catch (MalformedURLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                finally {
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            return;
        }
    }

    public KDContractConfigInfo getKDContractConfigInfo(Context ctx, String labFirstInfoId) throws BOSException {
        KDContractConfigInfo configInfo = this.kdConctractConfigInfoMap.get(labFirstInfoId);
        if (configInfo == null && (configInfo = ElectronicContractUtils.getKDContractConfigByLabContractFirstParty(ctx, labFirstInfoId)) != null) {
            this.kdConctractConfigInfoMap.put(labFirstInfoId, configInfo);
        }
        return configInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readInputStream(InputStream inputStream) throws BOSException, EASBizException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return bos.toByteArray();
    }

    public SHRAttachmentExtInfo saveAttachment(Context ctx, String boID, String fullname, byte[] filedata) throws BOSException, EASBizException {
        fullname = this.checkScriptAttack(fullname);
        String mainname = fullname.substring(0, fullname.lastIndexOf(46));
        String extname = fullname.substring(fullname.lastIndexOf(46) + 1, fullname.length());
        extname = extname.toLowerCase();
        SHRAttachmentExtInfo attchExt = new SHRAttachmentExtInfo();
        AttachmentInfo ai = new AttachmentInfo();
        BoAttchAssoInfo boAttchAssoInfo = new BoAttchAssoInfo();
        Locale locale_en_US = LocaleUtils.locale_en_US;
        Locale locale_zh_CN = LocaleUtils.locale_zh_CN;
        Locale locale_zh_TW = LocaleUtils.locale_zh_TW;
        ai.setName(mainname, locale_en_US);
        ai.setName(mainname, locale_zh_CN);
        ai.setName(mainname, locale_zh_TW);
        ai.setSimpleName(extname);
        ai.setDescription("");
        ai.setFile(filedata);
        ai.setIsShared(false);
        String label26 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label26", (Context)ctx);
        ai.setSharedDesc(label26);
        int size = filedata.length;
        if (size < 1024) {
            String label27 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label27", (Context)ctx);
            String realObj = MessageFormat.format(label27, size);
            ai.setSize(realObj);
        } else {
            ai.setSize(size / 1024 + "KB");
        }
        ai.setSizeInByte(size);
        ai.setAttachID("" + System.currentTimeMillis());
        String label28 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label28", (Context)ctx);
        ai.setType(label28);
        attchExt.setAttachment(ai);
        attchExt.setName(fullname, locale_en_US);
        attchExt.setName(fullname, locale_zh_CN);
        attchExt.setName(fullname, locale_zh_TW);
        attchExt.setPropertyName("null0");
        attchExt.setType(AttachmentTypeEnum.PROPERTY);
        attchExt.setState(AttachmentState.SAVE);
        attchExt.setBoID(boID);
        boAttchAssoInfo.setBoID(boID);
        boAttchAssoInfo.setAssoBusObjType(String.valueOf(BOSUuid.getBOSObjectType((String)boID, (boolean)true)));
        boAttchAssoInfo.setAssoType("Added Accessories");
        boAttchAssoInfo.setAttachment(ai);
        try {
            IAttachment attachment = AttachmentFactory.getLocalInstance((Context)ctx);
            IBoAttchAsso attchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
            attachment.addnew(ai);
            attchAsso.addnew(boAttchAssoInfo);
            shrAttchExt.addnew((CoreBaseInfo)attchExt);
            return attchExt;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String label29 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label29", (Context)ctx);
            String label30 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label30", (Context)ctx);
            String label31 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label31", (Context)ctx);
            String label32 = SHRServerResource.getString((String)"com.kingdee.shr.econtractservice.EcontractserviceServerResource", (String)"label32", (Context)ctx);
            throw new BOSException(label29 + "\uff1a\n1\u3001" + label30 + "\uff1b\n2\u3001" + label31 + "\uff1b\n3\u3001" + label32 + "\u3002");
        }
    }

    protected String checkScriptAttack(String str) {
        if (!StringUtils.isEmpty((String)str)) {
            if (str.contains("<")) {
                str = str.replaceAll("<", "&lt;");
            }
            if (str.contains(">")) {
                str = str.replaceAll(">", "&gt;");
            }
        }
        return str;
    }

    public Map<Boolean, Map<String, EContractSyncFileRecordInfo>> sortSyncRecord(EContractSyncFileRecordCollection syncFileRecordCollection) throws BOSException, EASBizException {
        HashMap<String, EContractSyncFileRecordInfo> isSyncMap = new HashMap<String, EContractSyncFileRecordInfo>();
        HashMap<String, EContractSyncFileRecordInfo> isNotSyncMap = new HashMap<String, EContractSyncFileRecordInfo>();
        for (int dex = 0; dex < syncFileRecordCollection.size(); ++dex) {
            EContractSyncFileRecordInfo syncFileRecordInfo = syncFileRecordCollection.get(dex);
            BOSUuid billId = syncFileRecordInfo.getBillId();
            BOSUuid entryId = syncFileRecordInfo.getEntryId();
            BOSUuid boId = syncFileRecordInfo.getBoId();
            String key = null;
            if (boId != null) {
                key = boId.toString();
            } else if (billId != null) {
                key = billId.toString();
                if (entryId != null) {
                    key = billId.toString() + "+" + entryId.toString();
                }
            }
            if (StringUtils.isEmpty((String)key)) continue;
            if (syncFileRecordInfo.isIsSync()) {
                isSyncMap.put(key, syncFileRecordInfo);
                continue;
            }
            isNotSyncMap.put(key, syncFileRecordInfo);
        }
        HashMap<Boolean, Map<String, EContractSyncFileRecordInfo>> res = new HashMap<Boolean, Map<String, EContractSyncFileRecordInfo>>();
        res.put(true, isSyncMap);
        res.put(false, isNotSyncMap);
        return res;
    }
}

