/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.app;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.elecontract.ElecontractException_880;
import com.kingdee.shr.elecontract.IKDContractConfig;
import com.kingdee.shr.elecontract.IKDContractConfigAuthRecord;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordCollection;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordFactory;
import com.kingdee.shr.elecontract.KDContractConfigAuthRecordInfo;
import com.kingdee.shr.elecontract.KDContractConfigFactory;
import com.kingdee.shr.elecontract.KDContractConfigInfo;
import com.kingdee.shr.elecontract.KDManageType;
import com.kingdee.shr.elecontract.app.AbstractKDContractConfigAuthRecordFacadeControllerBean;
import com.kingdee.shr.elecontract.app.KDContractConfigAuthRecordState;
import com.kingdee.shr.elecontract.util.CloudServiceUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KDContractConfigAuthRecordFacadeControllerBean
extends AbstractKDContractConfigAuthRecordFacadeControllerBean {
    private static final Logger logger = LoggerFactory.getLogger(KDContractConfigAuthRecordFacadeControllerBean.class);

    @Override
    protected Map _optAuthRecord(Context ctx, Map param) throws BOSException, EASBizException {
        try {
            HashMap<String, Object> data = new HashMap<String, Object>();
            String kdContractConfigid = (String)param.get("id");
            String clientEnterpriseId = (String)param.get("clientEnterpriseId");
            String authId = (String)param.get("authId");
            String authType = (String)param.get("authType");
            IKDContractConfigAuthRecord ikdContractConfigAuthRecord = KDContractConfigAuthRecordFactory.getLocalInstance(ctx);
            KDContractConfigAuthRecordInfo authRecordInfo = null;
            if (!StringUtils.isEmpty((String)authId)) {
                authRecordInfo = ikdContractConfigAuthRecord.getKDContractConfigAuthRecordInfo("where id = '" + authId + "'");
            } else {
                KDContractConfigAuthRecordCollection authRecordColls = ikdContractConfigAuthRecord.getKDContractConfigAuthRecordCollection("where config.id = '" + kdContractConfigid + "' and enterpId = '" + clientEnterpriseId + "'");
                authRecordInfo = authRecordColls.get(0);
            }
            if (authRecordInfo != null) {
                KDContractConfigAuthRecordState state = authRecordInfo.getState();
                String authFileNo = authRecordInfo.getAuthFileNo();
                if ("1".equals(authType)) {
                    String url = authRecordInfo.getAuthUrl();
                    if (KDContractConfigAuthRecordState.Unauthorized.equals((Object)state) && !StringUtils.isEmpty((String)authFileNo) && !StringUtils.isEmpty((String)url)) {
                        data.put("result", true);
                        data.put("authFileNo", authFileNo);
                        data.put("url", url);
                        return data;
                    }
                    if (KDContractConfigAuthRecordState.AuthFailed.equals((Object)state) && !StringUtils.isEmpty((String)authFileNo) && !StringUtils.isEmpty((String)url)) {
                        return this.assembleAuthRecord(ctx, authRecordInfo, kdContractConfigid, "1", "2");
                    }
                    if (KDContractConfigAuthRecordState.Authorized.equals((Object)state)) {
                        data.put("result", false);
                        String label1 = SHRServerResource.getString((String)"com.kingdee.shr.elecontract.EleContractResource_880", (String)"label1", (Context)ctx);
                        data.put("msg", label1);
                        return data;
                    }
                    return this.assembleAuthRecord(ctx, authRecordInfo, kdContractConfigid, "1", "1");
                }
                String url = authRecordInfo.getCancelAuthUrl();
                if (KDContractConfigAuthRecordState.Authorized.equals((Object)state) && !StringUtils.isEmpty((String)authFileNo) && !StringUtils.isEmpty((String)url)) {
                    data.put("result", true);
                    data.put("authFileNo", authFileNo);
                    data.put("url", url);
                    return data;
                }
                if (KDContractConfigAuthRecordState.Unauthorized.equals((Object)state)) {
                    data.put("result", false);
                    String label2 = SHRServerResource.getString((String)"com.kingdee.shr.elecontract.EleContractResource_880", (String)"label2", (Context)ctx);
                    data.put("msg", label2);
                    return data;
                }
                if (KDContractConfigAuthRecordState.AuthFailed.equals((Object)state) && !StringUtils.isEmpty((String)authFileNo) && !StringUtils.isEmpty((String)url)) {
                    return this.assembleAuthRecord(ctx, authRecordInfo, kdContractConfigid, "2", "2");
                }
                return this.assembleAuthRecord(ctx, authRecordInfo, kdContractConfigid, "2", "1");
            }
            authRecordInfo = new KDContractConfigAuthRecordInfo();
            authRecordInfo.setState(KDContractConfigAuthRecordState.Unauthorized);
            return this.assembleAuthRecord(ctx, authRecordInfo, kdContractConfigid, "1", "1");
        }
        catch (EASBizException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public Map<String, Object> assembleAuthRecord(Context ctx, KDContractConfigAuthRecordInfo authRecordInfo, String kdContractConfigId, String authType, String isFailed) throws BOSException, EASBizException {
        logger.info("authType is " + authType + " isFailed is " + isFailed);
        IKDContractConfig ikdContractConfig = KDContractConfigFactory.getLocalInstance(ctx);
        KDContractConfigInfo kdContractConfigInfo = ikdContractConfig.getKDContractConfigInfo((IObjectPK)new ObjectUuidPK(kdContractConfigId));
        authRecordInfo.setConfig(kdContractConfigInfo);
        authRecordInfo.setEnterpId(kdContractConfigInfo.getClientEnterpriseId());
        if (KDManageType.LEGALPERSON.equals((Object)kdContractConfigInfo.getManageType())) {
            authRecordInfo.setAuthPersonName(kdContractConfigInfo.getEnterpriseLegal());
            authRecordInfo.setAuthPersonCell(kdContractConfigInfo.getMobile());
            authRecordInfo.setAuthPersonNo(kdContractConfigInfo.getIdCardNO());
        } else {
            authRecordInfo.setAuthPersonName(kdContractConfigInfo.getAgentLinkMan());
            authRecordInfo.setAuthPersonCell(kdContractConfigInfo.getAgentMobile());
            authRecordInfo.setAuthPersonNo(kdContractConfigInfo.getAgentIdentity());
        }
        HashMap<String, String> osfDataMap = new HashMap<String, String>();
        osfDataMap.put("kDContractConfigId", kdContractConfigInfo.getId().toString());
        osfDataMap.put("userId", kdContractConfigInfo.getClientEnterpriseId());
        osfDataMap.put("authType", authType);
        String notifyUrl = CloudServiceUtil.getServiceUrl(ctx, "BASE") + "/kdcontract/kdcontract/authSignCallback";
        osfDataMap.put("notifyUrl", notifyUrl);
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        JSONObject result = (JSONObject)osfServiceFacade.processService("electronicLaborGetAuthSignURLService", osfDataMap);
        int code = result.getIntValue("code");
        if (code == 0) {
            JSONObject dataObj = result.getJSONObject("data");
            String contractNo = dataObj.getString("contractNo");
            if (!StringUtils.isEmpty((String)contractNo)) {
                authRecordInfo.setAuthFileNo(contractNo);
            }
            String authSignURL = dataObj.getString("authSignURL");
            if ("1".equals(authType)) {
                authRecordInfo.setSendAuthTime(new Timestamp(System.currentTimeMillis()));
                authRecordInfo.setAuthUrl(authSignURL);
            } else {
                authRecordInfo.setSendCancelAuthTime(new Timestamp(System.currentTimeMillis()));
                authRecordInfo.setCancelAuthUrl(authSignURL);
            }
            if ("2".equals(isFailed)) {
                authRecordInfo.setState(KDContractConfigAuthRecordState.Unauthorized);
                authRecordInfo.setErrorMsg(null);
            }
            KDContractConfigAuthRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)authRecordInfo);
            HashMap<String, Object> data = new HashMap<String, Object>(3);
            data.put("result", true);
            data.put("authFileNo", contractNo);
            data.put("url", authSignURL);
            return data;
        }
        throw new ElecontractException_880(ElecontractException_880.GET_AUTHSIGNURL_ERROR, new Object[]{code + " : " + result.getString("msg")});
    }
}

