/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.hr.contract.ContractBillMiddleCollection;
import com.kingdee.eas.hr.contract.ContractBillMiddleFactory;
import com.kingdee.eas.hr.contract.ContractBillMiddleInfo;
import com.kingdee.eas.hr.contract.ElectronicContractRelationCollection;
import com.kingdee.eas.hr.contract.ElectronicContractRelationFactory;
import com.kingdee.eas.hr.contract.ElectronicContractRelationInfo;
import com.kingdee.eas.hr.contract.IElectronicContractRelation;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateCollection;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateFactory;
import com.kingdee.eas.hr.contract.SHRElectronicTemplateInfo;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtilsEx;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.shr.elecontract.util.ElectronicContractUtils;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EContractReflectParamInfoService
implements Serializable {
    private static final long serialVersionUID = 8327600905050696596L;
    private static final Logger logger = LoggerFactory.getLogger(EContractReflectParamInfoService.class);

    public Map<String, Object> reflectTempLateParam(Context ctx, String contractNo, Map<String, Object> dataMap) {
        String signatureShowTime = "2";
        String writingTrack = "0";
        try {
            ContractBillMiddleInfo info = EContractReflectParamInfoService.getContractBillMiddleInfo(ctx, contractNo);
            ContractTempletInfo contractTemplet = info.getContractTemplet();
            SHRElectronicTemplateInfo templateInfo = EContractReflectParamInfoService.getSHRElectronicTemplateInfo(ctx, contractTemplet.getId().toString());
            logger.error("EContractReflectParamInfoService reflectTempLateParam");
            if (templateInfo != null) {
                logger.error("EContractReflectParamInfoService reflectTempLateParam templateInfo : " + templateInfo.getId().toString());
                if (templateInfo.isIsSignatureShowTime()) {
                    signatureShowTime = "1";
                }
                if (templateInfo.isIsWritingTrack()) {
                    writingTrack = "1";
                }
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        dataMap.put("signatureShowTime", signatureShowTime);
        dataMap.put("writingTrack", writingTrack);
        return dataMap;
    }

    public Map<String, Object> reflectSignParam(Context ctx, String contractNo, Map<String, Object> dataMap) {
        boolean acrosspageSign = false;
        String signatureShowTime = "2";
        try {
            ContractBillMiddleInfo info = EContractReflectParamInfoService.getContractBillMiddleInfo(ctx, contractNo);
            ContractTempletInfo contractTemplet = info.getContractTemplet();
            SHRElectronicTemplateInfo templateInfo = EContractReflectParamInfoService.getSHRElectronicTemplateInfo(ctx, contractTemplet.getId().toString());
            logger.error("EContractReflectParamInfoService reflectSignParam");
            if (templateInfo != null) {
                logger.error("EContractReflectParamInfoService reflectSignParam templateInfo : " + templateInfo.getId().toString());
                if (templateInfo.isAcrosspageSign()) {
                    acrosspageSign = true;
                }
                if (templateInfo.isIsSignatureShowTime()) {
                    signatureShowTime = "1";
                }
            }
            IElectronicContractRelation electronicContractRelation = ElectronicContractRelationFactory.getLocalInstance((Context)ctx);
            ElectronicContractRelationCollection coll = electronicContractRelation.getElectronicContractRelationCollection("select id, contractId, pageCount where contractId = '" + contractNo + "'");
            ElectronicContractRelationInfo relation = null;
            if (coll.size() > 0) {
                relation = coll.get(0);
            }
            if (relation != null && relation.get("pageCount") != null && relation.getPageCount() <= 1) {
                acrosspageSign = false;
            }
        }
        catch (BOSException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        dataMap.put("acrosspageSign", acrosspageSign);
        dataMap.put("signatureShowTime", signatureShowTime);
        return dataMap;
    }

    public static SHRElectronicTemplateInfo getSHRElectronicTemplateInfo(Context ctx, String contractTempletId) throws BOSException {
        SelectorItemCollection selectorColl = new SelectorItemCollection();
        selectorColl.add(new SelectorItemInfo("isSignatureShowTime"));
        selectorColl.add(new SelectorItemInfo("isWritingTrack"));
        selectorColl.add(new SelectorItemInfo("acrosspageSign"));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractTemplet.id", (Object)contractTempletId));
        entityViewInfo.setFilter(filterInfo);
        entityViewInfo.setSelector(selectorColl);
        SHRElectronicTemplateCollection colls = SHRElectronicTemplateFactory.getLocalInstance((Context)ctx).getSHRElectronicTemplateCollection(entityViewInfo);
        if (colls != null && colls.size() > 0) {
            return colls.get(0);
        }
        return null;
    }

    public static ContractBillMiddleInfo getContractBillMiddleInfo(Context ctx, String contractNo) throws BOSException {
        ContractBillMiddleInfo contractBillMiddleInfo = null;
        String realContractNo = EmpElectronicContractUtilsEx.getRealContractNo((Context)ctx, (String)contractNo);
        if (StringUtils.isEmpty((String)realContractNo)) {
            realContractNo = ElectronicContractUtils.getRealContractNo(contractNo);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("contractNo", (Object)realContractNo));
        view.setFilter(filterInfo);
        SelectorItemCollection selectorCollection = EContractReflectParamInfoService.getSelectorCollection();
        view.setSelector(selectorCollection);
        ContractBillMiddleCollection contractBillMiddleCollection = ContractBillMiddleFactory.getLocalInstance((Context)ctx).getContractBillMiddleCollection(view);
        if (contractBillMiddleCollection != null && contractBillMiddleCollection.size() > 0) {
            contractBillMiddleInfo = contractBillMiddleCollection.get(0);
        }
        return contractBillMiddleInfo;
    }

    public static SelectorItemCollection getSelectorCollection() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("contractType.id"));
        selector.add(new SelectorItemInfo("contractType.name"));
        selector.add(new SelectorItemInfo("contractType.number"));
        selector.add(new SelectorItemInfo("contractTemplet.id"));
        selector.add(new SelectorItemInfo("contractTemplet.name"));
        selector.add(new SelectorItemInfo("contractTemplet.number"));
        selector.add(new SelectorItemInfo("labContractFirstParty.id"));
        selector.add(new SelectorItemInfo("labContractFirstParty.name"));
        selector.add(new SelectorItemInfo("labContractFirstParty.number"));
        return selector;
    }
}

