/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.elecontract.util;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.cloudservice.CloudServiceException;
import com.kingdee.util.StringUtils;
import java.util.Hashtable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSPServerInstance {
    private static Logger logger = LoggerFactory.getLogger(TSPServerInstance.class);
    public static final String SERVERURL = "SERVERURL";
    public static final String TOKEN = "access_token";
    public static final String SERVICEID = "service_id";
    public static final String ENTITYOBJ = "entityobject";
    public static final String MODE = "testmode";
    public static final String RECORDID = "recordId";
    public static final String VALID = "valid";
    public static final int DEFAULT_PROMODE = 1;

    public static Map<String, String> getServerInfo(Context ctx) throws Exception {
        Hashtable<String, String> TSPSERVER = new Hashtable<String, String>();
        String sql = "select * from T_HR_TSPSERVERINFO ";
        String sqlCloudServer = "select * from T_CDS_CloudServiceConfig";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        IRowSet rsCloudServer = DbUtil.executeQuery((Context)ctx, (String)sqlCloudServer);
        int defaultMode = 0;
        try {
            if (rs.next()) {
                defaultMode = rs.getInt(MODE);
                if (defaultMode == 1) {
                    if (rsCloudServer.next()) {
                        String serverId = rsCloudServer.getString("FServiceID");
                        String token = rsCloudServer.getString("FAccessToken");
                        logger.error("Get official serverid synchronously with TSP:" + serverId + "==token:" + token);
                        TSPSERVER.put(SERVICEID, serverId);
                        TSPSERVER.put(TOKEN, token);
                    }
                } else {
                    String serverId = rs.getString(SERVICEID);
                    String token = rs.getString(TOKEN);
                    logger.error("Get official serverid synchronously with TSP:" + serverId + "==token:" + token);
                    TSPSERVER.put(TOKEN, rs.getString(TOKEN));
                    TSPSERVER.put(SERVICEID, rs.getString(SERVICEID));
                }
                if (StringUtils.isEmpty((String)rs.getString(SERVERURL))) {
                    throw new CloudServiceException(CloudServiceException.PLEASE_CONFIG_TSP_SERVER_INFO);
                }
                TSPSERVER.put(SERVERURL, rs.getString(SERVERURL));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return TSPSERVER;
    }
}

