/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.emplightapp.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.costbudget.StaffingChannel;
import com.kingdee.shr.costbudget.StaffingCollection;
import com.kingdee.shr.costbudget.StaffingFactory;
import com.kingdee.shr.emplightapp.app.AbstractBriefAffairFacadeControllerBean;
import com.kingdee.shr.emplightapp.logicservices.CommonCodeMethods;
import com.kingdee.shr.emplightapp.logicservices.EmpStrategyActualStaffPageService;
import com.kingdee.shr.emplightapp.logicservices.EmpStrategyEnrollPageService;
import com.kingdee.shr.emplightapp.logicservices.EmpStrategyResignPageService;
import com.kingdee.shr.emplightapp.util.BriefUtil;
import com.kingdee.shr.manager.HRAffairException;
import com.kingdee.shr.manager.util.HRManagerUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.staffcontrol.IStaffManageFacade;
import com.kingdee.shr.staffcontrol.StaffManageFacadeFactory;
import com.kingdee.shr.staffcontrol.StaffManageOrgSubInfoDTO;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BriefAffairFacadeControllerBean
extends AbstractBriefAffairFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.emplightapp.app.BriefAffairFacadeControllerBean");
    public static final String initPersonBizDefine = "P/OSDCPfQXqU0TB/LQoA6uZovtk=";
    private static Map<String, Object> empStrategyMap;

    public BriefAffairFacadeControllerBean() {
        empStrategyMap = new HashMap<String, Object>();
        empStrategyMap.put("1", EmpStrategyActualStaffPageService.class.getName());
        empStrategyMap.put("2", EmpStrategyEnrollPageService.class.getName());
        empStrategyMap.put("3", EmpStrategyResignPageService.class.getName());
    }

    @Override
    protected Map _getActualStaffing(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int actualStaffing = 0;
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        StringBuffer sql = new StringBuffer("select count(emprelation.fpersonid) actualStaffing").append(" from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid ").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                actualStaffing = rowSet.getInt("actualStaffing");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        map.put("actualStaffing", actualStaffing);
        return map;
    }

    @Override
    protected Map _getDirectActualStaffing(Context ctx, String orgId) throws BOSException, EASBizException {
        HashMap<String, Integer> directActualStaffingMap = new HashMap<String, Integer>();
        int directActualStaffing = 0;
        try {
            StringBuffer actualStaffingSql = new StringBuffer("select count(emprelation.fpersonid) actualStaffing").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1");
            IRowSet actualStaffingSet = DbUtil.executeQuery((Context)ctx, (String)actualStaffingSql.toString());
            while (actualStaffingSet.next()) {
                directActualStaffing = actualStaffingSet.getInt("actualStaffing");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        directActualStaffingMap.put("directActualStaffing", directActualStaffing);
        return directActualStaffingMap;
    }

    @Override
    protected Map _getAvaliableStaffing(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int year = DateTimeUtils.getYear((Date)new Date());
        int channel = this.getStaffingChannel(ctx, year);
        if (channel == 0) {
            return map;
        }
        int actualStaffing = (Integer)this._getActualStaffing(ctx, orgId, permItemId).get("actualStaffing");
        int staffingOrg = this.getStaffingOrg(ctx, orgId, channel);
        int onWayPersonCount = this.getOnWayPersoncount(ctx, orgId, permItemId);
        int avaliableStaffing = staffingOrg - actualStaffing - onWayPersonCount;
        map.put("avaliableStaffing", avaliableStaffing);
        return map;
    }

    protected Map _getAvaliableStaffManage(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int year = DateTimeUtils.getYear((Date)new Date());
        List<Integer> channels = this.getStaffManageChannels(ctx, year);
        if (channels == null || channels.size() == 0) {
            return map;
        }
        int actualStaffing = (Integer)this._getActualStaffing(ctx, orgId, permItemId).get("actualStaffing");
        Map orgStaffMap = StaffManageFacadeFactory.getLocalInstance((Context)ctx).getOrgStaffMap(orgId, this.listToStr(channels), new Date(), 1);
        int orgSubStaff = orgStaffMap.get(orgId) == null ? 0 : (Integer)orgStaffMap.get(orgId);
        int onWayPersonCount = this.getOnWayPersoncount(ctx, orgId, permItemId);
        int avaliableStaffing = orgSubStaff - actualStaffing - onWayPersonCount;
        map.put("avaliableStaffing", avaliableStaffing);
        return map;
    }

    protected List<Integer> getStaffManageChannels(Context ctx, int year) throws BOSException, EASBizException {
        ArrayList<Integer> channels = new ArrayList<Integer>();
        boolean haveYearChannel = false;
        String staffChannelSQL = "select fchannel from T_HR_StaffManageProject where fyear = ? and fstate = 1 group by fchannel order by fchannel desc";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)staffChannelSQL, (Object[])new Object[]{year + ""});
        try {
            while (rowSet.next()) {
                int channelVal = rowSet.getInt("fchannel");
                if (channelVal == 1) {
                    haveYearChannel = true;
                    continue;
                }
                channels.add(channelVal);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        if (haveYearChannel) {
            channels.add(0, 1);
        }
        return channels;
    }

    private String listToStr(List<Integer> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        String str = "";
        for (Integer value : list) {
            str = str + String.valueOf(value) + ",";
        }
        return str.substring(0, str.length() - 1);
    }

    @Override
    protected Map _getStaffingOrg(Context ctx, String orgId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getSubStaffing(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        boolean useOldStaff = StaffManageFacadeFactory.getLocalInstance((Context)ctx).useOldStaff();
        if (!useOldStaff) {
            return this._getSubStaffManage(ctx, orgId, permItemId);
        }
        HashMap subStaffingMap = new HashMap();
        int year = DateTimeUtils.getYear((Date)new Date());
        int channel = this.getStaffingChannel(ctx, year);
        if (channel == 0) {
            return subStaffingMap;
        }
        ArrayList list = new ArrayList();
        this.getDirectStaffing(ctx, orgId, list, channel);
        String tempTableName = BriefUtil.createTempTable(ctx, orgId, permItemId);
        try {
            Map subActualStaffingMap = this.getSubActualStaffing(ctx, orgId, tempTableName, permItemId);
            Map subStaffingOrgMap = this.getSubStaffingOrg(ctx, orgId, tempTableName, channel, permItemId);
            Map subOnWayPersoncountMap = this.getSubOnWayPersoncount(ctx, orgId, tempTableName, permItemId);
            StringBuffer sql = new StringBuffer("select fid,fname,fisleaf from ").append(tempTableName).append(" order by flongnumber asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String adminOrgId = rowSet.getString("fid");
                String adminOrgName = rowSet.getString("fname");
                boolean isLeaf = rowSet.getBoolean("fisleaf");
                boolean includeSub = !isLeaf;
                int subActualStaffing = (Integer)subActualStaffingMap.get(adminOrgId);
                int subStaffingOrg = (Integer)subStaffingOrgMap.get(adminOrgId);
                int subOnWayPersoncount = (Integer)subOnWayPersoncountMap.get(adminOrgId);
                int subAvaliableStaffing = subStaffingOrg - subActualStaffing - subOnWayPersoncount;
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgId", adminOrgId);
                map.put("orgName", adminOrgName);
                map.put("includeSub", includeSub);
                map.put("subActualStaffing", subActualStaffing);
                map.put("subStaffingOrg", subStaffingOrg);
                map.put("subAvaliableStaffing", subAvaliableStaffing);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            BriefUtil.relaseTempTable(ctx, tempTableName);
        }
        subStaffingMap.put("subStaffing", list);
        return subStaffingMap;
    }

    protected Map _getSubStaffManage(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        List orgSubInfoDTOs = StaffManageFacadeFactory.getLocalInstance((Context)ctx).getOrgSubStaff(orgId, permItemId);
        ArrayList list = new ArrayList();
        for (StaffManageOrgSubInfoDTO orgSubInfoDTO : orgSubInfoDTOs) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("orgId", orgSubInfoDTO.getOrgId());
            map.put("orgName", orgSubInfoDTO.getOrgName());
            map.put("includeSub", orgSubInfoDTO.getIsLeaf() == false);
            if (orgSubInfoDTO.getIsDirect().booleanValue()) {
                map.put("subStaffingOrg", orgSubInfoDTO.getOrgDirectStaff());
                map.put("subActualStaffing", orgSubInfoDTO.getOrgDirectActualCount());
                map.put("subAvaliableStaffing", orgSubInfoDTO.getOrgDirectAvaliableStaff());
            } else {
                map.put("subStaffingOrg", orgSubInfoDTO.getOrgSubStaff());
                map.put("subActualStaffing", orgSubInfoDTO.getOrgSubActualCount());
                map.put("subAvaliableStaffing", orgSubInfoDTO.getOrgSubAvaliableStaff());
            }
            list.add(map);
        }
        HashMap subStaffingMap = new HashMap();
        subStaffingMap.put("subStaffing", list);
        return subStaffingMap;
    }

    @Override
    protected Map _getEnrollHeadcount(Context ctx, String orgId, int dimension, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int enrollHeadcount = 0;
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        int day = BriefUtil.getDay(year, month);
        String beginDateStr = "{ts'" + year + "-" + month + "-01'}";
        String endDateStr = "{ts'" + year + "-" + month + "-" + day + "'}";
        switch (dimension) {
            case 1: {
                beginDateStr = "{ts'" + year + "-01-01'}";
                break;
            }
            case 2: {
                beginDateStr = "{ts'" + year + "-" + month + "-01'}";
            }
        }
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        try {
            StringBuffer sql = new StringBuffer("select count(emprelation.fpersonid) enrollHeadcount").append(" from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelationHis laborrelation on  emprelation.flaborrelationid = laborrelation.FHistoryRelateID").append(" and laborrelation.FStartDateTime <= emprelation.FEndDateTime and laborrelation.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_HRBizDefine bizDefine on  emprelation.factionid = bizDefine.fid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and (bizDefine.fbizdefinetype = 1 or bizDefine.fbizdefinetype = 16 or bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=')").append(" and laborrelation.fenterdate >= ").append(beginDateStr).append(" and laborrelation.fenterdate <= ").append(endDateStr).append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emptype.fisonthestrength = 1");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                enrollHeadcount = rowSet.getInt("enrollHeadcount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        map.put("enrollHeadcount", enrollHeadcount);
        return map;
    }

    @Override
    protected Map _getDirectEnrollHeadcount(Context ctx, String orgId, int dimension) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int directEnrollHeadcount = 0;
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        int day = BriefUtil.getDay(year, month);
        String beginDateStr = "{ts'" + year + "-" + month + "-01'}";
        String endDateStr = "{ts'" + year + "-" + month + "-" + day + "'}";
        switch (dimension) {
            case 1: {
                beginDateStr = "{ts'" + year + "-01-01'}";
                break;
            }
            case 2: {
                beginDateStr = "{ts'" + year + "-" + month + "-01'}";
            }
        }
        try {
            StringBuffer sql = new StringBuffer("select count(emprelation.fpersonid) directEnrollHeadcount").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_HR_EmpLaborRelationHis laborrelation on  emprelation.flaborrelationid = laborrelation.FHistoryRelateID").append(" and laborrelation.FStartDateTime <= emprelation.FEndDateTime and laborrelation.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_HRBizDefine bizDefine on  emprelation.factionid = bizDefine.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and ( bizDefine.fbizdefinetype = 1 or bizDefine.fbizdefinetype = 16 or bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=')").append(" and laborrelation.fenterdate >= ").append(beginDateStr).append(" and laborrelation.fenterdate <= ").append(endDateStr).append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emptype.fisonthestrength = 1");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                directEnrollHeadcount = rowSet.getInt("directEnrollHeadcount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        map.put("directEnrollHeadcount", directEnrollHeadcount);
        return map;
    }

    @Override
    protected Map _getResignHeadcount(Context ctx, String orgId, int dimension, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int resignHeadcount = 0;
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        int day = BriefUtil.getDay(year, month);
        String beginDateStr = "{ts'" + year + "-" + month + "-01'}";
        String endDateStr = "{ts'" + year + "-" + month + "-" + day + "'}";
        switch (dimension) {
            case 1: {
                beginDateStr = "{ts'" + year + "-01-01'}";
                break;
            }
            case 2: {
                beginDateStr = "{ts'" + year + "-" + month + "-01'}";
            }
        }
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        try {
            StringBuffer sql = new StringBuffer("select count(emprelation.fpersonid) resignHeadcount").append(" from T_ORG_Admin adcount").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join t_hr_personpositionhis pphis on emprelation.fpersonid = pphis.fpersonid").append(" and pphis.FStartDateTime <= emprelation.FEndDateTime and pphis.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_EmpLaborRelationHis laborrelation on  emprelation.flaborrelationid = laborrelation.FHistoryRelateID").append(" and laborrelation.FStartDateTime <= emprelation.FEndDateTime and laborrelation.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_HRBizDefine bizDefine on  emprelation.factionid = bizDefine.fid").append(" left join T_HR_BDEmployeeType empTypeLast  ON laborrelation.FLASTLABORRELASTATEID = empTypeLast.fid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and ((bizDefine.fbizdefinetype = 4 and empTypeLast.FISONTHESTRENGTH =1)").append(" or (bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and empType.FINSERVICE = 2))").append(" and pphis.FLeftCompanyDate >= ").append(beginDateStr).append(" and pphis.FLeftCompanyDate <= ").append(endDateStr).append(" and emprelation.fisinner = 1").append(" and (emprelation.fisenrolled = 0 or emptype.fisonthestrength = 0) ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                resignHeadcount = rowSet.getInt("resignHeadcount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        map.put("resignHeadcount", resignHeadcount);
        return map;
    }

    @Override
    protected Map _getDirectResignHeadcount(Context ctx, String orgId, int dimension) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int directResignHeadcount = 0;
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        int day = BriefUtil.getDay(year, month);
        String beginDateStr = "{ts'" + year + "-" + month + "-01'}";
        String endDateStr = "{ts'" + year + "-" + month + "-" + day + "'}";
        switch (dimension) {
            case 1: {
                beginDateStr = "{ts'" + year + "-01-01'}";
                break;
            }
            case 2: {
                beginDateStr = "{ts'" + year + "-" + month + "-01'}";
            }
        }
        try {
            StringBuffer sql = new StringBuffer("select count(emprelation.fpersonid) directResignHeadcount").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join t_hr_personpositionhis pphis on emprelation.fpersonid = pphis.fpersonid").append(" and pphis.FStartDateTime <= emprelation.FEndDateTime and pphis.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_EmpLaborRelationHis laborrelation on  emprelation.flaborrelationid = laborrelation.FHistoryRelateID").append(" and laborrelation.FStartDateTime <= emprelation.FEndDateTime and laborrelation.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_HRBizDefine bizDefine on  emprelation.factionid = bizDefine.fid").append(" left join T_HR_BDEmployeeType empTypeLast  ON laborrelation.FLASTLABORRELASTATEID = empTypeLast.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and ((bizDefine.fbizdefinetype = 4 and empTypeLast.FISONTHESTRENGTH =1)").append(" or (bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and empType.FINSERVICE = 2))").append(" and pphis.fleftdate >= ").append(beginDateStr).append(" and pphis.fleftdate <= ").append(endDateStr).append(" and emprelation.fisinner = 1").append(" and (emprelation.fisenrolled = 0 or emptype.fisonthestrength = 0)");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                directResignHeadcount = rowSet.getInt("directResignHeadcount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        map.put("directResignHeadcount", directResignHeadcount);
        return map;
    }

    @Override
    protected List _getSubEnrollAndResignHeadcount(Context ctx, String orgId, int dimension) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getSubHeadcount(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        HashMap subHeadcountMap = new HashMap();
        ArrayList list = new ArrayList();
        String tempTableName = BriefUtil.createTempTable(ctx, orgId, permItemId);
        try {
            int headcount = (Integer)this._getActualStaffing(ctx, orgId, permItemId).get("actualStaffing");
            int directHeadcount = (Integer)this._getDirectActualStaffing(ctx, orgId).get("directActualStaffing");
            String directHeadcountPercent = BriefUtil.rate(directHeadcount, headcount);
            HashMap<String, Object> directHeadcountMap = new HashMap<String, Object>();
            directHeadcountMap.put("orgId", orgId);
            directHeadcountMap.put("orgName", SHRServerResource.getString((String)"com.kingdee.eas.hr.base.ManagerResource", (String)"label_001", (Context)ctx));
            directHeadcountMap.put("includeSub", false);
            directHeadcountMap.put("subHeadcount", directHeadcount);
            directHeadcountMap.put("subHeadcountPercent", directHeadcountPercent);
            list.add(directHeadcountMap);
            Map subActualStaffingMap = this.getSubActualStaffing(ctx, orgId, tempTableName, permItemId);
            StringBuffer sql = new StringBuffer("select fid,fname,fisleaf from ").append(tempTableName).append(" order by fsortcode,flongnumber asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String adminOrgId = rowSet.getString("fid");
                String adminOrgName = rowSet.getString("fname");
                boolean isLeaf = rowSet.getBoolean("fisleaf");
                boolean includeSub = !isLeaf;
                int subHeadcount = (Integer)subActualStaffingMap.get(adminOrgId);
                String subHeadcountPercent = BriefUtil.rate(subHeadcount, headcount);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgId", adminOrgId);
                map.put("orgName", adminOrgName);
                map.put("includeSub", includeSub);
                map.put("subHeadcount", subHeadcount);
                map.put("subHeadcountPercent", subHeadcountPercent);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            BriefUtil.relaseTempTable(ctx, tempTableName);
        }
        if (list.size() > 0) {
            subHeadcountMap.put("subHeadcountList", list);
        }
        return subHeadcountMap;
    }

    @Override
    protected Map _getEnrollHeadcountTrend(Context ctx, String orgId, Date startDate, Date endDate, String permItemId) throws BOSException, EASBizException {
        this.checkDate(startDate, endDate);
        Map sixMonthData = BriefUtil.getSixMonthData();
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? "" : " where t2.FAdminOrgID = '" + orgId + "'";
        HashMap<String, Map> enrollHeadcountTrendMap = new HashMap<String, Map>();
        String filterStr = BriefUtil.getFilterStr(ctx, startDate, endDate);
        if (filterStr.length() > 0) {
            try {
                StringBuffer sql = new StringBuffer("select sum(t2.fenrollheadcount) as enrollHeadcountHis,t2.fyear,t2.fmonth").append(" from (").append(" select flongnumber,fyear,fmonth from T_MGR_HRAffairHeadcount").append(" where fadminorgid = '").append(orgId).append("' and (").append(filterStr).append(")").append(" ) t1").append(" left join T_MGR_HRAffairHeadcount t2 on (charindex(concat(t1.flongnumber,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on t2.fadminorgid = range.forgid").append(" and t1.fyear = t2.fyear and t1.fmonth = t2.fmonth").append(includeSubSql).append(" group by t2.fyear,t2.fmonth").append(" order by t2.fyear asc,t2.fmonth asc");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rowSet.next()) {
                    int enrollHeadcountHis = rowSet.getInt("enrollHeadcountHis");
                    int fyear = rowSet.getInt("fyear");
                    int fmonth = rowSet.getInt("fmonth");
                    if (!sixMonthData.containsKey(fyear + "-" + fmonth)) continue;
                    sixMonthData.put(fyear + "-" + fmonth, enrollHeadcountHis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        if (endYear == year && endMonth == month) {
            int enrollHeadcount = (Integer)this._getEnrollHeadcount(ctx, orgId, 2, permItemId).get("enrollHeadcount");
            if (sixMonthData.containsKey(year + "-" + month)) {
                sixMonthData.put(year + "-" + month, enrollHeadcount);
            }
        }
        Map map = BriefUtil.getTrendMap(sixMonthData);
        enrollHeadcountTrendMap.put("enrollHeadcountTrend", map);
        return enrollHeadcountTrendMap;
    }

    @Override
    protected Map _getResignHeadcountTrend(Context ctx, String orgId, Date startDate, Date endDate, String permItemId) throws BOSException, EASBizException {
        this.checkDate(startDate, endDate);
        Map sixMonthData = BriefUtil.getSixMonthData();
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? "" : " where t2.FAdminOrgID = '" + orgId + "'";
        HashMap<String, Map> resignHeadcountTrendMap = new HashMap<String, Map>();
        String filterStr = BriefUtil.getFilterStr(ctx, startDate, endDate);
        if (filterStr.length() > 0) {
            try {
                StringBuffer sql = new StringBuffer("select sum(t2.fresignheadcount) as resignHeadcountHis,t2.fyear,t2.fmonth").append(" from (").append(" select flongnumber,fyear,fmonth from T_MGR_HRAffairHeadcount").append(" where fadminorgid = '").append(orgId).append("' and (").append(filterStr).append(")").append(" ) t1").append(" left join T_MGR_HRAffairHeadcount t2 on (charindex(concat(t1.flongnumber,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on t2.fadminorgid = range.forgid").append(" and t1.fyear = t2.fyear and t1.fmonth = t2.fmonth").append(includeSubSql).append(" group by t2.fyear,t2.fmonth").append(" order by t2.fyear asc,t2.fmonth asc");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rowSet.next()) {
                    int resignHeadcountHis = rowSet.getInt("resignHeadcountHis");
                    int fyear = rowSet.getInt("fyear");
                    int fmonth = rowSet.getInt("fmonth");
                    if (!sixMonthData.containsKey(fyear + "-" + fmonth)) continue;
                    sixMonthData.put(fyear + "-" + fmonth, resignHeadcountHis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        if (endYear == year && endMonth == month) {
            int resignHeadcount = (Integer)this._getResignHeadcount(ctx, orgId, 2, permItemId).get("resignHeadcount");
            if (sixMonthData.containsKey(year + "-" + month)) {
                sixMonthData.put(year + "-" + month, resignHeadcount);
            }
        }
        Map map = BriefUtil.getTrendMap(sixMonthData);
        resignHeadcountTrendMap.put("resignHeadcountTrend", map);
        return resignHeadcountTrendMap;
    }

    @Override
    protected Map _getHeadcountTrend(Context ctx, String orgId, Date startDate, Date endDate, String permItemId) throws BOSException, EASBizException {
        this.checkDate(startDate, endDate);
        Map sixMonthData = BriefUtil.getSixMonthData();
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? "" : " where t2.FAdminOrgID = '" + orgId + "'";
        HashMap<String, Map> headcountTrendMap = new HashMap<String, Map>();
        String filterStr = BriefUtil.getFilterStr(ctx, startDate, endDate);
        if (filterStr.length() > 0) {
            try {
                StringBuffer sql = new StringBuffer("select sum(t2.fendheadcount) as headcount,t2.fyear,t2.fmonth").append(" from (").append(" select fendlongnumber,fyear,fmonth from T_MGR_HRHeadcount").append(" where fadminorgid = '").append(orgId).append("' and (").append(filterStr).append(")").append(" ) t1").append(" left join T_MGR_HRHeadcount t2 on (charindex(concat(t1.fendlongnumber,'!'),t2.fendlongnumber) = 1 or t1.fendlongnumber = t2.fendlongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on t2.fadminorgid = range.forgid").append(" and t1.fyear = t2.fyear and t1.fmonth = t2.fmonth").append(includeSubSql).append(" group by t2.fyear,t2.fmonth").append(" order by t2.fyear asc,t2.fmonth asc");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rowSet.next()) {
                    int headcountHis = rowSet.getInt("headcount");
                    int fyear = rowSet.getInt("fyear");
                    int fmonth = rowSet.getInt("fmonth");
                    if (!sixMonthData.containsKey(fyear + "-" + fmonth)) continue;
                    sixMonthData.put(fyear + "-" + fmonth, headcountHis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        if (endYear == year && endMonth == month) {
            int headcount = (Integer)this._getActualStaffing(ctx, orgId, permItemId).get("actualStaffing");
            if (sixMonthData.containsKey(year + "-" + month)) {
                sixMonthData.put(year + "-" + month, headcount);
            }
        }
        Map map = BriefUtil.getTrendMap(sixMonthData);
        headcountTrendMap.put("headcountTrend", map);
        return headcountTrendMap;
    }

    @Override
    protected Map _getStaffingOrgTrend(Context ctx, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        this.checkDate(startDate, endDate);
        Map sixMonthData = BriefUtil.getSixMonthData();
        ArrayList labelList = new ArrayList();
        ArrayList dataList = new ArrayList();
        HashMap map = new HashMap();
        map.put("labelList", labelList);
        map.put("dataList", dataList);
        HashMap<String, Map> staffingOrgTrendMap = new HashMap<String, Map>();
        staffingOrgTrendMap.put("staffingOrgTrend", map);
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        if (this.getStaffingChannel(ctx, startYear) == 0 && this.getStaffingChannel(ctx, endYear) == 0) {
            return staffingOrgTrendMap;
        }
        if (startYear < endYear) {
            this.getStaffingOrgTrend(ctx, staffingOrgTrendMap, orgId, startDate, BriefUtil.getDefaultMaxEndDate(startDate));
            this.getStaffingOrgTrend(ctx, staffingOrgTrendMap, orgId, BriefUtil.getDefaultMinStartDate(endDate), endDate);
        } else {
            this.getStaffingOrgTrend(ctx, staffingOrgTrendMap, orgId, startDate, endDate);
        }
        int index = 0;
        for (String key : sixMonthData.keySet()) {
            if (labelList.contains(key)) {
                ++index;
                continue;
            }
            dataList.add(index, sixMonthData.get(key));
            ++index;
        }
        return staffingOrgTrendMap;
    }

    @Override
    protected Map _getAffairPersonDetail(Context ctx, String orgId, int affair, int dimension, String permItemId) throws BOSException, EASBizException {
        HashMap<String, List> personDetailMap = new HashMap<String, List>();
        List personList = null;
        switch (affair) {
            case 1: {
                personList = this.getEnrollPersonDetail(ctx, orgId, dimension);
                break;
            }
            case 2: {
                personList = this.getResignPersonDetail(ctx, orgId, dimension);
            }
        }
        personDetailMap.put("personList", personList);
        return personDetailMap;
    }

    @Override
    protected Map _getSubAffairHeadcount(Context ctx, String orgId, int affair, int dimension, String permItemId) throws BOSException, EASBizException {
        HashMap subAffairHeadcountMap = new HashMap();
        ArrayList list = new ArrayList();
        int affairHeadcount = 0;
        int directAffairHeadcount = 0;
        Map subHeadcountMap = null;
        String tempTableName = null;
        try {
            tempTableName = BriefUtil.createTempTable(ctx, orgId, permItemId);
            switch (affair) {
                case 1: {
                    affairHeadcount = (Integer)this._getEnrollHeadcount(ctx, orgId, dimension, permItemId).get("enrollHeadcount");
                    directAffairHeadcount = (Integer)this._getDirectEnrollHeadcount(ctx, orgId, dimension).get("directEnrollHeadcount");
                    subHeadcountMap = this.getSubEnrollHeadcount(ctx, orgId, dimension, tempTableName, permItemId);
                    break;
                }
                case 2: {
                    affairHeadcount = (Integer)this._getResignHeadcount(ctx, orgId, dimension, permItemId).get("resignHeadcount");
                    directAffairHeadcount = (Integer)this._getDirectResignHeadcount(ctx, orgId, dimension).get("directResignHeadcount");
                    subHeadcountMap = this.getSubResignHeadcount(ctx, orgId, dimension, tempTableName, permItemId);
                }
            }
            HashMap<String, Object> directMap = new HashMap<String, Object>();
            directMap.put("orgId", orgId);
            directMap.put("orgName", SHRServerResource.getString((String)"com.kingdee.eas.hr.base.ManagerResource", (String)"label_001", (Context)ctx));
            directMap.put("includeSub", false);
            directMap.put("subAffairHeadcount", directAffairHeadcount);
            directMap.put("subAffairPercent", BriefUtil.rate(directAffairHeadcount, affairHeadcount));
            list.add(directMap);
            StringBuffer sql = new StringBuffer("select fid,fname,fisleaf from ").append(tempTableName).append(" order by flongnumber asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String adminOrgId = rowSet.getString("fid");
                String adminOrgName = rowSet.getString("fname");
                boolean isLeaf = rowSet.getBoolean("fisleaf");
                boolean includeSub = !isLeaf;
                int subAffairHeadcount = subHeadcountMap == null ? 0 : (Integer)subHeadcountMap.get(adminOrgId);
                String subAffairPercent = BriefUtil.rate(subAffairHeadcount, affairHeadcount);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgId", adminOrgId);
                map.put("orgName", adminOrgName);
                map.put("includeSub", includeSub);
                map.put("subAffairHeadcount", subAffairHeadcount);
                map.put("subAffairPercent", subAffairPercent);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            BriefUtil.relaseTempTable(ctx, tempTableName);
        }
        if (list.size() > 0) {
            subAffairHeadcountMap.put("subAffairHeadcountList", list);
        }
        return subAffairHeadcountMap;
    }

    @Override
    protected Map _getHumanBriefAnalysisData(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isStartStaffing = true;
        int avaliableStaffing = 0;
        IStaffManageFacade iStaffManageFacade = StaffManageFacadeFactory.getLocalInstance((Context)ctx);
        boolean useOldStaff = iStaffManageFacade.useOldStaff();
        Map avaliableStaffingMap = new HashMap();
        avaliableStaffingMap = useOldStaff ? this._getAvaliableStaffing(ctx, orgId, permItemId) : this._getAvaliableStaffManage(ctx, orgId, permItemId);
        if (avaliableStaffingMap.size() == 0) {
            isStartStaffing = false;
        } else {
            avaliableStaffing = (Integer)avaliableStaffingMap.get("avaliableStaffing");
        }
        int actualStaffing = (Integer)this._getActualStaffing(ctx, orgId, permItemId).get("actualStaffing");
        int enrollHeadcount = (Integer)this._getEnrollHeadcount(ctx, orgId, 2, permItemId).get("enrollHeadcount");
        int resignHeadcount = (Integer)this._getResignHeadcount(ctx, orgId, 2, permItemId).get("resignHeadcount");
        Map enrollHeadcountTrendMap = (Map)this._getEnrollHeadcountTrend(ctx, orgId, BriefUtil.getDefaultStartDate(new Date()), new Date(), permItemId).get("enrollHeadcountTrend");
        Map resignHeadcountTrendMap = (Map)this._getResignHeadcountTrend(ctx, orgId, BriefUtil.getDefaultStartDate(new Date()), new Date(), permItemId).get("resignHeadcountTrend");
        Map headcountTrendMap = (Map)this._getHeadcountTrend(ctx, orgId, BriefUtil.getDefaultStartDate(new Date()), new Date(), permItemId).get("headcountTrend");
        Map staffingOrgTrendMap = new HashMap();
        staffingOrgTrendMap = useOldStaff ? (Map)this._getStaffingOrgTrendByDate(ctx, orgId, BriefUtil.getDefaultStartDate(new Date()), new Date()).get("staffingOrgTrend") : iStaffManageFacade.getStaffManageOrgTrend(orgId, BriefUtil.getDefaultStartDate(new Date()), new Date());
        map.put("isStartStaffing", isStartStaffing);
        map.put("actualStaffing", actualStaffing);
        map.put("avaliableStaffing", avaliableStaffing);
        map.put("enrollHeadcount", enrollHeadcount);
        map.put("resignHeadcount", resignHeadcount);
        map.put("enrollHeadcountTrend", enrollHeadcountTrendMap);
        map.put("resignHeadcountTrend", resignHeadcountTrendMap);
        map.put("headcountTrend", headcountTrendMap);
        map.put("staffingOrgTrend", staffingOrgTrendMap);
        return map;
    }

    @Override
    protected Map _getHumanBriefForewarnData(Context ctx, String userId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getAvgHeadcountTrend(Context ctx, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getYOYHeadcountTrend(Context ctx, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getYOYAvgHeadcountTrend(Context ctx, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getYOYResignHeadcountTrend(Context ctx, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getGrowthRateTrend(Context ctx, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getHeadcountAnalysisData(Context ctx, String orgId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getFlowInOutAnalysisData(Context ctx, String orgId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getTalentHeadcount(Context ctx, String orgId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected Map _getTalentHeadcountTrend(Context ctx, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        return null;
    }

    private int getStaffingChannel(Context ctx, int year) throws BOSException, EASBizException {
        StaffingChannel staffingChannel;
        int channel = 0;
        StaffingCollection staffingColl = StaffingFactory.getLocalInstance((Context)ctx).getStaffingCollection("select channel where year = " + year + " and state = 1");
        if (staffingColl.size() == 1 && (staffingChannel = staffingColl.get(0).getChannel()) != null) {
            channel = staffingChannel.getValue();
        }
        return channel;
    }

    private int getStaffingOrg(Context ctx, String orgId, int channel) throws BOSException, EASBizException {
        String channelFilter = "";
        switch (channel) {
            case 1: {
                channelFilter = " and staffing.fyear = " + DateTimeUtils.getYear((Date)new Date());
                break;
            }
            case 2: {
                channelFilter = " and staffing.fyear = " + DateTimeUtils.getYear((Date)new Date()) + " and staffingorg.fmonth = " + DateTimeUtils.getMonth((Date)new Date());
            }
        }
        int staffingOrg = 0;
        try {
            StringBuffer sql = new StringBuffer("select isnull(staffingorg.fallstaffing,0) fallstaffing").append(" from T_HR_StaffingOrg staffingorg").append(" inner join T_HR_Staffing staffing on staffingorg.fstaffing = staffing.fid").append(" where staffingorg.fadminorgunit = '").append(orgId).append("'").append(channelFilter).append(" and staffingorg.fstate = 1 and staffing.fstate = 1");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                staffingOrg = rowSet.getInt("fallstaffing");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return staffingOrg;
    }

    private int getOnWayPersoncount(Context ctx, String orgId, String permItemId) throws BOSException, EASBizException {
        String userId = BriefUtil.getUserId(ctx);
        int onWayPersoncount = 0;
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        try {
            StringBuffer sql = new StringBuffer("select sum(changedata.fcount) onWayPersoncount").append(" from T_ORG_Admin adcount").append(" inner join t_org_admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpPosChangeData changedata on child.fid = changedata.fadminorgid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and changedata.fisenrolled = 1 and changedata.fisexcluded = 0").append(" and (changedata.fbillstate in (1,2) or").append(" (changedata.fbillstate = 3 and changedata.fbizdate > ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)new Date())).append("))");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                onWayPersoncount = rowSet.getInt("onWayPersoncount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return onWayPersoncount;
    }

    private void checkDate(Date startDate, Date endDate) throws BOSException, EASBizException {
        if (startDate == null) {
            throw new HRAffairException(HRAffairException.EMPTY_STARTDATE);
        }
        if (endDate == null) {
            throw new HRAffairException(HRAffairException.EMPTY_ENDDATE);
        }
        if (endDate.before(startDate)) {
            throw new HRAffairException(HRAffairException.ERROR_DATE);
        }
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        if (startYear + 1 < endYear || startYear + 1 == endYear && startMonth - 1 < endMonth) {
            throw new HRAffairException(HRAffairException.LIMIT_DATE);
        }
    }

    private void getStaffingOrgTrend(Context ctx, Map<String, Map> staffingOrgTrendMap, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        int year = DateTimeUtils.getYear((Date)startDate);
        int channel = this.getStaffingChannel(ctx, year);
        switch (channel) {
            case 1: {
                this.getStaffingOrgTrendByYear(ctx, staffingOrgTrendMap, orgId, startDate, endDate);
                break;
            }
            case 2: {
                this.getStaffingOrgTrendByMonth(ctx, staffingOrgTrendMap, orgId, startDate, endDate);
                break;
            }
            default: {
                this.getEmptyStaffingOrgTrend(ctx, staffingOrgTrendMap, orgId, startDate, endDate);
            }
        }
    }

    private void getStaffingOrgTrendByYear(Context ctx, Map<String, Map> staffingOrgTrendMap, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        int staffingOrg = 0;
        List labelList = (List)staffingOrgTrendMap.get("staffingOrgTrend").get("labelList");
        List dataList = (List)staffingOrgTrendMap.get("staffingOrgTrend").get("dataList");
        int year = DateTimeUtils.getYear((Date)startDate);
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        try {
            StringBuffer sql = new StringBuffer("select isnull(staffingorg.fallstaffing,0) staffingOrg").append(" from T_HR_StaffingOrg staffingorg").append(" inner join T_HR_Staffing staffing on staffingorg.fstaffing = staffing.fid").append(" where staffingorg.fadminorgunit = '").append(orgId).append("'").append(" and staffing.fyear = ").append(year).append(" and staffingorg.fstate = 1 and staffing.fstate = 1");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                staffingOrg = rowSet.getInt("staffingOrg");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        while (startMonth <= endMonth) {
            labelList.add(year + "-" + startMonth);
            dataList.add(staffingOrg);
            ++startMonth;
        }
    }

    private void getStaffingOrgTrendByMonth(Context ctx, Map<String, Map> staffingOrgTrendMap, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        int startMonth;
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List labelList = (List)staffingOrgTrendMap.get("staffingOrgTrend").get("labelList");
        List dataList = (List)staffingOrgTrendMap.get("staffingOrgTrend").get("dataList");
        int year = DateTimeUtils.getYear((Date)startDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        StringBuffer filterStr = new StringBuffer(" and staffing.fyear = ").append(year).append(" and staffingOrg.fmonth in (");
        for (startMonth = DateTimeUtils.getMonth((Date)startDate); startMonth <= endMonth; ++startMonth) {
            filterStr.append(startMonth).append(",");
        }
        filterStr.delete(filterStr.length() - 1, filterStr.length());
        filterStr.append(")");
        try {
            StringBuffer sql = new StringBuffer("select isnull(staffingorg.fallstaffing,0) staffingOrg,staffingOrg.fmonth").append(" from T_HR_StaffingOrg staffingorg").append(" inner join T_HR_Staffing staffing on staffingorg.fstaffing = staffing.fid").append(" where staffingorg.fadminorgunit = '").append(orgId).append("'").append(filterStr).append(" and staffingorg.fstate = 1 and staffing.fstate = 1").append(" order by staffingOrg.fyear asc,staffingOrg.fmonth asc");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                int staffingOrg = rowSet.getInt("staffingOrg");
                int fmonth = rowSet.getInt("fmonth");
                map.put(year + "-" + fmonth, staffingOrg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        endMonth = DateTimeUtils.getMonth((Date)endDate);
        for (startMonth = DateTimeUtils.getMonth((Date)startDate); startMonth <= endMonth; ++startMonth) {
            labelList.add(year + "-" + startMonth);
            int staffingOrg = map.get(year + "-" + startMonth) != null ? (Integer)map.get(year + "-" + startMonth) : 0;
            dataList.add(staffingOrg);
        }
    }

    private void getEmptyStaffingOrgTrend(Context ctx, Map<String, Map> staffingOrgTrendMap, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        int year = DateTimeUtils.getYear((Date)startDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        List labelList = (List)staffingOrgTrendMap.get("staffingOrgTrend").get("labelList");
        List dataList = (List)staffingOrgTrendMap.get("staffingOrgTrend").get("dataList");
        for (int startMonth = DateTimeUtils.getMonth((Date)startDate); startMonth <= endMonth; ++startMonth) {
            labelList.add(year + "-" + startMonth);
            dataList.add(0);
        }
    }

    private Map getSubActualStaffing(Context ctx, String orgId, String tempTableName, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String userId = BriefUtil.getUserId(ctx);
        try {
            StringBuffer sql = new StringBuffer("select adminOrg.fid,isnull(actualStaffing.subActualStaffing,0) subActualStaffing").append(" from ").append(tempTableName).append(" adminOrg").append(" left join (").append(" select adcount.fid adcountid,count(emprelation.fpersonid) subActualStaffing from T_ORG_Admin adcount").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" left join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" left join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" left join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" where adcount.fparentid = '").append(orgId).append("'").append(" and adcount.fissealup = 0 and child.fissealup = 0").append(" and adcount.fisstartshr = 1 and child.fisstartshr = 1").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1").append(" group by adcount.fid").append(" ) actualStaffing on adminOrg.fid = actualStaffing.adcountid");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String subAdminOrgId = rowSet.getString("fid");
                int subActualStaffing = rowSet.getInt("subActualStaffing");
                map.put(subAdminOrgId, subActualStaffing);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    private Map getSubEnrollHeadcount(Context ctx, String orgId, int dimension, String tempTableName, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String userId = BriefUtil.getUserId(ctx);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        int day = BriefUtil.getDay(year, month);
        String beginDateStr = "{ts'" + year + "-" + month + "-01'}";
        String endDateStr = "{ts'" + year + "-" + month + "-" + day + "'}";
        switch (dimension) {
            case 1: {
                beginDateStr = "{ts'" + year + "-01-01'}";
                break;
            }
            case 2: {
                beginDateStr = "{ts'" + year + "-" + month + "-01'}";
            }
        }
        try {
            StringBuffer sql = new StringBuffer("select adminOrg.fid,isnull(subEnrollHeadcount.enrollHeadcount,0) subEnrollHeadcount").append(" from ").append(tempTableName).append(" adminOrg").append(" left join (").append(" select adcount.fid adcountid,count(emprelation.fpersonid) enrollHeadcount from T_ORG_Admin adcount").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join T_HR_EmpLaborRelationHis laborrelation on  emprelation.flaborrelationid = laborrelation.FHistoryRelateID").append(" and laborrelation.FStartDateTime <= emprelation.FEndDateTime and laborrelation.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_HRBizDefine bizDefine on  emprelation.factionid = bizDefine.fid").append(" where adcount.fparentid = '").append(orgId).append("'").append(" and adcount.fissealup = 0 and child.fissealup = 0").append(" and adcount.fisstartshr = 1 and child.fisstartshr = 1").append(" and ( bizDefine.fbizdefinetype = 1 or bizDefine.fbizdefinetype = 16 or bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=')").append(" and laborrelation.fenterdate >= ").append(beginDateStr).append(" and laborrelation.fenterdate <= ").append(endDateStr).append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emptype.fisonthestrength = 1").append(" group by adcount.fid").append(" ) subEnrollHeadcount on adminOrg.fid = subEnrollHeadcount.adcountid");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String subAdminOrgId = rowSet.getString("fid");
                int subEnrollHeadcount = rowSet.getInt("subEnrollHeadcount");
                map.put(subAdminOrgId, subEnrollHeadcount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    private Map getSubResignHeadcount(Context ctx, String orgId, int dimension, String tempTableName, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String userId = BriefUtil.getUserId(ctx);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        int day = BriefUtil.getDay(year, month);
        String beginDateStr = "{ts'" + year + "-" + month + "-01'}";
        String endDateStr = "{ts'" + year + "-" + month + "-" + day + "'}";
        switch (dimension) {
            case 1: {
                beginDateStr = "{ts'" + year + "-01-01'}";
                break;
            }
            case 2: {
                beginDateStr = "{ts'" + year + "-" + month + "-01'}";
            }
        }
        try {
            StringBuffer sql = new StringBuffer("select adminOrg.fid,isnull(subResignHeadcount.resignHeadcount,0) subResignHeadcount").append(" from ").append(tempTableName).append(" adminOrg").append(" left join (").append(" select adcount.fid adcountid,count(emprelation.fpersonid) resignHeadcount from T_ORG_Admin adcount").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpOrgRelation emprelation on child.fid = emprelation.fadminorgid").append(" inner join t_hr_personpositionhis pphis on emprelation.fpersonid = pphis.fpersonid").append(" and pphis.FStartDateTime <= emprelation.FEndDateTime and pphis.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_EmpLaborRelationHis laborrelation on  emprelation.flaborrelationid = laborrelation.FHistoryRelateID").append(" and laborrelation.FStartDateTime <= emprelation.FEndDateTime and laborrelation.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_HRBizDefine bizDefine on  emprelation.factionid = bizDefine.fid").append(" left join T_HR_BDEmployeeType empTypeLast  ON laborrelation.FLASTLABORRELASTATEID = empTypeLast.fid").append(" where adcount.fparentid = '").append(orgId).append("'").append(" and adcount.fissealup = 0 and child.fissealup = 0").append(" and adcount.fisstartshr = 1 and child.fisstartshr = 1").append(" and ((bizDefine.fbizdefinetype = 4 and empTypeLast.FISONTHESTRENGTH =1)").append(" or (bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and empType.FINSERVICE = 2))").append(" and pphis.fleftdate >= ").append(beginDateStr).append(" and pphis.fleftdate <= ").append(endDateStr).append(" and emprelation.fisinner = 1").append(" and (emptype.fisonthestrength = 0 or emprelation.fisenrolled = 0) ").append(" group by adcount.fid").append(" ) subResignHeadcount on adminOrg.fid = subResignHeadcount.adcountid");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String subAdminOrgId = rowSet.getString("fid");
                int subResignHeadcount = rowSet.getInt("subResignHeadcount");
                map.put(subAdminOrgId, subResignHeadcount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    private List getEnrollPersonDetail(Context ctx, String orgId, int dimension) throws BOSException, EASBizException {
        String local = BriefUtil.getLocal(ctx);
        ArrayList list = new ArrayList();
        String userId = BriefUtil.getUserId(ctx);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        int day = BriefUtil.getDay(year, month);
        String beginDateStr = "{ts'" + year + "-" + month + "-01'}";
        String endDateStr = "{ts'" + year + "-" + month + "-" + day + "'}";
        switch (dimension) {
            case 1: {
                beginDateStr = "{ts'" + year + "-01-01'}";
                break;
            }
            case 2: {
                beginDateStr = "{ts'" + year + "-" + month + "-01'}";
            }
        }
        try {
            StringBuffer sql = new StringBuffer("select person.fid personId,person.fname_" + local + " personName,").append(" adminOrg.fname_" + local + " as orgName,position.fname_" + local + " as positionName,photo.fimagedata").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_ORG_Admin adminOrg on emprelation.fadminorgid = adminOrg.fid").append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" left join T_HR_PersonPhoto photo on person.fid = photo.fpersonid").append(" inner join T_HR_EmpLaborRelationHis laborrelation on  emprelation.flaborrelationid = laborrelation.FHistoryRelateID").append(" and laborrelation.FStartDateTime <= emprelation.FEndDateTime and laborrelation.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_HRBizDefine bizDefine on  emprelation.factionid = bizDefine.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and laborrelation.fenterdate >= ").append(beginDateStr).append(" and laborrelation.fenterdate <= ").append(endDateStr).append(" and emptype.fisonthestrength = 1").append(" and (bizDefine.fbizdefinetype = 1 or bizDefine.fbizdefinetype = 16 or bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=')").append(" order by person.fnumber");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String personId = rowSet.getString("personId");
                String personName = rowSet.getString("personName");
                String orgName = rowSet.getString("orgName");
                String positionName = rowSet.getString("positionName");
                Blob blob = rowSet.getBlob("fimagedata");
                String personPhoto = BriefUtil.convertBlobToBase64(blob);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("personId", personId);
                map.put("personName", personName);
                map.put("orgName", orgName);
                map.put("positionName", positionName);
                map.put("personPhoto", personPhoto);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    private List getResignPersonDetail(Context ctx, String orgId, int dimension) throws BOSException, EASBizException {
        String local = BriefUtil.getLocal(ctx);
        ArrayList list = new ArrayList();
        String userId = BriefUtil.getUserId(ctx);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        int day = BriefUtil.getDay(year, month);
        String beginDateStr = "{ts'" + year + "-" + month + "-01'}";
        String endDateStr = "{ts'" + year + "-" + month + "-" + day + "'}";
        switch (dimension) {
            case 1: {
                beginDateStr = "{ts'" + year + "-01-01'}";
                break;
            }
            case 2: {
                beginDateStr = "{ts'" + year + "-" + month + "-01'}";
            }
        }
        try {
            StringBuffer sql = new StringBuffer("select person.fid personId,person.fname_" + local + " personName,").append(" adminOrg.fname_" + local + " as orgName,position.fname_" + local + " as positionName,photo.fimagedata").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join t_hr_personpositionhis pphis on emprelation.fpersonid = pphis.fpersonid").append(" and pphis.FStartDateTime <= emprelation.FEndDateTime and pphis.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_ORG_Admin adminOrg on emprelation.fadminorgid = adminOrg.fid").append(" inner join T_ORG_Position position on emprelation.fpositionid = position.fid").append(" inner join T_BD_Person person on emprelation.fpersonid = person.fid").append(" left join T_HR_PersonPhoto photo on person.fid = photo.fpersonid").append(" inner join T_HR_EmpLaborRelationHis laborrelation on  emprelation.flaborrelationid = laborrelation.FHistoryRelateID").append(" and laborrelation.FStartDateTime <= emprelation.FEndDateTime and laborrelation.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" inner join T_HR_HRBizDefine bizDefine on  emprelation.factionid = bizDefine.fid").append(" left join T_HR_BDEmployeeType empTypeLast  ON laborrelation.FLASTLABORRELASTATEID = empTypeLast.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisinner = 1").append(" and pphis.fleftdate >= ").append(beginDateStr).append(" and pphis.fleftdate <= ").append(endDateStr).append(" and (emptype.fisonthestrength = 0 or emprelation.fisenrolled = 0)").append(" and ((bizDefine.fbizdefinetype = 4 and empTypeLast.FISONTHESTRENGTH =1)").append(" or (bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and empType.FINSERVICE = 2))");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String personId = rowSet.getString("personId");
                String personName = rowSet.getString("personName");
                String orgName = rowSet.getString("orgName");
                String positionName = rowSet.getString("positionName");
                Blob blob = rowSet.getBlob("fimagedata");
                String personPhoto = BriefUtil.convertBlobToBase64(blob);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("personId", personId);
                map.put("personName", personName);
                map.put("orgName", orgName);
                map.put("positionName", positionName);
                map.put("personPhoto", personPhoto);
                list.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return list;
    }

    private void getDirectStaffing(Context ctx, String orgId, List list, int channel) throws BOSException, EASBizException {
        String channelFilter = "";
        switch (channel) {
            case 1: {
                channelFilter = " and staffing.fyear = " + DateTimeUtils.getYear((Date)new Date());
                break;
            }
            case 2: {
                channelFilter = " and staffing.fyear = " + DateTimeUtils.getYear((Date)new Date()) + " and staffingorg.fmonth = " + DateTimeUtils.getMonth((Date)new Date());
            }
        }
        int actualStaffing = 0;
        int staffingOrg = 0;
        int onWayPersoncount = 0;
        try {
            StringBuffer actualStaffingSql = new StringBuffer("select count(emprelation.fpersonid) actualStaffing").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_HR_EmpLaborRelation laborrelation on  emprelation.flaborrelationid = laborrelation.fid").append(" inner join T_HR_BDEmployeeType emptype on laborrelation.flaborrelationstateid = emptype.fid").append(" where emprelation.fadminorgid = '").append(orgId).append("'").append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and emptype.fisonthestrength = 1");
            IRowSet actualStaffingSet = DbUtil.executeQuery((Context)ctx, (String)actualStaffingSql.toString());
            while (actualStaffingSet.next()) {
                actualStaffing = actualStaffingSet.getInt("actualStaffing");
            }
            StringBuffer staffingOrgSql = new StringBuffer("select isnull(staffingorg.fdirectstaffing,0) staffingOrg").append(" from T_HR_StaffingOrg staffingorg").append(" inner join T_HR_Staffing staffing on staffingorg.fstaffing = staffing.fid").append(" where staffingorg.fadminorgunit = '").append(orgId).append("'").append(channelFilter).append(" and staffingorg.fstate = 1 and staffing.fstate = 1");
            IRowSet staffingOrgSet = DbUtil.executeQuery((Context)ctx, (String)staffingOrgSql.toString());
            while (staffingOrgSet.next()) {
                staffingOrg = staffingOrgSet.getInt("staffingOrg");
            }
            StringBuffer onWayPersoncountSql = new StringBuffer("select isnull(sum(changedata.fcount),0) onWayPersoncount").append(" from T_HR_EmpPosChangeData changedata").append(" where changedata.fisenrolled = 1 and changedata.fisexcluded = 0").append(" and changedata.fadminorgid = '").append(orgId).append("'").append(" and (changedata.fbillstate in (1,2) or (changedata.fbillstate = 3 and changedata.fbizdate > ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)new Date())).append("))");
            IRowSet onWayPersoncountSet = DbUtil.executeQuery((Context)ctx, (String)onWayPersoncountSql.toString());
            while (onWayPersoncountSet.next()) {
                onWayPersoncount = onWayPersoncountSet.getInt("onWayPersoncount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        int avaliableStaffing = staffingOrg - actualStaffing - onWayPersoncount;
        String direct = SHRServerResource.getString((String)"com.kingdee.eas.hr.base.ManagerResource", (String)"label_001", (Context)ctx);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", orgId);
        map.put("orgName", direct);
        map.put("includeSub", false);
        map.put("subActualStaffing", actualStaffing);
        map.put("subStaffingOrg", staffingOrg);
        map.put("subAvaliableStaffing", avaliableStaffing);
        list.add(map);
    }

    private Map getSubStaffingOrg(Context ctx, String orgId, String tempTableName, int channel, String permItemId) throws BOSException, EASBizException {
        String channelFilter = "";
        switch (channel) {
            case 1: {
                channelFilter = " and staffing.fyear = " + DateTimeUtils.getYear((Date)new Date());
                break;
            }
            case 2: {
                channelFilter = " and staffing.fyear = " + DateTimeUtils.getYear((Date)new Date()) + " and staffingorg.fmonth = " + DateTimeUtils.getMonth((Date)new Date());
            }
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String userId = BriefUtil.getUserId(ctx);
        try {
            StringBuffer sql = new StringBuffer("select adminOrg.fid,isnull(staffingorg.fallstaffing,0) subStaffingOrg").append(" from ").append(tempTableName).append(" adminOrg").append(" left join (").append(" select adminOrg.fid,staffingorg.fallstaffing from T_ORG_Admin adminOrg").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on adminOrg.fid = range.forgid").append(" inner join T_HR_StaffingOrg staffingorg on staffingorg.fadminorgunit = adminOrg.fid").append(" inner join T_HR_Staffing staffing on staffingorg.fstaffing = staffing.fid").append(" where adminOrg.fparentid = '").append(orgId).append("' and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(channelFilter).append(" and staffingorg.fstate = 1 and staffing.fstate = 1").append(" ) staffingorg on adminOrg.fid = staffingorg.fid");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String subAdminOrgId = rowSet.getString("fid");
                int subStaffingOrg = rowSet.getInt("subStaffingOrg");
                map.put(subAdminOrgId, subStaffingOrg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    private Map getSubOnWayPersoncount(Context ctx, String orgId, String tempTableName, String permItemId) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String userId = BriefUtil.getUserId(ctx);
        try {
            StringBuffer sql = new StringBuffer("select adminOrg.fid,isnull(onWayPerson.onWayPersoncount,0) subOnWayPersoncount").append(" from ").append(tempTableName).append(" adminOrg").append(" left join (").append(" select adcount.fid adcountid,sum(changedata.fcount) onWayPersoncount  from T_ORG_Admin adcount").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpPosChangeData changedata on child.fid = changedata.fadminorgid").append(" where adcount.fparentid = '").append(orgId).append("'").append(" and adcount.fissealup = 0 and child.fissealup = 0").append(" and adcount.fisstartshr = 1 and child.fisstartshr = 1").append(" and changedata.fisenrolled = 1 and changedata.fisexcluded = 0").append(" and (changedata.fbillstate in (1,2) or (changedata.fbillstate = 3 and changedata.fbizdate > ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)new Date())).append("))").append(" group by adcount.fid").append(" ) onWayPerson on adminOrg.fid = onWayPerson.adcountid");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                String subAdminOrgId = rowSet.getString("fid");
                int subOnWayPersoncount = rowSet.getInt("subOnWayPersoncount");
                map.put(subAdminOrgId, subOnWayPersoncount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    @Override
    protected Map _getHumanBriefAnalysisDataMapParam(Context ctx, Map param) throws BOSException, EASBizException {
        String orgId = (String)param.get("orgId");
        String permItemId = (String)param.get("permItemId");
        String datePoint = (String)param.get("datePoint");
        if (StringUtils.isEmpty((String)datePoint)) {
            throw new HRAffairException(HRAffairException.DATE_EMPTY_EXCEPTION);
        }
        Date paramDate = null;
        try {
            paramDate = DateTimeUtils.parseDate((String)(datePoint + "-01"), (String)"yyyy-MM-dd");
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        boolean isUserOrgIncludeSub = CommonCodeMethods.isUserOrgIncludeSub(ctx, orgId, permItemId);
        int year = Integer.valueOf(datePoint.split("-")[0]);
        int month = Integer.valueOf(datePoint.split("-")[1]);
        HashMap<String, Object> map = new HashMap<String, Object>();
        boolean isStartStaffing = true;
        int avaliableStaffing = 0;
        IStaffManageFacade iStaffManageFacade = StaffManageFacadeFactory.getLocalInstance((Context)ctx);
        boolean useOldStaff = iStaffManageFacade.useOldStaff();
        Map avaliableStaffingMap = new HashMap();
        avaliableStaffingMap = useOldStaff ? this._getAvaliableStaffing(ctx, orgId, permItemId) : this._getAvaliableStaffManage(ctx, orgId, permItemId);
        if (avaliableStaffingMap.size() == 0) {
            isStartStaffing = false;
        } else {
            avaliableStaffing = (Integer)avaliableStaffingMap.get("avaliableStaffing");
        }
        int actualStaffing = (Integer)this._getActualStaffing(ctx, orgId, permItemId, year, month, isUserOrgIncludeSub).get("actualStaffing");
        int enrollHeadcount = (Integer)this._getEnrollHeadcount(ctx, orgId, permItemId, year, month, isUserOrgIncludeSub).get("enrollHeadcount");
        int resignHeadcount = (Integer)this._getResignHeadcount(ctx, orgId, permItemId, year, month, isUserOrgIncludeSub).get("resignHeadcount");
        Map enrollHeadcountTrendMap = (Map)this._getEnrollHeadcountTrend(ctx, orgId, BriefUtil.getDefaultStartDate(paramDate), paramDate, permItemId, isUserOrgIncludeSub).get("enrollHeadcountTrend");
        Map resignHeadcountTrendMap = (Map)this._getResignHeadcountTrend(ctx, orgId, BriefUtil.getDefaultStartDate(paramDate), paramDate, permItemId, isUserOrgIncludeSub).get("resignHeadcountTrend");
        Map headcountTrendMap = (Map)this._getHeadcountTrend(ctx, orgId, BriefUtil.getDefaultStartDate(paramDate), paramDate, permItemId, isUserOrgIncludeSub).get("headcountTrend");
        Map staffingOrgTrendMap = new HashMap();
        staffingOrgTrendMap = useOldStaff ? (Map)this._getStaffingOrgTrendByDate(ctx, orgId, BriefUtil.getDefaultStartDate(paramDate), paramDate).get("staffingOrgTrend") : iStaffManageFacade.getStaffManageOrgTrend(orgId, BriefUtil.getDefaultStartDate(paramDate), paramDate);
        map.put("isStartStaffing", isStartStaffing);
        map.put("actualStaffing", actualStaffing);
        map.put("avaliableStaffing", avaliableStaffing);
        map.put("enrollHeadcount", enrollHeadcount);
        map.put("resignHeadcount", resignHeadcount);
        map.put("enrollHeadcountTrend", enrollHeadcountTrendMap);
        map.put("resignHeadcountTrend", resignHeadcountTrendMap);
        map.put("headcountTrend", headcountTrendMap);
        map.put("staffingOrgTrend", staffingOrgTrendMap);
        return map;
    }

    protected Map _getAvaliableStaffing(Context ctx, String orgId, String permItemId, int year, int month, boolean isUserOrgIncludeSub) throws BOSException, EASBizException {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        int channel = this.getStaffingChannel(ctx, year);
        if (channel == 0) {
            return map;
        }
        int actualStaffing = (Integer)this._getActualStaffing(ctx, orgId, permItemId, year, month, isUserOrgIncludeSub).get("actualStaffing");
        int staffingOrg = this.getStaffingOrg(ctx, orgId, channel, year, month);
        int onWayPersonCount = this.getOnWayPersoncount(ctx, orgId, permItemId, year, month, isUserOrgIncludeSub);
        int avaliableStaffing = staffingOrg - actualStaffing - onWayPersonCount;
        map.put("avaliableStaffing", avaliableStaffing);
        return map;
    }

    private int getStaffingOrg(Context ctx, String orgId, int channel, int year, int month) throws BOSException, EASBizException {
        String channelFilter = "";
        switch (channel) {
            case 1: {
                channelFilter = " and staffing.fyear = " + year;
                break;
            }
            case 2: {
                channelFilter = " and staffing.fyear = " + year + " and staffingorg.fmonth = " + month;
            }
        }
        int staffingOrg = 0;
        try {
            StringBuffer sql = new StringBuffer("select isnull(staffingorg.fallstaffing,0) fallstaffing").append(" from T_HR_StaffingOrg staffingorg").append(" inner join T_HR_Staffing staffing on staffingorg.fstaffing = staffing.fid").append(" where staffingorg.fadminorgunit = '").append(orgId).append("'").append(channelFilter).append(" and staffingorg.fstate = 1 and staffing.fstate = 1");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                staffingOrg = rowSet.getInt("fallstaffing");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return staffingOrg;
    }

    private int getOnWayPersoncount(Context ctx, String orgId, String permItemId, int year, int month, boolean isUserOrgIncludeSub) throws BOSException, EASBizException {
        int nowYear = DateTimeUtils.getYear((Date)new Date());
        int nowMonth = DateTimeUtils.getMonth((Date)new Date());
        int getOnWayPersoncount = 0;
        String dateTs = "";
        if (nowYear == year && nowMonth == month) {
            dateTs = HRUtilExtend.getDateStringWithoutMininuteTs((Date)new Date());
        } else {
            int day = HRManagerUtil.getDay((int)year, (int)month);
            dateTs = " {ts'" + year + "-" + month + "-" + day + "'} ";
        }
        getOnWayPersoncount = this.getOnWayPersoncount(ctx, orgId, permItemId, dateTs, isUserOrgIncludeSub);
        return getOnWayPersoncount;
    }

    private int getOnWayPersoncount(Context ctx, String orgId, String permItemId, String dateTs, boolean isUserOrgIncludeSub) throws BOSException {
        String userId = BriefUtil.getUserId(ctx);
        int onWayPersoncount = 0;
        String includeSubSql = null;
        includeSubSql = isUserOrgIncludeSub ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        try {
            StringBuffer sql = new StringBuffer("select sum(changedata.fcount) onWayPersoncount").append(" from T_ORG_Admin adcount").append(" inner join t_org_admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on child.fid = range.forgid").append(" inner join T_HR_EmpPosChangeData changedata on child.fid = changedata.fadminorgid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and changedata.fisenrolled = 1 and changedata.fisexcluded = 0").append(" and (changedata.fbillstate in (1,2) or").append(" (changedata.fbillstate = 3 and changedata.fbizdate > ").append(dateTs).append("))");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                onWayPersoncount = rowSet.getInt("onWayPersoncount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return onWayPersoncount;
    }

    protected Map _getActualStaffing(Context ctx, String orgId, String permItemId, int year, int month, boolean isUserOrgIncludeSub) throws BOSException, EASBizException {
        int nowYear = DateTimeUtils.getYear((Date)new Date());
        int nowMonth = DateTimeUtils.getMonth((Date)new Date());
        int actualStaffing = 0;
        if (nowYear == year && nowMonth == month) {
            actualStaffing = (Integer)this._getActualStaffing(ctx, orgId, permItemId).get("actualStaffing");
        } else {
            HashMap<String, Object> hisQueryParam = new HashMap<String, Object>();
            hisQueryParam.put("orgId", orgId);
            hisQueryParam.put("permItemId", permItemId);
            hisQueryParam.put("year", year);
            hisQueryParam.put("month", month);
            hisQueryParam.put("isUserOrgIncludeSub", isUserOrgIncludeSub);
            actualStaffing = this.getHisHeadCountByCondition(ctx, hisQueryParam);
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("actualStaffing", actualStaffing);
        return map;
    }

    protected Map _getEnrollHeadcount(Context ctx, String orgId, String permItemId, int year, int month, boolean isUserOrgIncludeSub) throws BOSException, EASBizException {
        int nowYear = DateTimeUtils.getYear((Date)new Date());
        int nowMonth = DateTimeUtils.getMonth((Date)new Date());
        int enrollHeadcount = 0;
        if (nowYear == year && nowMonth == month) {
            enrollHeadcount = (Integer)this._getEnrollHeadcount(ctx, orgId, 2, permItemId).get("enrollHeadcount");
        } else {
            HashMap<String, Object> hisQueryParam = new HashMap<String, Object>();
            hisQueryParam.put("orgId", orgId);
            hisQueryParam.put("permItemId", permItemId);
            hisQueryParam.put("year", year);
            hisQueryParam.put("month", month);
            hisQueryParam.put("selectColumn", " sum(t2.fenrollheadcount) as enrollHeadcountHis ");
            hisQueryParam.put("selectTable", " T_MGR_HRAffairHeadcount ");
            hisQueryParam.put("getColumn", "enrollHeadcountHis");
            hisQueryParam.put("isUserOrgIncludeSub", isUserOrgIncludeSub);
            enrollHeadcount = this.getHisEnrollResignCountByCondition(ctx, hisQueryParam);
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("enrollHeadcount", enrollHeadcount);
        return map;
    }

    protected Map _getResignHeadcount(Context ctx, String orgId, String permItemId, int year, int month, boolean isUserOrgIncludeSub) throws BOSException, EASBizException {
        int nowYear = DateTimeUtils.getYear((Date)new Date());
        int nowMonth = DateTimeUtils.getMonth((Date)new Date());
        int resignHeadcount = 0;
        if (nowYear == year && nowMonth == month) {
            resignHeadcount = (Integer)this._getResignHeadcount(ctx, orgId, 2, permItemId).get("resignHeadcount");
        } else {
            HashMap<String, Object> hisQueryParam = new HashMap<String, Object>();
            hisQueryParam.put("orgId", orgId);
            hisQueryParam.put("permItemId", permItemId);
            hisQueryParam.put("year", year);
            hisQueryParam.put("month", month);
            hisQueryParam.put("selectColumn", " sum(t2.fresignheadcount) as resignHeadcountHis ");
            hisQueryParam.put("selectTable", " T_MGR_HRAffairHeadcount ");
            hisQueryParam.put("getColumn", "resignHeadcountHis");
            hisQueryParam.put("isUserOrgIncludeSub", isUserOrgIncludeSub);
            resignHeadcount = this.getHisEnrollResignCountByCondition(ctx, hisQueryParam);
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("resignHeadcount", resignHeadcount);
        return map;
    }

    private int getHisHeadCountByCondition(Context ctx, Map<String, Object> hisQueryParam) throws BOSException {
        String orgIdParam = (String)hisQueryParam.get("orgId");
        String permItemIdParam = (String)hisQueryParam.get("permItemId");
        Integer yearParam = (Integer)hisQueryParam.get("year");
        Integer monthParam = (Integer)hisQueryParam.get("month");
        Boolean isUserOrgIncludeSub = (Boolean)hisQueryParam.get("isUserOrgIncludeSub");
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = isUserOrgIncludeSub != false ? "" : " where t2.FAdminOrgID = '" + orgIdParam + "'";
        int hisCount = 0;
        try {
            StringBuffer sql = new StringBuffer("select ").append(" sum(t2.fendheadcount) as endheadcount ").append(" from (").append(" select fendlongnumber,fyear,fmonth from ").append(" T_MGR_HRHeadcount").append(" where fadminorgid = '").append(orgIdParam).append("'").append(" and fyear =").append(yearParam).append(" and fmonth=").append(monthParam).append(" ) t1").append(" left join T_MGR_HRHeadcount t2 on (charindex(concat(t1.fendlongnumber,'!'),t2.fendlongnumber) = 1 or t1.fendlongnumber = t2.fendlongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemIdParam)).append(" ) range on t2.fadminorgid = range.forgid").append(" and t1.fyear = t2.fyear and t1.fmonth = t2.fmonth").append(includeSubSql).append(" group by t2.fyear,t2.fmonth");
            if (logger.isInfoEnabled()) {
                logger.info((Object)("print=====getHisHeadCountByCondition====sql==\n " + sql));
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                hisCount = rowSet.getInt("endheadcount");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return hisCount;
    }

    private int getHisEnrollResignCountByCondition(Context ctx, Map<String, Object> hisQueryParam) throws BOSException {
        String orgIdParam = (String)hisQueryParam.get("orgId");
        String permItemIdParam = (String)hisQueryParam.get("permItemId");
        Integer yearParam = (Integer)hisQueryParam.get("year");
        Integer monthParam = (Integer)hisQueryParam.get("month");
        String selectColumnParam = (String)hisQueryParam.get("selectColumn");
        String selectTableParam = (String)hisQueryParam.get("selectTable");
        String getColumn = (String)hisQueryParam.get("getColumn");
        Boolean isUserOrgIncludeSub = (Boolean)hisQueryParam.get("isUserOrgIncludeSub");
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = isUserOrgIncludeSub != false ? "" : " where t2.FAdminOrgID = '" + orgIdParam + "'";
        int hisCount = 0;
        try {
            StringBuffer sql = new StringBuffer("select ").append(selectColumnParam).append(" from (").append(" select flongnumber,fyear,fmonth from ").append(selectTableParam).append(" where fadminorgid = '").append(orgIdParam).append("'").append(" and fyear =").append(yearParam).append(" and fmonth=").append(monthParam).append(" ) t1").append(" left join ").append(selectTableParam).append(" t2 on (charindex(concat(t1.flongnumber,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemIdParam)).append(" ) range on t2.fadminorgid = range.forgid").append(" and t1.fyear = t2.fyear and t1.fmonth = t2.fmonth").append(includeSubSql).append(" group by t2.fyear,t2.fmonth");
            if (logger.isInfoEnabled()) {
                logger.error((Object)("print=====getHisEnrollResignCountByCondition====sql==\n " + sql));
            }
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                hisCount = rowSet.getInt(getColumn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return hisCount;
    }

    protected Map _getEnrollHeadcountTrend(Context ctx, String orgId, Date startDate, Date endDate, String permItemId, boolean isUserOrgIncludeSub) throws BOSException, EASBizException {
        this.checkDate(startDate, endDate);
        Map sixMonthData = CommonCodeMethods.getSixMonthData(startDate, endDate);
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = isUserOrgIncludeSub ? "" : " where t2.FAdminOrgID = '" + orgId + "'";
        HashMap<String, Map> enrollHeadcountTrendMap = new HashMap<String, Map>();
        String filterStr = BriefUtil.getFilterStr(ctx, startDate, endDate);
        if (filterStr.length() > 0) {
            try {
                StringBuffer sql = new StringBuffer("select sum(t2.fenrollheadcount) as enrollHeadcountHis,t2.fyear,t2.fmonth").append(" from (").append(" select flongnumber,fyear,fmonth from T_MGR_HRAffairHeadcount").append(" where fadminorgid = '").append(orgId).append("' and (").append(filterStr).append(")").append(" ) t1").append(" left join T_MGR_HRAffairHeadcount t2 on (charindex(concat(t1.flongnumber,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on t2.fadminorgid = range.forgid").append(" and t1.fyear = t2.fyear and t1.fmonth = t2.fmonth").append(includeSubSql).append(" group by t2.fyear,t2.fmonth").append(" order by t2.fyear asc,t2.fmonth asc");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rowSet.next()) {
                    int enrollHeadcountHis = rowSet.getInt("enrollHeadcountHis");
                    int fyear = rowSet.getInt("fyear");
                    int fmonth = rowSet.getInt("fmonth");
                    if (!sixMonthData.containsKey(fyear + "-" + fmonth)) continue;
                    sixMonthData.put(fyear + "-" + fmonth, enrollHeadcountHis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        if (endYear == year && endMonth == month) {
            int enrollHeadcount = (Integer)this._getEnrollHeadcount(ctx, orgId, 2, permItemId).get("enrollHeadcount");
            if (sixMonthData.containsKey(year + "-" + month)) {
                sixMonthData.put(year + "-" + month, enrollHeadcount);
            }
        }
        Map map = BriefUtil.getTrendMap(sixMonthData);
        enrollHeadcountTrendMap.put("enrollHeadcountTrend", map);
        return enrollHeadcountTrendMap;
    }

    protected Map _getResignHeadcountTrend(Context ctx, String orgId, Date startDate, Date endDate, String permItemId, boolean isUserOrgIncludeSub) throws BOSException, EASBizException {
        this.checkDate(startDate, endDate);
        Map sixMonthData = CommonCodeMethods.getSixMonthData(startDate, endDate);
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = isUserOrgIncludeSub ? "" : " where t2.FAdminOrgID = '" + orgId + "'";
        HashMap<String, Map> resignHeadcountTrendMap = new HashMap<String, Map>();
        String filterStr = BriefUtil.getFilterStr(ctx, startDate, endDate);
        if (filterStr.length() > 0) {
            try {
                StringBuffer sql = new StringBuffer("select sum(t2.fresignheadcount) as resignHeadcountHis,t2.fyear,t2.fmonth").append(" from (").append(" select flongnumber,fyear,fmonth from T_MGR_HRAffairHeadcount").append(" where fadminorgid = '").append(orgId).append("' and (").append(filterStr).append(")").append(" ) t1").append(" left join T_MGR_HRAffairHeadcount t2 on (charindex(concat(t1.flongnumber,'!'),t2.flongnumber) = 1 or t1.flongnumber = t2.flongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on t2.fadminorgid = range.forgid").append(" and t1.fyear = t2.fyear and t1.fmonth = t2.fmonth").append(includeSubSql).append(" group by t2.fyear,t2.fmonth").append(" order by t2.fyear asc,t2.fmonth asc");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rowSet.next()) {
                    int resignHeadcountHis = rowSet.getInt("resignHeadcountHis");
                    int fyear = rowSet.getInt("fyear");
                    int fmonth = rowSet.getInt("fmonth");
                    if (!sixMonthData.containsKey(fyear + "-" + fmonth)) continue;
                    sixMonthData.put(fyear + "-" + fmonth, resignHeadcountHis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        if (endYear == year && endMonth == month) {
            int resignHeadcount = (Integer)this._getResignHeadcount(ctx, orgId, 2, permItemId).get("resignHeadcount");
            if (sixMonthData.containsKey(year + "-" + month)) {
                sixMonthData.put(year + "-" + month, resignHeadcount);
            }
        }
        Map map = BriefUtil.getTrendMap(sixMonthData);
        resignHeadcountTrendMap.put("resignHeadcountTrend", map);
        return resignHeadcountTrendMap;
    }

    protected Map _getHeadcountTrend(Context ctx, String orgId, Date startDate, Date endDate, String permItemId, boolean isUserOrgIncludeSub) throws BOSException, EASBizException {
        this.checkDate(startDate, endDate);
        Map sixMonthData = CommonCodeMethods.getSixMonthData(startDate, endDate);
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = isUserOrgIncludeSub ? "" : " where t2.FAdminOrgID = '" + orgId + "'";
        HashMap<String, Map> headcountTrendMap = new HashMap<String, Map>();
        String filterStr = BriefUtil.getFilterStr(ctx, startDate, endDate);
        if (filterStr.length() > 0) {
            try {
                StringBuffer sql = new StringBuffer("select sum(t2.fendheadcount) as headcount,t2.fyear,t2.fmonth").append(" from (").append(" select fendlongnumber,fyear,fmonth from T_MGR_HRHeadcount").append(" where fadminorgid = '").append(orgId).append("' and (").append(filterStr).append(")").append(" ) t1").append(" left join T_MGR_HRHeadcount t2 on (charindex(concat(t1.fendlongnumber,'!'),t2.fendlongnumber) = 1 or t1.fendlongnumber = t2.fendlongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on t2.fadminorgid = range.forgid").append(" and t1.fyear = t2.fyear and t1.fmonth = t2.fmonth").append(includeSubSql).append(" group by t2.fyear,t2.fmonth").append(" order by t2.fyear asc,t2.fmonth asc");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rowSet.next()) {
                    int headcountHis = rowSet.getInt("headcount");
                    int fyear = rowSet.getInt("fyear");
                    int fmonth = rowSet.getInt("fmonth");
                    if (!sixMonthData.containsKey(fyear + "-" + fmonth)) continue;
                    sixMonthData.put(fyear + "-" + fmonth, headcountHis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        if (endYear == year && endMonth == month) {
            int headcount = (Integer)this._getActualStaffing(ctx, orgId, permItemId).get("actualStaffing");
            if (sixMonthData.containsKey(year + "-" + month)) {
                sixMonthData.put(year + "-" + month, headcount);
            }
        }
        Map map = BriefUtil.getTrendMap(sixMonthData);
        headcountTrendMap.put("headcountTrend", map);
        return headcountTrendMap;
    }

    protected Map _getStaffingOrgTrendByDate(Context ctx, String orgId, Date startDate, Date endDate) throws BOSException, EASBizException {
        this.checkDate(startDate, endDate);
        Map sixMonthData = CommonCodeMethods.getSixMonthData(startDate, endDate);
        ArrayList labelList = new ArrayList();
        ArrayList dataList = new ArrayList();
        HashMap map = new HashMap();
        map.put("labelList", labelList);
        map.put("dataList", dataList);
        HashMap<String, Map> staffingOrgTrendMap = new HashMap<String, Map>();
        staffingOrgTrendMap.put("staffingOrgTrend", map);
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        if (this.getStaffingChannel(ctx, startYear) == 0 && this.getStaffingChannel(ctx, endYear) == 0) {
            return staffingOrgTrendMap;
        }
        if (startYear < endYear) {
            this.getStaffingOrgTrend(ctx, staffingOrgTrendMap, orgId, startDate, BriefUtil.getDefaultMaxEndDate(startDate));
            this.getStaffingOrgTrend(ctx, staffingOrgTrendMap, orgId, BriefUtil.getDefaultMinStartDate(endDate), endDate);
        } else {
            this.getStaffingOrgTrend(ctx, staffingOrgTrendMap, orgId, startDate, endDate);
        }
        int index = 0;
        for (String key : sixMonthData.keySet()) {
            if (labelList.contains(key)) {
                ++index;
                continue;
            }
            dataList.add(index, sixMonthData.get(key));
            ++index;
        }
        return staffingOrgTrendMap;
    }

    @Override
    protected Map _getAffairPersonPageDetail(Context ctx, Map param) throws BOSException, EASBizException {
        String affairTypeStr = (String)param.get("affairTypeStr");
        param.put("ctx", ctx);
        String className = (String)empStrategyMap.get(affairTypeStr);
        Map result = null;
        try {
            Class<?> clz = Class.forName(className);
            Method method = clz.getMethod("logicInvoke", Map.class);
            result = (Map)method.invoke(clz.newInstance(), param);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

