/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.emplightapp.logicservices;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.emplightapp.logicservices.CommonCodeMethods;
import com.kingdee.shr.emplightapp.logicservices.IEmpStrategyService;
import com.kingdee.shr.emplightapp.util.BriefUtil;
import com.kingdee.shr.manager.HRAffairException;
import com.kingdee.shr.manager.util.HRManagerUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmpStrategyActualStaffPageService
implements IEmpStrategyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.emplightapp.logicservices.EmpStrategyActualStaffPageService");

    @Override
    public Object logicInvoke(Map<String, Object> param) throws BOSException, EASBizException {
        String datePoint = (String)param.get("datePoint");
        Context ctx = (Context)param.get("ctx");
        String orgId = (String)param.get("orgId");
        String permItemId = (String)param.get("permItemId");
        Integer page = (Integer)param.get("page");
        Integer rows = (Integer)param.get("rows");
        String conditionQuery = (String)param.get("conditionQuery");
        if (StringUtils.isEmpty((String)datePoint)) {
            throw new HRAffairException(HRAffairException.DATE_EMPTY_EXCEPTION);
        }
        String includeSubSql = CommonCodeMethods.includeSubSql(ctx, orgId, permItemId);
        int totalCount = 0;
        String detailListSql = "";
        int year = Integer.valueOf(datePoint.split("-")[0]);
        int month = Integer.valueOf(datePoint.split("-")[1]);
        int nowYear = DateTimeUtils.getYear((Date)new Date());
        int nowMonth = DateTimeUtils.getMonth((Date)new Date());
        HashMap<String, Object> filterParamsMap = new HashMap<String, Object>();
        filterParamsMap.put("conditionQuery", conditionQuery);
        if (nowYear == year && nowMonth == month) {
            totalCount = this.currentTotalCount(ctx, permItemId, includeSubSql, filterParamsMap);
            detailListSql = this.currentActualStaffPersonDetailSql(ctx, orgId, permItemId, includeSubSql, filterParamsMap);
        } else {
            int day = HRManagerUtil.getDay((int)year, (int)month);
            String endDateTs = " {ts'" + year + "-" + month + "-" + day + "'} ";
            filterParamsMap.put("endDateTs", endDateTs);
            totalCount = this.hisActualStaffTotalCount(ctx, permItemId, includeSubSql, endDateTs, filterParamsMap);
            detailListSql = this.hisActualStaffpersonDetailSql(ctx, permItemId, includeSubSql, endDateTs, filterParamsMap);
        }
        Map<String, Object> personMap = CommonCodeMethods.queryPageListData(ctx, page, rows, totalCount, detailListSql);
        return personMap;
    }

    private String hisActualStaffpersonDetailSql(Context ctx, String permItemId, String includeSubSql, String endDateTs, Map<String, Object> filterParamsMap) {
        String local = BriefUtil.getLocal(ctx);
        StringBuffer detailSql = new StringBuffer("select");
        CommonCodeMethods.selectDetailColumns(detailSql, local);
        this.hisActualStaffCommTable(ctx, permItemId, includeSubSql, filterParamsMap, detailSql, CommonCodeMethods.detailOnTableSql());
        CommonCodeMethods.orderByFilter(detailSql);
        return detailSql.toString();
    }

    private int hisActualStaffTotalCount(Context ctx, String permItemId, String includeSubSql, String endDateTs, Map<String, Object> filterParamsMap) throws BOSException {
        int actualStaffing = 0;
        StringBuffer totalSql = new StringBuffer("select count(emprelation.fpersonid) actualStaffing");
        this.hisActualStaffCommTable(ctx, permItemId, includeSubSql, filterParamsMap, totalSql, CommonCodeMethods.detailOnTableSql());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("print====currentTotalCount====\n" + totalSql));
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)totalSql.toString());
        try {
            while (rowSet.next()) {
                actualStaffing = rowSet.getInt("actualStaffing");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return actualStaffing;
    }

    private void hisActualStaffCommTable(Context ctx, String permItemId, String includeSubSql, Map<String, Object> filterParamsMap, StringBuffer sql, String detailOnTableSql) {
        String userId = BriefUtil.getUserId(ctx);
        String local = BriefUtil.getLocal(ctx);
        CommonCodeMethods.childAdminIdSql(sql, userId, ctx, permItemId);
        CommonCodeMethods.relationHisTableSql(sql, null, detailOnTableSql);
        CommonCodeMethods.hisActualStaffFilter(sql, includeSubSql, filterParamsMap, local);
    }

    private int currentTotalCount(Context ctx, String permItemId, String includeSubSql, Map<String, Object> filterParamsMap) throws BOSException {
        int actualStaffing = 0;
        StringBuffer totalSql = new StringBuffer("select count(emprelation.fpersonid) actualStaffing");
        this.currentActualStaffCommTable(ctx, permItemId, includeSubSql, filterParamsMap, totalSql, CommonCodeMethods.detailOnTableSql());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("print====currentTotalCount====\n" + totalSql));
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)totalSql.toString());
        try {
            while (rowSet.next()) {
                actualStaffing = rowSet.getInt("actualStaffing");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return actualStaffing;
    }

    private String currentActualStaffPersonDetailSql(Context ctx, String orgId, String permItemId, String includeSubSql, Map<String, Object> filterParamsMap) throws BOSException {
        String local = BriefUtil.getLocal(ctx);
        StringBuffer detailSql = new StringBuffer("select");
        CommonCodeMethods.selectDetailColumns(detailSql, local);
        this.currentActualStaffCommTable(ctx, permItemId, includeSubSql, filterParamsMap, detailSql, CommonCodeMethods.detailOnTableSql());
        CommonCodeMethods.orderByFilter(detailSql);
        return detailSql.toString();
    }

    private void currentActualStaffCommTable(Context ctx, String permItemId, String includeSubSql, Map<String, Object> filterParamsMap, StringBuffer sql, String detailOnTableSql) {
        String userId = BriefUtil.getUserId(ctx);
        String local = BriefUtil.getLocal(ctx);
        CommonCodeMethods.childAdminIdSql(sql, userId, ctx, permItemId);
        CommonCodeMethods.relationCurrentTableSql(sql, detailOnTableSql);
        CommonCodeMethods.currentActualStaffFilter(sql, includeSubSql, filterParamsMap, local);
    }
}

