/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.emplightapp.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.permission.sql.SHRPermissionSQL;
import com.kingdee.shr.manager.HRAdminFacadeFactory;
import com.kingdee.shr.self.model.ConfigData;
import com.kingdee.shr.self.service.IExternalDataService;
import com.kingdee.shr.self.util.HRConfigUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class BriefUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.manager.util.HRManagerUtil");
    public static final int monthBoundary = 0;
    public static final String defaultMaleImgPath = "/shr/addon/manager/web/webviews/framework/resource/male.png";
    public static final String defaultFemaleImgPath = "/shr/addon/manager/web/webviews/framework/resource/female.png";
    public static final String defaultNeutralImgPath = "/shr/addon/manager/web/webviews/framework/resource/neutral.png";
    public static final int maxIndicator = 2;
    public static final String nodataImgPath = "/shr/addon/manager/web/webviews/framework/resource/nodata.png";

    public static String getTempTableName(Context ctx) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempTableName = pool.createTempTableName();
        return tempTableName;
    }

    public static void relaseTempTable(Context ctx, String tempTableName) throws BOSException {
        if (!StringUtils.isEmpty((String)tempTableName)) {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            pool.releaseTable(tempTableName);
        }
    }

    public static String createTempTable(Context ctx, String orgId, String permItemId) throws BOSException {
        String userId = BriefUtil.getUserId(ctx);
        String tempTableName = null;
        try {
            tempTableName = BriefUtil.getTempTableName(ctx);
            StringBuffer sql = new StringBuffer(" select adminOrg.fid,adminOrg.fname_" + BriefUtil.getLocal(ctx) + " as fname,adminOrg.flongnumber,adminOrg.fisleaf,adminOrg.fsortcode into ").append(tempTableName).append(" from T_ORG_Admin adminOrg").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) orgRange on adminOrg.fid = orgRange.forgid").append(" where adminOrg.fparentid = '").append(orgId).append("' and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return tempTableName;
    }

    public static String createForewarnOrgRangeTempTable(Context ctx, String userId) throws BOSException {
        String userSql = BriefUtil.getUserSql(userId);
        String tempTableName = null;
        try {
            tempTableName = BriefUtil.getTempTableName(ctx);
            StringBuffer sql = new StringBuffer("select * into ").append(tempTableName).append(" from (").append(" select pmuser.fid fuserid,adminOrg.fid forgid,adminOrg.fname_" + BriefUtil.getLocal(ctx) + " fname,adminOrg.flongnumber").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid = emprelation.fpositionid").append(" inner join T_ORG_Admin adminOrg on position.fadminorgunitid = adminOrg.fid").append(" where pmuser.fid in ").append(userSql).append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" union").append(" select subOrg.fuserid,adminOrg.fid forgid,adminOrg.fname_" + BriefUtil.getLocal(ctx) + " fname,adminOrg.flongnumber").append(" from T_PM_OrgRangeIncludeSubOrg subOrg").append(" inner join T_ORG_Admin adminOrg on subOrg.forgid = adminOrg.fid").append(" inner join T_PM_User pmuser on subOrg.fuserid = pmuser.fid").append(" inner join T_HR_PersonPosition pp on pp.fpersonid = pmuser.fpersonid").append(" where subOrg.fuserid in ").append(userSql).append(" and subOrg.ftype = 20 and pp.fisleader = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" ) userOrgRange order by userOrgRange.fuserid asc,userOrgRange.flongnumber asc");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return tempTableName;
    }

    public static int getDay(int year, int month) {
        int day = 0;
        switch (month) {
            case 1: {
                day = 31;
                break;
            }
            case 2: {
                day = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 29 : 28;
                break;
            }
            case 3: {
                day = 31;
                break;
            }
            case 4: {
                day = 30;
                break;
            }
            case 5: {
                day = 31;
                break;
            }
            case 6: {
                day = 30;
                break;
            }
            case 7: {
                day = 31;
                break;
            }
            case 8: {
                day = 31;
                break;
            }
            case 9: {
                day = 30;
                break;
            }
            case 10: {
                day = 31;
                break;
            }
            case 11: {
                day = 30;
                break;
            }
            case 12: {
                day = 31;
            }
        }
        return day;
    }

    public static double mul(double d1, double d2) {
        BigDecimal b1 = BigDecimal.valueOf(d1);
        BigDecimal b2 = BigDecimal.valueOf(d2);
        return b1.multiply(b2).doubleValue();
    }

    public static double round(double d, int len) {
        if (len != 0) {
            BigDecimal b1 = BigDecimal.valueOf(d);
            BigDecimal b2 = new BigDecimal(1);
            return b1.divide(b2, len, 4).doubleValue();
        }
        return 0.0;
    }

    public static String rate(double d1, double d2) {
        if (d2 != 0.0) {
            BigDecimal b1 = BigDecimal.valueOf(d1);
            BigDecimal b2 = BigDecimal.valueOf(d2);
            double result = b1.divide(b2, 4, 4).doubleValue();
            return BriefUtil.round(BriefUtil.mul(result, 100.0), 2) + "%";
        }
        return "0%";
    }

    public static void getPercent(List<Map> list, int headcount) {
        BriefUtil.getPercent(list, headcount, "count");
    }

    public static void getPercent(List<Map> list, int headcount, String calculateName) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map map = list.get(i);
            int count = (Integer)map.get(calculateName);
            String percent = BriefUtil.rate(count, headcount);
            map.put("percent", percent);
        }
    }

    public static List getPercent2(List<Integer> list, int headcount) {
        ArrayList<Double> dataList = new ArrayList<Double>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            int count = list.get(i);
            double data = BriefUtil.percent(count, headcount);
            dataList.add(data);
        }
        return dataList;
    }

    public static void getValue(List<Map> list, double[] temp) {
        String tempStr = "";
        int size = list.size();
        block0: for (int i = 0; i < size; ++i) {
            Map map = list.get(i);
            String countStr = map.get("count").toString();
            double count = Double.parseDouble(countStr);
            int length = temp.length;
            for (int j = 0; j < length; ++j) {
                if (count != temp[j] || tempStr.indexOf(j + "") >= 0) continue;
                map.put("value", j + 1);
                tempStr = tempStr + j + ",";
                continue block0;
            }
        }
    }

    public static double percent(double d1, double d2) {
        if (d2 != 0.0) {
            BigDecimal b1 = BigDecimal.valueOf(d1);
            BigDecimal b2 = BigDecimal.valueOf(d2);
            double result = b1.divide(b2, 4, 4).doubleValue();
            return BriefUtil.round(BriefUtil.mul(result, 100.0), 2);
        }
        return 0.0;
    }

    public static Date getDefaultStartDate(Date date) throws BOSException {
        Date startDate = null;
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        if (month < 6) {
            --year;
            month += 7;
        } else {
            month -= 5;
        }
        int day = BriefUtil.getDay(year, month);
        try {
            startDate = DateTimeUtils.parseDate((String)(year + "-" + month + "-" + day));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return startDate;
    }

    public static String getFilterStr(Context ctx, Date startDate, Date endDate) {
        StringBuffer filterStr = new StringBuffer("");
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        if (endYear == year && endMonth == month) {
            if (endMonth == 1) {
                endMonth = 12;
                --endYear;
            } else {
                --endMonth;
            }
        }
        if (startYear == endYear && startMonth <= endMonth) {
            filterStr.append("fyear = ").append(startYear).append(" and fmonth in (");
            while (startMonth <= endMonth) {
                filterStr.append(startMonth).append(",");
                ++startMonth;
            }
            filterStr.delete(filterStr.length() - 1, filterStr.length());
            filterStr.append(")");
        } else {
            filterStr.append("(fyear = ").append(startYear).append(" and fmonth in (");
            while (startMonth <= 12) {
                filterStr.append(startMonth).append(",");
                ++startMonth;
            }
            filterStr.delete(filterStr.length() - 1, filterStr.length());
            filterStr.append(")) or (fyear = ").append(endYear).append(" and fmonth in (");
            for (int m = 1; m <= endMonth; ++m) {
                filterStr.append(m).append(",");
            }
            filterStr.delete(filterStr.length() - 1, filterStr.length());
            filterStr.append("))");
        }
        return filterStr.toString();
    }

    public static String getYOYFilterStr(Context ctx, Date startDate, Date endDate) {
        int startMonth;
        StringBuffer filterStr = new StringBuffer("");
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        if (--startYear == --endYear && startMonth <= endMonth) {
            filterStr.append("fyear = ").append(startYear).append(" and fmonth in (");
            for (startMonth = DateTimeUtils.getMonth((Date)startDate); startMonth <= endMonth; ++startMonth) {
                filterStr.append(startMonth).append(",");
            }
            filterStr.delete(filterStr.length() - 1, filterStr.length());
            filterStr.append(")");
        } else {
            filterStr.append("(fyear = ").append(startYear).append(" and fmonth in (");
            while (startMonth <= 12) {
                filterStr.append(startMonth).append(",");
                ++startMonth;
            }
            filterStr.delete(filterStr.length() - 1, filterStr.length());
            filterStr.append(")) or (fyear = ").append(endYear).append(" and fmonth in (");
            for (int m = 1; m <= endMonth; ++m) {
                filterStr.append(m).append(",");
            }
            filterStr.delete(filterStr.length() - 1, filterStr.length());
            filterStr.append("))");
        }
        return filterStr.toString();
    }

    public static Date getDefaultMinStartDate(Date date) throws BOSException {
        Date startDate = null;
        int year = DateTimeUtils.getYear((Date)date);
        try {
            startDate = DateTimeUtils.parseDate((String)(year + "-01-01"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return startDate;
    }

    public static Date getDefaultMaxEndDate(Date date) throws BOSException {
        Date endDate = null;
        int year = DateTimeUtils.getYear((Date)date);
        try {
            endDate = DateTimeUtils.parseDate((String)(year + "-12-31"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return endDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertBlobToBase64(Blob blob) {
        String str = "";
        if (blob != null) {
            byte[] data = null;
            InputStream in = null;
            try {
                in = blob.getBinaryStream();
                data = new byte[in.available()];
                in.read(data);
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error((Object)"getBase64PersonPhoto===", (Throwable)e);
            }
            catch (SQLException e) {
                e.printStackTrace();
                logger.error((Object)"getBase64PersonPhoto===", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        logger.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            str = Base64.encodeBytes((byte[])data);
        }
        return str;
    }

    public static String getUserId(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo != null ? userInfo.getId().toString() : (String)ctx.get((Object)"userID");
        return userId;
    }

    public static String getLocal(Context ctx) {
        String local = ctx.getLocale() != null ? ctx.getLocale().toString() : "l2";
        return local;
    }

    public static String getPersonPositionResponseAdminSql(String userId) {
        StringBuffer sql = new StringBuffer("select child.fid as forgId").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid= emprelation.fpositionid").append(" inner join T_ORG_Admin adcount on position.fadminorgunitid = adcount.fid").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" where pmuser.fid = '").append(userId).append("'").append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition = 1").append(" and child.fissealup = 0").append(" and child.fisstartshr = 1");
        return sql.toString();
    }

    public static String getAdminRangeSql(Context ctx, String userId, String permItemId) {
        StringBuffer sql = new StringBuffer("select adminOrg.fid as forgId").append(" from t_org_admin adminOrg").append(" where fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId) + ")");
        return sql.toString();
    }

    public static String getUserSql(String userId) {
        if (!StringUtils.isEmpty((String)userId)) {
            StringBuffer sql = new StringBuffer("(");
            String[] userIds = userId.split(",");
            int length = userIds.length;
            for (int i = 0; i < length; ++i) {
                sql.append("'").append(userIds[i]).append("',");
            }
            int length2 = sql.length();
            sql.delete(length2 - 1, length2);
            sql.append(")");
            return sql.toString();
        }
        return "('')";
    }

    public static Map convertObjectToMap(Object o) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(o.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.compareToIgnoreCase("class") == 0 || o instanceof ConfigData && key.equalsIgnoreCase("element")) continue;
                Method getter = property.getReadMethod();
                Object value = getter != null ? getter.invoke(o, new Object[0]) : null;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public static Object getExternalData(String externalDataClass, Map param) throws BOSException {
        HashMap map = null;
        try {
            Class<?> clazz = Class.forName(externalDataClass);
            IExternalDataService iExternalDataService = (IExternalDataService)clazz.newInstance();
            Object obj = iExternalDataService.getExternalData(param);
            if (obj != null) {
                JSONObject jsonObj = JSONObject.fromObject((Object)obj);
                map = HRConfigUtil.convertJSONMap((JSONObject)jsonObj);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public static int getToltalCount(Context ctx, String sql) throws BOSException, EASBizException {
        int toltalCount = 0;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                toltalCount = rowSet.getInt("totalCount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return toltalCount;
    }

    public static String getDefaultOrgId(Context ctx) throws BOSException, EASBizException {
        String orgId = "";
        Map map = HRAdminFacadeFactory.getLocalInstance((Context)ctx).getOrgTreeData(orgId);
        if (map.size() > 0) {
            Map defaultOrgMap = (Map)((List)map.get("orgTree")).get(0);
            orgId = (String)defaultOrgMap.get("id");
        }
        return orgId;
    }

    public static String getStringFilter(String str) {
        StringBuffer filter = new StringBuffer("");
        String[] s = str.split(",");
        if (s.length > 0) {
            filter.append(" in ( ");
            int size = s.length;
            for (int i = 0; i < size; ++i) {
                filter.append("'").append(s[i]).append("',");
            }
            filter.delete(filter.length() - 1, filter.length());
            filter.append(" )");
        }
        return filter.toString();
    }

    public static String getIntFilter(String str) {
        StringBuffer filter = new StringBuffer("");
        String[] s = str.split(",");
        if (s.length > 0) {
            filter.append(" in ( ");
            int size = s.length;
            for (int i = 0; i < size; ++i) {
                filter.append(s[i]).append(",");
            }
            filter.delete(filter.length() - 1, filter.length());
            filter.append(" )");
        }
        return filter.toString();
    }

    public static boolean containStr(String source, String target) {
        StringBuffer filter = new StringBuffer("");
        String[] s = source.split(",");
        for (int i = 0; i < s.length; ++i) {
            if (!s[i].equals(target)) continue;
            return true;
        }
        return false;
    }

    public static String createUserOrgRangeTempTable(Context ctx, String userId) throws BOSException {
        String userSql = BriefUtil.getUserSql(userId);
        String tempTableName = null;
        try {
            tempTableName = BriefUtil.getTempTableName(ctx);
            StringBuffer sql = new StringBuffer("select * into ").append(tempTableName).append(" from (").append(" select pmuser.fid fuserid,adminOrg.fid forgid,adminOrg.fname_" + BriefUtil.getLocal(ctx) + " fname,adminOrg.flongnumber").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid = emprelation.fpositionid").append(" inner join T_ORG_Admin adminOrg on position.fadminorgunitid = adminOrg.fid").append(" where pmuser.fid in ").append(userSql).append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" union").append(" select subOrg.fuserid,adminOrg.fid forgid,adminOrg.fname_" + BriefUtil.getLocal(ctx) + " fname,adminOrg.flongnumber").append(" from T_PM_OrgRangeIncludeSubOrg subOrg").append(" inner join T_ORG_Admin adminOrg on subOrg.forgid = adminOrg.fid").append(" inner join T_PM_User pmuser on subOrg.fuserid = pmuser.fid").append(" inner join T_HR_PersonPosition pp on pp.fpersonid = pmuser.fpersonid").append(" where subOrg.fuserid in ").append(userSql).append(" and subOrg.ftype = 20 and pp.fisleader = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" ) userOrgRange order by userOrgRange.fuserid asc,userOrgRange.flongnumber asc");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return tempTableName;
    }

    public static Map getSixMonthData() throws BOSException {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        Date startDate = BriefUtil.getDefaultStartDate(new Date());
        Date endDate = new Date();
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        if (startYear == endYear) {
            for (int m = startMonth; m <= endMonth; ++m) {
                map.put(startYear + "-" + m, 0);
            }
        } else {
            int m;
            for (m = startMonth; m <= 12; ++m) {
                map.put(startYear + "-" + m, 0);
            }
            for (m = 1; m <= endMonth; ++m) {
                map.put(endYear + "-" + m, 0);
            }
        }
        return map;
    }

    public static Map getTrendMap(Map map) throws BOSException {
        HashMap resultMap = new HashMap();
        ArrayList<String> labelList = new ArrayList<String>();
        ArrayList<Integer> dataList = new ArrayList<Integer>();
        for (Map.Entry entry : map.entrySet()) {
            String label = (String)entry.getKey();
            labelList.add(label);
            int data = (Integer)entry.getValue();
            dataList.add(data);
        }
        resultMap.put("labelList", labelList);
        resultMap.put("dataList", dataList);
        return resultMap;
    }

    public static HashSet<String> getDefaultId() {
        HashSet<String> defualtBillId = new HashSet<String>();
        defualtBillId.add("8r0AAAAKskiyfgJj");
        defualtBillId.add("8r0AAAAKxdAVWxqK");
        defualtBillId.add("8r0AAAALeYNA42+n");
        defualtBillId.add("8r0AAAAKf5D8Co0g");
        defualtBillId.add("8r0AAAAKf4lsrgZ3");
        defualtBillId.add("8r0AAAAKf4aYteXk");
        defualtBillId.add("8r0AAAAKg272/Jmm");
        defualtBillId.add("8r0AAAAKg3Vjc0wq");
        return defualtBillId;
    }

    public static String getRootAdminId() {
        return "00000000-0000-0000-0000-000000000000CCE7AED4";
    }

    public static List getSixMonth() {
        ArrayList<String> result = new ArrayList<String>();
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        for (int i = 0; i < 6; ++i) {
            result.add(year + "-" + month);
            if (month == 1) {
                --year;
                month = 12;
                continue;
            }
            --month;
        }
        return result;
    }

    public static int getBeginHeadcount(Context ctx, String orgId, int year, int month, String permItemId) throws BOSException {
        String userId = BriefUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = BriefUtil.isUserOrgIncludeSub(ctx, userId, orgId, permItemId) ? " where t1.fadminorgid = '" + orgId + "'" : " where t2.fadminorgid = '" + orgId + "' and t1.fadminorgid = '" + orgId + "'";
        int headcount = 0;
        try {
            StringBuffer sql = new StringBuffer("select isnull(sum(t2.fbeginheadcount),0) headcount").append(" from T_MGR_HRHeadcount t1").append(" inner join T_MGR_HRHeadcount t2 on (charindex(concat(t1.fbeginlongnumber,'!'),t2.fbeginlongnumber) = 1 or t1.fbeginlongnumber = t2.fbeginlongnumber)").append(" inner join (").append(BriefUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(BriefUtil.getAdminRangeSql(ctx, userId, permItemId)).append(" ) range on t1.fadminorgid = range.forgid").append(includeSubSql).append(" and t1.fyear = " + year + " and t1.fmonth = " + month).append(" and t1.fyear = t2.fyear and t1.fmonth = t2.fmonth");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                headcount = rowSet.getInt("headcount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return headcount;
    }

    public static boolean isUserOrgIncludeSub(Context ctx, String userId, String orgId, String permItemId) throws BOSException {
        return true;
    }

    public static String getConfigId(Context ctx, String adminorgid, String tableName) throws BOSException {
        HashMap<String, String> adminConfigMap = new HashMap<String, String>();
        ArrayList<String> adminIdList = new ArrayList<String>();
        String configId = null;
        try {
            String tempSqlString = "select fadminorgid,fid from " + tableName + " where fstate = 1";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)tempSqlString);
            while (rowSet.next()) {
                adminConfigMap.put(rowSet.getString("fadminorgid"), rowSet.getString("fid"));
                adminIdList.add(rowSet.getString("fadminorgid"));
            }
            String configAdminIdsStr = HRUtilExtend.getStrFromList(adminIdList);
            String sourceLongnumber = "";
            HashMap<String, String> targetMap = new HashMap<String, String>();
            String sourceSql = "select flongnumber from t_org_admin where fid = '" + adminorgid + "'";
            String targetSql = "select flongnumber,fid from t_org_admin where fid in " + configAdminIdsStr;
            IRowSet sourceRowSet = DbUtil.executeQuery((Context)ctx, (String)sourceSql);
            while (sourceRowSet.next()) {
                sourceLongnumber = sourceRowSet.getString("flongnumber");
            }
            IRowSet targetRowSet = DbUtil.executeQuery((Context)ctx, (String)targetSql);
            while (targetRowSet.next()) {
                targetMap.put(targetRowSet.getString("flongnumber"), targetRowSet.getString("fid"));
            }
            if (targetMap.containsKey(sourceLongnumber)) {
                configId = (String)targetMap.get(sourceLongnumber);
            }
            String newLongnumber = sourceLongnumber;
            int sourceLevel = sourceLongnumber.split("!").length + 1;
            for (int i = 0; i < sourceLevel; ++i) {
                if (targetMap.containsKey(newLongnumber)) {
                    configId = (String)targetMap.get(newLongnumber);
                    break;
                }
                if (newLongnumber.lastIndexOf("!") == -1) {
                    // empty if block
                }
                int index = newLongnumber.lastIndexOf("!");
                newLongnumber = newLongnumber.substring(0, index);
            }
            if (configId == null) {
                logger.info((Object)"****getConfigId*****configId****is null");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return (String)adminConfigMap.get(configId);
    }

    public static List<String> getMangaerPermList(Context ctx, String userId) {
        ArrayList<String> resultList = new ArrayList<String>();
        ArrayList<String> permIdsList = new ArrayList<String>();
        permIdsList.add("fffffff0-ffff-efff-7bbe-0000009cad60PERMITEM");
        String permItemIds = HRUtilExtend.getStrFromList(permIdsList);
        StringBuffer sql = new StringBuffer();
        sql.append("select count(distinct uniontemp.fpermitemid) cnt, uniontemp.fpermitemid ").append(" from (").append(" select shruser.fpermitemid  from T_HR_SHRUserAdminOrgPerm  shruser ").append(" where  FUserId ='").append(userId).append("' and ").append(" FPermItemId in ").append(permItemIds).append(" union ").append(" select t2.fpermitemid from  T_HR_SHRRoleAdminOrgPerm  t0").append(" inner join T_PM_RolePerm t2 on t2.FROLEID=t0.FRoleID").append(" where ").append(" t0.FUserId = '").append(userId).append("'").append(" and t2.FPermItemId in ").append(permItemIds).append(" and exists(SELECT 1 FROM T_PM_UserRoleOrg t1 where t1.FROLEID=t0.FRoleID and t1.FUserId = '").append(userId).append("') ").append(" ) uniontemp ").append("  group by uniontemp.fpermitemid");
        if (logger.isDebugEnabled()) {
            // empty if block
        }
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (iRowSet.next()) {
                resultList.add(iRowSet.getString("fpermitemid"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static String getUserAdminOrgRangeSQL(Context ctx, String userId, String permItemId) {
        StringBuffer newPermSql = new StringBuffer();
        newPermSql.append(" SELECT shrperm.FAdminOrgID ,shrperm.FIsIncludeSubOrg fisIncludeSubOrg FROM T_HR_SHRUserAdminOrgPerm  shrperm").append(" where shrperm.FUserId = '").append(userId).append("'").append(" and shrperm.FPermItemId = '").append(permItemId).append("'").append(" and shrperm.FIsForbidden = 0 ").append(" union ").append(" select t0.FAdminOrgID ,t0.FIsIncludeSubOrg fisIncludeSubOrg from T_HR_SHRRoleAdminOrgPerm t0").append(" inner join T_PM_RolePerm t2 on t2.FROLEID=t0.FRoleID ").append(" where t0.FUserId = '").append(permItemId).append("'").append(" and exists(SELECT 1 FROM T_PM_UserRoleOrg t1 where t1.FROLEID=t0.FRoleID and t1.FUserId = '").append(userId).append("') ").append(" and t0.FIsForbidden = 0 ");
        StringBuffer oldPermSql = new StringBuffer();
        oldPermSql.append("SELECT FAdminOrgID, includeSub as fisincludesuborg from (");
        oldPermSql.append("SELECT range.FOrgID FAdminOrgID, 0 as includeSub FROM T_PM_OrgRangeIncludeSubOrg range LEFT OUTER JOIN T_ORG_ADMIN adminOrg on range.FORGID = adminOrg.FID WHERE range.FUserID = ");
        oldPermSql.append("'").append(userId).append("'");
        oldPermSql.append(" AND range.FType = ").append(20);
        oldPermSql.append(" AND range.FIsIncludeSubOrg = 0");
        oldPermSql.append(" union all ");
        oldPermSql.append(" SELECT org.FID FAdminOrgID, 1 as includeSub FROM  (");
        oldPermSql.append(" SELECT orgRange.FOrgID,adminOrg.FLONGNUMBER FROM T_PM_OrgRangeIncludeSubOrg orgRange ");
        oldPermSql.append(" inner join T_ORG_Admin adminOrg ");
        oldPermSql.append(" on orgRange.FOrgID = adminOrg.FID ");
        oldPermSql.append(" where orgRange.fuserid = '").append(userId).append("'");
        oldPermSql.append(" and orgRange.FIsIncludeSubOrg = 1");
        oldPermSql.append(" ) detail ");
        oldPermSql.append(" inner join T_ORG_Admin org ");
        oldPermSql.append(" on ( CHARINDEX( concat(detail.flongnumber,'!'),org.flongnumber )=1 ");
        oldPermSql.append(" or detail.flongnumber = org.flongnumber)");
        oldPermSql.append(" ) newPerm ");
        if (SHRPermissionSQL.hasHRUserAdminOrgRange((Context)ctx, (String)userId, (String)permItemId)) {
            return newPermSql.toString();
        }
        return oldPermSql.toString();
    }

    public static boolean getUserIsLeader(Context ctx, String userId) {
        boolean isLeader = false;
        String leaderSql = "select * from t_hr_personpositionextend where fpersonid in (select fpersonid from t_pm_user where fid ='" + userId + "') and fisleader=1";
        try {
            IRowSet isLeaderRowSet = DbUtil.executeQuery((Context)ctx, (String)leaderSql);
            isLeader = isLeaderRowSet.size() > 0;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        return isLeader;
    }
}

