/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shrimport.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.shr.shrimport.ImportTemplateStateEnum;
import com.kingdee.shr.shrimport.SHRFileTemplateInfo;
import com.kingdee.shr.shrimport.app.AbstractSHRFileTemplateControllerBean;
import com.kingdee.shr.shrimport.util.ShrFileImportUtil;
import org.apache.log4j.Logger;

public class SHRFileTemplateControllerBean
extends AbstractSHRFileTemplateControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.shrimport.app.SHRFileTemplateControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SHRFileTemplateInfo template = (SHRFileTemplateInfo)model;
        this.checkNameBlank(ctx, template);
        this.checkNameDup(ctx, template);
        ShrFileImportUtil.initShrFileTemplate(ctx, template);
        return super._save(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SHRFileTemplateInfo model = this.getSHRFileTemplateInfo(ctx, pk);
        if (null == model) {
            throw new SyssettinException(SyssettinException.TEMPLATE_DELETE_FAILS);
        }
        if (model.isIsPreset()) {
            throw new SyssettinException(SyssettinException.SYSDEFAULT_NOT_DELETE, new Object[]{model.getName()});
        }
        if (ImportTemplateStateEnum.ENABLE.equals((Object)model.getState())) {
            throw new SyssettinException(SyssettinException.ENABLED_NOT_DELETE, new Object[]{model.getName()});
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _enable(Context ctx, String templateId) throws BOSException, EASBizException {
        this.updateImportTemplateState(ctx, templateId, ImportTemplateStateEnum.ENABLE);
    }

    @Override
    protected void _disable(Context ctx, String templateId) throws BOSException, EASBizException {
        this.updateImportTemplateState(ctx, templateId, ImportTemplateStateEnum.DISABLE);
    }

    private String updateImportTemplateState(Context ctx, String templateId, ImportTemplateStateEnum state) throws EASBizException, BOSException {
        String result = "";
        if (!this.exists(ctx, (IObjectPK)new ObjectUuidPK(templateId))) {
            throw new SyssettinException(SyssettinException.IMPROT_TEMPLATE_ID_NOFOUND, new Object[]{templateId});
        }
        SHRFileTemplateInfo model = this.getSHRFileTemplateInfo(ctx, (IObjectPK)new ObjectUuidPK(templateId));
        if (ImportTemplateStateEnum.DISABLE.equals((Object)model.getState()) && ImportTemplateStateEnum.DISABLE.equals((Object)state)) {
            throw new SyssettinException(SyssettinException.TEMPLATE_ALREADY_DISABLE, new Object[]{model.getName()});
        }
        if (ImportTemplateStateEnum.ENABLE.equals((Object)model.getState()) && ImportTemplateStateEnum.ENABLE.equals((Object)state)) {
            throw new SyssettinException(SyssettinException.TEMPLATE_ALREADY_ENABLE, new Object[]{model.getName()});
        }
        model.setState(state);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(templateId), (CoreBaseInfo)model);
        result = ImportTemplateStateEnum.DISABLE.equals((Object)state) ? SHRSysSettingResourceUtil.getResource((String)"template_disabled_success", (Context)ctx) : SHRSysSettingResourceUtil.getResource((String)"template_enable_success", (Context)ctx);
        return result;
    }
}

