/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inteshrtrain.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.service.message.Message;
import com.kingdee.bos.service.message.agent.DirectSenderAgent;
import com.kingdee.bos.service.message.agent.MessageFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.inteshrtrain.InitSyncTaskFactory;
import com.kingdee.shr.inteshrtrain.InitSyncTaskInfo;
import com.kingdee.shr.inteshrtrain.InteSchemeCollection;
import com.kingdee.shr.inteshrtrain.InteSchemeFactory;
import com.kingdee.shr.inteshrtrain.InteSchemeInfo;
import com.kingdee.shr.inteshrtrain.app.InitSyncEnum;
import com.kingdee.shr.inteshrtrain.app.RequestArea;
import com.kingdee.shr.inteshrtrain.service.SyncAdminOrgModelFactory;
import com.kingdee.shr.inteshrtrain.service.SyncPersonModelFactory;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class InitSyncModelTaskExecutor
implements Runnable {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.inteshrtrain.service.InitSyncModelTaskExecutor");
    private Context ctx;
    private InitSyncTaskInfo task;
    private String schemeId;

    public InitSyncModelTaskExecutor(Context context, String schemeId, InitSyncTaskInfo task) {
        this.ctx = context;
        this.schemeId = schemeId;
        this.task = task;
    }

    @Override
    public void run() {
        String oql = "where isUsing = 1 and id = '" + this.schemeId + "'";
        InteSchemeCollection schemeInfoColl = null;
        try {
            schemeInfoColl = InteSchemeFactory.getLocalInstance(this.ctx).getInteSchemeCollection(oql);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        if (schemeInfoColl != null && schemeInfoColl.size() > 0) {
            InteSchemeInfo schemeInfo = schemeInfoColl.get(0);
            int totalCount = 0;
            int successCount = 0;
            int defeatCount = 0;
            Map<Object, Object> adminOrgMap = new HashMap<String, Integer>();
            adminOrgMap.put("totalCount", 0);
            adminOrgMap.put("successCount", 0);
            adminOrgMap.put("defeatCount", 0);
            Map<Object, Object> personMap = new HashMap<String, Integer>();
            personMap.put("totalCount", 0);
            personMap.put("successCount", 0);
            personMap.put("defeatCount", 0);
            try {
                String taskId = this.task.getId().toString();
                InitSyncTaskInfo taskInfo = InitSyncTaskFactory.getLocalInstance(this.ctx).getInitSyncTaskInfo((IObjectPK)new ObjectUuidPK(taskId));
                InitSyncEnum state = taskInfo.getState();
                if (state != null && !state.equals((Object)InitSyncEnum.SAVE) && !state.equals((Object)InitSyncEnum.RUNNING)) {
                    return;
                }
                this.task.setBeginTime(new Timestamp(System.currentTimeMillis()));
                this.task.setState(InitSyncEnum.RUNNING);
                InitSyncTaskFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.task);
                SyncAdminOrgModelFactory syncAdminModelFactory = new SyncAdminOrgModelFactory();
                adminOrgMap = syncAdminModelFactory.getSyncModelDataInstance().initSyncOfModel(this.ctx, schemeInfo, RequestArea.ADMINORG, this.task.getNumber());
                SyncPersonModelFactory syncPersonModelFactory = new SyncPersonModelFactory();
                personMap = syncPersonModelFactory.getSyncModelDataInstance().initSyncOfModel(this.ctx, schemeInfo, RequestArea.EMPLOYEE, this.task.getNumber());
                this.task.setEndTime(new Timestamp(System.currentTimeMillis()));
                totalCount = (Integer)adminOrgMap.get("totalCount") + (Integer)personMap.get("totalCount");
                successCount = (Integer)adminOrgMap.get("successCount") + (Integer)personMap.get("successCount");
                defeatCount = (Integer)adminOrgMap.get("defeatCount") + (Integer)personMap.get("defeatCount");
                StringBuilder detail = new StringBuilder();
                detail.append("total:" + totalCount);
                detail.append("(" + RequestArea.ADMINORG.getAlias() + ":" + adminOrgMap.get("totalCount") + ",");
                detail.append(RequestArea.EMPLOYEE.getAlias() + ":" + personMap.get("totalCount") + "),");
                detail.append("success:" + successCount);
                detail.append("(" + RequestArea.ADMINORG.getAlias() + ":" + adminOrgMap.get("successCount") + ",");
                detail.append(RequestArea.EMPLOYEE.getAlias() + ":" + personMap.get("successCount") + "),");
                detail.append("failure:" + defeatCount);
                detail.append("(" + RequestArea.ADMINORG.getAlias() + ":" + adminOrgMap.get("defeatCount") + ",");
                detail.append(RequestArea.EMPLOYEE.getAlias() + ":" + personMap.get("defeatCount") + ")");
                this.task.setDetailCount(detail.toString());
                if (!this.task.getState().equals((Object)InitSyncEnum.RUNNING)) {
                    this.task.setState(InitSyncEnum.STOP);
                } else {
                    this.task.setState(InitSyncEnum.DONE);
                }
                this.task.setTotalCount(totalCount);
                this.task.setSuccessCount(successCount);
                this.task.setDefeatCount(defeatCount);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)this.task.toString());
                }
                InitSyncTaskFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.task);
                schemeInfo.setInitSuccess(true);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("initSuccess"));
                InteSchemeFactory.getLocalInstance(this.ctx).updatePartial(schemeInfo, sic);
                this.sendComplateMessage(totalCount, successCount, defeatCount);
            }
            catch (Exception e) {
                e.printStackTrace();
                totalCount = (Integer)adminOrgMap.get("totalCount") + (Integer)personMap.get("totalCount");
                successCount = (Integer)adminOrgMap.get("successCount") + (Integer)personMap.get("successCount");
                defeatCount = (Integer)adminOrgMap.get("defeatCount") + (Integer)personMap.get("defeatCount");
                this.task.setState(InitSyncEnum.ERRORSTOP);
                this.task.setTotalCount(totalCount);
                this.task.setSuccessCount(successCount);
                this.task.setDefeatCount(defeatCount);
                try {
                    InitSyncTaskFactory.getLocalInstance(this.ctx).save((CoreBaseInfo)this.task);
                    this.sendComplateMessage(totalCount, successCount, defeatCount);
                }
                catch (EASBizException e1) {
                    e1.printStackTrace();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void sendComplateMessage(int totalCount, int successCount, int defeatCount) {
        Context ctx = this.ctx;
        String userId = ctx.getCaller().toString();
        Message message = MessageFactory.newMessage();
        message.setBooleanHeader("isSendCommon", Boolean.TRUE.booleanValue());
        InitSyncTaskInfo taskInfo = this.task;
        if (InitSyncEnum.DONE.getValue() == taskInfo.getState().getValue()) {
            message.setLocaleStringHeader("title", this.task.getName(), LocaleUtils.locale_l2);
        }
        StringBuffer bodySb1 = new StringBuffer();
        bodySb1.append("total: " + totalCount + "; success: " + successCount + "; failure: " + defeatCount + ";");
        message.setLocaleStringHeader("body", bodySb1.toString(), LocaleUtils.locale_l2);
        message.setIntHeader("type", 0);
        message.setIntHeader("bizType", 70);
        message.setIntHeader("priority", 20);
        message.setIntHeader("sourceStatus", 0);
        message.setStringHeader("solution", ctx.getSolution());
        message.setStringHeader("databaseCenter", ctx.getAIS());
        message.setStringHeader("receiver", userId);
        message.setStringHeader("senderId", userId);
        message.setLocaleStringHeader("sender", SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)LocaleUtils.locale_l1), LocaleUtils.locale_l1);
        message.setLocaleStringHeader("sender", SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)LocaleUtils.locale_l2), LocaleUtils.locale_l2);
        message.setLocaleStringHeader("sender", SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        message.setLocaleStringHeader("initiatorName", SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)LocaleUtils.locale_l1), LocaleUtils.locale_l1);
        message.setLocaleStringHeader("initiatorName", SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)LocaleUtils.locale_l2), LocaleUtils.locale_l2);
        message.setLocaleStringHeader("initiatorName", SHRServerResource.getString((String)"com.kingdee.shr.base.syssetting.CommonserviceResource", (String)"sys_auto_send", (Locale)LocaleUtils.locale_l3), LocaleUtils.locale_l3);
        DirectSenderAgent.getSenderAgent().sendMessage(message);
    }

    public Context getContext() {
        return this.ctx;
    }

    public void setContext(Context context) {
        this.ctx = context;
    }

    public String getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(String schemeId) {
        this.schemeId = schemeId;
    }

    public InitSyncTaskInfo getTask() {
        return this.task;
    }

    public void setTask(InitSyncTaskInfo task) {
        this.task = task;
    }
}

