/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inteshrtrain.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.inteshrtrain.InteSchemeConfigCollection;
import com.kingdee.shr.inteshrtrain.InteSchemeConfigFactory;
import com.kingdee.shr.inteshrtrain.InteSchemeConfigInfo;
import com.kingdee.shr.inteshrtrain.InteSchemeInfo;
import com.kingdee.shr.inteshrtrain.InteShrTrainException;
import com.kingdee.shr.inteshrtrain.InteTrainModelMappingCollection;
import com.kingdee.shr.inteshrtrain.InteTrainModelMappingFactory;
import com.kingdee.shr.inteshrtrain.InteTrainModelMappingInfo;
import com.kingdee.shr.inteshrtrain.InteTrainWaitModelCollection;
import com.kingdee.shr.inteshrtrain.InteTrainWaitModelFactory;
import com.kingdee.shr.inteshrtrain.InteTrainWaitModelInfo;
import com.kingdee.shr.inteshrtrain.InterfaceTrainLogFactory;
import com.kingdee.shr.inteshrtrain.InterfaceTrainLogInfo;
import com.kingdee.shr.inteshrtrain.app.RequestArea;
import com.kingdee.shr.inteshrtrain.app.RequestKey;
import com.kingdee.shr.inteshrtrain.app.RequestType;
import com.kingdee.shr.inteshrtrain.util.HttpClientUtils;
import com.kingdee.shr.inteshrtrain.util.InteShrUtil;
import com.kingdee.shr.inteshrtrain.util.JSONHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class InteShrTrainService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.inteshrtrain.service.InteShrTrainService");
    private static final int TOKEN_MAX = 5;

    private InteShrTrainService() {
    }

    public static InteShrTrainService getInstance() {
        return InteShrTrainServiceHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getToken(Context ctx, InteSchemeInfo schemeInfo) throws BOSException, EASBizException, SQLException {
        String token = InteShrUtil.getTokenFromCache(schemeInfo.getId().toString());
        if (StringUtils.isEmpty((String)token)) {
            String oql = "where reqKey = 1 and scheme = '" + schemeInfo.getId() + "'";
            InteSchemeConfigCollection colls = InteSchemeConfigFactory.getLocalInstance(ctx).getInteSchemeConfigCollection(oql);
            if (colls != null && colls.size() > 0) {
                InteSchemeConfigInfo configInfo = colls.get(0);
                if (configInfo.isIsStart()) {
                    InteShrTrainService inteShrTrainService = this;
                    synchronized (inteShrTrainService) {
                        token = InteShrUtil.getTokenFromCache(schemeInfo.getId().toString());
                        if (StringUtils.isEmpty((String)token)) {
                            String tokenStr = this.getTokenService(ctx, schemeInfo, configInfo);
                            InteShrUtil.addTokenToCache(schemeInfo.getId().toString(), tokenStr);
                            token = tokenStr;
                        }
                    }
                } else {
                    throw new InteShrTrainException(InteShrTrainException.INTERFACE_NOT_START, new Object[]{configInfo.getReqArea().toString()});
                }
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("token:" + token));
        }
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTokenService(Context ctx, InteSchemeInfo schemeInfo, InteSchemeConfigInfo configInfo) throws EASBizException, BOSException, SQLException {
        int requestNum = InteShrUtil.getTokenReqNumFromCache(schemeInfo.getId().toString());
        String result = "";
        Map<Object, Object> dataStrMap = new HashMap();
        String url = configInfo.getInterfaceUrl();
        HashMap<String, String> reqParam = new HashMap<String, String>();
        reqParam.put("corpid", schemeInfo.getCompanyID());
        reqParam.put("corpsecret", schemeInfo.getCompanySecret());
        dataStrMap = HttpClientUtils.doGet(url, reqParam);
        String dataStr = (String)dataStrMap.get("resultString");
        if ("401".equals(dataStrMap.get("statusCode"))) {
            InteShrUtil.addTokenReqNumToCache(schemeInfo.getId().toString(), ++requestNum);
            if (requestNum > 5) throw new InteShrTrainException(InteShrTrainException.TOKEN_FAILED);
            return this.getTokenService(ctx, schemeInfo, configInfo);
        }
        if ("500".equals(dataStrMap.get("statusCode"))) {
            InteShrUtil.addTokenReqNumToCache(schemeInfo.getId().toString(), ++requestNum);
            if (requestNum > 5) throw new InteShrTrainException(InteShrTrainException.SERVER_NOT_AVAILABLE);
            result = this.getTokenService(ctx, schemeInfo, configInfo);
            throw new InteShrTrainException(InteShrTrainException.SERVER_NOT_AVAILABLE);
        }
        if (StringUtils.isEmpty((String)dataStr)) return result;
        String targetTokenKey = schemeInfo.getTokenKey();
        result = JSONHelper.getTargetString(dataStr, targetTokenKey);
        this.saveInterfaceLog(ctx, schemeInfo, configInfo, null, null, dataStr, true, null);
        return result;
    }

    public boolean syncTrainDataForDelete(Context ctx, InteSchemeInfo schemeInfo, RequestArea ra, HashSet<String> resultSet, boolean isSpecial) throws EASBizException, BOSException, SQLException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("InteShrTrainService.syncTrainDataForDelete-ra: " + (Object)((Object)ra) + ",isSpecial: " + isSpecial));
        }
        boolean result = false;
        String token = this.getToken(ctx, schemeInfo);
        if (StringUtils.isEmpty((String)token)) {
            return result;
        }
        InteSchemeConfigInfo configInfoForDelete = null;
        if (RequestArea.ADMINORG.equals((Object)ra)) {
            configInfoForDelete = this.getInteSchemeConfigInfo(ctx, schemeInfo.getId().toString(), ra, RequestKey.DELETEADMINORG);
        } else if (RequestArea.POSITION.equals((Object)ra)) {
            configInfoForDelete = this.getInteSchemeConfigInfo(ctx, schemeInfo.getId().toString(), ra, RequestKey.DELETEPOSITION);
        } else if (RequestArea.EMPLOYEE.equals((Object)ra)) {
            configInfoForDelete = this.getInteSchemeConfigInfo(ctx, schemeInfo.getId().toString(), ra, RequestKey.DELETEPERSON);
        }
        if (configInfoForDelete != null && configInfoForDelete.isIsStart()) {
            try {
                HashMap<String, String> deleteParam = new HashMap<String, String>();
                deleteParam.put("access_token", token);
                for (String deleteId : resultSet) {
                    String mapId = "";
                    String oqlForMapId = "select mappingId where dataId = '" + deleteId + "' and inteScheme = '" + schemeInfo.getId() + "'";
                    InteTrainModelMappingCollection coll = InteTrainModelMappingFactory.getLocalInstance(ctx).getInteTrainModelMappingCollection(oqlForMapId);
                    if (coll != null && coll.size() > 0) {
                        mapId = coll.get(0).getMappingId();
                    }
                    if (RequestArea.ADMINORG.equals((Object)ra)) {
                        deleteParam.put("id", mapId);
                    } else if (RequestArea.POSITION.equals((Object)ra)) {
                        deleteParam.put("postid", mapId);
                    } else if (RequestArea.EMPLOYEE.equals((Object)ra)) {
                        deleteParam.put("userid", mapId);
                    }
                    String dataStr = "";
                    boolean checkSended = this.checkSendedForDelete(ctx, schemeInfo.getId().toString(), deleteId, ra);
                    boolean isSuccess = false;
                    if (checkSended) {
                        Map<Object, Object> delResult = new HashMap();
                        try {
                            delResult = HttpClientUtils.doGet(configInfoForDelete.getInterfaceUrl(), deleteParam);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (isSpecial) {
                                this.saveInteDefeatData(ctx, null, deleteId, configInfoForDelete.getReqArea(), RequestType.OTHER, schemeInfo);
                            } else {
                                this.saveInteDefeatData(ctx, null, deleteId, configInfoForDelete.getReqArea(), RequestType.DELETE, schemeInfo);
                            }
                            dataStr = "{\"runtime\":0.1,\"status\":\"N\",\"errcode\":-1,\"errmsg\":\"connection timeout\",\"results\":[]}";
                            this.saveInterfaceLog(ctx, schemeInfo, configInfoForDelete, null, deleteId, dataStr, false, null);
                        }
                        dataStr = (String)delResult.get("resultString");
                        if ("401".equals(delResult.get("statusCode"))) {
                            InteShrUtil.deleteTokenFromCache(schemeInfo.getId().toString());
                            this.getToken(ctx, schemeInfo);
                            result = this.syncTrainDataForDelete(ctx, schemeInfo, ra, resultSet, isSpecial);
                            continue;
                        }
                        if ("500".equals(delResult.get("statusCode"))) {
                            if (isSpecial) {
                                this.saveInteDefeatData(ctx, null, deleteId, configInfoForDelete.getReqArea(), RequestType.OTHER, schemeInfo);
                            } else {
                                this.saveInteDefeatData(ctx, null, deleteId, configInfoForDelete.getReqArea(), RequestType.DELETE, schemeInfo);
                            }
                            dataStr = "{\"runtime\":0.1,\"status\":\"N\",\"errcode\":-1,\"errmsg\":\"500 error\",\"results\":[]}";
                            this.saveInterfaceLog(ctx, schemeInfo, configInfoForDelete, null, deleteId, dataStr, false, null);
                            InteShrUtil.deleteTokenFromCache(schemeInfo.getId().toString());
                            throw new InteShrTrainException(InteShrTrainException.SERVER_NOT_AVAILABLE);
                        }
                        if (StringUtils.isEmpty((String)dataStr)) continue;
                        String errCode = JSONHelper.getTargetString(dataStr, "errcode");
                        isSuccess = "0".equals(errCode);
                        this.saveInterfaceLog(ctx, schemeInfo, configInfoForDelete, null, deleteId, dataStr, isSuccess, null);
                        if ("0".equals(errCode)) {
                            result = true;
                            this.saveDeleteMappingLog(ctx, schemeInfo, configInfoForDelete, deleteId, isSuccess, isSpecial);
                        }
                        if (!result) {
                            if (isSpecial) {
                                this.saveInteDefeatData(ctx, null, deleteId, configInfoForDelete.getReqArea(), RequestType.OTHER, schemeInfo);
                                continue;
                            }
                            this.saveInteDefeatData(ctx, null, deleteId, configInfoForDelete.getReqArea(), RequestType.DELETE, schemeInfo);
                            continue;
                        }
                        this.saveInteDefeatToSuccess(ctx, null, deleteId, configInfoForDelete.getReqArea(), RequestType.DELETE, schemeInfo);
                        continue;
                    }
                    this.saveInterfaceLog(ctx, schemeInfo, configInfoForDelete, null, deleteId, dataStr, isSuccess, null);
                    this.saveDeleteMappingLog(ctx, schemeInfo, configInfoForDelete, deleteId, isSuccess, isSpecial);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new BOSException((Throwable)e);
            }
        }
        throw new InteShrTrainException(InteShrTrainException.INTERFACE_NOT_START);
        return result;
    }

    public boolean checkSended(Context ctx, String schemePK, String pk, RequestArea area) throws EASBizException, BOSException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("InteShrTrainService.checkSended-pk: " + pk + ", area: " + (Object)((Object)area)));
        }
        String oql = "where dataid = '" + pk + "' and reqArea = '" + area.getValue() + "' and inteScheme = '" + schemePK + "'";
        boolean resultLocal = InteTrainModelMappingFactory.getLocalInstance(ctx).exists(oql);
        return resultLocal;
    }

    public boolean checkSendedForDelete(Context ctx, String schemePK, String pk, RequestArea ra) throws EASBizException, BOSException {
        InteTrainModelMappingInfo info;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("InteShrTrainService.checkSended-pk: " + pk + ", area: " + (Object)((Object)ra)));
        }
        boolean resultLocal = true;
        String oql = "where dataId = '" + pk + "' and reqArea = '" + ra.getValue() + "' and inteScheme = '" + schemePK + "'";
        InteTrainModelMappingCollection modelMap = InteTrainModelMappingFactory.getLocalInstance(ctx).getInteTrainModelMappingCollection(oql);
        resultLocal = modelMap != null && modelMap.size() > 0 ? !(info = modelMap.get(0)).isIsSealOrDelete() : false;
        return resultLocal;
    }

    public boolean checkSealStateMapping(Context ctx, String schemePK, String pk, RequestArea area) throws BOSException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("InteShrTrainService.checkSealStateMapping-pk: " + pk + ", area: " + (Object)((Object)area) + ", schemePK: " + schemePK));
        }
        boolean result = false;
        String oql = "select isSealOrDelete where dataid = '" + pk + "' and reqArea = '" + area.getValue() + "' and inteScheme = '" + schemePK + "'";
        InteTrainModelMappingCollection mappingColl = InteTrainModelMappingFactory.getLocalInstance(ctx).getInteTrainModelMappingCollection(oql);
        if (mappingColl != null && mappingColl.size() > 0) {
            result = mappingColl.get(0).isIsSealOrDelete();
        }
        return result;
    }

    public InteTrainModelMappingInfo getLastSendedMappingInfo(Context ctx, String schemePK, String pk) throws EASBizException, BOSException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("InteShrTrainService.InteTrainModelMappingInfo-pk: " + pk + ", schemePK: " + schemePK));
        }
        String oql = "where dataid = '" + pk + "' and inteScheme = '" + schemePK + "'";
        InteTrainModelMappingCollection lastSendedInfoCollction = InteTrainModelMappingFactory.getLocalInstance(ctx).getInteTrainModelMappingCollection(oql);
        if (lastSendedInfoCollction != null && lastSendedInfoCollction.size() > 0) {
            return lastSendedInfoCollction.get(0);
        }
        return null;
    }

    public boolean syncModel(Context ctx, InteSchemeInfo schemeInfo, InteSchemeConfigInfo configInfo, IRowSet resultSet, String taskNumber) throws SQLException, BOSException, EASBizException {
        boolean result = false;
        if (configInfo == null) {
            return result;
        }
        String token = this.getToken(ctx, schemeInfo);
        if (StringUtils.isEmpty((String)token)) {
            return result;
        }
        Map<Object, Object> dataStrMap = new HashMap();
        String dataStr = "";
        StringBuilder keyName = new StringBuilder();
        JsonParser jsonParser = new JsonParser();
        JsonElement je = jsonParser.parse(configInfo.getReqSample());
        JsonElement jeResult = JSONHelper.replaceJsonTreeDataByRow(je, keyName, resultSet);
        if (RequestArea.EMPLOYEE.equals((Object)configInfo.getReqArea())) {
            String userIdNew;
            String userIdOld;
            String dataId = resultSet.getString("baseDataId");
            InteTrainModelMappingInfo info = this.getLastSendedMappingInfo(ctx, schemeInfo.getId().toString(), dataId);
            if (info != null && !(userIdOld = info.getDataNumber().toString()).equals(userIdNew = resultSet.getString("number"))) {
                jeResult.getAsJsonObject().addProperty("newUserid", userIdNew);
            }
        }
        String jsonParam = jeResult.toString();
        HashMap<String, String> tokenWay = new HashMap<String, String>();
        tokenWay.put("access_token", token);
        String url = configInfo.getInterfaceUrl();
        try {
            dataStrMap = HttpClientUtils.doPost(url, jsonParam, tokenWay);
        }
        catch (Exception e) {
            e.printStackTrace();
            dataStr = "{\"runtime\":0.1,\"status\":\"N\",\"errcode\":-1,\"errmsg\":\"connection timeout\",\"results\":[]}";
            this.saveInterfaceLog(ctx, schemeInfo, configInfo, resultSet, null, dataStr, false, taskNumber);
            this.saveInteDefeatData(ctx, resultSet, null, configInfo.getReqArea(), RequestType.OTHER, schemeInfo);
        }
        dataStr = (String)dataStrMap.get("resultString");
        if ("401".equals(dataStrMap.get("statusCode"))) {
            InteShrUtil.deleteTokenFromCache(schemeInfo.getId().toString());
            this.getToken(ctx, schemeInfo);
            result = this.syncModel(ctx, schemeInfo, configInfo, resultSet, taskNumber);
        } else {
            if ("500".equals(dataStrMap.get("statusCode"))) {
                dataStr = "{\"runtime\":0.1,\"status\":\"N\",\"errcode\":-1,\"errmsg\":\" 500 error \",\"results\":[]}";
                this.saveInterfaceLog(ctx, schemeInfo, configInfo, resultSet, null, dataStr, false, taskNumber);
                this.saveInteDefeatData(ctx, resultSet, null, configInfo.getReqArea(), RequestType.OTHER, schemeInfo);
                InteShrUtil.deleteTokenFromCache(schemeInfo.getId().toString());
                throw new InteShrTrainException(InteShrTrainException.SERVER_NOT_AVAILABLE);
            }
            if (!StringUtils.isEmpty((String)dataStr)) {
                boolean isSuccess;
                String targetCode = configInfo.getSuccessKey();
                String code = JSONHelper.getTargetString(dataStr, targetCode);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("1.code:-" + code));
                }
                boolean bl = isSuccess = "0".equals(code);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("2.isSuccess:-" + isSuccess));
                }
                if (isSuccess) {
                    this.insertSyncMappingLog(ctx, schemeInfo, configInfo, resultSet, isSuccess);
                    result = true;
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("3.result:-" + result));
                    }
                }
                if (!result) {
                    this.saveInteDefeatData(ctx, resultSet, null, configInfo.getReqArea(), RequestType.OTHER, schemeInfo);
                } else {
                    this.saveInteDefeatToSuccess(ctx, resultSet, null, configInfo.getReqArea(), RequestType.OTHER, schemeInfo);
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("4.result:-" + result + ",isSuccess:-" + isSuccess));
                }
                this.saveInterfaceLog(ctx, schemeInfo, configInfo, resultSet, null, dataStr, isSuccess, taskNumber);
            }
        }
        return result;
    }

    public void saveInteDefeatData(Context ctx, IRowSet resultSet, String deleteId, RequestArea ra, RequestType rt, InteSchemeInfo schemeInfo) throws EASBizException, BOSException, UuidException, SQLException {
        InteTrainWaitModelInfo waitInfo = new InteTrainWaitModelInfo();
        if (resultSet != null) {
            waitInfo.setDataId(BOSUuid.read((String)resultSet.getString("baseDataId")));
            waitInfo.setDataNumber(resultSet.getString("number"));
            waitInfo.setDataName(resultSet.getString("name"));
        }
        if (!StringUtils.isEmpty((String)deleteId)) {
            waitInfo.setDataId(BOSUuid.read((String)deleteId));
        }
        waitInfo.setDataOperate(rt);
        waitInfo.setReqArea(ra);
        waitInfo.setSyncNum(1);
        waitInfo.setScheme(schemeInfo);
        String oql = "where dataId = '" + waitInfo.getDataId() + "' and scheme = '" + schemeInfo.getId() + "'";
        InteTrainWaitModelCollection waitInfoColl = InteTrainWaitModelFactory.getLocalInstance(ctx).getInteTrainWaitModelCollection(oql);
        if (waitInfoColl != null && waitInfoColl.size() > 0) {
            waitInfo.setId(waitInfoColl.get(0).getId());
            waitInfo.setSyncNum(waitInfoColl.get(0).getSyncNum() + 1);
        }
        InteTrainWaitModelFactory.getLocalInstance(ctx).save((CoreBaseInfo)waitInfo);
    }

    public void saveInteDefeatToSuccess(Context ctx, IRowSet resultSet, String deleteId, RequestArea ra, RequestType rt, InteSchemeInfo schemeInfo) throws EASBizException, BOSException, UuidException, SQLException {
        String inteDataId = "";
        if (resultSet != null) {
            inteDataId = resultSet.getString("baseDataId");
        }
        if (!StringUtils.isEmpty((String)deleteId)) {
            inteDataId = deleteId;
        }
        String oql = "where dataId = '" + inteDataId + "' and scheme = '" + schemeInfo.getId() + "'";
        InteTrainWaitModelFactory.getLocalInstance(ctx).delete(oql);
    }

    public void insertSyncMappingLog(Context ctx, InteSchemeInfo schemeInfo, InteSchemeConfigInfo configInfo, IRowSet resultSet, boolean isSuccess) throws BOSException, EASBizException, SQLException {
        String operateKey = configInfo.getReqKey().getValue();
        if ("6".equals(operateKey) || "2".equals(operateKey) || "10".equals(operateKey)) {
            this.saveCreateMappingLog(ctx, schemeInfo, configInfo, resultSet, isSuccess);
        } else if ("8".equals(operateKey) || "4".equals(operateKey) || "12".equals(operateKey)) {
            this.saveUpdateMappingLog(ctx, schemeInfo, configInfo, resultSet, isSuccess);
        } else if ("9".equals(operateKey) || "5".equals(operateKey) || "13".equals(operateKey)) {
            this.saveDeleteMappingLog(ctx, schemeInfo, configInfo, null, isSuccess, false);
        }
    }

    public void saveCreateMappingLog(Context ctx, InteSchemeInfo schemeInfo, InteSchemeConfigInfo configInfo, IRowSet resultSet, boolean isSuccess) throws EASBizException, BOSException, SQLException {
        RequestArea ra = configInfo.getReqArea();
        String oql = "where dataId = '" + resultSet.getString("baseDataId") + "' and inteScheme = '" + schemeInfo.getId() + "'";
        InteTrainModelMappingInfo mappingInfo = new InteTrainModelMappingInfo();
        InteTrainModelMappingCollection mappingColl = InteTrainModelMappingFactory.getLocalInstance(ctx).getInteTrainModelMappingCollection(oql);
        if (mappingColl != null && mappingColl.size() > 0) {
            mappingInfo = mappingColl.get(0);
        }
        mappingInfo.setDataId(BOSUuid.read((String)resultSet.getString("baseDataId")));
        mappingInfo.setDataName(resultSet.getString("name"));
        mappingInfo.setDataNumber(resultSet.getString("number"));
        mappingInfo.setIsSuccess(isSuccess);
        mappingInfo.setInteScheme(schemeInfo);
        if (RequestArea.ADMINORG.equals((Object)ra)) {
            mappingInfo.setMappingId(resultSet.getString("id"));
        } else if (RequestArea.POSITION.equals((Object)ra)) {
            mappingInfo.setMappingId(resultSet.getString("postid"));
        } else if (RequestArea.EMPLOYEE.equals((Object)ra)) {
            String userIdNew;
            String userIdOld;
            mappingInfo.setMappingId(resultSet.getString("userid"));
            String dataId = resultSet.getString("baseDataId");
            InteTrainModelMappingInfo info = this.getLastSendedMappingInfo(ctx, schemeInfo.getId().toString(), dataId);
            if (info != null && !(userIdOld = info.getDataNumber().toString()).equals(userIdNew = resultSet.getString("number"))) {
                if (RequestKey.ADDPERSON.equals((Object)configInfo.getReqKey())) {
                    InteSchemeConfigInfo configInfoForUpdate = InteShrTrainService.getInstance().getInteSchemeConfigInfo(ctx, schemeInfo.getId().toString(), ra, RequestKey.UPDATEPERSON);
                    this.syncModel(ctx, schemeInfo, configInfoForUpdate, resultSet, null);
                }
                mappingInfo.setMappingId(resultSet.getString("number"));
            }
        }
        mappingInfo.setReqArea(configInfo.getReqArea());
        mappingInfo.setReqMethod(configInfo.getReqMethod());
        mappingInfo.setReqType(configInfo.getReqType());
        mappingInfo.setIsSealOrDelete(false);
        InteTrainModelMappingFactory.getLocalInstance(ctx).save((CoreBaseInfo)mappingInfo);
    }

    public void saveUpdateMappingLog(Context ctx, InteSchemeInfo schemeInfo, InteSchemeConfigInfo configInfo, IRowSet resultSet, boolean isSuccess) throws EASBizException, BOSException, SQLException {
        RequestArea ra = configInfo.getReqArea();
        String oql = "where dataId = '" + resultSet.getString("baseDataId") + "' and inteScheme = '" + schemeInfo.getId() + "'";
        InteTrainModelMappingInfo mappingInfo = InteTrainModelMappingFactory.getLocalInstance(ctx).getInteTrainModelMappingInfo(oql);
        mappingInfo.setDataName(resultSet.getString("name"));
        mappingInfo.setDataNumber(resultSet.getString("number"));
        mappingInfo.setIsSuccess(isSuccess);
        mappingInfo.setIsSealOrDelete(false);
        if (RequestArea.ADMINORG.equals((Object)ra)) {
            mappingInfo.setMappingId(resultSet.getString("id"));
        } else if (RequestArea.POSITION.equals((Object)ra)) {
            mappingInfo.setMappingId(resultSet.getString("postid"));
        } else if (RequestArea.EMPLOYEE.equals((Object)ra)) {
            String userIdNew;
            String userIdOld;
            mappingInfo.setMappingId(resultSet.getString("userid"));
            String dataId = resultSet.getString("baseDataId");
            InteTrainModelMappingInfo info = this.getLastSendedMappingInfo(ctx, schemeInfo.getId().toString(), dataId);
            if (info != null && !(userIdOld = info.getDataNumber().toString()).equals(userIdNew = resultSet.getString("number"))) {
                mappingInfo.setMappingId(resultSet.getString("number"));
            }
        }
        SelectorItemCollection sicForPosition = new SelectorItemCollection();
        sicForPosition.add(new SelectorItemInfo("dataName"));
        sicForPosition.add(new SelectorItemInfo("dataNumber"));
        sicForPosition.add(new SelectorItemInfo("isSuccess"));
        sicForPosition.add(new SelectorItemInfo("mappingId"));
        InteTrainModelMappingFactory.getLocalInstance(ctx).updatePartial(mappingInfo, sicForPosition);
    }

    public void saveDeleteMappingLog(Context ctx, InteSchemeInfo schemeInfo, InteSchemeConfigInfo configInfo, String deleteId, boolean isSuccess, boolean isSpecial) throws SQLException, EASBizException, BOSException {
        String oql = "where dataId = '" + deleteId + "' and inteScheme = '" + schemeInfo.getId() + "'";
        if (isSpecial) {
            InteTrainModelMappingInfo model = InteTrainModelMappingFactory.getLocalInstance(ctx).getInteTrainModelMappingInfo(oql);
            model.setIsSealOrDelete(true);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isSealOrDelete"));
            InteTrainModelMappingFactory.getLocalInstance(ctx).updatePartial(model, sic);
        } else {
            InteTrainModelMappingFactory.getLocalInstance(ctx).delete(oql);
        }
    }

    public void saveInterfaceLog(Context ctx, InteSchemeInfo schemeInfo, InteSchemeConfigInfo configInfo, IRowSet resultSet, String deleteId, String dataStr, boolean isSuccess, String taskNumber) throws BOSException, SQLException, EASBizException {
        String targetMsg;
        String msg;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("InteShrTrainService.saveInterfaceLog-dataStr: " + dataStr));
        }
        if (!StringUtils.isEmpty((String)(msg = JSONHelper.getTargetString(dataStr, targetMsg = configInfo.getMsgKey()))) && msg.length() > 500) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("InteShrTrainService.saveInterfaceLog-dataStr: " + msg));
            }
            msg = msg.substring(0, 500);
        }
        InterfaceTrainLogInfo logInfo = new InterfaceTrainLogInfo();
        logInfo.setInterfaceName(configInfo.getReqKey().getAlias());
        if (resultSet != null) {
            logInfo.setDataId(BOSUuid.read((String)resultSet.getString("baseDataId")));
            logInfo.setDataNumber(resultSet.getString("number"));
            logInfo.setDataName(resultSet.getString("name"));
        }
        if (!StringUtils.isEmpty((String)deleteId)) {
            String mapOql = "select dataNumber,dataName where inteScheme = '" + schemeInfo.getId() + "' and dataId = '" + deleteId + "'";
            InteTrainModelMappingCollection mappingCollection = InteTrainModelMappingFactory.getLocalInstance(ctx).getInteTrainModelMappingCollection(mapOql);
            if (mappingCollection != null && mappingCollection.size() > 0) {
                logInfo.setDataNumber(mappingCollection.get(0).getDataNumber());
                logInfo.setDataName(mappingCollection.get(0).getDataName());
            }
            logInfo.setDataId(BOSUuid.read((String)deleteId));
        }
        if (!StringUtils.isEmpty((String)taskNumber)) {
            logInfo.setInitSyncNumber(taskNumber);
            logInfo.setIsFromInit(true);
        } else {
            logInfo.setIsFromInit(false);
        }
        logInfo.setIsSuccess(isSuccess);
        logInfo.setReqArea(configInfo.getReqArea());
        logInfo.setReqMethod(configInfo.getReqMethod());
        logInfo.setReqType(configInfo.getReqType());
        logInfo.setResMsg(msg);
        logInfo.setScheme(schemeInfo);
        InterfaceTrainLogFactory.getLocalInstance(ctx).addnew(logInfo);
    }

    public InteSchemeConfigInfo getInteSchemeConfigInfo(Context ctx, String schemeId, RequestArea ra, RequestKey rk) throws EASBizException, BOSException {
        if (logger.isInfoEnabled()) {
            logger.info((Object)("InteShrTrainService.getInteSchemeConfigInfo-schemeId: " + schemeId + ", ra: " + (Object)((Object)ra) + ", rk: " + (Object)((Object)rk)));
        }
        String oql = "where reqArea = " + ra.getValue() + " and scheme = '" + schemeId + "' and reqKey = '" + rk.getValue() + "'";
        InteSchemeConfigCollection shcemeConfigColl = InteSchemeConfigFactory.getLocalInstance(ctx).getInteSchemeConfigCollection(oql);
        if (shcemeConfigColl != null && shcemeConfigColl.size() > 0) {
            return shcemeConfigColl.get(0);
        }
        return null;
    }

    private static class InteShrTrainServiceHolder {
        private static final InteShrTrainService INSTANCE = new InteShrTrainService();

        private InteShrTrainServiceHolder() {
        }
    }
}

