/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inteshrtrain.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class JSONHelper {
    public static String getTargetString(String jsonStr, String targetKey) {
        if (StringUtils.isEmpty((CharSequence)jsonStr)) {
            return "";
        }
        JsonParser jsonParser = new JsonParser();
        JsonElement obj = jsonParser.parse(jsonStr);
        StringBuilder sb = new StringBuilder();
        String result = "";
        return JSONHelper.getTargetString(obj, sb, targetKey, result);
    }

    public static boolean containColumn(IRowSet rs, String columnName) throws SQLException {
        boolean result = false;
        if (rs != null) {
            ResultSetMetaData meta = rs.getMetaData();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                String colName = meta.getColumnName(i);
                if (!colName.equals(columnName)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static String getStringValueFromRow(IRowSet rs, String columnName) throws SQLException {
        String value = "";
        boolean checkContain = JSONHelper.containColumn(rs, columnName);
        if (checkContain) {
            value = rs.getString(columnName);
        } else {
            columnName = "@" + columnName;
            checkContain = JSONHelper.containColumn(rs, columnName);
            if (checkContain) {
                value = rs.getString(columnName);
            }
        }
        if (value == null) {
            value = "";
        } else if ("true".equals(value)) {
            value = "1";
        } else if ("false".equals(value)) {
            value = "0";
        }
        return value;
    }

    public static JsonElement replaceJsonTreeDataByRow(JsonElement e, StringBuilder keyName, IRowSet rs) throws SQLException {
        if (e.isJsonNull()) {
            keyName.delete(keyName.lastIndexOf("."), keyName.length());
            return JsonNull.INSTANCE;
        }
        if (e.isJsonPrimitive()) {
            String columnName = keyName.toString().substring(1, keyName.toString().length());
            String value = JSONHelper.getStringValueFromRow(rs, columnName);
            if ("".equals(value)) {
                value = e.getAsString();
            }
            JsonPrimitive je = new JsonPrimitive(value);
            keyName.delete(keyName.lastIndexOf("."), keyName.length());
            return je;
        }
        if (e.isJsonArray()) {
            JsonArray ja = e.getAsJsonArray();
            JsonArray newJsonArray = new JsonArray();
            if (null != ja) {
                if (ja.size() > 0) {
                    for (JsonElement ae : ja) {
                        newJsonArray.add(JSONHelper.replaceJsonTreeDataByRow(ae, keyName, rs));
                    }
                } else {
                    String columnName = keyName.toString().substring(1, keyName.toString().length());
                    String value = JSONHelper.getStringValueFromRow(rs, columnName);
                    if (!StringUtils.isEmpty((CharSequence)value)) {
                        newJsonArray.add((JsonElement)new JsonPrimitive(value));
                    }
                }
            }
            return newJsonArray;
        }
        if (e.isJsonObject()) {
            JsonObject newJsonObj = new JsonObject();
            Set es = e.getAsJsonObject().entrySet();
            for (Map.Entry en : es) {
                keyName.append(".");
                keyName.append((String)en.getKey());
                newJsonObj.add((String)en.getKey(), JSONHelper.replaceJsonTreeDataByRow((JsonElement)en.getValue(), keyName, rs));
                if (keyName.indexOf(".") == -1) continue;
                keyName.delete(keyName.lastIndexOf("."), keyName.length());
            }
            return newJsonObj;
        }
        return JsonNull.INSTANCE;
    }

    public static JsonElement replaceJsonTreeDataByMap(JsonElement e, StringBuilder keyName, Map<String, String> rs) {
        if (e.isJsonNull()) {
            keyName.delete(keyName.lastIndexOf("."), keyName.length());
            return JsonNull.INSTANCE;
        }
        if (e.isJsonPrimitive()) {
            String columnName = keyName.toString().substring(1, keyName.toString().length());
            String value = "";
            if (rs.containsKey(columnName)) {
                value = rs.get(columnName);
            }
            JsonPrimitive je = new JsonPrimitive(value);
            keyName.delete(keyName.lastIndexOf("."), keyName.length());
            return je;
        }
        if (e.isJsonArray()) {
            JsonArray ja = e.getAsJsonArray();
            JsonArray newJsonArray = new JsonArray();
            if (null != ja) {
                for (JsonElement ae : ja) {
                    newJsonArray.add(JSONHelper.replaceJsonTreeDataByMap(ae, keyName, rs));
                }
            }
            return newJsonArray;
        }
        if (e.isJsonObject()) {
            JsonObject newJsonObj = new JsonObject();
            Set es = e.getAsJsonObject().entrySet();
            for (Map.Entry en : es) {
                keyName.append(".");
                keyName.append((String)en.getKey());
                newJsonObj.add((String)en.getKey(), JSONHelper.replaceJsonTreeDataByMap((JsonElement)en.getValue(), keyName, rs));
                if (keyName.indexOf(".") == -1) continue;
                keyName.delete(keyName.lastIndexOf("."), keyName.length());
            }
            return newJsonObj;
        }
        return JsonNull.INSTANCE;
    }

    public static String getTargetString(JsonElement e, StringBuilder keyName, String targetKey, String result) {
        String temp = "";
        if (e.isJsonNull()) {
            String columnName;
            String string = columnName = keyName.toString().length() > 1 ? keyName.toString().substring(1, keyName.toString().length()) : "";
            if (columnName.equals(targetKey)) {
                result = temp = e.getAsString();
            }
            keyName.delete(keyName.lastIndexOf("."), keyName.length());
            return result;
        }
        if (e.isJsonPrimitive()) {
            String columnName;
            String string = columnName = keyName.toString().length() > 1 ? keyName.toString().substring(1, keyName.toString().length()) : "";
            if (columnName.equals(targetKey)) {
                result = temp = e.getAsString();
            }
            keyName.delete(keyName.lastIndexOf("."), keyName.length());
            return result;
        }
        if (e.isJsonArray()) {
            JsonArray ja = e.getAsJsonArray();
            if (null != ja) {
                for (JsonElement ae : ja) {
                    result = JSONHelper.getTargetString(ae, keyName, targetKey, result);
                }
            }
            return result;
        }
        if (e.isJsonObject()) {
            Set es = e.getAsJsonObject().entrySet();
            for (Map.Entry en : es) {
                keyName.append(".");
                keyName.append((String)en.getKey());
                result = JSONHelper.getTargetString((JsonElement)en.getValue(), keyName, targetKey, result);
                if (keyName.indexOf(".") == -1) continue;
                keyName.delete(keyName.lastIndexOf("."), keyName.length());
            }
        }
        return result;
    }
}

