/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.log.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.mobile.util.StringUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.log.ILogConfig;
import com.kingdee.shr.log.ILogConfigEntry;
import com.kingdee.shr.log.ILogConfigExt;
import com.kingdee.shr.log.LogConfigCollection;
import com.kingdee.shr.log.LogConfigEntryCollection;
import com.kingdee.shr.log.LogConfigEntryFactory;
import com.kingdee.shr.log.LogConfigEntryInfo;
import com.kingdee.shr.log.LogConfigExtCollection;
import com.kingdee.shr.log.LogConfigExtFactory;
import com.kingdee.shr.log.LogConfigExtInfo;
import com.kingdee.shr.log.LogConfigFactory;
import com.kingdee.shr.log.LogConfigInfo;
import com.kingdee.shr.log.LogLevel;
import com.kingdee.shr.log.LogType;
import com.kingdee.shr.log.ShrLogBizException;
import com.kingdee.shr.log.app.AbstractLogConfigControllerBean;
import com.kingdee.shr.log.cache.LogConfigCacheHelper;
import com.kingdee.shr.osf.log.IOsfLogService;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class LogConfigControllerBean
extends AbstractLogConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.log.app.LogConfigControllerBean");

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        this.doState(ctx, id, BaseItemStateEnum.ENABLE);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        this.doState(ctx, id, BaseItemStateEnum.DISABLE);
    }

    private void doState(Context ctx, String id, BaseItemStateEnum state) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id)) {
            throw new ShrLogBizException(ShrLogBizException.INPUT_PARAM_NOT_NULL, new Object[]{"id"});
        }
        LogConfigInfo model = this.getLogConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        if (BaseItemStateEnum.ENABLE.equals((Object)state) && BaseItemStateEnum.ENABLE.equals((Object)model.getState())) {
            throw new ShrLogBizException(ShrLogBizException.ENABLE_LOG_NOT_ENABLE);
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)state) && !BaseItemStateEnum.ENABLE.equals((Object)model.getState())) {
            throw new ShrLogBizException(ShrLogBizException.NOT_ENABLE_LOG_NOT_DISABLE);
        }
        if (BaseItemStateEnum.DISABLE.equals((Object)state) && LogType.Common_Log.equals((Object)model.getLogType())) {
            throw new ShrLogBizException(ShrLogBizException.COMMON_LOG_NOT_DISABLED);
        }
        LogConfigInfo updateModel = new LogConfigInfo();
        updateModel.setId(model.getId());
        updateModel.setState(state);
        updateModel.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        updateModel.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        selector.add("lastUpdateUser");
        selector.add("lastUpdateTime");
        this.updatePartial(ctx, (CoreBaseInfo)updateModel, selector);
        this.cleanCache(model);
    }

    @Override
    protected void _logLevelChange(Context ctx, List ids, LogLevel level) throws BOSException, EASBizException {
        if (null == ids || ids.isEmpty()) {
            throw new ShrLogBizException(ShrLogBizException.INPUT_PARAM_NOT_NULL, new Object[]{"ids"});
        }
        ILogConfigExt iLogConfigExt = LogConfigExtFactory.getLocalInstance(ctx);
        ILogConfig iLogConfig = LogConfigFactory.getLocalInstance(ctx);
        FilterInfo f = null;
        LogConfigInfo info = null;
        LogConfigExtInfo infoExt = null;
        SelectorItemCollection selector = null;
        int total = ids.size();
        for (int i = 0; i < total; ++i) {
            f = new FilterInfo();
            f.getFilterItems().add(new FilterItemInfo("parent.id", (Object)((String)ids.get(i))));
            info = iLogConfig.getLogConfigInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)((String)ids.get(i)))));
            if (iLogConfigExt.exists(f)) {
                infoExt = iLogConfigExt.getLogConfigExtInfo("where parent.id ='" + (String)ids.get(i) + "'");
                infoExt.setLevel(level);
                infoExt.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
                infoExt.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("level"));
                iLogConfigExt.updatePartial((CoreBaseInfo)infoExt, selector);
                continue;
            }
            infoExt = new LogConfigExtInfo();
            infoExt.setParent(info);
            infoExt.setLevel(level);
            infoExt.setImplClass(info.getImplClass());
            iLogConfigExt.addnew((CoreBaseInfo)infoExt);
        }
        LogConfigCacheHelper.removeAll();
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        LogConfigEntryCollection coll;
        LogConfigInfo info = (LogConfigInfo)model;
        this.checkNameBlank(ctx, info);
        this.checkNumberBlank(ctx, info);
        this.checkNumberDup(ctx, info);
        if (null == info.getLogType()) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this._getPropertyAlias(ctx, info, "logType")});
        }
        if (null == info.getState()) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this._getPropertyAlias(ctx, info, "state")});
        }
        if (null == info.getDomain()) {
            throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this._getPropertyAlias(ctx, info, "domain")});
        }
        boolean isExt = false;
        String implClass = null;
        LogLevel level = null;
        if (info.isIsPreset()) {
            if (null == info.getLevel()) {
                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this._getPropertyAlias(ctx, info, "level")});
            }
            if (StringUtils.isEmpty((String)info.getImplClass())) {
                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this._getPropertyAlias(ctx, info, "implClass")});
            }
        } else {
            if (null == info.getLevelExt()) {
                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this._getPropertyAlias(ctx, info, "levelExt")});
            }
            if (StringUtils.isEmpty((String)info.getImplClassExt())) {
                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this._getPropertyAlias(ctx, info, "implClassExt")});
            }
        }
        if (!StringUtils.isEmpty((String)info.getImplClassExt())) {
            isExt = true;
            implClass = info.getImplClassExt();
            level = info.getLevelExt();
            if (null == level) {
                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{this._getPropertyAlias(ctx, info, "levelExt")});
            }
            info.setImplClassExt(null);
            info.setLevelExt(null);
        } else {
            implClass = info.getImplClass();
            level = info.getLevel();
        }
        if (LogType.Common_Log.equals((Object)info.getLogType())) {
            if (null == info.getId()) {
                throw new ShrLogBizException(ShrLogBizException.COMMON_LOG_ONLYONE);
            }
            if (!"4i4AAAA8bMBSjrJs".equals(info.getId().toString())) {
                throw new ShrLogBizException(ShrLogBizException.COMMON_LOG_ONLYONE);
            }
        }
        Object obj = this.getClassNewinstance(implClass);
        if (LogType.Osf_Log.equals((Object)info.getLogType())) {
            if (null == obj || !(obj instanceof IOsfLogService)) {
                throw new ShrLogBizException(ShrLogBizException.LOG_OSF_IMPL_ERROR01);
            }
        } else if (null == obj || obj instanceof IOsfLogService) {
            throw new ShrLogBizException(ShrLogBizException.LOG_OSF_IMPL_ERROR02);
        }
        if (null != (coll = info.getEntrys()) && !coll.isEmpty()) {
            FilterInfo filter = null;
            ILogConfigEntry iLogConfigEntry = LogConfigEntryFactory.getLocalInstance(ctx);
            HashSet<String> urlDump = new HashSet<String>();
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                LogConfigEntryInfo eInfo = coll.get(i);
                if (StringUtil.isEmpty((Object)eInfo.getUrl())) {
                    throw new ShrLogBizException(ShrLogBizException.LOGCONFIGENTRY_URL_NOT_NULL, new Object[]{i + 1});
                }
                if (urlDump.contains(eInfo.getUrl())) {
                    throw new ShrLogBizException(ShrLogBizException.LOG_CONFIGENTRY_URL_DUMPINENTRY, new Object[]{i + 1});
                }
                urlDump.add(eInfo.getUrl());
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("url", (Object)eInfo.getUrl()));
                if (null != eInfo.getId()) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)eInfo.getId().toString(), CompareType.NOTEQUALS));
                }
                if (iLogConfigEntry.exists(filter)) {
                    EntityViewInfo view = new EntityViewInfo();
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add(new SelectorItemInfo("parent.*"));
                    view.setFilter(filter);
                    view.setSelector(selector);
                    LogConfigEntryCollection lcc = iLogConfigEntry.getLogConfigEntryCollection(view);
                    LogConfigEntryInfo eDbInfol = lcc.get(0);
                    throw new ShrLogBizException(ShrLogBizException.LOG_CONFIGENTRY_URL_DUMPINDB, new Object[]{i + 1, eDbInfol.getParent().getNumber(), eDbInfol.getParent().getName()});
                }
                if (!StringUtils.isEmpty((String)eInfo.getParams()) && eInfo.getParams().length() > 2) {
                    String params = eInfo.getParams().trim();
                    eInfo.setParams(params);
                    if (params.startsWith("{") && params.endsWith("}")) {
                        try {
                            JSONUtils.convertJsonToObject((Context)ctx, (String)params);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            throw new ShrLogBizException(ShrLogBizException.LOG_CONFIGENTRY_PARAMS_IS_JSON, new Object[]{i + 1});
                        }
                    }
                    if (params.startsWith("[") && params.endsWith("]")) {
                        try {
                            JSONUtils.convertJsonToObject((Context)ctx, (String)params, List.class);
                            continue;
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage(), (Throwable)e);
                            throw new ShrLogBizException(ShrLogBizException.LOG_CONFIGENTRY_PARAMS_IS_JSON, new Object[]{i + 1});
                        }
                    }
                    throw new ShrLogBizException(ShrLogBizException.LOG_CONFIGENTRY_PARAMS_IS_JSON, new Object[]{i + 1});
                }
                eInfo.setParams(null);
            }
        }
        IObjectPK pk = super._save(ctx, model);
        if (null == info.getId()) {
            info.setId(BOSUuid.read((String)pk.toString()));
        }
        this.extendSave(ctx, info, isExt, implClass, level);
        this.cleanCache(info);
        return pk;
    }

    private void cleanCache(LogConfigInfo info) {
        LogConfigEntryCollection coll = info.getEntrys();
        if (null != coll && !coll.isEmpty()) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                LogConfigEntryInfo eInfo = coll.get(i);
                LogConfigCacheHelper.remove(info.getLogType().getValue(), eInfo.getUrl());
            }
        }
    }

    private void extendSave(Context ctx, LogConfigInfo info, boolean isExt, String implClass, LogLevel level) throws BOSException, EASBizException {
        ILogConfigExt iLogConfigExt = LogConfigExtFactory.getLocalInstance(ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)info.getId().toString()));
        LogConfigExtInfo eInfo = null;
        if (isExt) {
            if (iLogConfigExt.exists(filter)) {
                eInfo = iLogConfigExt.getLogConfigExtInfo("where parent.id ='" + info.getId().toString() + "'");
            } else {
                eInfo = new LogConfigExtInfo();
                eInfo.setParent(info);
            }
            eInfo.setImplClass(implClass);
            eInfo.setLevel(level);
            iLogConfigExt.save((CoreBaseInfo)eInfo);
        } else if (iLogConfigExt.exists(filter)) {
            iLogConfigExt.delete(filter);
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogConfigInfo model = (LogConfigInfo)super._getValue(ctx, pk);
        ILogConfigExt iLogConfigExt = LogConfigExtFactory.getLocalInstance(ctx);
        this.megerExtend(ctx, model, iLogConfigExt);
        return model;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        LogConfigInfo model = (LogConfigInfo)super._getValue(ctx, pk, selector);
        ILogConfigExt iLogConfigExt = LogConfigExtFactory.getLocalInstance(ctx);
        this.megerExtend(ctx, model, iLogConfigExt);
        return model;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector, SorterItemCollection sorter) throws BOSException, EASBizException {
        LogConfigInfo model = (LogConfigInfo)super._getValue(ctx, pk, selector, sorter);
        ILogConfigExt iLogConfigExt = LogConfigExtFactory.getLocalInstance(ctx);
        this.megerExtend(ctx, model, iLogConfigExt);
        return model;
    }

    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SorterItemCollection sorter) throws BOSException, EASBizException {
        LogConfigInfo model = (LogConfigInfo)super._getValue(ctx, pk, sorter);
        ILogConfigExt iLogConfigExt = LogConfigExtFactory.getLocalInstance(ctx);
        this.megerExtend(ctx, model, iLogConfigExt);
        return model;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        LogConfigInfo model = (LogConfigInfo)super._getValue(ctx, oql);
        ILogConfigExt iLogConfigExt = LogConfigExtFactory.getLocalInstance(ctx);
        this.megerExtend(ctx, model, iLogConfigExt);
        return model;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx) throws BOSException {
        LogConfigCollection coll = (LogConfigCollection)super._getCollection(ctx, svcCtx);
        this.megerCollectionExtend(ctx, coll);
        return coll;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        LogConfigCollection coll = (LogConfigCollection)super._getCollection(ctx, svcCtx, view);
        this.megerCollectionExtend(ctx, coll);
        return coll;
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, String oql) throws BOSException {
        LogConfigCollection coll = (LogConfigCollection)super._getCollection(ctx, svcCtx, oql);
        this.megerCollectionExtend(ctx, coll);
        return coll;
    }

    private void megerCollectionExtend(Context ctx, LogConfigCollection coll) throws BOSException {
        if (null == coll || coll.isEmpty()) {
            return;
        }
        ILogConfigExt iLogConfigExt = LogConfigExtFactory.getLocalInstance(ctx);
        int total = coll.size();
        for (int i = 0; i < total; ++i) {
            LogConfigInfo model = coll.get(i);
            this.megerExtend(ctx, model, iLogConfigExt);
        }
    }

    private Object getClassNewinstance(String className) {
        Class<?> clazz;
        Object obj = null;
        try {
            clazz = MsfClassLoaderFactory.forName((String)className);
            if (null != clazz) {
                obj = clazz.newInstance();
            }
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (null == obj) {
            try {
                clazz = Class.forName(className);
                if (null != clazz) {
                    obj = clazz.newInstance();
                }
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return obj;
    }

    private void megerExtend(Context ctx, LogConfigInfo model, ILogConfigExt iLogConfigExt) throws BOSException {
        if (null == model) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)model.getId().toString()));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        LogConfigExtCollection coll = iLogConfigExt.getLogConfigExtCollection(view);
        if (null != coll && !coll.isEmpty()) {
            LogConfigExtInfo eInfo = coll.get(0);
            model.setImplClassExt(eInfo.getImplClass());
            model.setLevelExt(eInfo.getLevel());
        }
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        IObjectPK[] pks = super._delete(ctx, filter);
        LogConfigCacheHelper.removeAll();
        return pks;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        LogConfigInfo info = this.getLogConfigInfo(ctx, pk);
        if (!BaseItemStateEnum.NEW.equals((Object)info.getState())) {
            throw new ShrLogBizException(ShrLogBizException.DELETE_ERROR);
        }
        super._delete(ctx, pk);
        LogConfigCacheHelper.removeAll();
    }

    protected void _delete(Context ctx, IObjectPK[] arrayPK) throws BOSException, EASBizException {
        super._delete(ctx, arrayPK);
        LogConfigCacheHelper.removeAll();
    }

    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        IObjectPK[] pks = super._delete(ctx, oql);
        LogConfigCacheHelper.removeAll();
        return pks;
    }
}

