/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.orgchart.util;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.DCManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRParamUtil;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.emp.app.util.SHREmpOptPersonPositionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.orgchart.FieldTypeEnum;
import com.kingdee.shr.orgchart.ModelCategoryEnum;
import com.kingdee.shr.orgchart.OrgChartSettingFactory;
import com.kingdee.shr.orgchart.OrgChartSettingInfo;
import com.kingdee.shr.orgchart.SelectedFieldCollection;
import com.kingdee.shr.orgchart.ShowFormatCollection;
import com.kingdee.shr.orgchart.ShowFormatInfo;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.springframework.util.ReflectionUtils;

public class HROrgChartUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.manager.util.HRManagerConfigUtil");
    public static String[] IllegalKeyWord = new String[]{"delete ", "drop "};
    public static String MOVE_PIC = "/shr/addon/orgchart/web/webviews/biz/orgChartSetting/resource/headcount.png";
    public static String DEFAULT_SHOW_PIC = "/shr/addon/manager/web/webviews/framework/resource/neutral.png";
    public static String PART_TIME = "\uff08\u517c\uff09";
    public static String Admin_ID = "ctiKqt/vdEmIHEFYmabFbOXCsdk=";
    public static String Position_ID = "GbPmi5e1R0qHAacE6Vk//OXCsdk=";
    public static String All_ID = "dS1d6hR1rku129L7l2d+g+XCsdk=";
    public static String PIC_Admin_Tips = "/shr/addon/orgchart/web/webviews/biz/orgChartSetting/resource/admin-tips.png";
    public static String PIC_Position_Tips = "/shr/addon/orgchart/web/webviews/biz/orgChartSetting/resource/position-tips.png";
    public static String PIC_EXPENDDOWN = "";
    public static String PIC_ADDADMIN = "";
    public static String PIC_ADDPOSI = "";
    public static String PIC_DELETE = "";
    public static final String EAS_HOME = System.getProperty("EAS_HOME");
    public static final String SHR_WEB_WAR_NAME = "shr_web.war";
    public static final String EAS_EAR_ROOT = EAS_HOME + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear";
    public static final String photoPath = EAS_EAR_ROOT + File.separator + "shr_web.war" + File.separator + "orgchartTMP";

    public static String getUserId(Context ctx) {
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        String userId = userInfo != null ? userInfo.getId().toString() : null;
        return userId;
    }

    public static String getDefaultSetting(Context ctx) throws BOSException {
        String result = null;
        String sql = "select fid from T_HR_OrgChartSetting where FIsDefault=1";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() == 0) {
                logger.error((Object)"No default scheme");
                throw new BOSException();
            }
            if (rowSet.size() > 1) {
                logger.error((Object)"The default scheme is greater than 1");
                throw new BOSException();
            }
            while (rowSet.next()) {
                result = rowSet.getString("fid");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static List<Map<String, Object>> getAllSetting(Context ctx) throws BOSException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select fid orgChartSettingId , fname_" + l + " orgChartSettingName ,FIsDefault isDefault from T_HR_OrgChartSetting";
        try {
            int defaultSettingNum = 0;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() == 0) {
                logger.error((Object)"No plan");
                throw new BOSException();
            }
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgChartSettingId", rowSet.getString("orgChartSettingId") == null ? "" : rowSet.getString("orgChartSettingId"));
                map.put("orgChartSettingName", rowSet.getString("orgChartSettingName") == null ? "" : rowSet.getString("orgChartSettingName"));
                map.put("isDefault", rowSet.getBoolean("isDefault"));
                if (rowSet.getBoolean("isDefault")) {
                    ++defaultSettingNum;
                    resultList.add(0, map);
                    continue;
                }
                resultList.add(map);
            }
            if (defaultSettingNum == 0) {
                logger.error((Object)"No default scheme");
                throw new BOSException();
            }
            if (defaultSettingNum > 1) {
                logger.error((Object)"The default scheme is greater than 1");
                throw new BOSException();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return resultList;
    }

    public static List<Map<String, Object>> getAllUserSetting(Context ctx, String userId, String permItemId) throws BOSException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select fid orgChartSettingId , fname_" + l + " orgChartSettingName ,FIsDefault isDefault, FShowTypeID showType, FHierarcyType hierarcyType from T_HR_OrgChartSetting where fstate=1 and ( FAdminOrgUnitID in (" + HROrgChartUtil.getAdminOrgRangeIdByUserIdSql(ctx, userId, permItemId) + ") or FIsDefault=1)";
        try {
            int defaultSettingNum = 0;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rowSet.size() == 0) {
                logger.error((Object)"No plan");
                throw new BOSException();
            }
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("orgChartSettingId", rowSet.getString("orgChartSettingId") == null ? "" : rowSet.getString("orgChartSettingId"));
                map.put("orgChartSettingName", rowSet.getString("orgChartSettingName") == null ? "" : rowSet.getString("orgChartSettingName"));
                map.put("isDefault", rowSet.getBoolean("isDefault"));
                map.put("showType", HROrgChartUtil.assembleShowType(rowSet.getString("showType")));
                map.put("hierarcyType", rowSet.getString("hierarcyType") == null ? 0 : rowSet.getInt("hierarcyType"));
                if (rowSet.getBoolean("isDefault")) {
                    ++defaultSettingNum;
                    resultList.add(0, map);
                    continue;
                }
                resultList.add(map);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return resultList;
    }

    public static ArrayList getDCList() {
        ArrayList newList = new ArrayList();
        try {
            newList = DCManager.getInstance().getDCList();
        }
        catch (Exception e1) {
            logger.error((Object)("FaRebuildViewService.newList = " + e1.getMessage()));
        }
        return newList;
    }

    public static String getDBType(int dbType) {
        switch (dbType) {
            case 0: {
                return "MS SQL Server";
            }
            case 1: {
                return "DB2";
            }
        }
        return "Oracle";
    }

    public static List getModelListByClassName(String implClass, String methodName, Map paras) throws BOSException {
        try {
            Class clazz = MsfClassLoaderFactory.forName((String)implClass);
            Method method = ReflectionUtils.findMethod((Class)clazz, (String)methodName, (Class[])new Class[]{Map.class});
            if (method == null) {
                throw new BOSException();
            }
            long start = 0L;
            long end = 0L;
            if (logger.isDebugEnabled()) {
                start = new java.util.Date().getTime();
            }
            List resultList = (List)ReflectionUtils.invokeMethod((Method)method, clazz.newInstance(), (Object[])new Object[]{paras});
            if (logger.isDebugEnabled()) {
                end = new java.util.Date().getTime();
                logger.debug((Object)MessageFormat.format("handler: {0}, method: {1}, cost: {2}", implClass, methodName, end - start));
            }
            return resultList != null ? resultList : null;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw new BOSException();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new BOSException();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            throw new BOSException();
        }
    }

    public static void assembleField(OrgChartSettingInfo orgChartSettingInfo, List resultList) {
        SelectedFieldCollection selectedFieldCollection = orgChartSettingInfo.getSelectedField();
        HashMap<String, Integer> maxCountMap = new HashMap<String, Integer>();
        for (int i = 0; i < selectedFieldCollection.size(); ++i) {
            maxCountMap.put(selectedFieldCollection.get(i).getNumber(), selectedFieldCollection.get(i).getMaxCount());
        }
        ShowFormatCollection showFormatCollection = orgChartSettingInfo.getShowFormat();
        showFormatCollection.sort("number");
        for (int j = 0; j < resultList.size(); ++j) {
            Map map = (Map)resultList.get(j);
            for (int i = 0; i < showFormatCollection.size(); ++i) {
                ShowFormatInfo showFormatInfo = showFormatCollection.get(i);
                if (showFormatInfo.getType().equals((Object)FieldTypeEnum.text)) {
                    String number = showFormatInfo.getNumber();
                    ModelCategoryEnum modelCategory = showFormatInfo.getModelCategory();
                    String beforeFormat = showFormatInfo.getFormat();
                    String realNumber = null;
                    int numberLineWidth = showFormatInfo.getFieldW();
                    String afterFormat = beforeFormat;
                    realNumber = beforeFormat.substring(beforeFormat.indexOf("{") + 1, beforeFormat.indexOf("}"));
                    for (String key : map.keySet()) {
                        if (key.equals("key") || key.equals("parent") || key.equals("category") || !afterFormat.contains("{" + key + "}")) continue;
                        afterFormat = afterFormat.replace("{" + key + "}", map.get(key) == null ? "" : map.get(key).toString());
                        break;
                    }
                    if ("vertical".equals((String)map.get("category")) || map.get(realNumber + "isWholeLine") == null || map.get(realNumber + "isAllowWrap") == null) continue;
                    HROrgChartUtil.assembleLineWidth(numberLineWidth, map, number, afterFormat, (Boolean)map.get(realNumber + "isWholeLine"), (Boolean)map.get(realNumber + "isAllowWrap"), (Integer)maxCountMap.get(realNumber));
                    continue;
                }
                if (!showFormatInfo.getType().equals((Object)FieldTypeEnum.picture)) continue;
            }
            if (StringUtils.isEmpty((String)((String)map.get("showTips")))) {
                map.put("showTips", null);
                continue;
            }
            if (((String)map.get("showTips")).startsWith("\n")) {
                String newTips = ((String)map.get("showTips")).substring(1);
                map.put("showTips", newTips);
            }
            if (!((String)map.get("showTips")).endsWith("\n")) continue;
            String tips = (String)map.get("showTips");
            String newTips = tips.substring(0, tips.length() - 1);
            map.put("showTips", newTips);
        }
    }

    public static String getAdminOrgRangeIdByUserIdSql(Context ctx, String userId, String permItemId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select adminOrg.fid as forgId");
        sql.append(" from t_org_admin adminOrg");
        sql.append(" where fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId) + ")");
        return sql.toString();
    }

    public static String getAdminOrgRangeIdByUserIdSql(Context ctx, String userId, String orgUnitLayerTypeIds, String permItemId) throws BOSException {
        String orgUnitTypeSql = "";
        if ("('')".equals(orgUnitLayerTypeIds)) {
            orgUnitTypeSql = "";
        } else {
            String idString = orgUnitLayerTypeIds.replaceAll(" ", "").replaceAll("'", "").replaceAll("\\(", "").replaceAll("\\)", "");
            String[] ids = idString.split(",");
            for (int i = 0; i < ids.length; ++i) {
                HROrgChartUtil.isBOSUuid(ids[i]);
            }
            orgUnitTypeSql = " and adminOrg.FLayerTypeID in " + orgUnitLayerTypeIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select adminOrg.fid as forgId");
        sql.append(" from T_ORG_Admin adminOrg");
        sql.append(" inner join (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId));
        sql.append(" ) range on range.FAdminOrgID = adminOrg.fid");
        sql.append(" where adminOrg.fissealup = 0");
        sql.append(orgUnitTypeSql);
        return sql.toString();
    }

    public static String getAdminOrgRangeLongnumberByUserIdSql(Context ctx, String userId, String permItemId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select adminOrg.flongnumber");
        sql.append(" from T_ORG_Admin adminOrg");
        sql.append(" inner join (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId));
        sql.append(" ) range on (range.FAdminOrgID = adminOrg.fid");
        sql.append(" and adminOrg.fisstartshr = 1");
        sql.append(" and adminOrg.fissealup = 0) ");
        sql.append(" left join T_HR_SHRAdminOrgUnitExtend extend on extend.FAdminOrgUnitID = adminOrg.fid where extend.FIsShowInOrgChart = 1");
        sql.append(" order by adminOrg.flongnumber");
        return sql.toString();
    }

    public static String getAdminOrgRangeLongnumberByUserIdSql(Context ctx, String userId, String rootLongnumber, String orgUnitLayerTypeIds, String permItemId) {
        String orgUnitTypeSql = "";
        orgUnitTypeSql = "('')".equals(orgUnitLayerTypeIds) ? "" : " and ( adminOrg.FLayerTypeID in " + orgUnitLayerTypeIds + " or adminOrg.FLongNumber = '" + rootLongnumber + "')";
        StringBuffer sql = new StringBuffer();
        sql.append("select adminOrg.flongnumber");
        sql.append(" from T_ORG_Admin adminOrg");
        sql.append(" inner join (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId));
        sql.append(" ) range on range.FAdminOrgID = adminOrg.fid");
        sql.append(" left join T_HR_SHRAdminOrgUnitExtend extend on extend.FAdminOrgUnitID = adminOrg.fid ");
        sql.append(" where adminOrg.fisstartshr = 1");
        sql.append(" and extend.FIsShowInOrgChart = 1");
        sql.append(" and adminOrg.fissealup = 0");
        sql.append(orgUnitTypeSql);
        sql.append(" order by adminOrg.flongnumber");
        return sql.toString();
    }

    public static String getAdminOrgRangeByUserIdStr(Context ctx, String userId, String permItemId) throws Exception {
        String adminOrgRangeSql = HROrgChartUtil.getAdminOrgRangeIdByUserIdSql(ctx, userId, permItemId);
        IRowSet irowSet = DbUtil.executeQuery((Context)ctx, (String)adminOrgRangeSql);
        ArrayList<String> adminRangeIdsList = new ArrayList<String>();
        while (irowSet.next()) {
            adminRangeIdsList.add(irowSet.getString("forgId"));
        }
        return HRUtilExtend.getStrFromList(adminRangeIdsList);
    }

    public static String getAdminOrgPositionSql(String adminIds) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT adminOrg.fid adminId,position.fid positionId FROM T_ORG_POSITION position").append(" inner join T_ORG_ADMIN adminOrg on adminOrg.FID = position.FADMINORGUNITID").append(" inner join t_hr_positionextend positionextend on positionextend.fpositionid = position.FID").append(" where positionextend.fisshowinorgchart=1").append(" and position.fdeletedstatus=1").append(" and adminOrg.FID in ").append(adminIds).append(" order by position.findex,position.fnumber");
        return sql.toString();
    }

    public static List<LinkedHashMap<String, Integer>> getAdminOrgRangeTreeByUserId(Context ctx, String userId, String rootLongnumber, String orgUnitLayerTypeIds, String permItemId) throws Exception {
        ArrayList<LinkedHashMap<String, Integer>> result = new ArrayList<LinkedHashMap<String, Integer>>();
        String sql = null;
        sql = "('')".equals(orgUnitLayerTypeIds) ? HROrgChartUtil.getAdminOrgRangeLongnumberByUserIdSql(ctx, userId, permItemId) : HROrgChartUtil.getAdminOrgRangeLongnumberByUserIdSql(ctx, userId, rootLongnumber, orgUnitLayerTypeIds, permItemId);
        IRowSet irowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap tempMap = new HashMap();
        int index = 0;
        boolean newTree = true;
        LinkedHashMap tempMapOut = new LinkedHashMap();
        tempMap.put(index, tempMapOut);
        while (irowSet.next()) {
            newTree = true;
            String longNumber = irowSet.getString("flongnumber");
            if (((LinkedHashMap)tempMap.get(0)).isEmpty()) {
                HashMap temp = new HashMap();
                ((LinkedHashMap)tempMap.get(0)).put(longNumber, longNumber.split("!").length - 1);
                continue;
            }
            String parentLongnumber = HROrgChartUtil.assembleParentLongnumber(longNumber);
            for (Integer i : tempMap.keySet()) {
                if (!((LinkedHashMap)tempMap.get(i)).containsKey(parentLongnumber)) continue;
                newTree = false;
                ((LinkedHashMap)tempMap.get(i)).put(longNumber, longNumber.split("!").length - 1);
            }
            if (!newTree) continue;
            newTree = true;
            LinkedHashMap<String, Integer> tempMapIn = new LinkedHashMap<String, Integer>();
            tempMapIn.put(longNumber, longNumber.split("!").length - 1);
            tempMap.put(++index, tempMapIn);
        }
        for (Integer i : tempMap.keySet()) {
            result.add((LinkedHashMap<String, Integer>)tempMap.get(i));
        }
        return result;
    }

    public static List<Map<String, Object>> getAdminLink(Context ctx, String userId, String orgUnitLayerTypeIds, String permItemId) {
        return null;
    }

    public static List<String> getTreeByUserId(Context ctx, String rootLongnumber, List<LinkedHashMap<String, Integer>> orgTrees, int level) {
        ArrayList<String> result;
        block14: {
            int realLevel;
            int rootLevel;
            ArrayList<LinkedHashMap<String, Integer>> belongTree;
            block15: {
                result = new ArrayList<String>();
                belongTree = new ArrayList<LinkedHashMap<String, Integer>>();
                rootLevel = 0;
                List<String> childList = HROrgChartUtil.getUnderLongnumberByLongnumber(ctx, rootLongnumber);
                int childNum = childList.size();
                boolean needAdd = false;
                for (int i = 0; i < orgTrees.size(); ++i) {
                    LinkedHashMap<String, Integer> tree = orgTrees.get(i);
                    if (tree.containsKey(rootLongnumber)) {
                        belongTree.add(tree);
                        rootLevel = tree.get(rootLongnumber);
                        continue;
                    }
                    for (int j = 0; j < childNum; ++j) {
                        if (tree.containsKey(childList.get(j))) {
                            belongTree.add(tree);
                            needAdd = true;
                        }
                        rootLevel = rootLongnumber.split("!").length - 1;
                    }
                }
                if (belongTree.size() == 0) {
                    result.add(rootLongnumber);
                    return result;
                }
                realLevel = rootLevel + level;
                if (belongTree.size() != 1) break block15;
                LinkedHashMap tempBelongTree = (LinkedHashMap)belongTree.get(0);
                if (!needAdd) {
                    boolean begin = false;
                    boolean first = false;
                    for (String tempLongnumber : tempBelongTree.keySet()) {
                        if (tempLongnumber.equals(rootLongnumber)) {
                            result.add(tempLongnumber);
                            begin = true;
                            first = true;
                        }
                        if (begin && (Integer)tempBelongTree.get(tempLongnumber) > rootLevel && (Integer)tempBelongTree.get(tempLongnumber) <= realLevel && tempLongnumber.startsWith(rootLongnumber)) {
                            result.add(tempLongnumber);
                        }
                        if (!begin || first || (Integer)tempBelongTree.get(tempLongnumber) != rootLevel) {
                            first = false;
                            continue;
                        }
                        break block14;
                    }
                } else {
                    result.add(rootLongnumber);
                    for (String tempLongnumber : tempBelongTree.keySet()) {
                        if ((Integer)tempBelongTree.get(tempLongnumber) <= rootLevel || (Integer)tempBelongTree.get(tempLongnumber) > realLevel || !tempLongnumber.startsWith(rootLongnumber)) continue;
                        result.add(tempLongnumber);
                    }
                }
                break block14;
            }
            if (belongTree.size() <= 1) break block14;
            result.add(rootLongnumber);
            for (int i = 0; i < belongTree.size(); ++i) {
                LinkedHashMap tempBelongTree = (LinkedHashMap)belongTree.get(i);
                for (String tempLongnumber : ((LinkedHashMap)belongTree.get(i)).keySet()) {
                    if ((Integer)tempBelongTree.get(tempLongnumber) <= rootLevel || (Integer)tempBelongTree.get(tempLongnumber) > realLevel || !tempLongnumber.startsWith(rootLongnumber)) continue;
                    result.add(tempLongnumber);
                }
            }
        }
        return result;
    }

    private static String assembleParentLongnumber(String longNumber) {
        StringBuffer result = new StringBuffer();
        String[] numbers = longNumber.split("!");
        if (numbers.length == 1) {
            return longNumber;
        }
        for (int i = 0; i < numbers.length - 1; ++i) {
            result.append(numbers[i]).append("!");
        }
        return result.toString().substring(0, result.toString().length() - 1);
    }

    public static void assembleAdmin(Context ctx, String adminRangIdsStr, Set<String> userAdminRangeIdSet, String orgChartSettngId, List<Map<String, Object>> result, boolean isVertical, String verticalLevel) throws Exception {
        boolean isShowParent = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_ORGCHART_SHOWUPPER", null);
        String rootSql = "select fid from t_org_admin where fid in " + adminRangIdsStr + " order by flongnumber";
        IRowSet rootRowSet = DbUtil.executeQuery((Context)ctx, (String)rootSql);
        String rootId = "";
        if (rootRowSet.next()) {
            rootId = rootRowSet.getString("fid");
        }
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "SELECT fid,fparentid,flongnumber,fname_" + l + " name FROM T_ORG_ADMIN where fid in " + adminRangIdsStr + "and fisstartshr = 1 and FISSEALUP = 0 order by fsortCode,flongnumber,fnumber";
        IRowSet resultRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        if (isVertical) {
            int realVerticalLevel = 0;
            int verticalLevelInt = Integer.parseInt(verticalLevel);
            int rootBeforeLevel = 0;
            boolean hasParentPerm = false;
            while (resultRowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                boolean isRoot = StringUtils.equals((String)rootId, (String)resultRowSet.getString("fid"));
                map.put("key", resultRowSet.getString("fid"));
                if (resultRowSet.getString("fparentid") != null) {
                    map.put("parent", isRoot ? "" : resultRowSet.getString("fparentid"));
                    hasParentPerm = userAdminRangeIdSet.contains(resultRowSet.getString("fparentid"));
                }
                if (map.get("parent") == null || map.get("key").equals(map.get("parent"))) {
                    map.put("isRootNode", true);
                    hasParentPerm = true;
                } else {
                    map.put("isRootNode", false);
                }
                map.put("color", "white");
                map.put("canedit", false);
                map.put("isInnerNode", true);
                map.put("orgChartSettingid", orgChartSettngId);
                map.put("hasChild", false);
                map.put("isExpand", false);
                if (isRoot) {
                    rootBeforeLevel = resultRowSet.getString("flongnumber").split("!").length;
                    realVerticalLevel = rootBeforeLevel + verticalLevelInt;
                    map.put("category", "admin");
                    map.put("level", 0);
                    map.put("isShowParent", isShowParent && !hasParentPerm);
                    result.add(map);
                    isRoot = false;
                    continue;
                }
                int realLevel = resultRowSet.getString("flongnumber").split("!").length;
                if (realLevel < realVerticalLevel) {
                    map.put("category", "admin");
                    map.put("level", realLevel - rootBeforeLevel);
                } else {
                    String adminUnitName = resultRowSet.getString("name");
                    if (StringUtils.isEmpty((String)adminUnitName)) {
                        map.put("adminUnitName", "");
                        map.put("showTips", "");
                    } else {
                        map.put("adminUnitName", adminUnitName);
                        map.put("adminUnitNameNum", adminUnitName.length());
                        map.put("showTips", "");
                    }
                    map.put("category", "vertical");
                    map.put("level", realLevel - rootBeforeLevel);
                }
                map.put("isShowParent", false);
                result.add(map);
            }
        } else {
            int rootBeforeLevel = 0;
            boolean hasParentPerm = false;
            while (resultRowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                boolean isRoot = StringUtils.equals((String)rootId, (String)resultRowSet.getString("fid"));
                if (resultRowSet.getString("fparentid") != null) {
                    map.put("parent", isRoot ? "" : resultRowSet.getString("fparentid"));
                    hasParentPerm = userAdminRangeIdSet.contains(resultRowSet.getString("fparentid"));
                }
                map.put("key", resultRowSet.getString("fid"));
                if (map.get("parent") == null || map.get("key").equals(map.get("parent"))) {
                    hasParentPerm = true;
                }
                map.put("isShowParent", isShowParent && isRoot && !hasParentPerm);
                if (isRoot) {
                    rootBeforeLevel = resultRowSet.getString("flongnumber").split("!").length;
                    isRoot = false;
                }
                map.put("canedit", false);
                map.put("color", "white");
                map.put("level", resultRowSet.getString("flongnumber").split("!").length - rootBeforeLevel);
                map.put("category", "admin");
                map.put("isInnerNode", true);
                map.put("orgChartSettingid", orgChartSettngId);
                result.add(map);
            }
        }
    }

    public static void assemblePosition(Context ctx, String positionRangIdsStr, List<Map<String, Object>> result, String hierarchy, String orgChartSettingid) throws Exception {
        if (StringUtils.isEmpty((String)hierarchy)) {
            hierarchy = "00000000-0000-0000-0000-000000000001396FCAD0";
        }
        String sql = "select position.fid,positionHierarchy.fparentid,positionHierarchy.flongnumber FROM T_ORG_POSITION position left join T_ORG_POSITIONHIERARCHY positionHierarchy on positionHierarchy.fchildid = position.fid where position.fid in " + positionRangIdsStr + " and positionHierarchy.fhierarchyid ='" + hierarchy + "' order by positionHierarchy.flongnumber";
        IRowSet resultRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        boolean isShowParent = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_ORGCHART_SHOWUPPER", null);
        boolean isRoot = true;
        int rootLevel = 0;
        while (resultRowSet.next()) {
            if (isRoot) {
                rootLevel = resultRowSet.getString("flongnumber").split("!").length;
                isRoot = false;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("key", resultRowSet.getString("fid"));
            map.put("parent", resultRowSet.getString("fparentid"));
            map.put("level", resultRowSet.getString("flongnumber").split("!").length - rootLevel);
            map.put("category", "position");
            map.put("isInnerNode", true);
            map.put("color", "white");
            map.put("orgChartSettingid", orgChartSettingid);
            map.put("hasChild", false);
            map.put("isExpand", false);
            map.put("isShowParent", isShowParent && isRoot);
            result.add(map);
        }
    }

    public static String getPersonIdByAdminIdsSql(String adminIds) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT adminOrg.fid adminId,min(person.fid) personId FROM t_org_admin adminOrg");
        sql.append(" inner join t_hr_emporgrelation relation on relation.fadminorgid = adminOrg.fid");
        sql.append(" inner join t_bd_person person on person.fid = relation.fpersonid");
        sql.append(" where exists ( select 1 from (");
        sql.append(" SELECT min(person.findex) minIndex, relation.fadminorgid");
        sql.append(" FROM t_bd_person person");
        sql.append(" inner join t_hr_emporgrelation relation on relation.fpersonid = person.fid and relation.fleffdt=");
        sql.append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)HRUtil.getMaxEndDate()));
        sql.append(" and relation.FIsLatestInAday = 1");
        sql.append(" inner join t_org_position position on position.fid = relation.fpositionid");
        sql.append(" where position.fisrespposition = 1 group by relation.fadminorgid");
        sql.append(" ) a where  person.findex = a.minIndex and relation.FADMINORGID = a.fadminorgid");
        sql.append(" ) group by adminOrg.fid");
        return sql.toString();
    }

    public static Map<String, String> getPersonIdByAdminIdsMap(Context ctx) throws BOSException, SQLException {
        HashMap adminIdsMap = new HashMap();
        String emporgrelationSql = "select emprelation.fadminorgid adminId,emprelation.fpersonid personId from t_hr_emporgrelation emprelation inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid left join t_org_position position on emprelation.fpositionid = position.fid where emprelation.FISLATESTINADAY=1 and emprelation.fleffdt=" + HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)HRUtil.getMaxEndDate()) + " and (empType.FINSERVICE=1 or empType.FINSERVICE=4) and empType.fisonthestrength = 1  and position.fisrespposition = 1";
        String personSql = "select fid personId, findex indexNum from t_bd_person";
        IRowSet emporgrelationRowSet = DbUtil.executeQuery((Context)ctx, (String)emporgrelationSql);
        IRowSet personRowSet = DbUtil.executeQuery((Context)ctx, (String)personSql);
        while (emporgrelationRowSet.next()) {
            String personId;
            List<String> personInfoList;
            String adminId = emporgrelationRowSet.getString("adminId");
            if (adminId == null) continue;
            if (!adminIdsMap.containsKey(adminId)) {
                personInfoList = new ArrayList();
                personId = emporgrelationRowSet.getString("personId");
                if (personId == null) continue;
                personInfoList.add(personId);
                adminIdsMap.put(adminId, personInfoList);
                continue;
            }
            personInfoList = (List)adminIdsMap.get(adminId);
            personId = emporgrelationRowSet.getString("personId");
            if (personId == null) continue;
            personInfoList.add(personId);
        }
        HashMap<String, Integer> personInfoMap = new HashMap<String, Integer>();
        while (personRowSet.next()) {
            personInfoMap.put(personRowSet.getString("personId"), personRowSet.getString("indexNum") == null ? 9999999 : personRowSet.getInt("indexNum"));
        }
        HashMap<String, String> adminPersonMap = new HashMap<String, String>();
        for (Map.Entry entry : adminIdsMap.entrySet()) {
            String adminId = (String)entry.getKey();
            List personIdList = (List)entry.getValue();
            if (personIdList == null) continue;
            int minIndex = Integer.MAX_VALUE;
            int count = personIdList.size();
            for (int i = 0; i < count; ++i) {
                if (personInfoMap.get(personIdList.get(i)) == null) continue;
                if ((Integer)personInfoMap.get(personIdList.get(i)) < minIndex) {
                    adminPersonMap.put(adminId, (String)personIdList.get(i));
                    minIndex = (Integer)personInfoMap.get(personIdList.get(i));
                    continue;
                }
                if ((Integer)personInfoMap.get(personIdList.get(i)) != minIndex || ((String)personIdList.get(i)).compareTo((String)adminPersonMap.get(adminId)) >= 0) continue;
                adminPersonMap.put(adminId, (String)personIdList.get(i));
            }
        }
        return adminPersonMap;
    }

    public static Map<String, String> getPersonIdByAdminIdsMap(Context ctx, String userRangeIdsString) throws BOSException, SQLException {
        HashMap adminIdsMap = new HashMap();
        String emporgrelationSql = "select emprelation.fadminorgid adminId,emprelation.fpersonid personId from t_hr_emporgrelation emprelation inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid left join t_org_position position on emprelation.fpositionid = position.fid where emprelation.FISLATESTINADAY=1 and emprelation.fleffdt=" + HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)HRUtil.getMaxEndDate()) + " and (empType.FINSERVICE=1 or empType.FINSERVICE=4) and empType.fisonthestrength = 1 and position.fisrespposition = 1";
        String personSql = "select fid personId, findex indexNum from t_bd_person";
        IRowSet emporgrelationRowSet = DbUtil.executeQuery((Context)ctx, (String)emporgrelationSql);
        IRowSet personRowSet = DbUtil.executeQuery((Context)ctx, (String)personSql);
        while (emporgrelationRowSet.next()) {
            String personId;
            ArrayList<String> personInfoList;
            String adminId = emporgrelationRowSet.getString("adminId");
            if (adminId != null && !adminIdsMap.containsKey(adminId)) {
                personInfoList = new ArrayList<String>();
                personId = emporgrelationRowSet.getString("personId");
                if (personId == null) continue;
                personInfoList.add(personId);
                adminIdsMap.put(adminId, personInfoList);
                continue;
            }
            personInfoList = (ArrayList<String>)adminIdsMap.get(adminId);
            personId = emporgrelationRowSet.getString("personId");
            if (personId == null) continue;
            personInfoList.add(personId);
        }
        HashMap<String, Integer> personInfoMap = new HashMap<String, Integer>();
        while (personRowSet.next()) {
            personInfoMap.put(personRowSet.getString("personId"), personRowSet.getString("indexNum") == null ? 9999999 : personRowSet.getInt("indexNum"));
        }
        HashMap<String, String> adminPersonMap = new HashMap<String, String>();
        for (Map.Entry entry : adminIdsMap.entrySet()) {
            String adminId = (String)entry.getKey();
            List personIdList = (List)entry.getValue();
            if (personIdList == null) continue;
            int minIndex = Integer.MAX_VALUE;
            int count = personIdList.size();
            for (int i = 0; i < count; ++i) {
                if (personInfoMap.get(personIdList.get(i)) == null) continue;
                if ((Integer)personInfoMap.get(personIdList.get(i)) < minIndex) {
                    adminPersonMap.put(adminId, (String)personIdList.get(i));
                    minIndex = (Integer)personInfoMap.get(personIdList.get(i));
                    continue;
                }
                if ((Integer)personInfoMap.get(personIdList.get(i)) != minIndex || ((String)personIdList.get(i)).compareTo((String)adminPersonMap.get(adminId)) >= 0) continue;
                adminPersonMap.put(adminId, (String)personIdList.get(i));
            }
        }
        return adminPersonMap;
    }

    public static String getPersonIdByPositionIdsSql(String positionIds) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT position.fid positionId,min(person.fid) personId");
        sql.append(" FROM t_org_position position ");
        sql.append(" left join t_hr_emporgrelation relation on relation.fpositionid = position.fid");
        sql.append(" left join t_bd_person person on person.fid = relation.fpersonid");
        sql.append(" where exists ( select 1 from (");
        sql.append(" SELECT min(person.findex) minIndex, relation.fpositionid");
        sql.append(" FROM t_bd_person person");
        sql.append(" inner join t_hr_emporgrelation relation on relation.fpersonid = person.fid and relation.fleffdt=");
        sql.append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)HRUtil.getMaxEndDate()));
        sql.append(" group by relation.fpositionid");
        sql.append(" ) a where  person.findex = a.minIndex and relation.fpositionid = a.fpositionid");
        sql.append(" ) group by position.fid");
        return sql.toString();
    }

    public static Map<String, String> getPersonIdByPositionIdsMap(Context ctx) throws Exception {
        HashMap positionIdsMap = new HashMap();
        String emporgrelationSql = "select emprelation.fpositionid positionId,emprelation.fpersonid personId from t_hr_emporgrelation emprelation inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid where emprelation.FISLATESTINADAY=1 and emprelation.fleffdt=" + HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)HRUtil.getMaxEndDate()) + " and (empType.FINSERVICE=1 or empType.FINSERVICE=4) and empType.fisonthestrength = 1";
        String personSql = "select fid personId, findex indexNum from t_bd_person";
        IRowSet emporgrelationRowSet = DbUtil.executeQuery((Context)ctx, (String)emporgrelationSql);
        IRowSet personRowSet = DbUtil.executeQuery((Context)ctx, (String)personSql);
        while (emporgrelationRowSet.next()) {
            String personId;
            List<String> personInfoList;
            String positionId = emporgrelationRowSet.getString("positionId");
            if (positionId == null) continue;
            if (!positionIdsMap.containsKey(positionId)) {
                personInfoList = new ArrayList();
                personId = emporgrelationRowSet.getString("personId");
                if (personId == null) continue;
                personInfoList.add(personId);
                positionIdsMap.put(positionId, personInfoList);
                continue;
            }
            personInfoList = (List)positionIdsMap.get(positionId);
            personId = emporgrelationRowSet.getString("personId");
            if (personId == null) continue;
            personInfoList.add(personId);
        }
        HashMap<String, Integer> personInfoMap = new HashMap<String, Integer>();
        while (personRowSet.next()) {
            personInfoMap.put(personRowSet.getString("personId"), personRowSet.getString("indexNum") == null ? 9999999 : personRowSet.getInt("indexNum"));
        }
        HashMap<String, String> positionPersonMap = new HashMap<String, String>();
        for (Map.Entry entry : positionIdsMap.entrySet()) {
            String positionId = (String)entry.getKey();
            List personIdList = (List)entry.getValue();
            if (personIdList == null) continue;
            int minIndex = Integer.MAX_VALUE;
            int count = personIdList.size();
            for (int i = 0; i < count; ++i) {
                if (personInfoMap.get(personIdList.get(i)) == null) continue;
                if ((Integer)personInfoMap.get(personIdList.get(i)) < minIndex) {
                    positionPersonMap.put(positionId, (String)personIdList.get(i));
                    minIndex = (Integer)personInfoMap.get(personIdList.get(i));
                    continue;
                }
                if ((Integer)personInfoMap.get(personIdList.get(i)) != minIndex || ((String)personIdList.get(i)).compareTo((String)positionPersonMap.get(positionId)) >= 0) continue;
                positionPersonMap.put(positionId, (String)personIdList.get(i));
            }
        }
        return positionPersonMap;
    }

    public static String getPositionIdByAdminIdsSql(String adminIds) {
        return "select fid adminId,FRESPONPOSITIONID positionId FROM T_ORG_Admin where fid in " + adminIds;
    }

    public static Map<String, Object> getPositionIdByAdminIdsMap(Context ctx, String adminIds) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> tempMap = new HashMap<String, String>();
        ArrayList<String> positionIdsList = new ArrayList<String>();
        String sql = HROrgChartUtil.getPositionIdByAdminIdsSql(adminIds);
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (iRowSet.next()) {
            tempMap.put(iRowSet.getString("adminId"), iRowSet.getString("positionId"));
            positionIdsList.add(iRowSet.getString("positionId"));
        }
        Set positionIdsSet = HROrgChartUtil.assebleListToSet(positionIdsList);
        String positionIdsString = HRUtilExtend.getStrFromList(positionIdsList);
        resultMap.put("adminPositionMap", tempMap);
        resultMap.put("positionIdsSet", positionIdsSet);
        resultMap.put("positionIdsString", positionIdsString);
        return resultMap;
    }

    public static String getAdminIdByPositionIdsSql(String positionIds) {
        return "select fid positionId, FAdminOrgUnitID adminId from T_ORG_Position where fid in " + positionIds;
    }

    public static Map<String, Object> getAdminIdByPositionIdsMap(Context ctx, String positionIds) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> tempMap = new HashMap<String, String>();
        ArrayList<String> adminIdsList = new ArrayList<String>();
        String sql = HROrgChartUtil.getAdminIdByPositionIdsSql(positionIds);
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (iRowSet.next()) {
            tempMap.put(iRowSet.getString("positionId"), iRowSet.getString("adminId"));
            adminIdsList.add(iRowSet.getString("adminId"));
        }
        Set adminIdsSet = HROrgChartUtil.assebleListToSet(adminIdsList);
        String adminIdsString = HRUtilExtend.getStrFromList(adminIdsList);
        resultMap.put("positionAdminMap", tempMap);
        resultMap.put("adminIdsSet", adminIdsSet);
        resultMap.put("adminIdsString", adminIdsString);
        return resultMap;
    }

    public static Set assebleListToSet(List list) {
        HashSet<String> set = new HashSet<String>();
        if (list.size() == 0) {
            set.add("");
        } else {
            for (int i = 0; i < list.size(); ++i) {
                set.add((String)list.get(i));
            }
        }
        return set;
    }

    public static List<Map> getDefaultRootOrgId(Context ctx, String userId, String permItemId) throws EASBizException, BOSException, SQLException {
        HROrgChartUtil.isBOSUuid(userId);
        HROrgChartUtil.isBOSUuid(permItemId);
        ArrayList<Map> resultList = new ArrayList<Map>();
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select adminOrg.fid,adminOrg.flongnumber,adminOrg.fname_" + l + " name,1+length(flongnumber)-length(replace(flongnumber,'!','')) from t_org_admin adminOrg inner join (" + SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId) + ") orgrange on orgrange.FAdminOrgID = adminOrg.fid order by 4,adminOrg.findex";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (iRowSet.next()) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", iRowSet.getString("fid"));
            map.put("longnumber", iRowSet.getString("flongnumber"));
            map.put("name", iRowSet.getString("name"));
            resultList.add(map);
        }
        return resultList;
    }

    public static String getPositionLongnumberById(Context ctx, String positionId, String hierarchy) throws Exception {
        if (StringUtils.isEmpty((String)hierarchy)) {
            hierarchy = "00000000-0000-0000-0000-000000000001396FCAD0";
        }
        String sql = "select flongnumber from T_ORG_POSITIONHIERARCHY where fchildid = '" + positionId + "' and fhierarchyid = '" + hierarchy + "' order by flongnumber";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        String positionLongnumber = null;
        while (iRowSet.next()) {
            positionLongnumber = iRowSet.getString("flongnumber");
        }
        return positionLongnumber;
    }

    public static Map<String, String> getAdminLongnumberAndNameById(Context ctx, String adiminId, String datepicker, boolean isHis) throws Exception {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String sql = null;
        Object[] params = null;
        Date _datepicker = new Date(DateTimeUtils.parseDate((String)datepicker).getTime());
        String l = LocaleUtils.getShortCode((Context)ctx);
        if (isHis) {
            sql = "select admintreehis.flongnumber, adminhis.fname_" + l + " name from T_ORG_AdminHis adminhis left join t_org_adminorgtreehis admintreehis on adminhis.FHISTORYRELATEID = admintreehis.FAdminOrgID where adminhis.FID = ? and adminhis.feffdt<= ? and adminhis.fleffdt>= ? and admintreehis.feffdt<= ? and admintreehis.fleffdt>= ? order by flongnumber";
            params = new Object[]{adiminId, _datepicker, _datepicker, _datepicker, _datepicker};
        } else {
            sql = "select admintreehis.flongnumber, adminhis.fname_" + l + " name from T_ORG_AdminHis adminhis left join t_org_adminorgtreehis admintreehis on adminhis.FHISTORYRELATEID = admintreehis.FAdminOrgID where adminhis.FHISTORYRELATEID = ? and admintreehis.FAdminOrgID = ? and adminhis.feffdt<= ? and adminhis.fleffdt>= ? and admintreehis.feffdt<= ? and admintreehis.fleffdt>= ? order by flongnumber";
            params = new Object[]{adiminId, adiminId, _datepicker, _datepicker, _datepicker, _datepicker};
        }
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
        String adminLongnumber = null;
        String adminName = null;
        while (iRowSet.next()) {
            adminLongnumber = iRowSet.getString("flongnumber");
            adminName = iRowSet.getString("name");
        }
        resultMap.put("longnumber", adminLongnumber);
        resultMap.put("name", adminName);
        resultMap.put("id", adiminId);
        return resultMap;
    }

    public static String getDefaultRootPositionId(Context ctx, String userId) throws Exception {
        String rootPositionId = null;
        List userPositionList = SHREmpOptPersonPositionUtil.getUserPositionList((Context)ctx, (String)userId);
        rootPositionId = (String)((Map)userPositionList.get(0)).get("positionId");
        return rootPositionId;
    }

    public static Map<String, Object> longnumberlistToId(Context ctx, List<String> longnumbersList) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String longnumberStr = HRUtilExtend.getStrFromList(longnumbersList);
        String sql = null;
        sql = "select fid from t_org_admin where flongnumber in " + longnumberStr;
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> adminIdsList = new ArrayList<String>();
        HashSet<String> adminIdsSet = new HashSet<String>();
        while (iRowSet.next()) {
            adminIdsList.add(iRowSet.getString("fid"));
            adminIdsSet.add(iRowSet.getString("fid"));
        }
        String idsStr = HRUtilExtend.getStrFromList(adminIdsList);
        result.put("string", idsStr);
        result.put("set", adminIdsSet);
        return result;
    }

    public static Map<String, Object> positionLongnumberlistToId(Context ctx, List<String> positionLongnumbersList, String hierarchy) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String longnumberStr = HRUtilExtend.getStrFromList(positionLongnumbersList);
        if (StringUtils.isEmpty((String)hierarchy)) {
            hierarchy = "00000000-0000-0000-0000-000000000001396FCAD0";
        }
        String sql = "select fchildid from T_ORG_POSITIONHIERARCHY where flongnumber in " + longnumberStr + " and fhierarchyid = '" + hierarchy + "'";
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> positionIdsList = new ArrayList<String>();
        HashSet<String> positionIdsSet = new HashSet<String>();
        while (iRowSet.next()) {
            positionIdsList.add(iRowSet.getString("fchildid"));
            positionIdsSet.add(iRowSet.getString("fchildid"));
        }
        result.put("string", HRUtilExtend.getStrFromList(positionIdsList));
        result.put("set", positionIdsSet);
        return result;
    }

    public static Map<String, Object> getPositionRangeByAdmin(Context ctx, String adminRangIdsStr) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        String sql = "SELECT fid FROM T_ORG_POSITION where FADMINORGUNITID in " + adminRangIdsStr;
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        ArrayList<String> positionIdsList = new ArrayList<String>();
        HashSet<String> positionIdsSet = new HashSet<String>();
        while (iRowSet.next()) {
            positionIdsList.add(iRowSet.getString("fid"));
            positionIdsSet.add(iRowSet.getString("fid"));
        }
        result.put("string", HRUtilExtend.getStrFromList(positionIdsList));
        result.put("set", positionIdsSet);
        return result;
    }

    public static List<Map<String, Integer>> getPositionRangeTreeByUserId(Context ctx, String userId, String hierarchy, String permItemId) throws Exception {
        ArrayList<Map<String, Integer>> result = new ArrayList<Map<String, Integer>>();
        StringBuffer sql = new StringBuffer();
        Object filterSql = null;
        if (StringUtils.isEmpty((String)hierarchy)) {
            hierarchy = "00000000-0000-0000-0000-000000000001396FCAD0";
        }
        sql.append("SELECT positionHierarchy.flongnumber,positionHierarchy.fchildid").append(" FROM T_ORG_POSITIONHIERARCHY positionHierarchy").append(" inner join T_ORG_POSITION position on positionHierarchy.fchildid = position.fid").append(" inner join (").append(HROrgChartUtil.getAdminOrgRangeIdByUserIdSql(ctx, userId, permItemId)).append(") adminRange on position.fadminorgunitid = adminRange.forgId").append(" where positionHierarchy.fhierarchyid = '" + hierarchy + "'").append(" and position.FDeletedStatus = 1").append(" order by positionHierarchy.flongnumber");
        IRowSet irowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap tempMap = new HashMap();
        int index = 0;
        boolean newTree = true;
        LinkedHashMap tempMapOut = new LinkedHashMap();
        tempMap.put(index, tempMapOut);
        while (irowSet.next()) {
            newTree = true;
            String longNumber = irowSet.getString("flongnumber");
            if (((Map)tempMap.get(0)).isEmpty()) {
                HashMap temp = new HashMap();
                ((Map)tempMap.get(0)).put(longNumber, longNumber.split("!").length - 1);
                continue;
            }
            String parentLongnumber = HROrgChartUtil.assembleParentLongnumber(longNumber);
            for (Integer i : tempMap.keySet()) {
                if (!((Map)tempMap.get(i)).containsKey(parentLongnumber)) continue;
                newTree = false;
                ((Map)tempMap.get(i)).put(longNumber, longNumber.split("!").length - 1);
            }
            if (!newTree) continue;
            newTree = true;
            LinkedHashMap<String, Integer> tempMapIn = new LinkedHashMap<String, Integer>();
            tempMapIn.put(longNumber, longNumber.split("!").length - 1);
            tempMap.put(++index, tempMapIn);
        }
        for (Integer i : tempMap.keySet()) {
            result.add((Map<String, Integer>)tempMap.get(i));
        }
        return result;
    }

    public static String getPositionRangeByUserIdSql(Context ctx, String userId, String hierarchy, String permItemId) {
        StringBuffer sql = new StringBuffer();
        sql.append("select position.fid from t_org_position position");
        sql.append(" inner join T_ORG_POSITIONHIERARCHY hierarchy on hierarchy.fchildid = position.fid");
        sql.append(" where position.fadminorgunitid in (");
        sql.append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId)).append(")");
        sql.append(" and hierarchy.FHierarchyID = '" + hierarchy + "'");
        sql.append(" and position.fdeletedstatus=1");
        return sql.toString();
    }

    public static List<Map<String, Integer>> getPositionRangeTreeByUserId(Context ctx, String userId, String orgUnitLayerTypeIds, String hierarchy, String permItemId) throws Exception {
        ArrayList<Map<String, Integer>> result = new ArrayList<Map<String, Integer>>();
        StringBuffer sql = new StringBuffer();
        String rangeSql = null;
        HROrgChartUtil.isBOSUuid(userId);
        HROrgChartUtil.isBOSUuid(permItemId);
        rangeSql = "('')".equals(orgUnitLayerTypeIds) ? HROrgChartUtil.getAdminOrgRangeIdByUserIdSql(ctx, userId, permItemId) : HROrgChartUtil.getAdminOrgRangeIdByUserIdSql(ctx, userId, orgUnitLayerTypeIds, permItemId);
        if (StringUtils.isEmpty((String)hierarchy)) {
            hierarchy = "00000000-0000-0000-0000-000000000001396FCAD0";
        }
        sql.append("SELECT positionHierarchy.flongnumber,positionHierarchy.fchildid").append(" FROM T_ORG_POSITIONHIERARCHY positionHierarchy").append(" inner join T_ORG_POSITION position on positionHierarchy.fchildid = position.fid").append(" inner join (").append(rangeSql).append(") adminRange on position.fadminorgunitid = adminRange.forgId").append(" where positionHierarchy.fhierarchyid = ?").append(" order by positionHierarchy.flongnumber");
        IRowSet irowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{hierarchy});
        HashMap tempMap = new HashMap();
        int index = 0;
        boolean newTree = true;
        LinkedHashMap tempMapOut = new LinkedHashMap();
        tempMap.put(index, tempMapOut);
        while (irowSet.next()) {
            newTree = true;
            String longNumber = irowSet.getString("flongnumber");
            if (((Map)tempMap.get(0)).isEmpty()) {
                HashMap temp = new HashMap();
                ((Map)tempMap.get(0)).put(longNumber, longNumber.split("!").length - 1);
                continue;
            }
            String parentLongnumber = HROrgChartUtil.assembleParentLongnumber(longNumber);
            for (Integer i : tempMap.keySet()) {
                if (!((Map)tempMap.get(i)).containsKey(parentLongnumber)) continue;
                newTree = false;
                ((Map)tempMap.get(i)).put(longNumber, longNumber.split("!").length - 1);
            }
            if (!newTree) continue;
            newTree = true;
            LinkedHashMap<String, Integer> tempMapIn = new LinkedHashMap<String, Integer>();
            tempMapIn.put(longNumber, longNumber.split("!").length - 1);
            tempMap.put(++index, tempMapIn);
        }
        for (Integer i : tempMap.keySet()) {
            result.add((Map<String, Integer>)tempMap.get(i));
        }
        return result;
    }

    public static List<String> getPositionTreeByUserId(String positionLongnumber, List<Map<String, Integer>> positionTrees, int level) {
        ArrayList<String> result = new ArrayList<String>();
        Map<String, Integer> belongTree = null;
        int rootLevel = 0;
        for (int i = 0; i < positionTrees.size(); ++i) {
            Map<String, Integer> tree = positionTrees.get(i);
            if (!tree.containsKey(positionLongnumber)) continue;
            belongTree = tree;
            rootLevel = tree.get(positionLongnumber);
        }
        if (belongTree == null) {
            return null;
        }
        int realLevel = rootLevel + level;
        boolean begin = false;
        boolean first = false;
        for (String tempLongnumber : belongTree.keySet()) {
            if (tempLongnumber.equals(positionLongnumber)) {
                result.add(tempLongnumber);
                begin = true;
                first = true;
            }
            if (begin && belongTree.get(tempLongnumber) > rootLevel && belongTree.get(tempLongnumber) <= realLevel && tempLongnumber.startsWith(positionLongnumber)) {
                result.add(tempLongnumber);
            }
            if (begin && !first && belongTree.get(tempLongnumber) == rootLevel) break;
            first = false;
        }
        return result;
    }

    public static String getPersonListByPositionIdSql(String positionId, String userId) {
        java.util.Date now = new java.util.Date();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM T_BD_Person person").append(" LEFT OUTER join T_HR_EmpOrgRelation empRelation ON person.FID = empRelation.FPersonID").append(" LEFT OUTER join T_HR_PersonPositionHis pp ON person.FID = pp.FPersonID").append(" LEFT OUTER JOIN T_ORG_Admin AS adminOrg ON empRelation.FAdminOrgID = adminOrg.FID").append(" LEFT OUTER JOIN T_HR_BDEmployeeType AS employeeType ON person.FEmployeeTypeID = employeeType.FID").append(" WHERE").append(" empRelation.FEFFDT <= ").append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)now)).append(" AND empRelation.FLEFFDT > ").append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)now)).append(" AND pp.FEFFDT <= ").append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)now)).append(" AND pp.FLEFFDT > ").append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)now)).append(" AND empRelation.FPositionID = '" + positionId + "'").append(" AND employeeType.FIsInCount = 1");
        return sql.toString();
    }

    public static String getPersonListByAdminIdSql(String adminId, String userId, String adminLongnumber, boolean isIncludeSub) {
        java.util.Date now = new java.util.Date();
        String isIncludeSubSql = null;
        isIncludeSubSql = isIncludeSub ? " OR ADMINORGUNIT.FLongNumber like '" + adminLongnumber + "!%' " : "";
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM T_BD_PERSON person").append(" LEFT JOIN  T_HR_EMPORGRELATION emporgrelation ON emporgrelation.FPersonID=person.FID AND emporgrelation.FIsInner=1").append(" AND emporgrelation.FAssignType= 1 and emporgrelation.FEFFDT<= ").append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)now)).append(" and EMPORGRELATION.FLEFFDT>= ").append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)now)).append(" LEFT JOIN  T_ORG_ADMIN adminOrg ON adminOrg.FID=emporgrelation.FADMINORGID").append(" LEFT JOIN  T_HR_PERSONPOSITION pp ON pp.FPersonID=person.FID").append(" LEFT JOIN  T_HR_EMPLABORRELATION laborrela ON laborrela.FPersonID=emporgrelation.FPERSONID").append(" LEFT JOIN  T_HR_BDEMPLOYEETYPE emptype ON emptype.FID=laborrela.FLABORRELATIONSTATEID").append(" WHERE (adminOrg.FLongNumber= '" + adminLongnumber + "'").append(isIncludeSubSql).append(")").append(" AND emptype.FIsInCount= 1").append(" AND person.FEFFDT<= ").append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)now)).append(" AND person.FLEFFDT>= ").append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)now)).append(" AND pp.FEFFDT<= ").append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)now)).append(" AND pp.FLEFFDT>= ").append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)now)).append(" AND emporgrelation.FEFFDT<= ").append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)now)).append(" AND emporgrelation.FLEFFDT>= ").append(HRUtilExtend.getDateStringWithoutMininuteTs((java.util.Date)now));
        return sql.toString();
    }

    public static String getAdminHisLongnumber(Context ctx, String orgId, String datepicker) throws Exception {
        String result = null;
        String sql = "SELECT flongnumber FROM t_org_adminorgtreehis where FAdminOrgID = '" + orgId + "' and FEFFDT <={ts'" + datepicker + "'} and FLEFFDT>={ts'" + datepicker + "'} order by flongnumber";
        IRowSet irowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (irowSet.next()) {
            result = irowSet.getString("flongnumber");
        }
        return result;
    }

    public static List<Map<String, Object>> getHisTreeByAdminLongnumber(Context ctx, Set<String> userAdminRangeIdSet, String rootLongnumber, String datepicker, int level, boolean isVertical, String verticalLevel, String orgUnitLayerTypeIds) throws Exception {
        boolean isShowParent = HRParamUtil.getParamOfHR((Context)ctx, (String)"IS_ORGCHART_SHOWUPPER", null);
        String orgUnitTypeSql = "";
        orgUnitTypeSql = "('')".equals(orgUnitLayerTypeIds) ? "" : " and ( adminhis.FLayerTypeID in " + orgUnitLayerTypeIds + " or admintreehis.FLongNumber = '" + rootLongnumber + "')";
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            int rootLongnumberInt = rootLongnumber.split("!").length;
            int realEndLevel = rootLongnumberInt + level;
            int realVerticalLevel = rootLongnumberInt + Integer.parseInt(verticalLevel);
            String l = LocaleUtils.getShortCode((Context)ctx);
            StringBuffer sql = new StringBuffer("SELECT admintreehis.flongnumber,admintreehis.fparentid,admintreehis.FAdminOrgID fid,adminhis.fname_" + l + " name FROM T_ORG_ADMINHIS adminhis");
            sql.append(" left join t_org_adminorgtreehis admintreehis on admintreehis.FAdminOrgID = adminhis.FHISTORYRELATEID");
            sql.append(" where adminhis.FISSEALUP = 0 and adminhis.FISSTARTSHR = 1 and adminhis.FEFFDT <= {ts'").append(datepicker).append("'}");
            sql.append(" and adminhis.FLEFFDT >= {ts'").append(datepicker).append("'}");
            sql.append(" and admintreehis.FEFFDT <= {ts'").append(datepicker).append("'}");
            sql.append(" and admintreehis.FLEFFDT >= {ts'").append(datepicker).append("'}");
            sql.append(orgUnitTypeSql);
            sql.append(" order by admintreehis.FLONGNUMBER,adminhis.FSortCode");
            IRowSet irowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            boolean start = false;
            boolean end = false;
            ArrayList<String> tempLongnumberList = new ArrayList<String>();
            while (irowSet.next()) {
                HashMap<String, Object> map;
                if (irowSet.getString("flongnumber").equals(rootLongnumber)) {
                    map = new HashMap<String, Object>();
                    map.put("key", irowSet.getString("fid"));
                    if (map.get("parent") == null || map.get("key").equals(map.get("parent"))) {
                        map.put("isRootNode", true);
                    } else {
                        map.put("isRootNode", false);
                    }
                    map.put("color", "white");
                    map.put("level", 0);
                    map.put("hasChild", false);
                    map.put("isExpand", false);
                    map.put("category", "admin");
                    if (irowSet.getString("fparentid") == null) {
                        map.put("isShowParent", false);
                    } else {
                        map.put("isShowParent", isShowParent && !userAdminRangeIdSet.contains(irowSet.getString("fparentid")));
                    }
                    result.add(map);
                    tempLongnumberList.add(irowSet.getString("flongnumber"));
                    start = true;
                    continue;
                }
                if (start) {
                    String longNumber;
                    String parentLongnumber;
                    map = new HashMap();
                    if (irowSet.getString("flongnumber").split("!").length == rootLongnumberInt) {
                        end = true;
                    } else if (irowSet.getString("flongnumber").split("!").length > rootLongnumberInt && irowSet.getString("flongnumber").split("!").length <= realEndLevel && irowSet.getString("flongnumber").startsWith(rootLongnumber) && tempLongnumberList.contains(parentLongnumber = HROrgChartUtil.assembleParentLongnumber(longNumber = irowSet.getString("flongnumber")))) {
                        if (irowSet.getString("fparentid") != null) {
                            map.put("parent", irowSet.getString("fparentid"));
                        }
                        map.put("key", irowSet.getString("fid"));
                        map.put("color", "white");
                        map.put("hasChild", false);
                        map.put("isExpand", false);
                        map.put("isShowParent", false);
                        if (isVertical && irowSet.getString("flongnumber").split("!").length >= realVerticalLevel) {
                            String adminUnitName = irowSet.getString("name");
                            if (StringUtils.isEmpty((String)adminUnitName)) {
                                map.put("adminUnitName", "");
                                map.put("showTips", "");
                            } else {
                                map.put("adminUnitName", adminUnitName);
                                map.put("adminUnitNameNum", adminUnitName.length());
                                map.put("showTips", "");
                            }
                            map.put("category", "vertical");
                        } else {
                            map.put("category", "admin");
                        }
                        map.put("level", longNumber.split("!").length - rootLongnumberInt);
                        result.add(map);
                        tempLongnumberList.add(longNumber);
                    }
                }
                if (!end) continue;
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static String getHisAdminOrgPositionSql(String adminId, String datepicker) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT adminhis.FHISTORYRELATEID adminHisId, positionhis.FHISTORYRELATEID positionHisId FROM t_org_positionhis positionhis").append(" inner join t_org_adminhis adminhis on adminhis.FHISTORYRELATEID = positionhis.fadminorgunitid").append(" inner join t_hr_positionextend positionextend on positionextend.fpositionid = positionhis.FHISTORYRELATEID").append(" where positionextend.fisshowinorgchart=1").append(" and positionhis.feffdt <= {ts'" + datepicker + "'}").append(" and positionhis.fleffdt >= {ts'" + datepicker + "'}").append(" and positionhis.fdeletedstatus = 1").append(" and adminhis.feffdt <= {ts'" + datepicker + "'}").append(" and adminhis.fleffdt >= {ts'" + datepicker + "'}").append(" and adminhis.FHISTORYRELATEID in ").append(adminId).append(" order by positionhis.findex,positionhis.fnumber");
        return sql.toString();
    }

    public static String getHisPersonIdByAdminIdsSql(String adminHisIds, String datepicker) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT adminOrg.fid adminHisId,min(person.fid) personHisId FROM t_org_admin adminOrg");
        sql.append(" left join t_org_position position on position.fadminorgunitid = adminOrg.fresponpositionid");
        sql.append(" left join t_hr_emporgrelation relation on relation.fadminorgid = adminOrg.fid");
        sql.append(" left join t_bd_person person on person.fid = relation.fpersonid");
        sql.append(" where exists ( select 1 from (");
        sql.append(" SELECT min(person.findex) minIndex, relation.fadminorgid");
        sql.append(" FROM t_bd_person person ");
        sql.append(" inner join t_hr_emporgrelation relation on relation.fpersonid = person.fid and relation.feffdt <= {ts'" + datepicker + "'}");
        sql.append(" and relation.fleffdt >= {ts'" + datepicker + "'}");
        sql.append(" inner join t_org_positionhis position on position.fhistoryrelateid = relation.fpositionid and position.feffdt <= {ts'" + datepicker + "'}");
        sql.append(" and position.fleffdt >= {ts'" + datepicker + "'}");
        sql.append(" where position.fisrespposition = 1 group by relation.fadminorgid");
        sql.append(" ) a where  person.findex = a.minIndex and relation.FADMINORGID = a.fadminorgid");
        sql.append(" ) group by adminOrg.fid");
        return sql.toString();
    }

    public static Map<String, String> getHisPersonIdByAdminIdsMap(Context ctx, String adminHisIds, String datepicker) throws BOSException, SQLException {
        HashMap resultMap = new HashMap();
        HashMap tempMap = new HashMap();
        ArrayList personHisIdsList = new ArrayList();
        HashMap adminIdsMap = new HashMap();
        String emporgrelationSql = "select emprelation.fadminorgid adminId,emprelation.fpersonid personId from t_hr_emporgrelation emprelation inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid left join t_org_positionhis positionhis on emprelation.fpositionid = positionhis.fhistoryrelateid where emprelation.FISLATESTINADAY=1 and emprelation.feffdt <= {ts'" + datepicker + "'} and emprelation.fleffdt >= {ts'" + datepicker + "'}  and emprelation.FAssignType = 1 and laborRelationHis.FStartDateTime <= {ts'" + datepicker + "'} and laborRelationHis.FEndDateTime >= {ts'" + datepicker + "'} and (empType.FINSERVICE=1 or empType.FINSERVICE=4) and empType.fisonthestrength = 1 and positionhis.fisrespposition = 1  and positionhis.feffdt <= {ts'" + datepicker + "'} and positionhis.fleffdt >= {ts'" + datepicker + "'}  union all select emprelation.fadminorgid adminId,emprelation.fpersonid personId from t_hr_emporgrelation emprelation inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid left join t_org_positionhis positionhis on emprelation.fpositionid = positionhis.fhistoryrelateid where emprelation.FISLATESTINADAY=1 and emprelation.feffdt <= {ts'" + datepicker + "'} and emprelation.fleffdt >= {ts'" + datepicker + "'}  and emprelation.FAssignType = 0 and (empType.FINSERVICE=1 or empType.FINSERVICE=4) and empType.fisonthestrength = 1 and positionhis.fisrespposition = 1  and positionhis.feffdt <= {ts'" + datepicker + "'} and positionhis.fleffdt >= {ts'" + datepicker + "'} ";
        String personSql = "select fid personId, findex indexNum from t_bd_person";
        IRowSet emporgrelationRowSet = DbUtil.executeQuery((Context)ctx, (String)emporgrelationSql);
        IRowSet personRowSet = DbUtil.executeQuery((Context)ctx, (String)personSql);
        while (emporgrelationRowSet.next()) {
            String personId;
            ArrayList<String> personInfoList;
            String adminId = emporgrelationRowSet.getString("adminId");
            if (adminId == null) continue;
            if (adminId != null && !adminIdsMap.containsKey(adminId)) {
                personInfoList = new ArrayList<String>();
                personId = emporgrelationRowSet.getString("personId");
                if (personId == null) continue;
                personInfoList.add(personId);
                adminIdsMap.put(adminId, personInfoList);
                continue;
            }
            personInfoList = (ArrayList<String>)adminIdsMap.get(adminId);
            personId = emporgrelationRowSet.getString("personId");
            if (personId == null) continue;
            personInfoList.add(personId);
        }
        HashMap<String, Integer> personInfoMap = new HashMap<String, Integer>();
        while (personRowSet.next()) {
            personInfoMap.put(personRowSet.getString("personId"), personRowSet.getString("indexNum") == null ? 9999999 : personRowSet.getInt("indexNum"));
        }
        HashMap<String, String> adminPersonHisMap = new HashMap<String, String>();
        for (Map.Entry entry : adminIdsMap.entrySet()) {
            String adminId = (String)entry.getKey();
            List personIdList = (List)entry.getValue();
            if (personIdList == null) continue;
            int minIndex = Integer.MAX_VALUE;
            int count = personIdList.size();
            for (int i = 0; i < count; ++i) {
                if (personInfoMap.get(personIdList.get(i)) == null) continue;
                if ((Integer)personInfoMap.get(personIdList.get(i)) < minIndex) {
                    adminPersonHisMap.put(adminId, (String)personIdList.get(i));
                    minIndex = (Integer)personInfoMap.get(personIdList.get(i));
                    continue;
                }
                if ((Integer)personInfoMap.get(personIdList.get(i)) != minIndex || ((String)personIdList.get(i)).compareTo((String)adminPersonHisMap.get(adminId)) >= 0) continue;
                adminPersonHisMap.put(adminId, (String)personIdList.get(i));
            }
        }
        return adminPersonHisMap;
    }

    public static String getHisPersonIdByPositionIdsSql(String positionIds, String datepicker) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT positionhis.fhistoryrelateid,min(person.fid) personid");
        sql.append(" FROM t_org_positionhis positionhis");
        sql.append(" left join t_hr_emporgrelation relation on relation.fpositionid = positionhis.fhistoryrelateid and relation.feffdt <= {ts'" + datepicker + "'}");
        sql.append(" and relation.fleffdt >= {ts'" + datepicker + "'}");
        sql.append(" left join t_bd_person person on person.fid = relation.fpersonid");
        sql.append(" where exists ( select 1 from (");
        sql.append(" SELECT min(person.findex) minIndex, relation.fpositionid");
        sql.append(" FROM t_bd_person person ");
        sql.append(" inner join t_hr_emporgrelation relation on relation.fpersonid = person.fid and relation.feffdt <= {ts'" + datepicker + "'}");
        sql.append(" and relation.fleffdt >= {ts'" + datepicker + "'}");
        sql.append(" group by relation.fpositionid");
        sql.append(" ) a where  person.findex = a.minIndex and relation.fpositionid = a.fpositionid");
        sql.append(" ) and positionhis.feffdt <= {ts'" + datepicker + "'}");
        sql.append(" and positionhis.fleffdt >= {ts'" + datepicker + "'}");
        sql.append(" group by positionhis.fhistoryrelateid");
        return sql.toString();
    }

    public static Map<String, String> getHisPersonIdByPositionIdsMap(Context ctx, String positionIds, String datepicker) throws Exception {
        HashMap resultMap = new HashMap();
        HashMap positionIdsMap = new HashMap();
        String emporgrelationSql = "select emprelation.fpositionid positionId,emprelation.fpersonid personId from t_hr_emporgrelation emprelation inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid where emprelation.FISLATESTINADAY=1 and emprelation.feffdt <= {ts'" + datepicker + "'} and emprelation.fleffdt >= {ts'" + datepicker + "'} and emprelation.FAssignType = 1 and laborRelationHis.FStartDateTime <= {ts'" + datepicker + "'} and laborRelationHis.FEndDateTime >= {ts'" + datepicker + "'} and (empType.FINSERVICE=1 or empType.FINSERVICE=4) and empType.fisonthestrength = 1 union all  select emprelation.fpositionid positionId,emprelation.fpersonid personId from t_hr_emporgrelation emprelation inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid where emprelation.FISLATESTINADAY=1 and emprelation.feffdt <= {ts'" + datepicker + "'} and emprelation.fleffdt >= {ts'" + datepicker + "'} and emprelation.FAssignType = 0 and (empType.FINSERVICE=1 or empType.FINSERVICE=4) and empType.fisonthestrength = 1";
        String personSql = "select fid personId, findex indexNum from t_bd_person";
        IRowSet emporgrelationRowSet = DbUtil.executeQuery((Context)ctx, (String)emporgrelationSql);
        IRowSet personRowSet = DbUtil.executeQuery((Context)ctx, (String)personSql);
        while (emporgrelationRowSet.next()) {
            String personId;
            ArrayList<String> personInfoList;
            String positionId = emporgrelationRowSet.getString("positionId");
            if (positionId == null) continue;
            if (positionId != null && !positionIdsMap.containsKey(positionId)) {
                personInfoList = new ArrayList<String>();
                personId = emporgrelationRowSet.getString("personId");
                if (personId == null) continue;
                personInfoList.add(personId);
                positionIdsMap.put(positionId, personInfoList);
                continue;
            }
            personInfoList = (ArrayList<String>)positionIdsMap.get(positionId);
            personId = emporgrelationRowSet.getString("personId");
            if (personId == null) continue;
            personInfoList.add(personId);
        }
        HashMap<String, Integer> personInfoMap = new HashMap<String, Integer>();
        while (personRowSet.next()) {
            personInfoMap.put(personRowSet.getString("personId"), personRowSet.getString("indexNum") == null ? 9999999 : personRowSet.getInt("indexNum"));
        }
        HashMap<String, String> positionPersonHisMap = new HashMap<String, String>();
        for (Map.Entry entry : positionIdsMap.entrySet()) {
            String positionId = (String)entry.getKey();
            List personIdList = (List)entry.getValue();
            if (personIdList == null) continue;
            int minIndex = Integer.MAX_VALUE;
            int count = personIdList.size();
            for (int i = 0; i < count; ++i) {
                if (personInfoMap.get(personIdList.get(i)) == null) continue;
                if ((Integer)personInfoMap.get(personIdList.get(i)) < minIndex) {
                    positionPersonHisMap.put(positionId, (String)personIdList.get(i));
                    minIndex = (Integer)personInfoMap.get(personIdList.get(i));
                    continue;
                }
                if ((Integer)personInfoMap.get(personIdList.get(i)) != minIndex || ((String)personIdList.get(i)).compareTo((String)positionPersonHisMap.get(positionId)) >= 0) continue;
                positionPersonHisMap.put(positionId, (String)personIdList.get(i));
            }
        }
        return positionPersonHisMap;
    }

    public static String getHisPositionIdByAdminIdsSql(String adminHisIds, String datepicker) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT adminhis.FHISTORYRELATEID adminHisId, positionhis.FHISTORYRELATEID positionHisId FROM t_org_positionhis positionhis").append(" inner join t_org_adminhis adminhis on adminhis.FHISTORYRELATEID = positionhis.fadminorgunitid").append(" where positionhis.feffdt <= {ts'" + datepicker + "'}").append(" and positionhis.fleffdt >= {ts'" + datepicker + "'}").append(" and adminhis.feffdt <= {ts'" + datepicker + "'}").append(" and adminhis.fleffdt >= {ts'" + datepicker + "'}").append(" and adminhis.FHISTORYRELATEID in ").append(adminHisIds);
        return sql.toString();
    }

    public static Map<String, Object> getHisPositionIdByAdminIdsMap(Context ctx, String adminIds, String datepicker) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> tempMap = new HashMap<String, String>();
        ArrayList<String> positionHisIdsList = new ArrayList<String>();
        String sql = HROrgChartUtil.getHisPositionIdByAdminIdsSql(adminIds, datepicker);
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (iRowSet.next()) {
            tempMap.put(iRowSet.getString("adminHisId"), iRowSet.getString("positionHisId"));
            positionHisIdsList.add(iRowSet.getString("positionHisId"));
        }
        Set positionHisIdsSet = HROrgChartUtil.assebleListToSet(positionHisIdsList);
        String positionHisIdsString = HRUtilExtend.getStrFromList(positionHisIdsList);
        resultMap.put("adminPositionHisMap", tempMap);
        resultMap.put("positionHisIdsSet", positionHisIdsSet);
        resultMap.put("positionHisIdsString", positionHisIdsString);
        return resultMap;
    }

    public static String getHisAdminIdByPositionIdsSql(String positionIds, String datepicker) {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FADMINORGUNITID adminHisId,FHISTORYRELATEID positionHisId FROM t_org_positionhis").append(" where feffdt <= {ts'" + datepicker + "'}").append(" and fleffdt >= {ts'" + datepicker + "'}").append(" and FHISTORYRELATEID in ").append(positionIds);
        return sql.toString();
    }

    public static Map<String, Object> getHisAdminIdByPositionIdsMap(Context ctx, String positionIds, String datepicker) throws Exception {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        HashMap<String, String> tempMap = new HashMap<String, String>();
        ArrayList<String> adminHisIdsList = new ArrayList<String>();
        String sql = HROrgChartUtil.getHisAdminIdByPositionIdsSql(positionIds, datepicker);
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (iRowSet.next()) {
            tempMap.put(iRowSet.getString("positionHisId"), iRowSet.getString("adminHisId"));
            adminHisIdsList.add(iRowSet.getString("adminHisId"));
        }
        Set adminHisIdsSet = HROrgChartUtil.assebleListToSet(adminHisIdsList);
        String adminHisIdsString = HRUtilExtend.getStrFromList(adminHisIdsList);
        resultMap.put("positionAdminHisMap", tempMap);
        resultMap.put("adminHisIdsSet", adminHisIdsSet);
        resultMap.put("adminHisIdsString", adminHisIdsString);
        return resultMap;
    }

    public static Map<String, String> getUserInfoMap(Context ctx, String orgChartSettingId) throws Exception {
        HashMap<String, String> resultMap;
        block4: {
            int index;
            IRowSet iRowSet;
            block3: {
                resultMap = new HashMap<String, String>();
                StringBuffer sql = new StringBuffer();
                String l = LocaleUtils.getShortCode((Context)ctx);
                sql.append("SELECT fname_" + l + " name FROM t_bd_person where fid in (").append(" SELECT fpersonid FROM t_pm_user where fid in (").append(" select fcreatorid from t_hr_orgchartsetting where fid = ?").append(" union all ").append(" select flastupdateuserid from t_hr_orgchartsetting where fid = ?))");
                iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgChartSettingId, orgChartSettingId});
                index = 1;
                if (iRowSet.size() != 1) break block3;
                while (iRowSet.next()) {
                    resultMap.put("creator", iRowSet.getString("name") == null ? "" : iRowSet.getString("name"));
                    resultMap.put("lastupdateusr", iRowSet.getString("name") == null ? "" : iRowSet.getString("name"));
                }
                break block4;
            }
            if (iRowSet.size() != 2) break block4;
            while (iRowSet.next()) {
                if (index == 1) {
                    resultMap.put("creator", iRowSet.getString("name") == null ? "" : iRowSet.getString("name"));
                    ++index;
                    continue;
                }
                if (index != 2) continue;
                resultMap.put("lastupdateusr", iRowSet.getString("name") == null ? "" : iRowSet.getString("name"));
            }
        }
        return resultMap;
    }

    public static String getpersonNameByUserId(Context ctx, String userId) throws Exception {
        String resultStr = null;
        String l = LocaleUtils.getShortCode((Context)ctx);
        String sql = "select fname_" + l + " name from t_bd_person where fid in (select fpersonid from t_pm_user where fid = ?)";
        Object[] param = new String[]{userId};
        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
        while (iRowSet.next()) {
            resultStr = iRowSet.getString("name");
        }
        return resultStr;
    }

    public static Map<String, String> getUserRootPositionMap(Context ctx, String userId, String permItemId) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        String rootAdminId = null;
        String rootPositionId = null;
        String rootPositionName = null;
        try {
            List<Map> orgList = HROrgChartUtil.getDefaultRootOrgId(ctx, userId, permItemId);
            if (orgList.size() > 0) {
                rootAdminId = (String)orgList.get(0).get("id");
            }
            String l = LocaleUtils.getShortCode((Context)ctx);
            String sql = "select fid,fname_" + l + " positionname from t_org_position where FAdminOrgUnitID = '" + rootAdminId + "' order by FIsRespPosition desc, findex asc";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (iRowSet.size() != 0 && iRowSet.next()) {
                rootPositionId = iRowSet.getString("fid");
                rootPositionName = iRowSet.getString("positionname");
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        resultMap.put("rootPositionId", rootPositionId);
        resultMap.put("rootPositionName", rootPositionName);
        return resultMap;
    }

    public static boolean checkNum(Context ctx, String number, String orgChartSettingId) {
        String sql = null;
        boolean result = false;
        Object[] params = null;
        try {
            if (StringUtils.isEmpty((String)orgChartSettingId)) {
                sql = "select * from t_hr_orgchartsetting where fnumber = ? ";
                params = new Object[]{number};
            } else {
                sql = "select * from t_hr_orgchartsetting where fid <> ? and fnumber = ?";
                params = new Object[]{orgChartSettingId, number};
            }
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
            if (iRowSet.size() > 0) {
                result = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean assembleShowType(String showTypeId) {
        return showTypeId.equals(Admin_ID) || showTypeId.equals(All_ID);
    }

    public static List<String> getUnderLongnumberByLongnumber(Context ctx, String rootLongnumber) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            String sql = "select child.flongnumber from t_org_admin child inner join t_org_admin parent on parent.fid = child.fparentid where parent.flongnumber ='" + rootLongnumber + "'";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                result.add(iRowSet.getString("flongnumber"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void assembleLineWidth(int numberLineWidth, Map<String, Object> modelNode, String number, String tempShow, boolean isWholeLine, boolean isAllowWrap, int maxCount) {
        modelNode.put(number, tempShow);
        modelNode.put("all" + number, tempShow);
        modelNode.put(number + "lineWidth", numberLineWidth);
        if (isWholeLine) {
            if (isAllowWrap) {
                if (tempShow.length() > maxCount * 2) {
                    modelNode.put(number, tempShow.substring(0, maxCount * 2) + "...");
                    modelNode.put("all" + number, tempShow);
                    if (modelNode.get("showTips") == null) {
                        modelNode.put("showTips", tempShow + "\n");
                    } else {
                        String oldTips = modelNode.get("showTips").toString();
                        modelNode.put("showTips", oldTips + tempShow + "\n");
                    }
                } else {
                    modelNode.put(number, tempShow);
                    modelNode.put("all" + number, tempShow);
                    if (modelNode.get("showTips") == null) {
                        modelNode.put("showTips", "\n");
                    }
                }
            } else if (tempShow.length() > maxCount) {
                modelNode.put(number, tempShow.substring(0, maxCount) + "...");
                modelNode.put("all" + number, tempShow);
                if (modelNode.get("showTips") == null) {
                    modelNode.put("showTips", tempShow + "\n");
                } else {
                    String oldTips = modelNode.get("showTips").toString();
                    modelNode.put("showTips", oldTips + tempShow + "\n");
                }
            } else {
                modelNode.put(number, tempShow);
                modelNode.put("all" + number, tempShow);
                if (modelNode.get("showTips") == null) {
                    modelNode.put("showTips", "\n");
                }
            }
        } else if (isAllowWrap) {
            if (tempShow.length() > maxCount * 2) {
                modelNode.put(number, tempShow.substring(0, maxCount * 2) + "...");
                modelNode.put("all" + number, tempShow);
                if (modelNode.get("showTips") == null) {
                    modelNode.put("showTips", "\n" + tempShow + "\n\n");
                } else {
                    String oldTips = modelNode.get("showTips").toString();
                    modelNode.put("showTips", oldTips + tempShow + "\n");
                }
            } else {
                modelNode.put(number, tempShow);
                modelNode.put("all" + number, tempShow);
                if (modelNode.get("showTips") == null) {
                    modelNode.put("showTips", "\n");
                }
            }
        } else if (tempShow.length() > maxCount) {
            modelNode.put(number, tempShow.substring(0, maxCount) + "...");
            modelNode.put("all" + number, tempShow);
            if (modelNode.get("showTips") == null) {
                modelNode.put("showTips", tempShow + "\n");
            } else {
                String oldTips = modelNode.get("showTips").toString();
                modelNode.put("showTips", oldTips + tempShow + "\n");
            }
        } else {
            modelNode.put(number, tempShow);
            modelNode.put("all" + number, tempShow);
            if (modelNode.get("showTips") == null) {
                modelNode.put("showTips", "\n");
            }
        }
    }

    public static Map<String, List<Map<String, String>>> getHierarchyTypeInfo(Context ctx, String orgChartSettingId) {
        HashMap<String, List<Map<String, String>>> hierarchyTypeMap = new HashMap<String, List<Map<String, String>>>();
        SimpleDateFormat dateFormater = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String l = LocaleUtils.getShortCode((Context)ctx);
            String hierarchyTypeSql = "SELECT FTime dayTime,fid,fname_" + l + " name FROM T_HR_DesignHierarchy where FOrgChartSettingId = '" + orgChartSettingId + "' order by fname_" + l + ", ftime desc";
            IRowSet hierarchyTypeRowSet = DbUtil.executeQueryNoTx((Context)ctx, (String)hierarchyTypeSql);
            while (hierarchyTypeRowSet.next()) {
                if (hierarchyTypeMap.containsKey(hierarchyTypeRowSet.getString("name"))) {
                    HashMap<String, String> tempMap = new HashMap<String, String>();
                    tempMap.put("name", dateFormater.format(hierarchyTypeRowSet.getDate("dayTime")));
                    tempMap.put("value", hierarchyTypeRowSet.getString("fid"));
                    ((List)hierarchyTypeMap.get(hierarchyTypeRowSet.getString("name"))).add(tempMap);
                    continue;
                }
                ArrayList list = new ArrayList();
                HashMap<String, String> tempMap = new HashMap<String, String>();
                tempMap.put("name", dateFormater.format(hierarchyTypeRowSet.getDate("dayTime")));
                tempMap.put("value", hierarchyTypeRowSet.getString("fid"));
                list.add(tempMap);
                hierarchyTypeMap.put(hierarchyTypeRowSet.getString("name"), list);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return hierarchyTypeMap;
    }

    public static double round(double d, int len) {
        if (len != 0) {
            BigDecimal b1 = new BigDecimal(d);
            BigDecimal b2 = new BigDecimal(1);
            return b1.divide(b2, len, 4).doubleValue();
        }
        return 0.0;
    }

    public static SimpleDateFormat getDateFormater() {
        return new SimpleDateFormat("yyyy-MM-dd");
    }

    public static Map<String, Map<String, Boolean>> getAdminPersonAssignType(Context ctx, Map<String, String> sorceMap, String datepicker) {
        HashMap<String, Map<String, Boolean>> result = new HashMap<String, Map<String, Boolean>>();
        if (sorceMap.isEmpty()) {
            return result;
        }
        try {
            StringBuffer filterSB = new StringBuffer();
            for (Map.Entry<String, String> entry : sorceMap.entrySet()) {
                filterSB.append("(FPersonID = '" + entry.getValue() + "' and FAdminOrgID = '" + entry.getKey() + "') or ");
            }
            StringBuffer filterStr = filterSB.delete(filterSB.length() - 4, filterSB.length() - 1);
            String sql = "select FPersonID,FAssignType,FAdminOrgID from T_HR_EmpOrgRelation where (" + filterStr + ") and feffdt <= {ts'" + datepicker + "'} and fleffdt >=  {ts'" + datepicker + "'} and FIsLatestInAday = 1";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                HashMap<String, Boolean> tempMap = new HashMap<String, Boolean>();
                tempMap.put(iRowSet.getString("FPersonID"), iRowSet.getBoolean("FAssignType"));
                result.put(iRowSet.getString("FAdminOrgID"), tempMap);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Map<String, Map<String, Boolean>> getPositionPersonAssignType(Context ctx, Map<String, String> sorceMap, String datepicker) {
        HashMap<String, Map<String, Boolean>> result = new HashMap<String, Map<String, Boolean>>();
        if (sorceMap.isEmpty()) {
            return result;
        }
        try {
            StringBuffer filterSB = new StringBuffer();
            for (Map.Entry<String, String> entry : sorceMap.entrySet()) {
                filterSB.append("FPersonID = '" + entry.getValue() + "' and FPositionID = '" + entry.getKey() + "' or ");
            }
            StringBuffer filterStr = filterSB.delete(filterSB.length() - 4, filterSB.length() - 1);
            String sql = "select FPersonID,FAssignType,FPositionID from T_HR_EmpOrgRelation where (" + filterStr + ") and feffdt <= {ts'" + datepicker + "'} and fleffdt >=  {ts'" + datepicker + "'} and FIsLatestInAday = 1";
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (iRowSet.next()) {
                HashMap<String, Boolean> tempMap = new HashMap<String, Boolean>();
                tempMap.put(iRowSet.getString("FPersonID"), iRowSet.getBoolean("FAssignType"));
                result.put(iRowSet.getString("FPositionID"), tempMap);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String checkSql(Context ctx, String sql, String datepicker) {
        String l = LocaleUtils.getShortCode((Context)ctx);
        if (StringUtils.isEmpty((String)sql)) {
            return sql;
        }
        String newSql = sql.toLowerCase().replaceAll("historytime", "{ts'" + datepicker + "'}");
        if (newSql.toLowerCase().contains("_l2")) {
            newSql = newSql.toLowerCase().replaceAll("_l2", "_" + l);
        }
        return newSql;
    }

    public static void checkJava() {
    }

    public static boolean getCouldPermission(Context ctx) {
        boolean couldPermission = false;
        try {
            String sql = "select fkey,fvalue from t_hr_hrinit where fkey='couldPermissionOrgchart'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next() && "true".equals(rs.getString("fvalue"))) {
                return true;
            }
            String couldPermissionSql = "select fid from t_cds_cloudserviceconfig";
            IRowSet couldPermissionRowSet = DbUtil.executeQuery((Context)ctx, (String)couldPermissionSql);
            if (couldPermissionRowSet.size() > 0) {
                couldPermission = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return couldPermission;
    }

    public static List<String> getSystemAllFont() {
        ArrayList<String> fontList = new ArrayList<String>();
        HashSet<String> fontSet = new HashSet<String>();
        Font[] allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        String fontName = null;
        for (int i = 0; i < allFonts.length; ++i) {
            fontName = allFonts[i].getFamily();
            if (fontSet.contains(fontName)) continue;
            fontList.add(fontName);
            fontSet.add(fontName);
        }
        return fontList;
    }

    public static List getListFromJson(Context ctx, String orgChartSettingId, String sourceDate, Map<String, Map> sourceMap, String rootNode) throws EASBizException, BOSException {
        OrgChartSettingInfo orgChartSettingInfo = OrgChartSettingFactory.getLocalInstance(ctx).getOrgChartSettingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)orgChartSettingId)));
        ShowFormatCollection showFormatCollection = orgChartSettingInfo.getShowFormat();
        showFormatCollection.sort("number");
        List<Map> sourceList = HROrgChartUtil.jsonToCardList(sourceDate);
        for (int j = 0; j < sourceList.size(); ++j) {
            Map map = sourceList.get(j);
            for (int i = 0; i < showFormatCollection.size(); ++i) {
                ShowFormatInfo showFormatInfo = showFormatCollection.get(i);
                if (showFormatInfo.getType().equals((Object)FieldTypeEnum.text)) {
                    String context;
                    String number = showFormatInfo.getNumber();
                    ModelCategoryEnum modelCategory = showFormatInfo.getModelCategory();
                    String beforeFormat = showFormatInfo.getFormat();
                    String realNumber = null;
                    String afterFormat = beforeFormat;
                    realNumber = beforeFormat.substring(beforeFormat.indexOf("{") + 1, beforeFormat.indexOf("}"));
                    String string = context = sourceMap.get(realNumber) == null ? "" : sourceMap.get(realNumber).toString();
                    if (!map.containsKey(number)) continue;
                    afterFormat = afterFormat.replace("{" + realNumber + "}", context);
                    map.put(number, afterFormat);
                    map.put("all" + number, afterFormat);
                    continue;
                }
                if (!showFormatInfo.getType().equals((Object)FieldTypeEnum.picture)) continue;
            }
        }
        return sourceList;
    }

    public static Map<String, Map> getCardPosition(String sourceDate) {
        HashMap<String, Map> resultMap = new HashMap<String, Map>();
        List<Map> dataList = HROrgChartUtil.jsonToCardList(sourceDate);
        int count = dataList.size();
        for (int i = 0; i < count; ++i) {
            Map map = dataList.get(i);
            HashMap<String, String> tempMap = new HashMap<String, String>();
            if (!StringUtils.isEmpty(map.get("key") == null ? null : map.get("key").toString()) && !StringUtils.isEmpty(map.get("pos") == null ? null : map.get("pos").toString())) {
                tempMap.put("pos", map.get("pos").toString());
            }
            if (!StringUtils.isEmpty(map.get("key") == null ? null : map.get("key").toString()) && !StringUtils.isEmpty(map.get("points") == null ? null : map.get("points").toString())) {
                tempMap.put("points", map.get("points").toString());
            }
            if (!StringUtils.isEmpty(map.get("key") == null ? null : map.get("key").toString()) && !StringUtils.isEmpty(map.get("parent") == null ? null : map.get("parent").toString())) {
                tempMap.put("parent", map.get("parent").toString());
            }
            resultMap.put(map.get("key").toString(), tempMap);
        }
        return resultMap;
    }

    private static List<Map> jsonToCardList(String sourceDate) {
        Gson gson = new Gson();
        Map map = new HashMap();
        map = (Map)gson.fromJson(sourceDate, map.getClass());
        List nodeDataArray = (List)map.get("nodeDataArray");
        return nodeDataArray;
    }

    public static void assembleCardPosition(List resultList, Map<String, Map> cardPositionMap) {
        if (resultList == null || cardPositionMap == null) {
            return;
        }
        Gson gson = new Gson();
        HashMap toMap = new HashMap();
        ArrayList toList = new ArrayList();
        int count = resultList.size();
        for (int i = 0; i < count; ++i) {
            Map map = (Map)resultList.get(i);
            map.put("hasChild", false);
            map.put("isShowParent", false);
            if (!cardPositionMap.containsKey(map.get("key"))) continue;
            if (cardPositionMap.get(map.get("key")).get("pos") != null) {
                map.put("pos", gson.fromJson(cardPositionMap.get(map.get("key")).get("pos").toString(), toMap.getClass()));
            }
            if (cardPositionMap.get(map.get("key")).get("points") == null) continue;
            map.put("points", gson.fromJson(cardPositionMap.get(map.get("key")).get("points").toString(), toList.getClass()));
        }
    }

    public static String getStrFromSet(Set<String> set) {
        StringBuffer sb = new StringBuffer();
        if (set == null || set.size() == 0) {
            return "('')";
        }
        if (set.size() == 1) {
            sb.append("('");
            sb.append(set.iterator().next());
            sb.append("')");
        } else {
            StringBuffer tempSb = new StringBuffer();
            tempSb.append("(");
            for (String str : set) {
                tempSb.append("'");
                tempSb.append(str);
                tempSb.append("',");
            }
            sb = tempSb.deleteCharAt(tempSb.length() - 1);
            sb.append(")");
        }
        return sb.toString();
    }

    public static void isBOSUuid(String id) throws BOSException {
        try {
            BOSUuid.read((String)id);
        }
        catch (UuidException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
    }
}

