/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.OsfUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.CommonPageHelper;
import com.kingdee.shr.perfweb.utils.CommonSQLUtil;
import com.kingdee.shr.perfweb.utils.ICustomDataProcessor;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTeamGoalsScheduleService
implements IHRMsfService,
ICustomDataProcessor {
    private static Logger logger = LoggerFactory.getLogger((String)GetTeamGoalsScheduleService.class.getName());

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        Map<String, Object> result = new HashMap<String, Object>();
        OsfUtils.requirePagingParams(ctx, map, result);
        if (result != null && result.size() > 0) {
            return result;
        }
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        String baseSQL = this.getBaseSQL(ctx, personId, map);
        String baseOrder = "c.FPStartDate desc, c.FPEndDate desc, a.FHandlerTime desc, d.FID, c.FID, a.FID ";
        int rows = (Integer)map.get("rows");
        int page = (Integer)map.get("page");
        try {
            result = CommonPageHelper.getPageCallbackData(ctx, baseSQL, rows, page, baseOrder, this, null);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return result;
    }

    @Override
    public int getTotalCount(Context ctx, String sql) throws WfBizException {
        int totalCount = 0;
        try {
            String countSql = "select count(1) from (" + sql + ") as A";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
            totalCount = CommonSQLUtil.getTotalCount(rowSet);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return totalCount;
    }

    @Override
    public List<?> formatResultData(Context ctx, IRowSet rs, String type) throws WfBizException {
        ArrayList list = new ArrayList();
        try {
            if (rs != null && rs.size() > 0) {
                HashMap<String, String> personsMap = new HashMap<String, String>();
                while (rs.next()) {
                    HashMap<String, String> item = new HashMap<String, String>();
                    item.put("evaObjID", rs.getString("FEvaObjID"));
                    item.put("name", rs.getString("FName"));
                    String number = rs.getString("FNumber");
                    item.put("number", number);
                    item.put("perfPlanName", rs.getString("FPerfPlanName"));
                    item.put("positionName", rs.getString("FPositionName"));
                    item.put("belongOrgName", rs.getString("FBelongOrgName"));
                    item.put("periodDate", rs.getString("FPeriodName"));
                    item.put("periodId", rs.getString("FPeriodID"));
                    item.put("belongOrgId", rs.getString("FBelongOrgId"));
                    item.put("perfPlanId", rs.getString("FPerfPlan"));
                    String personId = rs.getString("FPerson");
                    item.put("personId", personId);
                    item.put("photo", null);
                    list.add(item);
                    personsMap.put(personId, number);
                }
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
            throw new WfBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EXECUTESQLERR, ctx));
        }
        return list;
    }

    private String getBaseSQL(Context ctx, String person, Map map) {
        String name = (String)map.get("name");
        String positionName = (String)map.get("positionName");
        String evaObjIDs = (String)map.get("evaObjIDs");
        String belongOrgId = (String)map.get("belongOrgId");
        String perfPlanId = (String)map.get("perfPlanId");
        String periodId = (String)map.get("periodId");
        int status = (Integer)map.get("status");
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        StringBuffer sb = new StringBuffer("SELECT a.FName" + mlFlag + " AS FName, a.FNumber, f.FName" + mlFlag + " AS FPositionName,d.FName" + mlFlag + " AS FPerfPlanName,");
        sb.append("replace(tochar(c.FPStartDate,'yyyy-mm-dd'),'-','.')||'-'||replace(tochar(c.FPEndDate,'yyyy-mm-dd'),'-','.') FPeriodDate,").append(" a.FID FEvaObjID, b.FID, a.FPeriodID, c.FPerfPlan, a.FPersonId AS FPerson, d.FBelongOrgId, d.FBelongOrgName, c.FName FPeriodName").append(" from T_EVA_PerfEvaObject a ").append(" left join T_EVA_PerfGoalsObject b ").append(" on a.FID = b.FPerfEvaObjectID ").append(" left join T_EVA_PerfPeriod c ").append(" on a.FPeriodID = c.FID ").append(" left join T_EVA_PerfPlan d ").append(" on c.FPerfPlan = d.FID ").append(" left join T_EVA_PerfFile e ").append(" on a.FPerfFileID = e.FID ").append(" left join T_ORG_Position f ").append(" on e.FPositionID = f.FID ").append(" where b.FPerson = '" + person + "'").append(" and a.FUnitGoalsStatus = ").append(1).append(" and a.FPersonalGoalStatus = ").append(3);
        if (0 == status) {
            sb.append(" and a.FWorkFlowStatus = ").append(0);
        } else {
            sb.append(" and a.FWorkFlowStatus != ").append(0);
        }
        if (!StringUtils.isEmpty((String)name) && name.equals(positionName)) {
            sb.append(" and (a.FName" + mlFlag + " like '%" + name + "%'").append(" or f.FName" + mlFlag + " like '%" + positionName + "%') ");
        } else {
            if (!StringUtils.isEmpty((String)name)) {
                sb.append(" and a.FName like '%" + name + "%'");
            }
            if (!StringUtils.isEmpty((String)positionName)) {
                sb.append(" and f.FName" + mlFlag + " like '%" + positionName + "%'");
            }
        }
        if (!StringUtils.isEmpty((String)evaObjIDs)) {
            String[] ids = evaObjIDs.split(",");
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < ids.length; ++i) {
                idSet.add(ids[i]);
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("a.FID", idSet, CompareType.INCLUDE));
            sb.append(" and " + filter.toSql());
        }
        if (!StringUtils.isEmpty((String)belongOrgId)) {
            sb.append(" and d.FBelongOrgId in (SELECT RANGE.FORGID  FROM T_PM_ORGRANGE RANGE").append(" LEFT OUTER JOIN T_ORG_ADMIN a").append(" ON RANGE.FORGID = a.FID  WHERE  RANGE.FTYPE = 20 ").append("AND a.FISSTARTSHR = 1 ").append(" AND RANGE.FUSERID = '" + HRFilterUtils.getCurrentUserId((Context)ctx) + "') ");
            try {
                AdminOrgUnitCollection adminOrgColl = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(" where id='" + belongOrgId + "'");
                if (adminOrgColl != null && adminOrgColl.size() > 0) {
                    String longNumber = adminOrgColl.get(0).getLongNumber();
                    sb.append(" and d.FBelongOrgId  in (select fid from T_ORG_Admin where FLongNumber like '" + longNumber + "!%')");
                }
            }
            catch (BOSException e) {
                logger.error("BOSException: ", (Throwable)e);
            }
        }
        if (!StringUtils.isEmpty((String)perfPlanId)) {
            sb.append(" and c.FPerfPlan = '" + perfPlanId + "' ");
        }
        if (!StringUtils.isEmpty((String)periodId)) {
            String[] periodIds = periodId.split(",");
            HashSet<String> periods = new HashSet<String>();
            periods.addAll(Arrays.asList(periodIds));
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("a.FPeriodID", periods, CompareType.INCLUDE));
            sb.append(" and " + filterInfo.toSql());
        }
        return sb.toString();
    }
}

