/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.portal.common.util.DateUtil;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.util.OsfUtils;
import com.kingdee.shr.perfweb.utils.PerfDateUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetTeamGoalsService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)GetTeamGoalsService.class.getName());

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        OsfUtils.requirePagingParams(ctx, map, result);
        if (result != null && result.size() > 0) {
            return result;
        }
        EntityViewInfo evi = this.getEntityView(ctx, map);
        IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
        int totalCount = iPerfEvaObject.getCount(evi);
        int rows = (Integer)map.get("rows");
        int page = (Integer)map.get("page");
        int length = rows;
        if (page * rows > totalCount) {
            length = totalCount - (page - 1) * rows;
        }
        List list = iPerfEvaObject.getPagingList(evi, (page - 1) * rows, length);
        HashSet<String> perfPlanIds = new HashSet<String>();
        ArrayList data = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            PerfEvaObjectInfo info = (PerfEvaObjectInfo)list.get(i);
            String id = info.getId().toString();
            resultMap.put("evaObjID", id);
            resultMap.put("name", info.getName());
            resultMap.put("number", info.getNumber());
            if (info.getPerfFile() != null && info.getPerfFile().getPosition() != null) {
                resultMap.put("positionName", info.getPerfFile().getPosition().getName());
            }
            if (info.getAdminOrgUnit() != null) {
                resultMap.put("belongOrgId", (String)info.getAdminOrgUnit().getId());
                resultMap.put("belongOrgName", info.getAdminOrgUnit().getName());
            }
            if (info.getPeriod() != null) {
                resultMap.put("periodId", info.getPeriod().getId().toString());
                resultMap.put("evaPeriodStatus", info.getPeriod().getEvaPeriodStatus().getName());
                Date pStartDate = info.getPeriod().getPStartDate();
                Date pEndDate = info.getPeriod().getPEndDate();
                String periodDate = DateUtil.dateToStr((Date)pStartDate, (String)"yyyy-MM-dd") + "-" + DateUtil.dateToStr((Date)pEndDate, (String)"yyyy-MM-dd");
                resultMap.put("periodDate", periodDate);
                String planId = info.getPeriod().getPerfPlan().getId().toString();
                if (!StringUtils.isEmpty((String)planId)) {
                    resultMap.put("perfPlanId", info.getPeriod().getPerfPlan().getId().toString());
                    perfPlanIds.add(planId);
                }
            }
            if (info.getPerson() != null) {
                resultMap.put("personId", info.getPerson().getId().toString());
            }
            resultMap.put("photo", null);
            data.add(resultMap);
        }
        if (perfPlanIds.size() > 0) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", perfPlanIds, CompareType.INCLUDE));
            evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            PerfPlanCollection perfPlanCollection = PerfPlanFactory.getLocalInstance(ctx).getPerfPlanCollection(evi);
            HashMap<String, String> perfPlanMap = new HashMap<String, String>();
            if (perfPlanCollection != null && perfPlanCollection.size() > 0) {
                int i;
                for (i = 0; i < perfPlanCollection.size(); ++i) {
                    PerfPlanInfo perfPlanInfo = perfPlanCollection.get(i);
                    perfPlanMap.put(perfPlanInfo.getId().toString(), perfPlanInfo.getName());
                }
                for (i = 0; i < list.size(); ++i) {
                    PerfEvaObjectInfo info = (PerfEvaObjectInfo)list.get(i);
                    Map resultMap = (Map)data.get(i);
                    String planId = info.getPeriod().getPerfPlan().getId().toString();
                    if (info.getPeriod() == null || StringUtils.isEmpty((String)planId)) continue;
                    String perfPlanName = (String)perfPlanMap.get(planId);
                    resultMap.put("perfPlanName", perfPlanName);
                }
            }
        }
        int pages = totalCount % rows == 0 ? totalCount / rows : totalCount / rows + 1;
        result.put("pages", pages);
        result.put("records", totalCount);
        result.put("rows", data);
        return result;
    }

    private EntityViewInfo getEntityView(Context ctx, Map map) throws BOSException {
        AdminOrgUnitCollection adminOrgUnitCollection;
        String permItemId;
        String name = (String)map.get("name");
        String positionName = (String)map.get("positionName");
        String evaObjIDs = (String)map.get("evaObjIDs");
        String belongOrgId = (String)map.get("belongOrgId");
        String perfPlanId = (String)map.get("perfPlanId");
        String periodId = (String)map.get("periodId");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isOrg", (Object)0, CompareType.EQUALS));
        String string = permItemId = map.get("permItemId") != null ? (String)map.get("permItemId") : "";
        if (!StringUtils.isEmpty((String)permItemId)) {
            FilterInfo deFaultFilter = GetTeamGoalsService.getResposeFilter(ctx, permItemId);
            filterInfo.mergeFilter(deFaultFilter, "AND");
        }
        if (!StringUtils.isEmpty((String)evaObjIDs)) {
            String[] evaObjIds = evaObjIDs.split(",");
            HashSet<String> evaObjs = new HashSet<String>();
            evaObjs.addAll(Arrays.asList(evaObjIds));
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)evaObjIDs, CompareType.INCLUDE));
        }
        if (!StringUtils.isEmpty((String)belongOrgId) && (adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection("where id='" + belongOrgId + "'")) != null && adminOrgUnitCollection.size() > 0) {
            AdminOrgUnitInfo adminOrgUnitInfo = adminOrgUnitCollection.get(0);
            filterInfo.getFilterItems().add(new FilterItemInfo("adminOrgUnit.longNumber", (Object)(adminOrgUnitInfo.getLongNumber() + "%"), CompareType.LIKE));
        }
        if (!StringUtils.isEmpty((String)perfPlanId)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("period.perfplan.id", (Object)perfPlanId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)periodId)) {
            String[] periodIds = periodId.split(",");
            HashSet<String> periods = new HashSet<String>();
            periods.addAll(Arrays.asList(periodIds));
            filterInfo.getFilterItems().add(new FilterItemInfo("period.id", periods, CompareType.INCLUDE));
        }
        if (!StringUtils.isEmpty((String)positionName) && !StringUtils.isEmpty((String)name)) {
            FilterInfo fastFilter = new FilterInfo();
            fastFilter.getFilterItems().add(new FilterItemInfo("perfFile.position.name", (Object)("%" + positionName + "%"), CompareType.LIKE));
            fastFilter.getFilterItems().add(new FilterItemInfo("name", (Object)("%" + name + "%"), CompareType.LIKE));
            fastFilter.setMaskString("#0 OR #1");
            filterInfo.mergeFilter(fastFilter, "AND");
        }
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        try {
            sorterItemCollection.getSorter().decode("order by period.pStartDate desc, period.pEndDate desc, id");
        }
        catch (ParserException e) {
            logger.error("my team goals list sortItems error", (Throwable)e);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("perfFile.position.name"));
        sic.add(new SelectorItemInfo("period.pStartDate"));
        sic.add(new SelectorItemInfo("period.pEndDate"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("period.perfplan.id"));
        sic.add(new SelectorItemInfo("period.id"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("period.evaPeriodStatus"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(sic);
        evi.setSorter(sorterItemCollection);
        return evi;
    }

    private static FilterInfo getResposeFilter(Context ctx, String permItemId) {
        FilterInfo deFaultFilter = new FilterInfo();
        String departmentAdminRangeSQL = SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)HRFilterUtils.getCurrentUserId((Context)ctx), (String)permItemId);
        deFaultFilter.getFilterItems().add(new FilterItemInfo("perffile.adminOrgUnit", (Object)departmentAdminRangeSQL, CompareType.INNER));
        deFaultFilter.getFilterItems().add(new FilterItemInfo("personalGoalStatus", (Object)"3", CompareType.EQUALS));
        return deFaultFilter;
    }

    private static AdminOrgUnitCollection getResponseAdminCollection(Context ctx, Set<String> positionSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("responPosition", positionSet, CompareType.INCLUDE));
        view.setFilter(filter);
        return AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
    }

    private static EmpPosOrgRelationCollection getEmpOrgRelCollection(Context ctx, String person) throws BOSException {
        Date now = new Date();
        String currentDate = PerfDateUtils.formatDate(now, "yyyy-MM-dd");
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("position.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person", (Object)person, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)currentDate, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)currentDate, CompareType.GREATER_EQUALS));
        view.setFilter(filter);
        return EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
    }
}

