/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.metas.AssignFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.AchivementDataAuditorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.AchivementDataEntriorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.IAchivementDataAuditor;
import com.kingdee.shr.perfweb.app.base.evalplan.IAchivementDataEntrior;
import com.kingdee.shr.perfweb.app.base.evalplan.IGoalsMessageReceiver;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaluAdminResponsorInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfOrgEvaSumResponsorCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfOrgEvaSumResponsorFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfOrgEvaSumResponsorInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PortalMesTypeEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.common.YesOrNotEnum;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.IMultiPerfPeriod;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.portal.bean.EvaObjBean;
import com.kingdee.shr.perfweb.portal.bean.EvaPerfPeriodBean;
import com.kingdee.shr.perfweb.portal.bean.TeamPersonalTargetBean;
import com.kingdee.shr.perfweb.portal.bean.TeamTargetCommentBean;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PerfPortalTodoUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PerfDateUtils;
import com.kingdee.shr.perfweb.utils.PerfInvolveScoreUtils;
import com.kingdee.shr.perfweb.utils.PerfwebStrUtils;
import com.kingdee.shr.perfweb.utils.PhotoUtils;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import shaded.org.apache.parquet.Strings;

public class PerfPortalUtils {
    public static final String MYEVALUATION = "myEvaluation";
    public static final String MYGOALS = "myGoals";
    public static final String GROUPGOALS = "groupGoals";
    public static final String MYHISTORY = "myHistory";
    public static final String GROUPHISTORY = "groupHistory";
    public static final String MYTEAMGOAL = "myTeamGoals";
    public static final String PERFSUMINTERVIEW = "perfSumInterview";
    public static final String PROCESSEDSCORES = "processedScores";
    public static final String GOALSFILLED = "goalsFilled";
    public static final String EVARESULTSTAT = "evaResultStat";
    public static final String ACHIVEMENTMANAGE = "achivementManage";
    public static final String MYACHIVEMENTENTRY = "myAchivementEntry";
    public static final String TEAMEVAL = "1";
    public static final int defaultRows = 8;
    public static final String TEAMPERSONALTARGET = "teamPersonalTarget";
    public static final String TEAMPERSONALTARGETEVA = "teamPersonalTargetEva";
    public static final String ASSESSMENT360 = "assessment360";
    public static final String MYEVATARGETFILL = "myEvaTargetFill";
    public static final String MYEVASELF = "myEvaSelf";
    public static final String MYACHIEVEMENTINPUT = "myAchievementInputTask";
    public static final String OTHERSTODOCOUNT = "othersTodoCount";
    public static final String OTHERSPERFTODOCOUNT = "othersPerfTodoCount";
    public static final String MY_EVA_SELF4ORG = "myEvaSelf4Org";
    public static final String TEAM_PERSONAL_TARGET_EVA4ORG = "teamPersonalTargetEva4Org";
    public static final String TARGET_EVA_DONE4ORG = "targetEvaDone4Org";
    public static final String ORG_HAD_FILLED = "orgHadFilled";
    public static final String ORG_HAD_TRANSMITED = "orgHadTransmited";
    public static final String ORG_TEAM_TARGET = "orgTeamTarget";
    public static final String ORG_TARGET_FILL = "myEvaTargetFill4Org";
    public static final String ORG_TARGET_TRANSMIT = "teamPersonalTarget4Org";
    public static final String ORG_OTHERSPERFTODOCOUNT = "orgOthersPerfTodoCount";
    public static final String MY_ACHIEVEMENT_INPUT_TASK_4ORG = "myAchievementInputTask4Org";
    public static final String ACHIVEMENT_DATA_TOINPUT_4ORG = "achivementDataToInput4Org";
    public static final String ACHIVEMENT_DATA_TOREVIEW_40RG = "achivementDataToReview40rg";
    public static final String MY_ORG_ACHIVEMENT_ENTRY = "myORGAchivementEntry";
    public static final String ACHIVEMENT_DATA_TO_INPUT = "achivementDataToInput";
    public static final String ACHIVEMENT_DATA_TO_REVIEW = "achivementDataToReview";
    public static final String ORG_ASSESSMENT360 = "orgAssessment360";
    public static final String MY_HISTORY_TARGET_4ORG = "myHistoryTarget4Org";
    public static final String MYTARGETMAP = "myTargetMap";
    public static final String ORGGOALCONTENT = "orgGoalContent";
    public static final String GROUPHISTORY4ORGCONTENT = "groupHistory4OrgContent";
    public static final String ORGTARGETMAP = "groupPerformMapContent";
    public static final String MYPERFTASK = "myPerfTask";
    public static final String OTHERPERFTASK = "otherPerfTask";
    public static final String myInchargeteamGoal = "myInchargeteamGoal";
    public static final String myInchargeteamHistory = "myInchargeteamHistory";
    public static final String myInchargeInteview = "myInchargeInteview";
    public static final HashMap<String, String> OTHERTODO = new HashMap();
    public static String invokeClass = "com.kingdee.shr.perfweb.util.PerfPortalUtils";
    private static Logger logger;

    public static String getTeamTargetCommentList(HttpServletRequest request, HttpServletResponse response, Context ctx) {
        try {
            int i;
            String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
            String personalScoreSearchIdList = request.getParameter("personalScoreSearchIdList");
            String isOrg = request.getParameter("isOrg");
            String orgVal = "0";
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)isOrg)) {
                orgVal = isOrg;
            }
            Set<Object> periodSet = new HashSet();
            String periodId = request.getParameter("period");
            String isTeamEvalu = request.getParameter("isTeamEvalu");
            String isBatchView = request.getParameter("isBatchView");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)isBatchView) && !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)periodId)) {
                String[] periodArr = periodId.split(",");
                periodSet = new HashSet<String>(Arrays.asList(periodArr));
            } else if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)isTeamEvalu) || !isTeamEvalu.equals(TEAMEVAL) || !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)periodId)) {
                periodSet = PerfPortalUtils.getTeamEvaPeriodSet(ctx, personId, orgVal, null);
            }
            if (periodSet.size() < 1) {
                return "";
            }
            String evaObjName = request.getParameter("evaObjName");
            String periodSb = "(" + PerfwebStrUtils.convertListToString(periodSet.toArray()) + ")";
            StringBuilder gradeTaskNodeConditionSb = new StringBuilder(" WHERE FNodeHandlerID='").append(personId).append("' AND FIsEffective='").append(TEAMEVAL).append("' AND FScoreStatus in ('").append(TEAMEVAL).append("','").append("5").append("')").append(" AND t.FIsSelf=").append(0).append(" and t.FPeriodID in").append(periodSb).append(" and o.FIsOrg=").append(orgVal);
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)evaObjName)) {
                StringBuilder evaObjBuilder = new StringBuilder("(''");
                IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
                PerfEvaObjectCollection evaObjColl = iPerfEvaObject.getPerfEvaObjectCollection(" where name like '%" + evaObjName + "%'");
                if (evaObjColl != null && evaObjColl.size() > 0) {
                    for (i = 0; i < evaObjColl.size(); ++i) {
                        evaObjBuilder.append(",'").append(evaObjColl.get(i).getId().toString()).append("'");
                    }
                }
                evaObjBuilder.append(")");
                gradeTaskNodeConditionSb.append(" and t.FEvaObjID in ").append((CharSequence)evaObjBuilder);
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)personalScoreSearchIdList)) {
                String decode = URLDecoder.decode(personalScoreSearchIdList);
                String[] split = decode.split(",");
                StringBuilder sb = new StringBuilder(" ");
                sb.append(" (");
                for (i = 0; i < split.length; ++i) {
                    sb.append("'").append(split[i]).append("'").append(",");
                }
                sb.deleteCharAt(sb.length() - 1);
                sb.append(") ");
                gradeTaskNodeConditionSb.append(" and t.FID in ").append((CharSequence)sb);
            }
            int rows = 8;
            String reqRows = request.getParameter("rows");
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqRows) && !reqRows.equals("null")) {
                rows = Integer.parseInt(request.getParameter("rows"));
            }
            return PerfPortalUtils.assembleTeamTargetCommentData(ctx, periodSet, rows, gradeTaskNodeConditionSb.toString(), request, response);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static void sortPeriodList(List<Map<String, String>> periodList) {
        Collections.sort(periodList, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy.MM.dd");
                SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd");
                String startDate1 = "";
                String endDate1 = "";
                String startDate2 = "";
                String endDate2 = "";
                try {
                    startDate1 = sdf3.format(sdf2.parse(o1.get("startDate")));
                    endDate1 = sdf3.format(sdf2.parse(o1.get("endDate")));
                    startDate2 = sdf3.format(sdf2.parse(o2.get("startDate")));
                    endDate2 = sdf3.format(sdf2.parse(o2.get("endDate")));
                }
                catch (ParseException e) {
                    logger.error("ParseException: ", (Throwable)e);
                }
                if (PerfDateUtils.compareStrDate(startDate1, startDate2) != 0) {
                    return PerfDateUtils.compareStrDate(startDate1, startDate2);
                }
                return PerfDateUtils.compareStrDate(endDate1, endDate2);
            }
        });
    }

    public static int getTeamTargetCommentCount(Context ctx, boolean isOrg) {
        return PerfPortalUtils.getTeamTargetCommentCount(ctx, null, isOrg);
    }

    public static int getTeamTargetCommentCount(Context ctx, String personId, boolean isOrg) {
        int dataCount = 0;
        try {
            if (personId == null) {
                personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
            }
            StringBuffer selectBuf = new StringBuffer("SELECT COUNT(1) AS dataCount FROM T_EVA_GradeTaskNodeInst t INNER JOIN T_EVA_PerfevaObject o ON ");
            selectBuf.append(" t.FEvaobjId=o.FID ").append(" WHERE t.FNodeHandlerID='").append(personId).append("'").append(" AND t.FIsEffective='").append(TEAMEVAL).append("'").append(" AND t.FScoreStatus not in ('").append("2").append("','").append("3").append("','").append("4").append("') ").append(" AND t.FIsSelf=").append(0);
            selectBuf.append(OrgAssessmentUtils.getPortalOrgFilterStr(null, PortalMesTypeEnum.personalEva, isOrg));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuf.toString());
            if (null != rowSet && rowSet.next()) {
                dataCount = rowSet.getInt("dataCount");
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return dataCount;
    }

    public static String assembleTeamTargetCommentData(Context ctx, Set<String> periodSet, int rows, String gradeTaskNodeCondition, HttpServletRequest request, HttpServletResponse response) throws BOSException, IOException {
        TeamTargetCommentBean teamBean = new TeamTargetCommentBean();
        int totalCount = 0;
        int totalPage = 0;
        String evaObjId = request.getParameter("evaObj");
        PerfEvaObjectInfo evaObjInfo = null;
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)evaObjId)) {
            evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObjId);
        }
        LinkedList<EvaPerfPeriodBean> evaPerfPeriodBeanList = new LinkedList<EvaPerfPeriodBean>();
        LinkedList<Map<String, String>> periodList = new LinkedList<Map<String, String>>();
        Iterator<String> iterator = periodSet.iterator();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", periodSet, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("id");
        selector.add("perfPlan.id");
        selector.add("perfPlan.name");
        selector.add("pStartDate");
        selector.add("pEndDate");
        viewInfo.setFilter(filter);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.add(new SorterItemInfo("id"));
        viewInfo.setSorter(sorterItemCollection);
        PerfPeriodCollection periodColl = PerfPeriodFactory.getLocalInstance(ctx).getPerfPeriodCollection(viewInfo);
        int periodSize = periodColl.size();
        HashMap<String, PerfPlanInfo> periodPlanMap = new HashMap<String, PerfPlanInfo>(16);
        for (int i = 0; i < periodSize; ++i) {
            periodPlanMap.put(periodColl.get(i).getId().toString(), periodColl.get(i).getPerfPlan());
        }
        for (int k = 0; k < periodSize; ++k) {
            PerfPlanInfo perfPlanInfo;
            PerfPeriodInfo periodInfo = periodColl.get(k);
            HashMap<String, String> periodMap = new HashMap<String, String>();
            if (periodInfo.getId() == null) continue;
            periodMap.put("periodId", periodInfo.getId().toString());
            if (null != periodInfo.getPStartDate()) {
                periodMap.put("startDate", sdf.format(periodInfo.getPStartDate()));
            }
            if (null != periodInfo.getPEndDate()) {
                periodMap.put("endDate", sdf.format(periodInfo.getPEndDate()));
            }
            if (null != periodInfo.getPerfPlan().getId() && null != (perfPlanInfo = (PerfPlanInfo)periodPlanMap.get(periodInfo.getId().toString())).getId()) {
                periodMap.put("planName", perfPlanInfo.getName());
                periodMap.put("planId", perfPlanInfo.getId().toString());
            }
            if (null != evaObjInfo && evaObjInfo.getPeriod().getId().toString().equals(periodInfo.getId().toString())) {
                periodList.addFirst(periodMap);
                continue;
            }
            periodList.add(periodMap);
        }
        Map firstPeriodMap = (Map)periodList.get(0);
        periodList.remove(0);
        periodList.addFirst(firstPeriodMap);
        totalPage = PerfPortalUtils.calcPageCount(totalCount += PerfPortalUtils.assembleEvaPerfPeriodBeanListData(ctx, rows, gradeTaskNodeCondition, periodList, evaPerfPeriodBeanList, request, response), rows);
        teamBean.setTotalCount(totalCount);
        teamBean.setTotalPage(totalPage);
        teamBean.setEvaPerfPeriodBeanList(evaPerfPeriodBeanList);
        Gson gson = new Gson();
        String json = gson.toJson((Object)teamBean);
        return json;
    }

    public static String assembleTeamTargetPeriod(Context ctx, Set<String> periodSet) throws BOSException, IOException {
        TeamTargetCommentBean teamBean = new TeamTargetCommentBean();
        LinkedList<Map<String, String>> periodList = new LinkedList<Map<String, String>>();
        Iterator<String> iterator = periodSet.iterator();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", periodSet, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add("id");
        selector.add("perfPlan");
        selector.add("pStartDate");
        selector.add("pEndDate");
        viewInfo.setFilter(filter);
        PerfPeriodCollection periodColl = PerfPeriodFactory.getLocalInstance(ctx).getPerfPeriodCollection(viewInfo);
        int periodSize = periodColl.size();
        HashSet<String> planIdSet = new HashSet<String>(16);
        HashMap<String, String> periodPlanMap = new HashMap<String, String>(16);
        for (int i = 0; i < periodSize; ++i) {
            planIdSet.add(periodColl.get(i).getPerfPlan().getId().toString());
            periodPlanMap.put(periodColl.get(i).getId().toString(), periodColl.get(i).getPerfPlan().getId().toString());
        }
        FilterInfo planFilter = new FilterInfo();
        planFilter.getFilterItems().add(new FilterItemInfo("id", planIdSet, CompareType.INCLUDE));
        EntityViewInfo planViewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add("id");
        sic.add("name");
        planViewInfo.setFilter(planFilter);
        PerfPlanCollection planColl = PerfPlanFactory.getLocalInstance(ctx).getPerfPlanCollection(planViewInfo);
        int planSize = planColl.size();
        HashMap<String, PerfPlanInfo> planMap = new HashMap<String, PerfPlanInfo>(16);
        for (int j = 0; j < planSize; ++j) {
            planMap.put(planColl.get(j).getId().toString(), planColl.get(j));
        }
        for (int k = 0; k < periodSize; ++k) {
            PerfPlanInfo perfPlanInfo;
            PerfPeriodInfo periodInfo = periodColl.get(k);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (periodInfo.getId() == null) continue;
            hashMap.put("periodId", periodInfo.getId().toString());
            if (null != periodInfo.getPStartDate()) {
                hashMap.put("startDate", sdf.format(periodInfo.getPStartDate()));
            }
            if (null != periodInfo.getPEndDate()) {
                hashMap.put("endDate", sdf.format(periodInfo.getPEndDate()));
            }
            if (null != periodInfo.getPerfPlan().getId() && null != (perfPlanInfo = (PerfPlanInfo)planMap.get(periodPlanMap.get(periodInfo.getId().toString()))).getId()) {
                hashMap.put("planName", perfPlanInfo.getName());
                hashMap.put("planId", perfPlanInfo.getId().toString());
            }
            periodList.add(hashMap);
        }
        LinkedList<EvaPerfPeriodBean> evaPerfPeriodBeanList = new LinkedList<EvaPerfPeriodBean>();
        if (!CollectionUtils.isEmpty(periodList)) {
            PerfPortalUtils.sortPeriodListDesc(ctx, periodList);
        }
        for (Map map : periodList) {
            EvaPerfPeriodBean bean = new EvaPerfPeriodBean();
            bean.setPeriodId((String)map.get("periodId"));
            bean.setStartDate((String)map.get("startDate"));
            bean.setEndDate((String)map.get("endDate"));
            bean.setPlanName((String)map.get("planName"));
            bean.setPlanId((String)map.get("planId"));
            evaPerfPeriodBeanList.add(bean);
        }
        teamBean.setEvaPerfPeriodBeanList(evaPerfPeriodBeanList);
        Gson gson = new Gson();
        String json = gson.toJson((Object)teamBean);
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int assembleEvaPerfPeriodBeanListData(Context ctx, Set<String> periodSet, int rows, String gradeTaskNodeCondition, Map<String, String> periodMap, LinkedList<EvaPerfPeriodBean> evaPerfPeriodBeanList, HttpServletRequest request, HttpServletResponse response) throws BOSException {
        int evaCountPerPeriod = 0;
        EvaPerfPeriodBean evaPerfPeriodBean = new EvaPerfPeriodBean();
        LinkedList<EvaObjBean> evaObjBeanList = new LinkedList<EvaObjBean>();
        StringBuffer evaCountPerPeriodSQL = new StringBuffer("SELECT COUNT(1) FROM T_EVA_GradeTaskNodeInst t INNER JOIN T_EVA_PerfevaObject o ON t.FEvaobjId=o.FID ").append(gradeTaskNodeCondition);
        if (!CollectionUtils.isEmpty(periodMap)) {
            evaCountPerPeriodSQL.append(" and t.FPeriodID='").append(periodMap.get("periodId")).append("'");
        }
        IRowSet evaCountPerPeriodSet = DbUtil.executeQuery((Context)ctx, (String)evaCountPerPeriodSQL.toString());
        try {
            if (evaCountPerPeriodSet != null && evaCountPerPeriodSet.next() && (evaCountPerPeriod = evaCountPerPeriodSet.getInt(1)) == 0) {
                return 0;
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        int page = 1;
        String reqPage = request.getParameter("page");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqPage) && !reqPage.equals("null")) {
            page = Integer.valueOf(request.getParameter("page"));
        }
        int start = (page - 1) * rows;
        String evaObjId = request.getParameter("evaObj");
        String nodeHandlerId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        Connection conn = null;
        IRowSet taskNodeSet = null;
        try {
            String sql = null;
            int replaceRows = rows;
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)evaObjId) && page == 1) {
                replaceRows = rows - 1;
                StringBuffer selectSQL = new StringBuffer();
                selectSQL.append(" SELECT FID,FWfLevel,FEvaObjID,FNodeSumScore,FNodeGrade,FCreateTime,FWfNodeID from T_EVA_GradeTaskNodeInst g ").append(" WHERE FEvaObjID='").append(evaObjId).append("' AND FNodeHandlerID='").append(nodeHandlerId).append("' and FIsEffective='1' and FScoreStatus in ('1','5') and g.FIsSelf=0");
                if (!CollectionUtils.isEmpty(periodMap)) {
                    selectSQL.append(" and g.FPeriodID='").append(periodMap.get("periodId")).append("'");
                }
                selectSQL.append("order by FWfLevel desc");
                taskNodeSet = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
                PerfPortalUtils.assembleEvaObjBean(ctx, taskNodeSet, evaObjBeanList, request, response);
                selectSQL = new StringBuffer("SELECT FID,FWfLevel,FEvaObjID,FNodeSumScore,FNodeGrade,FCreateTime,FWfNodeID from T_EVA_GradeTaskNodeInst t").append(gradeTaskNodeCondition);
                if (!CollectionUtils.isEmpty(periodMap)) {
                    selectSQL.append(" and t.FPeriodID='").append(periodMap.get("periodId")).append("'");
                }
                selectSQL.append(" and FEvaObjID not in ('").append(evaObjId).append("') order by FCreateTime desc,FWfLevel desc");
                selectSQL = new StringBuffer(selectSQL.toString().replaceFirst("SELECT", "SELECT TOP " + replaceRows));
                taskNodeSet = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
                PerfPortalUtils.assembleEvaObjBean(ctx, taskNodeSet, evaObjBeanList, request, response);
            } else {
                StringBuffer selectSQL = new StringBuffer("SELECT FID,FWfLevel,FEvaObjID,FNodeSumScore,FNodeGrade,FCreateTime,FWfNodeID from T_EVA_GradeTaskNodeInst t").append(gradeTaskNodeCondition);
                if (!CollectionUtils.isEmpty(periodMap)) {
                    selectSQL.append(" and FPeriodID='").append(periodMap.get("periodId")).append("'");
                }
                selectSQL.append(" order by FCreateTime desc,FWfLevel desc");
                conn = EJBFactory.getConnection((Context)ctx);
                sql = new PagingHelper().getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)conn), selectSQL.toString().trim(), start, rows);
                taskNodeSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                PerfPortalUtils.assembleEvaObjBean(ctx, taskNodeSet, evaObjBeanList, request, response);
            }
            SQLUtils.cleanup((ResultSet)taskNodeSet, null, (Connection)conn);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(taskNodeSet, null, conn);
        }
        if (!CollectionUtils.isEmpty(periodMap)) {
            evaPerfPeriodBean.setPlanId(periodMap.get("planId"));
            evaPerfPeriodBean.setPlanName(periodMap.get("planName"));
            evaPerfPeriodBean.setPeriodId(periodMap.get("periodId"));
            evaPerfPeriodBean.setStartDate(periodMap.get("startDate"));
            evaPerfPeriodBean.setEndDate(periodMap.get("endDate"));
            String planId = periodMap.get("planId");
            PerformanceRuleInfo ruleInfo = GetEntityInfoUtils.getPerformanceRuleInfoByPeriodId(ctx, periodMap.get("periodId"));
            evaPerfPeriodBean.setScoreWay(ruleInfo.getScoringWay().getValue());
        }
        evaPerfPeriodBean.setEvaCountPerPeriod(evaCountPerPeriod);
        evaPerfPeriodBean.setEvaObjBeanList(evaObjBeanList);
        evaPerfPeriodBeanList.add(evaPerfPeriodBean);
        return evaCountPerPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int assembleEvaPerfPeriodBeanListData(Context ctx, int rows, String gradeTaskNodeCondition, LinkedList<Map<String, String>> periodList, LinkedList<EvaPerfPeriodBean> evaPerfPeriodBeanList, HttpServletRequest request, HttpServletResponse response) throws BOSException {
        String periodId;
        int evaCountPerPeriod = 0;
        LinkedList<EvaObjBean> evaObjBeanList = new LinkedList<EvaObjBean>();
        int page = 1;
        String reqPage = request.getParameter("page");
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)reqPage) && !reqPage.equals("null")) {
            page = Integer.parseInt(reqPage);
        }
        int start = (page - 1) * rows;
        String evaObjId = request.getParameter("evaObj");
        Connection conn = null;
        IRowSet taskNodeSet = null;
        String periodFilterSql = "";
        Map<String, PerformanceRuleInfo> performanceMap = null;
        if (!CollectionUtils.isEmpty(periodList)) {
            HashSet<String> periodIds = new HashSet<String>();
            for (Map map : periodList) {
                periodId = (String)map.get("periodId");
                periodIds.add(periodId);
            }
            String string = Strings.join((String[])periodIds.toArray(new String[0]), (String)"','");
            periodFilterSql = " ('" + string + "') ";
            performanceMap = GetEntityInfoUtils.getPerformanceRuleInfoByPeriodIdS(ctx, periodIds);
        }
        try {
            IRowSet iRowSet;
            StringBuilder evaCountPerPeriodSQL = new StringBuilder("SELECT COUNT(1) FROM T_EVA_GradeTaskNodeInst t left JOIN T_EVA_PerfevaObject o ON t.FEvaobjId=o.FID ").append(" left join T_EVA_WFNodeDef d on t.FWfNodeID = d.FID").append(" left join T_EVA_PWorkFlowDef f on d.fworkflow = f.FID").append(gradeTaskNodeCondition);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)periodFilterSql)) {
                evaCountPerPeriodSQL.append(" and t.FPeriodID in ").append(periodFilterSql);
            }
            if ((iRowSet = DbUtil.executeQuery((Context)ctx, (String)evaCountPerPeriodSQL.toString())).next() && (evaCountPerPeriod = iRowSet.getInt(1)) == 0) {
                int n = 0;
                return n;
            }
            StringBuilder stringBuilder = new StringBuilder("SELECT t.FID,t.FWfLevel,t.FEvaObjID,t.FNodeSumScore,t.FNodeGrade,t.FCreateTime,t.FWfNodeID,").append("d.FPerfGradeEvaluate, d.FNeedScore, f.fconcurrent ").append(" from T_EVA_GradeTaskNodeInst t").append(" left join T_EVA_PerfEvaObject o on t.FEvaObjID = o.FID").append(" left join T_EVA_WFNodeDef d on t.FWfNodeID = d.FID").append(" left join T_EVA_PWorkFlowDef f on d.fworkflow = f.FID").append(gradeTaskNodeCondition);
            if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)periodFilterSql)) {
                stringBuilder.append(" and t.FPeriodID in ").append(periodFilterSql);
            }
            if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)evaObjId) && page == 1) {
                String tempSql = stringBuilder.toString();
                stringBuilder.append(" and t.FEvaObjID = '").append(evaObjId).append("'");
                taskNodeSet = DbUtil.executeQuery((Context)ctx, (String)stringBuilder.toString());
                PerfPortalUtils.assembleEvaObjBean(ctx, taskNodeSet, evaObjBeanList, request, response);
                StringBuilder stringBuilder2 = new StringBuilder(tempSql);
                stringBuilder2.append(" and t.FEvaObjID <> '").append(evaObjId).append("'");
                stringBuilder2.append(" order by t.FPeriodID asc,o.FNumber asc");
                StringBuilder stringBuilder3 = new StringBuilder(stringBuilder2.toString().replaceFirst("SELECT", "SELECT TOP " + (rows - 1)));
                taskNodeSet = DbUtil.executeQuery((Context)ctx, (String)stringBuilder3.toString());
            } else {
                stringBuilder.append(" and t.FEvaObjID <> '").append(evaObjId).append("'");
                stringBuilder.append(" order by t.FPeriodID asc,o.FNumber asc");
                conn = EJBFactory.getConnection((Context)ctx);
                String sql = new PagingHelper().getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)conn), stringBuilder.toString().trim(), start - 1, rows);
                taskNodeSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            }
            PerfPortalUtils.assembleEvaObjBean(ctx, taskNodeSet, evaObjBeanList, request, response);
            SQLUtils.cleanup((ResultSet)taskNodeSet, null, (Connection)conn);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(taskNodeSet, null, conn);
        }
        if (!CollectionUtils.isEmpty(periodList)) {
            for (Map map : periodList) {
                PerformanceRuleInfo ruleInfo;
                EvaPerfPeriodBean evaPerfPeriodBean = new EvaPerfPeriodBean();
                periodId = (String)map.get("periodId");
                evaPerfPeriodBean.setPlanId((String)map.get("planId"));
                evaPerfPeriodBean.setPlanName((String)map.get("planName"));
                evaPerfPeriodBean.setPeriodId(periodId);
                evaPerfPeriodBean.setStartDate((String)map.get("startDate"));
                evaPerfPeriodBean.setEndDate((String)map.get("endDate"));
                evaPerfPeriodBean.setEvaCountPerPeriod(evaCountPerPeriod);
                LinkedList<EvaObjBean> evaObjBeanListTmp = new LinkedList<EvaObjBean>();
                if (!CollectionUtils.isEmpty(evaObjBeanList)) {
                    for (EvaObjBean evaObjBean : evaObjBeanList) {
                        if (!evaObjBean.getPeriod().equals(periodId)) continue;
                        evaObjBeanListTmp.add(evaObjBean);
                    }
                }
                evaPerfPeriodBean.setEvaObjBeanList(evaObjBeanListTmp);
                if (performanceMap != null && performanceMap.size() > 0 && (ruleInfo = performanceMap.get(periodId)) != null) {
                    evaPerfPeriodBean.setScoreWay(ruleInfo.getScoringWay().getValue());
                }
                evaPerfPeriodBeanList.add(evaPerfPeriodBean);
            }
        }
        return evaCountPerPeriod;
    }

    public static int calcPageCount(int total, int pageRows) {
        int totalPage = 0;
        if (total > 0) {
            totalPage = total % pageRows == 0 ? total / pageRows : total / pageRows + 1;
        }
        return totalPage;
    }

    public static void assembleEvaObjBean(Context ctx, IRowSet taskNodeSet, LinkedList<EvaObjBean> evaObjBeanList, HttpServletRequest request, HttpServletResponse response) {
        if (taskNodeSet != null) {
            HashMap<String, Integer> taskSizeMap = new HashMap<String, Integer>();
            String clickEvaObj = request.getParameter("evaObj");
            HashSet<String> set = new HashSet<String>();
            HashSet<String> marTset = new HashSet<String>();
            try {
                HashSet<String> evaObjs = new HashSet<String>();
                HashSet<String> nodeToEvas = new HashSet<String>();
                while (taskNodeSet.next()) {
                    String evaObj = taskNodeSet.getString("FEvaObjID");
                    evaObjs.add(evaObj);
                    String taskNode = taskNodeSet.getString("FID");
                    nodeToEvas.add(taskNode + "##" + evaObj);
                }
                taskNodeSet.beforeFirst();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", evaObjs, CompareType.INCLUDE));
                PerfEvaObjectCollection evaObjectCollection = PerfEvaObjectFactory.getLocalInstance(ctx).getPerfEvaObjectCollection("where " + filterInfo.toSql());
                if (evaObjectCollection != null && evaObjectCollection.size() > 0) {
                    HashMap<String, PerfEvaObjectInfo> evaObjectInfoMap = new HashMap<String, PerfEvaObjectInfo>();
                    for (int i = 0; i < evaObjectCollection.size(); ++i) {
                        PerfEvaObjectInfo evaObjectInfo = evaObjectCollection.get(i);
                        evaObjectInfoMap.put(evaObjectInfo.getId().toString(), evaObjectInfo);
                    }
                    Map<String, Map<String, String>> nodeSumScoreMap = PerfInvolveScoreUtils.getCalcNodeSumScore(ctx, nodeToEvas);
                    while (taskNodeSet.next()) {
                        String evaObj = taskNodeSet.getString("FEvaObjID");
                        Integer size = (Integer)taskSizeMap.get(evaObj);
                        if (size == null) {
                            size = 1;
                            taskSizeMap.put(evaObj, 1);
                        } else {
                            Integer n = size;
                            Integer n2 = size = Integer.valueOf(size + 1);
                        }
                        taskSizeMap.put(evaObj, size);
                        if (set.contains(evaObj)) {
                            marTset.add(evaObj);
                            continue;
                        }
                        set.add(evaObj);
                        PerfEvaObjectInfo evaObjInfo = (PerfEvaObjectInfo)evaObjectInfoMap.get(evaObj);
                        EvaObjBean evaObjBean = new EvaObjBean();
                        evaObjBean.setSortCode(evaObjInfo.getNumber());
                        evaObjBean.setEvaObj(evaObj);
                        String isOrg = request.getParameter("isOrg");
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)isOrg)) {
                            isOrg = "0";
                        }
                        if (0 == Integer.parseInt(isOrg)) {
                            evaObjBean.setPersonId(evaObjInfo.getPerson().getId().toString());
                            request.setAttribute("personId", (Object)evaObjInfo.getPerson().getId().toString());
                            request.setAttribute("personNumber", (Object)evaObjInfo.getNumber());
                            evaObjBean.setPhotoPath(PhotoUtils.showCutImage(request, response));
                        } else {
                            evaObjBean.setPhotoPath("");
                        }
                        evaObjBean.setPersonName(evaObjInfo.getName());
                        evaObjBean.setPersonNumber(evaObjInfo.getNumber());
                        evaObjBean.setCurrentWFLevel(taskNodeSet.getInt("FWfLevel"));
                        evaObjBean.setGradeTaskNode(taskNodeSet.getString("FID"));
                        request.setAttribute("personNumber", (Object)evaObjInfo.getNumber());
                        if (size == 1) {
                            String nodeSumScore = taskNodeSet.getString("FNodeSumScore");
                            Map<String, String> map = nodeSumScoreMap.get(evaObjBean.getGradeTaskNode());
                            if (map.get("showTarget") != null && map.get("showTarget").equals("0")) {
                                BigDecimal score = new BigDecimal("0");
                                if (null != map.get("sumScore")) {
                                    score = new BigDecimal(map.get("sumScore"));
                                }
                                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)nodeSumScore)) {
                                    BigDecimal sumScore = new BigDecimal(nodeSumScore).subtract(score);
                                    nodeSumScore = String.valueOf(sumScore.setScale(2, RoundingMode.HALF_UP));
                                }
                            } else if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)nodeSumScore)) {
                                BigDecimal sumScore = new BigDecimal(nodeSumScore);
                                nodeSumScore = String.valueOf(sumScore.setScale(2, RoundingMode.HALF_UP));
                            }
                            evaObjBean.setScore(nodeSumScore);
                            evaObjBean.setGradeLevel(taskNodeSet.getString("FNodeGrade"));
                        } else {
                            evaObjBean.setScore(null);
                            evaObjBean.setGradeLevel(null);
                        }
                        if (null != evaObjInfo.getPeriod() && null != evaObjInfo.getPeriod().getId()) {
                            evaObjBean.setPeriod(evaObjInfo.getPeriod().getId().toString());
                        }
                        evaObjBean.setPerfGradeEvaluate(taskNodeSet.getString("FPerfGradeEvaluate"));
                        evaObjBean.setNeedScore(taskNodeSet.getString("FNeedScore"));
                        evaObjBean.setShowScore(TEAMEVAL);
                        if (1 == evaObjInfo.getCanAdjustEvaluer().getValue() || TEAMEVAL.equals(taskNodeSet.getString("fconcurrent"))) {
                            evaObjBean.setShowScore("0");
                        }
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)clickEvaObj) && clickEvaObj.equals(evaObj)) {
                            evaObjBeanList.addFirst(evaObjBean);
                            continue;
                        }
                        evaObjBeanList.add(evaObjBean);
                    }
                }
                for (EvaObjBean evaObjBean : evaObjBeanList) {
                    if (!marTset.contains(evaObjBean.getEvaObj())) continue;
                    evaObjBean.setScore(null);
                    evaObjBean.setGradeLevel(null);
                }
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
        }
    }

    public static String getTeamTargetInfoData(HttpServletRequest request, HttpServletResponse response, Context ctx) throws Exception {
        long start = System.currentTimeMillis();
        int rows = 8;
        String personId = request.getParameter("personId");
        if (personId == null) {
            IObjectPK userId = ctx.getCaller();
            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(userId);
            personId = user.getPerson().getId().toString();
        }
        String evaObjName = request.getParameter("evaObjName");
        String goalsMsgReceiverCondition = " where receiver.FReceiver='" + personId + "' and receiver.FHandleStatus='" + TEAMEVAL + "' and receiver.FMsgType='" + "0" + "' and receiver.FIsSelf=" + 0;
        List<Map<String, Object>> periodList = PerfPortalUtils.getPeriodList(ctx, personId, goalsMsgReceiverCondition, evaObjName, rows, null, OrgAssessmentUtils.isOrgAssessment(request));
        String json = PerfPortalUtils.getJsonData(request, response, ctx, periodList);
        logger.info("query end:");
        return json;
    }

    public static String getMyTargetInfoData(HttpServletRequest request, HttpServletResponse response, Context ctx) throws Exception {
        int rows = 8;
        String personId = request.getParameter("personId");
        if (personId == null) {
            IObjectPK userId = ctx.getCaller();
            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(userId);
            personId = user.getPerson().getId().toString();
        }
        String evaObjName = request.getParameter("evaObjName");
        String goalsMsgReceiverCondition = " where FReceiver='" + personId + "' and FHandleStatus='" + TEAMEVAL + "' and FMsgType='" + "0" + "' and FIsSelf=" + 1 + " and FTargetStatus = '" + "0" + "'";
        List<Map<String, Object>> periodList = PerfPortalUtils.getPeriodList(ctx, personId, goalsMsgReceiverCondition, evaObjName, rows, YesOrNotEnum.YES, OrgAssessmentUtils.isOrgAssessment(request));
        String json = PerfPortalUtils.getJsonData(request, response, ctx, periodList);
        return json;
    }

    @Deprecated
    public static int getTeamTargetCount(Context ctx, String personId, boolean isOrg) throws BOSException, EASBizException, IOException {
        int evaObjCount = 0;
        if (personId == null) {
            IObjectPK userId = ctx.getCaller();
            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(userId);
            personId = user.getPerson().getId().toString();
        }
        String goalsMsgReceiverCondition = " where receiver='" + personId + "' and handleStatus='" + TEAMEVAL + "' and msgType='" + "0" + "' and isSelf=" + 0 + " and evaObj.targetTransmitWay <> '" + TEAMEVAL + "' and evaObj.unitAfterFiller='1'";
        goalsMsgReceiverCondition = goalsMsgReceiverCondition + OrgAssessmentUtils.getPortalOrgFilterStr(null, PortalMesTypeEnum.orgTransmit, isOrg);
        IGoalsMessageReceiver igMReceiver = GoalsMessageReceiverFactory.getLocalInstance(ctx);
        GoalsMessageReceiverCollection goalsMReceiverColl = igMReceiver.getGoalsMessageReceiverCollection(goalsMsgReceiverCondition);
        evaObjCount = goalsMReceiverColl.size();
        return evaObjCount;
    }

    public static int getTeamTargetCount(Context ctx, boolean isOrg) {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("handleStatus", (Object)TEAMEVAL));
        filterInfo.getFilterItems().add(new FilterItemInfo("msgType", (Object)"0"));
        filterInfo.getFilterItems().add(new FilterItemInfo("isSelf", (Object)0));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaObj.targetTransmitWay", (Object)TEAMEVAL, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("receiver", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaObj.unitAfterFiller", (Object)1, CompareType.EQUALS));
        OrgAssessmentUtils.setPortalOrgFilter(filterInfo, PortalMesTypeEnum.orgTransmit, isOrg);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        try {
            return GoalsMessageReceiverFactory.getLocalInstance(ctx).getCount(evi);
        }
        catch (BOSException e) {
            logger.error("getTeamTargetCount bos err", (Throwable)e);
            return 0;
        }
    }

    public static int getPerfGoTeamTargetCount(Context ctx, String personId, boolean isOrg) throws BOSException, EASBizException {
        int evaObjCount = 0;
        if (personId == null) {
            IObjectPK userId = ctx.getCaller();
            UserInfo user = UserFactory.getLocalInstance((Context)ctx).getUserByID(userId);
            personId = user.getPerson().getId().toString();
        }
        String goalsMsgReceiverCondition = " where receiver='" + personId + "' and handleStatus='" + TEAMEVAL + "' and msgType='" + "0" + "' and isSelf=" + 0 + " and evaObj.targetTransmitWay <> '" + TEAMEVAL + "' and evaObj.personalGoalStatus =" + 2;
        goalsMsgReceiverCondition = goalsMsgReceiverCondition + OrgAssessmentUtils.getPortalOrgFilterStr(null, PortalMesTypeEnum.orgTransmit, isOrg);
        IGoalsMessageReceiver igMReceiver = GoalsMessageReceiverFactory.getLocalInstance(ctx);
        GoalsMessageReceiverCollection goalsMReceiverColl = igMReceiver.getGoalsMessageReceiverCollection(goalsMsgReceiverCondition);
        evaObjCount = goalsMReceiverColl.size();
        return evaObjCount;
    }

    public static void sortPeriodListDesc(final Context ctx, List<Map<String, String>> periodList) {
        Collections.sort(periodList, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                Date d1;
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy.MM.dd");
                SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd");
                String startDate1 = "";
                String endDate1 = "";
                String startDate2 = "";
                String endDate2 = "";
                try {
                    startDate1 = sdf3.format(sdf2.parse(o1.get("startDate")));
                    endDate1 = sdf3.format(sdf2.parse(o1.get("endDate")));
                    startDate2 = sdf3.format(sdf2.parse(o2.get("startDate")));
                    endDate2 = sdf3.format(sdf2.parse(o2.get("endDate")));
                }
                catch (ParseException e) {
                    logger.error("ParseException: ", (Throwable)e);
                }
                if (PerfDateUtils.compareStrDate(startDate1, startDate2) != 0) {
                    return PerfDateUtils.compareStrDate(startDate2, startDate1);
                }
                if (PerfDateUtils.compareStrDate(endDate2, endDate1) != 0) {
                    return PerfDateUtils.compareStrDate(endDate2, endDate1);
                }
                SimpleDateFormat sdf4 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String planId1 = o1.get("planId");
                String planId2 = o2.get("planId");
                PerfPlanInfo planInfo1 = GetEntityInfoUtils.getPerfPlanInfo(ctx, planId1);
                PerfPlanInfo planInfo2 = GetEntityInfoUtils.getPerfPlanInfo(ctx, planId2);
                Date d2 = d1 = new Date();
                if (planInfo1.getCreateTime() != null) {
                    try {
                        d1 = sdf4.parse(planInfo1.getCreateTime().toString());
                    }
                    catch (ParseException e) {
                        logger.error("ParseException: ", (Throwable)e);
                    }
                }
                if (planInfo2.getCreateTime() != null) {
                    try {
                        d2 = sdf4.parse(planInfo2.getCreateTime().toString());
                    }
                    catch (ParseException e) {
                        logger.error("ParseException: ", (Throwable)e);
                    }
                }
                return PerfDateUtils.compareDate(d2, d1);
            }
        });
    }

    public static void sortReceiverMsgByReceivetime(List<Map<String, Object>> receiverList) {
        Collections.sort(receiverList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Date d1;
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String receiveTime1 = (String)o1.get("receiveTime");
                String receiveTime2 = (String)o2.get("receiveTime");
                Date d2 = d1 = new Date();
                try {
                    d1 = sdf.parse(receiveTime1);
                    d2 = sdf.parse(receiveTime2);
                }
                catch (ParseException e) {
                    logger.error("ParseException: ", (Throwable)e);
                }
                return PerfDateUtils.compareDate(d2, d1);
            }
        });
    }

    public static String getTeamTargetInfo(HttpServletRequest request, HttpServletResponse response, Context ctx) throws Exception {
        int rows = 1;
        String personId = request.getParameter("personId");
        if (personId == null) {
            personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        }
        String evaObjName = request.getParameter("evaObjName");
        String goalsMsgReceiverCondition = " where FReceiver='" + personId + "' and receiver.FHandleStatus='" + TEAMEVAL + "' and receiver.FMsgType='" + "0" + "' and receiver.FIsSelf=" + "0";
        List<Map<String, Object>> periodList = PerfPortalUtils.getPeriodList(ctx, personId, goalsMsgReceiverCondition, evaObjName, rows, null, OrgAssessmentUtils.isOrgAssessment(request));
        String json = PerfPortalUtils.getJsonData(request, response, ctx, periodList);
        return json;
    }

    /*
     * Unable to fully structure code
     */
    public static List<Map<String, String>> getPlansWithPeriodByPageType(Context ctx, String isOrg, String pageType, String permItemId) throws BOSException, SQLException {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)isOrg) || org.apache.commons.lang3.StringUtils.isBlank((CharSequence)pageType)) {
            return null;
        }
        personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        type = null;
        isSelf = 0;
        portaMesType = null;
        personalGoalStatus = "";
        receiverTaskStatusFilter = "";
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"1", (CharSequence)pageType)) {
            type = "0";
            portaMesType = PortalMesTypeEnum.personalTarget;
            isSelf = 1;
            personalGoalStatus = "('0', '1')";
            receiverTaskStatusFilter = "  and receiver.FTargetStatus = '0'";
        }
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"2", (CharSequence)pageType)) {
            type = "0";
            portaMesType = PortalMesTypeEnum.personalTransmit;
            isSelf = 0;
            personalGoalStatus = "('0', '1','2')";
        }
        periodSet = new HashSet<E>();
        if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"1", (CharSequence)pageType) || org.apache.commons.lang3.StringUtils.equals((CharSequence)"2", (CharSequence)pageType)) {
            periodSQLBuf = new StringBuffer();
            periodSQLBuf.append("select receiver.FPeriodId as period from T_EVA_GoalsMessageReceiver receiver ").append(" left join T_EVA_PerfEvaObject evaObject on receiver.FEVAOBJID = evaObject.FID ").append(" where receiver.FReceiver='").append(personId).append("' and receiver.FHandleStatus='").append("1").append("' and receiver.FMsgType='").append(type).append("' and receiver.FIsSelf=").append(isSelf).append("  and evaObject.FunitGoalsStatus = 1 AND evaObject.FpersonalGoalStatus IN " + personalGoalStatus).append(receiverTaskStatusFilter);
            periodSQLBuf.append(OrgAssessmentUtils.getPortalOrgFilterStr(null, portaMesType, org.apache.commons.lang3.StringUtils.equals((CharSequence)"1", (CharSequence)isOrg)));
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)periodSQLBuf.toString());
                if (rs == null) ** GOTO lbl54
                while (rs.next()) {
                    period = rs.getString("period");
                    if (StringUtils.isEmpty((String)period)) continue;
                    periodSet.add(period);
                }
            }
            catch (BOSException e1) {
                PerfPortalUtils.logger.error("", (Throwable)e1);
            }
            catch (SQLException e) {
                PerfPortalUtils.logger.error("", (Throwable)e);
            }
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"3", (CharSequence)pageType)) {
            periodSet = PerfPortalUtils.getTeamEvaPeriodSet(ctx, personId, isOrg, pageType);
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"5", (CharSequence)pageType)) {
            periodSet = PerfPortalUtils.getTeamEvaPeriodSet(ctx, personId, isOrg, pageType);
        } else if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"6", (CharSequence)pageType)) {
            periodSet = PerfPortalUtils.getPeriodSetWithEvaObj(ctx, isOrg, permItemId);
        } else {
            periodAndCountMap = PerfPortalUtils.getMultiAssessmentPeriodList(ctx, isOrg);
            periodSet = periodAndCountMap.get("periods");
        }
lbl54:
        // 8 sources

        periodList = new ArrayList<E>();
        if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)"4", (CharSequence)pageType)) {
            sdf = new SimpleDateFormat("yyyy.MM.dd");
            iterator = periodSet.iterator();
            if (iterator != null) {
                while (iterator.hasNext()) {
                    period = (String)iterator.next();
                    periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, period);
                    if (periodInfo == null || periodInfo.getId() == null) {
                        PerfPortalUtils.logger.error("team goals task periodid:" + period + "not exist in period table,please check\uff01");
                        continue;
                    }
                    periodMap = new HashMap<String, String>();
                    periodMap.put("periodId", period);
                    periodMap.put("startDate", sdf.format(periodInfo.getPStartDate()));
                    periodMap.put("endDate", sdf.format(periodInfo.getPEndDate()));
                    periodMap.put("planName", periodInfo.getPerfPlan().getName());
                    periodList.add(periodMap);
                }
            }
        } else {
            periodList = PerfPortalUtils.getEnabledMultiPeriods(ctx, periodSet);
        }
        if (!CollectionUtils.isEmpty(periodList)) {
            PerfPortalUtils.sortPeriodListDesc(ctx, periodList);
        }
        return periodList;
    }

    private static Set<String> getPeriodSetWithEvaObj(Context ctx, String isOrg, String permItemId) throws BOSException, SQLException {
        HashSet<String> periodIdSet = new HashSet<String>();
        String sql = "select distinct o.fperiodid as periodId from t_eva_perfevaObject o left join t_eva_perfperiod p on p.fid = o.FPERIODID  where o.FUNITGOALSSTATUS = 1 and o.fpersonalGoalStatus in (0, 1) and p.FEVAPERIODSTATUS != 100 and o.FISORG = ?";
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)permItemId)) {
            sql = sql + " and o.FADMINORGUNITID in (" + SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)HRFilterUtils.getCurrentUserId((Context)ctx), (String)permItemId) + ")";
        }
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{Integer.parseInt(isOrg)});
        while (rowSet.next()) {
            periodIdSet.add(rowSet.getString("periodId"));
        }
        return periodIdSet;
    }

    public static String getJsonData(HttpServletRequest request, HttpServletResponse response, Context ctx, List<Map<String, Object>> periodList) throws BOSException, IOException {
        IPerfEvaObject iperfEvaObj = PerfEvaObjectFactory.getLocalInstance(ctx);
        long creatPhotoTime = 0L;
        TeamPersonalTargetBean teamBean = new TeamPersonalTargetBean();
        int totalCount = 0;
        ArrayList<EvaPerfPeriodBean> evaPerfPeriodBeanList = new ArrayList<EvaPerfPeriodBean>();
        for (Map<String, Object> map : periodList) {
            LinkedList<EvaObjBean> evaObjBeanList = new LinkedList<EvaObjBean>();
            EvaPerfPeriodBean evaPeriodBean = new EvaPerfPeriodBean();
            evaPeriodBean.setStartDate((String)map.get("startDate"));
            evaPeriodBean.setEndDate((String)map.get("endDate"));
            evaPeriodBean.setPeriodId((String)map.get("periodId"));
            evaPeriodBean.setPlanId((String)map.get("planId"));
            evaPeriodBean.setPlanName((String)map.get("planName"));
            Object isDealReceiveTime = request.getAttribute("isDealReceiveTime");
            if (isDealReceiveTime == null || TEAMEVAL.equals(isDealReceiveTime)) {
                ArrayList evaObjList = new ArrayList();
                evaObjList = (ArrayList)map.get("evaObjList");
                if (evaObjList != null && evaObjList.size() > 0) {
                    for (String evaObj : evaObjList) {
                        EvaObjBean evaObjBean = new EvaObjBean();
                        PerfEvaObjectInfo evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
                        if (null == evaObjInfo) {
                            logger.error("evaObj: \u3010" + evaObj + "\u3011 exist");
                            continue;
                        }
                        evaObjBean.setEvaObj(evaObj);
                        if (null != evaObjInfo.getPerfFile() && null != evaObjInfo.getPerfFile().getPerson()) {
                            evaObjBean.setPersonId(evaObjInfo.getPerfFile().getPerson().getId().toString());
                        }
                        evaObjBean.setPersonName(evaObjInfo.getName());
                        evaObjBean.setPersonNumber(evaObjInfo.getNumber());
                        String personId = "ORG";
                        long st = System.currentTimeMillis();
                        if (!OrgAssessmentUtils.isOrgAssessment(evaObjInfo)) {
                            personId = evaObjInfo.getPerson().getId().toString();
                            request.setAttribute("personId", (Object)personId);
                            request.setAttribute("personNumber", (Object)evaObjInfo.getNumber());
                            evaObjBean.setPhotoPath(PhotoUtils.showCutImage(request, response));
                        } else {
                            evaObjBean.setPhotoPath("");
                        }
                        creatPhotoTime += System.currentTimeMillis() - st;
                        evaObjBeanList.add(evaObjBean);
                    }
                }
            }
            int evaCountPerPeriod = (Integer)map.get("totalCount");
            totalCount += evaCountPerPeriod;
            evaPeriodBean.setEvaCountPerPeriod(evaCountPerPeriod);
            evaPeriodBean.setEvaObjBeanList(evaObjBeanList);
            Object scoreWay = map.get("scoreWay");
            evaPeriodBean.setScoreWay(scoreWay == null ? 0 : Integer.valueOf(String.valueOf(scoreWay)));
            evaPerfPeriodBeanList.add(evaPeriodBean);
        }
        teamBean.setTotalCount(totalCount);
        teamBean.setEvaPerfPeriodBeanList(evaPerfPeriodBeanList);
        Gson gson = new Gson();
        String json = gson.toJson((Object)teamBean);
        return json;
    }

    public static float roudUpRemainGiveDecimal(int decimalCount, float value) {
        float result = 0.0f;
        try {
            BigDecimal b = BigDecimal.valueOf(value);
            result = b.setScale(decimalCount, 4).floatValue();
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, Object>> getPeriodList(Context ctx, String personId, String goalsMsgReceiverCondition, String evaObjName, int rows, YesOrNotEnum isSelf, Boolean isOrg) throws Exception {
        if (isSelf == null) {
            isSelf = YesOrNotEnum.NO;
        }
        if (null == isOrg) {
            isOrg = false;
        }
        goalsMsgReceiverCondition = isOrg != false ? goalsMsgReceiverCondition + " and receiver.FPerson = 'ORG'" : goalsMsgReceiverCondition + " and receiver.FPerson <> 'ORG'";
        Set<String> periodSet = PerfPortalUtils.getPeriodSet(ctx, personId, isSelf, isOrg);
        ArrayList<Map<String, Object>> periodList = new ArrayList<Map<String, Object>>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd");
        Iterator<String> iterator = periodSet.iterator();
        if (iterator != null) {
            while (iterator.hasNext()) {
                StringBuffer evaObjBuffer = new StringBuffer("(''");
                String period = iterator.next();
                PerfPeriodInfo periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, period);
                if (periodInfo == null || periodInfo.getId() == null) {
                    logger.error("period id:" + period + "is not exist\uff01");
                    continue;
                }
                HashMap<String, Object> periodMap = new HashMap<String, Object>();
                periodMap.put("periodId", period);
                periodMap.put("startDate", sdf.format(periodInfo.getPStartDate()));
                periodMap.put("endDate", sdf.format(periodInfo.getPEndDate()));
                PerfPlanInfo perfPlanInfo = GetEntityInfoUtils.getPerfPlanInfo(ctx, periodInfo.getPerfPlan().getId().toString());
                periodMap.put("planName", perfPlanInfo.getName());
                if (perfPlanInfo.getId() != null) {
                    periodMap.put("planId", perfPlanInfo.getId().toString());
                } else {
                    periodMap.put("planId", null);
                }
                ArrayList<String> evaObjList = new ArrayList<String>();
                StringBuffer gMsgReceiverCondition = new StringBuffer(goalsMsgReceiverCondition);
                gMsgReceiverCondition.append(" and evaobj.funitAfterFiller='1' and receiver.FPeriodId ='").append(period).append("'");
                if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)evaObjName)) {
                    IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
                    PerfEvaObjectCollection evaObjColl = iPerfEvaObject.getPerfEvaObjectCollection(" where name like '%" + evaObjName + "%'");
                    if (evaObjColl != null && evaObjColl.size() > 0) {
                        for (int i = 0; i < evaObjColl.size(); ++i) {
                            evaObjBuffer.append(",'").append(evaObjColl.get(i).getId().toString()).append("'");
                        }
                    }
                    evaObjBuffer.append(")");
                    gMsgReceiverCondition.append(" and FEvaObjID in ").append(evaObjBuffer.toString());
                }
                StringBuilder totalCountSQL = new StringBuilder("select count(1) from T_EVA_GoalsMessageReceiver receiver ");
                if ("0".equals(isSelf.getValue())) {
                    totalCountSQL.append(" left join T_EVA_PerfEvaObject evaObj on receiver.FEvaObjId = evaObj.FID").append(gMsgReceiverCondition.toString()).append(" AND evaObj.FTargetTransmitWay <> '1'");
                } else {
                    totalCountSQL.append(gMsgReceiverCondition.toString());
                }
                IRowSet totoalCountSet = DbUtil.executeQuery((Context)ctx, (String)totalCountSQL.toString());
                try {
                    if (totoalCountSet != null && totoalCountSet.next()) {
                        periodMap.put("totalCount", totoalCountSet.getInt(1));
                    }
                }
                catch (SQLException e) {
                    logger.error("SQLException: ", (Throwable)e);
                }
                gMsgReceiverCondition.append(" order by receiver.FCreateTime DESC");
                String periodToDoEvaObjectSQL = "SELECT receiver.FEvaObjID AS FEvaObjID FROM T_EVA_GoalsMessageReceiver receiver inner join T_EVA_PerfEvaObject evaobj on evaobj.FID=receiver.FEvaObjID" + gMsgReceiverCondition.toString();
                periodToDoEvaObjectSQL = periodToDoEvaObjectSQL.trim().replaceFirst("SELECT", "SELECT TOP " + rows);
                Connection conn = null;
                IRowSet periodToDoEvaObjSet = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    periodToDoEvaObjectSQL = new PagingHelper().getPagingSqlNoOptmize(KSqlUtil.getDbType((Connection)conn), periodToDoEvaObjectSQL, 0, rows);
                    periodToDoEvaObjSet = DbUtil.executeQuery((Context)ctx, (String)periodToDoEvaObjectSQL);
                    while (periodToDoEvaObjSet.next()) {
                        String fEvaObjID = periodToDoEvaObjSet.getString("FEvaObjID");
                        PerfEvaObjectInfo perfEvaObjectInfo = PerfEvaObjectFactory.getLocalInstance(ctx).getPerfEvaObjectInfo("where id='" + fEvaObjID + "'");
                        YesOrNoEnum unitAfterFiller = perfEvaObjectInfo.getUnitAfterFiller();
                        if (unitAfterFiller.getValue() == 0) continue;
                        evaObjList.add(fEvaObjID);
                    }
                    SQLUtils.cleanup((ResultSet)periodToDoEvaObjSet, null, (Connection)conn);
                }
                catch (SQLException e) {
                    logger.error("SQLException: ", (Throwable)e);
                }
                finally {
                    SQLUtils.cleanup(periodToDoEvaObjSet, null, (Connection)conn);
                }
                periodMap.put("evaObjList", evaObjList);
                if (evaObjList.size() <= 0) continue;
                periodList.add(periodMap);
            }
        }
        return periodList;
    }

    public static Set<String> getPeriodSet(Context ctx, String personId, YesOrNotEnum isSelf, Boolean isOrg) {
        if (null == isOrg) {
            isOrg = false;
        }
        HashSet<String> periodSet = new HashSet<String>();
        StringBuffer periodSQLBuf = new StringBuffer("select FPeriodId from T_EVA_GoalsMessageReceiver where FReceiver='");
        periodSQLBuf.append(personId).append("' and FHandleStatus='").append(TEAMEVAL).append("' and FMsgType='").append("0").append("' and FIsSelf=").append(isSelf.getValue());
        if (isOrg.booleanValue()) {
            periodSQLBuf.append(" and Fperson = 'ORG'");
        } else {
            periodSQLBuf.append(" and Fperson <> 'ORG'");
        }
        periodSQLBuf.append(" group by FPeriodId ");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)periodSQLBuf.toString());
            if (rs != null) {
                while (rs.next()) {
                    String period = rs.getString("FPeriodId");
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)period)) continue;
                    periodSet.add(period);
                }
            }
        }
        catch (BOSException e1) {
            logger.error("BOSException: ", (Throwable)e1);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return periodSet;
    }

    public static Set<String> getTeamEvaPeriodSet(Context ctx, String personId, String isOrg, String pageType) {
        HashSet<String> periodSet = new HashSet<String>();
        StringBuilder periodSQLBuilder = new StringBuilder("select gtni.FPeriodID from  T_EVA_GradeTaskNodeInst gtni ").append(" LEFT JOIN T_EVA_PerfEvaObject peo ON gtni.FEVAOBJID= peo.FID  where gtni.FNodeHandlerID='").append(personId).append("' and gtni.FIsEffective='").append(TEAMEVAL).append("' and gtni.FScoreStatus<>'").append("2").append("' ");
        if (pageType == null) {
            pageType = TEAMEVAL;
        }
        if (pageType.equals(TEAMEVAL) || pageType.equals("3")) {
            periodSQLBuilder.append(" and gtni.FIsSelf=").append(0);
        } else if (pageType.equals("5")) {
            periodSQLBuilder.append(" and gtni.FIsSelf=").append(1);
        }
        periodSQLBuilder.append("  and peo.FIsOrg= ?");
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)periodSQLBuilder.toString(), (Object[])new Object[]{isOrg});
            if (rs != null) {
                while (rs.next()) {
                    String period = rs.getString("FPeriodID");
                    if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)period)) continue;
                    periodSet.add(period);
                }
            }
        }
        catch (BOSException e1) {
            logger.error("BOSException: ", (Throwable)e1);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return periodSet;
    }

    public static List<Map<String, String>> getEnabledMultiPeriods(Context ctx, Set<String> periodIds) throws BOSException {
        ArrayList<Map<String, String>> periods = new ArrayList<Map<String, String>>();
        MultiPerfPeriodInfo perfPeriodInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("multiperfplan.name"));
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        filterItems.add(new FilterItemInfo("id", periodIds, CompareType.INCLUDE));
        filterItems.add(new FilterItemInfo("evaPeriodStatus", (Object)200));
        viewInfo.setFilter(filterInfo);
        IMultiPerfPeriod iPeriodFactory = MultiPerfPeriodFactory.getLocalInstance(ctx);
        MultiPerfPeriodCollection periodCollection = iPeriodFactory.getMultiPerfPeriodCollection(viewInfo);
        int count = periodCollection.size();
        if (count > 0) {
            HashMap<String, String> periodMap = null;
            String dateFormat = "yyyy.MM.dd";
            for (int i = 0; i < count; ++i) {
                perfPeriodInfo = periodCollection.get(i);
                periodMap = new HashMap<String, String>();
                periodMap.put("periodId", perfPeriodInfo.getId().toString());
                periodMap.put("planName", perfPeriodInfo.getMultiPerfplan().getName());
                periodMap.put("startDate", PerfDateUtils.formatDate(perfPeriodInfo.getPStartDate(), "yyyy.MM.dd"));
                periodMap.put("endDate", PerfDateUtils.formatDate(perfPeriodInfo.getPEndDate(), "yyyy.MM.dd"));
                periods.add(periodMap);
            }
            final long currentDateTime = PerfDateUtils.formatDate().getTime();
            Collections.sort(periods, new Comparator<Map<String, String>>(){

                @Override
                public int compare(Map<String, String> periodOne, Map<String, String> periodTwo) {
                    String endDateTwo;
                    String endDateOne = periodOne.get("endDate");
                    if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)endDateOne, (CharSequence)(endDateTwo = periodTwo.get("endDate")))) {
                        long endDatetimeOne = PerfDateUtils.strToDateByFormat(endDateOne, "yyyy.MM.dd").getTime() - currentDateTime;
                        long endDatetimeTwo = PerfDateUtils.strToDateByFormat(endDateTwo, "yyyy.MM.dd").getTime() - currentDateTime;
                        return (int)(endDatetimeTwo - endDatetimeOne);
                    }
                    String startDateOne = periodOne.get("startDate");
                    String startDateTwo = periodTwo.get("startDate");
                    long startDatetimeOne = currentDateTime - PerfDateUtils.strToDateByFormat(startDateOne, "yyyy.MM.dd").getTime();
                    long startDatetimeTwo = currentDateTime - PerfDateUtils.strToDateByFormat(startDateTwo, "yyyy.MM.dd").getTime();
                    return (int)(startDatetimeTwo - startDatetimeOne);
                }
            });
        }
        return periods;
    }

    public static FilterInfo getMultiAssessmentFilterInfo(Context ctx, String periodId) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItems = filter.getFilterItems();
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)periodId)) {
            filterItems.add(new FilterItemInfo("multiPeriod.id", (Object)periodId, CompareType.EQUALS));
        }
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        filterItems.add(new FilterItemInfo("receiver", (Object)personId, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("status", (Object)TEAMEVAL, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("isEffect", (Object)1, CompareType.EQUALS));
        filterItems.add(new FilterItemInfo("perfEvaObj.paperStatus", (Object)"200", CompareType.EQUALS));
        return filter;
    }

    public static Map<String, Set<String>> getMultiAssessmentPeriodList(Context ctx, String isOrg) throws BOSException, SQLException {
        HashSet<String> assessmentPeriods = new HashSet<String>();
        HashSet<String> count = new HashSet<String>();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.shr.perfweb.app.multiEvalution.commonTask.MultiEvaluInstQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)queryPK);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("multiPeriod.id"));
        exec.setObjectView(viewInfo);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        FilterInfo filterInfo = PerfPortalUtils.getMultiAssessmentFilterInfo(ctx, null);
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)isOrg)) {
            isOrg = "0";
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("multiPeriod.isOrg", (Object)Integer.parseInt(isOrg), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        IRowSet iRowSet = exec.executeQuery();
        while (iRowSet.next()) {
            assessmentPeriods.add(iRowSet.getString("multiPeriod.id"));
            count.add(iRowSet.getString("id"));
        }
        result.put("periods", assessmentPeriods);
        result.put("count", count);
        return result;
    }

    public static String getEvaObjEvaluDataList(HttpServletRequest request, HttpServletResponse response, Context ctx) {
        try {
            TeamTargetCommentBean teamBean = new TeamTargetCommentBean();
            LinkedList<EvaPerfPeriodBean> evaPerfPeriodBeanList = new LinkedList<EvaPerfPeriodBean>();
            String personId = request.getParameter("personId");
            String evaObj = request.getParameter("evaObj");
            EvaPerfPeriodBean periodBean = new EvaPerfPeriodBean();
            LinkedList<EvaObjBean> evaObjBeanList = new LinkedList<EvaObjBean>();
            int totalCount = 0;
            int totalPage = 1;
            String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
            StringBuffer selectSQL = new StringBuffer("select p.FID AS perfPeriod ,p.FEVASTARTDATE ,p.FEVAENDDATE,p.FPERFPLAN,");
            selectSQL.append("n.FNAME").append(mlFlag).append(" AS planName,r.FSCORINGWAY,o.FPERSONID,o.FNAME").append(mlFlag).append(",o.FID ,o.FNUMBER ,g.FWFLEVEL ,g.FID AS gradeTaskNode,w.FPERFGRADEEVALUATE,w.FNEEDSCORE").append(" from T_EVA_GradetaskNodeInst g ").append(" left join T_EVA_PerfEvaObject o on g.FEVAOBJID =o.FID ").append(" left join T_EVA_PerfPeriod p on o.FPERIODID =p.FID ").append(" left join T_EVA_PerfPlan n on p.FPERFPLAN =n.FID ").append(" left join T_EVA_WFNodeDef w on g.FWFNODEID = w.FID ").append(" left join T_EVA_PerformanceRule r on p.FPERFRULEID = r.FID ").append(" where g.FEVAOBJID ='").append(evaObj).append("' and g.FNODEHANDLERID ='").append(personId).append("' and g.FIsEffective='1' and g.FCanEdit='1' and g.FScoreStatus in ('1','5')");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectSQL.toString());
            while (rowSet.next()) {
                if (++totalCount == 1) {
                    periodBean.setPeriodId(rowSet.getString("perfPeriod"));
                    periodBean.setStartDate(rowSet.getString("FEVASTARTDATE"));
                    periodBean.setEndDate(rowSet.getString("FEVAENDDATE"));
                    periodBean.setPlanId(rowSet.getString("FPERFPLAN"));
                    periodBean.setPlanName(rowSet.getString("planName"));
                    periodBean.setScoreWay(rowSet.getInt("FSCORINGWAY"));
                }
                EvaObjBean evaObjBean = new EvaObjBean();
                evaObjBean.setPersonId(rowSet.getString("FPERSONID"));
                evaObjBean.setPersonName(rowSet.getString("FNAME" + mlFlag));
                evaObjBean.setEvaObj(evaObj);
                evaObjBean.setPersonNumber(rowSet.getString("FNUMBER"));
                evaObjBean.setCurrentWFLevel(rowSet.getInt("FWFLEVEL"));
                evaObjBean.setGradeTaskNode(rowSet.getString("gradeTaskNode"));
                evaObjBean.setPeriod(rowSet.getString("perfPeriod"));
                evaObjBean.setPerfGradeEvaluate(rowSet.getString("FPERFGRADEEVALUATE"));
                evaObjBean.setNeedScore(rowSet.getString("FNEEDSCORE"));
                evaObjBeanList.add(evaObjBean);
            }
            periodBean.setEvaObjBeanList(evaObjBeanList);
            evaPerfPeriodBeanList.add(periodBean);
            teamBean.setEvaPerfPeriodBeanList(evaPerfPeriodBeanList);
            teamBean.setTotalCount(totalCount);
            teamBean.setTotalPage(totalPage);
            Gson gson = new Gson();
            String json = gson.toJson((Object)teamBean);
            return json;
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return null;
        }
    }

    public static int getPersonalTargetCount(Context ctx, boolean isOrg) {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        int dataCount = 0;
        try {
            String sql = "select count(gmr.FEvaObjID) as totalCount from T_EVA_GoalsMessageReceiver gmr left join t_eva_PerfEvaObject eva on gmr.FEvaObjID = eva.fid  where gmr.FReceiver = ? and gmr.FHandleStatus = '1' and gmr.FMsgType = '0' and gmr.FTargetStatus = '0' and gmr.FIsSelf = 1  and eva.FUnitGoalsStatus = 1 and eva.FPersonalGoalStatus in(0, 1)";
            sql = isOrg ? sql + " and FPerson = 'ORG'" : sql + " and FPerson <> 'ORG'";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{personId});
            if (rowSet != null) {
                while (rowSet.next()) {
                    dataCount = rowSet.getInt("totalCount");
                }
            }
        }
        catch (Exception e) {
            logger.error("get personalTargetCount err", (Throwable)e);
        }
        return dataCount;
    }

    public static int getMultiAssessmentCount(Context ctx, boolean isOrg) {
        Map<String, Set<String>> periodAndCountMap = null;
        try {
            periodAndCountMap = PerfPortalUtils.getMultiAssessmentPeriodList(ctx, isOrg ? TEAMEVAL : "0");
        }
        catch (BOSException e) {
            logger.error("getMultiAssessmentCount bos err", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("getMultiAssessmentCount sql err", (Throwable)e);
        }
        if (periodAndCountMap != null && periodAndCountMap.containsKey("count")) {
            Set<String> periodList = periodAndCountMap.get("count");
            return periodList.size();
        }
        return 0;
    }

    public static int getPersonalTargetCommentCount(Context ctx, boolean isOrg) throws EASBizException {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        int dataCount = 0;
        try {
            StringBuffer totalCountSQLBuffer = new StringBuffer("select count(distinct fevaObjid) from  T_EVA_GradeTaskNodeInst inst left join T_EVA_PerfEvaObject o on inst.FEvaObjID = o.FID where inst.FNodeHandlerID='");
            totalCountSQLBuffer.append(personId).append("' and inst.FScoreStatus not in ('").append("2").append("','").append("3").append("','").append("4").append("') and ").append(" inst.FIsSelf=").append(1).append(" and inst.FIsEffective='").append(TEAMEVAL).append("'");
            totalCountSQLBuffer.append(OrgAssessmentUtils.getPortalOrgFilterStr(null, PortalMesTypeEnum.personalSelfEva, isOrg));
            IRowSet totoalCountSet = DbUtil.executeQuery((Context)ctx, (String)totalCountSQLBuffer.toString());
            try {
                if (totoalCountSet != null && totoalCountSet.next()) {
                    dataCount = totoalCountSet.getInt(1);
                }
            }
            catch (SQLException e) {
                logger.error("SQLException: ", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new EASBizException(new NumericExceptionSubItem("perfweb", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETMYGOALSSCOREERR, ctx)));
        }
        return dataCount;
    }

    public static int getMyAchievementDataEntryCount(Context ctx, boolean isOrg) throws BOSException {
        if (isOrg) {
            return PerfPortalTodoUtil.getOrgAchievementDataEntryCount(ctx, HRFilterUtils.getCurrentPersonId((Context)ctx), "myAchivement");
        }
        return PerfPortalUtils.getAchievementDataEntryCount(ctx, "myAchivement", isOrg);
    }

    public static int getRespAchievementDataEntryCount(Context ctx, boolean isOrg) throws BOSException {
        return PerfPortalUtils.getAchievementDataEntryCount(ctx, ACHIVEMENTMANAGE, isOrg);
    }

    public static int getAchievementDataEntryCount(Context ctx, boolean isOrg) throws BOSException {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        if (isOrg) {
            return PerfPortalTodoUtil.getOrgAchievementDataEntryCount(ctx, personId, null);
        }
        return PerfPortalTodoUtil.getAchievementDataEntryCount(ctx, personId, "", isOrg);
    }

    public static int getAchievementDataEntryCount(Context ctx, String resourceTag, boolean isOrg) throws BOSException {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        IAchivementDataEntrior iAchivementDataEntrior = AchivementDataEntriorFactory.getRemoteInstance();
        StringBuffer sb = new StringBuffer("select id ");
        sb.append(" where person = '" + personId + "'").append(" and (target.actCompValState = '0'").append(" or target.actCompValState is null)").append(" and target.evaObj.personalGoalStatus =3").append(" and target.achivementEntryState <> 1");
        if ("myAchivement".equals(resourceTag)) {
            sb.append(" and ruleId.inputType = '0'");
        } else {
            sb.append(" and ruleId.inputType <> '0'");
        }
        sb.append(OrgAssessmentUtils.getPortalOrgFilterStr(null, PortalMesTypeEnum.personalAchivementInput, isOrg));
        CoreBaseCollection count = iAchivementDataEntrior.getCollection(sb.toString());
        return null == count ? 0 : count.size();
    }

    public static int getOthersTodoCount(Context ctx) {
        int othersTodoCount = 0;
        try {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("billEntity", (Object)"com.kingdee.shr.perfweb%", CompareType.LIKE));
            filterInfo.getFilterItems().add(new FilterItemInfo("personUserID", (Object)HRFilterUtils.getCurrentUserId((Context)ctx), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("isSendMsg", (Object)1, CompareType.EQUALS));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filterInfo);
            AssignCollection assigns = AssignFactory.getRemoteInstance().getCollection(evi);
            if (assigns != null && !assigns.isEmpty()) {
                othersTodoCount = assigns.size();
            }
        }
        catch (Exception e) {
            logger.error("get othersTodoCount err", (Throwable)e);
        }
        return othersTodoCount;
    }

    public static int getAchievementDataAuditCount(Context ctx, boolean isOrg) throws BOSException {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        IAchivementDataAuditor iAchivementDataAuditor = AchivementDataAuditorFactory.getRemoteInstance();
        StringBuffer sb = new StringBuffer("select id ");
        sb.append(" where person = '" + personId + "'").append(" and (target.actCompValState = '0'").append(" or target.actCompValState is null)");
        if (isOrg) {
            sb.append("and  target.evaObj.isOrg = '1'");
        } else {
            sb.append("and  target.evaObj.isOrg <> '1'");
        }
        sb.append(" and target.achivementEntryState = 1").append(" and target.evaObj.personalGoalStatus =3");
        CoreBaseCollection count = iAchivementDataAuditor.getCollection(sb.toString());
        return null == count ? 0 : count.size();
    }

    public static int getOthersPerfCount(Context ctx, boolean isOrg) throws BOSException {
        int count = 0;
        HashMap<String, Integer> countMap = PerfPortalUtils.getOthersPerfCountMap(ctx, isOrg);
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            try {
                count += entry.getValue().intValue();
            }
            catch (Exception e) {
                logger.error("[perfweb]getOthersPerfCount have error!", (Throwable)e);
            }
        }
        return count;
    }

    public static HashMap<String, Integer> getOthersPerfCountMap(Context ctx, boolean isOrg) throws BOSException {
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        for (Map.Entry<String, String> entry : OTHERTODO.entrySet()) {
            try {
                Method method = Class.forName(invokeClass).getMethod(entry.getValue(), Context.class, Boolean.TYPE);
                countMap.put(entry.getKey(), (Integer)method.invoke(null, ctx, isOrg));
            }
            catch (Exception e) {
                logger.error("[perfweb]getOthersPerfCountMap invoke have error!", (Throwable)e);
            }
        }
        return countMap;
    }

    public static int getEvaResultCount(Context ctx, boolean isOrg) throws BOSException {
        OrgEvaResultSummaryCollection coll;
        int count = 0;
        EntityViewInfo vi = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        vi.setSelector(selectorItemCollection);
        vi.setFilter(PerfPortalUtils.getEvaResultFilter(ctx, isOrg));
        count = isOrg ? (null == (coll = OrgEvaResultSummaryFactory.getLocalInstance(ctx).getOrgEvaResultSummaryCollection(vi)) ? 0 : coll.size()) : (null == (coll = EvaResultSummaryFactory.getLocalInstance(ctx).getEvaResultSummaryCollection(vi)) ? 0 : coll.size());
        return count;
    }

    public static int getTargetMakeSureCount(Context ctx, boolean isOrg) throws BOSException {
        int count = 0;
        EntityViewInfo vi = new EntityViewInfo();
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        vi.setSelector(selectorItemCollection);
        FilterInfo filterInfo = new FilterInfo();
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        filterInfo.getFilterItems().add(new FilterItemInfo("unitGoalsStatus", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("personalGoalStatus", (Object)3, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("workFlowStatus", (Object)0, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("targetMakeSure", (Object)1, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
        if (isOrg) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isOrg", (Object)1, CompareType.EQUALS));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("isOrg", (Object)0, CompareType.EQUALS));
        }
        vi.setFilter(filterInfo);
        PerfEvaObjectCollection coll = PerfEvaObjectFactory.getLocalInstance(ctx).getPerfEvaObjectCollection(vi);
        count = null == coll ? 0 : coll.size();
        return count;
    }

    public static FilterInfo getEvaResultFilter(Context ctx, boolean isOrg) {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        try {
            String table = " T_EVA_EvaResultSummary ";
            if (isOrg) {
                table = " T_EVA_OrgEvaResultSummary ";
            }
            String sql = " select EvaResultSummary.fid from " + table + " EvaResultSummary inner join T_EVA_PerfPlan evaPlan on evaPlan.fid = EvaResultSummary.FEvaPlanID  where ((DATEADD(((case when evaPlan.FCONFIRMDAYS= 0 or evaPlan.FCONFIRMDAYS is null then 3600  else evaPlan.FCONFIRMDAYS end) * 86400), EvaResultSummary.FAUDITDATE) >now() and evaPlan.fneedConfirm =1 )  or (DATEADD(((case when evaPlan.FAPPEALDAYS= 0 or evaPlan.FAPPEALDAYS is null then 3600  else evaPlan.FAPPEALDAYS end) * 86400), EvaResultSummary.FAUDITDATE) >now() and evaPlan.fallowAppeal=1))  and ( EvaResultSummary.fconfirmState <> 2 and (EvaResultSummary.fconfirmState=1 or (EvaResultSummary.fappealState in (1,2) or EvaResultSummary.fappealState is null or EvaResultSummary.fappealState = '' )))";
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
            filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)3, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("period.evaPeriodStatus", (Object)100, CompareType.NOTEQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("perfModel", (Object)"pER9PCMLSzypG7wVLbGZqqtdChg=", CompareType.NOTEQUALS));
            FilterInfo personFilterInfo = new FilterInfo();
            if (isOrg) {
                PerfEvaluAdminResponsorCollection responsorCollection = PerfEvaluAdminResponsorFactory.getRemoteInstance().getPerfEvaluAdminResponsorCollection("select evaObj.id where person.id = '" + personId + "'");
                PerfOrgEvaSumResponsorCollection perfOrgEvaSumResponsorCollection = PerfOrgEvaSumResponsorFactory.getRemoteInstance().getPerfOrgEvaSumResponsorCollection("select OrgEvaResultSummaryId where person.id = '" + personId + "'");
                HashSet<String> evaObjSet = null;
                if (responsorCollection != null && responsorCollection.size() > 0) {
                    evaObjSet = new HashSet<String>();
                    Iterator iterator = responsorCollection.iterator();
                    while (iterator.hasNext()) {
                        PerfEvaluAdminResponsorInfo next = (PerfEvaluAdminResponsorInfo)iterator.next();
                        evaObjSet.add(next.getEvaObj().getId().toString());
                    }
                }
                HashSet<String> ids = null;
                if (perfOrgEvaSumResponsorCollection != null && perfOrgEvaSumResponsorCollection.size() > 0) {
                    ids = new HashSet<String>();
                    Iterator iterator = perfOrgEvaSumResponsorCollection.iterator();
                    while (iterator.hasNext()) {
                        PerfOrgEvaSumResponsorInfo next = (PerfOrgEvaSumResponsorInfo)iterator.next();
                        ids.add(next.getOrgEvaResultSummaryId());
                    }
                }
                if (!CollectionUtils.isEmpty(evaObjSet)) {
                    personFilterInfo.getFilterItems().add(new FilterItemInfo("evaObj.id", evaObjSet, CompareType.INCLUDE));
                } else {
                    personFilterInfo.getFilterItems().add(new FilterItemInfo("evaObj.endWay", (Object)"4"));
                }
                if (!CollectionUtils.isEmpty(ids)) {
                    personFilterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
                }
                if (personFilterInfo.getFilterItems().size() == 2) {
                    personFilterInfo.setMaskString("(#0 or #1)");
                }
            } else {
                personFilterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
            }
            filterInfo.mergeFilter(personFilterInfo, "and");
            if (!isOrg) {
                filterInfo.mergeFilter(PerfPortalUtils.getSumEvaResultFilter(ctx, isOrg), "or");
            }
        }
        catch (BOSException e) {
            logger.error("perfweb-PerfPortalUtils-getOthersPerfToDoFilter have error!");
        }
        return filterInfo;
    }

    public static FilterInfo getSumEvaResultFilter(Context ctx, boolean isOrg) {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        FilterInfo filterInfo = new FilterInfo();
        try {
            String table = " T_EVA_EvaResultSummary ";
            if (isOrg) {
                table = " T_EVA_OrgEvaResultSummary ";
            }
            String sql = " select EvaResultSummary.fid from " + table + " EvaResultSummary inner join  T_EVA_SummaryPersonEvaObject tt on   EvaResultSummary.FSummaryPersonEvaObject=tt.fid left join  T_Eva_PerfSummarySchemeBase evaPlan on evaPlan.fid = tt.FPerfSummarySchemeBase  where ((DATEADD(((case when evaPlan.FCONFIRMDAYS= 0 or evaPlan.FCONFIRMDAYS is null then 3600  else evaPlan.FCONFIRMDAYS end) * 86400), EvaResultSummary.FAUDITDATE) >now() and evaPlan.fneedConfirm =1 )  or (DATEADD(((case when evaPlan.FAPPEALDAYS= 0 or evaPlan.FAPPEALDAYS is null then 3600  else evaPlan.FAPPEALDAYS end) * 86400), EvaResultSummary.FAUDITDATE) >now() and evaPlan.fallowAppeal=1))  and ( EvaResultSummary.fconfirmState <> 2 and (EvaResultSummary.fconfirmState=1 or (EvaResultSummary.fappealState in (1,2) or EvaResultSummary.fappealState is null or EvaResultSummary.fappealState = '' )))";
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
            filterInfo.getFilterItems().add(new FilterItemInfo("billState", (Object)3, CompareType.EQUALS));
            FilterInfo personFilterInfo = new FilterInfo();
            if (isOrg) {
                PerfEvaluAdminResponsorCollection responsorCollection = PerfEvaluAdminResponsorFactory.getRemoteInstance().getPerfEvaluAdminResponsorCollection("select evaObj.id where person.id = '" + personId + "'");
                HashSet<String> evaObjSet = null;
                if (responsorCollection != null && responsorCollection.size() > 0) {
                    evaObjSet = new HashSet<String>();
                    Iterator iterator = responsorCollection.iterator();
                    while (iterator.hasNext()) {
                        PerfEvaluAdminResponsorInfo next = (PerfEvaluAdminResponsorInfo)iterator.next();
                        evaObjSet.add(next.getEvaObj().getId().toString());
                    }
                }
                if (!CollectionUtils.isEmpty(evaObjSet)) {
                    personFilterInfo.getFilterItems().add(new FilterItemInfo("summaryPersonEvaObject.id", evaObjSet, CompareType.INCLUDE));
                }
            } else {
                personFilterInfo.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId, CompareType.EQUALS));
            }
            filterInfo.mergeFilter(personFilterInfo, "and");
        }
        catch (BOSException e) {
            logger.error("perfweb-PerfPortalUtils-getOthersPerfToDoFilter have error!");
        }
        return filterInfo;
    }

    static {
        OTHERTODO.put("evaResultTodo", "getEvaResultCount");
        OTHERTODO.put("targetMakeSureTodo", "getTargetMakeSureCount");
        logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.util.PerfPortalUtils");
    }
}

