/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.IPosition;
import com.kingdee.eas.basedata.org.PositionCollection;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.IEmpPosOrgRelation;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalfile.PerfFileInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.EmailSendFacadeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EndWayEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageHandlerStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.GoalsMessageReceiverInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.IEmailSendFacade;
import com.kingdee.shr.perfweb.app.base.evalplan.IEvaResultSummary;
import com.kingdee.shr.perfweb.app.base.evalplan.IGoalsMessageReceiver;
import com.kingdee.shr.perfweb.app.base.evalplan.IIndicatorTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IOrgEvaResultSummary;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfEvaObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IPerfGoalsFillerObject;
import com.kingdee.shr.perfweb.app.base.evalplan.IRecordTarget;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.IndicatorTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.OrgEvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjMatrixWorkFlowInstCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectMatrixWorkFlowCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectWFStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsFillerObjectCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfGoalsFillerObjectFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPlanInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PersonBatchFacadeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.RecordTargetFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.ScoreTaskStatusEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetEvaluModeEnum;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetNodeCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetNodeFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.TargetNodeInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.EvaluFormAreaBaseInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.IPWorkFlowDef;
import com.kingdee.shr.perfweb.app.base.evalrule.IWFNodeDef;
import com.kingdee.shr.perfweb.app.base.evalrule.IsNeedEnum;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PWorkFlowDefInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.WFNodeDefInfo;
import com.kingdee.shr.perfweb.app.base.notice.MessageTemplateDefineCollection;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.app.workflow.AsignmentPoolInfo;
import com.kingdee.shr.perfweb.app.workflow.CanEditEnum;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTargetInstInfo;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstCollection;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstFactory;
import com.kingdee.shr.perfweb.app.workflow.GradeTaskNodeInstInfo;
import com.kingdee.shr.perfweb.app.workflow.IGradeTaskNodeInst;
import com.kingdee.shr.perfweb.app.workflow.PerfWorkFlowFacadeControllerBean;
import com.kingdee.shr.perfweb.app.workflow.PerfWorkFlowFacadeFactory;
import com.kingdee.shr.perfweb.app.workflow.ScoreStatusEnum;
import com.kingdee.shr.perfweb.app.workflow.TaskStatusEnum;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.PerfWorkflowOptimizationUtils;
import com.kingdee.shr.perfweb.util.PersonInchargeUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.CurrentUserUtil;
import com.kingdee.shr.perfweb.utils.IndicatorUtils;
import com.kingdee.shr.perfweb.utils.MessageTemplateUtils;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PerfwebStrUtils;
import com.kingdee.shr.perfweb.utils.ProcessorUtils;
import com.kingdee.shr.perfweb.utils.SSOLoginUtils;
import com.kingdee.shr.perfweb.workflow.serviceImpl.WorkFlowEngine;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class WorkFlowUtils {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.util.PerfWorkFlowUtils");
    public static final String BUSINESS_TYPE = "100";

    public static synchronized String createWFNumber() {
        String number = "WF" + new SimpleDateFormat("yyyyMMdd").format(new Date());
        int maxNumber = 0;
        try {
            IPWorkFlowDef iPworkFlow = PWorkFlowDefFactory.getRemoteInstance();
            PWorkFlowDefCollection workFlowColl = iPworkFlow.getPWorkFlowDefCollection("where number like '" + number + "%' order by number desc");
            if (workFlowColl != null && !workFlowColl.isEmpty()) {
                Iterator archIter = workFlowColl.iterator();
                PWorkFlowDefInfo workFlowInfo = null;
                while (archIter.hasNext()) {
                    workFlowInfo = (PWorkFlowDefInfo)archIter.next();
                    int workFlowNumber = Integer.parseInt(workFlowInfo.getNumber().substring(10));
                    if (workFlowNumber <= maxNumber) continue;
                    maxNumber = workFlowNumber;
                }
            }
        }
        catch (BOSException e) {
            logger.error("generating process coding error, detailed information:" + e.getMessage());
        }
        number = ++maxNumber < 10 ? number + "0" + maxNumber : number + maxNumber;
        return number;
    }

    public static List<Map<String, String>> getDirectSuperior(Context ctx, String person) {
        ArrayList<Map<String, String>> superiorList = new ArrayList<Map<String, String>>();
        try {
            IPosition iposition;
            PositionCollection posColl;
            new SimpleDateFormat("yyyy-MM-dd");
            Date now = new Date();
            String selectEmpOrgRelation = "select FPositionID from T_HR_EmpOrgRelation where FPersonID='" + person + "' and FEFFDT>={ts'" + now + "'} and FEFFDT<={ts'" + now + "'}";
            String curPersonPosition = "";
            String superiorPosition = "";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectEmpOrgRelation);
            if (rs.next()) {
                curPersonPosition = rs.getString("FPositionID");
            }
            if ((posColl = (iposition = PositionFactory.getLocalInstance((Context)ctx)).getPositionCollection(" where id='" + curPersonPosition + "'")) != null && posColl.size() > 0) {
                superiorPosition = posColl.get(0).getParent().getId().toString();
            }
            String selectSuperiorPerson = "select FPersonID from T_HR_EmpOrgRelation where FPositionID='" + superiorPosition + "' and FEFFDT>={ts'" + now + "'} and FEFFDT<={ts'" + now + "'}";
            IRowSet superiorRS = DbUtil.executeQuery((Context)ctx, (String)selectSuperiorPerson);
            while (superiorRS.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("person", superiorRS.getString("FPersonID"));
                superiorList.add(map);
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
        }
        return superiorList;
    }

    public static void getIndirectSuperior(Context ctx, String person, List<Map<String, String>> hanlerList) {
        Map<String, PersonCollection> secondMap;
        PersonCollection secondPersonColl;
        HashSet<String> personIdSet = new HashSet<String>();
        personIdSet.add(person);
        Map<String, PersonCollection> map = WorkFlowEngine.getInstance().getDirectSuperior(ctx, personIdSet);
        PersonCollection personColl = map.get(person);
        HashSet<String> secondIdSet = new HashSet<String>();
        if (personColl != null && personColl.size() > 0) {
            for (int i = 0; i < personColl.size(); ++i) {
                PersonInfo personInfo = personColl.get(i);
                secondIdSet.add(personInfo.getId().toString());
            }
        }
        if (secondIdSet.size() > 0 && (secondPersonColl = (secondMap = WorkFlowEngine.getInstance().getDirectSuperior(ctx, secondIdSet)).get(person)) != null && secondPersonColl.size() > 0) {
            for (int i = 0; i < secondPersonColl.size(); ++i) {
                HashMap<String, String> handlerMap = new HashMap<String, String>();
                PersonInfo personInfo = secondPersonColl.get(i);
                handlerMap.put("person", personInfo.getId().toString());
                handlerMap.put("personName", personInfo.getName());
                hanlerList.add(handlerMap);
            }
        }
    }

    public static PersonCollection getSupervisor(Context ctx, String personId) {
        PersonCollection person = null;
        try {
            IPersonFacade iPersonFacade = PersonFacadeFactory.getLocalInstance((Context)ctx);
            person = iPersonFacade.getSupervisor(BOSUuid.read((String)personId));
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (UuidException e) {
            logger.error("UuidException: ", (Throwable)e);
        }
        return person;
    }

    public static PersonCollection getPrimarySubordinate(Context ctx, String personId) {
        PersonCollection person = null;
        try {
            IPersonFacade iPersonFacade = PersonFacadeFactory.getLocalInstance((Context)ctx);
            person = iPersonFacade.getPrimarySubordinate(BOSUuid.read((String)personId));
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (UuidException e) {
            logger.error("UuidException: ", (Throwable)e);
        }
        return person;
    }

    public static PersonCollection getColleague(Context ctx, String personId) {
        PersonCollection person = null;
        try {
            IPersonFacade iPersonFacade = PersonFacadeFactory.getLocalInstance((Context)ctx);
            person = iPersonFacade.getColleague(BOSUuid.read((String)personId));
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (UuidException e) {
            logger.error("UuidException: ", (Throwable)e);
        }
        return person;
    }

    public static PersonCollection getIndirectorSuperior(Context ctx, String personId) {
        PersonCollection person = null;
        try {
            IPersonFacade iPersonFacade = PersonFacadeFactory.getLocalInstance((Context)ctx);
            person = iPersonFacade.getDirector(BOSUuid.read((String)personId));
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        catch (UuidException e) {
            logger.error("UuidException: ", (Throwable)e);
        }
        return person;
    }

    public static Map getSupervisor(Context ctx, Set personIdSet, boolean isPrimary) {
        Map supervisorMap = new HashMap();
        try {
            supervisorMap = PersonBatchFacadeFactory.getLocalInstance(ctx).getSupervisor(personIdSet, "00000000-0000-0000-0000-000000000001396FCAD0", isPrimary);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return supervisorMap;
    }

    public static void setValueForHandlerList(Context ctx, PersonCollection personColl, List<Map<String, String>> hanlerList, String position, Boolean isOrg, Boolean isValidInCountOrOnTheStrength) {
        if (isOrg == null) {
            isOrg = false;
        }
        if (isValidInCountOrOnTheStrength == null) {
            isValidInCountOrOnTheStrength = true;
        }
        PersonCollection personNewColl = new PersonCollection();
        try {
            int i;
            IEmpPosOrgRelation iEmpPosOrgRelation = EmpPosOrgRelationFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("person.employeeType"));
            viewInfo.getSelector().add(new SelectorItemInfo("person.employeeType.isOnTheStrength"));
            viewInfo.getSelector().add(new SelectorItemInfo("person.employeeType.isInCount"));
            if (null != personColl && personColl.size() > 0) {
                int psize = personColl.size();
                for (i = 0; i < psize; ++i) {
                    FilterInfo filter = new FilterInfo();
                    FilterItemInfo filterItem = new FilterItemInfo("person.id", (Object)personColl.get(i).getId().toString(), CompareType.EQUALS);
                    filter.getFilterItems().add(filterItem);
                    if (isValidInCountOrOnTheStrength.booleanValue()) {
                        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isInCount", (Object)1, CompareType.EQUALS));
                        filter.getFilterItems().add(new FilterItemInfo("person.employeeType.isOnTheStrength", (Object)1, CompareType.EQUALS));
                        filter.setMaskString("#0 AND (#1 OR #2)");
                    } else {
                        filter.setMaskString("#0");
                    }
                    viewInfo.setFilter(filter);
                    EmpPosOrgRelationCollection empPosOrgColl = iEmpPosOrgRelation.getEmpPosOrgRelationCollection(viewInfo);
                    if (null == empPosOrgColl || empPosOrgColl.size() <= 0) continue;
                    personNewColl.add(personColl.get(i));
                }
            }
            if (personNewColl != null && personNewColl.size() > 0) {
                int size = personNewColl.size();
                for (i = 0; i < size; ++i) {
                    HashMap<String, String> handlerMap = new HashMap<String, String>();
                    PersonInfo personInfo = personNewColl.get(i);
                    handlerMap.put("personName", personInfo.getName(ctx.getLocale()));
                    handlerMap.put("person", personInfo.getId().toString());
                    handlerMap.put("personNumber", personInfo.getNumber());
                    if (!StringUtils.isEmpty((CharSequence)position)) {
                        handlerMap.put("processorPosition", position);
                    } else {
                        handlerMap.put("processorPosition", ProcessorUtils.getPrimaryPosition(ctx, personInfo.getId().toString()));
                    }
                    hanlerList.add(handlerMap);
                }
            } else {
                HashMap<String, String> handlerMap = new HashMap<String, String>();
                handlerMap.put("person", "");
                handlerMap.put("personName", "");
                handlerMap.put("processorPosition", position);
                handlerMap.put("personNumber", "");
                hanlerList.add(handlerMap);
            }
        }
        catch (BOSException e) {
            logger.error("\u3010PERFWEB\u3011-SAVEDEALPERSONERR\uff01", (Throwable)e);
        }
    }

    public static WFNodeDefCollection getNodeCollectionByEvaObj(Context ctx, String evaObj, int level) {
        WFNodeDefCollection wfNodeDefColl = null;
        try {
            IWFNodeDef iwfNodeDef = WFNodeDefFactory.getLocalInstance(ctx);
            PerfEvaObjectInfo evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
            wfNodeDefColl = iwfNodeDef.getWFNodeDefCollection(" where workflow='" + evaObjInfo.getWorkFlow().getId().toString() + "' and level='" + level + "'");
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return wfNodeDefColl;
    }

    public static EvaluFormAreaBaseCollection getEvaluFormAreaBaseCollectionByEvaObj(Context ctx, String evaObj, String workFlow) throws BOSException {
        EvaluFormAreaBaseCollection evaluFormABColl = null;
        PerfEvaObjectInfo evaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
        PerfPeriodInfo periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, evaObjInfo.getPeriod().getId().toString());
        PerformanceRuleInfo perfRuleInfo = periodInfo.getPerfRule();
        if (evaObjInfo.getCanAdjustEvaluer().getValue() == 0) {
            evaluFormABColl = GetEntityInfoUtils.getEvaluFormAreaBaseCollection(ctx, perfRuleInfo.getId().toString());
        } else {
            int i;
            IndicatorTargetCollection indicatorTargetColl = new IndicatorTargetCollection();
            RecordTargetCollection recordTargetColl = null;
            indicatorTargetColl = GetEntityInfoUtils.getIndicatorTargetCollByWorkFlow(ctx, evaObj, workFlow);
            recordTargetColl = GetEntityInfoUtils.getRecordTargetCollByWorkFlow(ctx, evaObj, workFlow);
            HashSet<String> set = new HashSet<String>();
            for (i = 0; i < indicatorTargetColl.size(); ++i) {
                set.add(indicatorTargetColl.get(i).getAreaBase().getId().toString());
            }
            for (i = 0; i < recordTargetColl.size(); ++i) {
                set.add(recordTargetColl.get(i).getAreaBase().getId().toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("areaWeight"));
            view.setFilter(filter);
            view.setSelector(sic);
            evaluFormABColl = EvaluFormAreaBaseFactory.getLocalInstance(ctx).getEvaluFormAreaBaseCollection(view);
        }
        return evaluFormABColl;
    }

    @Deprecated
    public static void createNodeInst(Context ctx, PerfEvaObjectInfo evaObjInfo, AsignmentPoolInfo asignmentInfo, int level, String createType) throws BOSException {
        ConcurrentHashMap<String, WFNodeDefCollection> wfNodeDefMap = new ConcurrentHashMap<String, WFNodeDefCollection>(10);
        try {
            String evaObj = evaObjInfo.getId().toString();
            int noHandlerSize = 0;
            int nodeSize = 0;
            boolean isHandUp = true;
            if (level == 1) {
                PerfWorkFlowFacadeFactory.getLocalInstance(ctx).calcEvaSumScore(evaObj, null, EndWayEnum.NOMALWAY, true);
                if (asignmentInfo != null && asignmentInfo.getIsCreateInst().getValue().equals("1")) {
                    return;
                }
            }
            String key = evaObjInfo.getWorkFlow().getId().toString() + level;
            WFNodeDefCollection wfNodeColl = null;
            if (wfNodeDefMap.containsKey(key)) {
                wfNodeColl = (WFNodeDefCollection)((Object)wfNodeDefMap.get(key));
            } else {
                wfNodeColl = WorkFlowUtils.getNodeCollectionByEvaObj(ctx, evaObj, level);
                wfNodeDefMap.put(key, wfNodeColl);
            }
            IWFNodeDef iwfNodeDef = WFNodeDefFactory.getLocalInstance(ctx);
            nodeSize = wfNodeColl.size();
            if (wfNodeColl != null && nodeSize > 0) {
                for (int i = 0; i < nodeSize; ++i) {
                    String processorPosition = "";
                    WFNodeDefInfo wfNodeInfo = wfNodeColl.get(i);
                    WFNodeDefCollection refNodeColl = iwfNodeDef.getWFNodeDefCollection(" where workflow='" + wfNodeInfo.getWorkflow().getId().toString() + "' and nodeName='" + wfNodeInfo.getRefObj() + "' and level<" + level);
                    String nodeId = wfNodeInfo.getId().toString();
                    HashSet<HashMap> handlerSet = new HashSet<HashMap>();
                    if (refNodeColl != null && refNodeColl.size() > 0) {
                        WFNodeDefInfo refNodeInfo = refNodeColl.get(0);
                        GradeTaskNodeInstCollection gradeTaskNodeInstColl = GetEntityInfoUtils.getGradeTaskNodeInstCollection(ctx, evaObj, refNodeInfo.getId().toString(), null);
                        if (gradeTaskNodeInstColl != null && gradeTaskNodeInstColl.size() > 0) {
                            for (int j = 0; j < gradeTaskNodeInstColl.size(); ++j) {
                                GradeTaskNodeInstInfo gradeTaskNodeInfo = gradeTaskNodeInstColl.get(j);
                                processorPosition = gradeTaskNodeInfo.getProcessorPosition();
                                List<Map<String, String>> handlerList = WorkFlowEngine.getInstance().getNodeHandler(ctx, evaObj, processorPosition, nodeId);
                                for (Map<String, String> handler : handlerList) {
                                    handlerSet.add((HashMap)handler);
                                }
                            }
                        }
                    } else {
                        String evaObjPosition = evaObjInfo.getPerfFile().getPosition().getId().toString();
                        List<Map<String, String>> handlerList = WorkFlowEngine.getInstance().getNodeHandler(ctx, evaObj, evaObjPosition, nodeId);
                        for (Map<String, String> handler : handlerList) {
                            handlerSet.add((HashMap)handler);
                        }
                    }
                    String redirectUrl = "";
                    for (HashMap handler : handlerSet) {
                        String person = (String)handler.get("person");
                        UserInfo userInfo = CurrentUserUtil.getUserInfoByPersonId(ctx, person);
                        if (null != userInfo && null != userInfo.getNumber()) {
                            redirectUrl = SSOLoginUtils._createSsoRedirectUrl(ctx, userInfo.getNumber());
                            isHandUp = false;
                        } else {
                            ++noHandlerSize;
                        }
                        String personName = (String)handler.get("personName");
                        processorPosition = (String)handler.get("processorPosition");
                        int isSelf = 0;
                        if (wfNodeInfo.getNodeHandler().equals(BUSINESS_TYPE) && person.equals(evaObjInfo.getPerfFile().getPerson().getId().toString())) {
                            isSelf = 1;
                        }
                        WorkFlowEngine.getInstance().createNodeInst(ctx, evaObjInfo, asignmentInfo, wfNodeInfo, person, personName, createType, isSelf, processorPosition);
                    }
                    if ((noHandlerSize <= 0 || noHandlerSize != handlerSet.size()) && handlerSet.size() != 0) continue;
                    isHandUp = true;
                }
            }
            if (level == 1 && isHandUp) {
                WorkFlowUtils.writeBackWorkFlowStatusForEvaObj(ctx, evaObjInfo, PerfEvaObjectWFStatusEnum.HANGUP);
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-CREATENODEINSTERR...", (Throwable)e);
            throw new BOSException();
        }
    }

    public static void createEmailTask(Context ctx, PerfEvaObjectInfo evaObjInfo, WFNodeDefInfo wfNodeInfo, HashMap<String, String> handler, int level, String redirectUrl, int isSelf) throws BOSException {
        String evaObj = evaObjInfo.getId().toString();
        String msgTempID = "";
        boolean isOrg = OrgAssessmentUtils.isOrgAssessment(evaObjInfo);
        msgTempID = isOrg ? (isSelf == 1 ? "6a8AAAAHf4BaQ0I5" : "6a8AAAAHf3BaQ0I5") : (isSelf == 1 ? "viEAAAQDKgZaQ0I5" : "viEAAAQDKihaQ0I5");
        HashMap<String, MessageTemplateDefineCollection> msgTempColl = MessageTemplateUtils.getMsgTempColl(ctx, evaObj.split(","), null, msgTempID, 1, isOrg);
        MessageTemplateDefineCollection msgcoll = msgTempColl.get(evaObj);
        String emailTitle = "";
        String emailContent = "";
        if (msgcoll != null) {
            int size = msgcoll.size();
            for (int j = 0; j < size; ++j) {
                if (msgcoll.get(j).getMessageType() == null || msgcoll.get(j).getMessageType().getValue() != 2) continue;
                emailContent = msgcoll.get(j).getTemplateContent();
                emailTitle = msgcoll.get(j).getTemplateTitle();
            }
        }
        IEmailSendFacade iEmailSendFacade = EmailSendFacadeFactory.getLocalInstance(ctx);
        if (level == 1) {
            int isSendEmail = 0;
            if (evaObjInfo.getIsSendEmail() != null) {
                isSendEmail = evaObjInfo.getIsSendEmail().getValue();
            }
            if (isSendEmail == 1) {
                iEmailSendFacade.createEmailTask(handler.get("person"), evaObj, emailContent, emailTitle, "0");
            } else {
                String isNeedEmailNotify = wfNodeInfo.getEmailNotification().getValue();
                if (isNeedEmailNotify.equals(IsNeedEnum.NEEDMUST.getValue())) {
                    iEmailSendFacade.createEmailTask(handler.get("person"), evaObj, emailContent, emailTitle, "0");
                }
            }
        }
    }

    public static String getNodeHandler(Context ctx, String handlerType, String handler) {
        PositionCollection positionColl;
        String handlerName = null;
        if (StringUtils.isEmpty((CharSequence)handlerType)) {
            return handlerName;
        }
        if (handlerType.equals("0")) {
            if (BUSINESS_TYPE.equals(handler)) {
                handlerName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SELF, ctx);
            } else if ("200".equals(handler)) {
                handlerName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUPERIOR, ctx);
            } else if ("300".equals(handler)) {
                handlerName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.INDIRECTSUPERIOR, ctx);
            } else if ("400".equals(handler)) {
                handlerName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SUBORDINATE, ctx);
            } else if ("500".equals(handler)) {
                handlerName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.COLLEAGUE, ctx);
            } else if ("700".equals(handler)) {
                handlerName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MYRESPONSOR, ctx);
            } else if ("800".equals(handler)) {
                handlerName = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.CHARGER, ctx);
            }
        } else if (handlerType.equals("1")) {
            PersonInfo personInfo = CurrentUserUtil.getPersonById(ctx, handler);
            if (personInfo != null) {
                handlerName = personInfo.getName();
            }
        } else if (handlerType.equals("2") && (positionColl = GetEntityInfoUtils.getPositionCollection(ctx, handler)) != null && positionColl.size() > 0) {
            handlerName = positionColl.get(0).getName();
        }
        return handlerName;
    }

    public static void writeBackWorkFlowStatusForEvaObj(Context ctx, PerfEvaObjectInfo perfEvaObjectInfo, PerfEvaObjectWFStatusEnum wfStatusEnum) throws BOSException, EASBizException {
        IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("workFlowStatus"));
        perfEvaObjectInfo.setWorkFlowStatus(wfStatusEnum);
        iPerfEvaObject.updatePartial(perfEvaObjectInfo, sic);
    }

    public static void writeBackEndWayForEvaObj(Context ctx, String evaObj, EndWayEnum endWayEnum) throws BOSException, EASBizException {
        IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("endWay"));
        PerfEvaObjectInfo perfEvaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
        perfEvaObjectInfo.setEndWay(endWayEnum);
        iPerfEvaObject.updatePartial(perfEvaObjectInfo, sic);
    }

    public static PositionCollection getPersonPositionColl(Context ctx, String personId) {
        PositionCollection positionColl = null;
        try {
            IPersonPosition ipersonPosition = PersonPositionFactory.getLocalInstance((Context)ctx);
            PersonPositionCollection personPositionColl = ipersonPosition.getPersonPositionCollection(" where person='" + personId + "'");
            if (personPositionColl != null && personPositionColl.size() > 0) {
                positionColl = GetEntityInfoUtils.getPositionCollection(ctx, personPositionColl.get(0).getPrimaryPosition().getId().toString());
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return positionColl;
    }

    public static void writeBackWorkFlowStatusForEvaResult(Context ctx, String evaObj, PerfEvaObjectWFStatusEnum wfStatusEnum) throws BOSException, EASBizException {
        IEvaResultSummary ievaResultSummary = EvaResultSummaryFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("flowStatus"));
        EvaResultSummaryInfo evaResultSummaryInfo = GetEntityInfoUtils.getEvaResultSummaryInfoByEvaObj(ctx, evaObj);
        if (null != evaResultSummaryInfo) {
            evaResultSummaryInfo.setFlowStatus(wfStatusEnum);
            ievaResultSummary.updatePartial(evaResultSummaryInfo, sic);
        }
    }

    public static void writeBackWorkFlowStatusForEvaResult(Context ctx, PerfEvaObjectCollection evaObjColl) throws BOSException, EASBizException {
        IEvaResultSummary ievaResultSummary = EvaResultSummaryFactory.getLocalInstance(ctx);
        IOrgEvaResultSummary iOrgEvaResultSummary = OrgEvaResultSummaryFactory.getLocalInstance(ctx);
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        CoreBaseCollection OrgcoreBaseCollection = new CoreBaseCollection();
        for (int i = 0; i < evaObjColl.size(); ++i) {
            PerfEvaObjectInfo perfEvaObjectInfo = evaObjColl.get(i);
            if (perfEvaObjectInfo.getIsOrg().getValue() == 1) {
                OrgEvaResultSummaryInfo orgEvaResultSummaryInfo = iOrgEvaResultSummary.getOrgEvaResultSummaryInfo("where evaObj= '" + perfEvaObjectInfo.getId().toString() + "'");
                orgEvaResultSummaryInfo.setFlowStatus(perfEvaObjectInfo.getWorkFlowStatus());
                OrgcoreBaseCollection.add((CoreBaseInfo)orgEvaResultSummaryInfo);
                if (OrgcoreBaseCollection.size() <= 0 || OrgcoreBaseCollection.size() % 200 != 0) continue;
                ievaResultSummary.updateBatchData(OrgcoreBaseCollection);
                OrgcoreBaseCollection.clear();
                continue;
            }
            EvaResultSummaryInfo evaResultSummaryInfo = ievaResultSummary.getEvaResultSummaryInfo("where evaObj= '" + perfEvaObjectInfo.getId().toString() + "'");
            evaResultSummaryInfo.setFlowStatus(perfEvaObjectInfo.getWorkFlowStatus());
            coreBaseCollection.add((CoreBaseInfo)evaResultSummaryInfo);
            if (coreBaseCollection.size() <= 0 || coreBaseCollection.size() % 200 != 0) continue;
            ievaResultSummary.updateBatchData(coreBaseCollection);
            coreBaseCollection.clear();
        }
        if (coreBaseCollection.size() > 0) {
            ievaResultSummary.updateBatchData(coreBaseCollection);
            coreBaseCollection.clear();
        }
        if (OrgcoreBaseCollection.size() > 0) {
            iOrgEvaResultSummary.updateBatchData(OrgcoreBaseCollection);
            OrgcoreBaseCollection.clear();
        }
    }

    public static void writeStatusForOrgEvaResult(Context ctx, String evaObj, PerfEvaObjectWFStatusEnum wfStatusEnum) throws BOSException, EASBizException {
        IOrgEvaResultSummary orgEvaResultSummary = OrgEvaResultSummaryFactory.getLocalInstance(ctx);
        OrgEvaResultSummaryInfo orgEvaResultSummaryInfo = null;
        try {
            orgEvaResultSummaryInfo = orgEvaResultSummary.getOrgEvaResultSummaryInfo("where evaObj ='" + evaObj + "'");
        }
        catch (EASBizException e) {
            logger.error("getOrgEvaErr\uff1a" + e.getMessage());
            throw e;
        }
        if (null == orgEvaResultSummaryInfo) {
            logger.error("evaObj\uff1a" + evaObj + " evaResult not exist!");
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("flowStatus"));
        orgEvaResultSummaryInfo.setFlowStatus(wfStatusEnum);
        orgEvaResultSummary.updatePartial(orgEvaResultSummaryInfo, sic);
    }

    public static void undoGoalsMessage(Context ctx, PerfEvaObjectInfo evaObjectInfo) throws BOSException, EASBizException {
        IGoalsMessageReceiver igoalsMsgReceiver = GoalsMessageReceiverFactory.getLocalInstance(ctx);
        String evaObj = evaObjectInfo.getId().toString();
        CoreBaseCollection goalsMsgRecColl = new CoreBaseCollection();
        if (evaObjectInfo.getPersonalGoalStatus().getValue() != 3) {
            GoalsMessageReceiverCollection goalsMsgReceiverColl = igoalsMsgReceiver.getGoalsMessageReceiverCollection(" where evaObj='" + evaObj + "'");
            if (goalsMsgReceiverColl != null && goalsMsgReceiverColl.size() > 0) {
                int goalsMsgReceiverSize = goalsMsgReceiverColl.size();
                for (int i = 0; i < goalsMsgReceiverSize; ++i) {
                    GoalsMessageReceiverInfo goalsMsgReceiverInfo = goalsMsgReceiverColl.get(i);
                    goalsMsgReceiverInfo.setHandleStatus(GoalsMessageHandlerStatusEnum.DEALED);
                    goalsMsgRecColl.add((CoreBaseInfo)goalsMsgReceiverInfo);
                }
            }
            igoalsMsgReceiver.updateBatchData(goalsMsgRecColl);
        }
    }

    public static void batchUndoGoalsMessage(Context ctx, ArrayList<String> personalGoalsUnassignedEvaObjIdList) throws BOSException, EASBizException {
        IGoalsMessageReceiver igoalsMsgReceiver = GoalsMessageReceiverFactory.getLocalInstance(ctx);
        String evaObjIdCondition = "(" + PerfwebStrUtils.convertListToString(personalGoalsUnassignedEvaObjIdList) + ")";
        CoreBaseCollection goalsMsgRecColl = new CoreBaseCollection();
        GoalsMessageReceiverCollection goalsMsgReceiverColl = igoalsMsgReceiver.getGoalsMessageReceiverCollection(" where evaObj in " + evaObjIdCondition + "");
        if (goalsMsgReceiverColl != null && goalsMsgReceiverColl.size() > 0) {
            for (int i = 0; i < goalsMsgReceiverColl.size(); ++i) {
                GoalsMessageReceiverInfo goalsMsgReceiverInfo = goalsMsgReceiverColl.get(i);
                goalsMsgReceiverInfo.setHandleStatus(GoalsMessageHandlerStatusEnum.DEALED);
                goalsMsgRecColl.add((CoreBaseInfo)goalsMsgReceiverInfo);
                if (goalsMsgRecColl.size() <= 0 || goalsMsgRecColl.size() % PerfWorkflowOptimizationUtils.batchHandCount != 0) continue;
                igoalsMsgReceiver.updateBatchData(goalsMsgRecColl);
                goalsMsgRecColl.clear();
            }
            if (goalsMsgRecColl.size() > 0) {
                igoalsMsgReceiver.updateBatchData(goalsMsgRecColl);
                goalsMsgRecColl.clear();
            }
        }
    }

    public static void updateActiveNodeScoereStatus(Context ctx, String evaObj) throws BOSException, EASBizException {
        CoreBaseCollection gradeTNodeColl = new CoreBaseCollection();
        IGradeTaskNodeInst igradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance(ctx);
        String evaObjIdCondition = "('" + evaObj + "')";
        GradeTaskNodeInstCollection gradeTaskNodeColl = GetEntityInfoUtils.getEffectiveGradeTaskNodeInstColl(ctx, evaObjIdCondition);
        if (gradeTaskNodeColl != null && gradeTaskNodeColl.size() > 0) {
            for (int i = 0; i < gradeTaskNodeColl.size(); ++i) {
                GradeTaskNodeInstInfo gtNodeInstInfo = gradeTaskNodeColl.get(i);
                gtNodeInstInfo.getId().toString();
                HashMap<String, String> sumscoreMap = PerfWorkFlowFacadeControllerBean.getInstance().calcNodeSumScore(ctx, gtNodeInstInfo.getId().toString(), evaObj);
                String nodeSumscore = sumscoreMap.get("sumScore");
                gtNodeInstInfo.setScoreStatus(ScoreStatusEnum.SUBMIT);
                gtNodeInstInfo.setCanEdit(CanEditEnum.DISABLED);
                if (StringUtils.isEmpty((CharSequence)nodeSumscore)) {
                    nodeSumscore = null;
                }
                gtNodeInstInfo.put("nodeSumScore", nodeSumscore);
                gtNodeInstInfo.setIsEndProcess(YesOrNoEnum.YES);
                gradeTNodeColl.add((CoreBaseInfo)gtNodeInstInfo);
                if (gradeTNodeColl.size() % PerfWorkflowOptimizationUtils.batchHandCount != 0) continue;
                igradeTaskNodeInst.submitBatchData(gradeTNodeColl);
                gradeTNodeColl.clear();
            }
        }
        if (gradeTNodeColl.size() > 0) {
            igradeTaskNodeInst.submitBatchData(gradeTNodeColl);
            gradeTNodeColl.clear();
        }
    }

    public static void batchUpdateActiveNodeScoereStatus(Context ctx, List<String> evaObjIdList) throws BOSException, EASBizException {
        IGradeTaskNodeInst igradeTaskNodeInst = GradeTaskNodeInstFactory.getLocalInstance(ctx);
        if (!CollectionUtils.isEmpty(evaObjIdList)) {
            String evaObjIdCondition = "(" + PerfwebStrUtils.convertListToString(evaObjIdList) + ")";
            CoreBaseCollection gradeTNodeColl = new CoreBaseCollection();
            GradeTaskNodeInstCollection gradeTaskNodeColl = GetEntityInfoUtils.getEffectiveGradeTaskNodeInstColl(ctx, evaObjIdCondition);
            if (gradeTaskNodeColl != null && gradeTaskNodeColl.size() > 0) {
                for (int i = 0; i < gradeTaskNodeColl.size(); ++i) {
                    GradeTaskNodeInstInfo gtNodeInstInfo = gradeTaskNodeColl.get(i);
                    gtNodeInstInfo.getId().toString();
                    HashMap<String, String> sumscoreMap = PerfWorkFlowFacadeControllerBean.getInstance().calcNodeSumScore(ctx, gtNodeInstInfo.getId().toString(), gtNodeInstInfo.getEvaObj().getId().toString());
                    String nodeSumscore = sumscoreMap.get("sumScore");
                    gtNodeInstInfo.setScoreStatus(ScoreStatusEnum.SUBMIT);
                    gtNodeInstInfo.setTaskStatus(TaskStatusEnum.COMPLETED);
                    gtNodeInstInfo.setCanEdit(CanEditEnum.DISABLED);
                    gtNodeInstInfo.setIsEndProcess(YesOrNoEnum.YES);
                    gtNodeInstInfo.put("nodeSumScore", nodeSumscore);
                    gradeTNodeColl.add((CoreBaseInfo)gtNodeInstInfo);
                    if (gradeTNodeColl.size() <= 0 || gradeTNodeColl.size() % PerfWorkflowOptimizationUtils.batchHandCount != 0) continue;
                    igradeTaskNodeInst.submitBatchData(gradeTNodeColl);
                    gradeTNodeColl.clear();
                }
            }
            if (gradeTNodeColl.size() > 0) {
                igradeTaskNodeInst.submitBatchData(gradeTNodeColl);
                gradeTNodeColl.clear();
            }
        }
    }

    public static void updatePerfEvaobjScoreTaskStatus(Context ctx, String[] evaObjIds, ScoreTaskStatusEnum scoreTaskStatusEnum) {
        try {
            StringBuffer updateSQL = new StringBuffer(" UPDATE T_EVA_PerfEvaObject SET FScoreTaskStatus ='");
            updateSQL.append(scoreTaskStatusEnum.getValue()).append("'");
            StringBuffer evaObjIdSb = new StringBuffer("(''");
            for (String evaObj : evaObjIds) {
                evaObjIdSb.append(",'").append(evaObj).append("'");
            }
            evaObjIdSb.append(")");
            updateSQL.append(" WHERE FID in ").append(evaObjIdSb.toString());
            DbUtil.execute((Context)ctx, (String)updateSQL.toString());
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    public static void updatePerfEvaobjWorkFlowStatus(Context ctx, String[] evaObjIds, PerfEvaObjectWFStatusEnum wfStatusEnum) {
        try {
            StringBuffer updateSQL = new StringBuffer(" UPDATE T_EVA_PerfEvaObject SET FWorkFlowStatus ='");
            updateSQL.append(wfStatusEnum.getValue()).append("'");
            StringBuffer evaObjIdSb = new StringBuffer("(''");
            for (String evaObj : evaObjIds) {
                evaObjIdSb.append(",'").append(evaObj).append("'");
            }
            evaObjIdSb.append(")");
            updateSQL.append(" WHERE FID in ").append(evaObjIdSb.toString());
            DbUtil.execute((Context)ctx, (String)updateSQL.toString());
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
    }

    public static boolean updateEvaobjWorkFlowAndScoreTaskStatus(Context ctx, String[] evaObjIds, PerfEvaObjectWFStatusEnum wfStatusEnum, ScoreTaskStatusEnum scoreTaskStatusEnum) {
        try {
            StringBuffer updateSQL = new StringBuffer(" UPDATE T_EVA_PerfEvaObject SET FWorkFlowStatus ='");
            updateSQL.append(wfStatusEnum.getValue()).append("',FScoreTaskStatus='" + scoreTaskStatusEnum.getValue()).append("'");
            StringBuffer evaObjIdSb = new StringBuffer("(''");
            for (String evaObj : evaObjIds) {
                evaObjIdSb.append(",'").append(evaObj).append("'");
            }
            evaObjIdSb.append(")");
            updateSQL.append(" WHERE FID in ").append(evaObjIdSb.toString());
            DbUtil.execute((Context)ctx, (String)updateSQL.toString());
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            return false;
        }
        return true;
    }

    public static LinkedList<HashMap<String, HashSet<HashMap<String, String>>>> getWorkflowHandlerForEvaObject(Context ctx, String evaObj, String workFlow) {
        LinkedList<HashMap<String, HashSet<HashMap<String, String>>>> handlerList;
        block15: {
            handlerList = new LinkedList<HashMap<String, HashSet<HashMap<String, String>>>>();
            try {
                int i;
                IWFNodeDef wfNodeDef;
                WFNodeDefCollection wfNodeColl;
                IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
                PerfEvaObjectCollection evaObjColl = iPerfEvaObject.getPerfEvaObjectCollection("select isOrg,evaluOrgAdmin.id,evaluOrgAdmin.responPosition.id,perfFile.person.id,perfFile.position.id,workFlow.id where id='" + evaObj + "'");
                if (null == evaObjColl || evaObjColl.size() <= 0) break block15;
                PerfEvaObjectInfo evaObjInfo = evaObjColl.get(0);
                if (StringUtils.isEmpty((CharSequence)workFlow)) {
                    workFlow = evaObjInfo.getWorkFlow().getId().toString();
                }
                String selfPosition = null;
                boolean isOrg = OrgAssessmentUtils.isOrgAssessment(evaObjInfo);
                if (isOrg) {
                    if (evaObjInfo.getEvaluOrgAdmin().getResponPosition() != null) {
                        selfPosition = evaObjInfo.getEvaluOrgAdmin().getResponPosition().getId().toString();
                    }
                } else {
                    selfPosition = evaObjInfo.getPerfFile().getPosition().getId().toString();
                }
                if ((wfNodeColl = (wfNodeDef = WFNodeDefFactory.getLocalInstance(ctx)).getWFNodeDefCollection(" where workflow='" + workFlow + "' order by level asc,nodeSeq")) == null || wfNodeColl.size() <= 0) break block15;
                int nodeSize = wfNodeColl.size();
                HashMap<String, WFNodeDefInfo> nodeMap = new HashMap<String, WFNodeDefInfo>(16);
                HashMap nodeProcessorPosition = new HashMap(4);
                for (i = 0; i < nodeSize; ++i) {
                    WFNodeDefInfo wfNodeInfo = wfNodeColl.get(i);
                    nodeMap.put(wfNodeInfo.getNodeName(), wfNodeInfo);
                }
                for (i = 0; i < nodeSize; ++i) {
                    String processorPosition2 = "";
                    WFNodeDefInfo wfNodeInfo = wfNodeColl.get(i);
                    int nodeHandlerCount = 0;
                    WFNodeDefInfo refNodeInfo = (WFNodeDefInfo)nodeMap.get(wfNodeInfo.getRefObj());
                    String nodeId = wfNodeInfo.getId().toString();
                    logger.error("\u3010PERFWEB\u3011-handle the node id : " + nodeId);
                    HashMap currentNodeHandlerMap = new HashMap(8);
                    StringBuffer nodeColname = new StringBuffer();
                    nodeColname.append(nodeId).append("#node").append(wfNodeInfo.getLevel()).append(wfNodeInfo.getNodeSeq()).append("#").append(wfNodeInfo.getNodeWeight());
                    HashSet<HashMap> currentNodeHandlerSet = new HashSet<HashMap>(8);
                    HashSet<String> currentNodeHandlerPosition = new HashSet<String>(8);
                    if (null != refNodeInfo) {
                        HashSet<String> refProcessorPositionSet = (HashSet<String>)nodeProcessorPosition.get(refNodeInfo.getId().toString());
                        if ((null == refProcessorPositionSet || refProcessorPositionSet.isEmpty()) && (refNodeInfo.getNodeName().equals(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SELF, ctx)) || refNodeInfo.getNodeName().equals(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MYRESPONSOR, ctx)))) {
                            refProcessorPositionSet = new HashSet<String>(1);
                            refProcessorPositionSet.add(selfPosition);
                        }
                        if (null != refProcessorPositionSet && !refProcessorPositionSet.isEmpty()) {
                            for (String processorPosition2 : refProcessorPositionSet) {
                                List<Map<String, String>> currentNodehandlerList = WorkFlowEngine.getInstance().getNodeHandler(ctx, evaObj, processorPosition2, nodeId);
                                for (Map<String, String> handler : currentNodehandlerList) {
                                    ++nodeHandlerCount;
                                    currentNodeHandlerSet.add((HashMap)handler);
                                    currentNodeHandlerPosition.add(handler.get("processorPosition"));
                                }
                            }
                        }
                    } else {
                        List<Map<String, String>> currentNodehandlerList = WorkFlowEngine.getInstance().getNodeHandler(ctx, evaObj, selfPosition, nodeId);
                        for (Map<String, String> handler : currentNodehandlerList) {
                            ++nodeHandlerCount;
                            currentNodeHandlerSet.add((HashMap)handler);
                            currentNodeHandlerPosition.add(handler.get("processorPosition"));
                        }
                    }
                    nodeProcessorPosition.put(nodeId, currentNodeHandlerPosition);
                    currentNodeHandlerMap.put(nodeColname.append("#").append(nodeHandlerCount).toString(), currentNodeHandlerSet);
                    handlerList.add(currentNodeHandlerMap);
                }
            }
            catch (Exception e) {
                logger.error("\u3010PERFWEB\u3011-getWorkflowHandlerForEvaObject err", (Throwable)e);
            }
        }
        return handlerList;
    }

    public static TargetNodeCollection getNodeHandlerByEvaObjAndNodeId(Context ctx, String evaObj, String workFlowId, String nodeId, String indicatorId) throws BOSException {
        TargetNodeCollection targetNodes = IndicatorUtils.getTargetNodeConfigHandler(ctx, evaObj, indicatorId, nodeId);
        if (targetNodes != null && !targetNodes.isEmpty()) {
            return targetNodes;
        }
        targetNodes = new TargetNodeCollection();
        LinkedList<HashMap<String, HashSet<HashMap<String, String>>>> handlerList = WorkFlowUtils.getWorkflowHandlerForEvaObject(ctx, evaObj, workFlowId);
        if (!CollectionUtils.isEmpty(handlerList)) {
            EntityViewInfo evi;
            SelectorItemCollection selectors;
            FilterInfo filterInfo;
            HashSet<String> personIds = new HashSet<String>();
            HashSet<String> positionIds = new HashSet<String>();
            for (HashMap hashMap : handlerList) {
                for (Map.Entry nodes : hashMap.entrySet()) {
                    String key = (String)nodes.getKey();
                    HashSet persons = (HashSet)nodes.getValue();
                    if (!key.contains(nodeId)) continue;
                    for (HashMap person : persons) {
                        TargetNodeInfo targetNodeInfo = new TargetNodeInfo();
                        String personId = (String)person.get("person");
                        personIds.add(personId);
                        String positionId = (String)person.get("processorPosition");
                        positionIds.add(positionId);
                        targetNodeInfo.setPerson((String)person.get("person"));
                        targetNodeInfo.setPersonName((String)person.get("personName"));
                        PositionInfo positionInfo = new PositionInfo();
                        positionInfo.setId(BOSUuid.read((String)positionId));
                        targetNodeInfo.setPersonPosition(positionInfo);
                        targetNodes.add(targetNodeInfo);
                    }
                }
            }
            HashMap<String, PersonInfo> personInfoMap = new HashMap<String, PersonInfo>();
            HashMap<String, PositionInfo> hashMap = new HashMap<String, PositionInfo>();
            if (!CollectionUtils.isEmpty(personIds)) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", personIds, CompareType.INCLUDE));
                selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("number"));
                selectors.add(new SelectorItemInfo("name"));
                evi = new EntityViewInfo();
                evi.setFilter(filterInfo);
                evi.setSelector(selectors);
                PersonCollection personColls = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(evi);
                if (personColls != null && !personColls.isEmpty()) {
                    for (PersonInfo personInfo : personColls) {
                        personInfoMap.put(personInfo.getId().toString(), personInfo);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(positionIds)) {
                filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", positionIds, CompareType.INCLUDE));
                selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("number"));
                selectors.add(new SelectorItemInfo("name"));
                evi = new EntityViewInfo();
                evi.setFilter(filterInfo);
                evi.setSelector(selectors);
                PositionCollection positionColls = PositionFactory.getLocalInstance((Context)ctx).getPositionCollection(evi);
                if (positionColls != null && !positionColls.isEmpty()) {
                    for (PositionInfo positionInfo : positionColls) {
                        hashMap.put(positionInfo.getId().toString(), positionInfo);
                    }
                }
            }
            if (targetNodes != null && !targetNodes.isEmpty()) {
                Iterator it = targetNodes.iterator();
                while (it.hasNext()) {
                    PositionInfo positionInfo;
                    TargetNodeInfo targetNodeInfo = (TargetNodeInfo)it.next();
                    String personId = targetNodeInfo.getPerson();
                    String positionId = targetNodeInfo.getPersonPosition().getId().toString();
                    PersonInfo personInfo = (PersonInfo)personInfoMap.get(personId);
                    positionInfo = (PositionInfo)hashMap.get(positionId);
                    if (personInfo != null) {
                        targetNodeInfo.setPersonNumber(personInfo.getNumber());
                    }
                    targetNodeInfo.setPersonPosition(positionInfo);
                }
            }
        }
        return targetNodes;
    }

    public static TargetNodeCollection getNodeHandlerByEvaObjAndNodeIdForSend(Context ctx, String evaObj, String nodeId, String indicatorId) throws BOSException {
        TargetNodeCollection targetNodes = new TargetNodeCollection();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObj));
        filterInfo.getFilterItems().add(new FilterItemInfo("target", (Object)indicatorId));
        filterInfo.getFilterItems().add(new FilterItemInfo("gradeTaskNode.wfNode.id", (Object)nodeId));
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("nodeTargetWeight"));
        selectors.add(new SelectorItemInfo("gradeTaskNode.nodeHandler.id"));
        selectors.add(new SelectorItemInfo("gradeTaskNode.nodeWeight"));
        selectors.add(new SelectorItemInfo("gradeTaskNode.nodeHandler.number"));
        selectors.add(new SelectorItemInfo("gradeTaskNode.nodeHandler.name"));
        selectors.add(new SelectorItemInfo("gradeTaskNode.processorPosition"));
        selectors.add(new SelectorItemInfo("gradeTaskNode.positionName"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectors);
        GradeTargetInstCollection targetInstColls = GradeTargetInstFactory.getLocalInstance(ctx).getGradeTargetInstCollection(evi);
        Iterator it = targetInstColls.iterator();
        while (it.hasNext()) {
            TargetNodeInfo targetNodeInfo = new TargetNodeInfo();
            GradeTargetInstInfo gradeTargetInstInfo = (GradeTargetInstInfo)it.next();
            GradeTaskNodeInstInfo gradeTaskNodeInstInfo = gradeTargetInstInfo.getGradeTaskNode();
            PersonInfo personInfo = gradeTaskNodeInstInfo.getNodeHandler();
            targetNodeInfo.setId(gradeTargetInstInfo.getId());
            targetNodeInfo.setPersonNumber(personInfo.getNumber());
            targetNodeInfo.setPersonName(personInfo.getName());
            PositionInfo positionInfo = new PositionInfo();
            positionInfo.setId(BOSUuid.read((String)gradeTaskNodeInstInfo.getProcessorPosition()));
            positionInfo.setName(gradeTaskNodeInstInfo.getPositionName());
            targetNodeInfo.setPersonPosition(positionInfo);
            targetNodeInfo.setWeight(gradeTargetInstInfo.getNodeTargetWeight());
            targetNodeInfo.setPerson(personInfo.getId().toString());
            targetNodes.add(targetNodeInfo);
        }
        return targetNodes;
    }

    public static void createNodeInstNew(Context ctx, PerfEvaObjectInfo evaObjInfo, AsignmentPoolInfo asignmentInfo, String workFlow, LinkedList<HashMap<String, HashSet<HashMap<String, String>>>> handlerList, int level, String createType) throws BOSException {
        ConcurrentHashMap<String, WFNodeDefCollection> wfNodeDefMap = new ConcurrentHashMap<String, WFNodeDefCollection>(10);
        try {
            String evaObj = evaObjInfo.getId().toString();
            List<Object> responsors = new ArrayList();
            if (OrgAssessmentUtils.isOrgAssessment(evaObjInfo)) {
                responsors = OrgAssessmentUtils.getOrgResponserIdByEvaObject(ctx, evaObj);
            }
            int noHandlerSize = 0;
            int nodeSize = 0;
            boolean isHandUp = true;
            if (level == 1 && asignmentInfo != null) {
                if (asignmentInfo.getIsCreateInst().getValue().equals("1") && evaObjInfo.getCanAdjustEvaluer().getValue() == 0) {
                    return;
                }
                PerfWorkFlowFacadeFactory.getLocalInstance(ctx).createEvaResultSummary(evaObj);
            }
            String key = null;
            key = StringUtils.isEmpty((CharSequence)workFlow) ? evaObjInfo.getWorkFlow().getId().toString() + level : workFlow + level;
            WFNodeDefCollection wfNodeColl = null;
            if (wfNodeDefMap.containsKey(key)) {
                wfNodeColl = (WFNodeDefCollection)((Object)wfNodeDefMap.get(key));
            } else {
                wfNodeColl = StringUtils.isEmpty((CharSequence)workFlow) ? WorkFlowUtils.getNodeCollectionByEvaObj(ctx, evaObj, level) : WorkFlowUtils.getNodeCollectionByWorkFlow(ctx, workFlow, level);
                wfNodeDefMap.put(key, wfNodeColl);
            }
            nodeSize = wfNodeColl.size();
            if (wfNodeColl != null && nodeSize > 0) {
                for (int i = 0; i < nodeSize; ++i) {
                    String processorPosition = "";
                    WFNodeDefInfo wfNodeInfo = wfNodeColl.get(i);
                    HashSet handlerSet = new HashSet();
                    for (HashMap hashMap : handlerList) {
                        for (Map.Entry entry : hashMap.entrySet()) {
                            if (((String)entry.getKey()).indexOf(wfNodeInfo.getId().toString()) == -1) continue;
                            handlerSet = (HashSet)entry.getValue();
                            break;
                        }
                        if (CollectionUtils.isEmpty(handlerSet)) continue;
                        break;
                    }
                    String redirectUrl = "";
                    for (HashMap handler : handlerSet) {
                        String person = (String)handler.get("person");
                        UserInfo userInfo = CurrentUserUtil.getUserInfoByPersonId(ctx, person);
                        if (null != userInfo && null != userInfo.getNumber()) {
                            redirectUrl = SSOLoginUtils._createSsoRedirectUrl(ctx, userInfo.getNumber());
                            isHandUp = false;
                        } else {
                            ++noHandlerSize;
                        }
                        String personName = (String)handler.get("personName");
                        processorPosition = (String)handler.get("processorPosition");
                        int isSelf = 0;
                        if (wfNodeInfo != null && wfNodeInfo.getNodeHandler() != null && wfNodeInfo.getNodeHandler().equals(BUSINESS_TYPE) && person.equals(evaObjInfo.getPerfFile().getPerson().getId().toString())) {
                            isSelf = 1;
                        }
                        if (wfNodeInfo != null && wfNodeInfo.getNodeHandler() != null && wfNodeInfo.getNodeHandler().equals("700") && responsors.size() > 0 && responsors.contains(person)) {
                            isSelf = 1;
                        }
                        WorkFlowEngine.getInstance().createNodeInst(ctx, evaObjInfo, asignmentInfo, wfNodeInfo, person, personName, createType, isSelf, processorPosition);
                    }
                    if ((noHandlerSize <= 0 || noHandlerSize != handlerSet.size()) && handlerSet.size() != 0) continue;
                    isHandUp = true;
                }
            }
            if (level == 1 && isHandUp) {
                WorkFlowUtils.writeBackWorkFlowStatusForEvaObj(ctx, evaObjInfo, PerfEvaObjectWFStatusEnum.HANGUP);
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-CREATENODEINSTERR...", (Throwable)e);
            throw new BOSException();
        }
    }

    public static WFNodeDefCollection getNodeCollectionByWorkFlow(Context ctx, String workFlow, int level) {
        WFNodeDefCollection wfNodeDefColl = null;
        try {
            IWFNodeDef iwfNodeDef = WFNodeDefFactory.getLocalInstance(ctx);
            wfNodeDefColl = iwfNodeDef.getWFNodeDefCollection(" where workflow='" + workFlow + "' and level='" + level + "'");
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return wfNodeDefColl;
    }

    public static Set<String> getMatrixWorkflowByEvaObj(Context ctx, PerfEvaObjectInfo evaObjInfo) throws BOSException {
        int i;
        HashSet<String> workFlowIds = new HashSet<String>(16);
        HashSet<String> areaBaseIdSet = new HashSet<String>(16);
        String evaObj = evaObjInfo.getId().toString();
        IIndicatorTarget iIndicatorTarget = IndicatorTargetFactory.getLocalInstance(ctx);
        IRecordTarget iRecordTarget = RecordTargetFactory.getLocalInstance(ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaObj", (Object)evaObj, CompareType.EQUALS));
        evi.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("workFlow.id"));
        sic.add(new SelectorItemInfo("workFlow.series"));
        sic.add(new SelectorItemInfo("areaBase.id"));
        evi.setSelector(sic);
        IndicatorTargetCollection indicatorTargetCollection = iIndicatorTarget.getIndicatorTargetCollection(evi);
        RecordTargetCollection recordTargetCollection = iRecordTarget.getRecordTargetCollection(evi);
        int size = indicatorTargetCollection.size();
        for (i = 0; i < size; ++i) {
            if (null != indicatorTargetCollection.get(i).getWorkFlow()) {
                workFlowIds.add(indicatorTargetCollection.get(i).getWorkFlow().getId().toString());
                continue;
            }
            areaBaseIdSet.add(indicatorTargetCollection.get(i).getAreaBase().getId().toString());
        }
        size = recordTargetCollection.size();
        for (i = 0; i < size; ++i) {
            if (null != recordTargetCollection.get(i).getWorkFlow()) {
                workFlowIds.add(recordTargetCollection.get(i).getWorkFlow().getId().toString());
                continue;
            }
            areaBaseIdSet.add(recordTargetCollection.get(i).getAreaBase().getId().toString());
        }
        PerfPeriodInfo periodInfo = GetEntityInfoUtils.getPerfPeriodInfo(ctx, evaObjInfo.getPeriod().getId().toString());
        Iterator areaBaseIdIt = areaBaseIdSet.iterator();
        while (areaBaseIdIt.hasNext()) {
            WorkFlowUtils.getAreaWorkflow(ctx, workFlowIds, evaObj, (String)areaBaseIdIt.next(), periodInfo);
        }
        String perfRuleId = periodInfo.getPerfRule().getId().toString();
        EvaluFormAreaBaseCollection evaluFormAreaBaseColl = GetEntityInfoUtils.getEvaluFormAreaBaseCollection(ctx, perfRuleId);
        if (null != evaluFormAreaBaseColl && evaluFormAreaBaseColl.size() > 0) {
            int areaSize = evaluFormAreaBaseColl.size();
            for (int i2 = 0; i2 < areaSize; ++i2) {
                EvaluFormAreaBaseInfo areaBaseInfo = evaluFormAreaBaseColl.get(i2);
                String areaBase = areaBaseInfo.getId().toString();
                if (areaBaseInfo.getAreaType().getValue().equals(BUSINESS_TYPE) || areaBaseInfo.getAreaType().getValue().equals("400")) continue;
                if (areaBaseInfo.getAreaType().getValue().equals("200")) {
                    if (WorkFlowUtils.judgeIsExistTargetCollByEvaObjAndArea(ctx, evaObj, areaBase)) continue;
                    WorkFlowUtils.getAreaWorkflow(ctx, workFlowIds, evaObj, areaBase, periodInfo);
                    continue;
                }
                if (!areaBaseInfo.getAreaType().getValue().equals("300") || WorkFlowUtils.judgeIsExistRecordTargetCollByEvaObjAndArea(ctx, evaObj, areaBase)) continue;
                WorkFlowUtils.getAreaWorkflow(ctx, workFlowIds, evaObj, areaBase, periodInfo);
            }
        }
        return workFlowIds;
    }

    public static void getAreaWorkflow(Context ctx, Set<String> workFlowIds, String evaObj, String areaBase, PerfPeriodInfo periodInfo) {
        PerfEvaObjMatrixWorkFlowInstCollection matrixWFColl = GetEntityInfoUtils.getPerfEvaObjMatrixWorkInstColl(ctx, evaObj, areaBase);
        if (null != matrixWFColl && matrixWFColl.size() > 0) {
            workFlowIds.add(matrixWFColl.get(0).getWorkflow().getId().toString());
        } else {
            PerfEvaObjectMatrixWorkFlowCollection evaObjMWFColl = null;
            String perfPlanId = periodInfo.getPerfPlan().getId().toString();
            String perfRuleId = periodInfo.getPerfRule().getId().toString();
            TargetEvaluModeEnum canAdjustEvaluer = periodInfo.getPerfPlan().getCanAdjustEvaluer();
            if (canAdjustEvaluer.getValue() == 1 && (evaObjMWFColl = GetEntityInfoUtils.getPerfEvaObjMatrixWorkColl(ctx, perfPlanId, areaBase, perfRuleId)).isEmpty() && 1 == periodInfo.getIsHistoryUpdate().getValue()) {
                evaObjMWFColl = GetEntityInfoUtils.getPerfEvaObjMatrixWorkColl(ctx, perfPlanId, areaBase);
            }
            if (null != evaObjMWFColl && evaObjMWFColl.size() > 0) {
                workFlowIds.add(evaObjMWFColl.get(0).getWorkflow().getId().toString());
            } else {
                PerfEvaObjectInfo perfEvaObjectInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
                if (perfEvaObjectInfo != null && perfEvaObjectInfo.getWorkFlow() != null) {
                    workFlowIds.add(perfEvaObjectInfo.getWorkFlow().getId().toString());
                } else {
                    PerfPlanInfo planInfo = GetEntityInfoUtils.getPerfPlanInfo(ctx, perfPlanId);
                    workFlowIds.add(planInfo.getDefaultWorkFlow().getId().toString());
                }
            }
        }
    }

    public static boolean judgeIsExistTargetCollByEvaObjAndArea(Context ctx, String evaObj, String areaId) {
        try {
            IIndicatorTarget iIndicatorTarget = IndicatorTargetFactory.getLocalInstance(ctx);
            if (iIndicatorTarget.exists(" where evaObj='" + evaObj + "' and areaBase='" + areaId + "'")) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-getIndicatorTargetCollByEvaObjAndArea execute error", (Throwable)e);
        }
        return false;
    }

    public static boolean judgeIsExistRecordTargetCollByEvaObjAndArea(Context ctx, String evaObj, String areaId) {
        try {
            IRecordTarget irecordTarget = RecordTargetFactory.getLocalInstance(ctx);
            if (irecordTarget.exists(" where evaObj='" + evaObj + "' and areaBase='" + areaId + "'")) {
                return true;
            }
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-getRecordTargetCollByEvaObjAndArea excute error", (Throwable)e);
        }
        return false;
    }

    public static void backTargetCreateEmailTask(Context ctx, boolean sendEmail, HashMap<String, MessageTemplateDefineCollection> msgTempColl, PerfEvaObjectInfo perfEvaObjectInfo) throws BOSException {
        IEmailSendFacade iEmailSendFacade = EmailSendFacadeFactory.getLocalInstance(ctx);
        IPerfGoalsFillerObject iperfGoalsFiller = PerfGoalsFillerObjectFactory.getLocalInstance(ctx);
        if (sendEmail) {
            PerfGoalsFillerObjectCollection perfGoalsFillerObjectColl;
            MessageTemplateDefineCollection msgcoll = msgTempColl.get(perfEvaObjectInfo.getId().toString());
            String emailTitle = "";
            String emailContent = "";
            if (msgcoll != null) {
                int size = msgcoll.size();
                for (int j = 0; j < size; ++j) {
                    if (msgcoll.get(j).getMessageType() == null || msgcoll.get(j).getMessageType().getValue() != 2) continue;
                    emailContent = msgcoll.get(j).getTemplateContent();
                    emailTitle = msgcoll.get(j).getTemplateTitle();
                    break;
                }
            }
            if (null != (perfGoalsFillerObjectColl = iperfGoalsFiller.getPerfGoalsFillerObjectCollection(" where perfEvaObject='" + perfEvaObjectInfo.getId().toString() + "'")) && perfGoalsFillerObjectColl.size() > 0) {
                int fillerSize = perfGoalsFillerObjectColl.size();
                for (int k = 0; k < fillerSize; ++k) {
                    iEmailSendFacade.createEmailTask(perfGoalsFillerObjectColl.get(k).getPerson(), perfEvaObjectInfo.getId().toString(), emailContent, emailTitle, BUSINESS_TYPE);
                }
            }
        }
    }

    public static void filterValidNodeHandler(Context ctx, PersonCollection personColl) throws BOSException {
        if (personColl != null && !personColl.isEmpty()) {
            Iterator personIt = personColl.iterator();
            while (personIt.hasNext()) {
                PersonInfo personInfo = (PersonInfo)personIt.next();
                if (personInfo.getEmployeeType().isIsOnTheStrength() || personInfo.getEmployeeType().isIsInCount()) continue;
                personIt.remove();
            }
        }
    }

    public static Map<String, WFNodeDefCollection> getWFNodeDefCollsByWorkFlows(Context ctx, Set<String> workFlowIds) throws BOSException {
        FilterInfo nodeFilter = new FilterInfo();
        nodeFilter.getFilterItems().add(new FilterItemInfo("workflow.id", workFlowIds, CompareType.INCLUDE));
        SorterItemCollection nodeSorters = new SorterItemCollection();
        nodeSorters.add(new SorterItemInfo("level"));
        nodeSorters.add(new SorterItemInfo("nodeSeq"));
        EntityViewInfo nodeEvi = new EntityViewInfo();
        nodeEvi.setFilter(nodeFilter);
        nodeEvi.setSorter(nodeSorters);
        WFNodeDefCollection wfNodeColls = WFNodeDefFactory.getLocalInstance(ctx).getWFNodeDefCollection(nodeEvi);
        HashMap<String, WFNodeDefCollection> wfNodeMap = new HashMap<String, WFNodeDefCollection>();
        Iterator it = wfNodeColls.iterator();
        while (it.hasNext()) {
            WFNodeDefInfo nodeDefInfo = (WFNodeDefInfo)it.next();
            String workFlowId = nodeDefInfo.getWorkflow().getId().toString();
            WFNodeDefCollection nodeDefs = (WFNodeDefCollection)((Object)wfNodeMap.get(workFlowId));
            if (nodeDefs == null) {
                nodeDefs = new WFNodeDefCollection();
            }
            nodeDefs.add(nodeDefInfo);
            wfNodeMap.put(workFlowId, nodeDefs);
        }
        return wfNodeMap;
    }

    public static PersonCollection getResponsibles(Context ctx, PerfEvaObjectInfo info, WFNodeDefCollection wfNodeColl) {
        PersonCollection persons = new PersonCollection();
        String selfPosition = info.getPerfFile().getPosition().getId().toString();
        if (wfNodeColl != null && wfNodeColl.size() > 0) {
            int nodeSize = wfNodeColl.size();
            HashMap<String, WFNodeDefInfo> nodeMap = new HashMap<String, WFNodeDefInfo>(16);
            HashMap nodeProcessorPosition = new HashMap(4);
            for (int i = 0; i < nodeSize; ++i) {
                WFNodeDefInfo wfNodeInfo = wfNodeColl.get(i);
                nodeMap.put(wfNodeInfo.getNodeName(), wfNodeInfo);
            }
            String _self = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.SELF, ctx);
            for (int i = 0; i < nodeSize; ++i) {
                WFNodeDefInfo wfNodeInfo = wfNodeColl.get(i);
                WFNodeDefInfo refNodeInfo = (WFNodeDefInfo)nodeMap.get(wfNodeInfo.getRefObj());
                String nodeId = wfNodeInfo.getId().toString();
                HashSet currentNodeHandlerPosition = new HashSet(8);
                if (null != refNodeInfo && !wfNodeInfo.getNodeHandler().equals(BUSINESS_TYPE)) {
                    HashSet<String> refProcessorPositionSet = (HashSet<String>)nodeProcessorPosition.get(refNodeInfo.getId().toString());
                    if (null == refProcessorPositionSet || refProcessorPositionSet.isEmpty()) {
                        if (refNodeInfo.getNodeName().equals(_self)) {
                            PerfFileInfo perfFileInfo = info.getPerfFile();
                            String positionId = perfFileInfo.getPosition().getId().toString();
                            refProcessorPositionSet = new HashSet<String>(1);
                            refProcessorPositionSet.add(positionId);
                        }
                    } else {
                        for (String processorPosition : refProcessorPositionSet) {
                            persons = WorkFlowEngine.getInstance().getNodeHandlerPerons(ctx, info, processorPosition, wfNodeInfo);
                        }
                    }
                } else {
                    persons = WorkFlowEngine.getInstance().getNodeHandlerPerons(ctx, info, selfPosition, wfNodeInfo);
                }
                nodeProcessorPosition.put(nodeId, currentNodeHandlerPosition);
                if (!"1".equals(wfNodeInfo.getIsFinalGrade())) continue;
                if (persons != null && !persons.isEmpty()) break;
                return null;
            }
        }
        return persons;
    }

    public static Map<String, PersonCollection> geResponsiblesByTaskNode(Context ctx) throws BOSException {
        return WorkFlowUtils.geResponsiblesByTaskNode(ctx, null);
    }

    public static Map<String, PersonCollection> geResponsiblesByTaskNode(Context ctx, Set<String> startEvaluEvaObjIds) throws BOSException {
        FilterInfo taskFilter = new FilterInfo();
        if (!CollectionUtils.isEmpty(startEvaluEvaObjIds)) {
            taskFilter.getFilterItems().add(new FilterItemInfo("evaObj.id", startEvaluEvaObjIds, CompareType.INCLUDE));
        }
        taskFilter.getFilterItems().add(new FilterItemInfo("wfNode.isFinalGrade", (Object)"1"));
        SelectorItemCollection taskSelectors = new SelectorItemCollection();
        taskSelectors.add(new SelectorItemInfo("evaObj.id"));
        taskSelectors.add(new SelectorItemInfo("nodeHandler.id"));
        taskSelectors.add(new SelectorItemInfo("nodeHandler.number"));
        taskSelectors.add(new SelectorItemInfo("nodeHandler.name"));
        EntityViewInfo taskEvi = new EntityViewInfo();
        taskEvi.setSelector(taskSelectors);
        taskEvi.setFilter(taskFilter);
        GradeTaskNodeInstCollection taskNodes = GradeTaskNodeInstFactory.getLocalInstance(ctx).getGradeTaskNodeInstCollection(taskEvi);
        HashMap<String, PersonCollection> resultMap = new HashMap<String, PersonCollection>();
        if (taskNodes != null && !taskNodes.isEmpty()) {
            Iterator taskIt = taskNodes.iterator();
            while (taskIt.hasNext()) {
                PersonInfo personInfo;
                GradeTaskNodeInstInfo taskInfo = (GradeTaskNodeInstInfo)taskIt.next();
                String evaObjId = taskInfo.getEvaObj().getId().toString();
                PersonCollection persons = (PersonCollection)resultMap.get(evaObjId);
                if (persons == null) {
                    persons = new PersonCollection();
                }
                if ((personInfo = taskInfo.getNodeHandler()) == null) continue;
                persons.add(personInfo);
                resultMap.put(evaObjId, persons);
            }
        }
        return resultMap;
    }

    public static Map<String, PersonCollection> geResponsiblesByTargetNode(Context ctx, Set<String> finalWorkFlowIds, Set<String> excludeEvaobjIds) throws BOSException {
        return WorkFlowUtils.geResponsiblesByTargetNode(ctx, null, finalWorkFlowIds, excludeEvaobjIds);
    }

    public static Map<String, PersonCollection> geResponsiblesByTargetNode(Context ctx, Map<String, String> evaObjMap, Set<String> finalWorkFlowIds) throws BOSException {
        return WorkFlowUtils.geResponsiblesByTargetNode(ctx, evaObjMap, finalWorkFlowIds, null);
    }

    public static Map<String, PersonCollection> geResponsiblesByTargetNode(Context ctx, Map<String, String> evaObjMap, Set<String> finalWorkFlowIds, Set<String> excludeEvaobjIds) throws BOSException {
        HashMap<String, PersonCollection> resultMap = new HashMap<String, PersonCollection>();
        FilterInfo nodeFilter = new FilterInfo();
        if (!CollectionUtils.isEmpty(evaObjMap)) {
            HashSet<String> workFlowIds = new HashSet<String>();
            workFlowIds.addAll(evaObjMap.values());
            nodeFilter.getFilterItems().add(new FilterItemInfo("workflow.id", workFlowIds, CompareType.INCLUDE));
        }
        nodeFilter.getFilterItems().add(new FilterItemInfo("isFinalGrade", (Object)"1"));
        SelectorItemCollection nodeSelectors = new SelectorItemCollection();
        nodeSelectors.add(new SelectorItemInfo("id"));
        nodeSelectors.add(new SelectorItemInfo("workflow.*"));
        nodeSelectors.add(new SelectorItemInfo("level"));
        nodeSelectors.add(new SelectorItemInfo("nodeSeq"));
        nodeSelectors.add(new SelectorItemInfo("nodeWeight"));
        EntityViewInfo nodeEvi = new EntityViewInfo();
        nodeEvi.setFilter(nodeFilter);
        nodeEvi.setSelector(nodeSelectors);
        IWFNodeDef iWfNodeDef = WFNodeDefFactory.getLocalInstance(ctx);
        WFNodeDefCollection nodeDefInfos = iWfNodeDef.getWFNodeDefCollection(nodeEvi);
        if (nodeDefInfos == null || nodeDefInfos.isEmpty()) {
            return null;
        }
        HashSet<String> nodeIds = new HashSet<String>();
        Iterator it = nodeDefInfos.iterator();
        while (it.hasNext()) {
            WFNodeDefInfo wfNodeDefInfo = (WFNodeDefInfo)it.next();
            if (finalWorkFlowIds != null) {
                finalWorkFlowIds.add(wfNodeDefInfo.getWorkflow().getId().toString());
            }
            nodeIds.add(wfNodeDefInfo.getId().toString());
        }
        FilterInfo tnFilter = new FilterInfo();
        tnFilter.getFilterItems().add(new FilterItemInfo("wfNode.id", nodeIds, CompareType.INCLUDE));
        if (!CollectionUtils.isEmpty(evaObjMap)) {
            tnFilter.getFilterItems().add(new FilterItemInfo("evaObj.id", evaObjMap.keySet(), CompareType.INCLUDE));
        } else if (!CollectionUtils.isEmpty(excludeEvaobjIds)) {
            tnFilter.getFilterItems().add(new FilterItemInfo("evaObj.id", excludeEvaobjIds, CompareType.NOTINCLUDE));
        }
        SelectorItemCollection tnSelectors = new SelectorItemCollection();
        tnSelectors.add(new SelectorItemInfo("evaObj.id"));
        tnSelectors.add(new SelectorItemInfo("person"));
        EntityViewInfo tnEvi = new EntityViewInfo();
        tnEvi.setFilter(tnFilter);
        tnEvi.setSelector(tnSelectors);
        TargetNodeCollection targetNodes = TargetNodeFactory.getLocalInstance(ctx).getTargetNodeCollection(tnEvi);
        if (targetNodes != null && !targetNodes.isEmpty()) {
            HashSet<String> personIds = new HashSet<String>();
            Iterator it2 = targetNodes.iterator();
            while (it2.hasNext()) {
                TargetNodeInfo targetNodeInfo = (TargetNodeInfo)it2.next();
                personIds.add(targetNodeInfo.getPerson());
            }
            HashMap<String, PersonInfo> personMap = new HashMap<String, PersonInfo>();
            FilterInfo pFilter = new FilterInfo();
            pFilter.getFilterItems().add(new FilterItemInfo("id", personIds, CompareType.INCLUDE));
            SelectorItemCollection pSelectors = new SelectorItemCollection();
            pSelectors.add(new SelectorItemInfo("id"));
            pSelectors.add(new SelectorItemInfo("number"));
            pSelectors.add(new SelectorItemInfo("name"));
            EntityViewInfo pEvi = new EntityViewInfo();
            pEvi.setSelector(pSelectors);
            pEvi.setFilter(pFilter);
            PersonCollection colls = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(pEvi);
            for (PersonInfo personInfo : colls) {
                personMap.put(personInfo.getId().toString(), personInfo);
            }
            Iterator it3 = targetNodes.iterator();
            while (it3.hasNext()) {
                TargetNodeInfo targetNodeInfo = (TargetNodeInfo)it3.next();
                String personId = targetNodeInfo.getPerson();
                String evaObjId = targetNodeInfo.getEvaObj().getId().toString();
                PersonCollection persons = (PersonCollection)resultMap.get(evaObjId);
                if (persons == null) {
                    persons = new PersonCollection();
                }
                persons.add((PersonInfo)personMap.get(personId));
                resultMap.put(evaObjId, persons);
            }
        }
        return resultMap;
    }

    private static void removeKeys(Map<String, String> evaObjMap, Set<String> keys) {
        for (String key : keys) {
            evaObjMap.remove(key);
        }
    }

    public static void setResponsible(Context ctx, PerfEvaObjectCollection evaObjects, Map<String, String> respNumberMap, Map<String, String> respNameMap, Map<String, String> perfPersonIncharge) throws BOSException, EASBizException {
        Map<String, PersonCollection> taskNodePersonMap;
        String evaObjId;
        HashMap<String, PersonCollection> evaObjPersonMap = new HashMap<String, PersonCollection>();
        HashSet<String> startEvaluEvaObjIds = new HashSet<String>();
        HashMap<String, String> evaObjMap = new HashMap<String, String>();
        Iterator it = evaObjects.iterator();
        while (it.hasNext()) {
            PerfEvaObjectInfo evaObjectInfo = (PerfEvaObjectInfo)it.next();
            evaObjId = evaObjectInfo.getId().toString();
            if (evaObjectInfo.getWorkFlow() != null) {
                evaObjMap.put(evaObjId, evaObjectInfo.getWorkFlow().getId().toString());
            }
            if (PerfEvaObjectWFStatusEnum.UNSTARTED.equals((Object)evaObjectInfo.getWorkFlowStatus())) continue;
            startEvaluEvaObjIds.add(evaObjId);
        }
        WorkFlowUtils.desposePerfPersonIncharge(ctx, evaObjects, perfPersonIncharge);
        if (!CollectionUtils.isEmpty(startEvaluEvaObjIds) && !CollectionUtils.isEmpty(taskNodePersonMap = WorkFlowUtils.geResponsiblesByTaskNode(ctx, startEvaluEvaObjIds))) {
            evaObjPersonMap.putAll(taskNodePersonMap);
            WorkFlowUtils.removeKeys(evaObjMap, taskNodePersonMap.keySet());
        }
        if (!evaObjMap.isEmpty()) {
            HashSet<String> finalWorkFlowIds = new HashSet<String>();
            Map<String, PersonCollection> targetNodePersonMap = WorkFlowUtils.geResponsiblesByTargetNode(ctx, evaObjMap, finalWorkFlowIds);
            if (!CollectionUtils.isEmpty(targetNodePersonMap)) {
                evaObjPersonMap.putAll(targetNodePersonMap);
                WorkFlowUtils.removeKeys(evaObjMap, targetNodePersonMap.keySet());
            }
            if (!evaObjMap.isEmpty()) {
                HashSet<String> workFlowIds = new HashSet<String>();
                workFlowIds.addAll(evaObjMap.values());
                Map<String, WFNodeDefCollection> wfNodeMap = WorkFlowUtils.getWFNodeDefCollsByWorkFlows(ctx, workFlowIds);
                Iterator evaObjIt = evaObjects.iterator();
                while (evaObjIt.hasNext()) {
                    PerfEvaObjectInfo info = (PerfEvaObjectInfo)evaObjIt.next();
                    String evaObjId2 = info.getId().toString();
                    String workFlow = info.getWorkFlow().getId().toString();
                    if (!finalWorkFlowIds.contains(workFlow)) continue;
                    PersonCollection persons = WorkFlowUtils.getResponsibles(ctx, info, wfNodeMap.get(workFlow));
                    evaObjPersonMap.put(evaObjId2, persons);
                }
            }
        }
        for (Map.Entry entry : evaObjPersonMap.entrySet()) {
            evaObjId = (String)entry.getKey();
            StringBuffer numberSb = new StringBuffer();
            StringBuffer nameSb = new StringBuffer();
            PersonCollection colls = (PersonCollection)entry.getValue();
            if (colls == null || colls.isEmpty()) continue;
            Locale locale = ctx.getLocale();
            for (PersonInfo personInfo : colls) {
                if (StringUtils.isEmpty((CharSequence)personInfo.getNumber())) {
                    logger.error("get responsible person number null, evaObj =" + evaObjId);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)personInfo.getName(locale))) {
                    logger.error("get responsible person name null, evaObj =" + evaObjId);
                    continue;
                }
                numberSb.append(personInfo.getNumber()).append(",");
                nameSb.append(personInfo.getName(locale)).append(",");
            }
            if (numberSb.length() > 1) {
                numberSb.setLength(numberSb.length() - 1);
            }
            if (nameSb.length() > 1) {
                nameSb.setLength(nameSb.length() - 1);
            }
            respNumberMap.put(evaObjId, numberSb.toString());
            respNameMap.put(evaObjId, nameSb.toString());
        }
    }

    public static PerfEvaObjectCollection getEvaObjInfoByWorkFlowIds(Context ctx, Set<String> workFlowIds, Set<String> excludeEvaObjIds) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("workFlow.id", workFlowIds, CompareType.INCLUDE));
        if (!CollectionUtils.isEmpty(excludeEvaObjIds)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", excludeEvaObjIds, CompareType.NOTINCLUDE));
        }
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("id"));
        selectors.add(new SelectorItemInfo("workFlow.id"));
        selectors.add(new SelectorItemInfo("perfFile.id"));
        selectors.add(new SelectorItemInfo("perfFile.person.id"));
        selectors.add(new SelectorItemInfo("perfFile.person.name"));
        selectors.add(new SelectorItemInfo("perfFile.person.number"));
        selectors.add(new SelectorItemInfo("perfFile.position.id"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectors);
        IPerfEvaObject iPerfEvaObject = PerfEvaObjectFactory.getLocalInstance(ctx);
        return iPerfEvaObject.getPerfEvaObjectCollection(evi);
    }

    public static Set<String> getEvaObjIdsByResponsible(Context ctx, FilterInfo personFilter) throws BOSException, EASBizException {
        PersonCollection persons;
        HashMap<String, PersonCollection> evaObjMap = new HashMap<String, PersonCollection>();
        Map<String, PersonCollection> taskNodePersonMap = WorkFlowUtils.geResponsiblesByTaskNode(ctx);
        evaObjMap.putAll(taskNodePersonMap);
        HashSet<String> workFlowIds = new HashSet<String>();
        Map<String, PersonCollection> targetNodePersonMap = WorkFlowUtils.geResponsiblesByTargetNode(ctx, workFlowIds, evaObjMap.keySet());
        evaObjMap.putAll(targetNodePersonMap);
        Map<String, WFNodeDefCollection> wfNodeMap = WorkFlowUtils.getWFNodeDefCollsByWorkFlows(ctx, workFlowIds);
        PerfEvaObjectCollection evaObjects = WorkFlowUtils.getEvaObjInfoByWorkFlowIds(ctx, workFlowIds, evaObjMap.keySet());
        if (evaObjects != null && !evaObjects.isEmpty()) {
            Iterator evaObjIt = evaObjects.iterator();
            while (evaObjIt.hasNext()) {
                PerfEvaObjectInfo info = (PerfEvaObjectInfo)evaObjIt.next();
                String string = info.getId().toString();
                String workFlow = info.getWorkFlow().getId().toString();
                persons = WorkFlowUtils.getResponsibles(ctx, info, wfNodeMap.get(workFlow));
                evaObjMap.put(string, persons);
            }
        }
        if (CollectionUtils.isEmpty(evaObjMap)) {
            return null;
        }
        HashMap<String, HashSet<String>> personMap = new HashMap<String, HashSet<String>>();
        for (Map.Entry entry : evaObjMap.entrySet()) {
            String evaObjId = (String)entry.getKey();
            persons = (PersonCollection)entry.getValue();
            if (persons == null || persons.isEmpty()) continue;
            for (PersonInfo pInfo : persons) {
                String personId = pInfo.getId().toString();
                HashSet<String> evaObjs = (HashSet<String>)personMap.get(personId);
                if (evaObjs == null) {
                    evaObjs = new HashSet<String>();
                }
                evaObjs.add(evaObjId);
                personMap.put(personId, evaObjs);
            }
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", personMap.keySet(), CompareType.INCLUDE));
        filterInfo.mergeFilter(personFilter, "and");
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("id"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectorItemCollection);
        PersonCollection colls = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(evi);
        HashSet<String> validEvaObjIds = new HashSet<String>();
        if (colls != null && !colls.isEmpty()) {
            for (PersonInfo pInfo : colls) {
                String personId = pInfo.getId().toString();
                validEvaObjIds.addAll((Collection)personMap.get(personId));
            }
        }
        return validEvaObjIds;
    }

    public static void desposePerfPersonIncharge(Context ctx, PerfEvaObjectCollection evaObjects, Map<String, String> perfPersonIncharge) throws BOSException {
        HashSet<String> evaobjIds = new HashSet<String>();
        HashSet<String> evaObjs = new HashSet<String>();
        Iterator it = evaObjects.iterator();
        while (it.hasNext()) {
            PerfEvaObjectInfo evaObjectInfo = (PerfEvaObjectInfo)it.next();
            String evaObjId = evaObjectInfo.getId().toString();
            evaObjs.add(evaObjId);
            int unitGoalsStatus = evaObjectInfo.getUnitGoalsStatus().getValue();
            if (!"0".equals(String.valueOf(unitGoalsStatus))) continue;
            evaobjIds.add(evaObjId);
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", evaObjs, CompareType.INCLUDE));
        Map<String, String> stringSetMap = PersonInchargeUtils.getPersonInfoRelaPersonInchargeByids(ctx, evaobjIds);
        PerfEvaObjectCollection evaObjectCollection = PerfEvaObjectFactory.getLocalInstance(ctx).getPerfEvaObjectCollection("select id, personIncharge.person.number,personIncharge.person.name, personIncharge.* where " + filter.toSql() + "order by createTime ,id asc");
        if (evaObjectCollection != null && evaObjectCollection.size() > 0) {
            Iterator it2 = evaObjects.iterator();
            while (it2.hasNext()) {
                PerfEvaObjectInfo evaObjectInfo = (PerfEvaObjectInfo)it2.next();
                String id = evaObjectInfo.getId().toString();
                int unitGoalsStatus = evaObjectInfo.getUnitGoalsStatus().getValue();
                String perfPersonInchargeTemp = "";
                for (int i = 0; i < evaObjectCollection.size(); ++i) {
                    if (!evaObjectCollection.get(i).getId().toString().equals(evaObjectInfo.getId().toString())) continue;
                    perfPersonInchargeTemp = PersonInchargeUtils.getPersonInchargeStr(ctx, evaObjectCollection.get(i).getPersonIncharge());
                    break;
                }
                if ("0".equals(String.valueOf(unitGoalsStatus))) {
                    perfPersonInchargeTemp = perfPersonInchargeTemp == "" || perfPersonInchargeTemp == null ? stringSetMap.get(id) : perfPersonInchargeTemp + (stringSetMap.get(id) == null ? "" : stringSetMap.get(id));
                }
                perfPersonIncharge.put(id, perfPersonInchargeTemp == null ? "" : perfPersonInchargeTemp);
            }
        }
    }
}

