/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.sql.util.Base64;
import com.kingdee.shr.perfweb.utils.MD5;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    public static final String DEFAULT_AES_PWD = new String(new char[]{'k', 'i', 'n', 'g', 'd', 'e', 'e', '_', 'e', 'i', 'p', '_', 'a', 'g', 'e', 'n', 't'});
    private static final String MODEL = "AES/CBC/PKCS5Padding";

    public static byte[] encrypt(byte[] byteArray, String key) throws Exception {
        if (key == null) {
            return new byte[0];
        }
        String md5 = MD5.code(key);
        key = md5.substring(0, 16);
        String ivStr = md5.substring(16, 32);
        byte[] raw = key.getBytes("UTF-8");
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance(MODEL);
        IvParameterSpec iv = new IvParameterSpec(ivStr.getBytes("UTF-8"));
        cipher.init(1, (Key)skeySpec, iv);
        byte[] encrypted = cipher.doFinal(byteArray);
        return encrypted;
    }

    public static byte[] encrypt(String str, String key) throws Exception {
        return AESUtil.encrypt(str == null || str.length() == 0 ? new byte[]{} : str.getBytes("UTF-8"), key);
    }

    public static byte[] decrypt(byte[] encrypted, String key) throws Exception {
        if (key == null) {
            return new byte[0];
        }
        String md5 = MD5.code(key);
        key = md5.substring(0, 16);
        String ivStr = md5.substring(16, 32);
        byte[] raw = key.getBytes("UTF-8");
        SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
        Cipher cipher = Cipher.getInstance(MODEL);
        IvParameterSpec iv = new IvParameterSpec(ivStr.getBytes("UTF-8"));
        cipher.init(2, (Key)skeySpec, iv);
        byte[] original = cipher.doFinal(encrypted);
        return original;
    }

    public static String encryptToString(String str, String key) throws Exception {
        if (null == str || "".equals(str)) {
            throw new NullPointerException("the string to be encrypted is empty!");
        }
        byte[] aesBytes = AESUtil.encrypt(str, key);
        return Base64.encodeBytes((byte[])aesBytes);
    }

    public static String decryptToString(String str, String key) throws Exception {
        char[] chars;
        if (null == str || "".equals(str)) {
            throw new NullPointerException("the string to be decrypted is empty!");
        }
        byte[] aesBytes = Base64.decode((String)str);
        if (aesBytes == null || aesBytes.length == 0) {
            throw new Exception("decrypt input string error: '#decryptToString,' is invalid Base64 code!");
        }
        byte[] decryptBytes = AESUtil.decrypt(aesBytes, key);
        ByteBuffer byteBuffer = ByteBuffer.allocate(decryptBytes.length);
        byteBuffer.put(decryptBytes).flip();
        Charset charset = Charset.forName("utf-8");
        CharBuffer charBuffer = charset.decode(byteBuffer);
        StringBuilder decryptStr = new StringBuilder();
        for (char aChar : chars = charBuffer.array()) {
            decryptStr.append(aChar);
        }
        Arrays.fill(chars, ' ');
        return decryptStr.toString();
    }
}

