/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.message.common.KDMessageAttachment;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.bireport.bimanager.ws.paramCtx.util.Strings;
import com.kingdee.eas.mobile.MimeTypeEnum;
import com.kingdee.eas.mobile.framework.ByteArrayDataSource;
import com.kingdee.eas.mobile.framework.ServerCenter;
import com.kingdee.eas.mobile.framework.ServerCenterFactory;
import com.kingdee.eas.mobile.msg.MobileConnectException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEmailConfigCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEmailConfigFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEmailConfigInfo;
import com.kingdee.shr.perfweb.bean.PerfMailBean;
import com.kingdee.shr.perfweb.util.XmlUtil;
import com.kingdee.shr.perfweb.utils.EmailUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailServiceForPerf {
    private static Logger logger = LoggerFactory.getLogger(EmailServiceForPerf.class);
    private static final int SSL_PORT = 465;
    private static final int NORMAL_PORT = 25;
    public static final String DEFAULT_DEPLOY_PATH = System.getProperty("EAS_HOME") + File.separator + "server" + File.separator + "deploy" + File.separator + "easweb.ear" + File.separator + "shr_web.war" + File.separator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doSendEmail(final String password, String company, final String from, String to, String server, Boolean isSupportSSL, String subject, String content, Object attch) {
        boolean flag = false;
        Properties props = new Properties();
        props.put("mail.smtp.host", server);
        props.put("mail.smtp.auth", "true");
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.stmp.timeout", "3000");
        props.put("mail.smtp.localhost", "localhost");
        props.setProperty("mail.user", from);
        props.setProperty("mail.password", password);
        if (isSupportSSL.booleanValue()) {
            Security.setProperty("ssl.SocketFactory.provider", "");
            Security.setProperty("ssl.ServerSocketFactory.provider", "");
            props.put("mail.smtp.ssl.enable", "true");
            props.put("mail.smtp.ssl.socketFactory.class", "DummySSLSocketFactory");
            props.put("mail.smtp.ssl.socketFactory.fallback", "false");
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.port", (Object)465);
        } else {
            props.put("mail.smtp.port", (Object)25);
        }
        props.put("mail.mime.charset", "utf-8");
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            public PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(from, password);
            }
        });
        session.setDebug(false);
        MimeMessage message = new MimeMessage(session);
        Transport transport = null;
        try {
            message.setSentDate(new Date());
            message.setFrom((Address)new InternetAddress(from, company));
            message.setRecipients(Message.RecipientType.TO, (Address[])new InternetAddress[]{new InternetAddress(to)});
            message.setSubject(subject);
            MimeMultipart multipart = new MimeMultipart("related");
            if (attch != null) {
                // empty if block
            }
            content = EmailServiceForPerf.setMessageImageInformation(multipart, content);
            EmailServiceForPerf.setMessageContentInformation(multipart, content);
            message.setContent((Multipart)multipart);
            message.saveChanges();
            Transport.send((Message)message);
            flag = true;
        }
        catch (Exception e) {
            flag = false;
            logger.error("\u3010PERFWEB\u3011-send email failed ,sendtime :" + new Date(System.currentTimeMillis()));
            logger.error("\u3010PERFWEB\u3011----resend email-----", (Throwable)e);
            try {
                transport = session.getTransport("smtp");
                transport.connect();
                transport.sendMessage((Message)message, message.getAllRecipients());
                logger.error("\u3010PERFWEB\u3011----resend email success-----");
            }
            catch (MessagingException e1) {
                logger.error("\u3010PERFWEB\u3011----resend email failed-----", (Throwable)e1);
            }
        }
        finally {
            if (transport != null) {
                try {
                    transport.close();
                }
                catch (MessagingException e) {
                    logger.error("MessagingException: ", (Throwable)e);
                }
            }
        }
        return flag;
    }

    private static List<String> getAllImgPath(String content) {
        ArrayList<String> pathList = new ArrayList<String>();
        try {
            List<Element> elements;
            if (!"".equals(content) && null != content) {
                content = content.replaceAll("nbsp", "#160");
            }
            if ((elements = XmlUtil.getElementsByName(content, "img")) != null && elements.size() > 0) {
                for (int i = 0; i < elements.size(); ++i) {
                    pathList.add(elements.get(i).attributeValue("src"));
                }
            }
        }
        catch (Exception e) {
            logger.error("**************************:Failed to get mail contents of image path************************", (Throwable)e);
        }
        return pathList;
    }

    public static PerfMailBean getPerfMailConfig(Context ctx) {
        PerfMailBean mailBean = new PerfMailBean();
        String from = "";
        String passportStr = "";
        String server = "";
        String company = "";
        String id = "";
        boolean isSupportSSL = true;
        PerfEmailConfigCollection perfEmailConfigColl = EmailUtils.getEmailServerConfig(ctx);
        if (perfEmailConfigColl != null && perfEmailConfigColl.size() > 0) {
            PerfEmailConfigInfo perfEmailConfigInfo = perfEmailConfigColl.get(0);
            from = perfEmailConfigInfo.getAddress();
            passportStr = perfEmailConfigInfo.getPassword();
            server = perfEmailConfigInfo.getEmailServer();
            isSupportSSL = perfEmailConfigInfo.getIsSupportSSL().getValue().equals("1");
            company = perfEmailConfigInfo.getCompany();
            id = perfEmailConfigInfo.getId().toString();
        } else {
            try {
                PerfEmailConfigCollection defaultConfig = PerfEmailConfigFactory.getLocalInstance(ctx).getPerfEmailConfigCollection("select address,password,emailServer where type='0'");
                if (defaultConfig != null && defaultConfig.size() > 0) {
                    PerfEmailConfigInfo defaultEmailConfigInfo = defaultConfig.get(0);
                    from = defaultEmailConfigInfo.getAddress();
                    passportStr = defaultEmailConfigInfo.getPassword();
                    server = defaultEmailConfigInfo.getEmailServer();
                }
            }
            catch (BOSException e) {
                logger.error("\u3010PERFWEB\u3011 get default email config failed...");
                e.printStackTrace();
            }
        }
        mailBean.setFrom(from);
        mailBean.setPassword(passportStr);
        mailBean.setServer(server);
        mailBean.setCompany(company);
        mailBean.setSupportSSL(isSupportSSL);
        mailBean.setId(id);
        return mailBean;
    }

    public static void addEmailServerCount(Context ctx, String emailServerId, int addCount) throws BOSException {
        if (!Strings.isEmpty((String)emailServerId)) {
            StringBuilder updateSQLBuffer = new StringBuilder("UPDATE T_EVA_PerfEmailConfig SET FUseCount = FUseCount + ");
            updateSQLBuffer.append(addCount).append(" where fid = '").append(emailServerId).append("'");
            DbUtil.execute((Context)ctx, (String)updateSQLBuffer.toString());
        }
    }

    public static boolean sendEmail(Context ctx, String title, String receiverAddress, String secretReceiver, String copyReceiver, String content, Object attch) {
        boolean flag = false;
        try {
            ServerCenter server = ServerCenterFactory.getServerCenter((Context)ctx);
            flag = server.sendMailDerect(ctx, title, content, MimeTypeEnum.HTML, receiverAddress, secretReceiver, copyReceiver, null);
        }
        catch (MobileConnectException e) {
            logger.error("MobileConnectException: ", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error("EASBizException: ", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return flag;
    }

    public static boolean sendMail(Context ctx, boolean isSupportSSL, String smtpHost, final String userName, final String password, String from, String fromUser, String title, String content, MimeTypeEnum contentMimeType, String receiver, String secretReceiver, String copyReceiver, KDMessageAttachment[] attachment) throws BOSException, EASBizException {
        Properties props = System.getProperties();
        props.setProperty("mail.smtp.host", smtpHost);
        props.setProperty("mail.smtp.socketFactory.fallback", "false");
        props.put("mail.smtp.auth", "true");
        if (isSupportSSL) {
            Security.setProperty("ssl.SocketFactory.provider", "");
            Security.setProperty("ssl.ServerSocketFactory.provider", "");
            props.put("mail.smtp.ssl.enable", "true");
            props.put("mail.smtp.ssl.socketFactory.class", "DummySSLSocketFactory");
            props.put("mail.smtp.ssl.socketFactory.fallback", "false");
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.socketFactory.port", (Object)465);
            props.put("mail.smtp.port", (Object)465);
        } else {
            props.put("mail.smtp.port", (Object)25);
            props.put("mail.smtp.socketFactory.port", (Object)25);
        }
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(userName, password);
            }
        });
        session.setDebug(false);
        try {
            int i;
            MimeMessage msg = new MimeMessage(session);
            msg.setFrom((Address)new InternetAddress(from, fromUser));
            String[] toMailArray = receiver.split(";");
            InternetAddress[] tos = new InternetAddress[toMailArray.length];
            for (int i2 = 0; i2 < toMailArray.length; ++i2) {
                String to = toMailArray[i2];
                tos[i2] = new InternetAddress(to);
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])tos);
            if (copyReceiver != null && !"".equals(copyReceiver)) {
                String[] ccMailArray = copyReceiver.split(";");
                InternetAddress[] ccs = new InternetAddress[ccMailArray.length];
                for (i = 0; i < ccMailArray.length; ++i) {
                    String cc = ccMailArray[i];
                    ccs[i] = new InternetAddress(cc);
                }
                msg.setRecipients(Message.RecipientType.CC, (Address[])ccs);
            }
            if (secretReceiver != null && !"".equals(secretReceiver)) {
                String[] bccMailArray = secretReceiver.split(";");
                InternetAddress[] bccs = new InternetAddress[bccMailArray.length];
                for (i = 0; i < bccMailArray.length; ++i) {
                    String bcc = bccMailArray[i];
                    bccs[i] = new InternetAddress(bcc);
                }
                msg.setRecipients(Message.RecipientType.BCC, (Address[])bccs);
            }
            String stitle = "No Title.";
            if (title == null || title.equals("")) {
                logger.info("MailUtil-mail title is null");
            } else {
                stitle = title;
            }
            msg.setSubject(stitle);
            MimeBodyPart mbp1 = new MimeBodyPart();
            String contentType = null;
            contentType = MimeTypeEnum.HTML.equals((Object)contentMimeType) ? "text/html;charset=UTF-8" : "text/plain;charset=UTF-8";
            String scontent = "No Content.";
            if (content == null || content.equals("")) {
                if (!stitle.equals("No Title.")) {
                    scontent = stitle;
                }
                logger.info("MailUtil-mail content is null");
            } else {
                scontent = content;
            }
            mbp1.setContent((Object)scontent, contentType);
            MimeMultipart mp = new MimeMultipart();
            if (attachment != null && attachment.length > 0) {
                for (int i3 = 0; i3 < attachment.length; ++i3) {
                    KDMessageAttachment attachmentItem = attachment[i3];
                    if (attachmentItem.getData() != null) {
                        String fileName = attachmentItem.getName();
                        if (fileName == null || "".equals(fileName.trim())) {
                            fileName = "noname";
                            logger.info("MailUtil-attachment: attachment name is null");
                        }
                        MimeBodyPart mbp2 = new MimeBodyPart();
                        DataHandler dh = new DataHandler((DataSource)new ByteArrayDataSource(attachmentItem.getData(), "application/octet-stream", fileName));
                        mbp2.setDataHandler(dh);
                        mbp2.setFileName(fileName);
                        mbp2.setHeader("Content-ID", fileName);
                        mp.addBodyPart((BodyPart)mbp2);
                        continue;
                    }
                    logger.info("MailUtil-attachment warning: attachment data is null");
                }
            }
            mp.addBodyPart((BodyPart)mbp1);
            msg.setContent((Multipart)mp);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (MessagingException mex) {
            logger.error("MailUtil-sendMail error:" + mex.getMessage());
            throw new BOSException((Throwable)mex);
        }
        catch (UnsupportedEncodingException e) {
            logger.error("MailUtil-sendMail error:" + e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private static String setMessageImageInformation(MimeMultipart textMp, String content) throws MessagingException {
        List<String> imgList = EmailServiceForPerf.getAllImgPath(content);
        if (imgList != null && imgList.size() > 0) {
            logger.info("**************************here are pictures, with pictures sending************************");
            int i = 0;
            Iterator<String> iterator = imgList.iterator();
            while (iterator.hasNext()) {
                String imgPath;
                String orgImgPath = imgPath = iterator.next();
                MimeBodyPart imgPart = new MimeBodyPart();
                DataHandler dataHandler = null;
                if (imgPath.startsWith("http")) {
                    try {
                        dataHandler = new DataHandler(new URL(imgPath));
                    }
                    catch (MalformedURLException e) {
                        logger.error("MalformedURLException: ", (Throwable)e);
                    }
                } else {
                    File file = new File(imgPath);
                    if (!file.exists() && !(file = new File(SHRCheck.checkFilePath((String)(imgPath = DEFAULT_DEPLOY_PATH + File.separator + imgPath)))).exists()) continue;
                    dataHandler = new DataHandler((DataSource)new FileDataSource(SHRCheck.checkFilePath((String)imgPath)));
                }
                if (dataHandler == null) continue;
                imgPart.setDataHandler(dataHandler);
                imgPart.setHeader("Content-ID", "<image" + i + ">");
                textMp.addBodyPart((BodyPart)imgPart);
                content = content.replace(orgImgPath, "cid:image" + i);
                ++i;
            }
        }
        return content;
    }

    private static void setMessageContentInformation(MimeMultipart textMp, String content) throws MessagingException {
        MimeBodyPart textPart = new MimeBodyPart();
        textPart.setContent((Object)content, "text/html; charset=utf-8");
        textMp.addBodyPart((BodyPart)textPart);
    }
}

