/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.util.URIUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.utils.HttpUtils");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, String queryString) {
        String response = null;
        HttpClient client = new HttpClient();
        GetMethod method = new GetMethod(url);
        try {
            if (!StringUtils.isEmpty((String)queryString)) {
                method.setQueryString(URIUtil.encodeQuery((String)queryString));
            }
            client.executeMethod((HttpMethod)method);
            if (method.getStatusCode() == 200) {
                response = method.getResponseBodyAsString();
            }
        }
        catch (URIException e) {
            logger.error("Codding query String '" + queryString + "', an exception occurs when performing a HTTP Get request");
        }
        catch (IOException e) {
            logger.error("url '" + url + "', an exception occurs when performing a HTTP Get request");
        }
        finally {
            method.releaseConnection();
        }
        return response;
    }

    public static byte[] download(String path, Map<String, String> param) throws Exception {
        String paramString = param.toString();
        HttpClient client = new HttpClient();
        GetMethod get = null;
        byte[] ret = null;
        get = new GetMethod(path);
        if (param != null && param.size() > 0) {
            NameValuePair[] datas = new NameValuePair[param.size()];
            int index = 0;
            for (String key : param.keySet()) {
                datas[index++] = new NameValuePair(key, param.get(key));
            }
            get.setQueryString(datas);
        }
        long startTime = System.currentTimeMillis();
        int statusCode = client.executeMethod((HttpMethod)get);
        if (statusCode != 200) {
            System.err.println(" http response status is " + statusCode);
            System.err.println(" content " + get.getResponseBodyAsString());
            throw new BOSException("url" + path + get.getQueryString() + "==http response status is " + statusCode + " content " + get.getResponseBodyAsString());
        }
        ret = get.getResponseBody();
        get.releaseConnection();
        client.getHttpConnectionManager().closeIdleConnections(0L);
        long endTime = System.currentTimeMillis();
        float usrTime = (float)(endTime - startTime) / 1000.0f;
        return ret;
    }

    public static String post(String path, Map<String, String> param, String charset, String contentType) throws Exception {
        String result;
        block10: {
            String paramString = param.toString();
            result = null;
            PostMethod postMethod = null;
            HttpClient httpClient = new HttpClient();
            httpClient.getParams().setParameter("http.protocol.content-charset", (Object)charset);
            postMethod = new PostMethod(path);
            if (!StringUtils.isEmpty((String)contentType)) {
                postMethod.addRequestHeader("Content-Type", contentType);
            }
            if (param != null && param.size() > 0) {
                NameValuePair[] datas = new NameValuePair[param.size()];
                int index = 0;
                for (String key : param.keySet()) {
                    datas[index++] = new NameValuePair(key, param.get(key));
                }
                postMethod.setRequestBody(datas);
            }
            HttpClientParams httparams = new HttpClientParams();
            httparams.setSoTimeout(60000);
            postMethod.setParams((HttpMethodParams)httparams);
            try {
                int statusCode = httpClient.executeMethod((HttpMethod)postMethod);
                if (statusCode == 200) {
                    result = postMethod.getResponseBodyAsString();
                    break block10;
                }
                result = "Please check the QUESCLOUD web site config is correct in table[T PEF Ques Server] , [wjy.kingdee.com]";
                System.err.println(" http response status is " + statusCode);
                System.err.println(" content " + postMethod.getResponseBodyAsString());
                throw new SHRPerfWebBizException(SHRPerfWebBizException.HTTPCONNECTERR, new Object[]{result, statusCode, postMethod.getResponseBodyAsString()});
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (postMethod != null) {
                    postMethod.releaseConnection();
                }
            }
        }
        logger.error("api:" + path + "/n result:" + result);
        return result;
    }

    public static String mapToString(Map<String, String> param) {
        String map = "";
        if (!param.isEmpty()) {
            for (Map.Entry<String, String> entry : param.entrySet()) {
                map = map + entry.getKey() + "=" + entry.getValue() + "&";
            }
            map.substring(0, map.length() - 1);
            return map;
        }
        return "";
    }
}

