/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.service.SHRFunctionPermissionService;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PermissionUtils {
    private static Logger logger = LoggerFactory.getLogger(PermissionUtils.class);
    private static final String MAINCODE = "10";
    public static final NumericExceptionSubItem PERMISSIONERROR = new NumericExceptionSubItem("999", "PERMISSIONERROR");

    public static void checkPermission(Context ctx, String url) throws EASBizException {
        PermItemInfo permItemInfo = PermissionUtils.getPermisionInfoByUrl(url, ctx);
        if (permItemInfo != null && !StringUtils.isEmpty((String)permItemInfo.getName())) {
            try {
                OrgUnitInfo mainOrg = PermissionUtils.getOrgUnitInfoByPermItemInfo(ctx, permItemInfo);
                PermissionUtils.checkFunctionPermission(ctx, permItemInfo.getName(), mainOrg);
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
                throw new EASBizException(PERMISSIONERROR, (Throwable)e);
            }
        }
    }

    public static OrgUnitInfo getOrgUnitInfoByPermItemInfo(Context ctx, PermItemInfo permItemInfo) {
        HROrgUnitInfo mainOrg = null;
        if (permItemInfo.getOrgRelation() != null && !permItemInfo.getOrgRelation().equals((Object)OrgType.NONE)) {
            mainOrg = (OrgUnitInfo)ctx.get((Object)permItemInfo.getOrgRelation());
        }
        if (mainOrg == null) {
            mainOrg = ContextUtil.getCurrentHRUnit((Context)ctx);
        }
        return mainOrg;
    }

    public static PermItemInfo getPermisionInfoByUrl(String url, Context ctx) throws EASBizException {
        PermItemInfo permItemInfo = null;
        try {
            Class<?> clazz = Class.forName("com.kingdee.shr.base.syssetting.app.cache.PermItemURLCache");
            Method method = clazz.getMethod("getPermItemInfoByURL", Context.class, String.class);
            permItemInfo = (PermItemInfo)method.invoke(clazz, ctx, url);
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
            throw new EASBizException(PERMISSIONERROR, (Throwable)e);
        }
        return permItemInfo;
    }

    public static PermItemInfo getPermisionInfoByUrlFromDB(String url, Context ctx) throws EASBizException {
        PermItemInfo permItemInfo = null;
        StringBuffer sql = new StringBuffer(300);
        sql.append("SELECT pm.FID, pm.FName,pm.Fnumber,").append(" pm.FOrgRelation,u.FURL ").append(" FROM T_PM_PermItem pm ").append(" inner join T_PM_PermItemURL u on u.FParentID = pm.fid where u.FUrl='" + url + "'");
        try {
            IRowSet rowSet = null;
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            String id = null;
            while (rowSet.next()) {
                url = rowSet.getString("FURL");
                id = rowSet.getString("FID");
                if (StringUtils.isEmpty((String)url)) continue;
                permItemInfo = new PermItemInfo();
                permItemInfo.setId(BOSUuid.read((String)rowSet.getString("FID")));
                permItemInfo.setName(rowSet.getString("FName"));
                permItemInfo.setNumber(rowSet.getString("FNumber"));
                permItemInfo.setOrgRelation(OrgType.getEnum((int)rowSet.getInt("FOrgRelation")));
            }
        }
        catch (Exception e) {
            logger.error("Exception: ", (Throwable)e);
        }
        return permItemInfo;
    }

    public static boolean hasFunctionPermission(Context ctx, String url) throws EASBizException {
        PermItemInfo permItemInfo = PermissionUtils.getPermisionInfoByUrl(url, ctx);
        if (permItemInfo != null && !StringUtils.isEmpty((String)permItemInfo.getName())) {
            try {
                SHRFunctionPermissionService.checkCurrnetUserFunctionPermission((Context)ctx, (PermItemInfo)permItemInfo);
                return true;
            }
            catch (Exception e) {
                logger.error("permission err occurred, permItem: " + permItemInfo.getName());
            }
        }
        return false;
    }

    public static Map<String, String> checkFunctionPermission(Context ctx, String url) {
        HashMap<String, String> map = new HashMap<String, String>();
        PermItemInfo permItemInfo = null;
        try {
            permItemInfo = PermissionUtils.getPermisionInfoByUrl(url, ctx);
        }
        catch (EASBizException e1) {
            logger.error("", (Throwable)e1);
        }
        if (permItemInfo != null && !StringUtils.isEmpty((String)permItemInfo.getName())) {
            try {
                OrgUnitInfo mainOrg = PermissionUtils.getOrgUnitInfoByPermItemInfo(ctx, permItemInfo);
                PermissionUtils.checkFunctionPermission(ctx, permItemInfo.getName(), mainOrg);
                boolean hasPerm = PermissionUtils.hasFunctionPermission(ctx, url);
                map.put("hasPerm", String.valueOf(hasPerm));
                map.put("msg", "");
            }
            catch (Exception e) {
                map.put("msg", e.getMessage());
            }
        }
        return map;
    }

    public static void checkFunctionPermission(Context ctx, String permItemName, OrgUnitInfo mainOrg) throws BOSException, EASBizException {
        IPermission perm = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK orgPK = null;
        OrgUnitInfo org = mainOrg;
        if (mainOrg == null) {
            org = (OrgUnitInfo)ctx.get((Object)OrgType.ControlUnit);
        }
        if (org != null) {
            orgPK = new ObjectUuidPK(org.getId());
        }
        ObjectUuidPK userPK = null;
        CoreBaseInfo user = (CoreBaseInfo)ctx.get((Object)"UserInfo");
        if (user != null) {
            userPK = new ObjectUuidPK(user.getId());
        }
        perm.checkFunctionPermission(userPK, (IObjectPK)orgPK, permItemName);
    }
}

