/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.hraux.FolkCollection;
import com.kingdee.eas.basedata.hraux.FolkFactory;
import com.kingdee.eas.basedata.hraux.PoliticalFaceInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmpLaborRelationCollection;
import com.kingdee.eas.hr.base.EmpLaborRelationFactory;
import com.kingdee.eas.hr.base.EmpLaborRelationInfo;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.base.EnrollSourceCollection;
import com.kingdee.eas.hr.base.EnrollSourceFactory;
import com.kingdee.eas.hr.base.IEmpLaborRelation;
import com.kingdee.eas.hr.base.IEnrollSource;
import com.kingdee.eas.hr.emp.EmpPostRankCollection;
import com.kingdee.eas.hr.emp.EmpPostRankFactory;
import com.kingdee.eas.hr.emp.IPersonOtherInfo;
import com.kingdee.eas.hr.emp.IPersonPosition;
import com.kingdee.eas.hr.emp.PersonOtherInfoCollection;
import com.kingdee.eas.hr.emp.PersonOtherInfoFactory;
import com.kingdee.eas.hr.emp.PersonOtherInfoInfo;
import com.kingdee.eas.hr.emp.PersonPositionCollection;
import com.kingdee.eas.hr.emp.PersonPositionFactory;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.org.HRJobCollection;
import com.kingdee.eas.hr.org.HRJobFactory;
import com.kingdee.eas.hr.org.HRJobInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.perfweb.app.base.evalplan.IPersonBaseOfGoals;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEvaObjectInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PersonBaseOfGoalsFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.PersonBaseOfGoalsInfo;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.utils.OrgAssessmentUtils;
import com.kingdee.shr.perfweb.utils.PhotoUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersonBaseOfGoalsUtils {
    public static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.perfweb.utils.PersonBaseOfGoalsUtils");

    public static int calculateAge(Date birthday) {
        int age = 0;
        if (birthday != null) {
            long times = System.currentTimeMillis() - birthday.getTime();
            age = (int)(times / 1000L / 86400L / 365L);
        }
        return age;
    }

    public static int getPersonAge(Context ctx, String personId) {
        int age = 0;
        try {
            IPersonOtherInfo ipersonOther = PersonOtherInfoFactory.getLocalInstance((Context)ctx);
            PersonOtherInfoCollection personOtherInfoColl = ipersonOther.getPersonOtherInfoCollection("where person='" + personId + "'");
            if (null != personOtherInfoColl && personOtherInfoColl.size() > 0) {
                age = personOtherInfoColl.get(0).getAge();
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return age;
    }

    public static PersonBaseOfGoalsInfo fillPersonBaseOfGoalsInfo(Context ctx, String evaObj, String person, String period, String beGroup) throws BOSException, EASBizException, ParserException {
        IPerson iperson;
        PersonCollection personColl;
        IPersonBaseOfGoals ipersonBaseOfGoals = PersonBaseOfGoalsFactory.getLocalInstance(ctx);
        PersonBaseOfGoalsInfo personBaseInfo = new PersonBaseOfGoalsInfo();
        PerfEvaObjectInfo perfEvaObjInfo = GetEntityInfoUtils.getPerfEvaObjectInfo(ctx, evaObj);
        if (OrgAssessmentUtils.isOrgAssessment(perfEvaObjInfo)) {
            return null;
        }
        if (perfEvaObjInfo != null) {
            personBaseInfo.setBelongOrg(perfEvaObjInfo.getAdminOrgUnit().getId().toString());
            personBaseInfo.put("position", perfEvaObjInfo.getPerfFile().getPosition().getId().toString());
            personBaseInfo.setPnumber(perfEvaObjInfo.getNumber());
        }
        if ((personColl = (iperson = PersonFactory.getLocalInstance((Context)ctx)).getPersonCollection("select name,number,employeeType,idCardNO,passPortNO,birthday,politicalFace,folk  where id='" + person + "'")) != null && personColl.size() > 0) {
            IPersonOtherInfo iPersonOtherInfo;
            PersonOtherInfoCollection personOtherInfoCollection;
            PersonInfo personInfo = personColl.get(0);
            personBaseInfo.put("evaObj", evaObj);
            personBaseInfo.put("perfGoalsGorup", beGroup);
            personBaseInfo.setPname(personInfo.getName());
            if (personInfo.getEmployeeType() != null && personInfo.getEmployeeType().getId() != null) {
                personBaseInfo.put("employeeType", personInfo.getEmployeeType().getId().toString());
            }
            personBaseInfo.setIdCardNo(personInfo.getIdCardNO());
            personBaseInfo.setPhotoId(null);
            personBaseInfo.setPhotoPath(PhotoUtils.getPhotoPath(ctx, person, personInfo.getNumber()));
            personBaseInfo.setPassPortNo(personInfo.getPassportNO());
            personBaseInfo.put("age", PersonBaseOfGoalsUtils.calculateAge(personInfo.getBirthday()));
            if (personInfo.getPoliticalFace() != null) {
                PoliticalFaceInfo politicalFaceInfo = GetEntityInfoUtils.getPoliticalFaceInfo(ctx, personInfo.getPoliticalFace().getId().toString());
                personBaseInfo.setPolitics(politicalFaceInfo.getName());
            }
            try {
                FolkCollection folkColl;
                if ((personInfo.getFolk() != null || personInfo.getFolk().getId() != null) && (folkColl = FolkFactory.getLocalInstance((Context)ctx).getFolkCollection(" where id='" + personInfo.getFolk().getId().toString() + "'")) != null && folkColl.size() > 0) {
                    personBaseInfo.setNation(folkColl.get(0).getName());
                }
            }
            catch (Exception e) {
                personBaseInfo.setNation("");
            }
            boolean noJobGrade = true;
            EmpPosOrgRelationInfo relationInfo = perfEvaObjInfo.getPerfFile().getEmpPosOrgRelation();
            if (relationInfo != null) {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("person", (Object)person));
                filter.getFilterItems().add(new FilterItemInfo("EFFDT", (Object)relationInfo.getEFFDT()));
                filter.getFilterItems().add(new FilterItemInfo("LEFFDT", (Object)relationInfo.getLEFFDT()));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("jobGrade.id"));
                view.setSelector(sic);
                view.setFilter(filter);
                EmpPostRankCollection eprColl = EmpPostRankFactory.getLocalInstance((Context)ctx).getEmpPostRankCollection(view);
                if (eprColl.size() > 0 && eprColl.get(0).getJobGrade() != null) {
                    personBaseInfo.put("jobGrade", eprColl.get(0).getJobGrade().getId().toString());
                    noJobGrade = false;
                }
            }
            if (noJobGrade) {
                String selectEmpPosOrgSql = " select FID,FJOBGRADEID from T_HR_EmpPostRank where FPersonID='" + person + "' order by FEFFDT desc";
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectEmpPosOrgSql);
                try {
                    if (rowSet != null && rowSet.next()) {
                        personBaseInfo.put("jobGrade", rowSet.getString("FJOBGRADEID"));
                    } else {
                        personBaseInfo.put("jobGrade", "");
                    }
                }
                catch (Exception e) {
                    logger.error("the employee position error information such as\uff1a", (Throwable)e);
                }
            }
            IPersonPosition ipersonPos = PersonPositionFactory.getLocalInstance((Context)ctx);
            PersonPositionCollection personPosColl = ipersonPos.getPersonPositionCollection("select *,jobGrade.type.name,primaryPosition.job.id where person='" + person + "'");
            IEmpLaborRelation iEmpLaborRelation = EmpLaborRelationFactory.getLocalInstance((Context)ctx);
            EmpLaborRelationCollection empLaborRelationColl = iEmpLaborRelation.getEmpLaborRelationCollection(" where person='" + person + "'");
            if (personPosColl != null && personPosColl.size() > 0) {
                PersonPositionInfo personPosInfo = personPosColl.get(0);
                if (personPosInfo.getPrimaryPosition() != null && personPosInfo.getPrimaryPosition().getJob() != null) {
                    String jobId = personPosInfo.getPrimaryPosition().getJob().getId().toString();
                    HRJobCollection hrJobColl = HRJobFactory.getLocalInstance((Context)ctx).getHRJobCollection("select hrJobSystemClassify.name,hrJobFamily.name,hrJobSubCategory.name where job = '" + jobId + "'");
                    if (hrJobColl != null && hrJobColl.size() > 0) {
                        HRJobInfo hrJobInfo = hrJobColl.get(0);
                        if (hrJobInfo.getHrJobSystemClassify() != null) {
                            personBaseInfo.put("hrJobSystemClassify", hrJobInfo.getHrJobSystemClassify().getName());
                        } else {
                            personBaseInfo.put("hrJobSystemClassify", "");
                        }
                        if (hrJobInfo.getHrJobFamily() != null) {
                            personBaseInfo.put("hrJobFamily", hrJobInfo.getHrJobFamily().getName());
                        } else {
                            personBaseInfo.put("hrJobFamily", "");
                        }
                        if (hrJobInfo.getHrJobSubCategory() != null) {
                            personBaseInfo.put("hrJobSubCategory", hrJobInfo.getHrJobSubCategory().getName());
                        } else {
                            personBaseInfo.put("hrJobSubCategory", "");
                        }
                    }
                }
                if (empLaborRelationColl != null && empLaborRelationColl.size() > 0) {
                    EmpLaborRelationInfo empLaborRelationInfo = empLaborRelationColl.get(0);
                    if (empLaborRelationInfo.getEnrollSource() != null && empLaborRelationInfo.getEnrollSource().getId() != null) {
                        String entrySourceId = empLaborRelationInfo.getEnrollSource().getId().toString();
                        IEnrollSource ienrollSource = EnrollSourceFactory.getLocalInstance((Context)ctx);
                        EnrollSourceCollection enrollSourceColl = ienrollSource.getEnrollSourceCollection(" where id='" + entrySourceId + "'");
                        if (enrollSourceColl != null && enrollSourceColl.size() > 0) {
                            personBaseInfo.put("entrySource", enrollSourceColl.get(0).getName());
                        }
                    } else {
                        personBaseInfo.put("entrySource", "");
                    }
                    personBaseInfo.setEnteryDate(empLaborRelationInfo.getEnterDate());
                    personBaseInfo.setProbation(String.valueOf(empLaborRelationInfo.getTryoutMonth()));
                    personBaseInfo.setConversionDate(empLaborRelationInfo.getActualFormalDate());
                }
                personBaseInfo.setLeaveDate(personPosInfo.getLeftDate());
                personBaseInfo.setJoinGroupDate(personPosInfo.getJoinGroupDate());
                personBaseInfo.setAdjustGroupDate(personPosInfo.getAdjustGroupVal());
                personBaseInfo.setJoinCompanyDate(personPosInfo.getJoinDate());
                personBaseInfo.setAdjustCompanyDate(personPosInfo.getAdjustCoValue());
                personBaseInfo.setAdjustWorkDate(personPosInfo.getAdjustWorkValue());
                personBaseInfo.setIsKeyStaff(personPosInfo.isIsImpt() == Boolean.TRUE.booleanValue() ? "1" : "0");
                personBaseInfo.setIsInChargeLeader(personPosInfo.isIsLeader() == Boolean.TRUE.booleanValue() ? "1" : "0");
                personBaseInfo.setTakeInManDate(null);
                personBaseInfo.put("joinGroupYears", Float.valueOf(personPosInfo.getJoinGroupYears()));
                personBaseInfo.put("joinCompanyYears", Float.valueOf(personPosInfo.getJoinCompanyYears()));
            }
            if (null != (personOtherInfoCollection = (iPersonOtherInfo = PersonOtherInfoFactory.getLocalInstance((Context)ctx)).getPersonOtherInfoCollection(" where person='" + person + "'")) && personOtherInfoCollection.size() > 0) {
                PersonOtherInfoInfo personOtherInfo = personOtherInfoCollection.get(0);
                personBaseInfo.setJoinWorkDate(personOtherInfo.getJobStartDate());
                personBaseInfo.put("newWorkTime", personOtherInfo.getSocialServiceYears());
            }
        }
        return personBaseInfo;
    }
}

