/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ctrl.semantic.model.base;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.shr.ctrl.semantic.model.base.AbstractSemanticEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SemanticRelation {
    private boolean _isStandard;
    private String _description;
    private AbstractSemanticEntity _client;
    private AbstractSemanticEntity _supplier;
    private JoinType _joinType = JoinType.INNER;
    private List _conditions = new ArrayList();
    private Map _properties;

    public void setStandard(boolean isStandard) {
        this._isStandard = isStandard;
    }

    public boolean isStandard() {
        return this._isStandard;
    }

    public void setDescription(String text) {
        this._description = text;
    }

    public String getDescription() {
        return this._description;
    }

    public AbstractSemanticEntity getClient() {
        return this._client;
    }

    public void setClient(AbstractSemanticEntity client) {
        this._client = client;
    }

    public AbstractSemanticEntity getSupplier() {
        return this._supplier;
    }

    public void setSupplier(AbstractSemanticEntity supplier) {
        this._supplier = supplier;
    }

    public JoinType getJoinType() {
        return this._joinType;
    }

    public void setJoinType(JoinType joinType) {
        this._joinType = joinType;
    }

    public boolean isCustomExpr() {
        return this._conditions.size() > 0 && this._conditions.get(0) instanceof CustomExpr;
    }

    public void addCondition(ICondition condition) {
        this._conditions.add(condition);
    }

    public void removeAllCondition() {
        this._conditions.clear();
    }

    public int getConditionCount() {
        return this._conditions.size();
    }

    public ICondition getCondition(int index) {
        return (ICondition)this._conditions.get(index);
    }

    private Map getProperties() {
        if (this._properties == null) {
            this._properties = new HashMap();
        }
        return this._properties;
    }

    public void setProperty(String key, Object value) {
        this.getProperties().put(key, value);
    }

    public Object getProperty(String key) {
        if (this._properties == null) {
            return null;
        }
        return this.getProperties().get(key);
    }

    public static boolean strictCompare(SemanticRelation r1, SemanticRelation r2) {
        if (!StringUtil.equals((String)r1.getDescription(), (String)r2.getDescription()) || r1.getJoinType() != r2.getJoinType()) {
            return false;
        }
        return SemanticRelation.looseCompare(r1, r2);
    }

    public static boolean looseCompare(SemanticRelation r1, SemanticRelation r2) {
        if (r1.isCustomExpr()) {
            if (r2.isCustomExpr() && StringUtil.equals((String)((CustomExpr)r1.getCondition(0)).getExpr(), (String)((CustomExpr)r2.getCondition(0)).getExpr())) {
                return true;
            }
        } else if (!r2.isCustomExpr() && r1.getConditionCount() == r2.getConditionCount()) {
            for (int j = r1.getConditionCount() - 1; j >= 0; --j) {
                JoinLine line1 = (JoinLine)r1.getCondition(j);
                JoinLine line2 = (JoinLine)r2.getCondition(j);
                if (StringUtil.equals((String)line1.getClientField(), (String)line2.getClientField()) && StringUtil.equals((String)line1.getSupplierField(), (String)line2.getSupplierField())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class JoinType {
        private static final Map ForLoad = new HashMap();
        public static final JoinType INNER = new JoinType("inner join", "I");
        public static final JoinType LEFT = new JoinType("left join", "L");
        public static final JoinType RIGHT = new JoinType("right join", "R");
        public static final JoinType FULL = new JoinType("full join", "F");
        private String _type;
        private String _shortForSave;

        private JoinType(String type, String shortForSave) {
            this._type = type;
            this._shortForSave = shortForSave;
            if (ForLoad.containsKey(shortForSave)) {
                throw new RuntimeException("You must modify code.");
            }
            ForLoad.put(shortForSave, this);
        }

        public String toString() {
            return this._type;
        }

        public String getSaveString() {
            return this._shortForSave;
        }

        public static JoinType getInst(String shortForSave) {
            JoinType inst = (JoinType)ForLoad.get(shortForSave);
            if (inst == null) {
                return INNER;
            }
            return inst;
        }
    }

    public static class CustomExpr
    implements ICondition {
        private String _expr;

        public String getExpr() {
            return this._expr;
        }

        public void setExpr(String expr) {
            this._expr = expr;
        }
    }

    public static class JoinLine
    implements ICondition {
        private String _clientField;
        private String _supplierField;

        public JoinLine(String clientField, String supplierField) {
            this._clientField = clientField;
            this._supplierField = supplierField;
        }

        public String getClientField() {
            return this._clientField;
        }

        public String getSupplierField() {
            return this._supplierField;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this._clientField);
            sb.append(" = ");
            sb.append(this._supplierField);
            return sb.toString();
        }
    }

    public static interface ICondition {
    }
}

