/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ctrl.semantic.use;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.common.util.UID;
import com.kingdee.shr.ctrl.semantic.model.base.AbstractSemanticEntity;
import com.kingdee.shr.ctrl.semantic.model.base.AbstractSemanticField;
import com.kingdee.shr.ctrl.semantic.model.base.SemanticExprField;
import com.kingdee.shr.ctrl.semantic.model.base.SemanticField;
import com.kingdee.shr.ctrl.semantic.model.base.SemanticRelation;
import com.kingdee.shr.ctrl.semantic.model.base.SemanticTable;
import com.kingdee.shr.ctrl.semantic.model.base.SemanticView;
import com.kingdee.shr.ctrl.semantic.model.trans.InfoWrapper;
import com.kingdee.shr.ctrl.semantic.model.trans.SchemaBriefModel;
import com.kingdee.shr.ctrl.semantic.use.SemanticUsetimeModel;
import com.kingdee.shr.ctrl.semantic.use.exception.EntitiesNotFoundException;
import com.kingdee.shr.ctrl.semantic.use.exception.RelationsNotFoundException;
import com.kingdee.shr.ctrl.semantic.use.exception.SemanticUsedException;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;

public class SemanticUsetimeModelIO {
    public static final String E_SEMANTIC = "Semantic";
    private static final String K_ID = "usetimeSavedId";

    public static Element toXml(SemanticUsetimeModel semanticModel) {
        AbstractSemanticEntity[] entities;
        Element root = new Element(E_SEMANTIC);
        root.setAttribute("version", "1.0");
        root.setAttribute("schemaId", semanticModel.getSchemaId());
        root.setAttribute("schemaName", semanticModel.getSchemaName());
        for (AbstractSemanticEntity entity : semanticModel.getEntities()) {
            entity.setProperty(K_ID, UID.create16());
        }
        for (AbstractSemanticEntity entity : entities) {
            int j;
            Element nodeEntity = new Element("Entity");
            if (entity instanceof SemanticTable) {
                nodeEntity.setAttribute("type", "table");
            } else if (entity instanceof SemanticView) {
                nodeEntity.setAttribute("type", "view");
            } else {
                throw new RuntimeException("You must modify code.");
            }
            nodeEntity.setAttribute("id", (String)entity.getProperty(K_ID));
            nodeEntity.setAttribute("name", entity.getPhysicalName());
            Rectangle rect = (Rectangle)entity.getProperty("rect");
            nodeEntity.setAttribute("x", String.valueOf(rect.x));
            nodeEntity.setAttribute("y", String.valueOf(rect.y));
            nodeEntity.setAttribute("width", String.valueOf(rect.width));
            nodeEntity.setAttribute("height", String.valueOf(rect.height));
            int jc = entity.getFieldCount();
            for (j = 0; j < jc; ++j) {
                Element nodeField = new Element("Field");
                nodeField.setAttribute("name", entity.getField(j).getPhysicalName());
                nodeEntity.addContent((Content)nodeField);
            }
            jc = entity.getExprFieldCount();
            for (j = 0; j < jc; ++j) {
                Element nodeExpr = new Element("Field");
                nodeExpr.setAttribute("type", "expr");
                nodeExpr.setAttribute("name", entity.getExprField(j).getPhysicalName());
                nodeEntity.addContent((Content)nodeExpr);
            }
            jc = entity.getRelationsCount();
            for (j = 0; j < jc; ++j) {
                SemanticRelation relation = entity.getRelation(j);
                Element nodeRelation = new Element("Relation");
                nodeRelation.setAttribute("joinType", relation.getJoinType().getSaveString());
                nodeRelation.setAttribute("supplierId", (String)relation.getSupplier().getProperty(K_ID));
                if (relation.isCustomExpr()) {
                    String expr = ((SemanticRelation.CustomExpr)relation.getCondition(0)).getExpr();
                    nodeRelation.addContent((Content)new CDATA(expr));
                } else {
                    int kc = relation.getConditionCount();
                    for (int k = 0; k < kc; ++k) {
                        SemanticRelation.JoinLine line = (SemanticRelation.JoinLine)relation.getCondition(k);
                        Element nodeLink = new Element("Link");
                        nodeLink.setAttribute("clientField", line.getClientField());
                        nodeLink.setAttribute("supplierField", line.getSupplierField());
                        nodeRelation.addContent((Content)nodeLink);
                    }
                }
                nodeEntity.addContent((Content)nodeRelation);
            }
            root.addContent((Content)nodeEntity);
        }
        return root;
    }

    public static SemanticUsetimeModel fromXml(Element root) {
        String schemaId = root.getAttributeValue("schemaId");
        String schemaName = root.getAttributeValue("schemaName");
        SchemaBriefModel schema = new SchemaBriefModel();
        schema.setId(schemaId);
        schema.setName(schemaName);
        SemanticUsetimeModel semanticModel = new SemanticUsetimeModel(schema);
        semanticModel.setXmlPreload(root);
        return semanticModel;
    }

    public static String[] load(SemanticUsetimeModel semanticModel, ILoadEnv loadEnv) throws SemanticUsedException {
        Element root = semanticModel.getXmlPreload();
        List tables = root.getChildren("Entity");
        int size = tables.size();
        if (size == 0) {
            return null;
        }
        String[] names = new String[size];
        Rectangle[] rects = new Rectangle[size];
        for (int i = 0; i < size; ++i) {
            Element nodeTable = (Element)tables.get(i);
            names[i] = nodeTable.getAttributeValue("name");
            Rectangle rect = new Rectangle();
            rect.x = Integer.parseInt(nodeTable.getAttributeValue("x"));
            rect.y = Integer.parseInt(nodeTable.getAttributeValue("y"));
            rect.width = Integer.parseInt(nodeTable.getAttributeValue("width"));
            rect.height = Integer.parseInt(nodeTable.getAttributeValue("height"));
            rects[i] = rect;
        }
        InfoWrapper[] infoWrappers = loadEnv.loadEntities(semanticModel.getSchemaId(), names);
        AbstractSemanticEntity[] entities = new AbstractSemanticEntity[size];
        HashMap<String, AbstractSemanticEntity> id2Obj = new HashMap<String, AbstractSemanticEntity>();
        for (int i = 0; i < size; ++i) {
            Element nodeTable = (Element)tables.get(i);
            entities[i] = loadEnv.addEntity(infoWrappers[i], rects[i]);
            String id = nodeTable.getAttributeValue("id");
            entities[i].setProperty(K_ID, id);
            id2Obj.put(id, entities[i]);
        }
        HashSet<String> notFoundFileds = new HashSet<String>();
        RelationsNotFoundException relationsNotFoundEx = null;
        for (int i = 0; i < size; ++i) {
            Element nodeTable = (Element)tables.get(i);
            List fieldsList = nodeTable.getChildren("Field");
            int fieldsCount = fieldsList.size();
            AbstractSemanticField[] fields = new AbstractSemanticField[fieldsCount];
            for (int j = 0; j < fieldsCount; ++j) {
                Element nodeField = (Element)fieldsList.get(j);
                fields[j] = "expr".equals(nodeField.getAttributeValue("type")) ? new SemanticExprField() : new SemanticField();
                String name = nodeField.getAttributeValue("name");
                fields[j].setPhysicalName(name);
            }
            AbstractSemanticField[] currentNotFoundFields = loadEnv.addFields(entities[i], fields);
            if (currentNotFoundFields != null) {
                String table = entities[i].getPhysicalName() + ".";
                for (int j = 0; j < currentNotFoundFields.length; ++j) {
                    notFoundFileds.add(table + currentNotFoundFields[j].getPhysicalName());
                }
            }
            List relationList = nodeTable.getChildren("Relation");
            for (int j = 0; j < relationList.size(); ++j) {
                Element nodeRelation = (Element)relationList.get(j);
                String supplierId = nodeRelation.getAttributeValue("supplierId");
                SemanticRelation relation = new SemanticRelation();
                relation.setClient(entities[i]);
                relation.setSupplier((AbstractSemanticEntity)id2Obj.get(supplierId));
                List linksList = nodeRelation.getChildren("Link");
                if (linksList.size() > 0) {
                    for (int k = 0; k < linksList.size(); ++k) {
                        Element nodeLink = (Element)linksList.get(k);
                        SemanticRelation.JoinLine line = new SemanticRelation.JoinLine(nodeLink.getAttributeValue("clientField"), nodeLink.getAttributeValue("supplierField"));
                        relation.addCondition(line);
                    }
                } else {
                    String exprStr = nodeRelation.getTextTrim();
                    if (!StringUtil.isEmptyString((String)exprStr)) {
                        SemanticRelation.CustomExpr expr = new SemanticRelation.CustomExpr();
                        expr.setExpr(exprStr);
                        relation.addCondition(expr);
                    }
                }
                try {
                    loadEnv.addRelation(entities[i], relation);
                    continue;
                }
                catch (RelationsNotFoundException ex) {
                    if (relationsNotFoundEx == null) {
                        relationsNotFoundEx = new RelationsNotFoundException();
                    }
                    relationsNotFoundEx.addRelation(ex.getRelation(0));
                }
            }
        }
        if (relationsNotFoundEx != null) {
            loadEnv.destoryWhenNotFound();
            throw relationsNotFoundEx;
        }
        if (notFoundFileds.size() > 0) {
            return notFoundFileds.toArray(new String[0]);
        }
        return null;
    }

    public static interface ILoadEnv {
        public InfoWrapper[] loadEntities(String var1, String[] var2) throws SemanticUsedException, EntitiesNotFoundException;

        public AbstractSemanticEntity addEntity(InfoWrapper var1, Rectangle var2) throws SemanticUsedException;

        public AbstractSemanticField[] addFields(AbstractSemanticEntity var1, AbstractSemanticField[] var2) throws SemanticUsedException;

        public void addRelation(AbstractSemanticEntity var1, SemanticRelation var2) throws SemanticUsedException, RelationsNotFoundException;

        public void destoryWhenNotFound();
    }
}

