/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.report.PersonDataSourceDefCollection;
import com.kingdee.shr.report.PersonDataSourceDefInfo;
import com.kingdee.shr.report.ReportDatasFactory;
import com.kingdee.shr.report.ShrReportException;
import com.kingdee.shr.report.app.AbstractPersonDataSourceDefControllerBean;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class PersonDataSourceDefControllerBean
extends AbstractPersonDataSourceDefControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.report.app.PersonDataSourceDefControllerBean");

    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk != null) {
            ReportDatasFactory.getLocalInstance(ctx).delete("where personalDS = '" + pk.toString() + "'");
        }
        super.delete(ctx, pk);
    }

    @Override
    protected Map _updateBatchByStructureChange(Context ctx, List changeContent) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList data = null;
        if (null != changeContent && changeContent.size() > 0) {
            data = new ArrayList();
            int total = changeContent.size();
            for (int i = 0; i < total; ++i) {
                Map changContentMap = (Map)changeContent.get(i);
                HashMap<String, Object> resultData = new HashMap<String, Object>();
                resultData.putAll(changContentMap);
                try {
                    this.updateByStructureChange(ctx, changContentMap);
                    resultData.put("success", true);
                    resultData.put("message", "");
                }
                catch (BOSException e) {
                    resultData.put("success", false);
                    resultData.put("message", e.getMessage());
                }
                catch (EASBizException e) {
                    resultData.put("success", false);
                    resultData.put("message", e.getMessage());
                }
                data.add(resultData);
            }
            result.put("success", true);
            result.put("message", "");
            result.put("data", data);
        } else {
            result.put("success", true);
            result.put("message", SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"no_data_to_update", (Context)ctx));
            result.put("data", changeContent);
        }
        return result;
    }

    private void dealUpdateByStructureChange(Context ctx, PersonDataSourceDefCollection coll, String sourceField, String targetField, String number) throws EASBizException, BOSException {
        PersonDataSourceDefCollection updateColl = new PersonDataSourceDefCollection();
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                PersonDataSourceDefInfo info = coll.get(i);
                boolean isUpdate = false;
                if (StringUtils.isEmpty((String)info.getControlConfig())) continue;
                try {
                    Document document = DocumentHelper.parseText((String)info.getControlConfig());
                    Element root = document.getRootElement();
                    String schemeNum = root.attributeValue("schemeNum");
                    if (StringUtils.isEmpty((String)schemeNum) || !number.equals(schemeNum)) {
                        continue;
                    }
                }
                catch (DocumentException e) {
                    throw new BOSException((Throwable)e);
                }
                if (!StringUtils.isEmpty((String)info.getSelector()) && info.getSelector().indexOf(sourceField) > 0) {
                    info.setSelector(info.getSelector().replaceAll(sourceField, targetField));
                    isUpdate = true;
                }
                if (!StringUtils.isEmpty((String)info.getFilter()) && info.getFilter().indexOf(sourceField) > 0) {
                    info.setFilter(info.getFilter().replaceAll(sourceField, targetField));
                    isUpdate = true;
                }
                if (!StringUtils.isEmpty((String)info.getParamMapping()) && info.getParamMapping().indexOf(sourceField) > 0) {
                    info.setParamMapping(info.getParamMapping().replaceAll(sourceField, targetField));
                    isUpdate = true;
                }
                if (!StringUtils.isEmpty((String)info.getParam()) && info.getParam().indexOf(sourceField) > 0) {
                    info.setParam(info.getParam().replaceAll(sourceField, targetField));
                    isUpdate = true;
                }
                if (!isUpdate) continue;
                updateColl.add(info);
            }
            if (null != updateColl && updateColl.size() > 0) {
                this._updateBatchData(ctx, (IObjectCollection)updateColl);
            }
        }
    }

    @Override
    protected void _updateByStructureChange(Context ctx, Map changeContent) throws BOSException, EASBizException {
        if (null == changeContent || changeContent.size() <= 0) {
            throw new ShrReportException(ShrReportException.UPDATE_INFO_NOT_EMPTY);
        }
        String number = (String)changeContent.get("number");
        String sourceField = (String)changeContent.get("sourceField");
        String targetField = (String)changeContent.get("targetField");
        StringBuffer errorMessage = new StringBuffer();
        if (StringUtils.isEmpty((String)number)) {
            errorMessage.append(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"structure_code_not_null", (Context)ctx, (Object[])new Object[]{"number"}));
        }
        if (StringUtils.isEmpty((String)sourceField)) {
            errorMessage.append(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"old_field_no_null", (Context)ctx, (Object[])new Object[]{"sourceField"}));
        }
        if (StringUtils.isEmpty((String)targetField)) {
            errorMessage.append(SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"target_field_no_null", (Context)ctx, (Object[])new Object[]{"targetField"}));
        }
        if (!StringUtils.isEmpty((String)errorMessage.toString())) {
            throw new ShrReportException(ShrReportException.CUSTOM_EXCEPTION, new Object[]{errorMessage.toString()});
        }
        PersonDataSourceDefCollection coll = this.getPersonDataSourceDefCollection(ctx);
        this.dealUpdateByStructureChange(ctx, coll, sourceField, targetField, number);
    }
}

