/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.attachment.AttachmentManagerFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentStorageTypeEnum;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.IAttachmentManagerFacade;
import com.kingdee.eas.base.attachment.common.AttachmentHelper;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.rpts.ctrlsqldesign.IKSQLReport;
import com.kingdee.eas.rpts.ctrlsqldesign.KSQLReportFactory;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.ParamUtil;
import com.kingdee.shr.report.IPersonDataSourceDef;
import com.kingdee.shr.report.IReportDatas;
import com.kingdee.shr.report.PersonDataSourceDefFactory;
import com.kingdee.shr.report.ReportDataSourceInstanceInfo;
import com.kingdee.shr.report.ReportDatasCollection;
import com.kingdee.shr.report.ReportDatasFactory;
import com.kingdee.shr.report.ReportDatasInfo;
import com.kingdee.shr.report.ShrReportException;
import com.kingdee.shr.report.app.AbstractReportFacadeControllerBean;
import com.kingdee.shr.report.app.DSParserFactory;
import com.kingdee.shr.report.app.DataSourceTypeEnum;
import com.kingdee.shr.report.app.IParseDS;
import com.kingdee.shr.report.app.model.DSModelInfo;
import com.kingdee.shr.report.app.model.ReportManagerInfo;
import com.kingdee.shr.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.shr.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.shr.rpts.ctrlsqldesign.industry.InnerParam;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignDataExecutor;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.shr.rpts.ctrlsqldesign.model.DateUtil;
import com.kingdee.shr.rpts.ctrlsqldesign.model.RunReportParam;
import com.kingdee.shr.rpts.snapshot.ds.model.ShrSqlModel;
import com.kingdee.util.StringUtils;
import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.util.ZipSecureFile;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ReportFacadeControllerBean
extends AbstractReportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.report.app.ReportFacadeControllerBean");

    @Override
    protected ReportManagerInfo _viewReport(Context ctx, String reportDefID, String dispatcherID, String reportInstanceID, Map reportParam) throws BOSException, EASBizException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"_viewReport begin");
        }
        ReportDatasCollection coll = this.getReportDatas(ctx, reportDefID);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"_viewReport getReportDatas success");
        }
        ReportManagerInfo rmInfo = new ReportManagerInfo();
        rmInfo.setReportDefID(reportDefID);
        rmInfo.setDispactherID(dispatcherID);
        if (reportParam == null) {
            reportParam = new HashMap();
        }
        InnerParam.putServerDefalutListParamsMap(ctx, reportParam);
        ReportDataSourceInstanceInfo info = new ReportDataSourceInstanceInfo();
        rmInfo.addDS(info);
        String templateId = null;
        String path = null;
        String tempPath = null;
        String outputType = null;
        if (reportParam.get("outputType") != null) {
            outputType = reportParam.get("outputType").toString();
            reportParam.remove("outputType");
        }
        if (reportParam.get("templateId") != null) {
            templateId = reportParam.get("templateId").toString();
            reportParam.remove("templateId");
        }
        if (reportParam.get("path") != null) {
            tempPath = reportParam.get("path").toString();
            reportParam.remove("path");
        }
        ArrayList params = null;
        if (reportParam.get("filterParamValue") != null) {
            params = (ArrayList)reportParam.get("filterParamValue");
            reportParam.remove("filterParamValue");
        } else {
            params = new ArrayList();
        }
        SXSSFWorkbook wb = null;
        BoAttchAssoCollection attach = null;
        if (!StringUtils.isEmpty((String)templateId)) {
            String oql = "select attachment.file,attachment.simpleName,attachment.type,attachment.name where boid = '" + templateId + "'";
            attach = BoAttchAssoFactory.getLocalInstance((Context)ctx).getBoAttchAssoCollection(oql);
        }
        String attachId = null;
        byte[] fileInfo = null;
        if (null != attach && !attach.isEmpty() && null != attach.get(0) && null != attach.get(0).getAttachment()) {
            String fileType;
            attachId = attach.get(0).getAttachment().getId().toString();
            AttachmentStorageTypeEnum type = AttachmentHelper.getStorageType((Context)ctx, (String)attachId);
            IAttachmentManagerFacade iAttachmentManagerFacade = AttachmentManagerFacadeFactory.getLocalInstance((Context)ctx);
            fileInfo = iAttachmentManagerFacade.downLoad(attachId);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"_viewReport getTemplate success");
            }
            path = (fileType = attach.get(0).getAttachment().getType()) != null && "xls".equalsIgnoreCase(fileType) ? tempPath + "/" + attach.get(0).getAttachment().getName() + ".xls" : (fileType != null && "xlsx".equalsIgnoreCase(fileType) ? tempPath + "/" + attach.get(0).getAttachment().getName() + ".xlsx" : (fileType != null && "xlsm".equalsIgnoreCase(fileType) ? tempPath + "/" + attach.get(0).getAttachment().getName() + ".xlsm" : tempPath + "/template.xlsx"));
            if (fileInfo == null || fileInfo.length <= 0) {
                throw new ShrReportException(ShrReportException.REPORT_TEMPLATE_CONTENT_IS_NULL, new Object[]{type.getAlias()});
            }
            FileOutputStream out1 = null;
            FileInputStream inputStream = null;
            try {
                out1 = new FileOutputStream(path);
                out1.write(fileInfo);
                out1.close();
                inputStream = new FileInputStream(path);
                ZipSecureFile.setMinInflateRatio((double)-1.0);
                if (fileType != null && "xls".equalsIgnoreCase(fileType)) {
                    wb = new HSSFWorkbook(new POIFSFileSystem((InputStream)new BufferedInputStream(inputStream)));
                }
                if (fileType != null && ("xlsx".equalsIgnoreCase(fileType) || "xlsm".equalsIgnoreCase(fileType))) {
                    wb = new XSSFWorkbook((InputStream)new BufferedInputStream(inputStream));
                }
                throw new ShrReportException(ShrReportException.CUSTOM_EXCEPTION, new Object[]{ResourceBase.getString((String)"com.kingdee.shr.report.app.ReportAppResource", (String)"unknownFileType", (Locale)ctx.getLocale())});
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                if (out1 != null) {
                    try {
                        out1.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        } else {
            path = tempPath + "/template.xlsx";
        }
        boolean is2003 = true;
        if (wb instanceof XSSFWorkbook) {
            is2003 = false;
            wb = new SXSSFWorkbook((XSSFWorkbook)wb, 1000);
        }
        if (wb == null) {
            wb = new SXSSFWorkbook();
            is2003 = false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"_viewReport templatetranslate success");
        }
        String sheetName = null;
        int collSize = coll.size();
        if (collSize != 0) {
            CountDownLatch latch = new CountDownLatch(collSize);
            ExecutorService exec = Executors.newFixedThreadPool(collSize);
            for (int i = 0; i < collSize; ++i) {
                sheetName = DataSourceTypeEnum.personnel.equals((Object)coll.get(i).getDsType()) ? (coll.get(i).getPersonalDS().getSheetName() != null && !"".equals(coll.get(i).getPersonalDS().getSheetName()) ? coll.get(i).getPersonalDS().getSheetName() : coll.get(i).getPersonalDS().getName()) : coll.get(i).getDataSources().getName();
                int index = wb.getSheetIndex(sheetName);
                Sheet sheet = null;
                if (index >= 0) {
                    wb.removeSheetAt(index);
                    sheet = wb.createSheet(sheetName);
                    wb.setSheetOrder(sheetName, index);
                } else {
                    sheet = wb.createSheet(sheetName);
                }
                exec.submit(new DSHandler(latch, coll.get(i), ctx, dispatcherID, reportInstanceID, reportParam, sheet, (Workbook)wb));
            }
            try {
                latch.await();
                exec.shutdown();
            }
            catch (InterruptedException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"_viewReport run success");
            }
            try {
                this.handlerFilterSheet(ctx, (Workbook)wb, params, is2003);
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"_viewReport handlerFilterSheet success");
        }
        wb.setForceFormulaRecalculation(true);
        boolean isHidden = true;
        try {
            String shrReportSheetHidden = ParamManager.getParamValue((Context)ctx, null, (String)"shr_report_sheet_hidden");
            if ("false".equals(shrReportSheetHidden)) {
                isHidden = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isHidden && !"Detail".equals(outputType)) {
            IPersonDataSourceDef iPersonDataSourceDef = PersonDataSourceDefFactory.getLocalInstance(ctx);
            IKSQLReport iKSQLReport = KSQLReportFactory.getLocalInstance((Context)ctx);
            int total = wb.getNumberOfSheets();
            for (int sheetindex = 0; sheetindex < total; ++sheetindex) {
                Sheet sheet = wb.getSheetAt(sheetindex);
                if (!iPersonDataSourceDef.exists("where sheetName='" + sheet.getSheetName() + "' or name='" + sheet.getSheetName() + "'") && !iKSQLReport.exists("where name='" + sheet.getSheetName() + "'")) continue;
                wb.setSheetHidden(sheetindex, true);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"_viewReport hidden sheet success");
        }
        FileOutputStream out1 = null;
        try {
            out1 = new FileOutputStream(path);
            if (is2003) {
                ((HSSFWorkbook)wb).write((OutputStream)out1);
            } else if (wb instanceof XSSFWorkbook) {
                ((XSSFWorkbook)wb).write((OutputStream)out1);
            } else {
                wb.write((OutputStream)out1);
            }
            out1.close();
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (out1 != null) {
                try {
                    out1.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        info.setDsName(path);
        if (attach != null && attach.size() > 0) {
            info.setDsResult(attach.get(0).getAttachment().getName());
            info.setHeader(attach.get(0).getAttachment().getType());
        } else {
            info.setDsResult("template");
            info.setHeader("xlsx");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"_viewReport end");
        }
        return rmInfo;
    }

    private void handlerFilterSheet(Context ctx, Workbook wb, List params, boolean is2003) throws BOSException, SQLException, ParseException, EASBizException {
        String facetitle = ResourceBase.getString((String)"com.kingdee.shr.report.app.ReportAppResource", (String)"filterPage", (Locale)ctx.getLocale());
        int rowCount = params.size();
        int rowNum = 0;
        IRowSet rowSet = null;
        String sql = "select * from T_SHR_StatisticalSet";
        rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap<String, Object> data = new HashMap<String, Object>();
        while (rowSet.next()) {
            if ("current".equals(rowSet.getString("FStartType"))) {
                data.put("starttype", ResourceBase.getString((String)"com.kingdee.shr.report.app.ReportAppResource", (String)"currentMonth", (Locale)ctx.getLocale()));
            } else {
                data.put("starttype", ResourceBase.getString((String)"com.kingdee.shr.report.app.ReportAppResource", (String)"lastMonth", (Locale)ctx.getLocale()));
            }
            if ("current".equals(rowSet.getString("FEndType"))) {
                data.put("endtype", ResourceBase.getString((String)"com.kingdee.shr.report.app.ReportAppResource", (String)"currentMonth", (Locale)ctx.getLocale()));
            } else if ("last".equals(rowSet.getString("FEndType"))) {
                data.put("endtype", ResourceBase.getString((String)"com.kingdee.shr.report.app.ReportAppResource", (String)"lastMonth", (Locale)ctx.getLocale()));
            } else {
                data.put("endtype", ResourceBase.getString((String)"com.kingdee.shr.report.app.ReportAppResource", (String)"nextMonth", (Locale)ctx.getLocale()));
            }
            data.put("startday", rowSet.getString("FStartDay"));
            if ("0".equals(rowSet.getString("FEndDay"))) {
                data.put("endday", ResourceBase.getString((String)"com.kingdee.shr.report.app.ReportAppResource", (String)"lastDayOfMonth", (Locale)ctx.getLocale()));
                continue;
            }
            data.put("endday", rowSet.getString("FEndDay"));
        }
        if (data.size() == 0) {
            data.put("starttype", ResourceBase.getString((String)"com.kingdee.shr.report.app.ReportAppResource", (String)"currentMonth", (Locale)ctx.getLocale()));
            data.put("startday", 1);
            data.put("endtype", ResourceBase.getString((String)"com.kingdee.shr.report.app.ReportAppResource", (String)"currentMonth", (Locale)ctx.getLocale()));
            data.put("endday", ResourceBase.getString((String)"com.kingdee.shr.report.app.ReportAppResource", (String)"lastDayOfMonth", (Locale)ctx.getLocale()));
        }
        DesignParameter hrOrgParameter = null;
        if (is2003) {
            int index = wb.getSheetIndex(facetitle);
            Sheet sheet = null;
            if (index >= 0) {
                wb.removeSheetAt(index);
                sheet = wb.createSheet(facetitle);
                wb.setSheetOrder(facetitle, index);
            } else {
                sheet = wb.createSheet(facetitle);
            }
            for (int i = 0; i < rowCount; ++i) {
                DesignParameter parameter = (DesignParameter)((Object)params.get(i));
                if ("hrOrg".equals(parameter.getName())) {
                    hrOrgParameter = parameter;
                    continue;
                }
                if ("@customHrOrg".replace("@", "").equals(parameter.getName()) || "@customAdminOrg".replace("@", "").equals(parameter.getName()) || "@customAdminOrgRange".replace("@", "").equals(parameter.getName()) || "@customHrOrg".equals(parameter.getName()) || "@customAdminOrg".equals(parameter.getName()) || "@customAdminOrgRange".equals(parameter.getName()) || parameter.getInputState() == null || parameter.getInputState().intValue() != 0) continue;
                this.fillParameterSheetRow(ctx, rowNum, sheet, parameter);
                ++rowNum;
            }
            if (null != hrOrgParameter) {
                this.fillParameterSheetRow(ctx, rowNum, sheet, hrOrgParameter);
            }
            if (sheet.getRow(0) != null) {
                sheet.getRow(0).createCell(4).setCellValue(data.get("starttype").toString());
                sheet.getRow(0).createCell(5).setCellValue(data.get("startday").toString());
                sheet.getRow(0).createCell(6).setCellValue(data.get("endtype").toString());
                sheet.getRow(0).createCell(7).setCellValue(data.get("endday").toString());
            }
        } else {
            int index = wb.getSheetIndex(facetitle);
            Sheet sheet = null;
            if (index >= 0) {
                wb.removeSheetAt(index);
                sheet = wb.createSheet(facetitle);
                wb.setSheetOrder(facetitle, index);
            } else {
                sheet = wb.createSheet(facetitle);
            }
            for (int i = 0; i < rowCount; ++i) {
                DesignParameter parameter = (DesignParameter)((Object)params.get(i));
                if ("hrOrg".equals(parameter.getName())) {
                    hrOrgParameter = parameter;
                    continue;
                }
                if ("@customHrOrg".replace("@", "").equals(parameter.getName()) || "@customAdminOrg".replace("@", "").equals(parameter.getName()) || "@customAdminOrgRange".replace("@", "").equals(parameter.getName()) || "@customHrOrg".equals(parameter.getName()) || "@customAdminOrg".equals(parameter.getName()) || "@customAdminOrgRange".equals(parameter.getName()) || parameter.getInputState() == null || parameter.getInputState().intValue() != 0) continue;
                this.fillParameterSheetRow(ctx, rowNum, sheet, parameter);
                ++rowNum;
            }
            if (null != hrOrgParameter) {
                this.fillParameterSheetRow(ctx, rowNum, sheet, hrOrgParameter);
            }
            if (sheet.getRow(0) != null) {
                sheet.getRow(0).createCell(4).setCellValue(data.get("starttype").toString());
                sheet.getRow(0).createCell(5).setCellValue(data.get("startday").toString());
                sheet.getRow(0).createCell(6).setCellValue(data.get("endtype").toString());
                sheet.getRow(0).createCell(7).setCellValue(data.get("endday").toString());
            }
        }
    }

    private void fillParameterSheetRow(Context ctx, int rowNum, Sheet sheet, DesignParameter parameter) throws BOSException, EASBizException, ParseException {
        Row row = sheet.createRow(rowNum);
        Cell cell = row.createCell(0);
        cell.setCellValue("" + parameter.getProperties().get("alias"));
        cell = row.createCell(1);
        if (parameter.getInputType().intValue() == 4 || parameter.getInputType().intValue() == 1) {
            if (!StringUtils.isEmpty((String)parameter.getCurentValue()) && "adminOrg".equals(parameter.getName())) {
                cell.setCellValue(AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(" where longNumber = '" + parameter.getCurentValue() + "'").get(0).getDisplayName());
            } else if (!StringUtils.isEmpty((String)parameter.getCurentValue()) && "hrOrg".equals(parameter.getName())) {
                cell.setCellValue(HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(parameter.getCurentValue())).getDisplayName());
            } else if (!StringUtils.isEmpty((String)parameter.getCurentValueAlias())) {
                cell.setCellValue("" + parameter.getCurentValueAlias());
            } else {
                cell.setCellValue("" + parameter.getCurentValue());
            }
        } else if (parameter.getInputType().intValue() == 2) {
            if (!StringUtils.isEmpty((String)parameter.getCurentValue())) {
                Date date = DateUtil.parseDate(parameter.getCurentValue());
                cell.setCellValue(DateUtil.format(date, "yyyy-MM-dd"));
            }
        } else {
            cell.setCellValue("" + parameter.getCurentValue() == null ? "" : parameter.getCurentValue());
        }
    }

    private ReportDatasCollection getReportDatas(Context ctx, String reportDefID) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("reportDef.id", (Object)reportDefID));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("dataSources.*"));
        sic.add(new SelectorItemInfo("dsType"));
        sic.add(new SelectorItemInfo("param"));
        sic.add(new SelectorItemInfo("personalDS.*"));
        sic.add(new SelectorItemInfo("param"));
        viewInfo.setSelector(sic);
        IReportDatas iReportDatas = ReportDatasFactory.getLocalInstance(ctx);
        ReportDatasCollection datas = iReportDatas.getReportDatasCollection(viewInfo);
        IKSQLReport iKSQLReport = KSQLReportFactory.getLocalInstance((Context)ctx);
        int total = datas.size();
        for (int index = 0; index < total; ++index) {
            ReportDatasInfo info = datas.get(index);
            if (info.getDsType() != DataSourceTypeEnum.getEnum(0)) continue;
            String ksqlid = info.getDataSources().getId().toString();
            if (iKSQLReport.exists("where id='" + ksqlid + "'")) continue;
            datas.remove(info);
            --index;
            iReportDatas.delete("where id='" + info.getId().toString() + "'");
        }
        return datas;
    }

    @Override
    protected List _getReportParam(Context ctx, String reportDefID) throws BOSException, EASBizException {
        ReportDatasCollection coll = this.getReportDatas(ctx, reportDefID);
        ArrayList allUnionParam = new ArrayList();
        for (int i = 0; i < coll.size(); ++i) {
            IParseDS rs1ds = DSParserFactory.getParser(coll.get(i));
            DSModelInfo modelInfo = rs1ds.prepareModel(ctx, coll.get(i));
            CtrlDesignQueryModel model = modelInfo.getModel();
            RunReportParam.unionKsqlParam(ctx, allUnionParam, model);
        }
        return allUnionParam;
    }

    @Override
    protected Map _getDSData(Context ctx, CtrlDesignQueryModel model, Map mapDesignParam, Map logMap, int start, int rows, boolean isRun, Window parent) throws BOSException, EASBizException {
        String sql;
        Object mapResult = null;
        HashMap result = new HashMap();
        boolean isMultTime = false;
        IRowSet rowSet = null;
        IRowSet irs = null;
        InnerParam.putServerDefalutListParamsMap(ctx, mapDesignParam);
        ReportDatasInfo report = new ReportDatasInfo();
        report.setDsType(DataSourceTypeEnum.personnel);
        IParseDS parseDS = DSParserFactory.getParser(report);
        if (model instanceof ShrSqlModel && !((CtrlDesignKsqlQuery)model.getQuery()).isRegular()) {
            sql = ShrSqlModel.makeShrSql(ctx, (ShrSqlModel)model);
            model.getQuery().setContent(sql);
        }
        if (model instanceof ShrSqlModel && "001".equals(((ShrSqlModel)model).getScheme())) {
            isMultTime = true;
        }
        try {
            if (isMultTime) {
                Object otherParam = model.getCommonQuery().getProperties().get("otherParam");
                if (otherParam != null && !"".equals(otherParam)) {
                    HashMap param = JSONUtils.convertJsonToObject((Context)ctx, (String)otherParam.toString());
                    if (mapDesignParam.get("startDate") != null) {
                        param.put("startDate", ((DesignParameter)((Object)mapDesignParam.get("startDate"))).getCurentValue());
                    }
                    if (mapDesignParam.get("endDate") != null) {
                        param.put("endDate", ((DesignParameter)((Object)mapDesignParam.get("endDate"))).getCurentValue());
                    }
                    ArrayList dates = this.getDimensionDates(ctx, JSONUtils.convertObjectToJson((Context)ctx, (Object)param));
                    HashMap tempValue = new HashMap();
                    String curBaseDate = "";
                    if (mapDesignParam.get("baseDate") != null) {
                        curBaseDate = ((DesignParameter)((Object)mapDesignParam.get("baseDate"))).getCurentValue();
                    }
                    for (int i = 0; i < dates.size(); ++i) {
                        for (Map.Entry entry : mapDesignParam.entrySet()) {
                            if (!"baseDate".equals(entry.getKey())) continue;
                            ((DesignParameter)((Object)entry.getValue())).setCurentValue(DateUtil.format((Date)dates.get(i), "yyyy-MM-dd"));
                            break;
                        }
                        try {
                            String sql2 = CtrlDesignDataExecutor.buildModelSQL(ctx, model, mapDesignParam, logMap, start, rows, isRun, parent);
                            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql2);
                            parseDS.changeRSData(ctx, tempValue, model, rowSet);
                            if (result.get("columns") == null) {
                                result.put("columns", tempValue.get("columns"));
                            }
                            if (result.get("data") == null) {
                                result.put("data", tempValue.get("data"));
                                continue;
                            }
                            ((ArrayList)result.get("data")).addAll((ArrayList)tempValue.get("data"));
                            continue;
                        }
                        catch (CtrlReportException e1) {
                            throw new BOSException((Throwable)e1);
                        }
                    }
                    if (mapDesignParam.get("baseDate") != null) {
                        ((DesignParameter)((Object)mapDesignParam.get("baseDate"))).setCurentValue(curBaseDate);
                    }
                    return result;
                }
                boolean isEnableEncrypt = ParamUtil.IsEnableEncrypt((Context)ctx);
                String sql3 = CtrlDesignDataExecutor.buildModelSQL(ctx, model, mapDesignParam, logMap, start, rows, isRun, parent);
                if (isEnableEncrypt && sql3.toUpperCase().startsWith(" SELECT TOP") && sql3.contains("\"")) {
                    int indexOf = sql3.indexOf("\"");
                    int infexofFrom = sql3.toUpperCase().indexOf("FROM");
                    String sql0 = sql3.substring(0, indexOf);
                    String sql1 = sql3.substring(infexofFrom);
                    sql3 = sql0 + " * " + sql1;
                }
                irs = DbUtil.executeQuery((Context)ctx, (String)sql3);
            } else {
                sql = CtrlDesignDataExecutor.buildModelSQL(ctx, model, mapDesignParam, logMap, start, rows, isRun, parent);
                irs = DbUtil.executeQuery((Context)ctx, (String)sql);
            }
        }
        catch (CtrlReportException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        parseDS.changeRSData(ctx, result, model, irs);
        return result;
    }

    private ArrayList getDimensionDates(Context ctx, String params) throws BOSException {
        ArrayList<Date> dates;
        block15: {
            dates = new ArrayList<Date>();
            try {
                HashMap param = JSONUtils.convertJsonToObject((Context)ctx, (String)params);
                String start = param.get("startDate").toString();
                String end = param.get("endDate").toString();
                Date startDate = DateUtil.parseDate(start);
                Date endDate = DateUtil.parseDate(end);
                String dimension = (String)param.get("dimension");
                String includetype = (String)param.get("includetype");
                if (!"month".equals(dimension)) break block15;
                IRowSet rowSet = null;
                String sql = "select * from T_SHR_StatisticalSet";
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
                String starttype = "current";
                int startday = 1;
                try {
                    while (rowSet.next()) {
                        starttype = rowSet.getString("FStartType");
                        startday = rowSet.getInt("FStartDay");
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                Date monthDay = DateUtil.parseDate(DateUtil.getYear(startDate) + "-" + DateUtil.getMonth(startDate) + "-" + startday);
                if ("last".equals(starttype)) {
                    monthDay = DateUtil.addMonth(monthDay, -1);
                }
                if ("end".equals(includetype)) {
                    monthDay = DateUtil.addMonth(monthDay, 1);
                    dates.add(DateUtil.addDay(monthDay, -1));
                    int monthCount = DateUtil.getMonth(endDate) - DateUtil.getMonth(startDate) + 1;
                    for (int i = 0; i < monthCount; ++i) {
                        monthDay = DateUtil.addMonth(monthDay, 1);
                        dates.add(DateUtil.addDay(monthDay, -1));
                    }
                } else if ("startend".equals(includetype)) {
                    int i;
                    Date tempDate = (Date)monthDay.clone();
                    dates.add(monthDay);
                    int monthCount = DateUtil.getMonth(endDate) - DateUtil.getMonth(startDate) + 1;
                    for (i = 0; i < monthCount; ++i) {
                        monthDay = DateUtil.addMonth(monthDay, 1);
                        dates.add(monthDay);
                    }
                    tempDate = DateUtil.addMonth(tempDate, 1);
                    dates.add(DateUtil.addDay(tempDate, -1));
                    monthCount = DateUtil.getMonth(endDate) - DateUtil.getMonth(startDate) + 1;
                    for (i = 0; i < monthCount; ++i) {
                        tempDate = DateUtil.addMonth(tempDate, 1);
                        dates.add(DateUtil.addDay(tempDate, -1));
                    }
                } else {
                    dates.add(monthDay);
                    int monthCount = DateUtil.getMonth(endDate) - DateUtil.getMonth(startDate) + 1;
                    for (int i = 0; i < monthCount; ++i) {
                        monthDay = DateUtil.addMonth(monthDay, 1);
                        dates.add(monthDay);
                    }
                }
            }
            catch (ParseException e) {
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return dates;
    }

    class DSHandler
    implements Callable<String> {
        private CountDownLatch latch;
        private ReportDatasInfo report;
        private Context ctx;
        private String dispatcherID;
        private String reportInstanceID;
        private Map reportParam;
        private Sheet sheet;
        private Workbook wb;

        public DSHandler(CountDownLatch latch, ReportDatasInfo report, Context ctx, String dispatcherID, String reportInstanceID, Map reportParam, Sheet sheet, Workbook wb) {
            this.latch = latch;
            this.report = report;
            this.ctx = ctx;
            this.dispatcherID = dispatcherID;
            this.reportInstanceID = reportInstanceID;
            this.reportParam = reportParam;
            this.sheet = sheet;
            this.wb = wb;
        }

        @Override
        public String call() throws BOSException, EASBizException {
            try {
                IParseDS rs1ds = DSParserFactory.getParser(this.report);
                this.report.put("sheet", this.sheet);
                this.report.put("wb", this.wb);
                rs1ds.parseDS(this.ctx, this.dispatcherID, this.report, this.reportInstanceID, this.reportParam);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("reportName =" + this.report.getReportDef().getName() + ",sheetName=" + this.sheet.getSheetName() + ",IParseDS=" + rs1ds.getClass().getName()));
                }
            }
            catch (Exception e) {
                logger.error((Object)("reportName =" + this.report.getReportDef().getName() + ",sheetName=" + this.sheet.getSheetName() + e.getMessage()), (Throwable)e);
                if (e instanceof EASBizException) {
                    throw (EASBizException)((Object)e);
                }
                throw new BOSException((Throwable)e);
            }
            finally {
                this.latch.countDown();
            }
            return null;
        }
    }
}

