/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.rpts.ctrlsqldesign.model;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.data.engine.NotFoundVarException;
import com.kingdee.bos.ctrl.data.invoke.IEnvProvider;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.shr.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.shr.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.shr.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.shr.rpts.ctrlsqldesign.model.SqlWhereParser;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BindParam {
    public static final Logger log = LogUtil.getPackageLogger(BindParam.class);
    private static final String PATTERN_PARAM_STR = "@[a-z|A-Z|_][\\w|_]*.[a-z|A-Z|_][\\w|_]*";
    private static final String PATTERN_ENV_STR = "@@[a-z|A-Z|_][\\w|_]*.[a-z|A-Z|_][\\w|_]*";
    public static final Pattern PARAM = Pattern.compile("@[a-z|A-Z|_][\\w|_]*.[a-z|A-Z|_][\\w|_]*", 32);
    public static final Pattern ENV = Pattern.compile("@@[a-z|A-Z|_][\\w|_]*.[a-z|A-Z|_][\\w|_]*", 32);
    private static final String PATTERN_SIMPLE_PARAM_STR = "@\\w+";
    private static final String PATTERN_SIMPLE_ENV_STR = "@@\\w+";
    public static final Pattern SIMPLE_PARAM = Pattern.compile("@\\w+", 32);
    public static final Pattern SIMPLE_ENV = Pattern.compile("@@\\w+", 32);

    public static final String replaceVariants(String expr, Map params, boolean simpleStyle) throws NotFoundVarException {
        return BindParam.replaceVariants(expr, params, null, simpleStyle, true);
    }

    public static final String replaceVariants(String expr, Map params, IEnvProvider envProvider, boolean simpleStyle, boolean param) throws NotFoundVarException {
        Matcher mch = null;
        mch = simpleStyle ? SIMPLE_PARAM.matcher(expr) : PARAM.matcher(expr);
        StringBuffer sb1 = new StringBuffer();
        int j = 0;
        while (mch.find()) {
            int i = mch.start();
            sb1.append(expr.substring(j, i));
            j = mch.end();
            String token = expr.substring(i, j);
            int index = token.lastIndexOf(64);
            String realName = token.substring(index + 1);
            String solveResult = BindParam.getVar(params, envProvider, realName, param);
            if (solveResult == null) {
                throw new NotFoundVarException(realName, param);
            }
            sb1.append(solveResult);
        }
        sb1.append(expr.substring(j));
        return sb1.toString();
    }

    public static final String replaceVariantEXKSQL(String expr, Map params, boolean simpleStyle) throws NotFoundVarException {
        Matcher mch = null;
        mch = simpleStyle ? SIMPLE_PARAM.matcher(expr) : PARAM.matcher(expr);
        StringBuffer sb1 = new StringBuffer();
        int j = 0;
        while (mch.find()) {
            int i = mch.start();
            sb1.append(expr.substring(j, i));
            j = mch.end();
            String token = expr.substring(i, j);
            int index = token.lastIndexOf(64);
            String realName = token.substring(index + 1);
            String solveResult = BindParam.getVar(params, null, realName, true);
            solveResult = CtrlReportUtil.getObjectString(solveResult);
            if (solveResult.equals("")) {
                throw new NotFoundVarException(realName, true);
            }
            sb1.append(solveResult);
        }
        sb1.append(expr.substring(j));
        return sb1.toString();
    }

    public static final String replaceVariantDialect(String sql, Map mapDesignParam, int DBType, Map warnMap) throws CtrlReportException {
        StringBuffer logParamSystem = new StringBuffer();
        StringBuffer logParamCustom = new StringBuffer();
        Iterator it = mapDesignParam.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(name));
            if (name.startsWith("ExtRpt")) {
                logParamSystem.append(EASResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"builtin_param") + ":").append(p.getName()).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
                continue;
            }
            logParamCustom.append(EASResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"custommade_param") + ":").append(p.getName()).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
        }
        StringBuffer logParam = new StringBuffer();
        logParam.append("\r\n").append(logParamCustom).append(logParamSystem);
        if (log.isDebugEnabled()) {
            log.debug((Object)("source:" + sql));
            String paramLog = logParam.toString();
            log.debug((Object)paramLog);
        }
        MiscUtil.log((int)4, (String)logParam.toString());
        try {
            sql = SqlWhereParser.parseDialectDateTime(sql, mapDesignParam, 0, DBType);
            while (sql.indexOf("@") != -1) {
                sql = SqlWhereParser.parseDialect(sql, mapDesignParam, warnMap);
            }
            sql = CtrlReportUtil.exartToArt(sql);
            log.debug((Object)("sql:" + sql));
            return sql;
        }
        catch (CtrlReportException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw CtrlReportException.makeException(EASResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"parse_dialect_sql_error"), e);
        }
    }

    public static final String replaceVariants2(String expr, Map params, boolean simpleStyle) {
        return BindParam.replaceVariants2(expr, params, null, simpleStyle, true);
    }

    public static final String replaceVariants2(String expr, Map params, IEnvProvider envProvider, boolean simpleStyle, boolean param) {
        Matcher mch = null;
        mch = simpleStyle ? SIMPLE_PARAM.matcher(expr) : PARAM.matcher(expr);
        StringBuffer sb1 = new StringBuffer();
        int j = 0;
        while (mch.find()) {
            int i = mch.start();
            sb1.append(expr.substring(j, i));
            j = mch.end();
            String token = expr.substring(i, j);
            int index = token.lastIndexOf(64);
            String realName = token.substring(index + 1);
            String solveResult = BindParam.getVar(params, envProvider, realName, param);
            if (solveResult == null) {
                solveResult = "";
            }
            sb1.append(solveResult);
        }
        sb1.append(expr.substring(j));
        return sb1.toString();
    }

    private static final String getVar(Map params, IEnvProvider envProvider, String name, boolean param) {
        Object objVal = null;
        if (param) {
            if (params == null) {
                return null;
            }
            objVal = params.get(name);
        } else {
            if (envProvider == null) {
                return null;
            }
            objVal = envProvider.get(name);
        }
        return objVal == null ? null : objVal.toString();
    }
}

