/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.rpts.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.code.AInputStream;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StreamUtil;
import com.kingdee.bos.ctrl.common.util.xml.XmlUtil;
import com.kingdee.eas.rpts.ctrlreport.bo.KSQLReportBO;
import com.kingdee.eas.rpts.ctrlsqldesign.KSQLReportInfo;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignQueryModel;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class CtrlDesignInputStream
extends AInputStream {
    private static Logger log = LogUtil.getPackageLogger(CtrlDesignInputStream.class);
    private String fid;
    private String systemid;
    private String dbsourcename;
    private String orgid;
    private Context ctx;
    private boolean isFound = true;
    KSQLReportInfo info;
    byte[] dataModel;

    public CtrlDesignInputStream(String fid) {
        this.fid = fid;
        try {
            this.reset();
        }
        catch (IOException e) {
            this.isFound = false;
            log.error((Object)e);
            StreamUtil.closeStream((InputStream)((Object)this));
        }
    }

    public CtrlDesignInputStream(Context ctx, String systemid, String dbsourcename, String orgid, String fid) {
        this.ctx = ctx;
        this.systemid = systemid;
        this.dbsourcename = dbsourcename;
        this.orgid = orgid;
        this.fid = fid;
        try {
            this.reset();
        }
        catch (IOException e) {
            this.isFound = false;
            log.error((Object)e);
            StreamUtil.closeStream((InputStream)((Object)this));
        }
    }

    public CtrlDesignInputStream(Context ctx, byte[] data) {
        this.ctx = ctx;
        this.dataModel = data;
        try {
            this.reset();
        }
        catch (IOException e) {
            this.isFound = false;
            log.error((Object)e);
            StreamUtil.closeStream((InputStream)((Object)this));
        }
    }

    public void reset() throws IOException {
        byte[] data = null;
        if (null != this.dataModel) {
            data = this.dataModel;
        } else {
            try {
                this.info = null == this.systemid || this.systemid.equals("") ? KSQLReportBO.getKSQLReportInfo((Context)this.ctx, (String)this.fid, (String)this.orgid) : KSQLReportBO.getKSQLReportInfo((Context)this.ctx, (String)this.systemid, (String)this.dbsourcename, (String)this.orgid, (String)this.fid);
                if (this.info == null) {
                    this.isFound = false;
                    return;
                }
                data = this.info.getContent();
            }
            catch (BOSException e) {
                this.isFound = false;
                log.error((Object)e);
            }
        }
        this.setProvider(new ByteArrayInputStream(data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInputObject(CtrlDesignQueryModel model) {
        Element xml = null;
        try {
            xml = XmlUtil.loadXmlStream((InputStream)((Object)this));
        }
        catch (Exception exception) {
        }
        finally {
            StreamUtil.closeStream((InputStream)((Object)this));
        }
        CtrlDesignUtil.toObject(model, xml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getXmlString() {
        Element xml = null;
        try {
            String xmlstr;
            xml = XmlUtil.loadXmlStream((InputStream)((Object)this));
            XMLOutputter outter = new XMLOutputter();
            Format format = Format.getCompactFormat();
            format.setEncoding("utf-8");
            format.setIndent("\t");
            format.setLineSeparator("\n");
            outter.setFormat(format);
            String string = xmlstr = outter.outputString(xml);
            return string;
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
        finally {
            StreamUtil.closeStream((InputStream)((Object)this));
        }
        return null;
    }

    public boolean isFound() {
        return this.isFound;
    }

    public void setOrgid(String orgid) {
        this.orgid = orgid;
    }
}

