/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.rpts.ctrlsqldesign.model;

import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.ext.util.MiscUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.dom.SqlJoinedTableSource;
import com.kingdee.bos.sql.dom.SqlOrderByItem;
import com.kingdee.bos.sql.dom.SqlSelect;
import com.kingdee.bos.sql.dom.SqlSelectBase;
import com.kingdee.bos.sql.dom.SqlSelectItem;
import com.kingdee.bos.sql.dom.SqlSubQueryTableSource;
import com.kingdee.bos.sql.dom.SqlTableSourceBase;
import com.kingdee.bos.sql.dom.SqlUnionSelect;
import com.kingdee.bos.sql.dom.expr.QueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlBinaryOpExpr;
import com.kingdee.bos.sql.dom.expr.SqlCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlDateTimeExpr;
import com.kingdee.bos.sql.dom.expr.SqlDoubleExpr;
import com.kingdee.bos.sql.dom.expr.SqlExistsExpr;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.sql.dom.expr.SqlIdentifierExpr;
import com.kingdee.bos.sql.dom.expr.SqlInListExpr;
import com.kingdee.bos.sql.dom.expr.SqlInSubQueryExpr;
import com.kingdee.bos.sql.dom.expr.SqlIntExpr;
import com.kingdee.bos.sql.dom.expr.SqlLongExpr;
import com.kingdee.bos.sql.dom.expr.SqlNCharExpr;
import com.kingdee.bos.sql.dom.expr.SqlNotExpr;
import com.kingdee.bos.sql.dom.expr.SqlNullExpr;
import com.kingdee.bos.sql.dom.stmt.SqlSelectStmt;
import com.kingdee.bos.sql.parser.Lexer;
import com.kingdee.bos.sql.parser.SqlExprParser;
import com.kingdee.bos.sql.parser.SqlParser;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.shr.rpts.ctrlreport.model.CtrlReportUtil;
import com.kingdee.shr.rpts.ctrlreport.util.ExtStringUtil;
import com.kingdee.shr.rpts.ctrlreport.util.MessageUtil;
import com.kingdee.shr.rpts.ctrlsqldesign.data.DesignParameter;
import com.kingdee.shr.rpts.ctrlsqldesign.exception.CtrlReportException;
import com.kingdee.shr.rpts.ctrlsqldesign.model.BindParam;
import com.kingdee.shr.rpts.ctrlsqldesign.model.SqlWhereParser;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;

public class CtrlDesignKsqlSolver {
    public static final Logger log = LogUtil.getPackageLogger(CtrlDesignKsqlSolver.class);
    Map params = new HashMap();
    private Map dateTypeMap;
    private boolean simpleVarStyle;
    private Map mapDesignParam = new HashMap();

    public CtrlDesignKsqlSolver(Map mapDesignParam, Map dateTypeMap, boolean simpleVarStyle) {
        this.dateTypeMap = dateTypeMap;
        this.simpleVarStyle = simpleVarStyle;
        this.mapDesignParam = mapDesignParam;
        StringBuffer logParamSystem = new StringBuffer();
        StringBuffer logParamCustom = new StringBuffer();
        Iterator it = mapDesignParam.keySet().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            DesignParameter p = (DesignParameter)((Object)mapDesignParam.get(name));
            DesignParameter oldp = null;
            String value = null;
            String key = p.getName();
            for (int times = 0; times < 10; ++times) {
                if (null == p) continue;
                value = p.getCurentValue();
                if (!value.startsWith("@ExtRpt")) break;
                value = value.substring(1);
                oldp = p;
                p = (DesignParameter)((Object)mapDesignParam.get(value));
                p = p != null ? p : oldp;
            }
            this.params.put(key, value);
            if (name.startsWith("ExtRpt")) {
                logParamSystem.append(EASResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"builtin_param") + ":").append(p.getName()).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
                continue;
            }
            logParamCustom.append(EASResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"custommade_param") + ":").append(key).append(", value = ").append(p.getCurentValue()).append(", type = ").append(p.getDesignDataType()).append("\r\n");
        }
        StringBuffer logParam = new StringBuffer();
        logParam.append("\r\n").append(logParamCustom).append(logParamSystem);
        if (log.isDebugEnabled()) {
            String paramLog = logParam.toString();
            log.debug((Object)paramLog);
        }
        MiscUtil.log((int)4, (String)logParam.toString());
    }

    public static final SqlSelectBase makeSqlSelect(String select) throws ParserException {
        Lexer lexer = new Lexer(select);
        SqlParser parser = new SqlParser(lexer);
        Collection c = parser.parseStmtList();
        SqlSelectBase sqlSelectBase = ((SqlSelectStmt)c.iterator().next()).select;
        return sqlSelectBase;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String solve(String sql, Map mapDesignParam, Map dateTypeMap, boolean simpleVarStyle) throws Exception {
        if (StringUtil.isEmptyString((String)sql)) {
            return sql;
        }
        log.debug((Object)("source:" + sql));
        CtrlDesignKsqlSolver solver = new CtrlDesignKsqlSolver(mapDesignParam, dateTypeMap, simpleVarStyle);
        String losql = sql.trim().toLowerCase(Locale.ENGLISH);
        String result = "";
        log.debug((Object)("source:" + losql.substring(0, 6)));
        if (!losql.substring(0, 6).equalsIgnoreCase("select")) {
            if (!losql.startsWith("where") && !losql.startsWith("order by")) throw new ParserException("unsupport sql text");
            result = solver.solveEntityView(sql);
        } else {
            SqlSelectBase sb = solver.solveSelect(sql);
            result = sb.toString();
        }
        if (!log.isDebugEnabled()) return result;
        log.debug((Object)("result:" + result));
        return result;
    }

    private SqlExpr str2KsqlExpr(String exprStr) throws ParserException {
        Lexer lexer = new Lexer(exprStr);
        SqlExprParser parser = new SqlExprParser(lexer);
        SqlExpr expr = parser.expr();
        return expr;
    }

    private static void trimSqlIdentifierExpr(SqlIdentifierExpr expr) {
        String exprString = expr.value;
        if (exprString.charAt(0) == '\"') {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < exprString.length(); ++i) {
                if (exprString.charAt(i) == '\"') continue;
                sb.append(exprString.charAt(i));
            }
            expr.value = sb.toString();
        }
    }

    public static void covertSqlExpr_forEntityView(SqlExpr expr) {
        if (expr instanceof SqlIdentifierExpr) {
            CtrlDesignKsqlSolver.trimSqlIdentifierExpr((SqlIdentifierExpr)expr);
            return;
        }
        Stack<Object> stack = new Stack<Object>();
        stack.push(expr);
        while (!stack.isEmpty()) {
            SqlExpr subExpr = (SqlExpr)stack.pop();
            Field[] fields = subExpr.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                try {
                    Field field = subExpr.getClass().getDeclaredField(fields[i].getName());
                    Object obj = field.get(subExpr);
                    if (obj == null || !SqlExpr.class.isAssignableFrom(obj.getClass())) continue;
                    if (obj instanceof SqlIdentifierExpr) {
                        CtrlDesignKsqlSolver.trimSqlIdentifierExpr((SqlIdentifierExpr)obj);
                        continue;
                    }
                    if (obj instanceof SqlLongExpr || obj instanceof SqlIntExpr || obj instanceof SqlDoubleExpr || obj instanceof SqlDateTimeExpr || obj instanceof SqlNCharExpr || obj instanceof SqlCharExpr || obj instanceof SqlNullExpr) continue;
                    stack.push(obj);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private String orderBys2Str_forEntityView(List orderBys) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < orderBys.size(); ++i) {
            SqlOrderByItem item = (SqlOrderByItem)orderBys.get(i);
            CtrlDesignKsqlSolver.covertSqlExpr_forEntityView(item.expr);
            sb.append(item.expr.toString()).append(" ").append(item.mode == 0 ? "ASC" : "DESC");
            if (i == orderBys.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private SqlExpr solvePureSqlExpr(SqlExpr expr) throws CtrlReportException {
        try {
            String newWhere;
            if (expr == null) {
                return expr;
            }
            String exprStr = expr.toString();
            String exprStrTemp = exprStr.toUpperCase();
            for (String key : this.dateTypeMap.keySet()) {
                String value = CtrlReportUtil.getObjectString(this.dateTypeMap.get(key));
                exprStr = ExtStringUtil.replace(exprStr, value, "@" + key, false, false);
            }
            String replaceExpr = exprStr;
            boolean isFind = false;
            if (exprStr.indexOf("@") != -1) {
                isFind = true;
            }
            int inFlag = -1;
            String field = null;
            String operatorString = null;
            String paramString = null;
            boolean isDate = false;
            boolean isTime = false;
            if (exprStrTemp.indexOf("{TS") != -1 || exprStrTemp.indexOf("{D") != -1 || exprStrTemp.indexOf("{T") != -1) {
                isDate = true;
                if (exprStrTemp.indexOf("{T") != -1) {
                    isTime = true;
                }
            }
            if (isFind || isDate) {
                SqlInListExpr binOp;
                if (expr instanceof SqlInListExpr) {
                    binOp = (SqlInListExpr)expr;
                    field = binOp.expr.toString();
                    operatorString = binOp.getExprWord();
                    paramString = ((SqlExpr)binOp.targetList.get(0)).toString();
                    inFlag = 1;
                } else if (expr instanceof SqlBinaryOpExpr) {
                    binOp = (SqlBinaryOpExpr)expr;
                    int operator = binOp.operator;
                    operatorString = SqlWhereParser.getOperator(operator);
                    field = binOp.left.toString();
                    paramString = binOp.right.toString();
                    inFlag = 0;
                }
            }
            if (isDate && null != paramString) {
                if (inFlag == 0) {
                    if (paramString.startsWith("{TS") || paramString.startsWith("{D") || paramString.startsWith("{T")) {
                        if (isFind) {
                            return this.replaceParam(expr, exprStr, replaceExpr, isTime);
                        }
                        newWhere = SqlWhereParser.parseKSQLDateTime(field, operatorString, paramString);
                        if (null != newWhere) {
                            replaceExpr = newWhere;
                        }
                    }
                } else if (inFlag == 1) {
                    if (paramString.startsWith("{TS") || paramString.startsWith("{D") || paramString.startsWith("{T")) {
                        throw new CtrlReportException(MessageUtil.getMsgInfo("label285"));
                    }
                } else {
                    throw new CtrlReportException(MessageUtil.getMsgInfo("label288"));
                }
            }
            if (isFind) {
                for (String key : this.dateTypeMap.keySet()) {
                    String value = CtrlReportUtil.getObjectString(this.dateTypeMap.get(key));
                    paramString = ExtStringUtil.replace(paramString, value, "@" + key, false, false);
                }
                newWhere = SqlWhereParser.parseKSQLList(exprStr, field, operatorString, paramString, this.mapDesignParam, this.params);
                if (null != newWhere) {
                    replaceExpr = newWhere;
                }
            }
            return this.replaceParam(expr, exprStr, replaceExpr, isTime);
        }
        catch (Exception e) {
            log.error((Object)"check solvePureSqlExpr error", (Throwable)e);
            throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label250"), e);
        }
    }

    private SqlExpr replaceParam(SqlExpr expr, String oriExprStr, String replaceExpr, boolean isTime) {
        try {
            String newExprStr = BindParam.replaceVariantEXKSQL(replaceExpr, this.params, this.simpleVarStyle);
            if (StringUtil.equals((String)newExprStr, (String)oriExprStr)) {
                return expr;
            }
            return this.str2KsqlExpr(newExprStr);
        }
        catch (Exception e) {
            log.info((Object)e);
            return UnkownBoolValueSqlExpr.instance;
        }
    }

    private SqlExpr solveWhere(SqlExpr expr) throws ParserException, CtrlReportException {
        if (expr instanceof SqlBinaryOpExpr) {
            SqlBinaryOpExpr binOp = (SqlBinaryOpExpr)expr;
            if (binOp.operator == 7 || binOp.operator == 8) {
                binOp.left = this.solveWhere(binOp.left);
                binOp.right = this.solveWhere(binOp.right);
                if (binOp.left == UnkownBoolValueSqlExpr.instance) {
                    return binOp.right;
                }
                if (binOp.right == UnkownBoolValueSqlExpr.instance) {
                    return binOp.left;
                }
                return expr;
            }
        } else {
            if (expr instanceof SqlNotExpr) {
                SqlNotExpr notOp = (SqlNotExpr)expr;
                notOp.expr = this.solveWhere(notOp.expr);
                if (notOp.expr == UnkownBoolValueSqlExpr.instance) {
                    return UnkownBoolValueSqlExpr.instance;
                }
                return expr;
            }
            if (expr instanceof SqlInSubQueryExpr || expr instanceof SqlExistsExpr || expr instanceof QueryExpr) {
                SqlSelectBase subSelect = expr instanceof SqlInSubQueryExpr ? ((SqlInSubQueryExpr)expr).subQuery : (expr instanceof SqlExistsExpr ? ((SqlExistsExpr)expr).subQuery : ((QueryExpr)expr).subQuery);
                if (subSelect instanceof SqlSelect && ((SqlSelect)subSelect).condition != null) {
                    ((SqlSelect)subSelect).condition = this.solveWhere(((SqlSelect)subSelect).condition);
                    if (((SqlSelect)subSelect).condition == UnkownBoolValueSqlExpr.instance) {
                        ((SqlSelect)subSelect).condition = null;
                    }
                }
                return expr;
            }
        }
        return this.solvePureSqlExpr(expr);
    }

    private void solveOrderBy(List orderBys) {
        if (orderBys == null) {
            return;
        }
        for (int i = 0; i < orderBys.size(); ++i) {
            SqlOrderByItem item = (SqlOrderByItem)orderBys.get(i);
            String exprStr = item.expr.toString();
            try {
                String newExprStr = BindParam.replaceVariantEXKSQL(exprStr, this.params, this.simpleVarStyle);
                if (StringUtil.equals((String)newExprStr, (String)exprStr)) continue;
                item.expr = this.str2KsqlExpr(newExprStr);
                continue;
            }
            catch (Exception e) {
                orderBys.remove(i);
                --i;
            }
        }
    }

    private String solveEntityView(String viewStr) throws Exception {
        if (viewStr == null || viewStr.length() == 0) {
            return viewStr;
        }
        SqlSelect select = (SqlSelect)this.solveSelect("SELECT * FROM T " + viewStr);
        viewStr = "";
        if (select.condition != null) {
            CtrlDesignKsqlSolver.covertSqlExpr_forEntityView(select.condition);
            viewStr = "WHERE " + select.condition.toString() + " ";
        }
        if (select.orderBy != null && select.orderBy.size() > 0) {
            viewStr = viewStr + "ORDER BY " + this.orderBys2Str_forEntityView(select.orderBy);
        }
        return viewStr;
    }

    private SqlSelectBase solveSelect(String select) throws Exception {
        SqlSelectBase sqlSelect = null;
        try {
            sqlSelect = CtrlDesignKsqlSolver.makeSqlSelect(select);
        }
        catch (Exception e) {
            throw CtrlReportException.makeException(MessageUtil.getMsgInfo("label249") + "\r\n" + e.getMessage(), e);
        }
        for (String key : this.dateTypeMap.keySet()) {
            if (!this.params.containsKey(key)) continue;
            this.params.remove(key);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("remove dateType insert temp:" + key));
        }
        this.solveSelect(sqlSelect);
        return sqlSelect;
    }

    private void solveSelect(SqlSelectBase sqlSelectBase) throws ParserException, CtrlReportException {
        if (sqlSelectBase instanceof SqlUnionSelect) {
            SqlUnionSelect unionSelect = (SqlUnionSelect)sqlSelectBase;
            this.solveSelect(unionSelect.left);
            this.solveSelect(unionSelect.right);
            if (unionSelect.orderBy != null) {
                this.solveOrderBy(unionSelect.orderBy);
            }
        } else if (sqlSelectBase instanceof SqlSelect) {
            SqlExpr newExpr;
            SqlSelect sqlSelect = (SqlSelect)sqlSelectBase;
            if (sqlSelect.condition != null) {
                newExpr = this.solveWhere(sqlSelect.condition);
                sqlSelect.condition = newExpr == UnkownBoolValueSqlExpr.instance ? null : newExpr;
            }
            this.solveSubQueryList(sqlSelect.subQueries);
            this.solveTableSource(sqlSelect.tableSource);
            this.solveOrderBy(sqlSelect.orderBy);
            if (sqlSelect.having != null) {
                newExpr = this.solveWhere(sqlSelect.having);
                sqlSelect.having = newExpr == UnkownBoolValueSqlExpr.instance ? null : newExpr;
            }
        }
    }

    private void solveTableSource(SqlTableSourceBase tableSource) throws ParserException, CtrlReportException {
        if (tableSource == null) {
            return;
        }
        if (tableSource instanceof SqlSubQueryTableSource) {
            this.solveSelect(((SqlSubQueryTableSource)tableSource).subQuery);
        } else if (tableSource instanceof SqlJoinedTableSource) {
            this.solveTableSource(((SqlJoinedTableSource)tableSource).left);
            this.solveTableSource(((SqlJoinedTableSource)tableSource).right);
            this.solveWhere(((SqlJoinedTableSource)tableSource).condition);
        }
        this.solveSubQueryList(tableSource.subQueries);
    }

    private void solveSelectList(List selectList) {
        if (selectList == null) {
            return;
        }
        Iterator iter = selectList.iterator();
        while (iter.hasNext()) {
            try {
                this.solveSelect(((SqlSelectItem)iter.next()).expr.toString());
            }
            catch (Throwable throwable) {}
        }
    }

    private void solveSubQueryList(List subQueries) throws ParserException, CtrlReportException {
        if (subQueries == null) {
            return;
        }
        Iterator iter = subQueries.iterator();
        while (iter.hasNext()) {
            this.solveSelect((SqlSelectBase)iter.next());
        }
    }

    private static class UnkownBoolValueSqlExpr
    extends SqlExpr {
        private static final UnkownBoolValueSqlExpr instance = new UnkownBoolValueSqlExpr();

        private UnkownBoolValueSqlExpr() {
            super(Short.MAX_VALUE);
        }
    }
}

