/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.rpts.ctrlsqldesign.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.ctrl.common.CtrlUtil;
import com.kingdee.bos.ctrl.common.util.LogUtil;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.data.framework.bos.BosQuery2SQLFactory;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.Condition;
import com.kingdee.bos.ctrl.data.modal.query.IColumnList;
import com.kingdee.bos.ctrl.data.modal.query.IJoinList;
import com.kingdee.bos.ctrl.data.modal.query.IOrderList;
import com.kingdee.bos.ctrl.data.modal.query.IQuery;
import com.kingdee.bos.ctrl.data.modal.query.ITable;
import com.kingdee.bos.ctrl.data.modal.query.ITableList;
import com.kingdee.bos.ctrl.data.modal.query.Join;
import com.kingdee.bos.ctrl.data.modal.query.Order;
import com.kingdee.bos.ctrl.data.modal.query.QueryType;
import com.kingdee.bos.ctrl.data.modal.query.Table;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedFilterList;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.eas.rpts.ctrlsqldesign.data.DesignBmd2Meta;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignCondition;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignFinal;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignKsqlQuery;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignUtil;
import com.kingdee.shr.rpts.ctrlsqldesign.model.ParseFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class CtrlDesignSQLMaker {
    private static final Logger log = LogUtil.getPackageLogger(CtrlDesignSQLMaker.class);
    public static final String NATIVE_SQL_PREFIX = "/*dialect*/";
    private static final String[] INDENTS = new String[4];
    private static final String UNDEFINED_QUERY_TABLE = "UNDEFINED-QUREY-TABLE:";
    private static final String UNDEFINED_META_FIELD = "UNDEFINED-META-FIELD:";
    public static final Pattern MC_AS;
    public static final Pattern QT_MF;
    private Context bosCtx;

    public CtrlDesignSQLMaker(Context bosCtx) {
        this.bosCtx = bosCtx;
    }

    public static String makeQuery(IQuery qry) {
        return CtrlDesignSQLMaker.makeQuery(qry, null);
    }

    public static String makeQuery(IQuery qry, String[] fields) {
        if (qry.getQueryType() == QueryType.SQL_CUSTOM) {
            return qry.getContent();
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT");
        if (qry.isDistinct()) {
            sql.append(" DISTINCT");
        }
        if (fields == null) {
            sql.append(CtrlDesignSQLMaker.makeSelect(qry.getColumns()));
        } else {
            sql.append(CtrlDesignSQLMaker.makeSelect(fields));
        }
        sql.append("\r\nFROM");
        sql.append(CtrlDesignSQLMaker.makeFrom(qry.getTables(), qry.getJoins()));
        String s = CtrlDesignSQLMaker.makeWhere(qry.getFilter());
        if (!StringUtil.isEmptyString((String)s)) {
            sql.append("\r\nWHERE ");
            sql.append(s);
        }
        if (!StringUtil.isEmptyString((String)(s = CtrlDesignSQLMaker.makeOrderBy(qry.getOrders())))) {
            sql.append("\r\nORDER BY");
            sql.append(s);
        }
        return sql.toString();
    }

    public static String makeSelect(String[] fields) {
        return fields == null || fields.length == 0 ? "\r\n *" : CtrlUtil.Array.objectArray2String((Object[])fields, (String)",\r\n");
    }

    public static String makeSelect(IColumnList cols) {
        int z = cols.size();
        if (z == 0) {
            return "\r\n *";
        }
        StringBuffer select = new StringBuffer();
        for (int i = 0; i < z; ++i) {
            if (i > 0) {
                select.append(",");
            }
            select.append("\r\n ");
            select.append(CtrlDesignSQLMaker.makeSelectColumn((Column)cols.get(i)));
        }
        return select.toString();
    }

    public static String makeSelectColumn(Column col) {
        StringBuffer sb = new StringBuffer();
        sb.append(col.getExpr());
        sb.append(" AS \"");
        sb.append(col.getName());
        sb.append("\"");
        return sb.toString();
    }

    public static String makeFrom(ITableList tbls, IJoinList joins) {
        JoinsParser jem = new JoinsParser(joins);
        List nodes = jem.getTopestNodes();
        StringBuffer sb = new StringBuffer();
        int tabCount = tbls.size();
        for (int i = 0; i < tabCount; ++i) {
            ITable tbl = (ITable)tbls.get(i);
            if (-1 != jem.findTopestNode(tbl.getName())) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append("\r\n ");
            sb.append(CtrlDesignSQLMaker.makeFromTable(tbl));
        }
        int joinCount = nodes.size();
        for (int i = 0; i < joinCount; ++i) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("\r\n ");
            JoinNode joinExt = (JoinNode)nodes.get(i);
            sb.append(CtrlDesignSQLMaker.makeJoinNode(joinExt, tbls, 0));
        }
        return sb.toString();
    }

    public static String makeFromTable(ITable tbl) {
        StringBuffer content = new StringBuffer();
        if (tbl instanceof Table) {
            content.append("[");
            content.append(tbl.getExpr());
            content.append("]");
        } else if (tbl instanceof IQuery) {
            content.append("(");
            content.append(((IQuery)tbl).getContent());
            content.append(")");
        }
        content.append(" AS \"");
        content.append(tbl.getName());
        content.append("\"");
        return content.toString();
    }

    public static String makeFromTable(ITableList tbls, String tblName) {
        ITable tbl = (ITable)tbls.get(tblName);
        if (tbl == null) {
            return UNDEFINED_QUERY_TABLE + tblName;
        }
        return CtrlDesignSQLMaker.makeFromTable(tbl);
    }

    public static String makeJoinNode(JoinNode node, ITableList tbls, int nest) {
        ArrayList joins = node.getJoins();
        Join join = (Join)joins.get(0);
        String[] s2 = new String[2];
        for (int i = 0; i < 2; ++i) {
            JoinNode jn;
            JoinNode joinNode = jn = i == 0 ? node.getLeft() : node.getRight();
            s2[i] = jn == null ? CtrlDesignSQLMaker.makeFromTable(tbls, i == 0 ? join.getLeftTable() : join.getRightTable()) : "(" + CtrlDesignSQLMaker.makeJoinNode(jn, tbls, nest + 1) + ")\r\n";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(s2[0] + " " + join.getJoinType().getName().toUpperCase() + " JOIN " + s2[1] + " ON ");
        int z = joins.size();
        for (int i = 0; i < z; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            join = (Join)joins.get(i);
            sb.append("(" + join.getCondition().getExpr() + ")");
        }
        return sb.toString();
    }

    public static String makeWhere(Condition cnd) {
        if (cnd == null) {
            return null;
        }
        CtrlDesignCondition cdcnd = (CtrlDesignCondition)cnd;
        if (null != cdcnd.getDynamicExpr()) {
            String de = cdcnd.getDynamicExpr();
            cdcnd.setDynamicExpr(null);
            return de;
        }
        String whereString = ParseFilter.getWhereString((DesignedFilterList)cdcnd.getExtObj());
        return whereString;
    }

    public static String makeOrderBy(IOrderList ords) {
        int z = ords.size();
        if (z == 0) {
            return null;
        }
        StringBuffer select = new StringBuffer();
        for (int i = 0; i < z; ++i) {
            if (i > 0) {
                select.append(", ");
            }
            select.append("\r\n ");
            select.append(CtrlDesignSQLMaker.makeOrderColumn((Order)ords.get(i)));
        }
        return select.toString();
    }

    public static String makeOrderColumn(Order ord) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        sb.append(ord.getExpr());
        sb.append("\"");
        sb.append(ord.isAscending() ? " ASC" : " DESC");
        return sb.toString();
    }

    public String buildSQL(IQuery qry) {
        return null;
    }

    public String buildSQLNew(IQuery qry) throws BOSException {
        return this.buildSQL(qry, null);
    }

    private String wrapFields(String sql, String[] fields) {
        if (fields == null) {
            return sql;
        }
        boolean nativeSql = sql != null && sql.startsWith(NATIVE_SQL_PREFIX);
        String sql2 = null;
        if (null != sql) {
            sql2 = sql.substring(nativeSql ? NATIVE_SQL_PREFIX.length() : 0).trim();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT ").append(CtrlUtil.Array.objectArray2String((Object[])fields, (String)",")).append(" FROM (").append(sql2).append(") AS ").append("T").append(System.currentTimeMillis());
        if (nativeSql) {
            sb.insert(0, NATIVE_SQL_PREFIX);
        }
        return sb.toString();
    }

    public String buildSQL(IQuery qry, String[] fields) throws BOSException {
        String sql;
        if (QueryType.SQL_WIZARD.equals(qry.getQueryType())) {
            sql = CtrlDesignSQLMaker.makeQuery(qry, fields);
        } else {
            sql = qry.getContent();
            ((CtrlDesignKsqlQuery)qry).setDynamicContent(null);
            if (sql != null && sql.startsWith(NATIVE_SQL_PREFIX)) {
                return this.wrapFields(sql, fields);
            }
        }
        sql = this.replaceMeta(sql, qry);
        if (!QueryType.SQL_WIZARD.equals(qry.getQueryType())) {
            sql = this.wrapFields(sql, fields);
        }
        return sql;
    }

    private String replaceMeta(String qryExpr, IQuery qry) throws BOSException {
        int i;
        ITableList tbls = qry.getTables();
        Matcher mch = QT_MF.matcher(qryExpr);
        StringBuffer sb1 = new StringBuffer();
        int j = 0;
        while (mch.find()) {
            i = mch.start();
            sb1.append(qryExpr.substring(j, i));
            j = mch.end();
            sb1.append(this.replaceQtMf(qryExpr.substring(i, j), tbls));
        }
        sb1.append(qryExpr.substring(j));
        mch = MC_AS.matcher(sb1);
        StringBuffer sb2 = new StringBuffer();
        j = 0;
        while (mch.find()) {
            i = mch.start() + 1;
            sb2.append(sb1.substring(j, i));
            j = mch.end() - 4;
            sb2.append(this.getTableSQLNew(sb1.substring(i + 1, j - 1)));
        }
        sb2.append(sb1.substring(j));
        return sb2.toString();
    }

    private String replaceQtMf(String qtmf, ITableList tbls) {
        int i = qtmf.indexOf("].[");
        String qtName = qtmf.substring(1, i);
        String mfName = qtmf.substring(i + 3, qtmf.length() - 1);
        ITable tbl = (ITable)tbls.get(qtName);
        if (tbl instanceof Table) {
            String colExpr = this.getColumnSQL(tbl.getExpr(), mfName);
            mfName = colExpr != null ? colExpr : UNDEFINED_META_FIELD + mfName;
        } else if (!(tbl instanceof IQuery)) {
            qtName = UNDEFINED_QUERY_TABLE + qtName;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        sb.append(qtName);
        sb.append("\".");
        sb.append(mfName);
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(CtrlDesignSQLMaker.makeSelect((String[])null));
    }

    protected String getColumnSQL(String qtName, String mfName) {
        String category = CtrlDesignUtil.getDesignTableType(qtName);
        String fullName = CtrlDesignUtil.getDesignTableExp(qtName);
        if (CtrlDesignFinal.isMetaDataTabel(category)) {
            DataTableInfo dti = (DataTableInfo)this.getMetaData(category, fullName);
            ColumnInfo ci = dti.getColumnByName(mfName);
            if (ci == null) {
                return null;
            }
            if (ci.isMultilingual()) {
                StringBuffer sb = new StringBuffer();
                sb.append(mfName);
                sb.append("_");
                sb.append(ContextUtils.getLocaleFromEnv());
                return sb.toString();
            }
            return mfName;
        }
        if (CtrlDesignFinal.isMetaDataQuery(category)) {
            StringBuffer sb = new StringBuffer();
            sb.append("\"");
            sb.append(mfName);
            sb.append("\"");
            return sb.toString();
        }
        return null;
    }

    protected String getTableSQL(String mcExpr) {
        return null;
    }

    protected String getTableSQLNew(String mcExpr) throws BOSException {
        String category = CtrlDesignUtil.getDesignTableType(mcExpr);
        String fullName = CtrlDesignUtil.getDesignTableExp(mcExpr);
        if (CtrlDesignFinal.isMetaDataTabel(category)) {
            return ((DataTableInfo)this.getMetaData(category, fullName)).getName();
        }
        if (CtrlDesignFinal.isMetaDataQuery(category)) {
            String queryExp = CtrlDesignUtil.getDesignTableExp(mcExpr);
            StringBuffer sb = new StringBuffer();
            sb.append("(");
            String qyrSql = "NoFoundQueryException:" + fullName;
            try {
                qyrSql = BosQuery2SQLFactory.getInstance((Context)this.bosCtx, null).getSubQuerySQL(queryExp);
            }
            catch (Exception e) {
                log.error((Object)("getTableSQLNew BOSException" + fullName + ", " + e.getMessage()));
            }
            sb.append(qyrSql);
            sb.append(")");
            return sb.toString();
        }
        return null;
    }

    private IObjectValue getMetaData(String category, String fullName) {
        return DesignBmd2Meta.getDesignMetaData((String)category, (String)fullName, (Context)this.bosCtx);
    }

    static {
        CtrlDesignSQLMaker.INDENTS[0] = "";
        CtrlDesignSQLMaker.INDENTS[1] = " ";
        CtrlDesignSQLMaker.INDENTS[2] = "  ";
        CtrlDesignSQLMaker.INDENTS[3] = "   ";
        MC_AS = Pattern.compile("[^\\.]\\[[^\\[\\]]*\\]\\ AS ", 32);
        QT_MF = Pattern.compile("\\[[^\\[\\]]*\\]\\.\\[[^\\[\\]]*\\]", 32);
    }

    private static class JoinsParser {
        private ArrayList topestNodes;

        public JoinsParser(IJoinList joins) {
            this.parse(joins);
        }

        public List getTopestNodes() {
            return this.topestNodes;
        }

        private void parse(IJoinList joins) {
            this.topestNodes = new ArrayList();
            int z = joins.size();
            for (int i = 0; i < z; ++i) {
                JoinNode rightNode;
                Join join = (Join)joins.get(i);
                int left = this.findTopestNode(join.getLeftTable());
                int right = this.findTopestNode(join.getRightTable());
                if (left == -1) {
                    if (right == -1) {
                        this.topestNodes.add(new JoinNode(join));
                        continue;
                    }
                    JoinNode rightExt = (JoinNode)this.topestNodes.get(right);
                    this.topestNodes.set(right, new JoinNode(join, null, rightExt));
                    continue;
                }
                if (right == -1) {
                    JoinNode leftExt = (JoinNode)this.topestNodes.get(left);
                    this.topestNodes.set(left, new JoinNode(join, leftExt, null));
                    continue;
                }
                JoinNode leftNode = (JoinNode)this.topestNodes.get(left);
                if (leftNode == (rightNode = (JoinNode)this.topestNodes.get(right))) {
                    JoinNode node = this.findLowestNode(leftNode, join);
                    node.addJoin(join);
                    continue;
                }
                if (left > right) {
                    int tmp = left;
                    left = right;
                    right = tmp;
                }
                this.topestNodes.set(left, new JoinNode(join, leftNode, rightNode));
                this.topestNodes.remove(right);
            }
        }

        private int findTopestNode(String tblName) {
            for (int i = 0; i < this.topestNodes.size(); ++i) {
                JoinNode joinExt = (JoinNode)this.topestNodes.get(i);
                if (!joinExt.containsTable(tblName)) continue;
                return i;
            }
            return -1;
        }

        private JoinNode findLowestNode(JoinNode startNode, Join join) {
            for (int i = 0; i < 2; ++i) {
                JoinNode node;
                JoinNode joinNode = node = i == 0 ? startNode.getLeft() : startNode.getRight();
                if (node == null || !node.containsTables(join)) continue;
                return this.findLowestNode(node, join);
            }
            return startNode;
        }
    }

    private static class JoinNode {
        private ArrayList tables = new ArrayList();
        private ArrayList joins = new ArrayList();
        private JoinNode left;
        private JoinNode right;

        public JoinNode(Join join) {
            this.addJoin(join);
            this.tables.add(join.getLeftTable());
            this.tables.add(join.getRightTable());
        }

        public JoinNode(Join join, JoinNode left, JoinNode right) {
            this(join);
            if (left != null) {
                this.left = left;
                this.tables.addAll(left.getTables());
            }
            if (right != null) {
                this.right = right;
                this.tables.addAll(right.getTables());
            }
        }

        public void addJoin(Join join) {
            this.joins.add(join);
        }

        public ArrayList getJoins() {
            return this.joins;
        }

        public ArrayList getTables() {
            return this.tables;
        }

        public boolean containsTable(String name) {
            return this.tables.contains(name);
        }

        public boolean containsTables(Join join) {
            return this.tables.contains(join.getLeftTable()) && this.tables.contains(join.getRightTable());
        }

        public JoinNode getLeft() {
            return this.left;
        }

        public JoinNode getRight() {
            return this.right;
        }
    }
}

