/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.rpts.ctrlsqldesign.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_FORMAT_0 = "MM/dd/yyyy";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String TIMESTAMP_FORMAT_0 = "MM/dd/yyyy HH:mm:ss";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final int[] CalendarWeek = new int[]{1, 2, 3, 4, 5, 6, 7};

    public static final String getMonthFirstDay(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-01");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 0);
        return sdf.format(cal.getTime());
    }

    public static final String getMonthLastDay(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String firstDay = DateUtil.getMonthFirstDay(date);
        Calendar cal = Calendar.getInstance();
        try {
            Date firstDate = sdf.parse(firstDay);
            cal.setTime(firstDate);
            cal.add(2, 1);
            cal.add(5, -1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sdf.format(cal.getTime());
    }

    public static final String tuneDate(String date, int amount) {
        String yesterday = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
            Date curr = sdf.parse(date);
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(curr);
            gc.add(5, amount);
            curr = gc.getTime();
            yesterday = sdf.format(curr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return yesterday;
    }

    public static final String tuneSecond(String date, int amount) {
        String yesterday = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(TIMESTAMP_FORMAT);
            Date curr = sdf.parse(date);
            GregorianCalendar gc = new GregorianCalendar();
            gc.setTime(curr);
            gc.add(13, amount);
            curr = gc.getTime();
            yesterday = sdf.format(curr);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return yesterday;
    }

    public static final String tuneDate(Date date, int amount) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        String dateString = sdf.format(date);
        return DateUtil.tuneDate(dateString, amount);
    }

    public static final String tuneDateTime(Date date, int amount) {
        SimpleDateFormat sdf = new SimpleDateFormat(TIMESTAMP_FORMAT);
        String dateTimeString = sdf.format(date);
        String[] arr = dateTimeString.split(" ");
        String dateString = arr[0];
        String timeString = arr[1];
        return DateUtil.tuneDate(dateString, amount) + " " + timeString;
    }

    public static final String[] getDateTimeArr(String datetime) {
        if (datetime.indexOf(" ") != -1) {
            String[] arr = datetime.split(" ");
            String date = arr[0];
            String time = arr[1];
            String[] dateArr = date.split("-");
            String[] timeArr = time.split(":");
            String[] resultArr = new String[]{dateArr[0], dateArr[1], dateArr[2], timeArr[0], timeArr[1], timeArr[2]};
            return resultArr;
        }
        if (datetime.indexOf("-") != -1) {
            return datetime.split("-");
        }
        if (datetime.indexOf(":") != -1) {
            return datetime.split(":");
        }
        return null;
    }

    public static String getDateOfWeek(Date date, int week) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(7, CalendarWeek[week]);
        String result = sdf.format(cal.getTime());
        return result;
    }

    public static String getDateOfQuarter(String date, boolean isBegin) {
        String quarBegin = "";
        String quarEnd = "";
        String[] arr = DateUtil.getDateTimeArr(date);
        String year = "";
        String month = "";
        if (null != arr) {
            year = arr[0];
            month = arr[1];
        }
        switch (Integer.parseInt(month)) {
            case 1: 
            case 2: 
            case 3: {
                quarBegin = year + "-01-01";
                quarEnd = year + "-03-31";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                quarBegin = year + "-04-01";
                quarEnd = year + "-06-30";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                quarBegin = year + "-07-01";
                quarEnd = year + "-09-30";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                quarBegin = year + "-10-01";
                quarEnd = year + "-12-31";
                break;
            }
        }
        if (isBegin) {
            return quarBegin;
        }
        return quarEnd;
    }

    public static String format(Date d) {
        return DateUtil.format(d, null, null);
    }

    public static String format(Date d, String fmt) {
        return DateUtil.format(d, fmt, null);
    }

    public static String format(Date d, String fmt, TimeZone timezone) {
        return DateUtil.format(d, fmt, timezone, null);
    }

    public static String format(Date d, String fmt, TimeZone timezone, Locale locale) {
        if (fmt == null) {
            fmt = TIMESTAMP_FORMAT;
        }
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            df.setTimeZone(TimeZone.getDefault());
        } else {
            df.setTimeZone(timezone);
        }
        return df.format(d);
    }

    public static String format(Date d, TimeZone timezone) {
        return DateUtil.format(d, null, timezone);
    }

    public static Date parseDate(String s) throws ParseException {
        try {
            return DateUtil.parseDate(s, TIMESTAMP_FORMAT);
        }
        catch (ParseException parseException) {
            try {
                return DateUtil.parseDate(s, DATE_FORMAT);
            }
            catch (ParseException parseException2) {
                try {
                    return DateUtil.parseDate(s, TIMESTAMP_FORMAT_0);
                }
                catch (ParseException parseException3) {
                    try {
                        return DateUtil.parseDate(s, DATE_FORMAT_0);
                    }
                    catch (ParseException parseException4) {
                        try {
                            return DateUtil.parseDate(s, TIME_FORMAT);
                        }
                        catch (ParseException parseException5) {
                            throw new ParseException("can not understand your format", -1);
                        }
                    }
                }
            }
        }
    }

    public static Date parseDate(String s, String fmt) throws ParseException {
        return DateUtil.parseDate(s, fmt, null);
    }

    public static Date parseDate(String s, String fmt, TimeZone timezone) throws ParseException {
        return DateUtil.parseDate(s, fmt, timezone, null);
    }

    public static Date parseDate(String s, String fmt, TimeZone timezone, Locale locale) throws ParseException {
        SimpleDateFormat df = locale == null ? new SimpleDateFormat(fmt) : new SimpleDateFormat(fmt, locale);
        if (timezone == null) {
            timezone = TimeZone.getDefault();
        }
        df.setTimeZone(timezone);
        df.setLenient(false);
        return df.parse(s);
    }

    public static Date addMonth(Date dDate, int iNbMonth) {
        if (null == dDate) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        cal.add(2, iNbMonth);
        return cal.getTime();
    }

    public static Date addDay(Date dDate, int iNbDay) {
        if (null == dDate) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(dDate);
        cal.add(5, iNbDay);
        return cal.getTime();
    }

    public static int getYear(Date d) {
        if (null == d) {
            return 0;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(1);
    }

    public static int getMonth(Date d) {
        if (null == d) {
            return 1;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(2) + 1;
    }

    public static int getDay(Date d) {
        if (null == d) {
            return 1;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        return cal.get(5);
    }
}

