/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.rpts.snapshot.ds.model;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.DataType;
import com.kingdee.bos.ctrl.data.modal.query.Column;
import com.kingdee.bos.ctrl.data.modal.query.IColumnList;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedFilter;
import com.kingdee.bos.ctrl.data.modal.query.design.DesignedFilterList;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.ShrSqlEnum;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.rpts.ctrlreport.osf.OSFExecutor;
import com.kingdee.shr.rpts.ctrlsqldesign.model.CtrlDesignCondition;
import com.kingdee.shr.rpts.ctrlsqldesign.model.DateUtil;
import com.kingdee.shr.rpts.ctrlsqldesign.model.ParseFilter;
import com.kingdee.shr.rpts.snapshot.ds.model.QueryFilterUtil;
import com.kingdee.shr.rpts.snapshot.ds.model.ShrSqlModel;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ShrSqlMakeUtil {
    public static DataType getDataType(String type) {
        if (DataType.INTEGER.getName().equalsIgnoreCase(type)) {
            return DataType.INTEGER;
        }
        if ("Date".equalsIgnoreCase(type)) {
            return DataType.DATETIME;
        }
        if (DataType.FLOAT.getName().equalsIgnoreCase(type)) {
            return DataType.FLOAT;
        }
        if (DataType.BOOLEAN.getName().equalsIgnoreCase(type)) {
            return DataType.BOOLEAN;
        }
        return DataType.STRING;
    }

    private static String[] getDateReplaceStr(int index) {
        StringBuffer str = new StringBuffer();
        str.append("{").append(3000 + index).append("-12-12");
        str.append(" 00:00:00}");
        StringBuffer returnstr = new StringBuffer();
        returnstr.append("{ts '").append(3000 + index).append("-12-12");
        returnstr.append(" 00:00:00'}");
        String[] replaceStr = new String[]{str.toString(), returnstr.toString()};
        return replaceStr;
    }

    private static DataType getDateType(ShrSqlModel model, String expr) {
        IColumnList columns = model.getQuery().getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column c = (Column)columns.get(i);
            if (null == c || null == c.getName() || null == c.getDataType() || !c.getName().equalsIgnoreCase(expr)) continue;
            return c.getDataType();
        }
        return null;
    }

    private static String[] getIntReplaceStr(int index) {
        int a = Integer.MAX_VALUE;
        String[] replaceStr = new String[]{"" + (a - index), "" + (a - index)};
        return replaceStr;
    }

    private static String[] getStrDateReplaceStr(int index) {
        StringBuffer str = new StringBuffer();
        str.append("2200-12-");
        str.append(index);
        StringBuffer returnstr = new StringBuffer();
        returnstr.append("{ts '2200-12-");
        if (index < 10) {
            returnstr.append("0");
        }
        returnstr.append(index);
        returnstr.append(" 00:00:00'}");
        String[] replaceStr = new String[]{str.toString(), returnstr.toString()};
        return replaceStr;
    }

    private static String[] getStringReplaceStr(int index) {
        StringBuffer str = new StringBuffer();
        str.append("'###");
        for (int i = 0; i < index; ++i) {
            str.append("1");
        }
        str.append("###'");
        String[] replaceStr = new String[]{str.toString(), str.toString()};
        return replaceStr;
    }

    private static String getWhereString(Context ctx, ShrSqlModel model, HashMap<String, String[]> paramReplace, FilterInfo filterInfo) {
        int dateIndex = 11;
        int stringIndex = 1;
        int intIndex = 1;
        StringBuffer whereString = new StringBuffer();
        if (null == filterInfo || filterInfo.getFilterItems().size() == 0) {
            return "";
        }
        if (model.getAllColumns() == null || model.getAllColumns().size() == 0) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("scheme", model.getScheme());
            Object result = OSFExecutor.executeOSF(null, param, "getQueryFieldNodes");
            List nodes = (List)result;
            HashMap<String, String> rootNode = new HashMap<String, String>();
            rootNode.put("name", SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"employee_info", (Context)ctx));
            DefaultKingdeeTreeNode rootTreeNode = new DefaultKingdeeTreeNode();
            for (int i = 0; i < nodes.size(); ++i) {
                HashMap node = (HashMap)nodes.get(i);
                Column column = new Column();
                column.setName((String)node.get("field"));
                column.setDataType(ShrSqlMakeUtil.getDataType((String)node.get("dataType")));
                column.setAlias((String)node.get("name"));
                column.setExpr(column.getName());
                model.getAllColumns().add((Object)column);
            }
        }
        FilterItemCollection filterItems = filterInfo.getFilterItems();
        for (int itemIndex = 0; itemIndex < filterItems.size(); ++itemIndex) {
            String key;
            FilterItemInfo itemInfo = filterItems.get(itemIndex);
            if (!ShrSqlMakeUtil.isParam(itemInfo.getCompareValue().toString()) || paramReplace.containsKey(key = itemInfo.getCompareValue().toString())) continue;
            String expr = itemInfo.getCompareExpression();
            DataType datetype = ShrSqlMakeUtil.getDateType(model, expr);
            if (DataType.STRING.equals(datetype)) {
                paramReplace.put(key, ShrSqlMakeUtil.getStringReplaceStr(stringIndex));
                ++stringIndex;
                continue;
            }
            if (DataType.DATETIME.equals(datetype)) {
                paramReplace.put(key, ShrSqlMakeUtil.getDateReplaceStr(dateIndex));
                ++dateIndex;
                continue;
            }
            if (!DataType.INTEGER.equals(datetype)) continue;
            paramReplace.put(key, ShrSqlMakeUtil.getIntReplaceStr(intIndex));
            ++intIndex;
        }
        whereString.append(" ").append(filterInfo.toString());
        return whereString.toString();
    }

    public static final String getWhereString(ShrSqlModel model, HashMap<String, String[]> paramReplace, DesignedFilterList designedFilterList) {
        int dateIndex = 11;
        int stringIndex = 1;
        int intIndex = 1;
        StringBuffer whereString = new StringBuffer();
        if (null == designedFilterList) {
            return "";
        }
        List filterList = designedFilterList.getFilterList();
        if (null == filterList) {
            return "";
        }
        for (DesignedFilter filter : filterList) {
            String value;
            DataType dateType;
            String key;
            if (ShrSqlMakeUtil.isParam(filter.getValue().toString()) && !paramReplace.containsKey(key = filter.getValue().toString())) {
                String expr = filter.getExpression();
                DataType datetype = ShrSqlMakeUtil.getDateType(model, expr);
                if (DataType.STRING.equals(datetype)) {
                    paramReplace.put(key, ShrSqlMakeUtil.getStringReplaceStr(stringIndex));
                    ++stringIndex;
                } else if (DataType.DATETIME.equals(datetype)) {
                    paramReplace.put(key, ShrSqlMakeUtil.getDateReplaceStr(dateIndex));
                    ++dateIndex;
                } else if (DataType.INTEGER.equals(datetype)) {
                    paramReplace.put(key, ShrSqlMakeUtil.getIntReplaceStr(intIndex));
                    ++intIndex;
                } else {
                    paramReplace.put(key, ShrSqlMakeUtil.getIntReplaceStr(intIndex));
                    ++intIndex;
                }
            }
            if (DataType.DATETIME.equals(dateType = ShrSqlMakeUtil.getDateType(model, filter.getExpression())) && (value = filter.getValue()).contains("/")) {
                String[] split = value.split("'");
                String date = split[1];
                Date parseDate = null;
                try {
                    parseDate = DateUtil.parseDate(date, "MM/dd/yyyy");
                }
                catch (ParseException e) {
                    try {
                        parseDate = DateUtil.parseDate(date, "yyyy/MM/dd");
                    }
                    catch (ParseException e1) {
                        e1.printStackTrace();
                    }
                }
                String dt = DateUtil.format(parseDate, "yyyy-MM-dd");
                String val = split[0] + "'" + dt + "'" + split[2];
                filter.setValue(val);
            }
            whereString.append(" ").append(ParseFilter.getWhereString(filter));
        }
        String exprStr = whereString.toString();
        if (exprStr.length() > 3 && "and".equalsIgnoreCase(exprStr.substring(exprStr.length() - 3))) {
            exprStr = exprStr.substring(0, exprStr.length() - 4);
        } else if (exprStr.length() > 2 && "or".equalsIgnoreCase(exprStr.substring(exprStr.length() - 2))) {
            exprStr = exprStr.substring(0, exprStr.length() - 3);
        }
        return exprStr;
    }

    private static boolean isParam(String value) {
        return value != null && value.indexOf("@") >= 0;
    }

    public static String makeShrSql(Context ctx, ShrSqlModel model) throws EASBizException, BOSException {
        IColumnList selectedList = model.getQuery().getColumns();
        if (selectedList == null || selectedList.size() == 0) {
            return "";
        }
        StringBuffer selectStr = new StringBuffer();
        ArrayList columns = new ArrayList();
        int total = selectedList.size();
        for (int i = 0; i < total; ++i) {
            if (selectStr.length() > 0) {
                selectStr.append(",");
            }
            selectStr.append(((Column)selectedList.get(i)).getName());
            HashMap<String, String> column = new HashMap<String, String>();
            column.put("name", ((Column)selectedList.get(i)).getName());
            column.put("datatype", ((Column)selectedList.get(i)).getDataType().getName());
            column.put("alias", ((Column)selectedList.get(i)).getAlias());
            column.put("isgroup", String.valueOf(((Column)selectedList.get(i)).getProperties().get("isgroup")));
            column.put("issum", String.valueOf(((Column)selectedList.get(i)).getProperties().get("issum")));
            column.put("isavg", String.valueOf(((Column)selectedList.get(i)).getProperties().get("isavg")));
            column.put("columnsql", String.valueOf(((Column)selectedList.get(i)).getProperties().get("columnsql")));
            columns.add(column);
        }
        String count = "false";
        String effdt = "";
        if (model.getCommonQuery().getProperty("selectDate") != null) {
            effdt = model.getCommonQuery().getProperty("selectDate").toString();
        }
        if (model.getCommonQuery().getProperty("ISGROUPCOUNT") != null) {
            count = model.getCommonQuery().getProperty("ISGROUPCOUNT").toString();
        }
        HashMap<String, String[]> paramReplace = new HashMap<String, String[]>();
        String startDate = "@startDate";
        if (model.getCommonQuery().getProperty("startDate") != null) {
            startDate = (String)model.getCommonQuery().getProperty("startDate");
        }
        String endDate = "@endDate";
        if (model.getCommonQuery().getProperty("endDate") != null) {
            endDate = (String)model.getCommonQuery().getProperty("endDate");
        }
        String beginYear = "@beginYear";
        if (model.getCommonQuery().getProperty("beginYear") != null) {
            beginYear = (String)model.getCommonQuery().getProperty("beginYear");
        }
        String beginMonth = "@beginMonth";
        if (model.getCommonQuery().getProperty("beginMonth") != null) {
            beginMonth = (String)model.getCommonQuery().getProperty("beginMonth");
        }
        String endYear = "@endYear";
        if (model.getCommonQuery().getProperty("endYear") != null) {
            endYear = (String)model.getCommonQuery().getProperty("endYear");
        }
        String endMonth = "@endMonth";
        if (model.getCommonQuery().getProperty("endMonth") != null) {
            endMonth = (String)model.getCommonQuery().getProperty("endMonth");
        }
        String incount = "false";
        List otherFilter = (List)model.getCommonQuery().getProperty("_otherfilter_");
        if (ShrSqlMakeUtil.isParam(effdt) && !paramReplace.containsKey(effdt)) {
            paramReplace.put(effdt, ShrSqlMakeUtil.getStrDateReplaceStr(10));
            effdt = ((String[])paramReplace.get(effdt))[0];
        }
        if (ShrSqlMakeUtil.isParam(startDate) && !paramReplace.containsKey(startDate)) {
            paramReplace.put(startDate, ShrSqlMakeUtil.getStrDateReplaceStr(9));
            startDate = ((String[])paramReplace.get(startDate))[0];
        }
        if (ShrSqlMakeUtil.isParam(endDate) && !paramReplace.containsKey(endDate)) {
            paramReplace.put(endDate, ShrSqlMakeUtil.getStrDateReplaceStr(8));
            endDate = ((String[])paramReplace.get(endDate))[0];
        }
        if (ShrSqlMakeUtil.isParam(beginYear) && !paramReplace.containsKey(beginYear)) {
            paramReplace.put(beginYear, new String[]{"1111111", "1111111"});
            beginYear = paramReplace.get(beginYear)[0];
        }
        if (ShrSqlMakeUtil.isParam(beginMonth) && !paramReplace.containsKey(beginMonth)) {
            paramReplace.put(beginMonth, new String[]{"2222222", "2222222"});
            beginMonth = paramReplace.get(beginMonth)[0];
        }
        if (ShrSqlMakeUtil.isParam(endYear) && !paramReplace.containsKey(endYear)) {
            paramReplace.put(endYear, new String[]{"3333333", "3333333"});
            endYear = paramReplace.get(endYear)[0];
        }
        if (ShrSqlMakeUtil.isParam(endMonth) && !paramReplace.containsKey(endMonth)) {
            paramReplace.put(endMonth, new String[]{"4444444", "4444444"});
            endMonth = paramReplace.get(endMonth)[0];
        }
        String whereString = ShrSqlMakeUtil.prepareWhere(ctx, model, paramReplace);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("scheme", model.getScheme());
        param.put("effdt", effdt);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        param.put("beginYear", beginYear);
        param.put("beginMonth", beginMonth);
        param.put("endYear", endYear);
        param.put("endMonth", endMonth);
        param.put("selectors", selectStr.toString());
        param.put("filters", whereString);
        param.put("returnType", "sql");
        param.put("incount", incount);
        if (null != otherFilter) {
            param.put("_otherfilter_", JSONUtils.convertObjectToJson((Context)ctx, (Object)otherFilter));
        }
        param.put("count", count);
        if (model.getQuery().isDistinct()) {
            param.put("distinct", "true");
        }
        param.put("grouptype", String.valueOf(model.getCommonQuery().getProperties().get("grouptype")));
        param.put("selecttype", String.valueOf(model.getCommonQuery().getProperties().get("selecttype")));
        param.put("permItemId", StringUtils.cnulls((String)model.getPermItemId()));
        param.put("pHr", StringUtils.cnulls((String)model.getPHr()));
        param.put("pAdmin", StringUtils.cnulls((String)model.getPAdmin()));
        param.put("adminType", StringUtils.cnulls((String)model.getAdminType()));
        param.put("FLongNumber", StringUtils.cnulls((String)model.getLongNumber()));
        param.put("FDisplayName", StringUtils.cnulls((String)model.getDisplayName()));
        param.put("ShrSqlEnum", (String)ShrSqlEnum.REPORT);
        param.put("columnsSet", JSONUtils.convertObjectToJson((Context)ctx, columns));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("configParam", JSONUtils.convertObjectToJson((Context)ctx, param));
        Object result = OSFExecutor.executeOSFRedirect(ctx, params, "getStructureConfigSql");
        if (result == null) {
            return null;
        }
        String sql = result.toString();
        for (Map.Entry<String, String[]> entry : paramReplace.entrySet()) {
            sql = StringUtils.replace((String)sql, (String)entry.getValue()[1], (String)entry.getKey());
        }
        return sql;
    }

    private static String prepareWhere(Context ctx, ShrSqlModel model, HashMap<String, String[]> paramReplace) {
        if (model.getCommonQuery().getProperty("shrfilter") != null && !StringUtils.isEmpty((String)model.getCommonQuery().getProperty("shrfilter").toString())) {
            FilterInfo filterInfo = QueryFilterUtil.getComplexQueryFilter(ctx, model.getCommonQuery().getProperty("shrfilter").toString());
            String getWhereString = ShrSqlMakeUtil.getWhereString(ctx, model, paramReplace, filterInfo);
            for (Map.Entry<String, String[]> entry : paramReplace.entrySet()) {
                getWhereString = StringUtils.replace((String)getWhereString, (String)entry.getKey(), (String)entry.getValue()[0]);
            }
            return getWhereString;
        }
        CtrlDesignCondition filter = (CtrlDesignCondition)model.getQuery().getFilter();
        DesignedFilterList extObj = null;
        if (filter != null) {
            extObj = (DesignedFilterList)filter.getExtObj();
        }
        String whereString = ShrSqlMakeUtil.getWhereString(model, paramReplace, extObj);
        for (Map.Entry<String, String[]> entry : paramReplace.entrySet()) {
            if (entry.getKey().toLowerCase().contains("select")) continue;
            whereString = StringUtils.replace((String)whereString, (String)entry.getKey(), (String)entry.getValue()[1]);
        }
        return whereString;
    }
}

