/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.app;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.SelectorInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IAttachment;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillBaseEntryInfo;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.attachment.AttachmentState;
import com.kingdee.shr.attachment.AttachmentTypeEnum;
import com.kingdee.shr.attachment.ISHRAttachmentExt;
import com.kingdee.shr.attachment.SHRAttachmentExtFactory;
import com.kingdee.shr.attachment.SHRAttachmentExtInfo;
import com.kingdee.shr.base.syssetting.CloudHubMessageFacadeFactory;
import com.kingdee.shr.base.syssetting.IMSFServiceFacade;
import com.kingdee.shr.base.syssetting.MSFServiceFacadeFactory;
import com.kingdee.shr.base.syssetting.SHRCommonFacadeFactory;
import com.kingdee.shr.base.syssetting.cloud.http.HttpResultVo;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.CloudHubUtil;
import com.kingdee.shr.cloudservice.util.TSPServerInstance;
import com.kingdee.shr.elecontract.util.CheckHRCloudLicenseUtils;
import com.kingdee.shr.elecontract.util.ElectronicTemplateSqlUtils;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.EContractSignFactory;
import com.kingdee.shr.shareservice.EContractSignInfo;
import com.kingdee.shr.shareservice.EContractSignSolutionSettingCollection;
import com.kingdee.shr.shareservice.EContractSignSolutionSettingFactory;
import com.kingdee.shr.shareservice.EContractSignSolutionSettingInfo;
import com.kingdee.shr.shareservice.EContractTemplateInfo;
import com.kingdee.shr.shareservice.EContractTemplateRelCollection;
import com.kingdee.shr.shareservice.EContractTemplateRelFactory;
import com.kingdee.shr.shareservice.EContractTemplateRelInfo;
import com.kingdee.shr.shareservice.ESignStatus;
import com.kingdee.shr.shareservice.EStatus;
import com.kingdee.shr.shareservice.SSCMessageType;
import com.kingdee.shr.shareservice.StateEnum;
import com.kingdee.shr.shareservice.TaskMessageLogFactory;
import com.kingdee.shr.shareservice.TaskMessageLogInfo;
import com.kingdee.shr.shareservice.app.AbstractEContractSignControllerBean;
import com.kingdee.shr.shareservice.app.EContractSignException;
import com.kingdee.shr.shareservice.util.AttachmentCheckUtils;
import com.kingdee.shr.shareservice.util.Base64Utils;
import com.kingdee.shr.shareservice.util.PropertyReader;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EContractSignControllerBean
extends AbstractEContractSignControllerBean {
    private static final long serialVersionUID = -1573387745170338403L;
    private static final Logger logger = LoggerFactory.getLogger(EContractSignControllerBean.class);
    private static Map<String, String> tspServerMap = null;
    private static String eid = "";

    @Override
    protected Object _sendMsg(Context ctx, IObjectPK pk, Map param) throws BOSException, EASBizException {
        EContractSignInfo signInfo = this.getEContractSignInfo(ctx, pk);
        return this.sendSignMsg(ctx, signInfo, param);
    }

    @Override
    protected Object _createSign(Context ctx, BOSUuid boId, String solutionNumber, Map param) throws BOSException, EASBizException {
        EntityObjectInfo boEntityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(boId.getType());
        String fullName = boEntityInfo.getFullName();
        EContractSignSolutionSettingInfo settingInfo = this.findSignSolutionSettingInfo(ctx, fullName, solutionNumber);
        EContractTemplateRelInfo relInfo = this.getEContractTemplateRelInfo(ctx, settingInfo.getEContractTemplate());
        HRBillBaseInfo billBaseInfo = this.getBillBaseInfo(ctx, boId, boEntityInfo);
        PropertyInfo propertyInfo = boEntityInfo.getPropertyByNameRuntime("entrys");
        if (propertyInfo != null && propertyInfo instanceof LinkPropertyInfo && billBaseInfo.get("entrys") instanceof IObjectCollection) {
            IObjectCollection entryColls = (IObjectCollection)billBaseInfo.get("entrys");
            HRBillBaseEntryInfo entryInfo = null;
            for (int dex = 0; dex < entryColls.size(); ++dex) {
                entryInfo = (HRBillBaseEntryInfo)entryColls.getObject(dex);
                this._processData(ctx, settingInfo, relInfo, billBaseInfo, entryInfo, boEntityInfo);
            }
        } else {
            this._processData(ctx, settingInfo, relInfo, billBaseInfo, null, boEntityInfo);
        }
        return null;
    }

    protected void _processData(Context ctx, EContractSignSolutionSettingInfo settingInfo, EContractTemplateRelInfo relInfo, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo entryInfo, EntityObjectInfo boEntityInfo) throws BOSException, EASBizException {
        EContractSignInfo signInfo = this.copySaveInfoToSign(ctx, settingInfo, billBaseInfo, entryInfo, boEntityInfo);
        EContractTemplateInfo templateInfo = settingInfo.getEContractTemplate();
        Map<String, Object> eContract = this.createEContract(ctx, signInfo, templateInfo, relInfo, billBaseInfo, entryInfo);
        Map<String, Object> downloadContract = this.downloadContract(ctx, signInfo, eContract);
        SHRAttachmentExtInfo extInfo = this.saveAttachment(ctx, signInfo, eContract, downloadContract);
        this.syncInfoToCloudService(ctx, signInfo, extInfo, eContract, downloadContract);
        HashMap param = new HashMap();
        try {
            this.sendSignMsg(ctx, signInfo, param);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public String processSignUrl(Context ctx, EContractSignInfo signInfo, Map param) throws EASBizException, BOSException {
        StringBuffer url = new StringBuffer(PropertyReader.getProperty(ctx, "econtract.sign.lightapp.base.url"));
        url.append("&contractNo=").append(signInfo.getContractNo());
        url.append("&serviceId=").append(EContractSignControllerBean.getTSPServerInfo(ctx).get("service_id"));
        PersonInfo personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(signInfo.getPerson().getId()));
        url.append("&phone=").append(personInfo.getCell());
        return url.toString();
    }

    public Object sendSignMsg(Context ctx, EContractSignInfo signInfo, Map param) throws BOSException, EASBizException {
        TaskMessageLogInfo messageLog = new TaskMessageLogInfo();
        try {
            String billId = signInfo.getId().toString();
            String personId = signInfo.getPerson().getId().toString();
            String url = this.processSignUrl(ctx, signInfo, param);
            String property = PropertyReader.getProperty(ctx, "econtract.sign.msg.text");
            String messageText = MessageFormat.format(property, signInfo.getContractNo());
            messageLog.setBusinessId(signInfo.getId());
            messageLog.setTaskId(billId);
            messageLog.setBusinessType("E_CONTRACT_SIGN");
            messageLog.setSendResult(false);
            messageLog.setType(SSCMessageType.CLOUDHUB_PUBS);
            boolean isPrivate = false;
            String pubaccName = "EContractSign";
            String appId = "10036";
            UserCollection userColl = UserFactory.getLocalInstance((Context)ctx).getUserCollection("where person.id = '" + personId + "' AND isDelete = 0 AND isForbidden = 0");
            if (userColl.size() == 1) {
                PersonInfo person = new PersonInfo();
                person.setId(BOSUuid.read((String)personId));
                messageLog.setToUser(userColl.get(0));
                messageLog.setToPerson(person);
                messageLog.setParam(signInfo.getContractNo());
                messageLog.setUrl(url);
                messageLog.setContent(messageText);
                logger.error("EContractSignControllerBean sendSignMsg url : " + url);
                logger.error("EContractSignControllerBean sendSignMsg userId : " + userColl.get(0).getId());
                messageLog.setIsSend(true);
                HttpResultVo result = (HttpResultVo)CloudHubMessageFacadeFactory.getLocalInstance((Context)ctx).sendTextLinkMessageToUser(messageText, appId, url, userColl, pubaccName, isPrivate);
                logger.error("EContractSignControllerBean result : " + result);
                int status = result.getStatus();
                messageLog.setSendResult(true);
                if (status != 200) {
                    messageLog.setSendResult(false);
                    throw new EContractSignException(EContractSignException.PUSH_ERROR);
                }
            } else {
                throw new EContractSignException(EContractSignException.PERSON_INFO_ERROR);
            }
            TaskMessageLogFactory.getLocalInstance(ctx).addnew(messageLog);
        }
        catch (EASBizException e) {
            messageLog.setSendResult(false);
            logger.error(e.getMessage(), (Throwable)e);
            messageLog.setReason(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            messageLog.setSendResult(false);
            logger.error(e.getMessage(), (Throwable)e);
            messageLog.setReason(e.getMessage());
            throw new EContractSignException(EContractSignException.OTHER, new Object[]{e.getMessage()});
        }
        return messageLog;
    }

    public void syncInfoToCloudService(Context ctx, EContractSignInfo signInfo, SHRAttachmentExtInfo extInfo, Map<String, Object> eContract, Map<String, Object> downloadContract) throws BOSException, EASBizException {
        block11: {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            Map<String, String> tspServerInfo = EContractSignControllerBean.getTSPServerInfo(ctx);
            dataMap.put("tenantId", tspServerInfo.get("service_id"));
            dataMap.put("contractNo", signInfo.getContractNo());
            dataMap.put("signPersonId", signInfo.getPerson() != null ? signInfo.getPerson().getId().toString() : signInfo.getPreEntryPerson().toString());
            dataMap.put("signType", signInfo.getEContractTemplate().getSignType().getValue());
            dataMap.put("keyWord", signInfo.getEContractTemplate().getSignKeyWord());
            dataMap.put("personId", signInfo.getApplier().getId().toString());
            String fileDataBase64Str = Base64Utils.encode((byte[])downloadContract.get("filedata"));
            dataMap.put("contractFile", fileDataBase64Str);
            dataMap.put("attachId", extInfo.getAttachment().getId().toString());
            dataMap.put("fileName", downloadContract.get("filename"));
            HttpPost method = null;
            try {
                String hrCloudBaseAddress = CheckHRCloudLicenseUtils.getHRCloudBaseAddress((Context)ctx);
                String url = hrCloudBaseAddress + "/kdcontract/personSingleSign/createContractInfo";
                CloseableHttpClient httpClient = HttpClients.createDefault();
                method = new HttpPost(url);
                StringEntity stringEntity = new StringEntity(JSONObject.toJSONString(dataMap), ContentType.APPLICATION_JSON);
                stringEntity.setContentEncoding((Header)new BasicHeader("Content-Type", "application/json"));
                method.setEntity((HttpEntity)stringEntity);
                HttpResponse response = httpClient.execute((HttpUriRequest)method);
                int statusCode = response.getStatusLine().getStatusCode();
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                if (statusCode == 200) {
                    JSONObject result = JSONObject.parseObject((String)responseString);
                    if (result.getIntValue("errcode") != 0) {
                        throw new EContractSignException(EContractSignException.OTHER, new Object[]{result.getString("description")});
                    }
                    break block11;
                }
                throw new EContractSignException(EContractSignException.OTHER, new Object[]{responseString});
            }
            catch (ClientProtocolException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
    }

    public SHRAttachmentExtInfo saveAttachment(Context ctx, EContractSignInfo signInfo, Map<String, Object> eContract, Map<String, Object> downloadContract) throws BOSException, EASBizException {
        String fullname = (String)downloadContract.get("filename");
        byte[] filedata = (byte[])downloadContract.get("filedata");
        String boID = signInfo.getId().toString();
        fullname = this.checkScriptAttack(fullname);
        String mainname = fullname.substring(0, fullname.lastIndexOf(46));
        String extname = fullname.substring(fullname.lastIndexOf(46) + 1, fullname.length());
        extname = extname.toLowerCase();
        SHRAttachmentExtInfo attchExt = new SHRAttachmentExtInfo();
        AttachmentCheckUtils.checkFileType(ctx, fullname, filedata);
        AttachmentInfo ai = new AttachmentInfo();
        BoAttchAssoInfo boAttchAssoInfo = new BoAttchAssoInfo();
        ai.setName(mainname);
        ai.setSimpleName(extname);
        ai.setDescription("");
        ai.setFile(filedata);
        ai.setIsShared(false);
        String label61 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label61", (Context)ctx);
        ai.setSharedDesc(label61);
        int size = filedata.length;
        if (size < 1024) {
            String label63 = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource", (String)"label63", (Context)ctx);
            ai.setSize(size + label63);
        } else {
            ai.setSize(size / 1024 + "KB");
        }
        ai.setSizeInByte(size);
        ai.setAttachID("" + System.currentTimeMillis());
        ai.setType(SHRServerResource.getString((String)"com.kingdee.shr.shareservice.ShrShareServiceResource880", (String)"label0", (Context)ctx));
        attchExt.setAttachment(ai);
        attchExt.setName(fullname);
        attchExt.setPropertyName("contractNo");
        attchExt.setType(AttachmentTypeEnum.PROPERTY);
        attchExt.setState(AttachmentState.SAVE);
        attchExt.setBoID(boID);
        boAttchAssoInfo.setBoID(boID);
        boAttchAssoInfo.setAssoBusObjType(String.valueOf(BOSUuid.getBOSObjectType((String)boID, (boolean)true)));
        boAttchAssoInfo.setAssoType("Added Accessories");
        boAttchAssoInfo.setAttachment(ai);
        try {
            IAttachment attachment = AttachmentFactory.getLocalInstance((Context)ctx);
            IBoAttchAsso attchAsso = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            ISHRAttachmentExt shrAttchExt = SHRAttachmentExtFactory.getLocalInstance((Context)ctx);
            attachment.addnew(ai);
            attchAsso.addnew(boAttchAssoInfo);
            shrAttchExt.addnew((CoreBaseInfo)attchExt);
            return attchExt;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new EContractSignException(EContractSignException.UPLOAD_FAIL_REASON);
        }
    }

    protected Map<String, Object> createEContract(Context ctx, EContractSignInfo signInfo, EContractTemplateInfo templateInfo, EContractTemplateRelInfo relInfo, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo entryInfo) throws BOSException, EASBizException {
        String templateId = relInfo.getTemplateId();
        ArrayList<String> templateIds = new ArrayList<String>();
        templateIds.add(templateId);
        ArrayList<Map<String, String>> osfContractDataList = new ArrayList<Map<String, String>>();
        Map<String, String> osfContractData = this.assembleContractInfoData(ctx, templateInfo, billBaseInfo, entryInfo, relInfo);
        osfContractDataList.add(osfContractData);
        Map<String, Object> dataMap = this.packageOsfParams(templateIds, signInfo.getContractNo(), osfContractDataList);
        dataMap.put("billId", signInfo.getId().toString());
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        Object result = osfServiceFacade.processService("electronicLaborContractCreateService", dataMap);
        HashMap resultMap = JSONUtils.convertJsonToObject((String)result.toString());
        int returnCode = ((Double)resultMap.get("code")).intValue();
        if (returnCode != 0) {
            throw new EContractSignException(EContractSignException.CREATE_ECOTRACT_ERROR, new Object[]{returnCode, resultMap.get("msg").toString()});
        }
        return dataMap;
    }

    protected Map<String, Object> downloadContract(Context ctx, EContractSignInfo signInfo, Map<String, Object> contractData) throws BOSException, EASBizException {
        byte[] byteData = null;
        String filename = null;
        HashMap<String, String> dataMap = new HashMap<String, String>();
        String contractNo = (String)contractData.get("contractNo");
        dataMap.put("isDefault", "1");
        dataMap.put("contractNo", contractNo);
        IMSFServiceFacade osfServiceFacade = MSFServiceFacadeFactory.getLocalInstance((Context)ctx);
        JSONObject result = (JSONObject)osfServiceFacade.processService("electronicLaborRefreshLocalService", dataMap);
        int resultCode = result.getIntValue("code");
        if (resultCode == 0) {
            JSONArray resultData = result.getJSONArray("data");
            if (resultData.size() > 0) {
                JSONObject nosealInfo = resultData.getJSONObject(0).getJSONObject("nosealInfo");
                String downloadUrl = nosealInfo.getString("downloadUrl");
                InputStream inputStream = null;
                try {
                    URL httpUrl = new URL(downloadUrl);
                    HttpURLConnection conn = (HttpURLConnection)httpUrl.openConnection();
                    conn.setConnectTimeout(10000);
                    inputStream = conn.getInputStream();
                    byteData = EContractSignControllerBean.readInputStream(inputStream);
                    filename = contractNo + ".pdf";
                }
                catch (MalformedURLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new EContractSignException(EContractSignException.OTHER, new Object[]{e.getMessage()});
                }
                catch (UnsupportedEncodingException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new EContractSignException(EContractSignException.OTHER, new Object[]{e.getMessage()});
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    throw new EContractSignException(EContractSignException.OTHER, new Object[]{e.getMessage()});
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            }
            HashMap<String, Object> returnData = new HashMap<String, Object>();
            returnData.put("filename", filename);
            returnData.put("filedata", byteData);
            return returnData;
        }
        throw new EContractSignException(EContractSignException.OTHER, new Object[]{""});
    }

    public static byte[] readInputStream(InputStream inputStream) throws BOSException, EASBizException {
        byte[] buffer = new byte[1024];
        int len = 0;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            while ((len = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new EContractSignException(EContractSignException.CREATE_ECOTRACT_ERROR, new Object[]{e.getMessage()});
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return bos.toByteArray();
    }

    public Map<String, String> assembleContractInfoData(Context ctx, EContractTemplateInfo templateInfo, HRBillBaseInfo billInfo, HRBillBaseEntryInfo entryInfo, EContractTemplateRelInfo relInfo) throws BOSException, EASBizException {
        HashMap<String, String> infoMap = new HashMap<String, String>();
        JSONArray configList = new JSONArray();
        if (StringUtils.isEmpty((String)relInfo.getKeys()) || StringUtils.isEmpty((String)relInfo.getConfig())) {
            throw new EContractSignException(EContractSignException.E_TEMPLATE_IS_NOT_MATCH);
        }
        String config = relInfo.getConfig();
        configList = JSONArray.parseArray((String)config);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("selectorFields", configList);
        FilterInfo filterItems = new FilterInfo();
        filterItems.getFilterItems().add(new FilterItemInfo("id", (Object)billInfo.getId().toString()));
        if (entryInfo != null) {
            filterItems.getFilterItems().add(new FilterItemInfo("entrys.id", (Object)entryInfo.getId().toString()));
        }
        try {
            Map<String, Object> queryParam = EContractSignControllerBean.getBizQueryParam(ctx, params, templateInfo.getDataSource(), filterItems);
            List bizDataList = SHRCommonFacadeFactory.getLocalInstance((Context)ctx).queryAallData(queryParam);
            Map fieldsMppingBusiness = (Map)queryParam.get("fieldsMppingBusiness");
            if (bizDataList != null && bizDataList.size() > 0) {
                Map bizDataMap = (Map)bizDataList.get(0);
                for (int i = 0; i < configList.size(); ++i) {
                    JSONObject config2 = configList.getJSONObject(i);
                    String key = config2.getString("key");
                    String metaField = config2.getString("metafield");
                    String metaFieldSqlKey = null;
                    metaFieldSqlKey = metaField.length() > 30 ? (String)fieldsMppingBusiness.get(metaField) : metaField;
                    Object metaFieldValue = bizDataMap.get(metaFieldSqlKey);
                    if (metaFieldValue != null) {
                        infoMap.put(key, metaFieldValue.toString());
                        continue;
                    }
                    infoMap.put(key, "");
                }
                return infoMap;
            }
            Set<Map.Entry<String, Object>> entrySet = queryParam.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
            }
            throw new BOSException("assembleContractInfoData Data ERROR\uff01");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, Object> getBizQueryParam(Context ctx, Map<String, Object> params, String queryName, FilterInfo filterItems) throws EASBizException, BOSException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        try {
            MetaDataPK queryPK = MetaDataPK.create((String)queryName);
            JSONArray selector = (JSONArray)params.get("selectorFields");
            SelectorInfo selectorRec = null;
            IQueryExecutor exec = ElectronicTemplateSqlUtils.getQueryExecutor((Context)ctx, (String)queryName);
            EntityViewInfo entityViewInfo = ElectronicTemplateSqlUtils.getEntityViewInfo((JSONArray)selector, (FilterInfo)filterItems);
            exec.setObjectView(entityViewInfo);
            boolean isSQLServerDB = "MS SQL Server".equalsIgnoreCase(ContextUtil.getDbType((Context)ctx));
            selectorRec = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getQuery((IMetaDataPK)queryPK).getSelector();
            Map result = ElectronicTemplateSqlUtils.initFieldsMpping((EntityViewInfo)exec.getObjectView(), (ArrayList)selectorRec.getFields(), (boolean)isSQLServerDB);
            param.put("cloumnCount", selector.size());
            param.put("selector", selectorRec);
            param.put("sql", exec.getSQL());
            param.put("fieldsMpping", result.get("fieldsMpping"));
            param.put("fieldsMppingBusiness", result.get("fieldsMppingBusiness"));
            param.put("option", exec.option());
        }
        catch (BOSException e) {
            throw e;
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return param;
    }

    protected EContractSignInfo copySaveInfoToSign(Context ctx, EContractSignSolutionSettingInfo settingInfo, HRBillBaseInfo billBaseInfo, HRBillBaseEntryInfo entryInfo, EntityObjectInfo boEntityInfo) throws BOSException, EASBizException {
        EContractSignInfo signInfo = new EContractSignInfo();
        if (entryInfo != null) {
            EntityObjectInfo entryEntityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(entryInfo.getBOSType());
            PropertyCollection entryPropertiesRuntime = entryEntityInfo.getPropertiesRuntime();
            for (int dex = 0; dex < entryPropertiesRuntime.size(); ++dex) {
                PropertyInfo property = entryPropertiesRuntime.get(dex);
                String proName = property.getName();
                if (this.isExcludedField(proName) || entryInfo.get(proName) == null || signInfo.get(proName) != null) continue;
                signInfo.put(proName, entryInfo.get(proName));
            }
        }
        PropertyCollection billPropertiesRuntime = boEntityInfo.getPropertiesRuntime();
        for (int dex = 0; dex < billPropertiesRuntime.size(); ++dex) {
            PropertyInfo property = billPropertiesRuntime.get(dex);
            String proName = property.getName();
            if (this.isExcludedField(proName) || billBaseInfo.get(proName) == null || signInfo.get(proName) != null) continue;
            signInfo.put(proName, billBaseInfo.get(proName));
        }
        signInfo.setEContractTemplate(settingInfo.getEContractTemplate());
        PropertyInfo propertyInfo = boEntityInfo.getPropertyByName("applier");
        if (propertyInfo != null && propertyInfo instanceof LinkPropertyInfo && billBaseInfo.get("applier") != null && billBaseInfo.get("applier") instanceof PersonInfo) {
            Object applierObj = billBaseInfo.get("applier");
            signInfo.setApplier((PersonInfo)applierObj);
        } else {
            signInfo.setApplier(billBaseInfo.getCreator().getPerson());
        }
        if (signInfo.getApplyDate() == null) {
            signInfo.setApplyDate(new Date());
        }
        if (signInfo.getSignDate() == null) {
            signInfo.setSignDate(new Date());
        }
        signInfo.setStatus(EStatus.CREATE);
        signInfo.setSignStatus(ESignStatus.NOT_SIGN);
        signInfo.setBillId(billBaseInfo.getId());
        if (entryInfo != null) {
            signInfo.setEntryId(entryInfo.getId());
        }
        if (signInfo.getPerson() != null) {
            signInfo.setPersonIdStr(signInfo.getPerson().getId().toString());
        } else if (signInfo.getPreEntryPerson() != null) {
            signInfo.setPersonIdStr(signInfo.getPreEntryPerson().getId().toString());
        }
        signInfo.setContractNo(this.generateContractNo(ctx, EContractSignControllerBean.getTSPServerInfo(ctx)));
        IObjectPK pk = EContractSignFactory.getLocalInstance(ctx).save((CoreBaseInfo)signInfo);
        signInfo.setId(BOSUuid.read((String)pk.toString()));
        return signInfo;
    }

    protected EContractSignSolutionSettingInfo findSignSolutionSettingInfo(Context ctx, String fullName, String solutionNumber) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billSource.fullName", (Object)fullName));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)StateEnum.enable));
        if (StringUtils.isEmpty((String)solutionNumber)) {
            filter.getFilterItems().add(new FilterItemInfo("billSource.number", (Object)solutionNumber));
        }
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("eContractTemplate.*"));
        view.setSelector(selector);
        EContractSignSolutionSettingCollection settingCollection = EContractSignSolutionSettingFactory.getLocalInstance(ctx).getEContractSignSolutionSettingCollection(view);
        if (settingCollection.size() > 0) {
            return settingCollection.get(0);
        }
        throw new EContractSignException(EContractSignException.SIGN_SOLUTION_NOT_EXIST, new Object[]{fullName, solutionNumber});
    }

    protected boolean isExcludedField(String fieldName) {
        return "id".equalsIgnoreCase(fieldName) || "bill".equalsIgnoreCase(fieldName) || "entrys".equalsIgnoreCase(fieldName) || "applier".equalsIgnoreCase(fieldName) || "CU".equalsIgnoreCase(fieldName) || "creator".equalsIgnoreCase(fieldName) || "createTime".equalsIgnoreCase(fieldName) || "lastUpdateUser".equalsIgnoreCase(fieldName) || "lastUpdateTime".equalsIgnoreCase(fieldName) || "number".equalsIgnoreCase(fieldName) || "name".equalsIgnoreCase(fieldName) || "simpleName".equalsIgnoreCase(fieldName) || "status".equalsIgnoreCase(fieldName) || "signStatus".equalsIgnoreCase(fieldName) || "eContractTemplate".equalsIgnoreCase(fieldName);
    }

    protected HRBillBaseInfo getBillBaseInfo(Context ctx, BOSUuid boId, EntityObjectInfo boEntityInfo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        PropertyInfo propertyInfo = boEntityInfo.getPropertyByNameRuntime("entrys");
        if (propertyInfo != null && propertyInfo instanceof LinkPropertyInfo) {
            selector.add(new SelectorItemInfo("entrys.*"));
        }
        HRBillBaseInfo billBaseInfo = ((IHRBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)boId.getType())).getHRBillBaseInfo((IObjectPK)new ObjectUuidPK(boId), selector);
        return billBaseInfo;
    }

    protected EContractTemplateRelInfo getEContractTemplateRelInfo(Context ctx, EContractTemplateInfo eInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boId", (Object)eInfo.getId().toString()));
        view.setFilter(filter);
        EContractTemplateRelCollection relCollection = EContractTemplateRelFactory.getLocalInstance(ctx).getEContractTemplateRelCollection(view);
        if (relCollection.size() <= 0) {
            throw new EContractSignException(EContractSignException.TEMPLATE_IS_NOT_COMPLETE);
        }
        if (!relCollection.get(0).isIsRegister()) {
            throw new EContractSignException(EContractSignException.TEMPLATE_IS_NOT_COMPLETE);
        }
        return relCollection.get(0);
    }

    public Map<String, Object> packageOsfParams(List<String> templateIds, String contractNo, List<Map<String, String>> osfContractDataList) {
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("contractNo", contractNo);
        dataMap.put("templates", templateIds);
        dataMap.put("templateData", osfContractDataList);
        return dataMap;
    }

    public static Map<String, String> getTSPServerInfo(Context ctx) throws BOSException, EASBizException {
        if (tspServerMap == null) {
            try {
                tspServerMap = TSPServerInstance.getServerInfo((Context)ctx);
            }
            catch (Exception e) {
                tspServerMap = null;
                logger.error(e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return tspServerMap;
    }

    protected String generateContractNo(Context ctx, Map<String, String> tspServerMap) {
        String serviceId = tspServerMap.get("service_id");
        SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssSSSS");
        return "EC_" + serviceId + "_" + DATE_FORMAT.format(new Date());
    }

    private static String getEid(Context ctx) {
        if (StringUtils.isEmpty((String)eid)) {
            try {
                eid = CloudHubUtil.getIntegrationEid((Context)ctx);
            }
            catch (BOSException bOSException) {
                // empty catch block
            }
        }
        return eid;
    }

    protected String checkScriptAttack(String str) {
        if (!StringUtils.isEmpty((String)str)) {
            if (str.contains("<")) {
                str = str.replaceAll("<", "&lt;");
            }
            if (str.contains(">")) {
                str = str.replaceAll(">", "&gt;");
            }
        }
        return str;
    }
}

