/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.dataquery;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.model.ParamValueItem;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.shareservice.dataquery.AbstractSSCBaseDataQueryService;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobTrendDataQueryService
extends AbstractSSCBaseDataQueryService {
    private static final Logger logger = LoggerFactory.getLogger(JobTrendDataQueryService.class);

    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        this.checkUserPermission(ctx);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo.getId().toString();
        paramMap.put("userId", userId);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", userId);
        params.put("roleType", "hEw8bwRNR8qPRPajcUdX4C0WZ4A=");
        paramMap.put("bussAttribute", SSCTaskAppUtil.getSourceDataStr(ctx, "SHRBUSSATTR", params));
        List runParam = param.getRunParam();
        int dateType = this.getDateType(runParam);
        paramMap.put("dateType", dateType);
        JsonObject trendData = SSCTaskAppUtil.operateTaskAll(ctx, "JOBTREND", paramMap);
        if (logger.isDebugEnabled()) {
            logger.debug("\u4efb\u52a1\u8d8b\u52bf=====" + trendData);
        }
        ArrayList resultList = new ArrayList();
        if (trendData.get("dataType") != null && "JsonArray".equals(trendData.get("dataType").getAsString())) {
            JsonArray dataArray = trendData.get("data").getAsJsonArray();
            for (int i = 0; i < dataArray.size(); ++i) {
                JsonObject dataObj = dataArray.get(i).getAsJsonObject();
                HashMap<String, Object> trendDataMap = new HashMap<String, Object>();
                String xAxis = dataObj.get("xAxis").getAsString();
                if (dateType == 2) {
                    trendDataMap.put("xAxis", xAxis);
                } else {
                    String xAxisMutilLang = SHRServerResource.getString((String)"com.kingdee.shr.shareservice.SSCDimension", (String)xAxis, (Context)ctx);
                    trendDataMap.put("xAxis", xAxisMutilLang);
                }
                trendDataMap.put("data2", dataObj.get("data2").isJsonNull() ? 0 : dataObj.get("data2").getAsInt());
                trendDataMap.put("data1", dataObj.get("data1").isJsonNull() ? 0 : dataObj.get("data1").getAsInt());
                trendDataMap.put("data3", Float.valueOf(dataObj.get("data3").isJsonNull() ? 0.0f : dataObj.get("data3").getAsFloat()));
                resultList.add(trendDataMap);
            }
        }
        DataResult dataResult = new DataResult();
        dataResult.setRows(resultList);
        return dataResult;
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        return this.getAllData(ctx, param);
    }

    public int getDateType(List<ParamValueItem> runParam) {
        int dateType = 1;
        if (null == runParam || runParam.isEmpty()) {
            return dateType;
        }
        for (ParamValueItem p : runParam) {
            String v = (String)p.getValue();
            if ("V_THIS_WEEK".equalsIgnoreCase(v)) {
                dateType = 1;
                continue;
            }
            if ("V_THISYEAR_MONTH".equalsIgnoreCase(v)) {
                dateType = 2;
                continue;
            }
            if ("V_THIS_YEAR".equalsIgnoreCase(v)) {
                dateType = 3;
                continue;
            }
            dateType = 1;
        }
        return dateType;
    }
}

