/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.IHRBillBase;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.shr.shareservice.ActivityUipkConfigCollection;
import com.kingdee.shr.shareservice.ActivityUipkConfigFactory;
import com.kingdee.shr.shareservice.ActivityUipkConfigInfo;
import com.kingdee.shr.shareservice.CoActivityJobFactory;
import com.kingdee.shr.shareservice.CoActivityJobInfo;
import com.kingdee.shr.shareservice.SSCActivityException;
import com.kingdee.shr.shareservice.strategy.JobInnerOperation;
import com.kingdee.shr.shareservice.util.SSCTaskAppUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobUtils {
    private static final Logger logger = LoggerFactory.getLogger(JobUtils.class);

    public static JobInnerOperation getUserUrlImpl(Context ctx, String uipk) throws BOSException {
        HashMap map = new HashMap();
        ActivityUipkConfigCollection coll = ActivityUipkConfigFactory.getLocalInstance(ctx).getActivityUipkConfigCollection("where uiView='" + uipk + "'");
        if (coll.size() == 0) {
            return null;
        }
        ActivityUipkConfigInfo info = coll.get(0);
        if (StringUtils.isEmpty((String)info.getImplClass())) {
            return null;
        }
        String assemblePath = info.getImplClass();
        try {
            Object implClass = Class.forName(assemblePath).newInstance();
            if (implClass instanceof JobInnerOperation) {
                return (JobInnerOperation)implClass;
            }
            return null;
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static boolean isBillSubmit(Context ctx, String billId) throws EASBizException, BOSException, UuidException {
        if (MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType()) instanceof IHRBillBase) {
            ICoreBase iCoreBase = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)BOSUuid.read((String)billId).getType());
            CoreBaseInfo coreBaseInfo = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(billId));
            if (coreBaseInfo.get("billState") != null) {
                int billState = (Integer)coreBaseInfo.get("billState");
                return billState != 0;
            }
            return false;
        }
        return false;
    }

    public static String checkJobState(Context ctx, String jobId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)jobId)) {
            throw new SSCActivityException(SSCActivityException.JOB_ID_ERROR);
        }
        String jobPoolingType = null;
        String bosType = BOSUuid.read((String)jobId).getType().toString();
        if ("88451F0D".equals(bosType)) {
            JsonObject jobJo = SSCTaskAppUtil.viewJobDetail(ctx, jobId);
            JsonElement jobPoolingTypeJe = jobJo.get("jobPoolingType");
            if (jobPoolingTypeJe != null && !jobPoolingTypeJe.isJsonNull()) {
                JsonElement jobPoolingTypeValueJe = jobPoolingTypeJe.getAsJsonObject().get("value");
                jobPoolingType = jobPoolingTypeValueJe.getAsString();
            }
        } else if ("DC26015C".equals(bosType)) {
            CoActivityJobInfo jobInfo = CoActivityJobFactory.getLocalInstance(ctx).getCoActivityJobInfo("select jobPoolingType where id = '" + jobId + "'");
            if (null != jobInfo) {
                jobPoolingType = jobInfo.getJobPoolingType().getValue();
            }
        } else {
            throw new SSCActivityException(SSCActivityException.JOB_ID_ERROR);
        }
        return jobPoolingType;
    }
}

