/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.shareservice.RuleOperator;
import com.kingdee.shr.shareservice.ShareServiceException;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleOperatorUtils {
    private static final Logger logger = LoggerFactory.getLogger(RuleOperatorUtils.class);
    public static Map<String, List<RuleOperator>> emunMap = new HashMap<String, List<RuleOperator>>();
    public static final String FILTERITEM_KEY_TIMESTAMPSTARTSTR = "00:00:00";
    public static final String FILTERITEM_KEY_TIMESTAMPENDSTR = "23:59:59";
    public static final String SPACE = " ";
    public static final String DATETIMEFORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATEFORMAT = "yyyy-MM-dd";
    public static final String DATEFORMATYMDHM = "yyyy-MM-dd HH:mm";

    public static List<RuleOperator> getSelectEnumDataByType(String dataType) {
        List<RuleOperator> itemize = RuleOperatorUtils.itemize(dataType);
        return itemize;
    }

    private static List<RuleOperator> itemize(String dataType) {
        ArrayList<RuleOperator> itemize = new ArrayList();
        if ("Boolean".equalsIgnoreCase(dataType)) {
            itemize = emunMap.get("Boolean");
        }
        if (DataType.STRING.getName().equalsIgnoreCase(dataType) || DataType.BYTE.getName().equalsIgnoreCase(dataType) || DataType.BOSUUID.getName().equalsIgnoreCase(dataType) || DataType.UUID.getName().equalsIgnoreCase(dataType) || DataType.CHAR.getName().equalsIgnoreCase(dataType)) {
            itemize = emunMap.get("String");
        }
        if (DataType.DATE.getName().equalsIgnoreCase(dataType) || DataType.TIME.getName().equalsIgnoreCase(dataType) || DataType.TIMESTAMP.getName().equalsIgnoreCase(dataType)) {
            itemize = emunMap.get("Date");
        }
        if (DataType.ENUM.getName().equalsIgnoreCase(dataType) || dataType.endsWith("Enum")) {
            itemize = emunMap.get("Enum");
        }
        if (DataType.INTEGER.getName().equalsIgnoreCase(dataType) || DataType.SHORT.getName().equalsIgnoreCase(dataType) || DataType.LONG.getName().equalsIgnoreCase(dataType) || DataType.DECIMAL.getName().equalsIgnoreCase(dataType) || DataType.FLOAT.getName().equalsIgnoreCase(dataType) || DataType.DOUBLE.getName().equalsIgnoreCase(dataType)) {
            itemize = emunMap.get("Number");
        }
        return itemize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean compare(String dataType, Object actualVal, int operator, Object compareVal) throws Exception {
        String actualValStr;
        String compareValStr;
        logger.info("RuleOperatorUtils.compare[dataType:" + dataType + ";actualVal:" + actualVal + ";operator:" + operator + ";compareVal:" + compareVal + "]");
        boolean result = false;
        if ("Boolean".equalsIgnoreCase(dataType)) {
            String fieldStr = (String)actualVal;
            compareValStr = (String)compareVal;
            result = RuleOperatorUtils.booleanCompare(fieldStr, operator, compareValStr);
        }
        if (DataType.STRING.getName().equalsIgnoreCase(dataType) || DataType.BYTE.getName().equalsIgnoreCase(dataType) || DataType.BOSUUID.getName().equalsIgnoreCase(dataType) || DataType.UUID.getName().equalsIgnoreCase(dataType) || DataType.BYTEARRAY.getName().equalsIgnoreCase(dataType) || DataType.CHAR.getName().equalsIgnoreCase(dataType)) {
            actualValStr = "";
            compareValStr = "";
            if (DataType.BYTEARRAY.getName().equalsIgnoreCase(dataType)) {
                if (null != actualVal && null != compareVal) {
                    actualValStr = Arrays.toString((byte[])actualVal);
                    compareValStr = Arrays.toString((byte[])compareVal);
                } else {
                    if (null != compareVal) return false;
                    if (null != actualVal) return false;
                    if (4 == operator) {
                        return true;
                    }
                }
            } else {
                actualValStr = (String)actualVal;
                compareValStr = (String)compareVal;
            }
            result = RuleOperatorUtils.stringCompare(actualValStr, operator, compareValStr);
        }
        if (DataType.DATE.getName().equalsIgnoreCase(dataType) || DataType.TIME.getName().equalsIgnoreCase(dataType) || DataType.TIMESTAMP.getName().equalsIgnoreCase(dataType)) {
            switch (operator) {
                case 14: {
                    result = null == actualVal || StringUtils.isEmpty((CharSequence)String.valueOf(actualVal));
                    break;
                }
                case 15: {
                    result = null != actualVal && StringUtils.isNotEmpty((CharSequence)String.valueOf(actualVal));
                    break;
                }
                default: {
                    if ((null == compareVal || StringUtils.isEmpty((CharSequence)String.valueOf(compareVal))) && (null == actualVal || StringUtils.isEmpty((CharSequence)String.valueOf(actualVal)))) {
                        if (4 != operator && 3 != operator && 2 != operator) break;
                        result = true;
                        break;
                    }
                    if (null == actualVal || !StringUtils.isNotEmpty((CharSequence)String.valueOf(actualVal))) break;
                    try {
                        Date actualValDate = DateTimeUtils.parseDate((String)String.valueOf(actualVal));
                        Date compareValDate = null;
                        if (8 != operator && 9 != operator && 10 != operator && 11 != operator && 12 != operator && 13 != operator) {
                            compareValDate = DateTimeUtils.parseDate((String)String.valueOf(compareVal));
                        }
                        result = RuleOperatorUtils.dateCompare(actualValDate, operator, compareValDate);
                        break;
                    }
                    catch (ParseException e) {
                        throw new ShareServiceException(ShareServiceException.CUSTOM_EXCEPTION, e);
                    }
                }
            }
        }
        if (DataType.ENUM.getName().equalsIgnoreCase(dataType) || dataType.endsWith("Enum")) {
            actualValStr = (String)actualVal;
            compareValStr = (String)compareVal;
            result = RuleOperatorUtils.enumCompare(actualValStr, operator, compareValStr);
        }
        if (!(DataType.INTEGER.getName().equalsIgnoreCase(dataType) || DataType.SHORT.getName().equalsIgnoreCase(dataType) || DataType.LONG.getName().equalsIgnoreCase(dataType) || DataType.DECIMAL.getName().equalsIgnoreCase(dataType) || DataType.FLOAT.getName().equalsIgnoreCase(dataType))) {
            if (!DataType.DOUBLE.getName().equalsIgnoreCase(dataType)) return result;
        }
        if (null != compareVal && !"".equals(compareVal) && null != actualVal && !"".equals(actualVal)) {
            String compareValStr2 = String.valueOf(compareVal);
            String actualValStr2 = String.valueOf(actualVal);
            return RuleOperatorUtils.numberCompare(dataType, actualValStr2, operator, compareValStr2);
        }
        if ((null == compareVal || "".equals(compareVal)) && (null == actualVal || "".equals(compareVal))) {
            if (4 == operator) return true;
            if (3 == operator) return true;
            if (2 == operator) return true;
            if (14 != operator) return result;
            return true;
        }
        switch (operator) {
            case 14: {
                if (null == actualVal) return true;
                if (!StringUtils.isEmpty((CharSequence)String.valueOf(actualVal))) return false;
                return true;
            }
            case 15: {
                if (null == actualVal) return false;
                if (!StringUtils.isEmpty((CharSequence)String.valueOf(actualVal))) return false;
                return true;
            }
        }
        return result;
    }

    private static boolean stringCompare(String actualVal, int operator, String compareVal) throws EASBizException {
        logger.info("RuleOperatorUtils.stringCompare[actualVal:" + actualVal + ";operator:" + operator + ";compareVal:" + compareVal + "]");
        boolean result = false;
        switch (operator) {
            case 4: {
                RuleOperatorUtils.checkArgument(actualVal, "stringCompare", "actualVal");
                result = actualVal.equalsIgnoreCase(compareVal);
                break;
            }
            case 5: {
                RuleOperatorUtils.checkArgument(actualVal, "stringCompare", "actualVal");
                result = !actualVal.equalsIgnoreCase(compareVal);
                break;
            }
            case 6: {
                RuleOperatorUtils.checkArgument(actualVal, "stringCompare", "actualVal");
                result = actualVal.contains(compareVal);
                break;
            }
            case 7: {
                RuleOperatorUtils.checkArgument(actualVal, "stringCompare", "actualVal");
                result = !actualVal.contains(compareVal);
                break;
            }
            case 14: {
                result = StringUtils.isEmpty((CharSequence)actualVal);
                break;
            }
            case 15: {
                result = StringUtils.isNotEmpty((CharSequence)actualVal);
                break;
            }
        }
        return result;
    }

    private static boolean dateCompare(Date actualVal, int op, Date compareVal) throws EASBizException {
        logger.info("RuleOperatorUtils.dateCompare[actualVal:" + actualVal + ";operator:" + op + ";compareVal:" + compareVal + "]");
        boolean result = false;
        String startDateString = "";
        String endDateString = "";
        Date d0 = new Date();
        int year = DateTimeUtils.getYear((Date)d0);
        int month = DateTimeUtils.getMonth((Date)d0);
        int day = DateTimeUtils.getDay((Date)d0);
        Calendar begin = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        switch (op) {
            case 4: {
                result = DateUtils.isSameDay((Date)actualVal, (Date)compareVal);
                break;
            }
            case 5: {
                result = !DateUtils.isSameDay((Date)actualVal, (Date)compareVal);
                break;
            }
            case 0: {
                result = actualVal.before(compareVal);
                break;
            }
            case 1: {
                result = actualVal.after(compareVal);
                break;
            }
            case 2: {
                result = !actualVal.after(compareVal);
                break;
            }
            case 3: {
                result = !actualVal.before(compareVal);
                break;
            }
            case 8: {
                begin.set(year, month - 1, day, 0, 0, 0);
                end.set(year, month - 1, day, 23, 59, 59);
                startDateString = RuleOperatorUtils.getCustomDateString(begin.getTime(), DATEFORMAT) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
                endDateString = RuleOperatorUtils.getCustomDateString(end.getTime(), DATEFORMAT) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
                Date startDate = RuleOperatorUtils.parseValueToDateTime(startDateString);
                Date endDate = RuleOperatorUtils.parseValueToDateTime(endDateString);
                result = !(!actualVal.equals(startDate) && !actualVal.after(startDate) || !actualVal.before(endDate) && !actualVal.equals(endDate));
                break;
            }
            case 9: {
                end.set(year, month - 1, day, 23, 59, 59);
                endDateString = RuleOperatorUtils.getCustomDateString(end.getTime(), DATEFORMAT) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
                Date endDate = RuleOperatorUtils.parseValueToDateTime(endDateString);
                result = actualVal.after(endDate);
                break;
            }
            case 10: {
                begin.set(year, month - 1, 1, 0, 0, 0);
                end.set(year, month - 1, DateTimeUtils.daysOfMonth((int)year, (int)month), 23, 59, 59);
                startDateString = RuleOperatorUtils.getCustomDateString(begin.getTime(), DATEFORMAT) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
                endDateString = RuleOperatorUtils.getCustomDateString(end.getTime(), DATEFORMAT) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
                Date startDate = RuleOperatorUtils.parseValueToDateTime(startDateString);
                Date endDate = RuleOperatorUtils.parseValueToDateTime(endDateString);
                result = !(!actualVal.equals(startDate) && !actualVal.after(startDate) || !actualVal.before(endDate) && !actualVal.equals(endDate));
                break;
            }
            case 11: {
                end.set(year, month - 1, DateTimeUtils.daysOfMonth((int)year, (int)month), 23, 59, 59);
                endDateString = RuleOperatorUtils.getCustomDateString(end.getTime(), DATEFORMAT) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
                Date endDate = RuleOperatorUtils.parseValueToDateTime(endDateString);
                result = actualVal.after(endDate);
                break;
            }
            case 12: {
                int preMonth = month - 2;
                int daysOfMonth = month - 1;
                if (month == 1) {
                    preMonth = 11;
                    --year;
                    daysOfMonth = 12;
                }
                begin.set(year, preMonth, 1, 0, 0, 0);
                end.set(year, preMonth, DateTimeUtils.daysOfMonth((int)year, (int)daysOfMonth), 23, 59, 59);
                startDateString = RuleOperatorUtils.getCustomDateString(begin.getTime(), DATEFORMAT) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
                endDateString = RuleOperatorUtils.getCustomDateString(end.getTime(), DATEFORMAT) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
                Date startDate = RuleOperatorUtils.parseValueToDateTime(startDateString);
                Date endDate = RuleOperatorUtils.parseValueToDateTime(endDateString);
                result = !(!actualVal.equals(startDate) && !actualVal.after(startDate) || !actualVal.before(endDate) && !actualVal.equals(endDate));
                break;
            }
            case 13: {
                int nextMonth = month + 1;
                if (month == 12) {
                    nextMonth = 1;
                    ++year;
                    month = 0;
                }
                begin.set(year, month, 1, 0, 0, 0);
                end.set(year, month, DateTimeUtils.daysOfMonth((int)year, (int)nextMonth), 23, 59, 59);
                startDateString = RuleOperatorUtils.getCustomDateString(begin.getTime(), DATEFORMAT) + SPACE + FILTERITEM_KEY_TIMESTAMPSTARTSTR;
                endDateString = RuleOperatorUtils.getCustomDateString(end.getTime(), DATEFORMAT) + SPACE + FILTERITEM_KEY_TIMESTAMPENDSTR;
                Date startDate = RuleOperatorUtils.parseValueToDateTime(startDateString);
                Date endDate = RuleOperatorUtils.parseValueToDateTime(endDateString);
                result = !(!actualVal.equals(startDate) && !actualVal.after(startDate) || !actualVal.before(endDate) && !actualVal.equals(endDate));
                break;
            }
            case 14: {
                result = null == actualVal || StringUtils.isEmpty((CharSequence)String.valueOf(actualVal));
                break;
            }
            case 15: {
                result = null != actualVal && StringUtils.isNotEmpty((CharSequence)String.valueOf(actualVal));
                break;
            }
        }
        return result;
    }

    private static String getCustomDateString(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        return dateFormat.format(date);
    }

    private static Date parseValueToDate(Object compareValue) throws EASBizException {
        try {
            return DateTimeUtils.parseDate((String)compareValue.toString(), (String)DATEFORMAT);
        }
        catch (ParseException e) {
            throw new ShareServiceException(ShareServiceException.CUSTOM_EXCEPTION, e);
        }
    }

    private static Date parseValueToDateTime(Object compareValue) throws EASBizException {
        return RuleOperatorUtils.parseValueToDateTime(compareValue, DATETIMEFORMAT);
    }

    private static Date parseValueToDateTime(Object compareValue, String fmt) throws EASBizException {
        try {
            return DateTimeUtils.parseDate((String)compareValue.toString(), (String)fmt);
        }
        catch (ParseException e) {
            throw new ShareServiceException(ShareServiceException.CUSTOM_EXCEPTION, e);
        }
    }

    private static boolean numberCompare(String dataType, String actualVal, int operator, String compareVal) {
        logger.info("RuleOperatorUtils.numberCompare[dataType:" + dataType + ";actualVal:" + actualVal + ";operator:" + operator + ";compareVal:" + compareVal + "]");
        boolean result = false;
        switch (operator) {
            case 4: {
                if (DataType.INTEGER.getName().equalsIgnoreCase(dataType)) {
                    result = Integer.parseInt(actualVal) == Integer.parseInt(compareVal);
                    break;
                }
                if (DataType.SHORT.getName().equalsIgnoreCase(dataType)) {
                    result = Short.parseShort(actualVal) == Short.parseShort(compareVal);
                    break;
                }
                if (DataType.LONG.getName().equalsIgnoreCase(dataType)) {
                    result = Long.parseLong(actualVal) == Long.parseLong(compareVal);
                    break;
                }
                if (DataType.DECIMAL.getName().equalsIgnoreCase(dataType)) {
                    if (null != actualVal && null != compareVal) {
                        BigDecimal bdCompareVal;
                        BigDecimal bdActualVal = new BigDecimal(String.valueOf(actualVal));
                        result = bdActualVal.compareTo(bdCompareVal = new BigDecimal(String.valueOf(compareVal))) == 0;
                        break;
                    }
                    result = false;
                    break;
                }
                if (DataType.FLOAT.getName().equalsIgnoreCase(dataType)) {
                    result = Float.parseFloat(actualVal) == Float.parseFloat(compareVal);
                    break;
                }
                if (DataType.DOUBLE.getName().equalsIgnoreCase(dataType)) {
                    result = Double.parseDouble(actualVal) == Double.parseDouble(compareVal);
                    break;
                }
                result = String.valueOf(actualVal).equalsIgnoreCase(String.valueOf(compareVal));
                break;
            }
            case 5: {
                if (DataType.INTEGER.getName().equalsIgnoreCase(dataType)) {
                    result = Integer.parseInt(actualVal) != Integer.parseInt(compareVal);
                    break;
                }
                if (DataType.SHORT.getName().equalsIgnoreCase(dataType)) {
                    result = Short.parseShort(actualVal) != Short.parseShort(compareVal);
                    break;
                }
                if (DataType.LONG.getName().equalsIgnoreCase(dataType)) {
                    result = Long.parseLong(actualVal) != Long.parseLong(compareVal);
                    break;
                }
                if (DataType.DECIMAL.getName().equalsIgnoreCase(dataType)) {
                    if (null != actualVal && null != compareVal) {
                        BigDecimal bdCompareVal;
                        BigDecimal bdActualVal = new BigDecimal(String.valueOf(actualVal));
                        result = bdActualVal.compareTo(bdCompareVal = new BigDecimal(String.valueOf(compareVal))) != 0;
                        break;
                    }
                    result = false;
                    break;
                }
                if (DataType.FLOAT.getName().equalsIgnoreCase(dataType)) {
                    result = Float.parseFloat(actualVal) != Float.parseFloat(compareVal);
                    break;
                }
                if (DataType.DOUBLE.getName().equalsIgnoreCase(dataType)) {
                    result = Double.parseDouble(actualVal) != Double.parseDouble(compareVal);
                    break;
                }
                result = !String.valueOf(actualVal).equalsIgnoreCase(String.valueOf(compareVal));
                break;
            }
            case 0: {
                if (DataType.INTEGER.getName().equalsIgnoreCase(dataType)) {
                    result = Integer.parseInt(actualVal) < Integer.parseInt(compareVal);
                    break;
                }
                if (DataType.SHORT.getName().equalsIgnoreCase(dataType)) {
                    result = Short.parseShort(actualVal) < Short.parseShort(compareVal);
                    break;
                }
                if (DataType.LONG.getName().equalsIgnoreCase(dataType)) {
                    result = Long.parseLong(actualVal) < Long.parseLong(compareVal);
                    break;
                }
                if (DataType.DECIMAL.getName().equalsIgnoreCase(dataType)) {
                    if (null != actualVal && null != compareVal) {
                        BigDecimal bdCompareVal;
                        BigDecimal bdActualVal = new BigDecimal(String.valueOf(actualVal));
                        result = bdActualVal.compareTo(bdCompareVal = new BigDecimal(String.valueOf(compareVal))) < 0;
                        break;
                    }
                    result = false;
                    break;
                }
                if (DataType.FLOAT.getName().equalsIgnoreCase(dataType)) {
                    result = Float.parseFloat(actualVal) < Float.parseFloat(compareVal);
                    break;
                }
                if (DataType.DOUBLE.getName().equalsIgnoreCase(dataType)) {
                    result = Double.parseDouble(actualVal) < Double.parseDouble(compareVal);
                    break;
                }
                result = false;
                break;
            }
            case 1: {
                if (DataType.INTEGER.getName().equalsIgnoreCase(dataType)) {
                    result = Integer.parseInt(actualVal) > Integer.parseInt(compareVal);
                    break;
                }
                if (DataType.SHORT.getName().equalsIgnoreCase(dataType)) {
                    result = Short.parseShort(actualVal) > Short.parseShort(compareVal);
                    break;
                }
                if (DataType.LONG.getName().equalsIgnoreCase(dataType)) {
                    result = Long.parseLong(actualVal) > Long.parseLong(compareVal);
                    break;
                }
                if (DataType.DECIMAL.getName().equalsIgnoreCase(dataType)) {
                    if (null != actualVal && null != compareVal) {
                        BigDecimal bdCompareVal;
                        BigDecimal bdActualVal = new BigDecimal(String.valueOf(actualVal));
                        result = bdActualVal.compareTo(bdCompareVal = new BigDecimal(String.valueOf(compareVal))) > 0;
                        break;
                    }
                    result = false;
                    break;
                }
                if (DataType.FLOAT.getName().equalsIgnoreCase(dataType)) {
                    result = Float.parseFloat(actualVal) > Float.parseFloat(compareVal);
                    break;
                }
                if (DataType.DOUBLE.getName().equalsIgnoreCase(dataType)) {
                    result = Double.parseDouble(actualVal) > Double.parseDouble(compareVal);
                    break;
                }
                result = false;
                break;
            }
            case 2: {
                if (DataType.INTEGER.getName().equalsIgnoreCase(dataType)) {
                    result = Integer.parseInt(actualVal) <= Integer.parseInt(compareVal);
                    break;
                }
                if (DataType.SHORT.getName().equalsIgnoreCase(dataType)) {
                    result = Short.parseShort(actualVal) <= Short.parseShort(compareVal);
                    break;
                }
                if (DataType.LONG.getName().equalsIgnoreCase(dataType)) {
                    result = Long.parseLong(actualVal) <= Long.parseLong(compareVal);
                    break;
                }
                if (DataType.DECIMAL.getName().equalsIgnoreCase(dataType)) {
                    if (null != actualVal && null != compareVal) {
                        BigDecimal bdCompareVal;
                        BigDecimal bdActualVal = new BigDecimal(String.valueOf(actualVal));
                        result = bdActualVal.compareTo(bdCompareVal = new BigDecimal(String.valueOf(compareVal))) < 1;
                        break;
                    }
                    result = false;
                    break;
                }
                if (DataType.FLOAT.getName().equalsIgnoreCase(dataType)) {
                    result = Float.parseFloat(actualVal) <= Float.parseFloat(compareVal);
                    break;
                }
                if (DataType.DOUBLE.getName().equalsIgnoreCase(dataType)) {
                    result = Double.parseDouble(actualVal) <= Double.parseDouble(compareVal);
                    break;
                }
                result = false;
                break;
            }
            case 3: {
                if (DataType.INTEGER.getName().equalsIgnoreCase(dataType)) {
                    result = Integer.parseInt(actualVal) >= Integer.parseInt(compareVal);
                    break;
                }
                if (DataType.SHORT.getName().equalsIgnoreCase(dataType)) {
                    result = Short.parseShort(actualVal) >= Short.parseShort(compareVal);
                    break;
                }
                if (DataType.LONG.getName().equalsIgnoreCase(dataType)) {
                    result = Long.parseLong(actualVal) >= Long.parseLong(compareVal);
                    break;
                }
                if (DataType.DECIMAL.getName().equalsIgnoreCase(dataType)) {
                    if (null != actualVal && null != compareVal) {
                        BigDecimal bdCompareVal;
                        BigDecimal bdActualVal = new BigDecimal(String.valueOf(actualVal));
                        result = bdActualVal.compareTo(bdCompareVal = new BigDecimal(String.valueOf(compareVal))) > -1;
                        break;
                    }
                    result = false;
                    break;
                }
                if (DataType.FLOAT.getName().equalsIgnoreCase(dataType)) {
                    result = Float.parseFloat(actualVal) >= Float.parseFloat(compareVal);
                    break;
                }
                if (DataType.DOUBLE.getName().equalsIgnoreCase(dataType)) {
                    result = Double.parseDouble(actualVal) >= Double.parseDouble(compareVal);
                    break;
                }
                result = false;
                break;
            }
            case 14: {
                result = null == actualVal || StringUtils.isEmpty((CharSequence)String.valueOf(actualVal));
                break;
            }
            case 15: {
                result = null != actualVal && StringUtils.isEmpty((CharSequence)String.valueOf(actualVal));
                break;
            }
        }
        return result;
    }

    private static boolean enumCompare(String actualVal, int operator, String compareVal) throws EASBizException {
        logger.info("RuleOperatorUtils.enumCompare[actualVal:" + actualVal + ";operator:" + operator + ";compareVal:" + compareVal + "]");
        boolean result = false;
        switch (operator) {
            case 4: {
                RuleOperatorUtils.checkArgument(actualVal, "enumCompare", "actualVal");
                result = actualVal.equalsIgnoreCase(compareVal);
                break;
            }
            case 5: {
                RuleOperatorUtils.checkArgument(actualVal, "enumCompare", "actualVal");
                result = !actualVal.equalsIgnoreCase(compareVal);
                break;
            }
            case 14: {
                result = StringUtils.isEmpty((CharSequence)actualVal);
                break;
            }
            case 15: {
                result = StringUtils.isNotEmpty((CharSequence)actualVal);
                break;
            }
        }
        return result;
    }

    private static boolean booleanCompare(String actualVal, int operator, String compareVal) throws EASBizException {
        logger.info("RuleOperatorUtils.booleanCompare[actualVal:" + actualVal + ";operator:" + operator + ";compareVal:" + compareVal + "]");
        boolean result = false;
        switch (operator) {
            case 4: {
                RuleOperatorUtils.checkArgument(actualVal, "booleanCompare", "actualVal");
                result = actualVal.equalsIgnoreCase(compareVal);
                break;
            }
            case 5: {
                RuleOperatorUtils.checkArgument(actualVal, "booleanCompare", "actualVal");
                result = !actualVal.equalsIgnoreCase(compareVal);
                break;
            }
            case 14: {
                result = StringUtils.isEmpty((CharSequence)actualVal);
                break;
            }
            case 15: {
                result = StringUtils.isNotEmpty((CharSequence)actualVal);
                break;
            }
        }
        return result;
    }

    private static void checkArgument(String actualVal, String method, String field) throws EASBizException {
        if (StringUtils.isEmpty((CharSequence)actualVal)) {
            throw new ShareServiceException(ShareServiceException.ILLEGAL_ARGUMENT_ERROR, new String[]{method, field});
        }
    }

    static {
        ArrayList<RuleOperator> stringEnums = new ArrayList<RuleOperator>();
        stringEnums.add(RuleOperator.EQUALITY);
        stringEnums.add(RuleOperator.INEQUALITY);
        stringEnums.add(RuleOperator.LIKE);
        stringEnums.add(RuleOperator.NOT_LIKE);
        stringEnums.add(RuleOperator.NO_CONTENT);
        stringEnums.add(RuleOperator.HAVE_CONTENT);
        emunMap.put("String", stringEnums);
        ArrayList<RuleOperator> timeStampEnums = new ArrayList<RuleOperator>();
        timeStampEnums.add(RuleOperator.EQUALITY);
        timeStampEnums.add(RuleOperator.INEQUALITY);
        timeStampEnums.add(RuleOperator.LESS_THAN);
        timeStampEnums.add(RuleOperator.GREATER_THAN);
        timeStampEnums.add(RuleOperator.LESS_THAN_OR_EQUAL);
        timeStampEnums.add(RuleOperator.GREATER_THAN_OR_EQUAL);
        timeStampEnums.add(RuleOperator.TODAY);
        timeStampEnums.add(RuleOperator.GREATER_TODAY);
        timeStampEnums.add(RuleOperator.THE_MONTH);
        timeStampEnums.add(RuleOperator.GREATER_THE_MONTH);
        timeStampEnums.add(RuleOperator.LAST_NATURAL_MONTH);
        timeStampEnums.add(RuleOperator.NEXT_MONTH);
        timeStampEnums.add(RuleOperator.NO_CONTENT);
        timeStampEnums.add(RuleOperator.HAVE_CONTENT);
        timeStampEnums.add(RuleOperator.DELAY);
        timeStampEnums.add(RuleOperator.ADVANCE);
        emunMap.put("Date", timeStampEnums);
        ArrayList<RuleOperator> numEnums = new ArrayList<RuleOperator>();
        numEnums.add(RuleOperator.EQUALITY);
        numEnums.add(RuleOperator.INEQUALITY);
        numEnums.add(RuleOperator.LESS_THAN);
        numEnums.add(RuleOperator.GREATER_THAN);
        numEnums.add(RuleOperator.LESS_THAN_OR_EQUAL);
        numEnums.add(RuleOperator.GREATER_THAN_OR_EQUAL);
        numEnums.add(RuleOperator.NO_CONTENT);
        numEnums.add(RuleOperator.HAVE_CONTENT);
        emunMap.put("Number", numEnums);
        ArrayList<RuleOperator> enumEnums = new ArrayList<RuleOperator>();
        enumEnums.add(RuleOperator.EQUALITY);
        enumEnums.add(RuleOperator.INEQUALITY);
        enumEnums.add(RuleOperator.NO_CONTENT);
        enumEnums.add(RuleOperator.HAVE_CONTENT);
        emunMap.put("Enum", enumEnums);
        ArrayList<RuleOperator> booleanEnums = new ArrayList<RuleOperator>();
        booleanEnums.add(RuleOperator.EQUALITY);
        booleanEnums.add(RuleOperator.INEQUALITY);
        booleanEnums.add(RuleOperator.NO_CONTENT);
        booleanEnums.add(RuleOperator.HAVE_CONTENT);
        emunMap.put("Boolean", booleanEnums);
    }
}

