/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.util;

import com.kingdee.shr.shareservice.vo.TaskInterQueryVO;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class XMLUtil {
    private static XMLUtil ins;
    private static ReentrantLock lock;

    public static void main(String[] args) {
        TaskInterQueryVO vo = new TaskInterQueryVO();
        vo.setQueryPK("com.kingdee.eas.base.ssc.app.JobQuery");
        vo.setColumnModel("id,subject,jobState");
        vo.setIncludePager("true");
        vo.setSidx("joblevel.value asc,remainderTime");
        vo.setSord("asc");
        vo.setIsDemandQuery("false");
        vo.setSscNumber("EAS");
        try {
            System.out.println(XMLUtil.getInstance().obj2xml(vo));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private XMLUtil() {
    }

    public static XMLUtil getInstance() {
        if (ins == null) {
            try {
                lock.lock();
                if (ins == null) {
                    ins = new XMLUtil();
                }
            }
            finally {
                lock.unlock();
            }
        }
        return ins;
    }

    public String obj2xml(Object obj) throws Exception {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        StringWriter writer = new StringWriter();
        marshaller.marshal(obj, (Writer)writer);
        return writer.toString().replace("standalone=\"yes\"", "");
    }

    static {
        lock = new ReentrantLock();
    }
}

