/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.shareservice.workdate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.shareservice.workdate.TimeIgnoretDate;
import com.kingdee.shr.shareservice.workdate.WorkCalInfo;
import com.kingdee.shr.shareservice.workdate.WorkTime;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WorkDateUtil {
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.shareservice.workdate.WorkDateUtil");
    public static final String TYPE_INSTANCE_CLIENT = ".instanceClient";
    public static final String TYPE_INSTANCE_NOREST = ".instanceNorest";
    private static Map<String, WorkDateUtil> instanceMap = new HashMap<String, WorkDateUtil>(2);
    private String version = "0";
    private final String type;
    private List<String> workDateList_morning = null;
    private List<String> workDateList_afternoon = null;
    private WorkTime workTimeInfo;
    private DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DateFormat dateOnlyFormat = new SimpleDateFormat("yyyy-MM-dd");

    private WorkDateUtil(Context ctx, String workDateOrgID, boolean norest) throws BOSException {
        this.type = norest ? TYPE_INSTANCE_NOREST : TYPE_INSTANCE_CLIENT;
        this.initInstance(ctx, workDateOrgID, norest);
    }

    private void initInstance(Context ctx, String workDateOrgID, boolean norest) throws BOSException {
        String sqlTw = "select * from T_WorkCalendar w where  w.FOrgUnitID = ? ";
        this.workTimeInfo = new WorkTime();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlTw, (Object[])new Object[]{workDateOrgID});
        try {
            if (rs.next()) {
                this.workTimeInfo.setStartWorkDate(rs.getDate("fstartWorkDate"));
                this.workTimeInfo.setEndWorkDate(rs.getDate("fendWorkDate"));
                this.workTimeInfo.setBeginTimeAM(rs.getString("fbeginTimeAM"));
                this.workTimeInfo.setEndTimeAM(rs.getString("fendTimeAM"));
                this.workTimeInfo.setBeginTimePM(rs.getString("fbeginTimePM"));
                this.workTimeInfo.setEndTimePM(rs.getString("fendTimePM"));
                this.workTimeInfo.setId(rs.getString("fid"));
                this.workTimeInfo.setDefaultWeekend(rs.getString("fDefaultWeekend"));
                this.workTimeInfo.calOneDayWorkTimeMilSec();
                this.version = rs.getString("FVersion");
            } else {
                String orgSql = "select fname_" + ctx.getLocale() + " from T_ORG_BaseUnit where fid = ? ";
                rs = DbUtil.executeQuery((Context)ctx, (String)orgSql, (Object[])new Object[]{workDateOrgID});
                if (rs.next()) {
                    throw new BOSException("\u8bf7\u7ed9\u884c\u653f\u7ec4\u7ec7\u3010" + rs.getString(1) + "\u3011\u914d\u7f6e\u5de5\u4f5c\u65e5\u5386\uff01");
                }
            }
        }
        catch (SQLException e) {
            logger.error("T_WorkCalendar:query exception:" + e.getMessage(), (Throwable)e);
        }
        if (this.workDateList_morning == null) {
            int days = (int)((this.workTimeInfo.getEndWorkDate().getTime() - this.workTimeInfo.getStartWorkDate().getTime()) / 1000L / 3600L / 24L);
            this.workDateList_morning = new ArrayList<String>(days);
            this.workDateList_afternoon = new ArrayList<String>(days);
            HashMap<String, WorkCalInfo> workCalInfoMap = new HashMap<String, WorkCalInfo>();
            String sqlCl = "select we.* from t_workcalendardayentry  we where  we.fworkcanlendarid  = '" + this.workTimeInfo.getId() + "' ";
            try {
                IRowSet rsCl = DbUtil.executeQuery((Context)ctx, (String)sqlCl);
                while (rsCl.next()) {
                    WorkCalInfo workCalInfo = new WorkCalInfo();
                    workCalInfo.setId(rsCl.getString("fid"));
                    workCalInfo.setDateType(rsCl.getInt("fDateType"));
                    workCalInfo.setHolidayName(rsCl.getString("fholidayName"));
                    workCalInfo.setWorkCalendarId(rsCl.getString("fworkcanlendarid"));
                    workCalInfo.setWorkDate(rsCl.getDate("fworkDate"));
                    workCalInfoMap.put(this.dateOnlyFormat.format(workCalInfo.getWorkDate()), workCalInfo);
                }
            }
            catch (SQLException e) {
                logger.error("\u521d\u59cb\u5316\u5de5\u4f5c\u65e5\u5386\u5de5\u5177\u7c7b\u5f02\u5e38!--\u67e5\u8be2t_workcalendardayentry(\u4f11\u606f\u65e5\u6570\u636e)\u5f02\u5e38." + e);
                throw new BOSException("\u521d\u59cb\u5316\u5de5\u4f5c\u65e5\u5386\u5de5\u5177\u7c7b\u5f02\u5e38!--\u67e5\u8be2t_workcalendardayentry(\u4f11\u606f\u65e5\u6570\u636e)\u5f02\u5e38,ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + ";workDateOrgID:" + workDateOrgID);
            }
            Date tmpDate = new Date(this.workTimeInfo.getStartWorkDate().getTime());
            String tempDateStr = this.dateOnlyFormat.format(tmpDate);
            for (int i = 0; i < days; ++i) {
                boolean isWeekend = this.isWeekend(tmpDate);
                WorkCalInfo workCalInfo = (WorkCalInfo)workCalInfoMap.get(tempDateStr);
                if (workCalInfo == null) {
                    if (!isWeekend) {
                        this.workDateList_morning.add(tempDateStr);
                        this.workDateList_afternoon.add(tempDateStr);
                    }
                } else {
                    int dateType = workCalInfo.getDateType();
                    if (dateType == 1) {
                        this.workDateList_morning.add(tempDateStr);
                        this.workDateList_afternoon.add(tempDateStr);
                    } else if (dateType == 4) {
                        this.workDateList_morning.add(tempDateStr);
                    }
                }
                tmpDate = new Date(tmpDate.getTime() + 86400000L);
                tempDateStr = this.dateOnlyFormat.format(tmpDate);
            }
        }
    }

    public static synchronized WorkDateUtil getInstance(Context ctx, String workDateOrgId, boolean norest) throws BOSException {
        String key = ctx.getAIS() + "." + workDateOrgId;
        try {
            key = norest ? key + TYPE_INSTANCE_NOREST : key + TYPE_INSTANCE_CLIENT;
            WorkDateUtil instance = instanceMap.get(key);
            if (instance == null || WorkDateUtil.isBadVersion(ctx, instance, workDateOrgId)) {
                instance = new WorkDateUtil(ctx, workDateOrgId, norest);
                instanceMap.put(key, instance);
            }
            return instance;
        }
        catch (Exception e) {
            logger.error(key + "----" + e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean hasWorkDate(Context ctx, String workDateOrgId) throws EASBizException, BOSException {
        String sqlTw = "select * from T_WorkCalendar w where  w.FOrgUnitID = '" + workDateOrgId + "' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlTw);
        boolean re = false;
        try {
            re = rs.next();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            re = false;
        }
        return re;
    }

    public long calWorkTimeBetweenDays(Date d1, Date d2) {
        long between = 0L;
        String d1Str = this.dateOnlyFormat.format(d1);
        String d2Str = this.dateOnlyFormat.format(d2);
        float f1_morningIndex = this.getIndexFromWorkDateList_morning(d1Str);
        float f2_morningIndex = this.getIndexFromWorkDateList_morning(d2Str);
        float f1_afternoonIndex = this.getIndexFromWorkDateList_afternoon(d1Str);
        float f2_afternoonIndex = this.getIndexFromWorkDateList_afternoon(d2Str);
        int days_morning = new BigDecimal(f2_morningIndex).setScale(0, RoundingMode.CEILING).subtract(new BigDecimal(f1_morningIndex).setScale(0, RoundingMode.CEILING)).intValue();
        between = days_morning * this.workTimeInfo.getMorningWorkTimeMilSec();
        int days_afternoon = new BigDecimal(f2_afternoonIndex).setScale(0, RoundingMode.CEILING).subtract(new BigDecimal(f1_afternoonIndex).setScale(0, RoundingMode.CEILING)).intValue();
        between += (long)days_afternoon * (this.workTimeInfo.getOneDayWorkTimeMilSec() - (long)this.workTimeInfo.getMorningWorkTimeMilSec());
        int d1WorkedTime = this.calWorkedTimeInOneDay(d1);
        between -= (long)d1WorkedTime;
        int d2WorkedTime = this.calWorkedTimeInOneDay(d2);
        return between += (long)d2WorkedTime;
    }

    public int calWorkedTimeInOneDay(Date date) {
        int result = 0;
        String day = this.dateOnlyFormat.format(date);
        TimeIgnoretDate dateTime = new TimeIgnoretDate(date);
        if (this.workDateList_morning.contains(day)) {
            if (dateTime.before(this.workTimeInfo.getEndTimestampAM())) {
                result = dateTime.compareTo(this.workTimeInfo.getStartTimestampAM());
                result = result > 0 ? result : 0;
            } else if (!this.workDateList_afternoon.contains(day)) {
                result = this.workTimeInfo.getMorningWorkTimeMilSec();
            } else {
                int allDayMilSec = (int)this.workTimeInfo.getOneDayWorkTimeMilSec();
                result = this.workTimeInfo.getStartTimestampPM().after(dateTime) ? this.workTimeInfo.getMorningWorkTimeMilSec() : ((result = allDayMilSec - this.workTimeInfo.getEndTimestampPM().compareTo(dateTime)) > allDayMilSec ? allDayMilSec : result);
            }
        }
        return result;
    }

    private float getIndexFromWorkDateList_morning(String date) {
        float result;
        block7: {
            result = -1.0f;
            int index = this.workDateList_morning.indexOf(date);
            if (index == -1) {
                try {
                    Date inputDate = this.dateOnlyFormat.parse(date);
                    Date startDate = this.dateOnlyFormat.parse(this.workDateList_morning.get(0));
                    Date endDate = this.dateOnlyFormat.parse(this.workDateList_morning.get(this.workDateList_morning.size() - 1));
                    if (inputDate.before(startDate)) {
                        result = -0.5f;
                        break block7;
                    }
                    if (inputDate.after(endDate)) {
                        result = (float)this.workDateList_morning.size() - 0.5f;
                        break block7;
                    }
                    inputDate.setTime(inputDate.getTime() + 86400000L);
                    String tempStr = this.dateOnlyFormat.format(inputDate);
                    index = this.workDateList_morning.indexOf(tempStr);
                    while (index == -1) {
                        inputDate.setTime(inputDate.getTime() + 86400000L);
                        tempStr = this.dateOnlyFormat.format(inputDate);
                        index = this.workDateList_morning.indexOf(tempStr);
                    }
                    result = (float)index - 0.5f;
                }
                catch (ParseException e) {
                    logger.error("\u5403\u6389\u5f02\u5e38,\u7ee7\u7eed." + e, (Throwable)e);
                    result = -1.0f;
                }
            } else {
                result = index;
            }
        }
        return result;
    }

    private float getIndexFromWorkDateList_afternoon(String date) {
        float result;
        block7: {
            result = -1.0f;
            int index = this.workDateList_afternoon.indexOf(date);
            if (index == -1) {
                try {
                    Date inputDate = this.dateOnlyFormat.parse(date);
                    Date startDate = this.dateOnlyFormat.parse(this.workDateList_afternoon.get(0));
                    Date endDate = this.dateOnlyFormat.parse(this.workDateList_afternoon.get(this.workDateList_afternoon.size() - 1));
                    if (inputDate.before(startDate)) {
                        result = -0.5f;
                        break block7;
                    }
                    if (inputDate.after(endDate)) {
                        result = (float)this.workDateList_afternoon.size() - 0.5f;
                        break block7;
                    }
                    inputDate.setTime(inputDate.getTime() + 86400000L);
                    String tempStr = this.dateOnlyFormat.format(inputDate);
                    index = this.workDateList_afternoon.indexOf(tempStr);
                    while (index == -1) {
                        inputDate.setTime(inputDate.getTime() + 86400000L);
                        tempStr = this.dateOnlyFormat.format(inputDate);
                        index = this.workDateList_afternoon.indexOf(tempStr);
                    }
                    result = (float)index - 0.5f;
                }
                catch (ParseException e) {
                    logger.error("\u5403\u6389\u5f02\u5e38,\u7ee7\u7eed." + e, (Throwable)e);
                    result = -1.0f;
                }
            } else {
                result = index;
            }
        }
        return result;
    }

    public double getCalWorkTimes(Date d1, Date d2, int timeType) {
        long msecends = this.calWorkTimeBetweenDays(d1, d2);
        BigDecimal b1000 = new BigDecimal(1000);
        BigDecimal b60 = new BigDecimal(60);
        switch (timeType) {
            case 0: {
                return msecends;
            }
            case 1: {
                return new BigDecimal(msecends).divide(b1000).setScale(2, RoundingMode.HALF_UP).doubleValue();
            }
            case 2: {
                return new BigDecimal(msecends).divide(b1000).divide(b60, 2, RoundingMode.HALF_UP).doubleValue();
            }
            case 3: {
                return new BigDecimal(msecends).divide(b1000).divide(b60, 10, RoundingMode.HALF_UP).divide(b60, 2, RoundingMode.HALF_UP).doubleValue();
            }
            case 4: {
                return new BigDecimal(msecends).divide(new BigDecimal(this.workTimeInfo.getOneDayWorkTimeMilSec()), 2, RoundingMode.HALF_UP).doubleValue();
            }
        }
        throw new IllegalArgumentException("\u9519\u8bef\u7684timeType,\u53ea\u652f\u63010,1,2,3,4\u5206\u522b\u5bf9\u5e94ms\u6beb\u79d2,s\u79d2,m\u5206,h\u65f6,d\u5929.\u5f53\u524dtimeType:" + timeType);
    }

    public double getCalWorkTimesWithOutAmRest(Date d1, Date d2, int timeType) {
        return this.getCalWorkTimes(d1, d2, timeType);
    }

    public Boolean isHalfHolidays(Date d) throws BOSException {
        String str = this.dateOnlyFormat.format(d);
        return this.workDateList_morning.contains(str) && !this.workDateList_afternoon.contains(str);
    }

    public Boolean isHolidays(Date d) throws BOSException {
        String str = this.dateOnlyFormat.format(d);
        return !this.workDateList_morning.contains(str);
    }

    public boolean isWeekend(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int dayOfWeek = calendar.get(7);
        return dayOfWeek == 7 || dayOfWeek == 1;
    }

    public boolean isWorkDay(Date date) throws BOSException {
        String str = this.dateOnlyFormat.format(date);
        return this.workDateList_morning.contains(str) && this.workDateList_afternoon.contains(str);
    }

    public boolean isRestDay(Date date) throws BOSException {
        return this.isHolidays(date);
    }

    public Date getHoursLaterWorkDay(Date startDate, double hour) throws BOSException {
        startDate = new Date(startDate.getTime());
        long afterMs = new BigDecimal(hour).multiply(new BigDecimal(3600000)).setScale(0, RoundingMode.HALF_UP).longValue();
        try {
            return this.getLaterWorkDay(startDate, afterMs);
        }
        catch (BOSException e) {
            logger.error("\u5de5\u4f5c\u65e5\u5386\u8ba1\u7b97startDate:" + startDate + ";" + hour + "\u5c0f\u65f6\u540e\u662f\u4ec0\u4e48\u65f6\u95f4,\u51fa\u73b0\u5f02\u5e38." + (Object)((Object)e));
            throw e;
        }
    }

    public Date getLaterWorkDay(Date startDate, long afterMs) throws BOSException {
        startDate = new Date(startDate.getTime());
        try {
            String dateStr = this.dateOnlyFormat.format(startDate);
            float start_index_morning = this.getIndexFromWorkDateList_morning(dateStr);
            int start_index_morning_int = new BigDecimal(start_index_morning).setScale(0, RoundingMode.CEILING).intValue();
            if (start_index_morning - (float)start_index_morning_int != 0.0f) {
                startDate = this.dateOnlyFormat.parse(this.workDateList_morning.get(start_index_morning_int));
                startDate.setTime(startDate.getTime() + (long)this.workTimeInfo.getStartTimestampAM().getTime());
            } else {
                TimeIgnoretDate timeIgnoreDate = new TimeIgnoretDate(startDate);
                if (timeIgnoreDate.compareTo(this.workTimeInfo.getStartTimestampAM()) != 0) {
                    int workedTime = this.calWorkedTimeInOneDay(startDate);
                    startDate = new Date(startDate.getTime() - (long)timeIgnoreDate.getTime() + (long)this.workTimeInfo.getStartTimestampAM().getTime());
                    afterMs += (long)workedTime;
                }
            }
            Date result = null;
            if (afterMs > this.workTimeInfo.getOneDayWorkTimeMilSec()) {
                int workDays;
                int days = new BigDecimal(afterMs).divide(new BigDecimal(this.workTimeInfo.getOneDayWorkTimeMilSec()), 0, RoundingMode.FLOOR).intValue();
                int msecends = (int)(afterMs - this.workTimeInfo.getOneDayWorkTimeMilSec() * (long)days);
                int end_index_morning_int = start_index_morning_int + days;
                Date oneDayBeforeEndDate = this.dateOnlyFormat.parse(this.workDateList_morning.get(end_index_morning_int - 1));
                int workAndHalfDays = this.getCalWorkAndHalfDays(startDate, oneDayBeforeEndDate);
                int halfDays = workAndHalfDays - (workDays = this.getCalWorkDays(startDate, oneDayBeforeEndDate));
                if (halfDays > 0) {
                    long lessTimeMs = (long)halfDays * (this.workTimeInfo.getOneDayWorkTimeMilSec() - (long)this.workTimeInfo.getMorningWorkTimeMilSec());
                    msecends = (int)((long)msecends + lessTimeMs);
                }
                startDate = this.dateOnlyFormat.parse(this.workDateList_morning.get(end_index_morning_int));
                startDate.setTime(startDate.getTime() + (long)this.workTimeInfo.getStartTimestampAM().getTime());
                return this.getLaterWorkDay(startDate, msecends);
            }
            if (afterMs > (long)this.workTimeInfo.getMorningWorkTimeMilSec()) {
                if (this.isHalfHolidays(startDate).booleanValue()) {
                    do {
                        startDate = this.dateOnlyFormat.parse(this.workDateList_morning.get(++start_index_morning_int));
                        startDate.setTime(startDate.getTime() + (long)this.workTimeInfo.getStartTimestampAM().getTime());
                    } while (!this.isHalfHolidays(startDate).booleanValue() || (afterMs -= (long)this.workTimeInfo.getMorningWorkTimeMilSec()) <= (long)this.workTimeInfo.getMorningWorkTimeMilSec());
                    result = afterMs > (long)this.workTimeInfo.getMorningWorkTimeMilSec() ? new Date(startDate.getTime() + afterMs + this.workTimeInfo.getNoonRestTimeMilSec()) : new Date(startDate.getTime() + afterMs);
                } else {
                    result = new Date(startDate.getTime() + afterMs + this.workTimeInfo.getNoonRestTimeMilSec());
                }
            } else {
                result = new Date(startDate.getTime() + afterMs);
            }
            return result;
        }
        catch (Exception e) {
            logger.error("\u5de5\u4f5c\u65e5\u5386\u8ba1\u7b97startDate:" + startDate + ";" + afterMs + "\u6beb\u79d2\u540e\u662f\u4ec0\u4e48\u65f6\u95f4,\u51fa\u73b0\u5f02\u5e38." + e);
            throw new BOSException((Throwable)e);
        }
    }

    public String getDate(Date date, int day) {
        if (day == 0) {
            return this.dateOnlyFormat.format(date);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        Date date2 = calendar.getTime();
        double d = this.getCalWorkTimes(date, date2, 4);
        return this.getDate(date2, (int)((double)day - d));
    }

    public String getFullDate(Date date, int day) {
        if (day == 0) {
            return this.df.format(date);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        Date date2 = calendar.getTime();
        double d = this.getCalWorkTimes(date, date2, 4);
        return this.getFullDate(date2, (int)((double)day - d));
    }

    public int getCalWorkAndHalfDays(Date d1, Date d2) throws BOSException {
        if (d1.compareTo(d2) <= 0) {
            String d1Str = this.dateOnlyFormat.format(d1);
            String d2Str = this.dateOnlyFormat.format(d2);
            float f1_morningIndex = this.getIndexFromWorkDateList_morning(d1Str);
            float f2_morningIndex = this.getIndexFromWorkDateList_morning(d2Str);
            int result = new BigDecimal(f2_morningIndex - f1_morningIndex).setScale(0, RoundingMode.UP).intValue();
            if (f1_morningIndex - (float)((int)f1_morningIndex) == 0.0f && f2_morningIndex - (float)((int)f2_morningIndex) == 0.0f) {
                ++result;
            }
            return result;
        }
        return -this.getCalWorkAndHalfDays(d2, d1);
    }

    public int getCalWorkDays(Date d1, Date d2) throws BOSException {
        if (d1.compareTo(d2) <= 0) {
            String d1Str = this.dateOnlyFormat.format(d1);
            String d2Str = this.dateOnlyFormat.format(d2);
            float f1_afternoonIndex = this.getIndexFromWorkDateList_afternoon(d1Str);
            float f2_afternoonIndex = this.getIndexFromWorkDateList_afternoon(d2Str);
            int result = new BigDecimal(f2_afternoonIndex - f1_afternoonIndex).setScale(0, RoundingMode.UP).intValue();
            if (f1_afternoonIndex - (float)((int)f1_afternoonIndex) == 0.0f && f2_afternoonIndex - (float)((int)f2_afternoonIndex) == 0.0f) {
                ++result;
            }
            return result;
        }
        return -this.getCalWorkDays(d2, d1);
    }

    public Boolean isWorkTime(Date date) {
        if (this.calWorkedTimeInOneDay(date) <= 0) {
            return false;
        }
        String day = this.dateOnlyFormat.format(date);
        TimeIgnoretDate dateTime = new TimeIgnoretDate(date);
        if (this.workDateList_morning.contains(day) && dateTime.before(this.workTimeInfo.getEndTimestampAM()) && dateTime.after(this.workTimeInfo.getStartTimestampAM())) {
            return true;
        }
        if (this.workDateList_afternoon.contains(day) && dateTime.after(this.workTimeInfo.getStartTimestampPM()) && dateTime.before(this.workTimeInfo.getEndTimestampPM())) {
            return true;
        }
        return false;
    }

    public void setWorkTimeInfo(WorkTime workTimeInfo) {
        this.workTimeInfo = workTimeInfo;
    }

    public WorkTime getWorkTimeInfo() {
        return this.workTimeInfo;
    }

    private static boolean isBadVersion(Context ctx, WorkDateUtil instance, String workDateOrgID) throws BOSException {
        String sql = "select FVersion from T_WorkCalendar w where  w.FOrgUnitID = '" + workDateOrgID + "' ";
        try {
            String nowVersion = null;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                nowVersion = rs.getString(1);
            }
            if (instance.version == nowVersion) {
                return true;
            }
            if (instance.version == null || nowVersion == null) {
                return false;
            }
            return instance.version.compareTo(nowVersion) < 0;
        }
        catch (Exception e) {
            throw new BOSException("\u83b7\u53d6\u5de5\u4f5c\u65e5\u5386\u5de5\u5177\u7c7b\u5b9e\u4f8b\u5f02\u5e38,\u5224\u65ad\u9759\u6001\u7f13\u5b58\u5b9e\u4f8b\u662f\u5426\u8fc7\u671f\u5f02\u5e38!,ctx:" + ctx.getAIS() + ";" + ctx.getCaller() + "instance.workDateOrgID:" + workDateOrgID);
        }
    }
}

