/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ssccompensation.app.common;

import com.google.common.collect.Lists;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ssccompensation.app.common.AdminOrgUnitVO;
import com.kingdee.shr.ssccompensation.app.common.CommonConstant;
import com.kingdee.shr.ssccompensation.app.wizard.DistributeStatusEnum;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CommonUtils {
    public static boolean isIncluded(AdminOrgUnitInfo adminOrgUnit, List<AdminOrgUnitVO> list) {
        if (null == list || list.isEmpty()) {
            return false;
        }
        String personAdminOrgLongNumber = adminOrgUnit.getLongNumber();
        ArrayList numbers = Lists.newArrayList((Object[])personAdminOrgLongNumber.split("!"));
        String personAdminOrgNumber = adminOrgUnit.getNumber();
        for (AdminOrgUnitVO vo : list) {
            String number = vo.getAdminOrgUnitInfo().getNumber();
            if (personAdminOrgNumber.equals(number) || !vo.isDownward() || !numbers.contains(number)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDistributedData(List<String> childIds, Map<String, DistributeStatusEnum> adminOrgDistribution) {
        if (null == childIds || childIds.isEmpty()) {
            return false;
        }
        for (String adminId : childIds) {
            if (adminOrgDistribution.get(adminId) != DistributeStatusEnum.DISTRIBUTED) continue;
            return true;
        }
        return false;
    }

    public static String getCoreBaseObjectId(CoreBaseInfo coreBaseInfo) {
        if (null == coreBaseInfo) {
            return null;
        }
        if (null == coreBaseInfo.getId()) {
            return null;
        }
        return coreBaseInfo.getId().toString();
    }

    public static List<String> getChildAdminIds(AdminOrgUnitInfo adminOrgUnit, List<AdminOrgUnitVO> list) {
        ArrayList<String> ids = new ArrayList<String>();
        if (null == list || list.isEmpty()) {
            return ids;
        }
        String adminNumber = adminOrgUnit.getNumber();
        for (AdminOrgUnitVO vo : list) {
            ArrayList numbers;
            String number = vo.getAdminOrgUnitInfo().getNumber();
            if (adminNumber.equals(number) || !(numbers = Lists.newArrayList((Object[])vo.getAdminOrgUnitInfo().getLongNumber().split("!"))).contains(adminNumber)) continue;
            ids.add(vo.getAdminOrgUnitInfo().getId().toString());
        }
        return ids;
    }

    public static boolean isFillingActivity(Context ctx, String activityId) {
        CommonUtils.addSSCActivityId(ctx);
        return CommonConstant.FILLING_ACTIVITY_IDS.contains(activityId);
    }

    public static void addSSCActivityId(Context ctx) {
        if (CommonConstant.FILLING_ACTIVITY_IDS.size() == 2) {
            String fillJobSQL = "select FBussAttrId from T_sHR_Activity where fid = '5fkKkXIEToSz9wMDPk5GoIIs15U='";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)fillJobSQL);
                while (rs.next()) {
                    String bussAttrId = rs.getString("FBussAttrId");
                    if (StringUtils.isEmpty((String)bussAttrId)) continue;
                    CommonConstant.FILLING_ACTIVITY_IDS.add(bussAttrId);
                }
            }
            catch (BOSException | SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

