/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ssccompensation.app.trace;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateEntryHelper;
import com.kingdee.shr.compensation.util.integrate.IntegrateEntryTableAttrs;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import com.kingdee.shr.ssccompensation.app.common.CommonUtils;
import com.kingdee.shr.ssccompensation.app.trace.AbstractSubmitBillActivityFacadeControllerBean;
import com.kingdee.shr.ssccompensation.app.trace.SubmitBillActivityFactory;
import com.kingdee.shr.ssccompensation.app.trace.SubmitBillActivityInfo;
import com.kingdee.shr.ssccompensation.app.trace.SubmitBillSyncRecordCollection;
import com.kingdee.shr.ssccompensation.app.trace.SubmitBillSyncRecordFactory;
import com.kingdee.shr.ssccompensation.app.trace.SubmitBillSyncRecordInfo;
import com.kingdee.shr.ssccompensation.exception.SyncActivityException;
import com.kingdee.shr.ssccompensation.utils.ActivityUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SubmitBillActivityFacadeControllerBean
extends AbstractSubmitBillActivityFacadeControllerBean {
    private static Logger logger = Logger.getLogger(SubmitBillActivityFacadeControllerBean.class);
    private static final String SUBMIT_BILL_ACTIVITY_SYNC_LOCK = "submit.bill.activity.sync.lock";
    private static final String SUBMIT_BILL_ACTIVITY_SYNC_LOCK_VAL = "sync";
    private Map<String, IntegrateEntryTableAttrs> tableMap = new HashMap<String, IntegrateEntryTableAttrs>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _sync(Context ctx, List billIds) throws BOSException, EASBizException {
        boolean flag = CmpDistributedLockUtils.tryLock((Context)ctx, (String)SUBMIT_BILL_ACTIVITY_SYNC_LOCK, (String)SUBMIT_BILL_ACTIVITY_SYNC_LOCK_VAL);
        if (!flag) {
            throw new SyncActivityException(SyncActivityException.EXCEPTION0);
        }
        try {
            SubmitBillSyncRecordCollection toSync;
            String oql = "select id, employees, rows, submittedRows, submitBill.id, submitBill.billState, submitBill.submitScheme.id where (isCompleted = 0 or isCompleted = null)";
            if (null != billIds && !billIds.isEmpty()) {
                oql = oql + " and id in (" + CmpStrUtil.convertCollectionToSql((Collection)billIds) + ")";
            }
            if ((toSync = SubmitBillSyncRecordFactory.getLocalInstance(ctx).getSubmitBillSyncRecordCollection(oql)).isEmpty()) {
                return;
            }
            ArrayList<String> submitBillIds = new ArrayList<String>();
            HashMap<String, SubmitBillSyncRecordInfo> submitBill2Record = new HashMap<String, SubmitBillSyncRecordInfo>();
            for (int i = 0; i < toSync.size(); ++i) {
                SubmitBillSyncRecordInfo info = toSync.get(i);
                String submitBillId = CommonUtils.getCoreBaseObjectId((CoreBaseInfo)info.getSubmitBill());
                submitBillIds.add(submitBillId);
                submitBill2Record.put(submitBillId, info);
            }
            List<SubmitBillActivityInfo> activities = ActivityUtils.getActivityBillInfo(ctx, submitBillIds);
            if (activities.isEmpty()) {
                return;
            }
            HashSet<String> billIdSet = new HashSet<String>();
            HashSet<String> completedBills = new HashSet<String>();
            CoreBaseCollection collection = new CoreBaseCollection();
            for (SubmitBillActivityInfo activity : activities) {
                String submitBillId = CommonUtils.getCoreBaseObjectId((CoreBaseInfo)activity.getSubmitBill());
                billIdSet.add(submitBillId);
                activity.setRecord((SubmitBillSyncRecordInfo)submitBill2Record.get(submitBillId));
                collection.add((CoreBaseInfo)activity);
                if (activity.getSubmitBill().getBillState() != HRBillStateEnum.AUDITED) continue;
                completedBills.add(submitBillId);
            }
            this.updateSubmitBillActivities(ctx, billIdSet, collection);
            this.initCODData(ctx, activities);
            this.updateCompleteStatus(ctx, completedBills);
            this.resetCount(ctx, toSync);
        }
        finally {
            CmpDistributedLockUtils.unlock((Context)ctx, (String)SUBMIT_BILL_ACTIVITY_SYNC_LOCK, (String)SUBMIT_BILL_ACTIVITY_SYNC_LOCK_VAL);
        }
    }

    protected void initCODData(Context ctx, List<SubmitBillActivityInfo> activities) throws BOSException {
        ArrayList activityIds = new ArrayList();
        activities.forEach(e -> activityIds.add(CommonUtils.getCoreBaseObjectId((CoreBaseInfo)e)));
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        try {
            String inCondition = cmpInSql.createInSqlBaseOnFId(ctx, activityIds);
            String querySQL = "select act.fid from T_HR_SubmitBillCOD cod, T_HR_SubmitBillActivity act where cod.FSubmitBillId = act.FSubmitBillId and cod.FJobId = act.FJobId and act.fid in " + inCondition;
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySQL);
            ArrayList<String> list = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString("fid"));
            }
            ArrayList toAdd = new ArrayList();
            activities.forEach(e -> {
                String id = CommonUtils.getCoreBaseObjectId((CoreBaseInfo)e);
                if (!list.contains(id) && CommonUtils.isFillingActivity(ctx, e.getActivityId())) {
                    toAdd.add(id);
                }
            });
            if (toAdd.isEmpty()) {
                return;
            }
            inCondition = cmpInSql.createInSqlBaseOnFId(ctx, toAdd);
            String insertSQL = "insert into T_HR_SubmitBillCOD (FJobId, FActivityId, FSubmitBillId, FCODDate, FCreateTime, fid) (select act.FJobId, act.FActivityId, act.FSubmitBillId, rel.FSubmitCOD, NOW(), newBosId('A0AA2BD3') from T_HR_SubmitBillActivity act, T_HR_STerminalSubmitBillRel rel where act.fid in " + inCondition + " and act.FSubmitBillId = rel.FSubmitBillId)";
            DbUtil.execute((Context)ctx, (String)insertSQL);
        }
        catch (BOSException | SQLException e2) {
            throw new BOSException(e2);
        }
        finally {
            cmpInSql.release(ctx);
        }
    }

    @Override
    protected void _backendSync(Context ctx) throws BOSException, EASBizException {
        this._sync(ctx, null);
    }

    protected void resetCount(Context ctx, SubmitBillSyncRecordCollection toSync) throws BOSException {
        HashMap<String, List<SubmitBillSyncRecordInfo>> bills = new HashMap<String, List<SubmitBillSyncRecordInfo>>();
        HashMap<String, List<SubmitBillSyncRecordInfo>> billMap = new HashMap<String, List<SubmitBillSyncRecordInfo>>();
        for (int i = 0; i < toSync.size(); ++i) {
            SubmitBillSyncRecordInfo info = toSync.get(i);
            String schemeId = CommonUtils.getCoreBaseObjectId((CoreBaseInfo)info.getSubmitBill().getSubmitScheme());
            List fixList = bills.computeIfAbsent(schemeId, k -> new ArrayList());
            fixList.add(info);
            if (!this.isUncompleted(info)) continue;
            List list = billMap.computeIfAbsent(schemeId, k -> new ArrayList());
            list.add(info);
        }
        this.updateFixCount(ctx, bills);
        this.updateFilledCount(ctx, billMap);
    }

    protected boolean isUncompleted(SubmitBillSyncRecordInfo info) {
        return info.getSubmitBill().getBillState() == HRBillStateEnum.SAVED || info.getSubmittedRows() == 0;
    }

    protected void updateFilledCount(Context ctx, Map<String, List<SubmitBillSyncRecordInfo>> bills) throws BOSException {
        if (bills.isEmpty()) {
            return;
        }
        Set<String> submitSchemes = bills.keySet();
        Set<String> existedSchemes = this.tableMap.keySet();
        HashSet<String> querySet = new HashSet<String>();
        for (String submitSchemeId : submitSchemes) {
            if (existedSchemes.contains(submitSchemeId)) continue;
            querySet.add(submitSchemeId);
        }
        if (!querySet.isEmpty()) {
            this.tableMap.putAll(CmpIntegrateEntryHelper.getIntegrateEntryTableAttrs((Context)ctx, querySet));
        }
        ArrayList updateParams = new ArrayList();
        ArrayList unfilled = new ArrayList();
        this.tableMap.forEach((key, value) -> {
            List submitBills = (List)bills.get(key);
            Set<String> billIds = this.getBillIds(submitBills);
            String selectSQL = this.getCountSQL((IntegrateEntryTableAttrs)value, billIds);
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
                while (rs.next()) {
                    int cnt = rs.getInt("cnt");
                    String billId = rs.getString("FBillID");
                    Object[] param = new Object[]{cnt, billId};
                    updateParams.add(param);
                    billIds.remove(billId);
                }
            }
            catch (BOSException | SQLException e) {
                logger.error((Object)("executeQuery error for SQL[" + selectSQL + "]: "), e);
            }
            if (!billIds.isEmpty()) {
                unfilled.addAll(billIds);
            }
        });
        if (!unfilled.isEmpty()) {
            unfilled.forEach(e -> {
                Object[] param = new Object[]{0, e};
                updateParams.add(param);
            });
        }
        if (!updateParams.isEmpty()) {
            String updateSQL = "update T_HR_SubmitBillSyncRecord set FSubmittedRows = ? where FSubmitBillId = ?";
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, updateParams);
        }
    }

    protected String getCountSQL(IntegrateEntryTableAttrs tableAttrs, Set<String> billIds) {
        StringBuilder countSQL = new StringBuilder();
        countSQL.append("select count(1) cnt, FBillID from ").append(tableAttrs.getTableName()).append(" where FBillID in (").append(CmpStrUtil.converCollectionToSql(billIds)).append(") and (");
        List columns = tableAttrs.getColNames();
        for (String column : columns) {
            if (columns.indexOf(column) > 0) {
                countSQL.append(" or ");
            }
            countSQL.append(column).append(" is not null ");
        }
        countSQL.append(")").append(" group by FBillID");
        return countSQL.toString();
    }

    protected void updateFixCount(Context ctx, Map<String, List<SubmitBillSyncRecordInfo>> bills) throws BOSException {
        if (bills.isEmpty()) {
            return;
        }
        ArrayList updateParams = new ArrayList();
        this.tableMap = CmpIntegrateEntryHelper.getIntegrateEntryTableAttrs((Context)ctx, bills.keySet());
        this.tableMap.forEach((key, value) -> {
            List submitBills = (List)bills.get(key);
            Set<String> billIds = this.getBillIds(submitBills);
            String tableName = value.getTableName();
            String selectSQL = "select count(1) cnt, count(distinct fPersonId) persons, fBillId from " + tableName + " where fBillId in (" + CmpStrUtil.converCollectionToSql(billIds) + ") group by fBillId";
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
                while (rs.next()) {
                    int rows = rs.getInt("cnt");
                    int persons = rs.getInt("persons");
                    String billId = rs.getString("fBillId");
                    Object[] param = new Object[]{rows, persons, billId};
                    updateParams.add(param);
                }
            }
            catch (BOSException | SQLException e) {
                logger.error((Object)("executeQuery error for SQL[" + selectSQL + "]: "), e);
            }
        });
        if (!updateParams.isEmpty()) {
            String updateSQL = "update T_HR_SubmitBillSyncRecord set FRows = ?, FEmployees = ? where FSubmitBillId = ?";
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, updateParams);
        }
    }

    private Set<String> getBillIds(List<SubmitBillSyncRecordInfo> submitBills) {
        HashSet<String> billIds = new HashSet<String>();
        if (null == submitBills || submitBills.isEmpty()) {
            return billIds;
        }
        for (SubmitBillSyncRecordInfo row : submitBills) {
            billIds.add(CommonUtils.getCoreBaseObjectId((CoreBaseInfo)row.getSubmitBill()));
        }
        return billIds;
    }

    protected void updateSubmitBillActivities(Context ctx, Set<String> billIdSet, CoreBaseCollection collection) throws BOSException {
        String deleteSQL = "delete from T_HR_SubmitBillActivity where FSubmitBillId = ?";
        ArrayList params = new ArrayList();
        billIdSet.forEach(e -> {
            Object[] param = new Object[]{e};
            params.add(param);
        });
        DbUtil.executeBatch((Context)ctx, (String)deleteSQL, params);
        try {
            SubmitBillActivityFactory.getLocalInstance(ctx).saveBatchData(collection);
        }
        catch (EASBizException e2) {
            logger.error((Object)"sync SubmitBillActivity error: ", (Throwable)e2);
            throw new BOSException((Throwable)e2);
        }
    }

    protected void updateCompleteStatus(Context ctx, Set<String> completedBills) throws BOSException {
        if (completedBills.isEmpty()) {
            return;
        }
        ArrayList params = new ArrayList();
        completedBills.forEach(e -> {
            Object[] param = new Object[]{e};
            params.add(param);
        });
        String deleteSQL = "update T_HR_SubmitBillSyncRecord set FIsCompleted = 1 where FSubmitBillId = ?";
        DbUtil.executeBatch((Context)ctx, (String)deleteSQL, params);
    }
}

