/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ssccompensation.app.wizard;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import com.kingdee.shr.ssccompensation.app.distributionRule.DistributionRuleInfo;
import com.kingdee.shr.ssccompensation.app.wizard.AbstractDistributionPeriodControllerBean;
import com.kingdee.shr.ssccompensation.app.wizard.DistributeStatusEnum;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionPeriodCollection;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionPeriodInfo;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class DistributionPeriodControllerBean
extends AbstractDistributionPeriodControllerBean {
    private static final Logger LOG = Logger.getLogger(DistributionPeriodControllerBean.class);

    @Override
    protected DistributionPeriodInfo _create(Context ctx, String distributionRuleId, Date periodDate) throws BOSException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(periodDate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        String oql = "select id, isCompleted, deadline, description, createTime where distributionRule.id = '" + distributionRuleId + "' and isCompleted != " + 100;
        boolean flag = CmpDistributedLockUtils.tryLock((Context)ctx, (String)"ssc.cmp.distribution.wizard.period", (String)distributionRuleId);
        if (!flag) {
            throw new BOSException("System is busy! Please try again later.");
        }
        DistributionPeriodInfo periodInfo = new DistributionPeriodInfo();
        try {
            DistributionPeriodCollection periods = this.getDistributionPeriodCollection(ctx, oql);
            if (!periods.isEmpty()) {
                DistributionPeriodInfo distributionPeriodInfo = periods.get(0);
                return distributionPeriodInfo;
            }
            periodInfo.setId(BOSUuid.create((BOSObjectType)periodInfo.getBOSType()));
            DistributionRuleInfo ruleInfo = new DistributionRuleInfo();
            ruleInfo.setId(BOSUuid.read((String)distributionRuleId));
            periodInfo.setDistributionRule(ruleInfo);
            periodInfo.setYear(year);
            periodInfo.setMonth(month);
            periodInfo.setDay(day);
            periodInfo.setIsCompleted(DistributeStatusEnum.BEGINNING);
            super.save(ctx, (CoreBaseInfo)periodInfo);
            String id = periodInfo.getId().toString();
            String updateSQL = "update T_HR_SDistributionRule set FCurrentPeriodId = ? where fid = ?";
            Object[] param = new Object[]{id, distributionRuleId};
            DbUtil.execute((Context)ctx, (String)updateSQL, (Object[])param);
            DistributionPeriodInfo distributionPeriodInfo = periodInfo;
            return distributionPeriodInfo;
        }
        catch (EASBizException e) {
            LOG.error((Object)"create Distribution Period error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            CmpDistributedLockUtils.unlock((Context)ctx, (String)"ssc.cmp.distribution.wizard.period", (String)distributionRuleId);
        }
    }
}

