/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ssccompensation.app.wizard;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.CmpEmpORelationInfo;
import com.kingdee.shr.compensation.util.SQLHandleUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.compensation.util.lock.CmpDistributedLockUtils;
import com.kingdee.shr.ssccompensation.app.distributionRule.RangeConfigEntryCollection;
import com.kingdee.shr.ssccompensation.app.distributionRule.RangeConfigEntryInfo;
import com.kingdee.shr.ssccompensation.app.distributionRule.SubmitElementCollectionCollection;
import com.kingdee.shr.ssccompensation.app.wizard.AbstractWizardEmployeeRangeControllerBean;
import com.kingdee.shr.ssccompensation.app.wizard.DataSource;
import com.kingdee.shr.ssccompensation.app.wizard.DistributeStatusEnum;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionPeriodFactory;
import com.kingdee.shr.ssccompensation.app.wizard.DistributionPeriodInfo;
import com.kingdee.shr.ssccompensation.app.wizard.IWizardEmployeeRange;
import com.kingdee.shr.ssccompensation.app.wizard.WizardEmployeeRangeCollection;
import com.kingdee.shr.ssccompensation.app.wizard.WizardEmployeeRangeFactory;
import com.kingdee.shr.ssccompensation.app.wizard.WizardEmployeeRangeInfo;
import com.kingdee.shr.ssccompensation.exception.DistributionRuleException;
import com.kingdee.shr.ssccompensation.utils.CmpSscUtil;
import com.kingdee.shr.ssccompensation.utils.SubmitEmployeeRangeHelper;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WizardEmployeeRangeControllerBean
extends AbstractWizardEmployeeRangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.sscCompensation.app.wizard.WizardEmployeeRangeControllerBean");
    private List<String> allTempTable = Lists.newArrayList();

    public IObjectPK save(Context ctx, CoreBaseInfo model) throws BOSException, EASBizException {
        DistributionPeriodInfo info = (DistributionPeriodInfo)model;
        if (info.getId() != null && !StringUtils.isEmpty((String)info.getId().toString())) {
            this.dealUpdate(ctx, info);
            return new ObjectUuidPK(info.getId());
        }
        return null;
    }

    protected void dealUpdate(Context ctx, DistributionPeriodInfo info) throws BOSException {
        String key;
        int i;
        this.beforeUpd(ctx, info);
        WizardEmployeeRangeCollection employeeEntry = info.getEmployeeEntry();
        if (employeeEntry == null || employeeEntry.isEmpty()) {
            return;
        }
        String distributionPeriodId = info.getId().toString();
        CoreBaseCollection insertColl = new CoreBaseCollection();
        CoreBaseCollection updateColl = new CoreBaseCollection();
        WizardEmployeeRangeCollection existColl = WizardEmployeeRangeFactory.getLocalInstance(ctx).getWizardEmployeeRangeCollection("where bill.id = '" + distributionPeriodId + "'");
        HashMap coll2Map = Maps.newHashMap();
        for (i = 0; i < existColl.size(); ++i) {
            WizardEmployeeRangeInfo rInfo = existColl.get(i);
            key = null;
            key = rInfo.getSubmitElement() == null ? rInfo.getCmpEmpORelation().getId().toString() : rInfo.getCmpEmpORelation().getId() + "_" + rInfo.getSubmitElement().getId();
            coll2Map.put(key, rInfo);
        }
        for (i = 0; i < employeeEntry.size(); ++i) {
            WizardEmployeeRangeInfo existInfo;
            WizardEmployeeRangeInfo empInfo = employeeEntry.get(i);
            if (empInfo == null) continue;
            key = empInfo.getString("cmpemporelation.id");
            if (empInfo.getSubmitElement() != null) {
                key = key + "_" + empInfo.getSubmitElement().getId();
            }
            if ((existInfo = (WizardEmployeeRangeInfo)coll2Map.get(key)) != null) continue;
            coll2Map.put(key, empInfo);
            empInfo.setBill(info);
            CmpEmpORelationInfo rel = new CmpEmpORelationInfo();
            rel.setId(BOSUuid.read((String)empInfo.getString("cmpemporelation.id")));
            empInfo.setCmpEmpORelation(rel);
            empInfo.setDataSource(DataSource.MANUAL);
            if (empInfo.getId() != null) {
                if (empInfo.getDistributeStatus() == DistributeStatusEnum.DISTRIBUTED) continue;
                updateColl.add((CoreBaseInfo)empInfo);
                continue;
            }
            empInfo.setDistributeStatus(DistributeStatusEnum.NOT_DISTRIBUTE);
            insertColl.add((CoreBaseInfo)empInfo);
        }
        try {
            IWizardEmployeeRange localInstance = WizardEmployeeRangeFactory.getLocalInstance(ctx);
            localInstance.saveBatchData(insertColl);
            localInstance.updateBatchData(updateColl);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    protected void beforeUpd(Context ctx, DistributionPeriodInfo info) throws BOSException {
        CmpInSql instance = CmpInSqlFactory.getInstance();
        try {
            String removed = (String)info.get("removed");
            if (!StringUtils.isEmpty((String)removed)) {
                String[] removes = removed.split(",");
                String removeSqlIds = instance.createInSqlBaseOnFId(ctx, Arrays.asList(removes));
                String deleteSql = "delete from T_HR_SWizardEmployeeRange where FDistributeStatus = 200 and fid in " + removeSqlIds;
                DbUtil.execute((Context)ctx, (String)deleteSql);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            instance.release(ctx);
        }
    }

    @Override
    protected String _createEmp(Context ctx, Map param) throws BOSException, EASBizException {
        String distributionPeriodId = (String)param.get("distributionPeriodId");
        String permItemId = (String)param.get("permItemId");
        boolean flag = CmpDistributedLockUtils.tryLock((Context)ctx, (String)"ssc.cmp.distribution.wizard.employeeRange.gen", (String)distributionPeriodId);
        if (!flag) {
            throw new DistributionRuleException(DistributionRuleException.EXCEPTION1);
        }
        CmpInSql instance = CmpInSqlFactory.getInstance();
        try {
            List<CoreBaseInfo> adminList = SubmitEmployeeRangeHelper.getAdminList(ctx, distributionPeriodId, "", "period");
            String tempTableName = SubmitEmployeeRangeHelper.getParent2Children(ctx, adminList);
            String oql = "select id, distributionRule.id, distributionRule.hrOrgUnit.id where id = '" + distributionPeriodId + "'";
            DistributionPeriodInfo period = DistributionPeriodFactory.getLocalInstance(ctx).getDistributionPeriodInfo(oql);
            if (period == null || period.getDistributionRule() == null) {
                String string = null;
                return string;
            }
            String distributionRuleId = period.getDistributionRule().getId().toString();
            RangeConfigEntryCollection rangeConfig = SubmitEmployeeRangeHelper.getRangeConfig(ctx, distributionRuleId);
            StringBuilder unionSql = new StringBuilder();
            if (rangeConfig != null && !rangeConfig.isEmpty()) {
                for (int i = 0; rangeConfig != null && i < rangeConfig.size(); ++i) {
                    RangeConfigEntryInfo configInfo = rangeConfig.get(i);
                    if (i > 0) {
                        unionSql.append(" union all ");
                    }
                    unionSql.append(this.getSelectSql(ctx, (CmpInSql<String>)instance, period, tempTableName, configInfo));
                }
            } else {
                unionSql.append(this.getSelectSql(ctx, (CmpInSql<String>)instance, period, tempTableName, null));
            }
            HashMap insertParam = Maps.newHashMap();
            insertParam.put("distributionPeriodId", distributionPeriodId);
            insertParam.put("unionSql", unionSql);
            insertParam.put("permItemId", permItemId);
            boolean isEnableSubmitElement = true;
            if (rangeConfig == null || rangeConfig.isEmpty() || rangeConfig.get(0).getSubmitElementCollection() == null) {
                isEnableSubmitElement = false;
            }
            insertParam.put("isEnableSubmitElement", isEnableSubmitElement);
            this.genEmpData(ctx, insertParam);
            instance.release(ctx);
            for (String tempTable : this.allTempTable) {
                if (StringUtils.isEmpty((String)tempTable)) continue;
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        finally {
            CmpDistributedLockUtils.unlock((Context)ctx, (String)"ssc.cmp.distribution.wizard.employeeRange.gen", (String)distributionPeriodId);
        }
        return null;
    }

    protected void genEmpData(Context ctx, Map param) throws BOSException, EASBizException {
        String distributionPeriodId = (String)param.get("distributionPeriodId");
        StringBuilder unionSql = (StringBuilder)param.get("unionSql");
        String permItemId = (String)param.get("permItemId");
        boolean isEnableSubmitElement = (Boolean)param.get("isEnableSubmitElement");
        String userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        String userAdminRangeSQL = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
        String tempTable = SQLHandleUtil.getTempTable((Context)ctx, (String)userAdminRangeSQL);
        String deleteSql = "delete from T_HR_SWizardEmployeeRange where FDistributeStatus = 200 and FBillID = '" + distributionPeriodId + "'";
        DbUtil.execute((Context)ctx, (String)deleteSql);
        StringBuilder sql2 = new StringBuilder();
        sql2.append("select * from (").append((CharSequence)unionSql).append(") tmp ");
        sql2.append(" where tmp.adminOrgId in (" + tempTable + ") ");
        sql2.append(" order by personId, assignType desc, effectDate desc, leffectDate desc ");
        HashMap filterMap = Maps.newHashMap();
        ArrayList empList = Lists.newArrayList();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql2.toString());
        try {
            while (rs.next()) {
                String key;
                String personId = rs.getString("personId");
                String adminOrgId = rs.getString("adminOrgId");
                String submitElementId = StringUtils.isEmpty((String)rs.getString("submitElementId")) ? null : rs.getString("submitElementId");
                int assignType = rs.getInt("assignType");
                String string = key = isEnableSubmitElement ? personId + "_" + adminOrgId + "_" + submitElementId : personId;
                if ((filterMap.get(key) != null || assignType != 1) && assignType != 0) continue;
                EmployeeRange er = new EmployeeRange();
                er.setDistributionPeriodId(rs.getString("distributionPeriodId"));
                er.setId(rs.getString("ID"));
                er.setCmpEmpORelationID(rs.getString("cmpEmpORelationId"));
                er.setAdminOrgID(rs.getString("adminOrgId"));
                er.setPositionID(rs.getString("positionId"));
                er.setPersonID(rs.getString("personId"));
                er.setSubmitElementID(submitElementId);
                er.setAdminOrgUnitID(rs.getString("adminOrgUnitId"));
                filterMap.put(key, key);
                empList.add(er);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        WizardEmployeeRangeCollection empColl = WizardEmployeeRangeFactory.getLocalInstance(ctx).getWizardEmployeeRangeCollection("where bill.id = '" + distributionPeriodId + "' distributeStatus = " + 150);
        HashMap empRangeMap = Maps.newHashMap();
        for (int i = 0; i < empColl.size(); ++i) {
            WizardEmployeeRangeInfo info = empColl.get(i);
            String cmpEmpORelationId = info.getCmpEmpORelation().getId().toString();
            String submitElementId = info.getSubmitElement() == null ? null : info.getSubmitElement().getId().toString();
            String key = isEnableSubmitElement ? cmpEmpORelationId + "_" + submitElementId : cmpEmpORelationId;
            empRangeMap.put(key, info);
        }
        ArrayList params = Lists.newArrayList();
        for (EmployeeRange value : empList) {
            String cmpEmpORelationId = value.getCmpEmpORelationID();
            String submitElementId = value.getSubmitElementID();
            String key = isEnableSubmitElement ? cmpEmpORelationId + "_" + submitElementId : cmpEmpORelationId;
            if (empRangeMap.get(key) != null) continue;
            params.add(value.getObject());
        }
        if (params.size() > 0) {
            String insertSql = "insert into T_HR_SWizardEmployeeRange  (FBillID, fid, FCmpEmpORelationID, FAdminOrgID, FPositionID, FPersonID, FSubmitElementID, FAdminOrgUnitID, FDataSource, FDistributeStatus)  values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            DbUtil.executeBatch((Context)ctx, (String)insertSql, (List)params);
        }
    }

    protected String getSelectSql(Context ctx, CmpInSql<String> instance, DistributionPeriodInfo period, String tempTableName, RangeConfigEntryInfo configInfo) throws BOSException, ParserException {
        String configStr = null;
        if (configInfo != null) {
            configStr = configInfo.getRangeConfig();
        }
        String hrOrgId = period.getDistributionRule().getHrOrgUnit().getId().toString();
        String adminFilter = "select FID from " + tempTableName;
        String tempTable = SubmitEmployeeRangeHelper.getConfigFilter(ctx, configStr, adminFilter, hrOrgId);
        this.allTempTable.add(tempTable);
        String configFilter = "select * from  " + tempTable;
        SubmitElementCollectionCollection submitColl = null;
        if (configInfo != null) {
            submitColl = configInfo.getSubmitElementCollection();
        }
        List submitList = CmpSscUtil.transColl2Array((IObjectCollection)submitColl, "submitElement.id");
        String distributionPeriodId = period.getId().toString();
        String sql = "select ''" + distributionPeriodId + "'' distributionPeriodId, newbosid(''87CCD8BE'') ID, tableA.fid cmpEmpORelationId, tableA.adminOrgId adminOrgId, tableA.positionId positionId, tableA.personId personId, tableA.assignType assignType, tableA.effectDate effectDate, tableA.leffectDate leffectDate, tableB.fid submitElementId, tableC.FParentId adminOrgUnitId from ({0}) tableA, ({1}) tableB, ({2}) tableC  where tableA.adminOrgId = tableC.FID";
        if (submitList.size() == 0) {
            sql = "select ''" + distributionPeriodId + "'' distributionPeriodId, newbosid(''87CCD8BE'') ID, tableA.fid cmpEmpORelationId, tableA.adminOrgId adminOrgId, tableA.positionId positionId, tableA.personId personId, tableA.assignType assignType, tableA.effectDate effectDate, tableA.leffectDate leffectDate, null submitElementId, tableC.FParentId adminOrgUnitId from ({0}) tableA, ({1}) tableC  where tableA.adminOrgId = tableC.FID";
            return MessageFormat.format(sql, configFilter, "select * from " + tempTableName);
        }
        String submitSql = instance.createInSqlBaseOnFId(ctx, submitList);
        return MessageFormat.format(sql, configFilter, "select fid from T_HR_SSubmitElement where fid in " + submitSql, "select * from " + tempTableName);
    }

    class EmployeeRange {
        private String distributionPeriodId;
        private String id;
        private String cmpEmpORelationID;
        private String adminOrgID;
        private String positionID;
        private String personID;
        private String submitElementID;
        private String adminOrgUnitID;

        EmployeeRange() {
        }

        public String getDistributionPeriodId() {
            return this.distributionPeriodId;
        }

        public void setDistributionPeriodId(String distributionPeriodId) {
            this.distributionPeriodId = distributionPeriodId;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getCmpEmpORelationID() {
            return this.cmpEmpORelationID;
        }

        public void setCmpEmpORelationID(String cmpEmpORelationID) {
            this.cmpEmpORelationID = cmpEmpORelationID;
        }

        public String getAdminOrgID() {
            return this.adminOrgID;
        }

        public void setAdminOrgID(String adminOrgID) {
            this.adminOrgID = adminOrgID;
        }

        public String getPositionID() {
            return this.positionID;
        }

        public void setPositionID(String positionID) {
            this.positionID = positionID;
        }

        public String getPersonID() {
            return this.personID;
        }

        public void setPersonID(String personID) {
            this.personID = personID;
        }

        public String getSubmitElementID() {
            return this.submitElementID;
        }

        public void setSubmitElementID(String submitElementID) {
            this.submitElementID = submitElementID;
        }

        public String getAdminOrgUnitID() {
            return this.adminOrgUnitID;
        }

        public void setAdminOrgUnitID(String adminOrgUnitID) {
            this.adminOrgUnitID = adminOrgUnitID;
        }

        public Object[] getObject() {
            return new Object[]{this.distributionPeriodId, this.id, this.cmpEmpORelationID, this.adminOrgID, this.positionID, this.personID, this.submitElementID, this.adminOrgUnitID, 0, 200};
        }
    }
}

