/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.api.file;

import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.jdom2.Document;
import org.jdom2.output.XMLOutputter;

public class FileOperateHelper {
    private static Logger logger = Logger.getLogger(FileOperateHelper.class);

    private FileOperateHelper() {
    }

    public static String getServerPath() {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(SHRSyssettingUtil.getProfilesPath()).append(File.separator).append(SHRSyssettingUtil.getCurrentLoginServer());
        return sBuffer.toString();
    }

    public static String getDomainsServerPath() {
        StringBuffer sBuffer = new StringBuffer();
        sBuffer.append(System.getProperty("APP_SERVER_HOME")).append(File.separator).append("domains").append(File.separator).append(SHRSyssettingUtil.getCurrentLoginServer());
        return sBuffer.toString();
    }

    public static void saveXML(Document doc, String filePath) {
        try {
            XMLOutputter xmlopt = new XMLOutputter();
            FileWriter writer = new FileWriter(filePath);
            xmlopt.output(doc, (Writer)writer);
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(String filePath, Properties properties) {
        FileOutputStream fos = null;
        try {
            File file = new File(filePath);
            fos = new FileOutputStream(file);
            properties.store(fos, "");
            boolean isChange = file.setLastModified(System.currentTimeMillis());
            if (isChange && logger.isDebugEnabled()) {
                logger.debug((Object)"change fileTime success");
            }
            fos.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (null != fos) {
                    fos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

