/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.api.logSearch;

import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class RuleEngineer {
    private static Logger logger = Logger.getLogger(RuleEngineer.class);
    private static final Map<String, Pattern> patternMap = new HashMap<String, Pattern>();
    private static final String CONFIG_FILE_NAME = "matchRule.properties";
    private static Properties properties = null;

    public static List<Map<String, String>> match(File file, String targetFileName) {
        ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
        Scanner scanner = null;
        try {
            scanner = new Scanner(file);
            int lineNumber = 0;
            while (scanner.hasNextLine()) {
                ++lineNumber;
                String line = scanner.nextLine();
                for (Map.Entry<String, Pattern> entry : patternMap.entrySet()) {
                    Matcher matcher = entry.getValue().matcher(line);
                    while (matcher.find()) {
                        String match = matcher.group();
                        HashMap<String, String> sourcemap = new HashMap<String, String>();
                        String matchInfo = "\u65e5\u5fd7\u6253\u5370\u654f\u611f\u4fe1\u606f" + entry.getKey() + ":" + match;
                        sourcemap.put("matchInfo", matchInfo);
                        if (rows.stream().anyMatch(map -> ((String)map.get("matchInfo")).equals(sourcemap.get("matchInfo")))) continue;
                        sourcemap.put("logLine", String.valueOf(lineNumber));
                        sourcemap.put("logPath", targetFileName);
                        rows.add(sourcemap);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return rows;
    }

    public static boolean match(String s, String targetFileName, List<Map<String, String>> rows) {
        boolean flag = false;
        int line = 1;
        int pos = 0;
        for (Map.Entry<String, Pattern> entry : patternMap.entrySet()) {
            Matcher matcher = entry.getValue().matcher(s);
            while (matcher.find()) {
                flag = true;
                String match = matcher.group();
                int start = matcher.start();
                while (pos < start) {
                    if (s.charAt(pos) == '\n') {
                        ++line;
                    }
                    ++pos;
                }
                HashMap<String, String> map = new HashMap<String, String>();
                String matchInfo = "\u65e5\u5fd7\u6253\u5370\u654f\u611f\u4fe1\u606f" + entry.getKey() + ":" + match;
                map.put("matchInfo", matchInfo);
                map.put("logLine", String.valueOf(line));
                map.put("logPath", targetFileName);
                rows.add(map);
            }
        }
        return flag;
    }

    private static String getConfigPath() {
        StringBuffer sb = new StringBuffer();
        sb.append(SHRSyssettingUtil.getShrPropertiesPath()).append(File.separator).append(CONFIG_FILE_NAME);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String configFile = RuleEngineer.getConfigPath();
        FileInputStream input = null;
        try {
            File file = new File(configFile);
            if (file.exists()) {
                properties = new Properties();
                input = new FileInputStream(configFile);
                InputStreamReader reader = new InputStreamReader((InputStream)input, "UTF-8");
                properties.load(reader);
                for (String key : properties.stringPropertyNames()) {
                    String value = properties.getProperty(key);
                    patternMap.put(key, Pattern.compile(value));
                }
            }
        }
        catch (IOException e) {
            logger.error((Object)"Init params error!");
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.error((Object)"FileInputStream is not closed!");
                }
            }
        }
    }
}

