/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.google.gson.JsonSyntaxException;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.DynamicListSettingCollection;
import com.kingdee.shr.base.syssetting.DynamicListSettingInfo;
import com.kingdee.shr.base.syssetting.DynamicListSettingTypeEnum;
import com.kingdee.shr.base.syssetting.FieldRangeCollection;
import com.kingdee.shr.base.syssetting.FieldRangeFactory;
import com.kingdee.shr.base.syssetting.FieldRangeInfo;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.app.AbstractDynamicListSettingControllerBean;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class DynamicListSettingControllerBean
extends AbstractDynamicListSettingControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.DynamicListSettingControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        DynamicListSettingInfo info = (DynamicListSettingInfo)model;
        this.checkNameDup(ctx, info);
        this.checkConfig(ctx, info);
        if (DynamicListSettingTypeEnum.USER.equals((Object)info.getType())) {
            if (info.getOwner() == null) {
                info.setOwner(ContextUtil.getCurrentUserInfo((Context)ctx));
            }
            if (info.isIsDefault()) {
                this.clearSolutionIsDefault(ctx, info);
            }
        }
        if (info.getState() == null) {
            info.setState(StateEnum.DISABLE);
        }
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    private void checkConfig(Context ctx, DynamicListSettingInfo info) throws EASBizException {
        String config = info.getConfig();
        if (!StringUtils.isEmpty((String)config)) {
            try {
                JSONUtils.convertJsonToObject(ctx, config);
            }
            catch (JsonSyntaxException e) {
                throw new SyssettinException(SyssettinException.JSON_FORMAT_ERROR);
            }
        }
    }

    public void checkNameDup(Context ctx, DataBaseInfo dataBaseInfo) throws BOSException, EASBizException {
        String category;
        DynamicListSettingInfo info = (DynamicListSettingInfo)dataBaseInfo;
        FilterInfo filterInfo = new FilterInfo();
        String id = null;
        if (info.getId() != null) {
            id = info.getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
        filterInfo.getFilterItems().add(new FilterItemInfo("uiview.id", (Object)info.getUiview().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)1));
        if (DynamicListSettingTypeEnum.USER.equals((Object)info.getType())) {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            filterInfo.getFilterItems().add(new FilterItemInfo("owner.id", (Object)userInfo.getId().toString()));
            String maskString = "#0 and #1 and #2 and (#3 or #4)";
            filterInfo.setMaskString(maskString);
        }
        if (!StringUtils.isEmpty((String)(category = info.getCategory()))) {
            FilterInfo categoryFilterInfo = new FilterInfo();
            categoryFilterInfo.getFilterItems().add(new FilterItemInfo("category", (Object)category));
            filterInfo.mergeFilter(categoryFilterInfo, "AND");
        }
        if (this.exists(ctx, filterInfo)) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{info.getName()});
        }
    }

    private void clearSolutionIsDefault(Context ctx, DynamicListSettingInfo info) throws BOSException {
        String category;
        if (DynamicListSettingTypeEnum.SYSTEM.equals((Object)info.getType())) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("update t_bd_dynamicListSetting set FIsDefault = 0 where FUIViewID = ? and FType = ? ");
        if (DynamicListSettingTypeEnum.USER.equals((Object)info.getType())) {
            sb.append(" and FOwnerID = ");
            sb.append("'");
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            sb.append(userInfo.getId().toString());
            sb.append("'");
        }
        if (!StringUtils.isEmpty((String)(category = info.getCategory()))) {
            sb.append(" and FCategory = ");
            sb.append("'");
            sb.append(category);
            sb.append("'");
        }
        Object[] params = new Object[]{info.getUiview().getId().toString(), info.getType().getValue()};
        DbUtil.execute((Context)ctx, (String)sb.toString(), (Object[])params);
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        this.setState(ctx, id, StateEnum.ENABLE);
        this.checkStateData(ctx, id);
    }

    private void checkStateData(Context ctx, String id) throws BOSException, EASBizException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("uiview.id"));
        DynamicListSettingInfo info = this.getDynamicListSettingInfo(ctx, (IObjectPK)new ObjectUuidPK(id), sic);
        this.checkStateData(ctx, info);
    }

    private void checkStateData(Context ctx, DynamicListSettingInfo info) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("uiview.id", (Object)info.getUiview().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("type", (Object)1));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isDefault"));
        viewInfo.setSelector(selector);
        DynamicListSettingCollection collection = this.getDynamicListSettingCollection(ctx, viewInfo);
        int defaultCount = 0;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            if (!collection.get(i).isIsDefault()) continue;
            ++defaultCount;
        }
        if (defaultCount == 0) {
            throw new SyssettinException(SyssettinException.MUST_ENABLE_CASE);
        }
        if (defaultCount > 1) {
            throw new SyssettinException(SyssettinException.ONLY_ENABLE_CASE);
        }
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        this.setState(ctx, id, StateEnum.DISABLE);
    }

    private void setState(Context ctx, String id, StateEnum state) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        this.addEnabledAndDisabled(ctx, id, state);
        DynamicListSettingInfo info = new DynamicListSettingInfo();
        info.setId(BOSUuid.read((String)id));
        info.setState(state);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        this._updatePartial(ctx, (IObjectValue)info, sic);
    }

    private void addEnabledAndDisabled(Context ctx, String id, StateEnum state) throws EASBizException, BOSException, UuidException {
        DynamicListSettingInfo oldModel = this.getDynamicListSettingInfo(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        if (StateEnum.DISABLE.equals((Object)state)) {
            if (StateEnum.ENABLE.equals((Object)oldModel.getState()) && oldModel.isIsDefault()) {
                throw new SyssettinException(SyssettinException.NOT_REDIRECT_FORBID);
            }
        } else if (StateEnum.ENABLE.equals((Object)state) && StateEnum.DISABLE.equals((Object)oldModel.getState()) && oldModel.isIsDefault()) {
            this.changeDefault(ctx, oldModel.getUiview().getId());
        }
    }

    private void changeDefault(Context ctx, BOSUuid uiViewId) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("uiview.id", (Object)uiViewId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
        filterInfo.getFilterItems().add(new FilterItemInfo("state", (Object)1));
        viewInfo.setFilter(filterInfo);
        DynamicListSettingCollection collection = this.getDynamicListSettingCollection(ctx, viewInfo);
        if (null != collection && collection.size() > 0) {
            int total = collection.size();
            for (int i = 0; i < total; ++i) {
                this.setIsDefault(ctx, collection.get(i).getId(), false);
            }
        }
    }

    private void setIsDefault(Context ctx, BOSUuid id, boolean isDefault) throws EASBizException, BOSException {
        DynamicListSettingInfo info = new DynamicListSettingInfo();
        info.setId(id);
        info.setIsDefault(isDefault);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("isDefault"));
        this._updatePartial(ctx, (IObjectValue)info, sic);
    }

    @Override
    protected IObjectPK _copy(Context ctx, String id) throws BOSException, EASBizException {
        DynamicListSettingInfo info = this.getDynamicListSettingInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setId(null);
        info.setName(info.getName() + "_" + SHRSysSettingResourceUtil.getResource("copy", ctx));
        info.setIsDefault(false);
        info.setInner(false);
        info.setState(StateEnum.DISABLE);
        info.setCreateTime(null);
        info.setCreator(null);
        return this._save(ctx, (IObjectValue)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DynamicListSettingInfo info = this.getDynamicListSettingInfo(ctx, pk);
        this.checkCanDelete(info);
        super._delete(ctx, pk);
    }

    private void checkCanDelete(DynamicListSettingInfo info) throws EASBizException {
        if (DynamicListSettingTypeEnum.SYSTEM.equals((Object)info.getType()) && StateEnum.ENABLE.equals((Object)info.getState())) {
            throw new SyssettinException(SyssettinException.FORBID_BEFORE_DELETE);
        }
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        DynamicListSettingCollection collection = this.getDynamicListSettingCollection(ctx, viewInfo);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            this.checkCanDelete(collection.get(i));
        }
        IObjectPK[] pks = super._delete(ctx, filter);
        return pks;
    }

    @Override
    protected void _setisDefault(Context ctx, String id) throws BOSException, EASBizException {
        DynamicListSettingInfo info = this.getDynamicListSettingInfo(ctx, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        if (StateEnum.ENABLE.equals((Object)info.getState())) {
            this.changeDefault(ctx, info.getUiview().getId());
        }
        this.setIsDefault(ctx, BOSUuid.read((String)id), true);
    }

    @Override
    protected Map _updateBatchByStructureChange(Context ctx, List changeContent) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList data = null;
        if (null != changeContent && changeContent.size() > 0) {
            data = new ArrayList();
            int total = changeContent.size();
            for (int i = 0; i < total; ++i) {
                Map changContentMap = (Map)changeContent.get(i);
                HashMap<String, Object> resultData = new HashMap<String, Object>();
                resultData.putAll(changContentMap);
                try {
                    this.updateByStructureChange(ctx, changContentMap);
                    resultData.put("success", true);
                    resultData.put("message", "");
                }
                catch (BOSException e) {
                    resultData.put("success", false);
                    resultData.put("message", e.getMessage());
                }
                catch (EASBizException e) {
                    resultData.put("success", false);
                    resultData.put("message", e.getMessage());
                }
                data.add(resultData);
            }
            result.put("success", true);
            result.put("message", "");
            result.put("data", data);
        } else {
            result.put("success", true);
            result.put("message", SHRSysSettingResourceUtil.getResource("no_data_need_update", ctx));
            result.put("data", changeContent);
        }
        return result;
    }

    private void dealUpdateByStructureChange(Context ctx, DynamicListSettingCollection coll, String sourceField, String targetField, String number) throws EASBizException, BOSException {
        DynamicListSettingCollection updateColl = new DynamicListSettingCollection();
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                DynamicListSettingInfo info = coll.get(i);
                if (StringUtils.isEmpty((String)info.getConfig()) || info.getConfig().indexOf(sourceField) <= 0) continue;
                info.setConfig(info.getConfig().replaceAll(sourceField, targetField));
                updateColl.add(info);
            }
            if (null != updateColl && updateColl.size() > 0) {
                this._updateBatchData(ctx, (IObjectCollection)updateColl);
            }
        }
    }

    private void dealUpdateByStructureChange(Context ctx, FieldRangeCollection coll, String sourceField, String targetField, String number) throws EASBizException, BOSException {
        CoreBaseCollection updateColl = new CoreBaseCollection();
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                FieldRangeInfo info = coll.get(i);
                if (StringUtils.isEmpty((String)info.getConfig()) || info.getConfig().indexOf(sourceField) <= 0) continue;
                info.setConfig(info.getConfig().replaceAll(sourceField, targetField));
                updateColl.add((CoreBaseInfo)info);
            }
            if (null != updateColl && updateColl.size() > 0) {
                FieldRangeFactory.getLocalInstance(ctx).updateBatchData(updateColl);
            }
        }
    }

    @Override
    protected void _updateByStructureChange(Context ctx, Map changeContent) throws BOSException, EASBizException {
        if (null == changeContent || changeContent.size() <= 0) {
            throw new SyssettinException(SyssettinException.MODIFIED_INFO_NOT_NULL);
        }
        String number = (String)changeContent.get("number");
        String sourceField = (String)changeContent.get("sourceField");
        String targetField = (String)changeContent.get("targetField");
        StringBuffer errorMessage = new StringBuffer();
        if (StringUtils.isEmpty((String)number)) {
            errorMessage.append(SHRSysSettingResourceUtil.getResource("struc_config_number_null", ctx, "number"));
        }
        if (StringUtils.isEmpty((String)sourceField)) {
            errorMessage.append(SHRSysSettingResourceUtil.getResource("source_field_not_null", ctx, "sourceField"));
        }
        if (StringUtils.isEmpty((String)targetField)) {
            errorMessage.append(SHRSysSettingResourceUtil.getResource("target_field_not_null", ctx, "targetField"));
        }
        if (!StringUtils.isEmpty((String)errorMessage.toString())) {
            throw new SyssettinException(SyssettinException.CUSTOM_EXCEPTION, new Object[]{errorMessage.toString()});
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("uiview.model", (Object)number, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        DynamicListSettingCollection coll = this.getDynamicListSettingCollection(ctx, view);
        this.dealUpdateByStructureChange(ctx, coll, sourceField, targetField, number);
        String sql = "SELECT fuipk FROM S_BS_UIView where fmodel = '" + number + "'";
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("number", (Object)sql, CompareType.INNER));
        EntityViewInfo view1 = new EntityViewInfo();
        view1.setFilter(filter1);
        FieldRangeCollection coll1 = FieldRangeFactory.getLocalInstance(ctx).getFieldRangeCollection(view1);
        this.dealUpdateByStructureChange(ctx, coll1, sourceField, targetField, number);
    }
}

