/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.DynamicListSettingInfo;
import com.kingdee.shr.base.syssetting.FieldRangeCollection;
import com.kingdee.shr.base.syssetting.FieldRangeInfo;
import com.kingdee.shr.base.syssetting.SyssettinException;
import com.kingdee.shr.base.syssetting.app.AbstractFieldRangeControllerBean;
import com.kingdee.shr.base.syssetting.util.SHRSysSettingResourceUtil;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class FieldRangeControllerBean
extends AbstractFieldRangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.FieldRangeControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        FieldRangeInfo info = (FieldRangeInfo)model;
        this.checkNameDup(ctx, info);
        return super._save(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        FieldRangeInfo info = (FieldRangeInfo)model;
        this.checkNameDup(ctx, info);
        super._update(ctx, pk, model);
    }

    public void checkNameDup(Context ctx, DataBaseInfo dataBaseInfo) throws BOSException, EASBizException {
        FieldRangeInfo info = (FieldRangeInfo)dataBaseInfo;
        FilterInfo filterInfo = new FilterInfo();
        String id = null;
        if (info.getId() != null) {
            id = info.getId().toString();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName()));
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)info.getNumber()));
        if (this.exists(ctx, filterInfo)) {
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{info.getName()});
        }
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        this.clearEnableData(ctx, id);
        this.setState(ctx, id, StateEnum.ENABLE);
    }

    private void clearEnableData(Context ctx, String id) throws BOSException, EASBizException {
        FieldRangeInfo info = this.getFieldRangeInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        String sql = "update T_BD_FieldRange set FState = 2 where FNumber = ?";
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getNumber()});
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        this.setState(ctx, id, StateEnum.DISABLE);
    }

    private void setState(Context ctx, String id, StateEnum state) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        DynamicListSettingInfo info = new DynamicListSettingInfo();
        info.setId(BOSUuid.read((String)id));
        info.setState(state);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        this._updatePartial(ctx, (IObjectValue)info, sic);
    }

    @Override
    protected IObjectPK _copy(Context ctx, String id) throws BOSException, EASBizException {
        FieldRangeInfo info = this.getFieldRangeInfo(ctx, (IObjectPK)new ObjectUuidPK(id));
        info.setId(null);
        info.setName(info.getName() + "_" + SHRSysSettingResourceUtil.getResource("copy", ctx));
        info.setInner(false);
        info.setState(StateEnum.DISABLE);
        info.setCreateTime(null);
        info.setCreator(null);
        return this._save(ctx, (IObjectValue)info);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FieldRangeInfo info = this.getFieldRangeInfo(ctx, pk);
        this.checkCanDelete(info);
        super._delete(ctx, pk);
    }

    private void checkCanDelete(FieldRangeInfo info) throws EASBizException {
        if (StateEnum.ENABLE.equals((Object)info.getState())) {
            throw new SyssettinException(SyssettinException.FORBID_BEFORE_DELETE);
        }
    }

    protected IObjectPK[] _delete(Context ctx, FilterInfo filter) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        FieldRangeCollection collection = this.getFieldRangeCollection(ctx, viewInfo);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            this.checkCanDelete(collection.get(i));
        }
        IObjectPK[] pks = super._delete(ctx, filter);
        return pks;
    }
}

