/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.base.syssetting.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.AuthCQTypeEnum;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.CQAPIConfigCollection;
import com.kingdee.shr.base.syssetting.CQAPIConfigInfo;
import com.kingdee.shr.base.syssetting.InteCQConfigInfo;
import com.kingdee.shr.base.syssetting.InteCQException;
import com.kingdee.shr.base.syssetting.JWTTypeEnum;
import com.kingdee.shr.base.syssetting.StateEnum;
import com.kingdee.shr.base.syssetting.app.AbstractInteCQConfigControllerBean;
import com.kingdee.shr.inte.cq.util.InteCQConfigUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InteCQConfigControllerBean
extends AbstractInteCQConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.base.syssetting.app.InteCQConfigControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkData(ctx, model);
        this.encryptHanlder(model);
        return super._save(ctx, model);
    }

    private void encryptHanlder(IObjectValue model) {
        InteCQConfigInfo info = (InteCQConfigInfo)model;
        info.setAppSecret(InteCQConfigUtil.encrypt(info.getAppSecret()));
        info.setDigestSecret(InteCQConfigUtil.encrypt(info.getDigestSecret()));
        info.setSignSecret(InteCQConfigUtil.encrypt(info.getSignSecret()));
        info.setSignKey(InteCQConfigUtil.encrypt(info.getSignKey()));
        info.setCertKey(InteCQConfigUtil.encrypt(info.getCertKey()));
    }

    private void checkData(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CQAPIConfigCollection coll;
        InteCQConfigInfo info = (InteCQConfigInfo)model;
        this.checkNumberBlank(ctx, info);
        this.checkNumberDup(ctx, info);
        this.checkNameBlank(ctx, info);
        if (null == info.getStatus()) {
            throw new InteCQException(InteCQException.STATUS_ISNULL);
        }
        if (StringUtils.isEmpty((String)info.getUrl())) {
            throw new InteCQException(InteCQException.URL_ISNULL);
        }
        if (!InteCQConfigUtil.isValidURL(info.getUrl())) {
            throw new InteCQException(InteCQException.URL_FORMATTER_ERROR);
        }
        if (StringUtils.isEmpty((String)info.getAppId())) {
            throw new InteCQException(InteCQException.APP_ID_ISNULL);
        }
        if (StringUtils.isEmpty((String)info.getAccountId())) {
            throw new InteCQException(InteCQException.ACCOUNT_ID_ISNULL);
        }
        if (null == info.getInteSystem()) {
            throw new InteCQException(InteCQException.INTESYSTEM_ISNULL);
        }
        if (null == info.getAuthType()) {
            throw new InteCQException(InteCQException.AUTHTYPE_ISNULL);
        }
        if (AuthCQTypeEnum.advance.equals((Object)info.getAuthType()) || AuthCQTypeEnum.jwt.equals((Object)info.getAuthType())) {
            if (StringUtils.isEmpty((String)info.getAgentUser())) {
                throw new InteCQException(InteCQException.AGENT_USER_ISNULL);
            }
            if (StringUtils.isEmpty((String)info.getAppSecret())) {
                throw new InteCQException(InteCQException.APPSECRET_ISNULL);
            }
            if (AuthCQTypeEnum.jwt.equals((Object)info.getAuthType()) && null == info.getJwtType()) {
                info.setJwtType(JWTTypeEnum.SHA256);
            }
        }
        if (AuthCQTypeEnum.digest.equals((Object)info.getAuthType())) {
            if (StringUtils.isEmpty((String)info.getAgentUser())) {
                throw new InteCQException(InteCQException.AGENT_USER_ISNULL);
            }
            if (StringUtils.isEmpty((String)info.getDigestSecret())) {
                throw new InteCQException(InteCQException.DIGEST_SECRET_ISNULL);
            }
            if (StringUtils.isEmpty((String)info.getDigestType())) {
                info.setDigestType("SHA256");
            }
        }
        if (AuthCQTypeEnum.sign.equals((Object)info.getAuthType())) {
            if (StringUtils.isEmpty((String)info.getSignSecret())) {
                throw new InteCQException(InteCQException.SIGN_SECRET_ISNULL);
            }
            if (StringUtils.isEmpty((String)info.getSignKey())) {
                throw new InteCQException(InteCQException.SIGN_KEY_ISNULL);
            }
            if (null == info.getEncryptType()) {
                throw new InteCQException(InteCQException.ENCRYTPTYPE_ISNULL);
            }
            if (StringUtils.isEmpty((String)info.getCertKey())) {
                throw new InteCQException(InteCQException.CERTKEY_ISNULL);
            }
            if (StringUtils.isEmpty((String)info.getSignType())) {
                info.setSignType("SHA256");
            }
            if (StringUtils.isEmpty((String)info.getSignUser())) {
                info.setSignUser(info.getAgentUser());
            }
        }
        if (StringUtils.isEmpty((String)info.getDatacenter())) {
            info.setDatacenter(ctx.getAIS());
        }
        if (null != (coll = info.getEntry()) && !coll.isEmpty()) {
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            HashMap<String, Integer> countMapNumber = new HashMap<String, Integer>();
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                CQAPIConfigInfo entryInfo = coll.get(i);
                this.checkNumberBlank(ctx, entryInfo);
                this.checkNameBlank(ctx, entryInfo);
                if (StringUtils.isEmpty((String)entryInfo.getUrl())) {
                    throw new InteCQException(InteCQException.API_URL_ISNULL);
                }
                if (null == entryInfo.getDomain() || null == entryInfo.getDomain().getId()) {
                    throw new InteCQException(InteCQException.API_DOMAIN_ISNULL);
                }
                int count = 0;
                if (null != countMap.get(entryInfo.getUrl())) {
                    count = (Integer)countMap.get(entryInfo.getUrl());
                }
                countMap.put(entryInfo.getUrl(), count + 1);
                int count1 = 0;
                if (null != countMapNumber.get(entryInfo.getNumber())) {
                    count1 = (Integer)countMapNumber.get(entryInfo.getNumber());
                }
                countMapNumber.put(entryInfo.getNumber(), count1 + 1);
            }
            StringBuilder sb = new StringBuilder();
            boolean isDump = false;
            for (Map.Entry entry : countMap.entrySet()) {
                if ((Integer)entry.getValue() <= 1) continue;
                isDump = true;
                sb.append((String)entry.getKey()).append(",");
            }
            if (isDump) {
                throw new InteCQException(InteCQException.URL_DUMP, new Object[]{sb.toString().substring(0, sb.toString().length() - 1)});
            }
            sb = new StringBuilder();
            isDump = false;
            for (Map.Entry entry : countMapNumber.entrySet()) {
                if ((Integer)entry.getValue() <= 1) continue;
                isDump = true;
                sb.append((String)entry.getKey()).append(",");
            }
            if (isDump) {
                throw new InteCQException(InteCQException.NUMBER_DUMP, new Object[]{sb.toString().substring(0, sb.toString().length() - 1)});
            }
        }
    }

    @Override
    protected void _enable(Context ctx, String billId) throws BOSException, EASBizException {
        InteCQConfigInfo model = this.getInteCQConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        this.doState(ctx, model, StateEnum.Enable);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("inteSystem");
        selector.add("ispreset");
        selector.add("status");
        selector.add("number");
        return selector;
    }

    @Override
    protected void _disable(Context ctx, String billId) throws BOSException, EASBizException {
        InteCQConfigInfo model = this.getInteCQConfigInfo(ctx, (IObjectPK)new ObjectUuidPK(billId), this.getSelector());
        this.doState(ctx, model, StateEnum.Disable);
    }

    private void doState(Context ctx, InteCQConfigInfo model, StateEnum state) throws BOSException, EASBizException {
        if (StateEnum.Enable.equals((Object)state)) {
            if (StateEnum.Enable.equals((Object)model.getStatus())) {
                throw new BaseItemException(BaseItemException.ENABLED_ALREADY, new Object[]{model.getNumber()});
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("inteSystem", (Object)model.getInteSystem(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)StateEnum.Enable, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)model.getId().toString(), CompareType.NOTEQUALS));
            if (this._exists(ctx, filter)) {
                throw new InteCQException(InteCQException.ENABLE_ERROR2);
            }
        }
        if (StateEnum.Disable.equals((Object)state) && StateEnum.Disable.equals((Object)model.getStatus())) {
            throw new BaseItemException(BaseItemException.FORBID_ALREADY, new Object[]{model.getNumber()});
        }
        InteCQConfigInfo updateModel = new InteCQConfigInfo();
        updateModel.setId(model.getId());
        updateModel.setStatus(state);
        updateModel.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        updateModel.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("status");
        selector.add("lastUpdateUser");
        selector.add("lastUpdateTime");
        this.updatePartial(ctx, (CoreBaseInfo)updateModel, selector);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InteCQConfigInfo model = this.getInteCQConfigInfo(ctx, pk, this.getSelector());
        if (model.isIspreset()) {
            throw new InteCQException(InteCQException.PRESET_DATA_NOTDELETE);
        }
        if (StateEnum.Enable.equals((Object)model.getStatus())) {
            throw new InteCQException(InteCQException.ENABLE_DATA_NOTDELETE);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected void _updateDataCenter(Context ctx, String ids) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)ids)) {
            return;
        }
        String[] idsStr = ids.split(",");
        String sql = "update T_SHR_InteCQConfig set FDatacenter = ?, FLastUpdateUserID=?,FLastUpdateTime=now() where FID = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(idsStr.length);
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        for (String id : idsStr) {
            paramsList.add(new Object[]{ctx.getAIS(), userId, id});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramsList);
    }
}

